// Copyright (c) 2021, Compiler Explorer Authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice,
//       this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

import path from 'path';

import { RustCompiler } from './rust';

export class RustcCgGCCCompiler extends RustCompiler {
    static get key() { return 'rustc-cg-gcc'; }

    constructor(info, env) {
        super(info, env);
        this.compiler.supportsIrView = false;
    }

    optionsForFilter(filters, outputFilename, userOptions) {
        // these options are direcly taken from rustc_codegen_gcc doc.
        // See https://github.com/antoyo/rustc_codegen_gcc
        let toolroot = path.resolve(path.dirname(this.compiler.exe), '..');

        let options = ['-C', 'panic=abort',
            '-Z', 'codegen-backend=librustc_codegen_gcc.so',
            '--sysroot', toolroot + '/sysroot' ];

        // rust.js makes the asumption that LLVM is used. This may go away when cranelift is available.
        // Until this is the case and the super() class is refactored, simply ditch -Cllvm arg.
        let super_options = super.optionsForFilter(filters, outputFilename, userOptions).filter(arg => !/-Cllvm.*/.test(arg));
        options = options.concat(super_options);
        return options;
    }
}
