# commonFunctions
The commonFunctions folder contains the collection of all the common functions which are run from the various main scripts. In order to access these scripts, the following lines are added in each main.m file:

```matlab
commonFunctionsPath = '../../commonFunctions/';
addpath(genpath(commonFunctionsPath));
```

## Folders
### angleTransformation
This folder contains all the functions needed to compute angles, quaternions and direction cosine matrix. These scripts are taken from related MATLAB functions and optimized to achieve a faster computation.
### Datcom
This folder contains all the functions needed to compile DATCOM input files and parse the output file.
### eventFunctions
This folder contains all the event functions needed to stop integration.
### miscellaneous
As the folder name says, miscellanes scripts are stored here. Take a look at the script headers for further details.
### odeFunctions
This folder contains all the common ODE functions.
### roccarasoTerrainData
This folder contains the functions to retrieve the heightmap of Roccaraso (AQ).
### simulations
This folder contains different types of simulations needed.
### windModels
This folder contains the functions needed to generate different types of wind models.
