function [value, isterminal, direction] = eventLanding(~, Y, varargin)
%{
eventLanding - Event function to stop simulation at landing checking when a
               value tends to zero; the value taken is to account is the 
               vertical position, z = 0 --> landing.

INPUTS:     
        - t, double [n° variations, 1], integration time, [s];
        - Y, double [n° variations, 13], state matrix,
                            [ x y z | u v w | p q r | q0 q1 q2 q3]:
                            * (x y z), NED{north, east, down} horizontal frame;
                            * (u v w), body frame velocities;
                            * (p q r), body frame angular rates;
                            * (q0 q1 q2 q3), attitude unit quaternion.
        - settings, struct, rocket and simulation data.

OUTPUTS:        
        - value, selected value to check if the integration has to be stopped (vertical velocity);
        - isterminal, logical input to stop the integration;
        - direction, to select the sign that the function must have when tends to zero, 1 = positive.

CALLED FUNCTIONS: -

REVISION:
- #0    25/04/2014, Release, Ruben Di Battista

- #1    19/05/2018, Revision, Adriano Filippo Inno
Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}

% x = Y(1);
% y = Y(2);
altitude = -Y(3);

% if settings.terrain
%     zloc = -settings.funZ(x,y);
%     if zloc > 853
%         zloc = 853;
%     end
% 
%     if zloc < -656
%         zloc = -656;
%     end
% 
%     value = z - zloc;
% else
    value = altitude;
% end


isterminal = 1;
direction = 0;


end

