function [value, isterminal, direction] = eventParaCut(~, Y, rocket, ~, ~, settings, descentData, ~)
%{ 
stdDescent(ascent, rocket, environment, wind, parachute, newSettings)
eventParaCut - Event function to stop simulation at the chosen altitude to cut the 
                 parachute, checking when a value tends to zero;
                 the value taken is to account is the vertical position respect to the chosen altitude,
                 z - zcut = 0 --> parachute cut

INPUTS:     
            - t, array, [n� variations, 1], integration time;
            - Y, array, [n� variations, 13], state vector;
                    State vector: [ x y z | u v w | p q r | q0 q1 q2 q3]:

                                * (x y z), NED{north, east, down} horizontal frame; 
                                * (u v w), body frame velocities;
                                * (p q r), body frame angular rates;
                                * (q0 q1 q2 q3), attitude unit quaternion;

            - settings, struct, stores data of the rocket and of the simulation.

OUTPUTS:        
            - isterminal, logical array [1, 1], logical input to stop the integration;
            - direction, logical array [1, 1], to select the sign that the function must have when tends to zero, 1 = positive;
            - value, logical array [1, 1], selected value to check if the integration has to be stopped (vertical position).

REVISIONS:
- #0 25/04/2014, Release, Ruben Di Battista
- #1 09/10/2019, Revision, Adriano Filippo Inno
Copyright © 2022, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}

% x = Y(1);
% y = Y(2);
altitude = -Y(3);

if ~isfield(settings.simulator,'stochNumber')
    para = descentData.para;
else
    para = settings.stoch.para;
end
stage = descentData.stage;

value = altitude - rocket.parachutes(para, stage).finalAltitude;

isterminal = 1;
direction = 0;
end

