function [xBoat, yBoat] = computeTangentBoatPoints(dRocket, dAft, lAft)
%{
computeTangentBoatPoints - function used to plot tangent ogive boat tail

INPUTS:
         - dRocket, double, rocket diameter
         - dAft, double, boat tail ending diameter
         - lAft, double boat tail length

OUTPUTS:
         - xBoat, double [1, nPoints], boat tail plot x-coordinates
         - yBoat, double [1, nPoints], boat tail plot y-coordinates

CALLED FUNCTIONS: /

VERSIONS:   #0, release, Matteo Gotti, Maria Teresa Cazzola
%}
rRocket = dRocket/2;
eqRadius = abs(dAft/2 - rRocket);
rho = (lAft^2 + eqRadius^2) / (2*eqRadius);

nPoints = 20;
xBoat = lAft * linspace(0, 1, nPoints);
yBoat = sqrt(rho^2 - xBoat.^2) - (rho - rRocket); 
end