function state = gaplotshape(settings, ~, state, flag)
%{
GAPLOTSHAPE - Genethic algorithm plot function to visualize current best
rocket shape.

INPUTS:
- settings, struct, simulation parameters;
- state, struct, current generation data struct;
- flag, char, current generation specification.

OUTPUTS:
- state, struct, current generation data struct;

CALLED FUNCTIONS: /

REVISIONS:
- 0     21/10/20,   release     Davide Rosato

Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}


switch flag
    case 'init'
        hold on
        %%% NOSECONE
        r = settings.C/2*1000;
        Lnos = state.Population(1, 5)*10;
        xNos = Lnos - Lnos*cos(linspace(0, pi/2, 50));
        if settings.modHaack
            p = state.Population(1, 6);
            c = state.Population(1, 7);
            xMod = @(x, p) (x/Lnos).^(p)*Lnos;
            thetaMod = @(x, p) acos( 1 - ( (2*xMod(x, p))./Lnos ) );
            haackSeriesMod = @(x, p, C) ( r/sqrt(pi) ) * sqrt( thetaMod(x, p) - ( sin(2*thetaMod(x, p))./ 2 ) + C*sin(thetaMod(x, p)).^3 );
            yNos = haackSeriesMod(xNos, p, c);
        else
            if settings.boatOptimization
                ogType = state.Population(1, 7);
            else
                ogType = state.Population(1, 6);
            end
            if ogType == 1
                theta = @(x) acos( 1 - ( (2*x)./Lnos ) );
                Karman = @(x) ( r/sqrt(pi) ) * sqrt( theta(x) - ( sin(2*theta(x))./ 2 ) );
                yNos = Karman(xNos);
            elseif ogType == 2
                theta = @(x) acos( 1 - ( (2*x)./Lnos ) );
                Haack = @(x) ( r/sqrt(pi) ) * sqrt( theta(x) - ( sin(2*theta(x))./ 2 ) + (1/3)*sin(theta(x)).^3 );
                yNos = Haack(xNos);
            elseif ogType == 3
                rho = (r^2 + Lnos^2)/(2*r);
                Ogive = @(x) sqrt(rho^2 - (Lnos - x).^2) + r - rho;
                yNos = Ogive(xNos);
            elseif ogType == 4
                Power1_3 = @(x) r * (x/Lnos).^(1/3);
                yNos = Power1_3(xNos);
            elseif ogType == 5
                Power1_2 = @(x) r * (x/Lnos).^(1/2);
                yNos = Power1_2(xNos);
            elseif ogType == 6
                Power3_4 = @(x) r * (x/Lnos).^(3/4);
                yNos = Power3_4(xNos);
            end
        end
        plotNos = plot(xNos, yNos, 'k');
        set(plotNos,'Tag','gaplotNos');
        plotNos = plot(xNos, -yNos, 'k');
        set(plotNos,'Tag','gaplotNosNeg');
        plotNosEnd = plot([Lnos Lnos], [-r r], 'k');
        set(plotNosEnd,'Tag','gaplotNosEnd');
        %%% CENTERBODY
        if settings.boatOptimization
            if settings.modHaack
                Laft = state.Population(1, 8);
                Lcent = settings.Lcenter*1000 + settings.boatL*1000 - Laft;
            else
                Laft = state.Population(1, 6);
                Lcent = settings.Lcenter*1000 + settings.boatL*1000 - Laft;
            end
        else
            Lcent = settings.Lcenter*1000;
        end
        plotCent = plot([Lnos Lnos+Lcent], [r r], 'k');
        set(plotCent,'Tag','gaplotCent');
        plotCent = plot([Lnos Lnos+Lcent], [-r -r], 'k');
        set(plotCent,'Tag','gaplotCentNeg');
        plotCentEnd = plot([Lnos+Lcent Lnos+Lcent], [-r r], 'k');
        set(plotCentEnd,'Tag','gaplotCentEnd');
        %%% BOAT-TAIL
        Daft = settings.optimBoatD*1000;
        if settings.boatOptimization
            if settings.modHaack
                Laft = state.Population(1, 8);
            else
                Laft = state.Population(1, 6);
            end
        else
            Laft = settings.boatL*1000;
        end
        
        if settings.boatType == 1
           [xBoat, yBoat] = computeTangentBoatPoints(2*r, Daft, Laft);
        else
            xBoat = [0 Laft];
            yBoat = [r Daft/2];
        end

        plotBoat = plot(xBoat+Lnos+Lcent, yBoat, 'k');
        set(plotBoat,'Tag','gaplotBoat');
        plotBoatNeg = plot(xBoat+Lnos+Lcent, -yBoat, 'k');
        set(plotBoatNeg,'Tag','gaplotBoatNeg');
        plotBoatEnd = plot([Lnos+Lcent+Laft Lnos+Lcent+Laft], [-Daft/2 Daft/2], 'k');
        set(plotBoatEnd,'Tag','gaplotBoatEnd');
        %%FINS
        C1 = state.Population(1,1)*10;
        C2 = state.Population(1,2)*10;
        deltaXLE = state.Population(1,4)*10;
        H = state.Population(1,3)*10;
        Xle1 = Lcent + Lnos - settings.d*1000 - C1;
        plotFin1 = plot([Xle1 Xle1+deltaXLE], [r r+H],'k');
        set(plotFin1,'Tag','gaplotFin1');
        plotFin2 = plot([Xle1+C1 Xle1+deltaXLE+C2], [r r+H],'k');
        set(plotFin2,'Tag','gaplotFin2');
        plotFin3 = plot([Xle1+deltaXLE Xle1+deltaXLE+C2], [r+H r+H],'k');
        set(plotFin3,'Tag','gaplotFin3');
        plotFin1n = plot([Xle1 Xle1+deltaXLE], [-r -r-H],'k');
        set(plotFin1n,'Tag','gaplotFin1n');
        plotFin2n = plot([Xle1+C1 Xle1+deltaXLE+C2], [-r -r-H],'k');
        set(plotFin2n,'Tag','gaplotFin2n');
        plotFin3n = plot([Xle1+deltaXLE Xle1+deltaXLE+C2], [-r-H, -r-H],'k');
        set(plotFin3n,'Tag','gaplotFin3n');
        set(gca, 'xlim', [-100, Lnos+Lcent+Laft+100]);
        axis equal
        xlabel('x [mm]'); ylabel('y [mm]'); title('Current Best Shape')

    case 'iter'
        [~,i] = min(state.Score);
        %%% NOSECONE
        r = settings.C/2*1000;
        Lnos = state.Population(i, 5)*10;
        xNos = Lnos - Lnos*cos(linspace(0, pi/2, 50));
        if settings.modHaack
            p = state.Population(i, 6);
            c = state.Population(i, 7);
            xMod = @(x, p) (x/Lnos).^(p)*Lnos;
            thetaMod = @(x, p) acos( 1 - ( (2*xMod(x, p))./Lnos ) );
            haackSeriesMod = @(x, p, C) ( r/sqrt(pi) ) * sqrt( thetaMod(x, p) - ( sin(2*thetaMod(x, p))./ 2 ) + C*sin(thetaMod(x, p)).^3 );
            yNos = haackSeriesMod(xNos, p, c);
        else
            if settings.boatOptimization
                ogType = state.Population(1, 7);
            else
                ogType = state.Population(1, 6);
            end
            if ogType == 1
                theta = @(x) acos( 1 - ( (2*x)./Lnos ) );
                Karman = @(x) ( r/sqrt(pi) ) * sqrt( theta(x) - ( sin(2*theta(x))./ 2 ) );
                yNos = Karman(xNos);
            elseif ogType == 2
                theta = @(x) acos( 1 - ( (2*x)./Lnos ) );
                Haack = @(x) ( r/sqrt(pi) ) * sqrt( theta(x) - ( sin(2*theta(x))./ 2 ) + (1/3)*sin(theta(x)).^3 );
                yNos = Haack(xNos);
            elseif ogType == 3
                rho = (r^2 + Lnos^2)/(2*r);
                Ogive = @(x) sqrt(rho^2 - (Lnos - x).^2) + r - rho;
                yNos = Ogive(xNos);
            elseif ogType == 4
                Power1_3 = @(x) r * (x/Lnos).^(1/3);
                yNos = Power1_3(xNos);
            elseif ogType == 5
                Power1_2 = @(x) r * (x/Lnos).^(1/2);
                yNos = Power1_2(xNos);
            elseif ogType == 6
                Power3_4 = @(x) r * (x/Lnos).^(3/4);
                yNos = Power3_4(xNos);
            end
        end
        h = findobj(get(gca,'Children'),'Tag','gaplotNos');
        set(h,'Xdata',xNos);
        set(h,'Ydata',yNos);
        h = findobj(get(gca,'Children'),'Tag','gaplotNosNeg');
        set(h,'Xdata',xNos);
        set(h,'Ydata',-yNos);
        h = findobj(get(gca,'Children'),'Tag','gaplotNosEnd');
        set(h,'Xdata',[Lnos Lnos]);
        %%% CENTERBODY
        if settings.boatOptimization
            if settings.modHaack
                Laft = state.Population(i, 8);
                Lcent = settings.Lcenter*1000 + settings.boatL*1000 - Laft;
            else
                Laft = state.Population(i, 6);
                Lcent = settings.Lcenter*1000 + settings.boatL*1000 - Laft;
            end
        else
            Lcent = settings.Lcenter*1000;
        end
        h = findobj(get(gca,'Children'),'Tag','gaplotCent');
        set(h,'Xdata',[Lnos Lnos+Lcent]);
        h = findobj(get(gca,'Children'),'Tag','gaplotCentNeg');
        set(h,'Xdata',[Lnos Lnos+Lcent]);
        h = findobj(get(gca,'Children'),'Tag','gaplotCentEnd');
        set(h,'Xdata',[Lnos+Lcent Lnos+Lcent]);
        %%% BOAT-TAIL
        Daft = settings.optimBoatD*1000;
        if settings.boatOptimization
            if settings.modHaack
                Laft = state.Population(i, 8);
            else
                Laft = state.Population(i, 6);
            end
        else
            Laft = settings.boatL*1000;
        end
        if settings.boatType == 1
           [xBoat, yBoat] = computeTangentBoatPoints(2*r, Daft, Laft);
        else
            xBoat = [0 Laft];
            yBoat = [r Daft/2];
        end

        h = findobj(get(gca,'Children'),'Tag','gaplotBoat');
        set(h,'Xdata', xBoat+Lnos+Lcent);
        set(h, 'Ydata', yBoat)
        h = findobj(get(gca,'Children'),'Tag','gaplotBoatNeg');
        set(h,'Xdata', xBoat+Lnos+Lcent);
        set(h, 'Ydata', -yBoat)
        h = findobj(get(gca,'Children'),'Tag','gaplotBoatEnd');
        set(h,'Xdata',[Lnos+Lcent+Laft Lnos+Lcent+Laft]);
        
        %%FINS
        C1 = state.Population(i,1)*10;
        C2 = state.Population(i,2)*10;
        deltaXLE = state.Population(i,4)*10;
        H = state.Population(i,3)*10;
        Xle1 = Lcent + Lnos - settings.d*1000 - C1;
        h = findobj(get(gca,'Children'),'Tag','gaplotFin1');
        set(h,'Xdata',[Xle1 Xle1+deltaXLE]);
        set(h,'Ydata',[r r+H]);
        h = findobj(get(gca,'Children'),'Tag','gaplotFin2');
        set(h,'Xdata',[Xle1+C1 Xle1+deltaXLE+C2]);
        set(h,'Ydata',[r r+H]);
        h = findobj(get(gca,'Children'),'Tag','gaplotFin3');
        set(h,'Xdata',[Xle1+deltaXLE Xle1+deltaXLE+C2]);
        set(h,'Ydata',[r+H r+H]);
        h = findobj(get(gca,'Children'),'Tag','gaplotFin1n');
        set(h,'Xdata',[Xle1 Xle1+deltaXLE]);
        set(h,'Ydata',[-r -r-H]);
        h = findobj(get(gca,'Children'),'Tag','gaplotFin2n');
        set(h,'Xdata',[Xle1+C1 Xle1+deltaXLE+C2]);
        set(h,'Ydata',[-r -r-H]);
        h = findobj(get(gca,'Children'),'Tag','gaplotFin3n');
        set(h,'Xdata',[Xle1+deltaXLE Xle1+deltaXLE+C2]);
        set(h,'Ydata',[-r-H, -r-H]);
        
        set(gca, 'xlim', [-100, Lnos+Lcent+Laft+100]);
        
end

