function [alphaTot, phi] = getAlphaPhi(alpha, beta)
%{
getAlphaPhi - convert alpha and beta aerodynamics angles in
              alpha total and phi

INPUTS:
- alpha,        double [1, n], attack angle [rad].
- beta,         double [1, n], sideslip angle [rad].

OUTPUTS:
- alphaTot,     double [1, n], total attack angle [rad]
- phi,          double [1, n], aerodynamic roll angle [rad] 

CALLED FUNCTIONS: /

REVISIONS:
- 0     03/12/22    release,     Riccardo Cadamuro, Maria Teresa Cazzola   

Copyright © 2022, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}

    if not(length(alpha) == length(beta))
        error('alpha and beta need to have the same length'); 
    end
    
    u = ones(1, length(alpha)); 
    w = tan(alpha); 
    v = tan(beta); 
    
    alphaTot = acos(u./vecnorm([u; v; w]));
    phi = atan2(v,w);

end