function settings = settingsEngineCut(settings)
%{
    settingsEngineCut - This function computes specifc parameters at engine
                        cut event
    
    INPUTS:
            - settings, struct
    
    OUTPUTS:
            - settings, struct, contains modified settings data to consider
                                engine cutoff
    
    CALLED FUNCTIONS: -
    
    REVISIONS:
    - 0    19/10/2022, Release, Riccardo Cadamuro, Maria Teresa Cazzola
    - 1    25/02/2022, Update,  Riccardo Cadamuro
                                cut-off transient added

    Copyright © 2022, Skyward Experimental Rocketry, AFD department
    All rights reserved
    
    SPDX-License-Identifier: GPL-3.0-or-later
%}
    
    
    if (settings.timeEngineCut) > 0 && ( settings.timeEngineCut <= (settings.tb - settings.tCO) )
        
        tEC = settings.timeEngineCut;           % controlled shutoff moment 
        tCO = settings.tCO;                     % cutoff transient duration

        indexTransient = settings.motor.expTime >= settings.timeEngineCut;
        settings.motor.expThrust(indexTransient) = settings.motor.expThrust(indexTransient) .* (1 - (settings.motor.expTime(indexTransient) - tEC)/tCO );

        indexThrustNull = or(settings.motor.expTime > tEC + tCO, settings.motor.expThrust < 0);
        settings.motor.expThrust(indexThrustNull) = 0; 
        
        settings.timeEngineCut = settings.timeEngineCut + settings.tCO; 

        settings.expMengineCut = interpLinear(settings.motor.expTime, settings.motor.expM, settings.timeEngineCut);
        settings.IengineCut = interpLinear(settings.motor.expTime, settings.I, settings.timeEngineCut);    
    
    elseif settings.timeEngineCut >= (settings.tb - settings.tCO)
    
        settings.timeEngineCut = inf;
    
    elseif settings.timeEngineCut <= 0
        error('settings.timeEngineCut must be grater than zero');
    end
end