function out = trimPath(path)
% trimPath - This function recursively contracts paths that use ".."
%   e.g: C:\User\..\randomFolder -> C:\randomFolder
% 
% INPUTS:
%         - path, string, path to be trimmed
% 
% OUTPUTS:
%         - trimmed path, string

trimmed = false;
out = fullfile(path); % Trims multiple separators characters
exp = ['\', filesep, '[^\', filesep,']+\', filesep,'\.\.'];

while ~trimmed
    out = regexprep(out, exp, '', 'once');
    trimmed = ~logical(regexp(out, exp, 'once'));
end

if contains(out, '..')
    error('Failed to trim string. Check validity of path')
end
end

