function data_ascent = stochAscentLoop(settings, Y0a)
%{
stochAscentLoop - This function runs the ascent inside the parfor loop

INPUTS:     
            - settings,   struct: stores data of the rocket and of the simulation.
            - Y0a, double [13,1]: initial conditions 

OUTPUTS:
            - data_ascent,struct: containins fligth data of the ascent phase;

CALLED FUNCTIONS: 

REVISIONS:
- 0     17/03/2023, Release,  Simone Cimolato
- 1     04/03/2023, update,   Riccardo Cadamuro
                    all data saved in settings except for the initial
                    conditions

Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later
%}

    tf = settings.ode.finalTime;

    if settings.multipleAB
        settings.control = [1, settings.control];
        nAB = length(settings.control);
        t0 = 0;
        Ta = [];
        Ya = [];
        data_ascentAB = cell(1, nAB);
        
        settings.delayControl = delayControl(settings.control, settings);

        for iAB = 1:nAB
            [Tab, Yab] = ode113(@ascentMultipleAB, [t0, tf], Y0a, settings.ode.optionsascMultipleAB, t0, iAB, settings); 
            [data_ascentAB{iAB}] = recallOdeFcn(@ascentMultipleAB, Tab, Yab, t0, iAB, settings);

            % update variables and the state
            t0 = Tab(end);
            Y0a = Yab(end, :);
            Ta = [Ta; Tab];
            Ya = [Ya; Yab];
        end

        if settings.para(1).delay ~= 0 % checking if the actuation delay is different from zero
            [Ta2, Ya2] = ode113(@ascentMultipleAB, [Ta(end), Ta(end) + settings.para(1).delay],... 
                Ya(end,:), settings.ode.optionsasc2, 0, nAB, settings); % till end of the delay

            Ta = [Ta; Ta2(1:end)];
            Ya = [Ya; Ya2(1:end, :)];

            [data_ascentAB{nAB+1}] = recallOdeFcn(@ascentMultipleAB, Ta2, Ya2, 0, nAB, settings);
        end

        data_ascent = chainStruct(data_ascentAB);

    else
        settings.control = settings.control(1);
        [Ta, Ya] = ode113(@ascent, [0, tf], Y0a, settings.ode.optionsasc1, settings);

        if settings.para(1).delay ~= 0 % checking if the actuation delay is different from zero
            [Ta2,Ya2] = ode113(@ascent, [Ta(end), Ta(end) + settings.para(1).delay], Ya(end, :),...
                settings.ode.optionsasc2, settings);
            Ta = [Ta; Ta2(2:end   )];
            Ya = [Ya; Ya2(2:end, :)];
        end

        data_ascent = recallOdeFcn(@ascent, Ta, Ya, settings);
    end

    data_ascent.state.Y = Ya;
    data_ascent.state.T = Ta;

end