function data_bal = stochDescentBalLoop(settings, data_ascent)
%{
stochDescentBalLoop - This function runs the ballistic descent inside the parfor loop

INPUTS:     
            - settings,    struct: stores data of the rocket and of the simulation.
            - data_ascent, struct: ascent simulations data to compute the ballistic
                                   descent initial conditions

OUTPUTS:
            - data_bal,    struct: containins fligth data of the ballistic descent phase;

CALLED FUNCTIONS: 

REVISIONS:
- 0     17/03/2023, Release,  Simone Cimolato
- 1     04/03/2023, update,   Riccardo Cadamuro
                    all data saved in settings except for the initial
                    conditions stored in data_ascent

Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later
%}
    
    tf = settings.ode.finalTime;
    settings.mEndAscent = data_ascent.interp.mass(end);
    settings.IxxEndAscent = data_ascent.interp.inertias(1, end);
    settings.IyyEndAscent = data_ascent.interp.inertias(2, end);
    settings.IzzEndAscent = data_ascent.interp.inertias(3, end);

    [Tb, Yb] = ode113(@descentBal, [data_ascent.state.T(end), tf], data_ascent.state.Y(end, 1:13), settings.ode.optionsdesc, settings);
    [data_bal] = recallOdeFcn(@descentBal, Tb, Yb, settings);
    data_bal.state.Y = Yb;
    data_bal.state.T = Tb;
end