function [solution, ascent] = stdAscent(rocket, env, wind, settings, wrapper)
arguments
    rocket      Rocket
    env         Environment
    wind        WindCustom {mustBeA(wind, {'WindCustom', 'WindMatlab'})}
    settings    Settings
    wrapper     DataWrapper
end
% stdAscent - This function runs a nominal ascent
% 
% INPUTS:
% - rocket, environment, wind, settings
% 
% OUTPUTS:
% - solution,       raw solution
% - ascent,         post processed solution
% NOTE: if the simultation calculates the apogee only post processed
% solution is used. Otherwise, for complete simulations (with descent) raw
% solution is required.
% 
%
% CALLED FUNCTIONS: windConstGenerator, ascent, recallOdeFcn, descentParachute, descentParachute6Dof, delayControl.
%
% REVISIONS:
% - 0                 Release, Ruben Di Battista
% - 1                 Revision, Francesco Colombi
% - 2     09/10/2019, Revision, Adriano Filippo Inno
% - 3     16/04/2021, Update,   Fiammetta Artioli, Davide Rosato
%                     6DOF descent update
% - 4     03/10/2021, Update,   Davide Rosato
%                     Multiple smooth airbrakes opening update
% Copyright © 2022, Skyward Experimental Rocketry, AFD department
% All rights reserved
%
% SPDX-License-Identifier: GPL-3.0-or-later

%% DATA PREPARATION
options = odeset(settings.ode.optAscent, 'OutputFcn', @storeData);
tf = settings.ode.finalTime;

%% INITIAL CONDITIONS
%%% Attitude
Q0 = angleToQuat(env.phi, env.omega, 180*pi/180)';

%%% State
X0 = [0; 0; 0];
V0 = [0; 0; 0];
W0 = [0; 0; 0];

Y0 = [X0; V0; W0; Q0; 0];

%% ASCENT
t0 = 0;
solution = ode113(@ballistic, [t0, tf], Y0, options, ...
    rocket, env, wind, [], 0, wrapper);

if settings.simulator.parachute && rocket.parachutes(1, 1).openingTime
    solution = odextend(solution, [], solution.x(end) + rocket.parachutes(1, 1).openingTime);
end

if nargout == 2
    ascent = getOdeFcn(solution);
end
% if not(isfield(simulator, 'unitTest')) || simulator.unitTest == false
%     save('ascent_plot.mat', 'ascent');
% end
end