function stability = stdStability(rocket, env, wind, settings, wrapper)
arguments
    rocket      Rocket
    env         Environment
    wind        WindCustom {mustBeA(wind, {'WindCustom', 'WindMatlab'})}
    settings    Settings
    wrapper     DataWrapper
end
% stochStabilityLoop - This function runs a simulation to compute the rocket
%                      stability inside the parfor loop
%
% INPUTS:
%             - settings,     struct: stores data of the rocket and of the simulation.
%             - Y0,   double [13, 1]: initial state vector of the integration
%                                     [x, y, z, u, v, w, p, q, r, q0, q1, q2, q3]
%
% OUTPUTS:
%             - data_stability,cell [1, k]: cell containg the struct with the rocket
%                                           stability data at the launchpad exit
%
% CALLED FUNCTIONS:
%
% REVISIONS:
% - 0     14/06/2023, Release,    Riccardo Cadamuro
%
% Copyright © 2023, Skyward Experimental Rocketry, AFD department
% All rights reserved
%
% SPDX-License-Identifier: GPL-3.0-or-later

%% DATA PREPARATION
options = odeset(settings.ode.optLaunchpad, 'OutputFcn', @storeData);
tf = settings.ode.finalTime;

%% INITIAL CONDITIONS
%%% Attitude
Q0 = angleToQuat(env.phi, env.omega, 180*pi/180)';

%%% State
X0 = [0; 0; 0];
V0 = [0; 0; 0];
W0 = [0; 0; 0];

Y0 = [X0; V0; W0; Q0; 0];

%% LAUNCHPAD
t0 = 0;
solution = ode113(@ballistic, [t0, tf], Y0, options, ...
    rocket, env, wind, [], 0, wrapper);

stability = getOdeFcn(solution);
end