function [value, isterminal, direction] = eventPad(~, Y, ~, environment, varargin)
% eventPad - Event function to stop simulation at the launchpad exit
% 
% INPUTS:
% - t,        double [1, 1], integration time  [s];
% - Y,        double [4, 1], integration state, check launchPadFreeDyn for explanation; 
% - settings, struct (motor, CoeffsE, CoeffsF, para, ode, stoch, prob, wind), 
%                    simulation data;
% - varargin, cell {3, 1}, for additional inputs of the ode function, un-necessary here.
% 
% OUTPUTS:
% - value,        double [1, 1], see eventFunction explantion in matlab website
% - isterminal,   double [1, 1], see eventFunction explantion in matlab website
% - direction,    double [1, 1], see eventFunction explantion in matlab website
% 
% CALLED FUNCTIONS: /
% 
% REVISIONS:
% - 0     21/10/20,   release     Adriano Filippo Inno
% Copyright © 2021, Skyward Experimental Rocketry, AFD department
% All rights reserved
% 
% SPDX-License-Identifier: GPL-3.0-or-later

altitude = -Y(3);
value = altitude - environment.effectiveRampAltitude;

isterminal = 1;
direction = 1;
end

