function chainedStruct = chainStruct(varargin)
%{
mergeStruct - This function allows to merge two or more structs with the
              same fields. Structs must be in the order you want to
              concatenate them

INPUTS:
        - varargin, cell array [1 x nStruct], structs to be concatenated.

OUTPUTS:
        - chainedStruct, struct, which contains all the value concatenated.

CALLED FUNCTIONS: -

REVISIONS:
- 0    02/10/2021, Release, Davide Rosato
Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}

%% PRE-ALLOCATION
nS = size(varargin{1}, 2);
allStruct = cell(nS, 1);

if nS < 2
    error('At least two structs must be input');
end

% Create a bigger struct containing the input structs
for iA = 1 : nS
    allStruct{iA} = varargin{1}{iA};
end

%%
chainedStruct = struct;
chainedStruct = merging(allStruct, nS, chainedStruct);

    function mergedStruct = merging(structures, n, mergedStruct)
        % Get fieldnames from structs
        fieldNames = cell(1, n);
        nField = zeros(1, n);
        for iB = 1 : n
            fieldNames{iB} = fieldnames(structures{iB});
            % Get number of fields
            nField(iB) = size(fieldNames{iB}, 1);
        end
       
        %%% ERROR CHECKING
        % Control that there is the same number of fields
        if length(unique(nField)) ~= 1
            error('Structs contain different numbers of fields. Merge result impossible')
        end
        nField = nField(1);
        % Control that there are the same fieldnames
        for iB = 1 : nField
            str = '';
            for iC = 1 : n
                if iC == n
                    str = strcat(str, 'fieldNames{', num2str(iC),'}{', num2str(iB), '}');
                else
                    str = strcat(str, 'fieldNames{', num2str(iC),'}{', num2str(iB), '},');
                end
            end
            isEqual = eval(strcat('isequal(',str,')'));
        end
        
        if not(isEqual)
            error('Structs contain different field names. Merge result impossible')
        end
        
        %%% MERGING
        for iB = 1 : nField
            if isstruct(structures{1}.(fieldNames{1}{iB})) % if the field is a structure
                struc = cell(1, n);
                for iC = 1 : n
                    struc{iC} = structures{iC}.(fieldNames{1}{iB});
                end
                mergedStruct.(fieldNames{1}{iB}) = struct;
                mergedStruct.(fieldNames{1}{iB}) = merging(struc, n, mergedStruct.(fieldNames{1}{iB}));

            else % if the field is a vector
                
                % Dimension to concatenate
                dim = length(size(structures{iC}.(fieldNames{1}{iB})));
                
                % Concatenate
                str = '';
                for iC = 1 : n
                    if iC == n
                        str = strcat(str, 'structures{', num2str(iC), '}.(fieldNames{1}{', num2str(iB), '})');
                    else
                        str = strcat(str, 'structures{', num2str(iC), '}.(fieldNames{1}{', num2str(iB), '}),');
                    end
                end
                
                concVec = eval(strcat('cat(', num2str(dim),',',str, ')'));
                mergedStruct.(fieldNames{1}{iB}) = concVec;
                
            end
        end
        
        
    end

end



