function delay = delayControl(pControl, settings)
%{ 

delayCOntrol - This function calculates the delay to change airbrakes
               configuration, basing on servo motor angular velocity.

INTPUTS: 
            - pControl, double [1 x n° configurations changes], airbrakes configurations;
            - settings, struct, rocket and simulation data.

OUTPUTS:
            - delay, double [1 x n° configurations changes], delay time vector.

CALLED FUNCTIONS: -

REVISIONS:
- 0     03/10/2021, Release,   Davide Rosato
Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}

A = -9.43386/(3*1000);
B = 19.86779/(3*1000);
alpha = @(S) (-B + sqrt(B^2 + 4*A*S))/(2*A);

controlSurf = settings.hprot(pControl) * settings.wprot;

servoAngle = alpha(controlSurf);

Np = length(pControl);
delay = zeros(1, Np-1);

for i = 2:Np
    delay(i-1) = abs(servoAngle(i) - servoAngle(i-1))/settings.vServo;
end


end