function velExit = exitVelocity(settings)

%{  
exitVelocity - This function calculates the launchpad exit velocity.

INPUT: 
- settings,     struct, (motor, CoeffsE, CoeffsF, para, ode, stoch, prob, wind),
                         simulation data.

OUTPUT: 
- velExit,      double [1, 1], exit launchpad velocity

REVISIONS:
- 0,    20/11/2021,    release    Jacopo Carradori

- 1,    17/08/2022,    update     Riccardo Cadamuro
                       runnable with HRE   

Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}


% Initial State
X0pad = [0; 0; 0; 0];
% Attitude
Q0 = angleToQuat(settings.PHI, settings.OMEGA, 0*pi/180)';


    nAlpha = size(settings.Coeffs, 2);
    nBeta = size(settings.Coeffs, 4);
    meanCA = settings.Coeffs(1, ceil(nAlpha/2), 1, ceil(nBeta/2), 1, 1, 1);   % CA at alpha = 0 | beta = 0 | Mach = 0.05 | ARB = closed | Xcg = full     

[~, Ypad] = ode113(@launchPadFreeDyn, [0, 10], X0pad, settings.ode.optionspad,...
    settings, Q0, meanCA);

velExit = Ypad(end, 4);
                