function [alpha, beta] = getAlphaBeta(alphaTot, phi)
%{
getAlphaBeta - convert alpha total and phi aerodynamics angles in
               alpha and beta

INPUT:
- alphaTot,     double [1, n], total attack angle [rad]
- phi,          double [1, n], aerodynamic roll angle [rad] 

OUTPUT:
- alpha,        double [1, n], attack angle [rad].
- beta,         double [1, n], sideslip angle [rad].


CALLED FUNCTIONS: /

REVISIONS:
- 0     10/12/22    release,     Riccardo Cadamuro, Maria Teresa Cazzola   

Copyright © 2022, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}

    if not(length(alphaTot) == length(phi))
        error('alpha and beta need to have the same length'); 
    end
    
    alpha = atan( tan(alphaTot) .* cos(phi)); 
    beta = atan( tan(alphaTot) .* sin(phi)); 
end