function out = getOdeFcn(solution, startIdx)
arguments
    solution    (1, :)  struct
    startIdx    (1, 1)  double  = 1
end
% recallOdeFcn - This function allows to compute some parameters used
%                inside the ODE integrations.
%
% INPUTS:
%         - fun, function, ode function used;
%         - T, double [n° variation, 1], integration time vector;
%         - Y, double [n° variation, 16], state matrix,
%                             [ x y z | u v w | p q r | q0 q1 q2 q3 | m | Ixx Iyy Izz ]:
%                             * (x y z), NED{north, east, down} horizontal frame;
%                             * (u v w), body frame velocities;
%                             * (p q r), body frame angular rates;
%                             * m , total mass;
%                             * (Ixx Iyy Izz), Inertias;
%                             * (q0 q1 q2 q3), attitude unit quaternion.
%
% OUTPUTS:
%         - allSteps, struct, which contains all the parameters needed.


args = solution.extdata.varargin;
fun = solution.extdata.odefun;

wrapper = args{end};
data = wrapper.getData(startIdx);

%% Fixing points at t = 0, t = end

[~, data(1)] = fun(solution.x(startIdx), solution.y(:,startIdx), args{1:end-1});
[~, data(end)] = fun(solution.x(end), solution.y(:,end), args{1:end-1});

%% Adding solution timesteps
out = wrapper.packageData(data);
out.state.time = solution.x;
out.state.Y = solution.y;
out.state.iEvent = [];

if ~isempty(solution.ie)
    out.state.iEvent = find(solution.x == solution.xe(1), 1, "first");
end