function [x, index] = nearestValSorted(vect, x0)
%{
nearestValSorted - nearest neighbour interpolation function. Input vector
                   must be already sorted

INPUTS:
        - vect, double [1,N], sorted vector;
        - x0, double [1,1], value at which you want to permorm
          interpolation.

OUTPUTS:
        - x, double [1,1], nearest value;
        - index, double [1,1], nearest value index.

CALLED FUNCTIONS: -

VERSIONS:
        - 06/11/2021,   release,    Adriano Filippo Inno
Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}


N = length(vect);

if x0 <= vect(1)
    x = vect(1);
    index = 1;
    return;
end

if x0 >= vect(N)
    x = vect(N);
    index = N;
    return;
end

for i = 2:N
    if x0 <= vect(i)
        xUp = vect(i);
        xDown = vect(i - 1);
        break;
    end
end

if (xUp - x0) > (x0 - xDown)
    x = xDown;
    index = i - 1;
else
    x = xUp;
    index = i;
end
