function [c, a, b, A, s, R] = safeEllipse(X, conf)
%{
This function finds the ellipse inside wich the point are with a percentage
of confidence R.

INPUTS:
        - X,    double [Nx2],   vector of sample points
        - R,    double [nx1],   percentage of confidence

OUTPUT:
        - c,    double [nx1],   centre of the ellipses
        - a,    double [nx1],   ellipse parameter a
        - b,    double [nx1],   ellipse parameter b

VERSION:
        - 10/08/2022,   release,    Luca Erbetta

Copyright © 2022, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}
%% CALCULATE ELLIPSE GEOMETRIC PARAMETERS
c    = mean(X);
data = X - c;

% Covariance matrix
C = cov(data);

[V, D] = eig(C);
sigma = sqrt(diag(D));

a = sigma(1);
b = sigma(2);

[~, imax] = max(diag(D));
A = atan2(V(2,imax), V(1,imax));

s = chi2inv(conf, 2);
R = V;

adeg = rad2deg(A);

end
