function [X, V_Apo, LP, ApoTime] = stochPostProcess(data_ascent, data_descent, isBallistic)
%{
stochPostProcess - This function computes useful data in a stochastic simulation

INPUTS:     
            - data_ascent, cell array, ascent data
            - data_descent, cell array, descent data

OUTPUTS:
            - X, double, apogee position matrix
            - V_apo, double, apogee velocities matrix
            - LP, double, landing points position matrix
            - ApoTime, double, apogee time vector 

CALLED FUNCTIONS: 

REVISIONS:
- 0     10/04/2023, Release,  Simone Cimolato

Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-late
%}
    % N = length(data_ascent) = size(data_descent, 1), Nstages = size(data_descent, 2)
    LP = zeros(length(data_ascent), size(data_descent, 2), 3);

    X = cell2mat(cellfun(@(Cell) [Cell.state.Y(end, 1:2) -Cell.state.Y(end, 3)], data_ascent, 'UniformOutput', false));
    V_Apo = cell2mat(cellfun(@(Cell) Cell.state.Y(end, 4:6) - Cell.wind.body_wind(1:3, end)', data_ascent, 'UniformOutput', false));
    ApoTime = cellfun(@(Cell) Cell.state.T(end), data_ascent);

    for i = 1:size(data_descent, 1)
        for j = 1:size(data_descent, 2)
            if isBallistic 
                LP(i, j, :) = data_descent{i, j}.state.Y(end, 1:3);
            else
                LP(i, j, :) = data_descent{i, j}.para{end}.state.Y(end, 1:3);
            end
        end
    end
end