function descent = stdDescentBal(ascentSolution, settings)
arguments
    ascentSolution      struct
    settings    Settings
end
%{ 

stdRunBallistic - This function runs a standard ballistic (non-stochastic) simulation

INTPUTS: 
            - settings, struct, stores data of the rocket and of the simulation.

OUTPUTS:
            - Tf, array, Total integration time vector; 
            - Yf, array, Total State Matrix;
            - Ta, array, [n� variations, 1], Ascent Integration time vector;
            - Ya, array, [n� variations, 16], Ascent State Matrix;
            - bound_value, struct, Useful values for the plots;

CALLED FUNCTIONS: windConstGenerator, ascent, recallOdeFcn, descentBal, delayControl.

REVISIONS:
- 0                 Release, Ruben Di Battista
- 1                 Revision, Francesco Colombi
- 2     09/10/2019, Revision, Adriano Filippo Inno
- 3     03/10/2021, Update,   Davide Rosato
                    Multiple and smooth airbrakes opening update

Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}

%% DATA PREPARATION
options = odeset(settings.ode.optDescent, 'OutputFcn', @storeData);

fun = ascentSolution.extdata.odefun;
t0 = ascentSolution.x(end);
tf = settings.ode.finalTime;

Y0 = ascentSolution.y(:, end);

wrapper = ascentSolution.extdata.varargin{end};
wrapper.reset();

%% DESCEND 
solution = ode113(fun, [t0, tf], Y0, options, ascentSolution.extdata.varargin{:});
descent = getOdeFcn(solution);

% if not(isfield(settings, 'unitTest')) || settings.unitTest == false
%     save('descent_plot.mat', 'descent');
% end
end