function [uw, vw, ww] = windVariableGenerator(z, wind)
%{
windVariableGenerator - generates a wind dividing the space in three layers, with a gaussian distribution at
ground and a uniform distribution in altitude, and in the middle it is performed a linear interplolation 

INPUTS:
    -z,  , double [1,1]: altitude
    -wind, struct:
                    magG: wind magnitude ground [m/s]
                    azG: wind azimuth ground [rad]
                    hG: limit groud layer [m]

                    magH: wind magnitude high-altitude [m/s]
                    azH: wind azimuth high-altitude [rad]
                    hH: limit high-altitude layer [m]

OUTPUTS: 
    - uw,        double [1, 1], wind component along x [m/s];
    - vw,        double [1, 1], wind component along y [m/s];
    - ww,        double [1, 1], wind component along z [m/s];

REVISIONS:
-#0, 04/01/2023, Release, Riccardo Cadamuro, Maria Teresa  Cazzola

Copyright © 2021, Skyward Experimental Rocketry, AFD department
All rights reserved

SPDX-License-Identifier: GPL-3.0-or-later

%}

z = -z; 

if z < wind.hG
    mag = wind.magG;     
    az = wind.azG; 
elseif z > wind.hH
    mag = wind.magH; 
    az = wind.azH; 
else
    mag = (z - wind.hG)/(wind.hH - wind.hG) * (wind.magH - wind.magG) + wind.magG;
    az = (z - wind.hG)/(wind.hH - wind.hG) * (wind.azH - wind.azG) + wind.azG; 
end

uw = mag * cos(az); 
vw = mag * sin(az); 
ww = 0;
end