/* Copyright (c) 2015-2020 Skyward Experimental Rocketry
 * Authors: Luca Erbetta, Luca Conterio
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#pragma once

#include <miosix.h>
#include <sensors/Sensor.h>
#include <utils/Constants.h>
#include <utils/Debug.h>

#include <cmath>

namespace Boardcore
{

struct TestData : public TimestampData
{
    float value;

    TestData(float v)
        : TimestampData{static_cast<uint64_t>(miosix::getTick())}, value(v)
    {
    }

    TestData()
        : TimestampData{static_cast<uint64_t>(miosix::getTick())}, value(0.0)
    {
    }
};

class TestSensor : public Sensor<TestData>
{
public:
    TestSensor() {}
    ~TestSensor() {}

    bool init() override { return true; }

    bool selfTest() override { return true; }

    TestData sampleImpl() override
    {
        TRACE("[TestSensor] sampleImpl() \n");
        return TestData(
            10 * sin(Constants::PI * static_cast<float>(miosix::getTick()) /
                     static_cast<float>(miosix::TICK_FREQ)));
    }
};

}  // namespace Boardcore
