/* Copyright (c) 2023 Skyward Experimental Rocketry
 * Author: Matteo Pignataro
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#pragma once

#include <algorithms/AirBrakes/TrajectorySet.h>

namespace Boardcore
{
static const std::vector<float> Z = {
    0,
    0.00229583764956942,
    0.00140099814791483,
    0,
    0.00302588293442341,
    0.00227860249694345,
    0,
    0.00144981504189445,
    0.00610658430696276,
    0.00610658430696276,
    0.0132358465088203,
    0.0220918286805443,
    0.0220918286805443,
    0.0255984959881914,
    0.0354616506923549,
    0.0354616506923549,
    0.0542063382948754,
    0.0627618863030648,
    0.0627618863030648,
    0.0826906217971839,
    0.114684539217308,
    0.114684539217308,
    0.137679151752735,
    0.181618463017742,
    0.181618463017742,
    0.221652560648891,
    0.268410776347366,
    0.268410776347366,
    0.303737523863475,
    0.356649155915449,
    0.356649155915449,
    0.430446488979072,
    0.491568499867924,
    0.491568499867924,
    0.571402732314141,
    0.650563977966584,
    0.650563977966584,
    0.745254107300383,
    0.805550322680318,
    0.805550322680318,
    0.873203539645289,
    0.969105510629845,
    0.969105510629845,
    1.09406962591385,
    1.19939780264187,
    1.19939780264187,
    1.33268904681265,
    1.42135070003064,
    1.42135070003064,
    1.51401453916625,
    1.6164651995002,
    1.6164651995002,
    1.73661566937321,
    1.8797939471973,
    1.8797939471973,
    2.05495445257742,
    2.21479312734184,
    2.21479312734184,
    2.37486220807241,
    2.55276013735406,
    2.55276013735406,
    2.68646918658195,
    2.82523458611146,
    2.82523458611146,
    2.97180755989197,
    3.10661781274308,
    3.10661781274308,
    3.26246500740319,
    3.39653668659437,
    3.39653668659437,
    3.55078637491502,
    3.72626009285443,
    3.72626009285443,
    3.92240277895149,
    4.16989737597382,
    4.16989737597382,
    4.30322957541222,
    4.48949734245514,
    4.48949734245514,
    4.61437195297367,
    4.77927482612276,
    4.77927482612276,
    5.0006713761081,
    5.15522823320018,
    5.15522823320018,
    5.34060445736242,
    5.52341172372263,
    5.52341172372263,
    5.69935702068412,
    5.94690662328316,
    5.94690662328316,
    6.1138097690592,
    6.3412671073288,
    6.3412671073288,
    6.51089014845968,
    6.66462221871075,
    6.66462221871075,
    6.92359042736393,
    7.13324626177214,
    7.13324626177214,
    7.30191382925571,
    7.44715782321219,
    7.44715782321219,
    7.6128244709476,
    7.84395482046736,
    7.84395482046736,
    8.05857572378144,
    8.2758046067386,
    8.2758046067386,
    8.51840451692144,
    8.71839593827323,
    8.71839593827323,
    8.96658189344586,
    9.23626670283554,
    9.23626670283554,
    9.46482115713687,
    9.7369383485163,
    9.7369383485163,
    9.9597708556206,
    10.2284085690636,
    10.2284085690636,
    10.5073992792727,
    10.7734645595449,
    10.7734645595449,
    11.0304092094334,
    11.2519632868651,
    11.2519632868651,
    11.4903211016851,
    11.7778477592524,
    11.7778477592524,
    11.9888877889857,
    12.2511266552532,
    12.2511266552532,
    12.4767271209175,
    12.7900582615435,
    12.7900582615435,
    13.0584171549428,
    13.3424270413622,
    13.3424270413622,
    13.5759516064762,
    13.7853026699536,
    13.7853026699536,
    14.0866784415552,
    14.4281830096937,
    14.4281830096937,
    14.7971212284913,
    15.0911450960964,
    15.0911450960964,
    15.3734872610752,
    15.7100203638115,
    15.7100203638115,
    16.0341742522481,
    16.4626203918523,
    16.4626203918523,
    16.7894171271318,
    17.1230319578453,
    17.1230319578453,
    17.4250506649835,
    17.7914190726676,
    17.7914190726676,
    18.0589740705291,
    18.3313751832695,
    18.3313751832695,
    18.6926232381372,
    19.0672403720735,
    19.0672403720735,
    19.4109518985874,
    19.7368460136003,
    19.7368460136003,
    20.0096689141696,
    20.2981157837843,
    20.2981157837843,
    20.6551967894853,
    21.0119040368826,
    21.0119040368826,
    21.3421546721588,
    21.7084301813784,
    21.7084301813784,
    22.113341064626,
    22.5442251281787,
    22.5442251281787,
    22.9208922767095,
    23.3752383238603,
    23.3752383238603,
    23.7112927555573,
    24.1563139880431,
    24.1563139880431,
    24.5324290650439,
    24.9948338366181,
    24.9948338366181,
    25.3502338708229,
    25.8113792581134,
    25.8113792581134,
    26.2293523680178,
    26.6925440542343,
    26.6925440542343,
    27.1118302585126,
    27.5238424011503,
    27.5238424011503,
    27.9450802409651,
    28.3628212642263,
    28.3628212642263,
    28.7322599294101,
    29.1712218852891,
    29.1712218852891,
    29.5913748883229,
    30.104424536782,
    30.104424536782,
    30.5747492308198,
    31.081430238792,
    31.081430238792,
    31.5701593903017,
    32.0768691640729,
    32.0768691640729,
    32.4507507709281,
    32.9194252276529,
    32.9194252276529,
    33.3622493141536,
    33.9073560409683,
    33.9073560409683,
    34.3874436125557,
    34.980301950504,
    34.980301950504,
    35.48831318538,
    36.0671741096808,
    36.0671741096808,
    36.5317410657746,
    37.108411356793,
    37.108411356793,
    37.553399309004,
    38.1127418570142,
    38.1127418570142,
    38.6236598500683,
    39.2114898991253,
    39.2114898991253,
    39.7083022755751,
    40.2692934989986,
    40.2692934989986,
    40.7718813392004,
    41.3815370692143,
    41.3815370692143,
    41.9293399179404,
    42.5763561255846,
    42.5763561255846,
    43.0480570660155,
    43.5984629136223,
    43.5984629136223,
    44.1678115539819,
    44.8064787953826,
    44.8064787953826,
    45.3353097018314,
    45.9488471495895,
    45.9488471495895,
    46.5228220877566,
    47.2032061136226,
    47.2032061136226,
    47.8022914983618,
    48.47117153113,
    48.47117153113,
    49.0051345219864,
    49.5983173494154,
    49.5983173494154,
    50.2089336480153,
    50.8541182259983,
    50.8541182259983,
    51.4385932701904,
    52.0801761754374,
    52.0801761754374,
    52.6459907148989,
    53.3214904796183,
    53.3214904796183,
    53.9455213757575,
    54.6246546113141,
    54.6246546113141,
    55.210043452844,
    55.907846231663,
    55.907846231663,
    56.5225006406047,
    57.1854669729615,
    57.1854669729615,
    57.8285049341572,
    58.5374217759169,
    58.5374217759169,
    59.2196961389018,
    59.9640490122179,
    59.9640490122179,
    60.5645806663022,
    61.3493807224804,
    61.3493807224804,
    62.0037508363425,
    62.7135902237237,
    62.7135902237237,
    63.3989797715274,
    64.1944303271254,
    64.1944303271254,
    64.8661614050355,
    65.5550525798532,
    65.5550525798532,
    66.3045876734361,
    67.1555213616317,
    67.1555213616317,
    67.8542828985784,
    68.7102938298746,
    68.7102938298746,
    69.3686685682914,
    70.1070519004767,
    70.1070519004767,
    70.833348269403,
    71.6882191257056,
    71.6882191257056,
    72.4121146660299,
    73.2676819099397,
    73.2676819099397,
    74.0853766109115,
    74.9800109467503,
    74.9800109467503,
    75.7561145056111,
    76.5752480206893,
    76.5752480206893,
    77.3055118872311,
    78.1098702139876,
    78.1098702139876,
    78.9286755824936,
    79.8396155574679,
    79.8396155574679,
    80.6458607366647,
    81.4596506696543,
    81.4596506696543,
    82.2364831017684,
    83.1626517515649,
    83.1626517515649,
    84.0563478625182,
    84.9363180017705,
    84.9363180017705,
    85.6762341471107,
    86.4892752409614,
    86.4892752409614,
    87.312378058177,
    88.2525720512255,
    88.2525720512255,
    89.057702546516,
    89.9770369252871,
    89.9770369252871,
    90.8149916878391,
    91.8524116616786,
    91.8524116616786,
    92.7431164684594,
    93.7156603569802,
    93.7156603569802,
    94.4737160010831,
    95.3999841375237,
    95.3999841375237,
    96.2830997897065,
    97.2361064459023,
    97.2361064459023,
    98.0473736760975,
    98.9826569743803,
    98.9826569743803,
    99.9138299358752,
    100.970529050661,
    100.970529050661,
    101.874396938334,
    102.837530581423,
    102.837530581423,
    103.676156910912,
    104.610413067743,
    104.610413067743,
    105.523162522135,
    106.612347308846,
    106.612347308846,
    107.491286698232,
    108.541093893686,
    108.541093893686,
    109.52333350318,
    110.610476643855,
    110.610476643855,
    111.599030891455,
    112.644367065482,
    112.644367065482,
    113.502817992646,
    114.541683445083,
    114.541683445083,
    115.534627916486,
    116.637531945694,
    116.637531945694,
    117.636151018864,
    118.686432591947,
    118.686432591947,
    119.720393374535,
    120.910066229009,
    120.910066229009,
    121.85832472886,
    123.011957209555,
    123.011957209555,
    123.947764274268,
    124.966442371057,
    124.966442371057,
    126.06224479068,
    127.232126837936,
    127.232126837936,
    128.197194300159,
    129.299715217223,
    129.299715217223,
    130.363694070288,
    131.609201720406,
    131.609201720406,
    132.64715284326,
    133.829752299661,
    133.829752299661,
    134.819402371308,
    135.945789934179,
    135.945789934179,
    137.002329364937,
    138.213917276823,
    138.213917276823,
    139.232674265552,
    140.409247792334,
    140.409247792334,
    141.502252165701,
    142.752564773005,
    142.752564773005,
    143.852792021512,
    145.047977607778,
    145.047977607778,
    146.035016160971,
    147.148052043645,
    147.148052043645,
    148.285394240135,
    149.530557080904,
    149.530557080904,
    150.613613363053,
    151.852986432286,
    151.852986432286,
    153.061952136489,
    154.380927861768,
    154.380927861768,
    155.49619991848,
    156.75491017379,
    156.75491017379,
    157.762637894872,
    158.937658764989,
    158.937658764989,
    160.057569926541,
    161.363179768512,
    161.363179768512,
    162.438048558469,
    163.716236516917,
    163.716236516917,
    164.941633012666,
    166.338618508272,
    166.338618508272,
    167.492904268155,
    168.781967404077,
    168.781967404077,
    169.886445681911,
    171.09201139089,
    171.09201139089,
    172.274579972311,
    173.636229724673,
    173.636229724673,
    174.808000744919,
    176.086847600009,
    176.086847600009,
    177.377524800446,
    178.78886682469,
    178.78886682469,
    179.966987692111,
    181.351237245424,
    181.351237245424,
    182.468873875024,
    183.717308383367,
    183.717308383367,
    184.94445060746,
    186.3149556976,
    186.3149556976,
    187.472172575315,
    188.832912977773,
    188.832912977773,
    190.164427999441,
    191.624240881095,
    191.624240881095,
    192.845115202504,
    194.230761166674,
    194.230761166674,
    195.487012933093,
    196.818956821779,
    196.818956821779,
    198.090347435934,
    199.53758749175,
    199.53758749175,
    200.744750269961,
    202.145844341832,
    202.145844341832,
    203.483345150163,
    205.026649526658,
    205.026649526658,
    206.307063315826,
    207.70273499652,
    207.70273499652,
    208.899466939828,
    210.260671762699,
    210.260671762699,
    211.566227152897,
    213.085381368997,
    213.085381368997,
    214.385825521302,
    215.802208297653,
    215.802208297653,
    217.197474477758,
    218.7307885208,
    218.7307885208,
    220.077424612596,
    221.620868830359,
    221.620868830359,
    222.854486906692,
    224.22148027613,
    224.22148027613,
    225.587811107626,
    227.15784036626,
    227.15784036626,
    228.447169306134,
    229.898228430305,
    229.898228430305,
    231.376994220526,
    232.961945376039,
    232.961945376039,
    234.355565030368,
    235.893156630243,
    235.893156630243,
    237.218522245695,
    238.684152614497,
    238.684152614497,
    240.119908142652,
    241.665528395348,
    241.665528395348,
    243.011726033349,
    244.481374146245,
    244.481374146245,
    245.952220402659,
    247.576032099189,
    247.576032099189,
    248.979506660623,
    250.53005780358,
    250.53005780358,
    251.877737444808,
    253.411803239967,
    253.411803239967,
    254.821009191678,
    256.430271635452,
    256.430271635452,
    257.820915602468,
    259.354170546853,
    259.354170546853,
    260.851654039694,
    262.519320298323,
    262.519320298323,
    263.960219461341,
    265.615802491542,
    265.615802491542,
    267.017246576925,
    268.546092589084,
    268.546092589084,
    269.95308939312,
    271.611737888349,
    271.611737888349,
    272.968120276161,
    274.59108210554,
    274.59108210554,
    276.151887275503,
    277.931590150556,
    277.931590150556,
    279.447570959005,
    281.10345185902,
    281.10345185902,
    282.480460589796,
    284.105492697829,
    284.105492697829,
    285.648081559386,
    287.400391292088,
    287.400391292088,
    288.830972086907,
    290.459569516154,
    290.459569516154,
    292.111473319779,
    293.8906001058,
    293.8906001058,
    295.429625502408,
    297.190548552904,
    297.190548552904,
    298.636234942379,
    300.260966483129,
    300.260966483129,
    301.839912646211,
    303.624083878022,
    303.624083878022,
    305.085970655837,
    306.812725620574,
    306.812725620574,
    308.471960444659,
    310.319990808991,
    310.319990808991,
    311.85474294943,
    313.664512235003,
    313.664512235003,
    315.177964235386,
    316.841382737136,
    316.841382737136,
    318.503458703345,
    320.300554081173,
    320.300554081173,
    321.839944141418,
    323.581147175571,
    323.581147175571,
    325.259015032862,
    327.161947185622,
    327.161947185622,
    328.760084537197,
    330.540417067406,
    330.540417067406,
    332.033640412802,
    333.709070300431,
    333.709070300431,
    335.350568922007,
    337.218621937758,
    337.218621937758,
    338.764629204352,
    340.601252038799,
    340.601252038799,
    342.350010178379,
    344.36039486991,
    344.36039486991,
    346.034336508314,
    347.868200835746,
    347.868200835746,
    349.47533239926,
    351.250137622967,
    351.250137622967,
    352.949529920949,
    354.842140360983,
    354.842140360983,
    356.403410264841,
    358.233412770713,
    358.233412770713,
    360.010333707357,
    362.008352224299,
    362.008352224299,
    363.719743658201,
    365.64538445333,
    365.64538445333,
    367.265785854024,
    369.054774922256,
    369.054774922256,
    370.840718428411,
    372.792302113172,
    372.792302113172,
    374.496542860852,
    376.415285722189,
    376.415285722189,
    378.238291775876,
    380.23213119284,
    380.23213119284,
    381.981366918964,
    383.908102841049,
    383.908102841049,
    385.592476447906,
    387.419354613046,
    387.419354613046,
    389.246125615138,
    391.22007017422,
    391.22007017422,
    392.967042627785,
    394.878477754263,
    394.878477754263,
    396.471276796781,
    398.332963029684,
    398.332963029684,
    400.099677277504,
    402.099710795684,
    402.099710795684,
    403.772861551246,
    405.663695315117,
    405.663695315117,
    407.54832006709,
    409.639881303042,
    409.639881303042,
    411.40448758052,
    413.369646072993,
    413.369646072993,
    415.016870281465,
    416.899581426391,
    416.899581426391,
    418.764071051435,
    420.820358611693,
    420.820358611693,
    422.529467509226,
    424.500804872021,
    424.500804872021,
    426.412958958563,
    428.597190425245,
    428.597190425245,
    430.396110522258,
    432.406948116988,
    432.406948116988,
    434.158035566045,
    436.037832074314,
    436.037832074314,
    437.894070306351,
    439.985508158817,
    439.985508158817,
    441.768659447653,
    443.762221710733,
    443.762221710733,
    445.692773536696,
    447.843270196612,
    447.843270196612,
    449.672047039024,
    451.783360450399,
    451.783360450399,
    453.476575884956,
    455.458531031833,
    455.458531031833,
    457.351081248304,
    459.461184495387,
    459.461184495387,
    461.247390273932,
    463.292737873546,
    463.292737873546,
    465.260508087703,
    467.485121788556,
    467.485121788556,
    469.318808962409,
    471.442421000091,
    471.442421000091,
    473.21754785513,
    475.241892400661,
    475.241892400661,
    477.221582672045,
    479.418101413518,
    479.418101413518,
    481.318861825051,
    483.368884546701,
    483.368884546701,
    485.415808030328,
    487.66225305955,
    487.66225305955,
    489.611968946551,
    491.771809080693,
    491.771809080693,
    493.615537817093,
    495.662907318897,
    495.662907318897,
    497.622102677903,
    499.851277034945,
    499.851277034945,
    501.681308771481,
    503.825562401666,
    503.825562401666,
    505.924497527781,
    508.243271596835,
    508.243271596835,
    510.233592207908,
    512.392578662566,
    512.392578662566,
    514.212181227129,
    516.317294837194,
    516.317294837194,
    518.381346435295,
    520.687166034807,
    520.687166034807,
    522.63419902793,
    524.847571573905,
    524.847571573905,
    526.970831181083,
    529.351683933857,
    529.351683933857,
    531.333630805777,
    533.595687234522,
    533.595687234522,
    535.483313068801,
    537.568327954074,
    537.568327954074,
    539.700183671729,
    541.990241446195,
    541.990241446195,
    543.982938750189,
    546.133319458301,
    546.133319458301,
    548.233696177874,
    550.581033340571,
    550.581033340571,
    552.629043372436,
    554.882183523213,
    554.882183523213,
    556.801266031239,
    558.932728324243,
    558.932728324243,
    561.086617862069,
    563.403129109646,
    563.403129109646,
    565.341534084778,
    567.576204854919,
    567.576204854919,
    569.744466406892,
    572.179783762178,
    572.179783762178,
    574.210754444059,
    576.466224523097,
    576.466224523097,
    578.399885406864,
    580.651316629019,
    580.651316629019,
    582.775747792195,
    585.236576417442,
    585.236576417442,
    587.235413681531,
    589.51493526834,
    589.51493526834,
    591.758295784694,
    594.209788738559,
    594.209788738559,
    596.371635972897,
    598.751219877242,
    598.751219877242,
    600.702552333175,
    602.984440888699,
    602.984440888699,
    605.14606324845,
    607.619925380526,
    607.619925380526,
    609.6991523373,
    612.053591665327,
    612.053591665327,
    614.357848883409,
    616.866457520944,
    616.866457520944,
    619.052456341662,
    621.425445598449,
    621.425445598449,
    623.416348780869,
    625.701668502624,
    625.701668502624,
    627.966925509174,
    630.502793633816,
    630.502793633816,
    632.613178520707,
    635.001357137752,
    635.001357137752,
    637.276329383169,
    639.923604830722,
    639.923604830722,
    642.086871708584,
    644.526153461289,
    644.526153461289,
    646.556672513097,
    648.879330471526,
    648.879330471526,
    651.148047157751,
    653.683349193678,
    653.683349193678,
    655.805856396983,
    658.166830339629,
    658.166830339629,
    660.480171602946,
    663.048844599422,
    663.048844599422,
    665.304026778074,
    667.762923730327,
    667.762923730327,
    669.865693728059,
    672.228631890221,
    672.228631890221,
    674.574115719605,
    677.095333913127,
    677.095333913127,
    679.2297220396,
    681.647382106786,
    681.647382106786,
    684.033059725333,
    686.6662121252,
    686.6662121252,
    688.906225938109,
    691.461291678424,
    691.461291678424,
    693.573946706041,
    696.004610640785,
    696.004610640785,
    698.381260362792,
    701.04172023876,
    701.04172023876,
    703.25610012852,
    705.714859650825,
    705.714859650825,
    708.152416885465,
    710.834085555249,
    710.834085555249,
    713.106065416403,
    715.670649233697,
    715.670649233697,
    717.777658046673,
    720.244536798532,
    720.244536798532,
    722.671357730653,
    725.326595396154,
    725.326595396154,
    727.541397129468,
    730.080713683868,
    730.080713683868,
    732.555478261925,
    735.317754564205,
    735.317754564205,
    737.728278394207,
    740.355901992343,
    740.355901992343,
    742.545971007856,
    745.009399078444,
    745.009399078444,
    747.382148467539,
    750.079926754036,
    750.079926754036,
    752.378751426567,
    755.012932764204,
    755.012932764204,
    757.533690936906,
    760.345703715211,
    760.345703715211,
    762.72248643873,
    765.355529703684,
    765.355529703684,
    767.658516338449,
    770.171197380802,
    770.171197380802,
    772.631350774645,
    775.379866355117,
    775.379866355117,
    777.739222514947,
    780.359247035308,
    780.359247035308,
    782.881094931909,
    785.74360029826,
    785.74360029826,
    788.122871942756,
    790.826994452033,
    790.826994452033,
    793.042367840885,
    795.578485162415,
    795.578485162415,
    798.084621046159,
    800.882571461103,
    800.882571461103,
    803.245169661321,
    805.886942681773,
    805.886942681773,
    808.459889681787,
    811.316778919722,
    811.316778919722,
    813.753532057555,
    816.433372234996,
    816.433372234996,
    818.675293683086,
    821.235556087663,
    821.235556087663,
    823.809180905151,
    826.592507841,
    826.592507841,
    828.919327612652,
    831.556696575033,
    831.556696575033,
    834.06675823464,
    836.883972076191,
    836.883972076191,
    839.287876204263,
    841.972521266136,
    841.972521266136,
    844.236535222536,
    846.804327851693,
    846.804327851693,
    849.309155811171,
    852.076135598493,
    852.076135598493,
    854.418605445988,
    856.98085219695,
    856.98085219695,
    859.563652279964,
    862.361657366639,
    862.361657366639,
    864.689438244972,
    867.404301868993,
    867.404301868993,
    869.638025833041,
    872.164191887203,
    872.164191887203,
    874.618939887484,
    877.401577688177,
    877.401577688177,
    879.688799871355,
    882.2631762881,
    882.2631762881,
    884.794593282966,
    887.55925231732,
    887.55925231732,
    889.916808469934,
    892.586106519849,
    892.586106519849,
    894.766163025001,
    897.314512251359,
    897.314512251359,
    899.808414712835,
    902.50929675481,
    902.50929675481,
    904.817334686188,
    907.372010402851,
    907.372010402851,
    909.892921581129,
    912.620168448275,
    912.620168448275,
    915.037087540206,
    917.701158669995,
    917.701158669995,
    919.885014530583,
    922.402402340435,
    922.402402340435,
    924.889296090067,
    927.547493349703,
    927.547493349703,
    929.732387631223,
    932.241221108542,
    932.241221108542,
    934.703835813815,
    937.453698020006,
    937.453698020006,
    939.761263992148,
    942.369000743808,
    942.369000743808,
    944.600764809126,
    947.067656331715,
    947.067656331715,
    949.491290721872,
    952.213954145752,
    952.213954145752,
    954.511093018292,
    957.06144640682,
    957.06144640682,
    959.559901745449,
    962.2939703733,
    962.2939703733,
    964.593341099114,
    967.282839941954,
    967.282839941954,
    969.402896891294,
    971.789265462125,
    971.789265462125,
    974.207907291135,
    976.898600556142,
    976.898600556142,
    979.142105703346,
    981.691762401004,
    981.691762401004,
    984.161325302563,
    986.909937551172,
    986.909937551172,
    989.233398225601,
    991.84239071819,
    991.84239071819,
    994.078601926954,
    996.564731970137,
    996.564731970137,
    998.980526416686,
    1001.61908242347,
    1001.61908242347,
    1003.80572668955,
    1006.29958571799,
    1006.29958571799,
    1008.74495589693,
    1011.42249764902,
    1011.42249764902,
    1013.73338928753,
    1016.28544178875,
    1016.28544178875,
    1018.39532148204,
    1020.84162616046,
    1020.84162616046,
    1023.19611508956,
    1025.80790083786,
    1025.80790083786,
    1028.02942936921,
    1030.56148688447,
    1030.56148688447,
    1032.95933581214,
    1035.65541242931,
    1035.65541242931,
    1037.92803778211,
    1040.36102480942,
    1040.36102480942,
    1042.55442588062,
    1044.97313373387,
    1044.97313373387,
    1047.34058140575,
    1049.90287247743,
    1049.90287247743,
    1052.07317695689,
    1054.5119656908,
    1054.5119656908,
    1056.93638137622,
    1059.58518506069,
    1059.58518506069,
    1061.81244385815,
    1064.31290588671,
    1064.31290588671,
    1066.44111534733,
    1068.79591065615,
    1068.79591065615,
    1071.08457295838,
    1073.66844186346,
    1073.66844186346,
    1075.80941256524,
    1078.25151373242,
    1078.25151373242,
    1080.63683724612,
    1083.2623585022,
    1083.2623585022,
    1085.52536151206,
    1088.01995456904,
    1088.01995456904,
    1090.12993463021,
    1092.55386586133,
    1092.55386586133,
    1094.80477411404,
    1097.36074970847,
    1097.36074970847,
    1099.52613077881,
    1101.89806911419,
    1101.89806911419,
    1104.242851466,
    1106.80592113304,
    1106.80592113304,
    1109.02576616889,
    1111.4782323763,
    1111.4782323763,
    1113.50667261036,
    1115.84160361016,
    1115.84160361016,
    1118.13928293984,
    1120.68984229617,
    1120.68984229617,
    1122.88143462261,
    1125.26630983681,
    1125.26630983681,
    1127.62343597132,
    1130.17876688053,
    1130.17876688053,
    1132.33527829945,
    1134.79773045039,
    1134.79773045039,
    1136.89838522009,
    1139.21831425854,
    1139.21831425854,
    1141.43720122566,
    1144.00015371527,
    1144.00015371527,
    1146.13481237906,
    1148.56907775774,
    1148.56907775774,
    1150.8219077326,
    1153.31614371819,
    1153.31614371819,
    1155.52303931722,
    1157.955237094,
    1157.955237094,
    1160.03237364292,
    1162.34002453498,
    1162.34002453498,
    1164.55068232786,
    1166.98392475767,
    1166.98392475767,
    1169.08347110238,
    1171.40497311442,
    1171.40497311442,
    1173.78163852646,
    1176.32271677729,
    1176.32271677729,
    1178.53145685959,
    1180.94028075835,
    1180.94028075835,
    1182.95557082421,
    1185.25742009809,
    1185.25742009809,
    1187.48086593354,
    1189.98732848612,
    1189.98732848612,
    1192.14100665654,
    1194.49467569495,
    1194.49467569495,
    1196.7912537809,
    1199.32538619759,
    1199.32538619759,
    1201.47644891733,
    1203.8446046363,
    1203.8446046363,
    1205.8132713065,
    1208.13096337606,
    1208.13096337606,
    1210.37807669658,
    1212.82415070782,
    1212.82415070782,
    1214.82966712619,
    1217.16558255896,
    1217.16558255896,
    1219.43631480364,
    1221.93594144003,
    1221.93594144003,
    1224.08436108996,
    1226.50345395436,
    1226.50345395436,
    1228.52212560028,
    1230.799859895,
    1230.799859895,
    1232.97780817149,
    1235.4905906176,
    1235.4905906176,
    1237.51275882358,
    1239.81614302521,
    1239.81614302521,
    1242.00539100084,
    1244.48041214139,
    1244.48041214139,
    1246.53880715925,
    1248.86826650087,
    1248.86826650087,
    1250.85972967536,
    1253.05839024206,
    1253.05839024206,
    1255.1782080356,
    1257.68357929915,
    1257.68357929915,
    1259.73772989075,
    1262.07910341568,
    1262.07910341568,
    1264.30434460006,
    1266.80273258745,
    1266.80273258745,
    1268.88959259389,
    1271.26800275622,
    1271.26800275622,
    1273.24693682083,
    1275.46318878076,
    1275.46318878076,
    1277.61047490662,
    1279.96119174613,
    1279.96119174613,
    1281.93954886688,
    1284.19272133948,
    1284.19272133948,
    1286.40986381321,
    1288.82221858591,
    1288.82221858591,
    1290.91746268,
    1293.18817594754,
    1293.18817594754,
    1295.11942754385,
    1297.34267042473,
    1297.34267042473,
    1299.43157456214,
    1301.82471933673,
    1301.82471933673,
    1303.83199666088,
    1306.1233120776,
    1306.1233120776,
    1308.29660456316,
    1310.67611877549,
    1310.67611877549,
    1312.68549502461,
    1314.98340331851,
    1314.98340331851,
    1316.85392951832,
    1318.962891126,
    1318.962891126,
    1321.02139854131,
    1323.36913277094,
    1323.36913277094,
    1325.33949688553,
    1327.55782096256,
    1327.55782096256,
    1329.66694622696,
    1332.06855286388,
    1332.06855286388,
    1334.06727647121,
    1336.33306755198,
    1336.33306755198,
    1338.24061909314,
    1340.42972966142,
    1340.42972966142,
    1342.55983744193,
    1344.91027978318,
    1344.91027978318,
    1346.85939493253,
    1349.06510000834,
    1349.06510000834,
    1351.19753582802,
    1353.61784127687,
    1353.61784127687,
    1355.66492591209,
    1357.92944057857,
    1357.92944057857,
    1359.80753178292,
    1361.95037293129,
    1361.95037293129,
    1364.00232778534,
    1366.30367583463,
    1366.30367583463,
    1368.25442813107,
    1370.386882865,
    1370.386882865,
    1372.49160705238,
    1374.86732960131,
    1374.86732960131,
    1376.85316571024,
    1379.08060107703,
    1379.08060107703,
    1380.95379201769,
    1383.08063399136,
    1383.08063399136,
    1385.09056253028,
    1387.3802582556,
    1387.3802582556,
    1389.34854443689,
    1391.53287255394,
    1391.53287255394,
    1393.6177200452,
    1395.98027006249,
    1395.98027006249,
    1397.92500544115,
    1400.17962427036,
    1400.17962427036,
    1402.02656086172,
    1404.18875458606,
    1404.18875458606,
    1406.20374806179,
    1408.46434518553,
    1408.46434518553,
    1410.40488297918,
    1412.54583879802,
    1412.54583879802,
    1414.62349020956,
    1416.9289178088,
    1416.9289178088,
    1418.94494490817,
    1421.13141476618,
    1421.13141476618,
    1422.95445019951,
    1424.99018913174,
    1424.99018913174,
    1426.97775408475,
    1429.29002548077,
    1429.29002548077,
    1431.16601422545,
    1433.31462150541,
    1433.31462150541,
    1435.39972708309,
    1437.62290546038,
    1437.62290546038,
    1439.51070876411,
    1441.70536041671,
    1441.70536041671,
    1443.51776002463,
    1445.58133223149,
    1445.58133223149,
    1447.58905496757,
    1449.81208074848,
    1449.81208074848,
    1451.66793681197,
    1453.79492952814,
    1453.79492952814,
    1455.82106634566,
    1458.11874339258,
    1458.11874339258,
    1460.14180089154,
    1462.28017643488,
    1462.28017643488,
    1464.0753409496,
    1466.094805343,
    1466.094805343,
    1468.11468577588,
    1470.32917830925,
    1470.32917830925,
    1472.18436565983,
    1474.34156660656,
    1474.34156660656,
    1476.38802695376,
    1478.65012121629,
    1478.65012121629,
    1480.5784197182,
    1482.74826901257,
    1482.74826901257,
    1484.53362100673,
    1486.55350567165,
    1486.55350567165,
    1488.45193371574,
    1490.68320722873,
    1490.68320722873,
    1492.46049803777,
    1494.52435326934,
    1494.52435326934,
    1496.56731549152,
    1498.84572720001,
    1498.84572720001,
    1500.75554708946,
    1502.97453178422,
    1502.97453178422,
    1504.75517023218,
    1506.81714492023,
    1506.81714492023,
    1508.74266915817,
    1510.94222298189,
    1510.94222298189,
    1512.81941626385,
    1514.89990613983,
    1514.89990613983,
    1516.90967446905,
    1519.14203578993,
    1519.14203578993,
    1521.04977512983,
    1523.16139845146,
    1523.16139845146,
    1524.9059812271,
    1526.96880181365,
    1526.96880181365,
    1528.85237833969,
    1531.0607843907,
    1531.0607843907,
    1532.87352451648,
    1534.9356726162,
    1534.9356726162,
    1536.9533553006,
    1539.23880354443,
    1539.23880354443,
    1541.09568895864,
    1543.20116438819,
    1543.20116438819,
    1544.96283594645,
    1546.93084208615,
    1546.93084208615,
    1548.91086030897,
    1551.06673829663,
    1551.06673829663,
    1552.85790937145,
    1554.88606012315,
    1554.88606012315,
    1556.87624803072,
    1559.08212996452,
    1559.08212996452,
    1561.02459223013,
    1563.05076824799,
    1563.05076824799,
    1564.85120569833,
    1566.85803290593,
    1566.85803290593,
    1568.7712632272,
    1570.89718452835,
    1570.89718452835,
    1572.73469783812,
    1574.75189459064,
    1574.75189459064,
    1576.65749081177,
    1578.81947508236,
    1578.81947508236,
    1580.67581802276,
    1582.79241451644,
    1582.79241451644,
    1584.55702741756,
    1586.52283454808,
    1586.52283454808,
    1588.41535878937,
    1590.56256314108,
    1590.56256314108,
    1592.35796454193,
    1594.40327219436,
    1594.40327219436,
    1596.32649119353,
    1598.45841052715,
    1598.45841052715,
    1600.24065030559,
    1602.24382531512,
    1602.24382531512,
    1603.91844673249,
    1605.88572341761,
    1605.88572341761,
    1607.7917313799,
    1609.90503524441,
    1609.90503524441,
    1611.64585676623,
    1613.65410754733,
    1613.65410754733,
    1615.56468382702,
    1617.70996208832,
    1617.70996208832,
    1619.54795882428,
    1621.59454484941,
    1621.59454484941,
    1623.29836351259,
    1625.24133977453,
    1625.24133977453,
    1627.11766425333,
    1629.12579910861,
    1629.12579910861,
    1630.82631959896,
    1632.73413501933,
    1632.73413501933,
    1634.61960797052,
    1636.74049158557,
    1636.74049158557,
    1638.47335065848,
    1640.49757012014,
    1640.49757012014,
    1642.16803963023,
    1644.1108433011,
    1644.1108433011,
    1646.01668038727,
    1648.05689008678,
    1648.05689008678,
    1649.77161972879,
    1651.72407315078,
    1651.72407315078,
    1653.65591835664,
    1655.77594385374,
    1655.77594385374,
    1657.55778125661,
    1659.59905512616,
    1659.59905512616,
    1661.26927335483,
    1663.20296491343,
    1663.20296491343,
    1665.03708675349,
    1667.0277025837,
    1667.0277025837,
    1668.73159640223,
    1670.65707411688,
    1670.65707411688,
    1672.50997918086,
    1674.61238737724,
    1674.61238737724,
    1676.40525761981,
    1678.4195082113,
    1678.4195082113,
    1680.04310691099,
    1681.91238123931,
    1681.91238123931,
    1683.69183232672,
    1685.68303364816,
    1685.68303364816,
    1687.44789187903,
    1689.40043382924,
    1689.40043382924,
    1691.27951957819,
    1693.39975581411,
    1693.39975581411,
    1695.11290753316,
    1697.07973111286,
    1697.07973111286,
    1698.7178817505,
    1700.58010552696,
    1700.58010552696,
    1702.36260041188,
    1704.40745218133,
    1704.40745218133,
    1706.11600865173,
    1708.06639676762,
    1708.06639676762,
    1709.90142298558,
    1711.99493274336,
    1711.99493274336,
    1713.76816113528,
    1715.77697653626,
    1715.77697653626,
    1717.38112096655,
    1719.22141106529,
    1719.22141106529,
    1720.97559100772,
    1722.98896799272,
    1722.98896799272,
    1724.68894639937,
    1726.62950770622,
    1726.62950770622,
    1728.46056000682,
    1730.53782235207,
    1730.53782235207,
    1732.23213314949,
    1734.10613589522,
    1734.10613589522,
    1735.66863072706,
    1737.4957092524,
    1737.4957092524,
    1739.23672086855,
    1741.2007675134,
    1741.2007675134,
    1742.87654405254,
    1744.71470287828,
    1744.71470287828,
    1746.59782453016,
    1748.63968877675,
    1748.63968877675,
    1750.38255727478,
    1752.23732413227,
    1752.23732413227,
    1753.83223515265,
    1755.62485050531,
    1755.62485050531,
    1757.42701793665,
    1759.38047074999,
    1759.38047074999,
    1761.0915209231,
    1762.88273374789,
    1762.88273374789,
    1764.68258230936,
    1766.631206571,
    1766.631206571,
    1768.21407000649,
    1770.12513463221,
    1770.12513463221,
    1771.67959598084,
    1773.40343446762,
    1773.40343446762,
    1775.24484208659,
    1777.12418420532,
    1777.12418420532,
    1778.74280771292,
    1780.52737415065,
    1780.52737415065,
    1782.36180595162,
    1784.40713795215,
    1784.40713795215,
    1786.07047237046,
    1787.96981058443,
    1787.96981058443,
    1789.59589926522,
    1791.31321373619,
    1791.31321373619,
    1793.01849928693,
    1794.90761855845,
    1794.90761855845,
    1796.57562376076,
    1798.34338476969,
    1798.34338476969,
    1800.11670367337,
    1802.08876000141,
    1802.08876000141,
    1803.78878987343,
    1805.55735305891,
    1805.55735305891,
    1807.12179085061,
    1808.843908106,
    1808.843908106,
    1810.52529277804,
    1812.46023279755,
    1812.46023279755,
    1814.11138120562,
    1815.93949973381,
    1815.93949973381,
    1817.69912607463,
    1819.60890395241,
    1819.60890395241,
    1821.27590796305,
    1823.12499868538,
    1823.12499868538,
    1824.60485506414,
    1826.32244894159,
    1826.32244894159,
    1828.04459407813,
    1829.85087781458,
    1829.85087781458,
    1831.50820913847,
    1833.30277501231,
    1833.30277501231,
    1835.01379816145,
    1836.89548822084,
    1836.89548822084,
    1838.49494691625,
    1840.30563976016,
    1840.30563976016,
    1841.88729082935,
    1843.65983571433,
    1843.65983571433,
    1845.36535596511,
    1847.21223103219,
    1847.21223103219,
    1848.7405314138,
    1850.45624320802,
    1850.45624320802,
    1852.1043972634,
    1853.96687222105,
    1853.96687222105,
    1855.55211247491,
    1857.40495178858,
    1857.40495178858,
    1858.97916210622,
    1860.66774140715,
    1860.66774140715,
    1862.37959099675,
    1864.20426817414,
    1864.20426817414,
    1865.75788412126,
    1867.52427764198,
    1867.52427764198,
    1869.13360320221,
    1870.99537906433,
    1870.99537906433,
    1872.54061799085,
    1874.35163582595,
    1874.35163582595,
    1875.8683571915,
    1877.64940332825,
    1877.64940332825,
    1879.29405064177,
    1881.13401762524,
    1881.13401762524,
    1882.70092139296,
    1884.42391546297,
    1884.42391546297,
    1886.14705767648,
    1887.95697639991,
    1887.95697639991,
    1889.58025996579,
    1891.35771110328,
    1891.35771110328,
    1892.82354590101,
    1894.55974756577,
    1894.55974756577,
    1896.20793562043,
    1898.03445884329,
    1898.03445884329,
    1899.55822622401,
    1901.2763265777,
    1901.2763265777,
    1902.95005926367,
    1904.77127235795,
    1904.77127235795,
    1906.29733577333,
    1908.06575029992,
    1908.06575029992,
    1909.56019666228,
    1911.22245568589,
    1911.22245568589,
    1912.85651102639,
    1914.62811036351,
    1914.62811036351,
    1916.10478615873,
    1917.81702984609,
    1917.81702984609,
    1919.4824611827,
    1921.2753318997,
    1921.2753318997,
    1922.85038105091,
    1924.57930451801,
    1924.57930451801,
    1926.0153455373,
    1927.66560941695,
    1927.66560941695,
    1929.24817997563,
    1931.06320328611,
    1931.06320328611,
    1932.57188988558,
    1934.19682900561,
    1934.19682900561,
    1935.77617615049,
    1937.56917593382,
    1937.56917593382,
    1939.1697555092,
    1940.87825338634,
    1940.87825338634,
    1942.34870702715,
    1943.98059577068,
    1943.98059577068,
    1945.53762958574,
    1947.33190809451,
    1947.33190809451,
    1948.78645254006,
    1950.4737354571,
    1950.4737354571,
    1952.09784993128,
    1953.89262841988,
    1953.89262841988,
    1955.43319892799,
    1957.11468440486,
    1957.11468440486,
    1958.57660714058,
    1960.24984340284,
    1960.24984340284,
    1961.84739748622,
    1963.63656314551,
    1963.63656314551,
    1965.10316622257,
    1966.79578845638,
    1966.79578845638,
    1968.34927972157,
    1970.11630380522,
    1970.11630380522,
    1971.60099975297,
    1973.30676400188,
    1973.30676400188,
    1974.75997895596,
    1976.3934191188,
    1976.3934191188,
    1978.02454118857,
    1979.75597346931,
    1979.75597346931,
    1981.2245597348,
    1982.83526997289,
    1982.83526997289,
    1984.37486945764,
    1986.15510578574,
    1986.15510578574,
    1987.66006164058,
    1989.31166102215,
    1989.31166102215,
    1990.68799655594,
    1992.26698240189,
    1992.26698240189,
    1993.79516730445,
    1995.49969665024,
    1995.49969665024,
    1996.96541492614,
    1998.57570027168,
    1998.57570027168,
    2000.17156058812,
    2001.88881670647,
    2001.88881670647,
    2003.37210583341,
    2005.0253094335,
    2005.0253094335,
    2006.42741246337,
    2008.04956537238,
    2008.04956537238,
    2009.5821762024,
    2011.25948035005,
    2011.25948035005,
    2012.63447935317,
    2014.23133259948,
    2014.23133259948,
    2015.79701551102,
    2017.55130292716,
    2017.55130292716,
    2019.02556780599,
    2020.72793634688,
    2020.72793634688,
    2022.08630471622,
    2023.67628980472,
    2023.67628980472,
    2025.12564931331,
    2026.79134319779,
    2026.79134319779,
    2028.17674652762,
    2029.80546591892,
    2029.80546591892,
    2031.39204122943,
    2033.11848716596,
    2033.11848716596,
    2034.59197871309,
    2036.20852556662,
    2036.20852556662,
    2037.55986280633,
    2039.06477945836,
    2039.06477945836,
    2040.55990976227,
    2042.25104156098,
    2042.25104156098,
    2043.64813808913,
    2045.20872554306,
    2045.20872554306,
    2046.73373715775,
    2048.45191974853,
    2048.45191974853,
    2049.91612526532,
    2051.52911584081,
    2051.52911584081,
    2052.86634482341,
    2054.3554079544,
    2054.3554079544,
    2055.84091163716,
    2057.4844655828,
    2057.4844655828,
    2058.90308984714,
    2060.49474394069,
    2060.49474394069,
    2061.97017289079,
    2063.62502925794,
    2063.62502925794,
    2065.08028380354,
    2066.70169076147,
    2066.70169076147,
    2068.07451340459,
    2069.57815524698,
    2069.57815524698,
    2071.10398930506,
    2072.75495373902,
    2072.75495373902,
    2074.1102615198,
    2075.65911579652,
    2075.65911579652,
    2077.18040172177,
    2078.84371997726,
    2078.84371997726,
    2080.16433579227,
    2081.67083122016,
    2081.67083122016,
    2082.97442765798,
    2084.45601774878,
    2084.45601774878,
    2085.93020578622,
    2087.55345453766,
    2087.55345453766,
    2088.84634856452,
    2090.44809296615,
    2090.44809296615,
    2091.96113619545,
    2093.569140406,
    2093.569140406,
    2094.93917460851,
    2096.53290820005,
    2096.53290820005,
    2097.9016050669,
    2099.40891360735,
    2099.40891360735,
    2100.85530620355,
    2102.4120577818,
    2102.4120577818,
    2103.75457358013,
    2105.26200560179,
    2105.26200560179,
    2106.74560802108,
    2108.37159704685,
    2108.37159704685,
    2109.73792928375,
    2111.32189735471,
    2111.32189735471,
    2112.60560957656,
    2114.08425222452,
    2114.08425222452,
    2115.55664966626,
    2117.12480301496,
    2117.12480301496,
    2118.46920771685,
    2119.96724687697,
    2119.96724687697,
    2121.43803266807,
    2123.05731253198,
    2123.05731253198,
    2124.46915491847,
    2126.02414639922,
    2126.02414639922,
    2127.31942389642,
    2128.75474088237,
    2128.75474088237,
    2130.14350412679,
    2131.68228706451,
    2131.68228706451,
    2133.01512175296,
    2134.48308183601,
    2134.48308183601,
    2135.93271423843,
    2137.54120980508,
    2137.54120980508,
    2138.89863761558,
    2140.36502830759,
    2140.36502830759,
    2141.61939092601,
    2143.08663811736,
    2143.08663811736,
    2144.50680526901,
    2146.03109372525,
    2146.03109372525,
    2147.3783633063,
    2148.87398405844,
    2148.87398405844,
    2150.29934113678,
    2151.82954780146,
    2151.82954780146,
    2153.14955359787,
    2154.62954802048,
    2154.62954802048,
    2155.87508579383,
    2157.28502724249,
    2157.28502724249,
    2158.63846349572,
    2160.194165974,
    2160.194165974,
    2161.54811916672,
    2163.00587198033,
    2163.00587198033,
    2164.45689660262,
    2166.07195922892,
    2166.07195922892,
    2167.4008058668,
    2168.94285169778,
    2168.94285169778,
    2170.22614596153,
    2171.58673130003,
    2171.58673130003,
    2172.98231890886,
    2174.49661524086,
    2174.49661524086,
    2175.75980153186,
    2177.16541882873,
    2177.16541882873,
    2178.57747809907,
    2180.07931189674,
    2180.07931189674,
    2181.35368487172,
    2182.8696105206,
    2182.8696105206,
    2184.11537626437,
    2185.48563200629,
    2185.48563200629,
    2186.84621882026,
    2188.35872663979,
    2188.35872663979,
    2189.66947069062,
    2191.15544842372,
    2191.15544842372,
    2192.5963352043,
    2194.12484820703,
    2194.12484820703,
    2195.38931507434,
    2196.82117259585,
    2196.82117259585,
    2198.01274992484,
    2199.44927648569,
    2199.44927648569,
    2200.70477623449,
    2202.16696377115,
    2202.16696377115,
    2203.40185158241,
    2204.85780402943,
    2204.85780402943,
    2206.21968353877,
    2207.68435519573,
    2207.68435519573,
    2208.98751876791,
    2210.41297751663,
    2210.41297751663,
    2211.68520647585,
    2213.04143714816,
    2213.04143714816,
    2214.32645340193,
    2215.76983342994,
    2215.76983342994,
    2217.02678243473,
    2218.4437637731,
    2218.4437637731,
    2219.82717976316,
    2221.33149949731,
    2221.33149949731,
    2222.6051908134,
    2223.99475398488,
    2223.99475398488,
    2225.13099188347,
    2226.46368198004,
    2226.46368198004,
    2227.73618110481,
    2229.2464814096,
    2229.2464814096,
    2230.46950910827,
    2231.7829159757,
    2231.7829159757,
    2233.1644697354,
    2234.63955662902,
    2234.63955662902,
    2235.86165894383,
    2237.27240932389,
    2237.27240932389,
    2238.46585244759,
    2239.81218286467,
    2239.81218286467,
    2241.08325193669,
    2242.56602490919,
    2242.56602490919,
    2243.77475759233,
    2245.2297194774,
    2245.2297194774,
    2246.53273185698,
    2247.99222370031,
    2247.99222370031,
    2249.20853722915,
    2250.6767424585,
    2250.6767424585,
    2251.89316303487,
    2253.21165171418,
    2253.21165171418,
    2254.5128092496,
    2255.95221592443,
    2255.95221592443,
    2257.20443847084,
    2258.61106540609,
    2258.61106540609,
    2259.9211709693,
    2261.41549362812,
    2261.41549362812,
    2262.65578402303,
    2264.07134170493,
    2264.07134170493,
    2265.20413690384,
    2266.55823121735,
    2266.55823121735,
    2267.87267839212,
    2269.28278883585,
    2269.28278883585,
    2270.51789624573,
    2271.82865482623,
    2271.82865482623,
    2273.16493727342,
    2274.61187123447,
    2274.61187123447,
    2275.84687146646,
    2277.21770631931,
    2277.21770631931,
    2278.38521704568,
    2279.68744929818,
    2279.68744929818,
    2280.95497824017,
    2282.37540244947,
    2282.37540244947,
    2283.53406832799,
    2284.7877706345,
    2284.7877706345,
    2286.09083470985,
    2287.5559349728,
    2287.5559349728,
    2288.77730023076,
    2290.25788453946,
    2290.25788453946,
    2291.39294140178,
    2292.74091552411,
    2292.74091552411,
    2293.95589044088,
    2295.26551720307,
    2295.26551720307,
    2296.47995145939,
    2297.77664282801,
    2297.77664282801,
    2299.03716450877,
    2300.41170831087,
    2300.41170831087,
    2301.66307661299,
    2302.98705109354,
    2302.98705109354,
    2304.13787207771,
    2305.38143986882,
    2305.38143986882,
    2306.64369835017,
    2308.05103070025,
    2308.05103070025,
    2309.16467652887,
    2310.42140999184,
    2310.42140999184,
    2311.68549013033,
    2313.1444460763,
    2313.1444460763,
    2314.34190886969,
    2315.62703112876,
    2315.62703112876,
    2316.73537883265,
    2317.97349302456,
    2317.97349302456,
    2319.20212851872,
    2320.60902208764,
    2320.60902208764,
    2321.78167304408,
    2323.1182119249,
    2323.1182119249,
    2324.36333907461,
    2325.80185317891,
    2325.80185317891,
    2327.00660090066,
    2328.28289408158,
    2328.28289408158,
    2329.37687174435,
    2330.58928188904,
    2330.58928188904,
    2331.80792601534,
    2333.15689974608,
    2333.15689974608,
    2334.30194977076,
    2335.59989094584,
    2335.59989094584,
    2336.90886638028,
    2338.3151913258,
    2338.3151913258,
    2339.49659121789,
    2340.7463060087,
    2340.7463060087,
    2341.86732902122,
    2343.16361446951,
    2343.16361446951,
    2344.38497898772,
    2345.7259036606,
    2345.7259036606,
    2346.83002016808,
    2348.1418376824,
    2348.1418376824,
    2349.40970563227,
    2350.79394903358,
    2350.79394903358,
    2351.89963094954,
    2353.2221969587,
    2353.2221969587,
    2354.33190566567,
    2355.56339892654,
    2355.56339892654,
    2356.6505024266,
    2357.97628158297,
    2357.97628158297,
    2359.12525984573,
    2360.35366588168,
    2360.35366588168,
    2361.59782301466,
    2362.97471530067,
    2362.97471530067,
    2364.14895321657,
    2365.40563517835,
    2365.40563517835,
    2366.52318001377,
    2367.76650507893,
    2367.76650507893,
    2368.92746222636,
    2370.26019815497,
    2370.26019815497,
    2371.33723476609,
    2372.53110830442,
    2372.53110830442,
    2373.77893215316,
    2375.15881395823,
    2375.15881395823,
    2376.28156053421,
    2377.48598324438,
    2377.48598324438,
    2378.54296107617,
    2379.76844810253,
    2379.76844810253,
    2380.92925610968,
    2382.19131539216,
    2382.19131539216,
    2383.40383459896,
    2384.66076411204,
    2384.66076411204,
    2385.79515888445,
    2387.07455224416,
    2387.07455224416,
    2388.12098016991,
    2389.36034509342,
    2389.36034509342,
    2390.41465339693,
    2391.56918177128,
    2391.56918177128,
    2392.69881637811,
    2393.99162223384,
    2393.99162223384,
    2395.02621078107,
    2396.25739427225,
    2396.25739427225,
    2397.45371275144,
    2398.72044968358,
    2398.72044968358,
    2399.80312249838,
    2401.02486492067,
    2401.02486492067,
    2402.03567463371,
    2403.17886857864,
    2403.17886857864,
    2404.32010844944,
    2405.62680776363,
    2405.62680776363,
    2406.6986023882,
    2407.84061205855,
    2407.84061205855,
    2409.04501143155,
    2410.33023287766,
    2410.33023287766,
    2411.39642263066,
    2412.53657038917,
    2412.53657038917,
    2413.60383544645,
    2414.76709874808,
    2414.76709874808,
    2415.89211346542,
    2417.16294513287,
    2417.16294513287,
    2418.23857815155,
    2419.52694273009,
    2419.52694273009,
    2420.68589560709,
    2421.9774373591,
    2421.9774373591,
    2423.03290048638,
    2424.26632771142,
    2424.26632771142,
    2425.3062609918,
    2426.52348155685,
    2426.52348155685,
    2427.65425346877,
    2428.92531861422,
    2428.92531861422,
    2429.98060847543,
    2431.1574130726,
    2431.1574130726,
    2432.285555448,
    2433.50646934971,
    2433.50646934971,
    2434.56196772921,
    2435.73013805322,
    2435.73013805322,
    2436.77182210225,
    2437.94835505405,
    2437.94835505405,
    2439.10839523697,
    2440.34552199932,
    2440.34552199932,
    2441.42245155691,
    2442.58003523757,
    2442.58003523757,
    2443.71439453122,
    2444.90090893687,
    2444.90090893687,
    2446.02712642979,
    2447.19335287284,
    2447.19335287284,
    2448.24283792906,
    2449.39174765142,
    2449.39174765142,
    2450.45090377964,
    2451.65165397542,
    2451.65165397542,
    2452.6267007388,
    2453.82933626227,
    2453.82933626227,
    2454.94056136246,
    2456.13801825868,
    2456.13801825868,
    2457.15626785534,
    2458.34207543204,
    2458.34207543204,
    2459.35137780862,
    2460.4106226245,
    2460.4106226245,
    2461.49384427359,
    2462.70261068074,
    2462.70261068074,
    2463.72551288978,
    2464.87801760997,
    2464.87801760997,
    2466.04373541629,
    2467.27476659693,
    2467.27476659693,
    2468.33101821396,
    2469.45562152381,
    2469.45562152381,
    2470.39573685822,
    2471.45054520111,
    2471.45054520111,
    2472.48523116332,
    2473.62727299918,
    2473.62727299918,
    2474.61301536069,
    2475.73299527151,
    2475.73299527151,
    2476.83818502791,
    2478.07081332917,
    2478.07081332917,
    2479.09160382675,
    2480.25348544889,
    2480.25348544889,
    2481.22740111512,
    2482.27912734288,
    2482.27912734288,
    2483.33409918809,
    2484.55387012303,
    2484.55387012303,
    2485.52295203992,
    2486.65672573325,
    2486.65672573325,
    2487.69498862825,
    2488.92256458971,
    2488.92256458971,
    2489.87146546317,
    2491.03094185414,
    2491.03094185414,
    2491.93782111653,
    2492.9789616708,
    2492.9789616708,
    2494.01807794868,
    2495.14657292796,
    2495.14657292796,
    2496.1300599385,
    2497.26891124814,
    2497.26891124814,
    2498.32532373188,
    2499.54212118846,
    2499.54212118846,
    2500.61511057069,
    2501.69921169067,
    2501.69921169067,
    2502.68902988104,
    2503.72504585081,
    2503.72504585081,
    2504.81174732156,
    2505.97223234897,
    2505.97223234897,
    2506.92851374204,
    2508.01964286141,
    2508.01964286141,
    2509.1314905975,
    2510.36474159102,
    2510.36474159102,
    2511.38259569082,
    2512.47981753175,
    2512.47981753175,
    2513.45358272466,
    2514.50037937577,
    2514.50037937577,
    2515.55508063754,
    2516.64026041094,
    2516.64026041094,
    2517.57395856366,
    2518.68211363268,
    2518.68211363268,
    2519.73668012284,
    2520.96727210064,
    2520.96727210064,
    2521.93636978097,
    2523.02618667594,
    2523.02618667594,
    2523.87862103648,
    2524.96280581478,
    2524.96280581478,
    2526.00082535464,
    2527.06279016426,
    2527.06279016426,
    2528.01608825825,
    2529.01502378753,
    2529.01502378753,
    2530.0435534906,
    2531.22180688337,
    2531.22180688337,
    2532.19551559585,
    2533.29510007579,
    2533.29510007579,
    2534.17929255392,
    2535.20592424296,
    2535.20592424296,
    2536.20578112443,
    2537.32122637253,
    2537.32122637253,
    2538.24075228796,
    2539.27556016606,
    2539.27556016606,
    2540.28342770945,
    2541.38995278383,
    2541.38995278383,
    2542.37498066703,
    2543.43645877475,
    2543.43645877475,
    2544.28207025852,
    2545.36693437032,
    2545.36693437032,
    2546.38399839683,
    2547.41312261614,
    2547.41312261614,
    2548.2690954777,
    2549.25798669537,
    2549.25798669537,
    2550.22932822116,
    2551.35217892262,
    2551.35217892262,
    2552.28820737844,
    2553.38222438006,
    2553.38222438006,
    2554.28543964151,
    2555.26930273957,
    2555.26930273957,
    2556.15795328309,
    2557.21884805634,
    2557.21884805634,
    2558.09931854231,
    2559.19202708201,
    2559.19202708201,
    2560.12278353662,
    2561.1960290631,
    2561.1960290631,
    2562.1607924968,
    2563.19694214159,
    2563.19694214159,
    2564.08439694066,
    2565.06751004551,
    2565.06751004551,
    2566.04623148785,
    2567.09152986324,
    2567.09152986324,
    2567.94016100508,
    2568.99071543206,
    2568.99071543206,
    2569.97025062935,
    2571.02175656546,
    2571.02175656546,
    2571.91105547514,
    2572.92819133554,
    2572.92819133554,
    2573.76832472187,
    2574.77151389803,
    2574.77151389803,
    2575.70878691329,
    2576.80847613196,
    2576.80847613196,
    2577.66304430299,
    2578.69677859443,
    2578.69677859443,
    2579.67340026183,
    2580.71894731052,
    2580.71894731052,
    2581.69157441775,
    2582.73239916763,
    2582.73239916763,
    2583.569121384,
    2584.51118378032,
    2584.51118378032,
    2585.46888689307,
    2586.52468300556,
    2586.52468300556,
    2587.39744272585,
    2588.44263139409,
    2588.44263139409,
    2589.4826272955,
    2590.51921664568,
    2590.51921664568,
    2591.38343786205,
    2592.39527712899,
    2592.39527712899,
    2593.23682521613,
    2594.24891144401,
    2594.24891144401,
    2595.14401174782,
    2596.17768372708,
    2596.17768372708,
    2597.079294567,
    2598.10331914237,
    2598.10331914237,
    2599.07299241104,
    2600.11537665722,
    2600.11537665722,
    2601.00025760937,
    2602.023412843,
    2602.023412843,
    2602.87813114481,
    2603.87443858084,
    2603.87443858084,
    2604.81441436609,
    2605.80880047011,
    2605.80880047011,
    2606.67857505798,
    2607.58012722243,
    2607.58012722243,
    2608.47561098555,
    2609.53147179011,
    2609.53147179011,
    2610.36112696061,
    2611.32922676906,
    2611.32922676906,
    2612.11507207775,
    2613.08719308189,
    2613.08719308189,
    2613.97477491629,
    2614.95366329908,
    2614.95366329908,
    2615.76281333663,
    2616.68455035398,
    2616.68455035398,
    2617.49694248834,
    2618.47288274612,
    2618.47288274612,
    2619.33008443857,
    2620.30680313363,
    2620.30680313363,
    2621.0880897273,
    2621.96892452279,
    2621.96892452279,
    2622.79550639639,
    2623.76027447826,
    2623.76027447826,
    2624.63629907654,
    2625.56731644495,
    2625.56731644495,
    2626.4975874459,
    2627.58527778578,
    2627.58527778578,
    2628.44359384484,
    2629.45281912296,
    2629.45281912296,
    2630.28354442005,
    2631.13488128284,
    2631.13488128284,
    2632.05572190653,
    2632.98114644076,
    2632.98114644076,
    2633.7687633157,
    2634.72786002348,
    2634.72786002348,
    2635.67143950843,
    2636.67729388373,
    2636.67729388373,
    2637.51233189631,
    2638.42600278216,
    2638.42600278216,
    2639.23358773237,
    2640.03343822754,
    2640.03343822754,
    2640.85002734418,
    2641.81903973199,
    2641.81903973199,
    2642.61330467773,
    2643.47567341199,
    2643.47567341199,
    2644.3041008268,
    2645.25151136555,
    2645.25151136555,
    2646.15290735823,
    2647.02677989725,
    2647.02677989725,
    2647.82702885598,
    2648.6690046443,
    2648.6690046443,
    2649.50933162053,
    2650.50377726412,
    2650.50377726412,
    2651.28519624884,
    2652.17793309132,
    2652.17793309132,
    2653.05296843622,
    2654.08284719269,
    2654.08284719269,
    2654.88320833904,
    2655.82824119601,
    2655.82824119601,
    2656.5357017405,
    2657.40652065303,
    2657.40652065303,
    2658.2321593741,
    2659.14482083485,
    2659.14482083485,
    2659.90317724099,
    2660.82501847461,
    2660.82501847461,
    2661.59806494591,
    2662.56590090688,
    2662.56590090688,
    2663.36914608135,
    2664.27846822902,
    2664.27846822902,
    2665.0942071967,
    2665.94597540177,
    2665.94597540177,
    2666.77394645409,
    2667.64762442674,
    2667.64762442674,
    2668.45874216358,
    2669.30264498752,
    2669.30264498752,
    2670.12408750543,
    2671.12294606956,
    2671.12294606956,
    2671.95768408542,
    2672.83103765706,
    2672.83103765706,
    2673.53567758358,
    2674.47452147216,
    2674.47452147216,
    2675.31758117612,
    2676.17945891311,
    2676.17945891311,
    2677.03703666031,
    2677.90028402986,
    2677.90028402986,
    2678.77233800325,
    2679.70910125276,
    2679.70910125276,
    2680.5692636213,
    2681.42523456382,
    2681.42523456382,
    2682.17679108271,
    2683.06561488969,
    2683.06561488969,
    2683.87393285385,
    2684.73752250106,
    2684.73752250106,
    2685.50460310738,
    2686.33639042285,
    2686.33639042285,
    2687.17957106521,
    2688.04019674034,
    2688.04019674034,
    2688.83853546682,
    2689.63954587886,
    2689.63954587886,
    2690.43338315594,
    2691.29586303573,
    2691.29586303573,
    2692.07049595674,
    2692.97802006773,
    2692.97802006773,
    2693.74160284471,
    2694.6232148984,
    2694.6232148984,
    2695.47925527752,
    2696.39410549572,
    2696.39410549572,
    2697.15080477631,
    2698.06845948219,
    2698.06845948219,
    2698.75352912267,
    2699.66741080819,
    2699.66741080819,
    2700.48054621922,
    2701.37320516705,
    2701.37320516705,
    2702.09793273474,
    2702.92062093091,
    2702.92062093091,
    2703.73204794888,
    2704.69320542016,
    2704.69320542016,
    2705.42508025293,
    2706.33699511794,
    2706.33699511794,
    2707.04554233312,
    2707.83530664405,
    2707.83530664405,
    2708.55205151165,
    2709.44300817631,
    2709.44300817631,
    2710.16461107045,
    2710.9757489162,
    2710.9757489162,
    2711.7832258979,
    2712.61918768231,
    2712.61918768231,
    2713.38907132762,
    2714.20792736735,
    2714.20792736735,
    2714.86093465044,
    2715.70540063192,
    2715.70540063192,
    2716.46552790873,
    2717.3636314921,
    2717.3636314921,
    2718.04570071829,
    2718.88251281138,
    2718.88251281138,
    2719.63359791812,
    2720.51881731832,
    2720.51881731832,
    2721.24627745046,
    2722.10579796148,
    2722.10579796148,
    2722.7877269395,
    2723.53622910325,
    2723.53622910325,
    2724.26799311408,
    2725.11995807042,
    2725.11995807042,
    2725.82863160369,
    2726.63341284064,
    2726.63341284064,
    2727.36471794485,
    2728.24995284946,
    2728.24995284946,
    2728.97699328744,
    2729.79585310189,
    2729.79585310189,
    2730.48748456883,
    2731.24787939793,
    2731.24787939793,
    2732.02972991194,
    2732.8578610098,
    2732.8578610098,
    2733.58132159444,
    2734.45669959556,
    2734.45669959556,
    2735.22256179422,
    2736.01110581,
    2736.01110581,
    2736.72556031986,
    2737.52344570556,
    2737.52344570556,
    2738.11741915127,
    2738.85876318836,
    2738.85876318836,
    2739.64859093825,
    2740.48652777078,
    2740.48652777078,
    2741.20008527254,
    2741.94795911019,
    2741.94795911019,
    2742.71113997372,
    2743.56746202605,
    2743.56746202605,
    2744.24019879651,
    2745.07275230656,
    2745.07275230656,
    2745.72197688406,
    2746.53611392498,
    2746.53611392498,
    2747.30210893237,
    2748.13219440674,
    2748.13219440674,
    2748.88766487692,
    2749.60095145122,
    2749.60095145122,
    2750.3441783401,
    2751.19204205343,
    2751.19204205343,
    2751.84989542733,
    2752.62787662372,
    2752.62787662372,
    2753.30614447404,
    2754.09497613496,
    2754.09497613496,
    2754.81991712394,
    2755.61053377193,
    2755.61053377193,
    2756.20491523147,
    2756.87844822692,
    2756.87844822692,
    2757.57200613352,
    2758.4126428501,
    2758.4126428501,
    2759.09477105845,
    2759.81888209248,
    2759.81888209248,
    2760.44174856376,
    2761.17787327341,
    2761.17787327341,
    2761.84913570062,
    2762.62386644707,
    2762.62386644707,
    2763.29281546761,
    2763.96445881415,
    2763.96445881415,
    2764.6512854968,
    2765.42269502571,
    2765.42269502571,
    2766.1286172319,
    2766.90128637291,
    2766.90128637291,
    2767.53718859764,
    2768.23158916498,
    2768.23158916498,
    2768.86580424459,
    2769.68858390552,
    2769.68858390552,
    2770.33205853824,
    2771.10490366815,
    2771.10490366815,
    2771.84647765844,
    2772.62657095981,
    2772.62657095981,
    2773.33197716346,
    2774.02017928617,
    2774.02017928617,
    2774.57568366588,
    2775.35443974084,
    2775.35443974084,
    2776.07835829861,
    2776.80667886322,
    2776.80667886322,
    2777.51522161059,
    2778.26874442977,
    2778.26874442977,
    2778.95778772384,
    2779.70281785472,
    2779.70281785472,
    2780.37874741716,
    2781.10439775424,
    2781.10439775424,
    2781.72222835269,
    2782.42764718026,
    2782.42764718026,
    2783.0963899547,
    2783.87118957288,
    2783.87118957288,
    2784.54347801354,
    2785.23761149279,
    2785.23761149279,
    2785.87312507448,
    2786.5757249977,
    2786.5757249977,
    2787.26692180183,
    2788.00514065256,
    2788.00514065256,
    2788.60989052642,
    2789.31035828464,
    2789.31035828464,
    2790.04230185775,
    2790.74807251036,
    2790.74807251036,
    2791.31033783602,
    2792.0043390703,
    2792.0043390703,
    2792.67997500388,
    2793.42088955811,
    2793.42088955811,
    2794.08884760318,
    2794.79071322647,
    2794.79071322647,
    2795.3349223292,
    2796.05313895712,
    2796.05313895712,
    2796.7690082164,
    2797.48712857048,
    2797.48712857048,
    2798.05806656217,
    2798.66684308203,
    2798.66684308203,
    2799.35784527319,
    2800.10259512312,
    2800.10259512312,
    2800.72787136682,
    2801.50197826884,
    2801.50197826884,
    2802.05339342095,
    2802.69090785689,
    2802.69090785689,
    2803.32668956283,
    2804.06204755109,
    2804.06204755109,
    2804.67331648305,
    2805.37389421298,
    2805.37389421298,
    2806.0049013334,
    2806.74236332051,
    2806.74236332051,
    2807.31957176035,
    2808.02716463006,
    2808.02716463006,
    2808.55434179277,
    2809.19775202912,
    2809.19775202912,
    2809.83895953015,
    2810.55014962594,
    2810.55014962594,
    2811.11944157417,
    2811.80137494493,
    2811.80137494493,
    2812.46627381921,
    2813.18470411736,
    2813.18470411736,
    2813.75264561206,
    2814.45694594438,
    2814.45694594438,
    2815.00514718047,
    2815.66935220626,
    2815.66935220626,
    2816.30840841012,
    2817.05687848631,
    2817.05687848631,
    2817.59710985209,
    2818.23891526166,
    2818.23891526166,
    2818.86732804554,
    2819.59501052744,
    2819.59501052744,
    2820.23720765347,
    2820.94289056365,
    2820.94289056365,
    2821.52750817324,
    2822.10606990114,
    2822.10606990114,
    2822.74836111768,
    2823.51206265653,
    2823.51206265653,
    2824.09890886075,
    2824.78405825687,
    2824.78405825687,
    2825.42211818835,
    2826.11500613398,
    2826.11500613398,
    2826.71920953486,
    2827.40588380364,
    2827.40588380364,
    2827.99559721797,
    2828.68569589343,
    2828.68569589343,
    2829.27997922803,
    2829.93313505633,
    2829.93313505633,
    2830.46757789839,
    2831.10465617587,
    2831.10465617587,
    2831.7894549018,
    2832.41913987513,
    2832.41913987513,
    2832.99237794157,
    2833.53566502281,
    2833.53566502281,
    2834.1159893698,
    2834.72010691712,
    2834.72010691712,
    2835.28807028283,
    2835.93957818424,
    2835.93957818424,
    2836.50181444245,
    2837.16293774775,
    2837.16293774775,
    2837.77823684513,
    2838.51403282228,
    2838.51403282228,
    2839.17313013825,
    2839.8654342712,
    2839.8654342712,
    2840.41216585816,
    2841.02654634611,
    2841.02654634611,
    2841.62538888113,
    2842.27616066096,
    2842.27616066096,
    2842.82631031163,
    2843.43079717677,
    2843.43079717677,
    2844.02437494989,
    2844.65850238778,
    2844.65850238778,
    2845.1969102983,
    2845.80876390802,
    2845.80876390802,
    2846.35062164402,
    2846.9283110072,
    2846.9283110072,
    2847.42107341804,
    2848.07136511589,
    2848.07136511589,
    2848.58100777507,
    2849.21704060454,
    2849.21704060454,
    2849.74670235032,
    2850.43767202962,
    2850.43767202962,
    2850.99191616992,
    2851.58674767459,
    2851.58674767459,
    2852.14345439701,
    2852.69619950377,
    2852.69619950377,
    2853.27703205867,
    2853.92770715873,
    2853.92770715873,
    2854.4751842343,
    2855.06282454564,
    2855.06282454564,
    2855.65216144868,
    2856.26678219453,
    2856.26678219453,
    2856.75504923131,
    2857.38629734723,
    2857.38629734723,
    2857.87713650536,
    2858.49469129028,
    2858.49469129028,
    2858.95653571118,
    2859.56223099527,
    2859.56223099527,
    2860.04268094016,
    2860.59278470947,
    2860.59278470947,
    2861.16491510138,
    2861.83370445449,
    2861.83370445449,
    2862.39348213081,
    2863.01372629911,
    2863.01372629911,
    2863.4962628507,
    2864.05904294544,
    2864.05904294544,
    2864.57308721186,
    2865.11951801518,
    2865.11951801518,
    2865.59542380485,
    2866.17781419921,
    2866.17781419921,
    2866.64850954082,
    2867.22664282431,
    2867.22664282431,
    2867.761237228,
    2868.30000277411,
    2868.30000277411,
    2868.80205313607,
    2869.41370395643,
    2869.41370395643,
    2869.96047089848,
    2870.56667986646,
    2870.56667986646,
    2871.01076182615,
    2871.5886587659,
    2871.5886587659,
    2872.10303673182,
    2872.70543272013,
    2872.70543272013,
    2873.18145077366,
    2873.77254356756,
    2873.77254356756,
    2874.21601258421,
    2874.71842373903,
    2874.71842373903,
    2875.20887250264,
    2875.82119649178,
    2875.82119649178,
    2876.28413000043,
    2876.89971254179,
    2876.89971254179,
    2877.40768887567,
    2878.02025142185,
    2878.02025142185,
    2878.47067036175,
    2879.03162959181,
    2879.03162959181,
    2879.46908912348,
    2880.03548975855,
    2880.03548975855,
    2880.60097755464,
    2881.16765513529,
    2881.16765513529,
    2881.67628383381,
    2882.22129512972,
    2882.22129512972,
    2882.74980393686,
    2883.31308004713,
    2883.31308004713,
    2883.79934799785,
    2884.30086264568,
    2884.30086264568,
    2884.65504888603,
    2885.14176344714,
    2885.14176344714,
    2885.66404824999,
    2886.1476831828,
    2886.1476831828,
    2886.65581577418,
    2887.16567820708,
    2887.16567820708,
    2887.64064320809,
    2888.2126809566,
    2888.2126809566,
    2888.71366404718,
    2889.2765965433,
    2889.2765965433,
    2889.66451859477,
    2890.14480863999,
    2890.14480863999,
    2890.59712044373,
    2891.14426068455,
    2891.14426068455,
    2891.5848302039,
    2892.18549845521,
    2892.18549845521,
    2892.69161305755,
    2893.23912724389,
    2893.23912724389,
    2893.71938422278,
    2894.24679132133,
    2894.24679132133,
    2894.65556900942,
    2895.16965493609,
    2895.16965493609,
    2895.69197101654,
    2896.2373634831,
    2896.2373634831,
    2896.68448517987,
    2897.23000261365,
    2897.23000261365,
    2897.71831227187,
    2898.27856470352,
    2898.27856470352,
    2898.74702304167,
    2899.20701712076,
    2899.20701712076,
    2899.61116235158,
    2900.06053168256,
    2900.06053168256,
    2900.47773567636,
    2900.92317556025,
    2900.92317556025,
    2901.38290875957,
    2901.91544936013,
    2901.91544936013,
    2902.47116236006,
    2903.02023904644,
    2903.02023904644,
    2903.49479112609,
    2904.04292794661,
    2904.04292794661,
    2904.48470638925,
    2904.90562894243,
    2904.90562894243,
    2905.40078128034,
    2905.93786015021,
    2905.93786015021,
    2906.43632661773,
    2906.89472150203,
    2906.89472150203,
    2907.40349301444,
    2908.0173579356,
    2908.0173579356,
    2908.46770458109,
    2908.94640733814,
    2908.94640733814,
    2909.38154624541,
    2909.82223708208,
    2909.82223708208,
    2910.30217655931,
    2910.83407238265,
    2910.83407238265,
    2911.24984350766,
    2911.67944371947,
    2911.67944371947,
    2912.16186166614,
    2912.58976459212,
    2912.58976459212,
    2913.00533186485,
    2913.47853276211,
    2913.47853276211,
    2913.78795952456,
    2914.24295316703,
    2914.24295316703,
    2914.65986255012,
    2915.17757396636,
    2915.17757396636,
    2915.60477058477,
    2916.08887488339,
    2916.08887488339,
    2916.47132405466,
    2916.94359360838,
    2916.94359360838,
    2917.35714839579,
    2917.80730151248,
    2917.80730151248,
    2918.21142268738,
    2918.66365818544,
    2918.66365818544,
    2919.01061806871,
    2919.5687483578,
    2919.5687483578,
    2920.01330057788,
    2920.46419034423,
    2920.46419034423,
    2920.93577773098,
    2921.52325980967,
    2921.52325980967,
    2921.98099544856,
    2922.499582792,
    2922.499582792,
    2922.89599552133,
    2923.36333422858,
    2923.36333422858,
    2923.82917850178,
    2924.28256147511,
    2924.28256147511,
    2924.64316614635,
    2925.12067323571,
    2925.12067323571,
    2925.53074390921,
    2926.01838763733,
    2926.01838763733,
    2926.40242244749,
    2926.81700609653,
    2926.81700609653,
    2927.22678229357,
    2927.58663453684,
    2927.58663453684,
    2928.00147998584,
    2928.46835560347,
    2928.46835560347,
    2928.87144891214,
    2929.32381689924,
    2929.32381689924,
    2929.71392024351,
    2930.19963559543,
    2930.19963559543,
    2930.60279954987,
    2931.02650429023,
    2931.02650429023,
    2931.41037192972,
    2931.83194050774,
    2931.83194050774,
    2932.2867392571,
    2932.75846847234,
    2932.75846847234,
    2933.09065386394,
    2933.5589026792,
    2933.5589026792,
    2934.03041210842,
    2934.46279916433,
    2934.46279916433,
    2934.80193649971,
    2935.27479709954,
    2935.27479709954,
    2935.60424361638,
    2935.87892787503,
    2935.87892787503,
    2936.27510724345,
    2936.70165164908,
    2936.70165164908,
    2937.02837537987,
    2937.43413694546,
    2937.43413694546,
    2937.89670909083,
    2938.25436410332,
    2938.25436410332,
    2938.62390248228,
    2939.06702667454,
    2939.06702667454,
    2939.4094300407,
    2939.74995557447,
    2939.74995557447,
    2940.12946222502,
    2940.50670473941,
    2940.50670473941,
    2940.88449986517,
    2941.28364010337,
    2941.28364010337,
    2941.59246841618,
    2942.00061225163,
    2942.00061225163,
    2942.39765084191,
    2942.80116014083,
    2942.80116014083,
    2943.15811296785,
    2943.61276388039,
    2943.61276388039,
    2943.98450755083,
    2944.41141166144,
    2944.41141166144,
    2944.79547518789,
    2945.12651117466,
    2945.12651117466,
    2945.50601920545,
    2945.85401178447,
    2945.85401178447,
    2946.20595611206,
    2946.58234572428,
    2946.58234572428,
    2946.89756127293,
    2947.31652279779,
    2947.31652279779,
    2947.76274201446,
    2948.14764163016,
    2948.14764163016,
    2948.48580761568,
    2948.8350535427,
    2948.8350535427,
    2949.2390576209,
    2949.67566042519,
    2949.67566042519,
    2949.9921281306,
    2950.3974422124,
    2950.3974422124,
    2950.75344915784,
    2951.06878141107,
    2951.06878141107,
    2951.30445756981,
    2951.71339697001,
    2951.71339697001,
    2952.05614838732,
    2952.40967246266,
    2952.40967246266,
    2952.82823699551,
    2953.19365182619,
    2953.19365182619,
    2953.54343407665,
    2953.90309142724,
    2953.90309142724,
    2954.1574369812,
    2954.47873881826,
    2954.47873881826,
    2954.846061606,
    2955.21978179585,
    2955.21978179585,
    2955.50370509765,
    2955.91704247567,
    2955.91704247567,
    2956.27082436518,
    2956.67537586139,
    2956.67537586139,
    2957.11061440044,
    2957.43019028955,
    2957.43019028955,
    2957.81026551444,
    2958.16849209074,
    2958.16849209074,
    2958.53430511656,
    2958.86936901354,
    2958.86936901354,
    2959.16688526509,
    2959.49176475537,
    2959.49176475537,
    2959.82527916938,
    2960.21180370926,
    2960.21180370926,
    2960.52400081698,
    2960.88558299691,
    2960.88558299691,
    2961.16709441046,
    2961.49129899186,
    2961.49129899186,
    2961.78825381242,
    2962.170258609,
    2962.170258609,
    2962.42697996589,
    2962.75290118242,
    2962.75290118242,
    2963.14977283725,
    2963.47254720051,
    2963.47254720051,
    2963.72766708623,
    2964.126870172,
    2964.126870172,
    2964.44322628496,
    2964.77099297673,
    2964.77099297673,
    2965.05682850505,
    2965.4083711025,
    2965.4083711025,
    2965.65111569323,
    2965.9276956026,
    2965.9276956026,
    2966.19901515664,
    2966.55040712127,
    2966.55040712127,
    2966.85875599882,
    2967.22637327674,
    2967.22637327674,
    2967.44924898241,
    2967.74681755512,
    2967.74681755512,
    2968.11090021914,
    2968.4194426658,
    2968.4194426658,
    2968.68356758116,
    2968.92851027749,
    2968.92851027749,
    2969.17774410598,
    2969.51587177375,
    2969.51587177375,
    2969.81630993068,
    2970.12509531469,
    2970.12509531469,
    2970.49064313295,
    2970.83771749802,
    2970.83771749802,
    2971.19799123086,
    2971.55614669662,
    2971.55614669662,
    2971.83797022889,
    2972.18602160042,
    2972.18602160042,
    2972.57309085457,
    2972.90261320253,
    2972.90261320253,
    2973.23066975734,
    2973.50744205791,
    2973.50744205791,
    2973.77503922512,
    2974.12940068714,
    2974.12940068714,
    2974.43455307962,
    2974.86911852749,
    2974.86911852749,
    2975.13407955398,
    2975.38760675854,
    2975.38760675854,
    2975.67248334106,
    2975.95080722299,
    2975.95080722299,
    2976.17577518643,
    2976.54630574227,
    2976.54630574227,
    2976.78416692125,
    2977.08116980815,
    2977.08116980815,
    2977.34616748491,
    2977.63395788633,
    2977.63395788633,
    2977.8906332795,
    2978.17257538119,
    2978.17257538119,
    2978.51240395485,
    2978.73686920408,
    2978.73686920408,
    2978.95347019174,
    2979.18073629456,
    2979.18073629456,
    2979.41893802659,
    2979.69651460604,
    2979.69651460604,
    2980.03742989268,
    2980.37223542814,
    2980.37223542814,
    2980.51027434636,
    2980.76996839399,
    2980.76996839399,
    2981.08097089549,
    2981.35025793236,
    2981.35025793236,
    2981.47020520725,
    2981.77411448227,
    2981.77411448227,
    2982.05542495725,
    2982.40410827874,
    2982.40410827874,
    2982.69343255955,
    2983.01286096971,
    2983.01286096971,
    2983.21886732791,
    2983.53776088882,
    2983.53776088882,
    2983.82727993668,
    2984.04662983003,
    2984.04662983003,
    2984.30012506085,
    2984.56827151955,
    2984.56827151955,
    2984.75860556674,
    2984.91547729158,
    2984.91547729158,
    2985.1212570797,
    2985.45053556923,
    2985.45053556923,
    2985.71276180649,
    2986.01907350225,
    2986.01907350225,
    2986.26904095641,
    2986.51832345217,
    2986.51832345217,
    2986.71142859923,
    2986.93830087565,
    2986.93830087565,
    2987.16344079901,
    2987.40013562894,
    2987.40013562894,
    2987.70902599576,
    2987.8733993997,
    2987.8733993997,
    2988.1366552949,
    2988.393010899,
    2988.393010899,
    2988.71653144833,
    2988.94808246901,
    2988.94808246901,
    2989.12946264874,
    2989.31314713981,
    2989.31314713981,
    2989.49295975431,
    2989.71203265499,
    2989.71203265499,
    2989.97387592587,
    2990.1864989934,
    2990.1864989934,
    2990.41590602666,
    2990.76583031039,
    2990.76583031039,
    2990.93063173956,
    2991.16853212316,
    2991.16853212316,
    2991.3484249353,
    2991.53049900344,
    2991.53049900344,
    2991.65115495149,
    2991.81372792333,
    2991.81372792333,
    2992.10079668118,
    2992.31823847792,
    2992.31823847792,
    2992.51774543527,
    2992.61850376749,
    2992.61850376749,
    2992.84813841927,
    2993.06779927307,
    2993.06779927307,
    2993.310246652,
    2993.5991622074,
    2993.5991622074,
    2993.77449646754,
    2993.97471999211,
    2993.97471999211,
    2994.21013869925,
    2994.40259788969,
    2994.40259788969,
    2994.61740534328,
    2994.91359736266,
    2994.91359736266,
    2995.15082488542,
    2995.33790600847,
    2995.33790600847,
    2995.5077108847,
    2995.68492322023,
    2995.68492322023,
    2995.92409731982,
    2996.13824957813,
    2996.13824957813,
    2996.31623002667,
    2996.54718745891,
    2996.54718745891,
    2996.68873048474,
    2997.10413941954,
    2997.10413941954,
    2997.31335113321,
    2997.53619567333,
    2997.53619567333,
    2997.63990877226,
    2997.94510846671,
    2997.94510846671,
    2998.05531422464,
    2998.28018944738,
    2998.28018944738,
    2998.33483233843,
    2998.60981056207,
    2998.60981056207,
    2998.71456388153,
    2998.86746332241,
    2998.86746332241,
    2998.963102177,
    2999.13651706835,
    2999.13651706835,
    2999.32494488494,
    2999.46371416812,
    2999.46371416812,
    2999.540765388,
    2999.69052162418,
    2999.69052162418,
    2999.88525550116,
    3000.04044696195,
    3000.04044696195,
    3000.14983480247,
    3000.36838299501,
    3000.36838299501,
    3000.5821754773,
    3000.83657609726,
    3000.83657609726,
    3000.87334466419,
    3001.12573783799,
    3001.12573783799,
    3001.39063975908,
    3001.64688373805,
    3001.64688373805,
    3001.81305167275,
    3002.01623997903,
    3002.01623997903,
    3002.11328738107,
    3002.1484600605,
    3002.1484600605,
    3002.26807392943,
    3002.42543626299,
    3002.42543626299,
    3002.57237680976,
    3002.82532334076,
    3002.82532334076,
    3002.88008936942,
    3003.05111312788,
    3003.05111312788,
    3003.1445806531,
    3003.2806087051,
    3003.2806087051,
    3003.46987705382,
    3003.65537760032,
    3003.65537760032,
    3003.87835187178,
    3004.065393666,
    3004.065393666,
    3004.24604164465,
    3004.4981398168,
    3004.4981398168,
    3004.68159033537,
    3005.00395143957,
    3005.00395143957,
    3005.22006949633,
    3005.46435509013,
    3005.46435509013,
    3005.59339169268,
    3005.67642528695,
    3005.67642528695,
    3005.8105728983,
    3005.99011783316,
    3005.99011783316,
    3006.29874623337,
    3006.47309620821,
    3006.47309620821,
    3006.51278054829,
    3006.74338039195,
    3006.74338039195,
    3006.89153348626,
    3007.12521074295,
    3007.12521074295,
    3007.12735263202,
    3007.24042119198,
    3007.24042119198,
    3007.35332672117,
    3007.5656331092,
    3007.5656331092,
    3007.62137737418,
    3007.82229974611,
    3007.82229974611,
    3008.02378477429,
    3008.10739691525,
    3008.10739691525,
    3008.20777660898,
    3008.43563784906,
    3008.43563784906,
    3008.664147353,
    3008.90365079272,
    3008.90365079272,
    3008.94078403295,
    3009.2250642405,
    3009.2250642405,
    3009.37384625123,
    3009.47566286246,
    3009.47566286246,
    3009.52934617275,
    3009.64412488495,
    3009.64412488495,
    3009.67703876396,
    3009.84494658881,
    3009.84494658881,
    3009.97053531353,
    3010.09097039827,
    3010.09097039827,
    3010.24223049147,
    3010.30833547374,
    3010.30833547374,
    3010.4257668093,
    3010.43012504945,
    3010.43012504945,
    3010.55246537742,
    3010.73204559382,
    3010.73204559382,
    3010.9853164165,
    3011.06257265054,
    3011.06257265054,
    3011.09158027982,
    3011.30172762398,
    3011.30172762398,
    3011.38482274593,
    3011.51047376789,
    3011.51047376789,
    3011.50210842355,
    3011.61809647809,
    3011.61809647809,
    3011.76063494119,
    3011.91633740044,
    3011.91633740044,
    3012.07766805367,
    3012.31455141646,
    3012.31455141646,
    3012.46948230458,
    3012.52093318974,
    3012.52093318974,
    3012.66110267406,
    3012.79006506904,
    3012.79006506904,
    3012.86206315269,
    3013.05982165156,
    3013.05982165156,
    3013.24640956474,
    3013.40550613314,
    3013.40550613314,
    3013.5042073307,
    3013.53795138369,
    3013.53795138369,
    3013.60485685861,
    3013.59300864578,
    3013.59300864578,
    3013.67456130363,
    3013.83644930235,
    3013.83644930235,
    3013.91812024293,
    3013.93373427815,
    3013.93373427815,
    3014.17129437744,
    3014.2151280337,
    3014.2151280337,
    3014.15919210925,
    3014.22200853814,
    3014.22200853814,
    3014.25605239141,
    3014.24459964461,
    3014.24459964461,
    3014.2519375223,
    3014.39204836503,
    3014.39204836503,
    3014.46395328412,
    3014.52624089755,
    3014.52624089755,
    3014.60461612701,
    3014.73326067927,
    3014.73326067927,
    3014.78372373426,
    3014.86459355385,
    3014.86459355385,
    3014.93561029715,
    3015.00061193934,
    3015.00061193934,
    3015.14440531922,
    3015.30235212881,
    3015.30235212881,
    3015.40993898807,
    3015.54050871161,
    3015.54050871161,
    3015.60360671249,
    3015.78648870523,
    3015.78648870523,
    3015.88601071506,
    3015.8808752231,
    3015.8808752231,
    3015.94248426198,
    3016.03332361798,
    3016.03332361798,
    3016.06512391218,
    3016.10592103754,
    3016.10592103754,
    3016.28463311628,
    3016.39095839733,
    3016.39095839733,
    3016.47522596195,
    3016.59413077777,
    3016.59413077777,
    3016.69097263973,
    3016.74671021127,
    3016.74671021127,
    3016.70541227986,
    3016.80920266686,
    3016.80920266686,
    3016.83511382821,
    3016.89210290763,
    3016.89210290763,
    3017.02472441441,
    3017.20937273566,
    3017.20937273566,
    3017.24487868422,
    3017.27751137965,
    3017.27751137965,
    3017.3764779314,
    3017.53630440942,
    3017.53630440942,
    3017.72803869662,
    3017.63574140676,
    3017.63574140676,
    3017.6407333759,
    3017.71629899987,
    3017.71629899987,
    3017.80658211839,
    3018.00766260746,
    3018.00766260746,
    3018.08614725893,
    3018.14521665165,
    3018.14521665165,
    3018.25853408005,
    3018.30322645444,
    3018.30322645444,
    3018.35082777379,
    3018.44530244433,
    3018.44530244433,
    3018.42055884133,
    3018.42607573744,
    3018.42607573744,
    3018.45621629235,
    3018.44543963906,
    3018.44543963906,
    3018.43204925752,
    3018.47247675403,
    3018.47247675403,
    3018.47985404858,
    3018.55030491252,
    3018.55030491252,
    3018.60176000955,
    3018.62071283952,
    3018.62071283952,
    3018.6862376289,
    3018.68482698859,
    3018.68482698859,
    3018.66177729801,
    3018.67675792623,
    3018.67675792623,
    3018.7431520714,
    3018.7522466993,
    3018.7522466993,
    3018.7286417783,
    3018.75656463725,
    3018.75656463725,
    3018.93293370226,
    3018.96907831228,
    3018.96907831228,
    3018.90853301188,
    3018.98682101525,
    3018.98682101525,
    3018.94507143068,
    3019.01377419202,
    3019.01377419202,
    3019.07026191203,
    3019.10931327622,
    3019.10931327622,
    3019.07062804928,
    3019.05663911542,
};

static const std::vector<float> Vz = {
    -0,
    -0.0894839501660423,
    -0.169235839897608,
    -0,
    -0.0747280437479634,
    -0.143731472968402,
    -0,
    -0.061538801741211,
    -0.115792482861415,
    -0.115792482861415,
    -0.160063519557992,
    -0.183245125590776,
    -0.183245125590776,
    -0.165079690681168,
    -0.0747799156558606,
    -0.0747799156558606,
    0.09552880947162,
    0.341685642676658,
    0.341685642676658,
    0.655376168355276,
    1.01295293424645,
    1.01295293424645,
    1.39953209994033,
    1.80322688258518,
    1.80322688258518,
    2.22686886068573,
    2.66559462868992,
    2.66559462868992,
    3.04577601827492,
    3.41640308048573,
    3.41640308048573,
    3.89494782581983,
    4.39065308822068,
    4.39065308822068,
    4.82987692491072,
    5.26144534071872,
    5.26144534071872,
    5.67833319721175,
    6.06559847276498,
    6.06559847276498,
    6.78890126315368,
    7.57002725631487,
    7.57002725631487,
    8.39734566098508,
    9.24811678031393,
    9.24811678031393,
    8.64828110993685,
    8.3004938924049,
    8.3004938924049,
    9.19119615174402,
    10.0789317538954,
    10.0789317538954,
    10.5933713964696,
    10.9980907058159,
    10.9980907058159,
    10.5719431145127,
    10.3281904664729,
    10.3281904664729,
    11.4342766426924,
    12.4507184208457,
    12.4507184208457,
    12.1634322954407,
    12.0042426762283,
    12.0042426762283,
    11.9103390309228,
    11.8519004275412,
    11.8519004275412,
    12.4230538687837,
    12.8147085330479,
    12.8147085330479,
    13.997752034418,
    14.9047793086342,
    14.9047793086342,
    15.9913410595009,
    16.6924730099607,
    16.6924730099607,
    16.3854725787743,
    16.2657507535756,
    16.2657507535756,
    16.2121991141005,
    16.1912875173398,
    16.1912875173398,
    16.8015481447585,
    17.1223621219985,
    17.1223621219985,
    18.3546792114441,
    19.0655434206167,
    19.0655434206167,
    17.9627205767347,
    17.6450308016372,
    17.6450308016372,
    18.6508019382603,
    19.2081012250625,
    19.2081012250625,
    19.4702464855968,
    19.5849939676938,
    19.5849939676938,
    20.7145578150596,
    21.2849255127978,
    21.2849255127978,
    19.3731905629257,
    18.9262661223571,
    18.9262661223571,
    20.2649054142834,
    21.0510638973294,
    21.0510638973294,
    21.9320158026095,
    22.349986750159,
    22.349986750159,
    21.2835715139652,
    20.9658717062553,
    20.9658717062553,
    22.9970799332921,
    24.2570616050206,
    24.2570616050206,
    23.7966454771958,
    23.6537758826423,
    23.6537758826423,
    24.9705657954707,
    25.6308563404721,
    25.6308563404721,
    27.1885293025871,
    27.9270870558786,
    27.9270870558786,
    27.2270443616443,
    27.0247587738469,
    27.0247587738469,
    27.4078070695711,
    27.5731102721169,
    27.5731102721169,
    28.0645790498999,
    28.2818806579454,
    28.2818806579454,
    29.1667923435721,
    29.5783550945035,
    29.5783550945035,
    28.8786032328577,
    28.6372095594702,
    28.6372095594702,
    27.6520331597876,
    27.2890837242592,
    27.2890837242592,
    29.3978724362829,
    30.7142637353469,
    30.7142637353469,
    30.6438172917546,
    30.6180003472595,
    30.6180003472595,
    32.8026367878498,
    34.0466652410899,
    34.0466652410899,
    33.1273479517852,
    32.8287704205086,
    32.8287704205086,
    33.3945207020688,
    33.6601350570766,
    33.6601350570766,
    34.1130840648393,
    34.3286967055691,
    34.3286967055691,
    34.4189727046189,
    34.4653760788715,
    34.4653760788715,
    35.4036685902495,
    35.8705549069534,
    35.8705549069534,
    35.7693186876655,
    35.7301231345674,
    35.7301231345674,
    36.0219792836462,
    36.1647930834255,
    36.1647930834255,
    37.596998274646,
    38.3642815556676,
    38.3642815556676,
    39.0144414205893,
    39.3245114943603,
    39.3245114943603,
    40.2750339531287,
    40.7388650222321,
    40.7388650222321,
    40.9505128089894,
    41.0530984225773,
    41.0530984225773,
    40.5335092642831,
    40.3213393275063,
    40.3213393275063,
    41.2311742727143,
    41.7072219505158,
    41.7072219505158,
    42.4295597015431,
    42.7990551579901,
    42.7990551579901,
    44.146074120159,
    44.8526578936532,
    44.8526578936532,
    44.9482410602672,
    45.0002241353063,
    45.0002241353063,
    44.7833812342418,
    44.6905281085047,
    44.6905281085047,
    45.9714366239694,
    46.6569451966165,
    46.6569451966165,
    46.7676706274345,
    46.829557097717,
    46.829557097717,
    47.9292851477907,
    48.4999229052701,
    48.4999229052701,
    48.7791929811472,
    48.9135858001646,
    48.9135858001646,
    49.1895800866353,
    49.3301662680425,
    49.3301662680425,
    50.5889456452146,
    51.2634084606637,
    51.2634084606637,
    51.3994907871768,
    51.4780432284929,
    51.4780432284929,
    51.7140785513686,
    51.8377413093444,
    51.8377413093444,
    52.6737314594675,
    53.1079813777287,
    53.1079813777287,
    53.5134017246232,
    53.7178854789041,
    53.7178854789041,
    54.8968052662538,
    55.518454506223,
    55.518454506223,
    55.6445025008903,
    55.712702443923,
    55.712702443923,
    56.9701596397417,
    57.6347427739658,
    57.6347427739658,
    58.3125783936136,
    58.6556149614398,
    58.6556149614398,
    57.9012293217726,
    57.5672636104319,
    57.5672636104319,
    59.3571244772149,
    60.3714514531507,
    60.3714514531507,
    60.2164999651039,
    60.1576924115224,
    60.1576924115224,
    61.5712055088574,
    62.3380315575562,
    62.3380315575562,
    62.561337438102,
    62.6799446418508,
    62.6799446418508,
    62.7312161111724,
    62.7631601036074,
    62.7631601036074,
    64.0112362989158,
    64.6817397299126,
    64.6817397299126,
    64.8645484364024,
    64.9613282056993,
    64.9613282056993,
    66.6030169643355,
    67.4975528853667,
    67.4975528853667,
    67.8010804062444,
    67.9568917793376,
    67.9568917793376,
    67.7343339126042,
    67.6330412206331,
    67.6330412206331,
    69.1048083971698,
    69.9100301206231,
    69.9100301206231,
    70.1803492469587,
    70.3216829249579,
    70.3216829249579,
    71.6078663676903,
    72.2966333362076,
    72.2966333362076,
    72.2287804409865,
    72.2068449516372,
    72.2068449516372,
    72.3375284664676,
    72.4081640113918,
    72.4081640113918,
    73.8516003407431,
    74.6438917453224,
    74.6438917453224,
    75.1807539190377,
    75.4605622728725,
    75.4605622728725,
    76.6047243782132,
    77.2159685455652,
    77.2159685455652,
    77.2730787336592,
    77.3098383286275,
    77.3098383286275,
    77.7057686220134,
    77.9146516529875,
    77.9146516529875,
    79.2067595262673,
    79.9089474857834,
    79.9089474857834,
    79.9106422454278,
    79.91929008193,
    79.91929008193,
    80.8496286824203,
    81.349351809372,
    81.349351809372,
    81.964274946218,
    82.2908137067841,
    82.2908137067841,
    82.5798170625891,
    82.7323925659887,
    82.7323925659887,
    84.1365252805922,
    84.9041477758944,
    84.9041477758944,
    84.8401359686876,
    84.8147038118509,
    84.8147038118509,
    86.2055219644182,
    86.9670642108739,
    86.9670642108739,
    87.3693993060793,
    87.5805434635023,
    87.5805434635023,
    87.8030502437181,
    87.9222248865044,
    87.9222248865044,
    89.2219189015476,
    89.9332360508259,
    89.9332360508259,
    90.0850063950108,
    90.1689110347913,
    90.1689110347913,
    91.4171410443962,
    92.1018322902104,
    92.1018322902104,
    92.4609189349817,
    92.6519767771151,
    92.6519767771151,
    92.7488573197507,
    92.805855114156,
    92.805855114156,
    93.8058079233515,
    94.3514920361284,
    94.3514920361284,
    94.9370113711006,
    95.2540019591401,
    95.2540019591401,
    96.5363261462276,
    97.2390763441595,
    97.2390763441595,
    97.7080209691866,
    97.9575539982202,
    97.9575539982202,
    97.9870293126594,
    98.0061326992265,
    98.0061326992265,
    99.2001651398035,
    99.859134815211,
    99.859134815211,
    100.583348037689,
    100.974484896265,
    100.974484896265,
    101.875381647212,
    102.363463063971,
    102.363463063971,
    102.622570332527,
    102.764546208097,
    102.764546208097,
    102.921176998107,
    103.009937000451,
    103.009937000451,
    104.170725575747,
    104.812533568781,
    104.812533568781,
    104.970332146647,
    105.056812417838,
    105.056812417838,
    106.357014431479,
    107.077724807042,
    107.077724807042,
    107.37085351696,
    107.530358917569,
    107.530358917569,
    107.42979056346,
    107.378126391374,
    107.378126391374,
    108.724157835472,
    109.472697047394,
    109.472697047394,
    109.890264215399,
    110.118777876506,
    110.118777876506,
    111.176241262509,
    111.758447321494,
    111.758447321494,
    112.140751530669,
    112.348068957605,
    112.348068957605,
    112.468895188616,
    112.538181596273,
    112.538181596273,
    113.633781885255,
    114.245280781418,
    114.245280781418,
    114.418328108568,
    114.515287775701,
    114.515287775701,
    115.841992935303,
    116.584386708411,
    116.584386708411,
    116.903099862642,
    117.076658117629,
    117.076658117629,
    117.170468707929,
    117.224048916437,
    117.224048916437,
    118.269233109463,
    118.850717446954,
    118.850717446954,
    119.153183505246,
    119.318317890764,
    119.318317890764,
    120.400056418298,
    120.998730835013,
    120.998730835013,
    121.256037003483,
    121.397110046891,
    121.397110046891,
    121.613672702833,
    121.732195249361,
    121.732195249361,
    122.765258014385,
    123.342979551088,
    123.342979551088,
    123.65589654557,
    123.830708003224,
    123.830708003224,
    125.097931246625,
    125.807356379345,
    125.807356379345,
    125.977035510237,
    126.071881632311,
    126.071881632311,
    126.118310893832,
    126.145948553469,
    126.145948553469,
    127.158120379743,
    127.726186460335,
    127.726186460335,
    127.975418882403,
    128.114345918961,
    128.114345918961,
    129.102262965925,
    129.65334017807,
    129.65334017807,
    130.228481988837,
    130.550418519141,
    130.550418519141,
    130.591417872103,
    130.618049719133,
    130.618049719133,
    131.658687889353,
    132.243468919493,
    132.243468919493,
    132.490274861987,
    132.626954638438,
    132.626954638438,
    133.707533288028,
    134.310419990611,
    134.310419990611,
    134.639460262034,
    134.821565606612,
    134.821565606612,
    134.865019657887,
    134.890342875266,
    134.890342875266,
    135.888227201216,
    136.451900036587,
    136.451900036587,
    136.829697093117,
    137.038432577855,
    137.038432577855,
    138.106477623722,
    138.709410898065,
    138.709410898065,
    138.986551899286,
    139.141624153446,
    139.141624153446,
    139.344832134444,
    139.455991859356,
    139.455991859356,
    140.325273583372,
    140.813701508724,
    140.813701508724,
    141.213391294755,
    141.437308821239,
    141.437308821239,
    142.37568867938,
    142.905440017453,
    142.905440017453,
    143.249777948553,
    143.443394975259,
    143.443394975259,
    143.431442685993,
    143.426866701608,
    143.426866701608,
    144.618182985746,
    145.295055509147,
    145.295055509147,
    145.552542359183,
    145.698699289244,
    145.698699289244,
    146.782587038148,
    147.397092141605,
    147.397092141605,
    147.623896916339,
    147.752014531816,
    147.752014531816,
    147.691762668679,
    147.660370801247,
    147.660370801247,
    148.685332349941,
    149.269015480792,
    149.269015480792,
    149.544780521995,
    149.700856296404,
    149.700856296404,
    150.860106781499,
    151.517067126673,
    151.517067126673,
    151.772176752437,
    151.918295177893,
    151.918295177893,
    151.939847948545,
    151.951257524944,
    151.951257524944,
    152.841505174671,
    153.35022370176,
    153.35022370176,
    153.798480698386,
    154.049036112896,
    154.049036112896,
    155.016933383919,
    155.568361217568,
    155.568361217568,
    155.93564471207,
    156.144359223911,
    156.144359223911,
    156.149712557128,
    156.157356176905,
    156.157356176905,
    157.01361467731,
    157.503407213959,
    157.503407213959,
    158.034353635136,
    158.336742784495,
    158.336742784495,
    159.245353544044,
    159.761068076393,
    159.761068076393,
    159.946410508927,
    160.05434858569,
    160.05434858569,
    160.114160091628,
    160.15141314942,
    160.15141314942,
    161.051489068341,
    161.564497621395,
    161.564497621395,
    161.848616026012,
    162.010606627104,
    162.010606627104,
    162.972106451717,
    163.523767947964,
    163.523767947964,
    163.738056721893,
    163.859297236204,
    163.859297236204,
    164.021673158676,
    164.113373029923,
    164.113373029923,
    165.125283376596,
    165.704751933108,
    165.704751933108,
    165.78073440446,
    165.825894503262,
    165.825894503262,
    166.879248339921,
    167.482814230017,
    167.482814230017,
    167.875696861715,
    168.104313430978,
    168.104313430978,
    168.160126334754,
    168.194092548077,
    168.194092548077,
    169.145459086058,
    169.692928499849,
    169.692928499849,
    169.906685391595,
    170.030758836733,
    170.030758836733,
    171.001325181522,
    171.558484088077,
    171.558484088077,
    171.92619326763,
    172.134981824494,
    172.134981824494,
    172.198429633151,
    172.234120890376,
    172.234120890376,
    173.132883518898,
    173.654441020225,
    173.654441020225,
    174.000020817233,
    174.203355026226,
    174.203355026226,
    175.049085899519,
    175.537514648816,
    175.537514648816,
    175.810341071278,
    175.964464205691,
    175.964464205691,
    176.133700219745,
    176.232385103324,
    176.232385103324,
    177.056206691526,
    177.535111758771,
    177.535111758771,
    177.754725504424,
    177.879537002085,
    177.879537002085,
    178.846395797878,
    179.405417022359,
    179.405417022359,
    179.67473860844,
    179.829363954631,
    179.829363954631,
    179.997259181608,
    180.093775823786,
    180.093775823786,
    181.024933290525,
    181.563682614253,
    181.563682614253,
    181.820048273037,
    181.965242511149,
    181.965242511149,
    182.910691741208,
    183.45834056521,
    183.45834056521,
    183.770206648084,
    183.950880439278,
    183.950880439278,
    183.920684618826,
    183.90539813069,
    183.90539813069,
    184.750872699327,
    185.243731077132,
    185.243731077132,
    185.605395355862,
    185.816263299568,
    185.816263299568,
    185.934052896954,
    185.999203900569,
    185.999203900569,
    186.778995230567,
    187.236361297172,
    187.236361297172,
    187.668100879069,
    187.918023818652,
    187.918023818652,
    188.838602442801,
    189.370762617306,
    189.370762617306,
    189.497560305845,
    189.574964669855,
    189.574964669855,
    189.917140224107,
    190.113735325293,
    190.113735325293,
    190.823354138451,
    191.237830260037,
    191.237830260037,
    191.425090240948,
    191.530743492077,
    191.530743492077,
    192.469843895737,
    193.017718328161,
    193.017718328161,
    193.253863688533,
    193.392391985021,
    193.392391985021,
    193.467231410159,
    193.510176759299,
    193.510176759299,
    194.351144763528,
    194.841382585063,
    194.841382585063,
    195.150802849017,
    195.330205301395,
    195.330205301395,
    196.212146623659,
    196.73051831385,
    196.73051831385,
    197.028052503405,
    197.203923392385,
    197.203923392385,
    197.345848591934,
    197.429785329313,
    197.429785329313,
    198.131757462717,
    198.544044715258,
    198.544044715258,
    198.829761823581,
    198.994693931857,
    198.994693931857,
    199.847273044091,
    200.352010757526,
    200.352010757526,
    200.85268871589,
    201.144018608618,
    201.144018608618,
    201.166904625074,
    201.180328275469,
    201.180328275469,
    201.911372349104,
    202.344172050456,
    202.344172050456,
    202.634228563801,
    202.805731116525,
    202.805731116525,
    203.659860631672,
    204.165424669342,
    204.165424669342,
    204.503662747332,
    204.700471019243,
    204.700471019243,
    204.880333702076,
    204.98813608377,
    204.98813608377,
    205.639923331787,
    206.023500778523,
    206.023500778523,
    206.357842520267,
    206.549447852853,
    206.549447852853,
    207.335666760188,
    207.799218826043,
    207.799218826043,
    208.138768724217,
    208.338201179995,
    208.338201179995,
    208.518611664175,
    208.624894605422,
    208.624894605422,
    209.491661785282,
    210.005476389951,
    210.005476389951,
    210.173884606461,
    210.271783490973,
    210.271783490973,
    211.154671691918,
    211.680405382814,
    211.680405382814,
    211.919374491202,
    212.05991325921,
    212.05991325921,
    212.137786282002,
    212.181071134669,
    212.181071134669,
    212.805843558001,
    213.175930605584,
    213.175930605584,
    213.562058557735,
    213.789089190935,
    213.789089190935,
    214.58165831489,
    215.053140960995,
    215.053140960995,
    215.411672216152,
    215.622880330576,
    215.622880330576,
    215.829370952,
    215.951755930105,
    215.951755930105,
    216.644008916513,
    217.058939722972,
    217.058939722972,
    217.280814723083,
    217.412397415989,
    217.412397415989,
    218.351887945226,
    218.921041416175,
    218.921041416175,
    219.217166852394,
    219.407083955842,
    219.407083955842,
    219.62404191867,
    219.75896761677,
    219.75896761677,
    220.647951899741,
    221.179245363644,
    221.179245363644,
    221.449530985421,
    221.609554893947,
    221.609554893947,
    222.636875864938,
    223.247062088555,
    223.247062088555,
    223.569157619883,
    223.757759691732,
    223.757759691732,
    223.925748695999,
    224.023525265054,
    224.023525265054,
    224.937701778742,
    225.484522159177,
    225.484522159177,
    225.764882996315,
    225.93793521141,
    225.93793521141,
    226.998344625873,
    227.63203711584,
    227.63203711584,
    228.019823196738,
    228.25491709799,
    228.25491709799,
    228.363293119668,
    228.427163849445,
    228.427163849445,
    229.312277651632,
    229.84412737239,
    229.84412737239,
    230.197077814887,
    230.411914501887,
    230.411914501887,
    231.375555578397,
    231.9546337447,
    231.9546337447,
    232.350544820796,
    232.589941676746,
    232.589941676746,
    232.600668663335,
    232.604945230283,
    232.604945230283,
    233.534434995157,
    234.096014715593,
    234.096014715593,
    234.321448126637,
    234.456143945131,
    234.456143945131,
    235.473443407368,
    236.087451092021,
    236.087451092021,
    236.396861399915,
    236.580435297664,
    236.580435297664,
    236.762316402298,
    236.87167507304,
    236.87167507304,
    237.781257178164,
    238.332323798136,
    238.332323798136,
    238.554482368774,
    238.688581233081,
    238.688581233081,
    239.653071082464,
    240.237846917811,
    240.237846917811,
    240.548943305488,
    240.735293364403,
    240.735293364403,
    240.880095931447,
    240.967649524734,
    240.967649524734,
    241.746609995648,
    242.217577712683,
    242.217577712683,
    242.548057460168,
    242.749186388729,
    242.749186388729,
    243.657237601938,
    244.210342543238,
    244.210342543238,
    244.522659572295,
    244.714806997366,
    244.714806997366,
    244.790753609102,
    244.84043208102,
    244.84043208102,
    245.635757411197,
    246.127673605072,
    246.127673605072,
    246.369427734582,
    246.52125552319,
    246.52125552319,
    247.425237452175,
    247.982076497512,
    247.982076497512,
    248.3616917499,
    248.593560116934,
    248.593560116934,
    248.698016233887,
    248.76371530109,
    248.76371530109,
    249.526942730379,
    249.991522845241,
    249.991522845241,
    250.348537538681,
    250.560114739161,
    250.560114739161,
    251.48018116477,
    252.04383767679,
    252.04383767679,
    252.312290977795,
    252.477266343842,
    252.477266343842,
    252.557412959044,
    252.603637038675,
    252.603637038675,
    253.324867141771,
    253.765739367052,
    253.765739367052,
    254.070371505108,
    254.247525624492,
    254.247525624492,
    254.908361510705,
    255.29346890631,
    255.29346890631,
    255.491033040912,
    255.588439070134,
    255.588439070134,
    255.632716722377,
    255.637697947411,
    255.637697947411,
    256.02062373433,
    256.243013794134,
    256.243013794134,
    256.281773760555,
    256.173439224395,
    256.173439224395,
    255.999921389649,
    255.890846437407,
    255.890846437407,
    255.864177536571,
    255.846250624516,
    255.846250624516,
    255.830423331874,
    255.819552362995,
    255.819552362995,
    255.455675599181,
    255.22845880378,
    255.22845880378,
    255.037317560575,
    254.917752329292,
    254.917752329292,
    254.643711481628,
    254.473028387456,
    254.473028387456,
    254.23635008886,
    254.088609219804,
    254.088609219804,
    254.026584176308,
    253.9872974003,
    253.9872974003,
    253.566319757143,
    253.305589288715,
    253.305589288715,
    253.241442555584,
    253.200304729871,
    253.200304729871,
    252.904683719012,
    252.720583148608,
    252.720583148608,
    252.636065715151,
    252.583190289909,
    252.583190289909,
    252.44380547586,
    252.356436395142,
    252.356436395142,
    252.004516556849,
    251.786638390792,
    251.786638390792,
    251.647185527214,
    251.55999879208,
    251.55999879208,
    251.301748035937,
    251.14094164271,
    251.14094164271,
    251.024138068068,
    250.951118772729,
    250.951118772729,
    250.832528393578,
    250.758772446542,
    250.758772446542,
    250.411724897724,
    250.196698612148,
    250.196698612148,
    250.107505655881,
    250.051311980441,
    250.051311980441,
    249.6789463004,
    249.44877249615,
    249.44877249615,
    249.255126309917,
    249.13420157197,
    249.13420157197,
    249.068542409994,
    249.027349729207,
    249.027349729207,
    248.648254367452,
    248.41407420526,
    248.41407420526,
    248.278772303362,
    248.194805234299,
    248.194805234299,
    247.801004891043,
    247.558689415573,
    247.558689415573,
    247.523404842561,
    247.500544926412,
    247.500544926412,
    247.48203494121,
    247.469338116473,
    247.469338116473,
    247.060922036706,
    246.809968744856,
    246.809968744856,
    246.770115362052,
    246.744501981671,
    246.744501981671,
    246.298312359637,
    246.020580726543,
    246.020580726543,
    245.80701475082,
    245.672261514917,
    245.672261514917,
    245.700572588575,
    245.714270245637,
    245.714270245637,
    245.321516138737,
    245.077740766513,
    245.077740766513,
    245.006231449344,
    244.959718796303,
    244.959718796303,
    244.422628746372,
    244.092691842261,
    244.092691842261,
    244.005814030022,
    243.950513761518,
    243.950513761518,
    243.812265239968,
    243.725920619477,
    243.725920619477,
    243.31896921384,
    243.068908488773,
    243.068908488773,
    242.961993992105,
    242.89534859227,
    242.89534859227,
    242.325672111795,
    241.977740659653,
    241.977740659653,
    241.831736427984,
    241.74116611384,
    241.74116611384,
    241.681195802212,
    241.643998509133,
    241.643998509133,
    241.087590100124,
    240.748226508565,
    240.748226508565,
    240.660141147623,
    240.605793959771,
    240.605793959771,
    240.034806928747,
    239.687255793604,
    239.687255793604,
    239.558621506616,
    239.481684530345,
    239.481684530345,
    239.431654397423,
    239.400005333122,
    239.400005333122,
    238.963722798103,
    238.69753672389,
    238.69753672389,
    238.583427231609,
    238.513269107772,
    238.513269107772,
    237.998815587368,
    237.685555968004,
    237.685555968004,
    237.526787647416,
    237.429404545815,
    237.429404545815,
    237.382080484334,
    237.352149432621,
    237.352149432621,
    236.895063423787,
    236.617402191815,
    236.617402191815,
    236.444316167616,
    236.338431715527,
    236.338431715527,
    235.864309837547,
    235.576212302352,
    235.576212302352,
    235.380778516364,
    235.261307103149,
    235.261307103149,
    235.290622378856,
    235.308193968674,
    235.308193968674,
    234.798126710939,
    234.489682671326,
    234.489682671326,
    234.335484505784,
    234.240825367319,
    234.240825367319,
    233.821519895982,
    233.567176562329,
    233.567176562329,
    233.392651616407,
    233.285927975482,
    233.285927975482,
    233.217102598242,
    233.17518779135,
    233.17518779135,
    232.768118537607,
    232.521509521143,
    232.521509521143,
    232.31425249345,
    232.187681917257,
    232.187681917257,
    231.726668147766,
    231.447476728319,
    231.447476728319,
    231.274213884204,
    231.168909859016,
    231.168909859016,
    231.155606479054,
    231.146640113405,
    231.146640113405,
    230.660489153263,
    230.367605425004,
    230.367605425004,
    230.186171799499,
    230.076459374763,
    230.076459374763,
    229.674807876616,
    229.432018655355,
    229.432018655355,
    229.302116404194,
    229.222966238555,
    229.222966238555,
    229.133075009318,
    229.078265624928,
    229.078265624928,
    228.651839269207,
    228.394364823634,
    228.394364823634,
    228.235739663907,
    228.138953660622,
    228.138953660622,
    227.629054924097,
    227.32177924426,
    227.32177924426,
    227.150537123518,
    227.046575678747,
    227.046575678747,
    227.018041474925,
    227.00047805367,
    227.00047805367,
    226.513440629226,
    226.220948492925,
    226.220948492925,
    226.079410553282,
    225.99334891,
    225.99334891,
    225.597262601632,
    225.358260665393,
    225.358260665393,
    225.191700862095,
    225.090827413938,
    225.090827413938,
    225.025681197206,
    224.986405702876,
    224.986405702876,
    224.615494508444,
    224.392102568593,
    224.392102568593,
    224.234549376426,
    224.140092523168,
    224.140092523168,
    223.694533640708,
    223.427075053719,
    223.427075053719,
    223.301349375625,
    223.225192083076,
    223.225192083076,
    223.078368209286,
    222.990063397808,
    222.990063397808,
    222.584273744653,
    222.341498777125,
    222.341498777125,
    222.248982432894,
    222.195598164252,
    222.195598164252,
    221.691515922205,
    221.390210322775,
    221.390210322775,
    221.205048348463,
    221.093634452913,
    221.093634452913,
    221.062281358977,
    221.04291608431,
    221.04291608431,
    220.535114555559,
    220.232657526977,
    220.232657526977,
    220.204438272686,
    220.18785608586,
    220.18785608586,
    219.718406914277,
    219.438205336521,
    219.438205336521,
    219.365103499304,
    219.321152519918,
    219.321152519918,
    219.211047634359,
    219.144536677389,
    219.144536677389,
    218.662655150543,
    218.374843159076,
    218.374843159076,
    218.218814219725,
    218.125087472345,
    218.125087472345,
    217.724682823044,
    217.484917296395,
    217.484917296395,
    217.357815366469,
    217.28100742839,
    217.28100742839,
    217.270885508458,
    217.265015470801,
    217.265015470801,
    216.832636729289,
    216.575418100943,
    216.575418100943,
    216.377106728873,
    216.258676153832,
    216.258676153832,
    215.920320280265,
    215.717673940355,
    215.717673940355,
    215.511618946846,
    215.388252164325,
    215.388252164325,
    215.391502569765,
    215.392984878957,
    215.392984878957,
    215.021914939458,
    214.801888548617,
    214.801888548617,
    214.48251342781,
    214.292074891892,
    214.292074891892,
    213.926184923955,
    213.708321424576,
    213.708321424576,
    213.512009795226,
    213.394977898543,
    213.394977898543,
    213.423779891498,
    213.441158857721,
    213.441158857721,
    212.991596248409,
    212.725160896789,
    212.725160896789,
    212.60301908343,
    212.530182146003,
    212.530182146003,
    212.107032686194,
    211.855908241464,
    211.855908241464,
    211.743621630496,
    211.676129802979,
    211.676129802979,
    211.590613090676,
    211.539812610468,
    211.539812610468,
    211.126723998841,
    210.881809999558,
    210.881809999558,
    210.795350203472,
    210.743123898256,
    210.743123898256,
    210.328089564729,
    210.082362355694,
    210.082362355694,
    209.867821201225,
    209.740088521457,
    209.740088521457,
    209.765413415909,
    209.780590209567,
    209.780590209567,
    209.402065788472,
    209.178195295382,
    209.178195295382,
    208.935045192377,
    208.790445494147,
    208.790445494147,
    208.486067509819,
    208.30545683949,
    208.30545683949,
    208.109184592778,
    207.99280843155,
    207.99280843155,
    207.854424867853,
    207.772852915324,
    207.772852915324,
    207.396026282654,
    207.172940990977,
    207.172940990977,
    206.971867232952,
    206.851771428631,
    206.851771428631,
    206.57893336818,
    206.416638994834,
    206.416638994834,
    206.123735138278,
    205.949957269358,
    205.949957269358,
    205.973385069931,
    205.987142564114,
    205.987142564114,
    205.640575866901,
    205.43652134936,
    205.43652134936,
    205.244656382079,
    205.131019554857,
    205.131019554857,
    204.687201444262,
    204.424635902032,
    204.424635902032,
    204.266772977435,
    204.173877993767,
    204.173877993767,
    204.133422869434,
    204.109689449751,
    204.109689449751,
    203.716106466332,
    203.4839375883,
    203.4839375883,
    203.34249530342,
    203.258861129136,
    203.258861129136,
    202.827606454492,
    202.573654322451,
    202.573654322451,
    202.376475853257,
    202.258842920152,
    202.258842920152,
    202.271503586872,
    202.27918763161,
    202.27918763161,
    201.986869037742,
    201.814289541038,
    201.814289541038,
    201.621218587278,
    201.507859202422,
    201.507859202422,
    201.185134137651,
    200.994575671409,
    200.994575671409,
    200.722627782667,
    200.562371608308,
    200.562371608308,
    200.531276180473,
    200.512973730089,
    200.512973730089,
    200.156817029059,
    199.947981093331,
    199.947981093331,
    199.682622420998,
    199.526543605882,
    199.526543605882,
    199.244484816149,
    199.07834509491,
    199.07834509491,
    198.981818801037,
    198.925768954553,
    198.925768954553,
    198.994276750847,
    199.035008714694,
    199.035008714694,
    198.620629858127,
    198.378059231638,
    198.378059231638,
    198.117496734652,
    197.964027017534,
    197.964027017534,
    197.566142169944,
    197.332429181638,
    197.332429181638,
    197.1906698746,
    197.10682329832,
    197.10682329832,
    197.0532183342,
    197.02242804067,
    197.02242804067,
    196.649181008593,
    196.431277978807,
    196.431277978807,
    196.253691108403,
    196.149710729509,
    196.149710729509,
    195.687000011245,
    195.416350154493,
    195.416350154493,
    195.36727609122,
    195.338672498879,
    195.338672498879,
    195.317675885834,
    195.305377638227,
    195.305377638227,
    194.796475213024,
    194.498659950898,
    194.498659950898,
    194.506421862604,
    194.511326687163,
    194.511326687163,
    194.244454776347,
    194.088207353971,
    194.088207353971,
    193.74016768319,
    193.535079124773,
    193.535079124773,
    193.572893975208,
    193.595364266803,
    193.595364266803,
    193.227039838232,
    193.011454301759,
    193.011454301759,
    192.663581142855,
    192.45981722461,
    192.45981722461,
    192.210649812442,
    192.064489606172,
    192.064489606172,
    192.047445106926,
    192.037689153615,
    192.037689153615,
    191.954978545629,
    191.906548556851,
    191.906548556851,
    191.510237019235,
    191.278895245573,
    191.278895245573,
    191.019762960814,
    190.868261721832,
    190.868261721832,
    190.60227722975,
    190.446357459092,
    190.446357459092,
    190.350527514593,
    190.294938869742,
    190.294938869742,
    190.184312544555,
    190.12028109497,
    190.12028109497,
    189.738272858823,
    189.515333967926,
    189.515333967926,
    189.472189828841,
    189.447599121107,
    189.447599121107,
    189.011754608606,
    188.757986705671,
    188.757986705671,
    188.633352756438,
    188.560365346517,
    188.560365346517,
    188.559407524804,
    188.559594967573,
    188.559594967573,
    188.182534398515,
    187.962687926749,
    187.962687926749,
    187.754781018836,
    187.633325249342,
    187.633325249342,
    187.258762177376,
    187.040713426484,
    187.040713426484,
    186.937398275389,
    186.87773267024,
    186.87773267024,
    186.809533786165,
    186.7705240897,
    186.7705240897,
    186.471324069807,
    186.296263875053,
    186.296263875053,
    186.207298511964,
    186.155977038272,
    186.155977038272,
    185.819057966739,
    185.622757931597,
    185.622757931597,
    185.409677075695,
    185.285362130828,
    185.285362130828,
    185.160921565465,
    185.088825487624,
    185.088825487624,
    184.754804828244,
    184.559913126487,
    184.559913126487,
    184.442551553536,
    184.374225711172,
    184.374225711172,
    183.975320471533,
    183.74370361779,
    183.74370361779,
    183.604312481575,
    183.522835274324,
    183.522835274324,
    183.440576740505,
    183.393368157377,
    183.393368157377,
    183.130385802462,
    182.977579242188,
    182.977579242188,
    182.837199329175,
    182.755303607534,
    182.755303607534,
    182.313649494889,
    182.057426334847,
    182.057426334847,
    181.854899297864,
    181.737510685906,
    181.737510685906,
    181.838388342755,
    181.89846690935,
    181.89846690935,
    181.585567157136,
    181.40481227588,
    181.40481227588,
    181.198591686084,
    181.07878424773,
    181.07878424773,
    180.720777165871,
    180.51365469306,
    180.51365469306,
    180.278467250125,
    180.142252217164,
    180.142252217164,
    180.185003746601,
    180.211059749112,
    180.211059749112,
    179.905548712271,
    179.729114401013,
    179.729114401013,
    179.542169287542,
    179.434065797397,
    179.434065797397,
    179.128017473608,
    178.951149048442,
    178.951149048442,
    178.713834708995,
    178.575808489173,
    178.575808489173,
    178.58888480668,
    178.598103255982,
    178.598103255982,
    178.179871269851,
    177.937898197798,
    177.937898197798,
    178.051780933656,
    178.118788129068,
    178.118788129068,
    177.620339908049,
    177.332160571201,
    177.332160571201,
    177.062073749728,
    176.904194130327,
    176.904194130327,
    176.906660785963,
    176.90899039586,
    176.90899039586,
    176.664216574005,
    176.522149139383,
    176.522149139383,
    176.354316745768,
    176.255901660054,
    176.255901660054,
    175.95116604081,
    175.774193346286,
    175.774193346286,
    175.534446168223,
    175.396631240851,
    175.396631240851,
    175.344216647597,
    175.31415940951,
    175.31415940951,
    175.115952734159,
    174.999856448299,
    174.999856448299,
    174.878509616179,
    174.808184964793,
    174.808184964793,
    174.433749158656,
    174.217832756911,
    174.217832756911,
    173.95370238219,
    173.80136875719,
    173.80136875719,
    173.791578628439,
    173.785801308715,
    173.785801308715,
    173.496783198806,
    173.329950771752,
    173.329950771752,
    173.262739214538,
    173.223301424319,
    173.223301424319,
    172.778213683635,
    172.521670096689,
    172.521670096689,
    172.469293860426,
    172.438447706256,
    172.438447706256,
    172.180846971937,
    172.031644728022,
    172.031644728022,
    171.791174683954,
    171.65276568504,
    171.65276568504,
    171.618756452736,
    171.599916765748,
    171.599916765748,
    171.091796418123,
    170.799484924258,
    170.799484924258,
    170.72815325029,
    170.687502291322,
    170.687502291322,
    170.556856159606,
    170.482075703796,
    170.482075703796,
    170.197129664797,
    170.031997390504,
    170.031997390504,
    169.985335001291,
    169.958456975968,
    169.958456975968,
    169.630402685328,
    169.441336785063,
    169.441336785063,
    169.32747264249,
    169.262310431118,
    169.262310431118,
    169.221011716431,
    169.197802163155,
    169.197802163155,
    168.747927793818,
    168.488628629218,
    168.488628629218,
    168.282255811228,
    168.163553805744,
    168.163553805744,
    167.88314240461,
    167.721714113029,
    167.721714113029,
    167.572177454829,
    167.486965555953,
    167.486965555953,
    167.485253490642,
    167.484480537854,
    167.484480537854,
    167.131126072073,
    166.927382702107,
    166.927382702107,
    166.893200059696,
    166.874296166961,
    166.874296166961,
    166.36508487989,
    166.074106003632,
    166.074106003632,
    166.041484678718,
    166.024323332502,
    166.024323332502,
    166.098459541327,
    166.143119920723,
    166.143119920723,
    165.810411832407,
    165.620016341913,
    165.620016341913,
    165.505840228625,
    165.440043472375,
    165.440043472375,
    165.096332423758,
    164.897680614209,
    164.897680614209,
    164.727186412137,
    164.628949413725,
    164.628949413725,
    164.551376771195,
    164.508145800003,
    164.508145800003,
    164.174495247614,
    163.982889126475,
    163.982889126475,
    163.86749536214,
    163.801881421839,
    163.801881421839,
    163.400172685839,
    163.169562425269,
    163.169562425269,
    163.031693910919,
    162.953381190713,
    162.953381190713,
    162.957735615446,
    162.960552691965,
    162.960552691965,
    162.595930866384,
    162.386831117789,
    162.386831117789,
    162.208160450715,
    162.106291823038,
    162.106291823038,
    161.716405966422,
    161.492452788487,
    161.492452788487,
    161.321596198025,
    161.223333966712,
    161.223333966712,
    161.307492700981,
    161.357764536734,
    161.357764536734,
    161.108468284796,
    160.96641418833,
    160.96641418833,
    160.971776082383,
    160.974937768562,
    160.974937768562,
    160.659381866327,
    160.479311954473,
    160.479311954473,
    160.224836449662,
    160.078687266147,
    160.078687266147,
    160.22932954358,
    160.317929455676,
    160.317929455676,
    159.84561184701,
    159.57696540244,
    159.57696540244,
    159.417304592419,
    159.327128593391,
    159.327128593391,
    158.937066369821,
    158.71316551506,
    158.71316551506,
    158.580009087953,
    158.50386812069,
    158.50386812069,
    158.510795730516,
    158.516058919075,
    158.516058919075,
    158.289556416414,
    158.16018468988,
    158.16018468988,
    157.876122003111,
    157.714026778387,
    157.714026778387,
    157.578602091092,
    157.501418658998,
    157.501418658998,
    157.222881264594,
    157.064229074455,
    157.064229074455,
    157.008375961979,
    156.977007508126,
    156.977007508126,
    156.671645790955,
    156.496055838299,
    156.496055838299,
    156.224210633925,
    156.067957533058,
    156.067957533058,
    155.895667397815,
    155.798327712892,
    155.798327712892,
    155.601390956049,
    155.489020594847,
    155.489020594847,
    155.57189460644,
    155.621327525095,
    155.621327525095,
    155.204447570783,
    154.966994792686,
    154.966994792686,
    154.673570013101,
    154.505345270884,
    154.505345270884,
    154.212655336203,
    154.044838207467,
    154.044838207467,
    153.888121591783,
    153.798797756711,
    153.798797756711,
    153.799625415405,
    153.801675275487,
    153.801675275487,
    153.563937289512,
    153.428094812378,
    153.428094812378,
    153.386612992015,
    153.364339105952,
    153.364339105952,
    152.955658889381,
    152.723706338306,
    152.723706338306,
    152.643466033062,
    152.598629043879,
    152.598629043879,
    152.66614519517,
    152.707051599214,
    152.707051599214,
    152.273597965069,
    152.028150081494,
    152.028150081494,
    152.038473703465,
    152.046667484785,
    152.046667484785,
    151.651552407013,
    151.42602178557,
    151.42602178557,
    151.391625415851,
    151.372742600703,
    151.372742600703,
    151.35777436839,
    151.349799766527,
    151.349799766527,
    150.94310786108,
    150.712493670901,
    150.712493670901,
    150.517722847197,
    150.40669403697,
    150.40669403697,
    150.256203344675,
    150.171115614106,
    150.171115614106,
    149.959398576253,
    149.838706159431,
    149.838706159431,
    149.807546964725,
    149.790808830075,
    149.790808830075,
    149.491509331416,
    149.321298021305,
    149.321298021305,
    149.044613440429,
    148.887362339792,
    148.887362339792,
    148.590929052163,
    148.422323798711,
    148.422323798711,
    148.379956378705,
    148.356824065349,
    148.356824065349,
    148.397922487137,
    148.422495412069,
    148.422495412069,
    148.068932893382,
    147.867808939884,
    147.867808939884,
    147.80660295652,
    147.772885657655,
    147.772885657655,
    147.442901669096,
    147.255002925866,
    147.255002925866,
    147.142143260758,
    147.078523980956,
    147.078523980956,
    146.935070434164,
    146.85423482133,
    146.85423482133,
    146.494996207018,
    146.291029156645,
    146.291029156645,
    146.21306478212,
    146.171571402472,
    146.171571402472,
    145.99703352564,
    145.89713520004,
    145.89713520004,
    145.67149782046,
    145.544423976601,
    145.544423976601,
    145.586511965297,
    145.61183388647,
    145.61183388647,
    145.248947475958,
    145.043222304656,
    145.043222304656,
    144.816313164189,
    144.68750317778,
    144.68750317778,
    144.340914889412,
    144.143609337626,
    144.143609337626,
    144.086005788977,
    144.054995353061,
    144.054995353061,
    144.077934311478,
    144.092765537935,
    144.092765537935,
    143.842172807431,
    143.699457655054,
    143.699457655054,
    143.613985565569,
    143.565870712219,
    143.565870712219,
    143.169694108959,
    142.945263068332,
    142.945263068332,
    142.919940362464,
    142.906560310515,
    142.906560310515,
    142.833943813191,
    142.793412785992,
    142.793412785992,
    142.445866694519,
    142.24886673687,
    142.24886673687,
    142.132661235312,
    142.066944555579,
    142.066944555579,
    141.812313519972,
    141.668061871257,
    141.668061871257,
    141.581381044047,
    141.532258469642,
    141.532258469642,
    141.547373909719,
    141.557856481933,
    141.557856481933,
    141.126694751994,
    140.882597857247,
    140.882597857247,
    140.67790154335,
    140.562280340717,
    140.562280340717,
    140.337349155963,
    140.209389914904,
    140.209389914904,
    140.022778701674,
    139.917349590452,
    139.917349590452,
    139.852870533581,
    139.817408618099,
    139.817408618099,
    139.575371433389,
    139.439350808191,
    139.439350808191,
    139.247570994679,
    139.138550106507,
    139.138550106507,
    138.867798066163,
    138.714969453886,
    138.714969453886,
    138.780964407126,
    138.820960937418,
    138.820960937418,
    138.839932566769,
    138.851115269431,
    138.851115269431,
    138.473738008369,
    138.260439970169,
    138.260439970169,
    138.245624428241,
    138.238353748202,
    138.238353748202,
    137.834392132986,
    137.605379539634,
    137.605379539634,
    137.470553514698,
    137.395818192317,
    137.395818192317,
    137.285705572689,
    137.223531650181,
    137.223531650181,
    136.848277039323,
    136.636250647944,
    136.636250647944,
    136.687001241421,
    136.717927366103,
    136.717927366103,
    136.280077037208,
    136.032237559098,
    136.032237559098,
    135.999297012346,
    135.982339239395,
    135.982339239395,
    135.79096022762,
    135.684579806008,
    135.684579806008,
    135.392023874418,
    135.227756422831,
    135.227756422831,
    135.243537117464,
    135.255334503338,
    135.255334503338,
    134.915537690989,
    134.722943481697,
    134.722943481697,
    134.623909759741,
    134.567752301724,
    134.567752301724,
    134.583275037939,
    134.592586734979,
    134.592586734979,
    134.365765020791,
    134.238276210122,
    134.238276210122,
    134.097282753844,
    134.018223091153,
    134.018223091153,
    133.623049722844,
    133.399926089036,
    133.399926089036,
    133.268304038058,
    133.194003937386,
    133.194003937386,
    133.147274477227,
    133.122967025914,
    133.122967025914,
    133.069832259672,
    133.041917108661,
    133.041917108661,
    132.942035688838,
    132.885859703834,
    132.885859703834,
    132.449129540694,
    132.202600045022,
    132.202600045022,
    132.058070760745,
    131.977555043591,
    131.977555043591,
    131.861958354504,
    131.797741462674,
    131.797741462674,
    131.706761082,
    131.657256301878,
    131.657256301878,
    131.374191378267,
    131.216335432984,
    131.216335432984,
    131.018046839946,
    130.906705438416,
    130.906705438416,
    130.719690372331,
    130.615838732687,
    130.615838732687,
    130.552148948274,
    130.516651247946,
    130.516651247946,
    130.256208775679,
    130.109491566696,
    130.109491566696,
    130.141347640117,
    130.161599123104,
    130.161599123104,
    129.742633722001,
    129.507803882709,
    129.507803882709,
    129.316066564843,
    129.208689180561,
    129.208689180561,
    129.142192410147,
    129.107093163508,
    129.107093163508,
    128.776156239646,
    128.589222934466,
    128.589222934466,
    128.666878513799,
    128.712090878642,
    128.712090878642,
    128.372254119728,
    128.180904169781,
    128.180904169781,
    127.946056819811,
    127.813759271769,
    127.813759271769,
    127.976927737806,
    128.07228938659,
    128.07228938659,
    127.689496473409,
    127.4749358575,
    127.4749358575,
    127.225354480627,
    127.084322070915,
    127.084322070915,
    126.757476454695,
    126.573804161848,
    126.573804161848,
    126.532281077768,
    126.512097142509,
    126.512097142509,
    126.61721501674,
    126.680287256509,
    126.680287256509,
    126.284488642041,
    126.061957579556,
    126.061957579556,
    126.112564861769,
    126.142085692435,
    126.142085692435,
    125.783540795765,
    125.582196099534,
    125.582196099534,
    125.46519821547,
    125.39878873913,
    125.39878873913,
    125.35747172144,
    125.334946497686,
    125.334946497686,
    125.070746373153,
    124.922791283854,
    124.922791283854,
    124.637919712059,
    124.477898110875,
    124.477898110875,
    124.273097351671,
    124.159164201001,
    124.159164201001,
    124.076523818131,
    124.030153602166,
    124.030153602166,
    124.069665394843,
    124.093875523496,
    124.093875523496,
    123.795476954081,
    123.628920083864,
    123.628920083864,
    123.656613931067,
    123.674410685857,
    123.674410685857,
    123.228006443451,
    122.978670438335,
    122.978670438335,
    122.973000156131,
    122.970373829806,
    122.970373829806,
    122.895141560712,
    122.853478367959,
    122.853478367959,
    122.370842841041,
    122.10061493858,
    122.10061493858,
    122.001232019703,
    121.946383780666,
    121.946383780666,
    121.668860221887,
    121.512608833669,
    121.512608833669,
    121.335336918006,
    121.234791369154,
    121.234791369154,
    121.245901769589,
    121.25466699282,
    121.25466699282,
    121.14058732793,
    121.077026338001,
    121.077026338001,
    120.893355295734,
    120.791897301369,
    120.791897301369,
    120.338493760101,
    120.084168970787,
    120.084168970787,
    119.862708643813,
    119.739975074501,
    119.739975074501,
    120.138323847782,
    120.370655580802,
    120.370655580802,
    119.959246146469,
    119.731981462415,
    119.731981462415,
    119.467294115977,
    119.318078228791,
    119.318078228791,
    119.10062133911,
    118.979117087332,
    118.979117087332,
    118.965860562867,
    118.959083866022,
    118.959083866022,
    118.89229872365,
    118.855898004007,
    118.855898004007,
    118.431070186022,
    118.194678691689,
    118.194678691689,
    118.333254860383,
    118.414453951662,
    118.414453951662,
    117.984259807465,
    117.743927845417,
    117.743927845417,
    117.736765249709,
    117.733555721978,
    117.733555721978,
    117.520732259473,
    117.402541264752,
    117.402541264752,
    117.272236771658,
    117.199630243707,
    117.199630243707,
    116.959949309025,
    116.824363929884,
    116.824363929884,
    116.38497022911,
    116.139249518945,
    116.139249518945,
    116.277402148048,
    116.359846960977,
    116.359846960977,
    116.192754994577,
    116.099548821188,
    116.099548821188,
    115.771015519932,
    115.587916205663,
    115.587916205663,
    115.553682278978,
    115.536979197447,
    115.536979197447,
    115.175230172645,
    114.972077893276,
    114.972077893276,
    114.990192804212,
    115.002908433254,
    115.002908433254,
    115.005902971252,
    115.009554289281,
    115.009554289281,
    114.657173409129,
    114.461511331707,
    114.461511331707,
    114.707620112835,
    114.850092006521,
    114.850092006521,
    114.436994680686,
    114.206826752965,
    114.206826752965,
    114.060188343891,
    113.978064794073,
    113.978064794073,
    113.866036441603,
    113.803752327153,
    113.803752327153,
    113.486485707651,
    113.309393388297,
    113.309393388297,
    113.356661906178,
    113.387179602476,
    113.387179602476,
    113.042843265856,
    112.850947131236,
    112.850947131236,
    112.877691263874,
    112.896085980655,
    112.896085980655,
    112.684742706864,
    112.568039760211,
    112.568039760211,
    112.292790520814,
    112.139366582592,
    112.139366582592,
    111.970948216475,
    111.877077463704,
    111.877077463704,
    111.691658757409,
    111.58815622002,
    111.58815622002,
    111.371000968805,
    111.249915095438,
    111.249915095438,
    111.397057109156,
    111.483447058501,
    111.483447058501,
    111.020796295372,
    110.762806635483,
    110.762806635483,
    110.691286236176,
    110.651858582001,
    110.651858582001,
    110.180772158578,
    109.916768652832,
    109.916768652832,
    109.92160038501,
    109.924801621779,
    109.924801621779,
    109.92399496569,
    109.924966523793,
    109.924966523793,
    109.778027097837,
    109.697187303178,
    109.697187303178,
    109.646453109056,
    109.621274977867,
    109.621274977867,
    109.311854601797,
    109.138942898189,
    109.138942898189,
    109.037060022124,
    108.981993015951,
    108.981993015951,
    109.025815833709,
    109.051267151328,
    109.051267151328,
    108.690688937456,
    108.490181651467,
    108.490181651467,
    108.372831031948,
    108.308551659209,
    108.308551659209,
    108.123766108806,
    108.019908111777,
    108.019908111777,
    107.957441604306,
    107.922644893516,
    107.922644893516,
    107.899044276998,
    107.887446145307,
    107.887446145307,
    107.500092481597,
    107.284978828848,
    107.284978828848,
    107.010020579075,
    106.857162866302,
    106.857162866302,
    106.849886345814,
    106.847765023479,
    106.847765023479,
    106.611021031419,
    106.479748319563,
    106.479748319563,
    106.250226787679,
    106.121924563336,
    106.121924563336,
    105.897583038807,
    105.773587421768,
    105.773587421768,
    105.54640291714,
    105.42062505132,
    105.42062505132,
    105.276685871297,
    105.1986313907,
    105.1986313907,
    105.218474126701,
    105.233764673009,
    105.233764673009,
    105.084300858344,
    105.002353375534,
    105.002353375534,
    104.88476444771,
    104.819698451794,
    104.819698451794,
    104.779506612991,
    104.759252630998,
    104.759252630998,
    104.43697005191,
    104.2588840485,
    104.2588840485,
    104.237494409413,
    104.225350388925,
    104.225350388925,
    104.050689973109,
    103.952809162979,
    103.952809162979,
    103.743229662707,
    103.625883798646,
    103.625883798646,
    103.637596356317,
    103.646636851863,
    103.646636851863,
    103.096340878678,
    102.791716478312,
    102.791716478312,
    102.698821068117,
    102.647291965679,
    102.647291965679,
    102.770639094322,
    102.842328109405,
    102.842328109405,
    102.726422967582,
    102.66104221333,
    102.66104221333,
    102.378731693434,
    102.223086975719,
    102.223086975719,
    102.060261748601,
    101.9714648852,
    101.9714648852,
    101.671995022716,
    101.505825186594,
    101.505825186594,
    101.563974271445,
    101.601424775232,
    101.601424775232,
    101.141587225683,
    100.884910967639,
    100.884910967639,
    100.896426257391,
    100.903492216422,
    100.903492216422,
    100.587562464115,
    100.412484418358,
    100.412484418358,
    100.637000202447,
    100.768282240489,
    100.768282240489,
    100.92290016645,
    101.013423459413,
    101.013423459413,
    100.390648438311,
    100.049453481522,
    100.049453481522,
    100.0248671848,
    100.013254914087,
    100.013254914087,
    99.6809852233184,
    99.4962849663844,
    99.4962849663844,
    99.4750133684301,
    99.4643284735625,
    99.4643284735625,
    99.1933090695352,
    99.0458769412893,
    99.0458769412893,
    98.8076473265196,
    98.673167900626,
    98.673167900626,
    98.7556027968672,
    98.8055555328217,
    98.8055555328217,
    98.5924450866925,
    98.4756904574386,
    98.4756904574386,
    98.0632919563109,
    97.8356475996655,
    97.8356475996655,
    98.1152859369337,
    98.2776176379967,
    98.2776176379967,
    98.0373830383905,
    97.9059180824937,
    97.9059180824937,
    97.8279907069201,
    97.7881651541336,
    97.7881651541336,
    97.2586514117057,
    96.9673263373701,
    96.9673263373701,
    97.2170667911211,
    97.3621916932683,
    97.3621916932683,
    97.3534278282232,
    97.3500047557179,
    97.3500047557179,
    97.0119847768311,
    96.8244346959259,
    96.8244346959259,
    96.71441942987,
    96.6561021075345,
    96.6561021075345,
    96.3636615208352,
    96.2008287702108,
    96.2008287702108,
    95.9360063695595,
    95.7894607875575,
    95.7894607875575,
    95.7024313827239,
    95.6564584279754,
    95.6564584279754,
    95.3786289974003,
    95.2259747580971,
    95.2259747580971,
    95.3030127883643,
    95.3506284154881,
    95.3506284154881,
    94.8599594092106,
    94.588431518272,
    94.588431518272,
    94.5141844681088,
    94.4734032569392,
    94.4734032569392,
    94.2735777729398,
    94.1631259428687,
    94.1631259428687,
    94.1915605775468,
    94.209777416015,
    94.209777416015,
    94.1244808847547,
    94.0797501382328,
    94.0797501382328,
    93.7058267248827,
    93.4964427477934,
    93.4964427477934,
    93.3745837684106,
    93.3086388835844,
    93.3086388835844,
    93.4394930937935,
    93.5177968007382,
    93.5177968007382,
    93.3027607023983,
    93.185200030829,
    93.185200030829,
    92.846496549224,
    92.65962492002,
    92.65962492002,
    92.3767395961683,
    92.2191226716168,
    92.2191226716168,
    92.3107316725937,
    92.3658616916537,
    92.3658616916537,
    92.207085171915,
    92.1206356826335,
    92.1206356826335,
    92.1630411145536,
    92.1883113282552,
    92.1883113282552,
    92.1159374695797,
    92.0757291605583,
    92.0757291605583,
    91.7803766229814,
    91.6187975334204,
    91.6187975334204,
    91.4280976280647,
    91.32429251201,
    91.32429251201,
    91.0822061725752,
    90.9500700517284,
    90.9500700517284,
    91.0603468196117,
    91.1252830917007,
    91.1252830917007,
    90.883771660205,
    90.7507521985154,
    90.7507521985154,
    90.4063894213278,
    90.2178252160321,
    90.2178252160321,
    90.1935666304354,
    90.1822024151899,
    90.1822024151899,
    89.7974742549646,
    89.5848058366021,
    89.5848058366021,
    89.4729312178101,
    89.412763392707,
    89.412763392707,
    89.5565333924005,
    89.6397329029796,
    89.6397329029796,
    89.2225548957847,
    88.9942123854799,
    88.9942123854799,
    88.8600879826511,
    88.7877458856651,
    88.7877458856651,
    88.8477794382752,
    88.8824464563576,
    88.8824464563576,
    88.7099431227278,
    88.612811658144,
    88.612811658144,
    88.4573551653359,
    88.3741569029576,
    88.3741569029576,
    88.0521611460097,
    87.8733346310982,
    87.8733346310982,
    87.7681726705063,
    87.7104946205107,
    87.7104946205107,
    87.8589564091199,
    87.9434325674559,
    87.9434325674559,
    87.4170560001167,
    87.1298058866814,
    87.1298058866814,
    86.9731221147279,
    86.886324245692,
    86.886324245692,
    86.5483799588367,
    86.3618313798352,
    86.3618313798352,
    86.5396790054826,
    86.64079287921,
    86.64079287921,
    86.5976528022669,
    86.5740986164066,
    86.5740986164066,
    86.2795923201081,
    86.1190564302549,
    86.1190564302549,
    86.1225409873872,
    86.1273523666928,
    86.1273523666928,
    85.7455974628646,
    85.5366956882735,
    85.5366956882735,
    85.2947820259518,
    85.1622560781839,
    85.1622560781839,
    85.2890460458865,
    85.3655993012992,
    85.3655993012992,
    84.9188803748619,
    84.6729227211391,
    84.6729227211391,
    84.8222346864169,
    84.9116238883104,
    84.9116238883104,
    84.4667213547005,
    84.2246670583398,
    84.2246670583398,
    84.377370752158,
    84.4670705167254,
    84.4670705167254,
    84.5156946046595,
    84.5441029752017,
    84.5441029752017,
    84.4663080860259,
    84.4239539003505,
    84.4239539003505,
    83.9949555109022,
    83.7581451656276,
    83.7581451656276,
    83.8278483409101,
    83.8721124945773,
    83.8721124945773,
    83.5936087767499,
    83.4389183186325,
    83.4389183186325,
    83.3471187826752,
    83.301300594827,
    83.301300594827,
    83.0753276851606,
    82.9491586428524,
    82.9491586428524,
    83.0731543537179,
    83.1440477199396,
    83.1440477199396,
    82.6888718399764,
    82.4388975552009,
    82.4388975552009,
    82.1921741082234,
    82.0534949898047,
    82.0534949898047,
    81.7628888845618,
    81.60331622805,
    81.60331622805,
    81.9219784884158,
    82.1068974190839,
    82.1068974190839,
    82.1056491645469,
    82.1068480202484,
    82.1068480202484,
    81.5852085296109,
    81.2983622197753,
    81.2983622197753,
    80.9322406649895,
    80.7274922862396,
    80.7274922862396,
    80.821052804781,
    80.8761642360697,
    80.8761642360697,
    80.8086024784985,
    80.773693621349,
    80.773693621349,
    80.4378719042583,
    80.2541007124265,
    80.2541007124265,
    80.1498262270004,
    80.092557748881,
    80.092557748881,
    80.1528263459489,
    80.19152174475,
    80.19152174475,
    79.793019166324,
    79.577822012452,
    79.577822012452,
    79.6674871802575,
    79.72075340322,
    79.72075340322,
    79.6389364834281,
    79.595390883957,
    79.595390883957,
    79.1513702334887,
    78.9095918594135,
    78.9095918594135,
    79.2819892081977,
    79.502515502779,
    79.502515502779,
    79.1962695511608,
    79.028872605517,
    79.028872605517,
    78.6203430803733,
    78.398369407151,
    78.398369407151,
    78.4769447344558,
    78.5240650057725,
    78.5240650057725,
    78.1192177671889,
    77.8951956587969,
    77.8951956587969,
    77.5548552928266,
    77.3656355412687,
    77.3656355412687,
    77.3635687383783,
    77.367948630072,
    77.367948630072,
    77.4770164008283,
    77.5429928869682,
    77.5429928869682,
    77.4639707097008,
    77.4237253797849,
    77.4237253797849,
    76.8517377813029,
    76.5412336573068,
    76.5412336573068,
    76.584651348565,
    76.6130255997294,
    76.6130255997294,
    76.5211904478801,
    76.4714841549692,
    76.4714841549692,
    76.330928181629,
    76.2550474945621,
    76.2550474945621,
    76.4212922104646,
    76.5188838195304,
    76.5188838195304,
    76.3556926784161,
    76.2687507884245,
    76.2687507884245,
    75.6580243397573,
    75.3258036507312,
    75.3258036507312,
    75.3535455649985,
    75.3712413571557,
    75.3712413571557,
    75.2771792881909,
    75.2255213892042,
    75.2255213892042,
    75.1932508326932,
    75.1790841955822,
    75.1790841955822,
    74.94750764335,
    74.8188238491448,
    74.8188238491448,
    74.8575214255696,
    74.8818652664594,
    74.8818652664594,
    74.6603091793366,
    74.5406782680448,
    74.5406782680448,
    74.1426621705352,
    73.923014585393,
    73.923014585393,
    74.3440567332862,
    74.5892787220949,
    74.5892787220949,
    73.8116089956882,
    73.3937003015763,
    73.3937003015763,
    73.4938959269357,
    73.5561588244814,
    73.5561588244814,
    73.5862900846388,
    73.6080569166962,
    73.6080569166962,
    73.7339444769667,
    73.8070867155975,
    73.8070867155975,
    73.502136925012,
    73.3320518776648,
    73.3320518776648,
    73.0097787353614,
    72.8336793440766,
    72.8336793440766,
    72.9532376342481,
    73.0249810648869,
    73.0249810648869,
    72.596713637274,
    72.3633690778333,
    72.3633690778333,
    72.0080522300862,
    71.8117238302629,
    71.8117238302629,
    71.805088962458,
    71.8037908656652,
    71.8037908656652,
    71.9208268058489,
    71.9920836160459,
    71.9920836160459,
    71.7974664726959,
    71.6900439215005,
    71.6900439215005,
    71.5067724209314,
    71.4075522037024,
    71.4075522037024,
    71.1240424080365,
    70.9690359154889,
    70.9690359154889,
    70.99001528857,
    71.0021028524165,
    71.0021028524165,
    70.8974881331034,
    70.8411281953344,
    70.8411281953344,
    70.9189629695615,
    70.9653140381396,
    70.9653140381396,
    70.5052243804163,
    70.2540648760079,
    70.2540648760079,
    69.99694731175,
    69.8587148411481,
    69.8587148411481,
    69.5372954963222,
    69.3617010928654,
    69.3617010928654,
    69.4960220224279,
    69.5741304273973,
    69.5741304273973,
    69.7369976543928,
    69.8293681455175,
    69.8293681455175,
    69.6389745059704,
    69.539966252841,
    69.539966252841,
    69.2415004863307,
    69.0760697536777,
    69.0760697536777,
    68.8583480450701,
    68.7379419838508,
    68.7379419838508,
    68.5511530325919,
    68.4481501428595,
    68.4481501428595,
    68.745930971256,
    68.9194131090485,
    68.9194131090485,
    68.6475978906615,
    68.4996190308826,
    68.4996190308826,
    67.9125894799973,
    67.5945244722421,
    67.5945244722421,
    67.8992492764033,
    68.0768949538707,
    68.0768949538707,
    67.5552420213925,
    67.2710301613183,
    67.2710301613183,
    67.6008028477508,
    67.793340941179,
    67.793340941179,
    67.6467867906238,
    67.567958194611,
    67.567958194611,
    67.2839024539548,
    67.1252793631708,
    67.1252793631708,
    66.9038315541334,
    66.7841569980332,
    66.7841569980332,
    66.5885855118841,
    66.4808054417687,
    66.4808054417687,
    66.1668385539603,
    65.9926334985526,
    65.9926334985526,
    66.2606487379841,
    66.4217507038716,
    66.4217507038716,
    66.2637990713182,
    66.1755088438585,
    66.1755088438585,
    65.9914711091202,
    65.8898443779472,
    65.8898443779472,
    65.8424524842008,
    65.8175100786905,
    65.8175100786905,
    65.4121858347014,
    65.1937288012089,
    65.1937288012089,
    64.9322925718351,
    64.7885339856499,
    64.7885339856499,
    64.315775934849,
    64.0565946975343,
    64.0565946975343,
    64.2878267392372,
    64.4255222482767,
    64.4255222482767,
    64.111663385965,
    63.9404856665732,
    63.9404856665732,
    63.9775118261676,
    64.0031388158955,
    64.0031388158955,
    64.1355059971205,
    64.2151944216496,
    64.2151944216496,
    63.8640240819353,
    63.672488608732,
    63.672488608732,
    63.1577582325585,
    62.8782383249094,
    62.8782383249094,
    63.1112137717722,
    63.2481355595314,
    63.2481355595314,
    63.3281346189218,
    63.3782805879771,
    63.3782805879771,
    63.4011128337261,
    63.4178622717517,
    63.4178622717517,
    63.2910254401873,
    63.2240573440718,
    63.2240573440718,
    63.1791396035595,
    63.1574451344783,
    63.1574451344783,
    62.7387575358068,
    62.5124896633737,
    62.5124896633737,
    62.2523963429508,
    62.1095102712094,
    62.1095102712094,
    62.2870051714847,
    62.3890477658171,
    62.3890477658171,
    62.0428511915119,
    61.8555901789333,
    61.8555901789333,
    61.4721054617772,
    61.2628893988287,
    61.2628893988287,
    61.2806603533762,
    61.2931630381164,
    61.2931630381164,
    61.1589405449626,
    61.0861908087528,
    61.0861908087528,
    61.1789701678966,
    61.2356337014166,
    61.2356337014166,
    61.4014078112179,
    61.4979419955239,
    61.4979419955239,
    61.1320806863256,
    60.9347207093518,
    60.9347207093518,
    60.6918790842432,
    60.5545488480178,
    60.5545488480178,
    60.3342264936148,
    60.2099602755113,
    60.2099602755113,
    60.2740654171275,
    60.3116450373248,
    60.3116450373248,
    59.7695017943826,
    59.4758168370393,
    59.4758168370393,
    59.4501354874458,
    59.4393100698879,
    59.4393100698879,
    59.2892509585137,
    59.2093277532662,
    59.2093277532662,
    59.1612584777813,
    59.1351700812374,
    59.1351700812374,
    59.2565455398299,
    59.3285948003535,
    59.3285948003535,
    58.7952916515841,
    58.5061322869577,
    58.5061322869577,
    58.4796807921855,
    58.4665286559412,
    58.4665286559412,
    58.3201830624375,
    58.239706531108,
    58.239706531108,
    57.7516226758462,
    57.4855011080015,
    57.4855011080015,
    57.6229812634005,
    57.7041003729224,
    57.7041003729224,
    57.1551594806274,
    56.8602583108587,
    56.8602583108587,
    57.1189831437338,
    57.2749154526127,
    57.2749154526127,
    57.2134814916818,
    57.1851931458819,
    57.1851931458819,
    57.3108301412009,
    57.3836044198423,
    57.3836044198423,
    57.4235922034088,
    57.4455945821014,
    57.4455945821014,
    56.700819823243,
    56.3050273597052,
    56.3050273597052,
    56.3747669012311,
    56.4167405679045,
    56.4167405679045,
    55.9960874655124,
    55.7649048184337,
    55.7649048184337,
    55.9222841373366,
    56.0191667955977,
    56.0191667955977,
    56.35696459269,
    56.5575336322788,
    56.5575336322788,
    56.0619175038079,
    55.7986007955415,
    55.7986007955415,
    55.6475397641369,
    55.5657855706534,
    55.5657855706534,
    55.8138168789628,
    55.9601354064018,
    55.9601354064018,
    55.1004022278436,
    54.6462211525734,
    54.6462211525734,
    54.5446818118484,
    54.49035259827,
    54.49035259827,
    54.3084839524693,
    54.2075472035326,
    54.2075472035326,
    53.9915951665105,
    53.8742228762707,
    53.8742228762707,
    54.535234003165,
    54.9355121453521,
    54.9355121453521,
    54.5503077376242,
    54.3405675896194,
    54.3405675896194,
    54.3787777672403,
    54.4048876412241,
    54.4048876412241,
    53.7831584187053,
    53.4504012368179,
    53.4504012368179,
    53.5601415244132,
    53.6290894649066,
    53.6290894649066,
    53.1967864031608,
    52.9627053460403,
    52.9627053460403,
    52.8258504572912,
    52.7534672002574,
    52.7534672002574,
    52.7064655981776,
    52.6823723620699,
    52.6823723620699,
    52.3498308811289,
    52.1699379849087,
    52.1699379849087,
    51.7332397726096,
    51.4973877395218,
    51.4973877395218,
    51.6785542073078,
    51.7889846874201,
    51.7889846874201,
    52.1544149963911,
    52.3729012447162,
    52.3729012447162,
    52.3314500813046,
    52.3136071991866,
    52.3136071991866,
    51.9776677393495,
    51.7936382561462,
    51.7936382561462,
    51.8516102467249,
    51.8859020292754,
    51.8859020292754,
    51.5786213500193,
    51.4106940548272,
    51.4106940548272,
    51.6317872596948,
    51.7599401683133,
    51.7599401683133,
    51.8265235052037,
    51.8696020918413,
    51.8696020918413,
    51.5674228409618,
    51.4000480978808,
    51.4000480978808,
    51.4722558661906,
    51.5134518358073,
    51.5134518358073,
    51.1999844219367,
    51.0319485116519,
    51.0319485116519,
    50.772229104459,
    50.6307054659553,
    50.6307054659553,
    50.3803815776356,
    50.2445945539628,
    50.2445945539628,
    50.1668692691804,
    50.1271577988923,
    50.1271577988923,
    49.931186068257,
    49.8282257613261,
    49.8282257613261,
    49.5957299775159,
    49.4671092361583,
    49.4671092361583,
    49.2202918480696,
    49.0840119496944,
    49.0840119496944,
    49.0066565176837,
    48.9674429195125,
    48.9674429195125,
    49.4347705863077,
    49.7122932509725,
    49.7122932509725,
    49.1743518932859,
    48.8881677926199,
    48.8881677926199,
    48.0078164854512,
    47.5414335987348,
    47.5414335987348,
    47.7858689531641,
    47.930763490736,
    47.930763490736,
    48.1765021637549,
    48.3223169318326,
    48.3223169318326,
    48.0589218082436,
    47.9138722782221,
    47.9138722782221,
    47.8329569376473,
    47.7908744965406,
    47.7908744965406,
    47.941460847941,
    48.0279059691562,
    48.0279059691562,
    47.5365952837304,
    47.2730107143955,
    47.2730107143955,
    47.6354232608292,
    47.8475200858185,
    47.8475200858185,
    47.6222574772349,
    47.4997206134681,
    47.4997206134681,
    47.2488103536243,
    47.1077324160406,
    47.1077324160406,
    46.4780039823668,
    46.1419144973107,
    46.1419144973107,
    46.1267593557258,
    46.1199230504219,
    46.1199230504219,
    46.1137729839304,
    46.1111028708645,
    46.1111028708645,
    45.9342384821296,
    45.8369757996474,
    45.8369757996474,
    45.4074949012123,
    45.1706187144304,
    45.1706187144304,
    45.3908113030378,
    45.5175278669543,
    45.5175278669543,
    45.5954133674737,
    45.6429625722813,
    45.6429625722813,
    45.091724085462,
    44.799286646018,
    44.799286646018,
    45.1819501612895,
    45.4140453984344,
    45.4140453984344,
    44.7765662107815,
    44.4370891808609,
    44.4370891808609,
    44.2481975909021,
    44.145994121499,
    44.145994121499,
    45.1189011503076,
    45.7266749689787,
    45.7266749689787,
    45.7206245414413,
    45.7192906006376,
    45.7192906006376,
    44.9266789904416,
    44.5236400982665,
    44.5236400982665,
    44.4887194306759,
    44.4691797603504,
    44.4691797603504,
    44.2683195709815,
    44.1622491554502,
    44.1622491554502,
    44.2836171978741,
    44.3568612817824,
    44.3568612817824,
    44.3922211544868,
    44.4158324909756,
    44.4158324909756,
    43.8416788377646,
    43.5321913637244,
    43.5321913637244,
    43.9113876009798,
    44.1420717404596,
    44.1420717404596,
    43.6905891445934,
    43.4495207575322,
    43.4495207575322,
    43.3099276048005,
    43.2328975081546,
    43.2328975081546,
    42.7961338484301,
    42.5533303111441,
    42.5533303111441,
    42.4193743456697,
    42.3456652943997,
    42.3456652943997,
    41.9030682699241,
    41.659994909471,
    41.659994909471,
    41.5144872983655,
    41.4361568420264,
    41.4361568420264,
    41.3913879334355,
    41.3670628208068,
    41.3670628208068,
    41.5458243770458,
    41.6530551892198,
    41.6530551892198,
    41.5170476340742,
    41.4413529819435,
    41.4413529819435,
    41.3913256822424,
    41.369679490958,
    41.369679490958,
    41.1536560851836,
    41.0306347069699,
    41.0306347069699,
    41.1566836021396,
    41.2369516164638,
    41.2369516164638,
    41.2754232600875,
    41.2946511717976,
    41.2946511717976,
    40.2218888817972,
    39.6721426666522,
    39.6721426666522,
    39.7722606833627,
    39.8359778237517,
    39.8359778237517,
    40.0812944667926,
    40.2209956409764,
    40.2209956409764,
    39.8817823215075,
    39.6981041285439,
    39.6981041285439,
    39.9918126160375,
    40.1655831500094,
    40.1655831500094,
    39.8496238285606,
    39.6755959932914,
    39.6755959932914,
    39.3624197067268,
    39.1895771649521,
    39.1895771649521,
    39.2960695127165,
    39.3637386043786,
    39.3637386043786,
    39.1894745675029,
    39.0923280475378,
    39.0923280475378,
    39.4420312533393,
    39.6546788062083,
    39.6546788062083,
    39.5656483995487,
    39.5189010921211,
    39.5189010921211,
    38.5764049461708,
    38.0863817341291,
    38.0863817341291,
    38.2475266741424,
    38.3413929917407,
    38.3413929917407,
    37.7279331635308,
    37.3965031134466,
    37.3965031134466,
    37.8314323717593,
    38.1036710119108,
    38.1036710119108,
    37.832494662672,
    37.6783183104955,
    37.6783183104955,
    38.2074389678873,
    38.5292329062259,
    38.5292329062259,
    38.5088532359822,
    38.4991212796375,
    38.4991212796375,
    37.7942041484255,
    37.4285335426358,
    37.4285335426358,
    36.9964615600048,
    36.7558905225565,
    36.7558905225565,
    36.3892352975472,
    36.193355026747,
    36.193355026747,
    36.7079265630247,
    37.026943502782,
    37.026943502782,
    36.0327608735755,
    35.5158390500205,
    35.5158390500205,
    35.6767678006309,
    35.7743604500152,
    35.7743604500152,
    36.2544658556156,
    36.5530839363477,
    36.5530839363477,
    36.2731168467515,
    36.1188091440303,
    36.1188091440303,
    35.5469242420382,
    35.2450042989773,
    35.2450042989773,
    35.3031530277971,
    35.3405759814922,
    35.3405759814922,
    35.1336302135378,
    35.0097406962,
    35.0097406962,
    35.3848186727649,
    35.6098363592299,
    35.6098363592299,
    34.4776032576474,
    33.9031071619868,
    33.9031071619868,
    33.826637573424,
    33.7837206079134,
    33.7837206079134,
    34.4178713798156,
    34.8219131801716,
    34.8219131801716,
    34.3355684239563,
    34.0748429164135,
    34.0748429164135,
    34.1629181263602,
    34.217683811734,
    34.217683811734,
    34.2480261158679,
    34.2710010574233,
    34.2710010574233,
    34.0306765643369,
    33.9007781829928,
    33.9007781829928,
    33.8320637790384,
    33.7880787188581,
    33.7880787188581,
    33.2511818902152,
    32.968131812933,
    32.968131812933,
    33.0483124334604,
    33.0969676549688,
    33.0969676549688,
    33.1192010649824,
    33.1369502492329,
    33.1369502492329,
    33.1437874042953,
    33.1501006675933,
    33.1501006675933,
    33.3914283938479,
    33.5396060654126,
    33.5396060654126,
    32.5468967290672,
    32.0466095156238,
    32.0466095156238,
    32.2576898949055,
    32.3908872288785,
    32.3908872288785,
    31.9584701341862,
    31.7165495134596,
    31.7165495134596,
    32.2904062719316,
    32.6499689018345,
    32.6499689018345,
    32.359566242776,
    32.2050270990623,
    32.2050270990623,
    32.6039636192698,
    32.8453341728284,
    32.8453341728284,
    32.9901143480267,
    33.071667556824,
    33.071667556824,
    32.2989117673385,
    31.9025155481747,
    31.9025155481747,
    31.941061242853,
    31.9681299071785,
    31.9681299071785,
    32.2361893873181,
    32.3904953512486,
    32.3904953512486,
    31.3532882507053,
    30.8286502948051,
    30.8286502948051,
    32.124738113037,
    33.0205657367817,
    33.0205657367817,
    32.5509074316148,
    32.3133943181658,
    32.3133943181658,
    30.9821422861002,
    30.3365764368969,
    30.3365764368969,
    30.5143913881648,
    30.6222688136435,
    30.6222688136435,
    29.5266094738469,
    28.9724744342787,
    28.9724744342787,
    29.6417451013014,
    30.0907267397707,
    30.0907267397707,
    30.3714742721468,
    30.543707505901,
    30.543707505901,
    30.6438211545678,
    30.7039286709611,
    30.7039286709611,
    30.4716696893761,
    30.3346743683164,
    30.3346743683164,
    29.0154563184163,
    28.3683654090033,
    28.3683654090033,
    29.2526123232333,
    29.8563869748915,
    29.8563869748915,
    29.4292022835938,
    29.1951043976516,
    29.1951043976516,
    29.0456854894811,
    28.9683202936289,
    28.9683202936289,
    27.6511604434693,
    26.9958038002822,
    26.9958038002822,
    27.8794415524311,
    28.5109543745703,
    28.5109543745703,
    28.9197276586689,
    29.1776407746358,
    29.1776407746358,
    29.0485725807248,
    28.9780147074353,
    28.9780147074353,
    28.9298014316638,
    28.9104616241171,
    28.9104616241171,
    28.2907033309395,
    27.9571985157722,
    27.9571985157722,
    27.7671754679879,
    27.658932654413,
    27.658932654413,
    26.9717320195701,
    26.5979107475506,
    26.5979107475506,
    26.9446494294257,
    27.1764539195126,
    27.1764539195126,
    27.0267256453508,
    26.9436531935865,
    26.9436531935865,
    26.2501505693118,
    25.875914802382,
    25.875914802382,
    26.2295150276886,
    26.4595308246929,
    26.4595308246929,
    27.3684739384634,
    27.9804992097519,
    27.9804992097519,
    27.4580945027109,
    27.1732575254474,
    27.1732575254474,
    26.7002433012424,
    26.4431788695735,
    26.4431788695735,
    26.306211311943,
    26.2199519623239,
    26.2199519623239,
    25.5018948640781,
    25.1180265808448,
    25.1180265808448,
    26.4156271153561,
    27.3674720734471,
    27.3674720734471,
    26.7888604987294,
    26.4842633239342,
    26.4842633239342,
    26.6248841749943,
    26.7181819007065,
    26.7181819007065,
    26.102132789794,
    25.7829485500191,
    25.7829485500191,
    24.4925409639415,
    23.8606159807494,
    23.8606159807494,
    24.6327924747867,
    25.1783435458512,
    25.1783435458512,
    25.2569838576079,
    25.2983157010528,
    25.2983157010528,
    25.6184344724219,
    25.8071410773816,
    25.8071410773816,
    25.2674190497673,
    24.9791657427183,
    24.9791657427183,
    25.1359458673292,
    25.2350052242523,
    25.2350052242523,
    24.205003501676,
    23.6903900717355,
    23.6903900717355,
    24.3067210368211,
    24.7157880717559,
    24.7157880717559,
    24.6679437015921,
    24.647241146043,
    24.647241146043,
    23.9130078606858,
    23.5239201848314,
    23.5239201848314,
    22.5301527907232,
    22.0143812803686,
    22.0143812803686,
    22.6371289547611,
    23.0699307376228,
    23.0699307376228,
    23.9005687207617,
    24.4784321432977,
    24.4784321432977,
    24.182251813718,
    24.0424212146717,
    24.0424212146717,
    23.1853743870135,
    22.7496407102226,
    22.7496407102226,
    23.1429507089465,
    23.4178423094695,
    23.4178423094695,
    23.5703063042724,
    23.6736104244024,
    23.6736104244024,
    23.3694494288623,
    23.2189350665413,
    23.2189350665413,
    23.1176841221317,
    23.0631822320928,
    23.0631822320928,
    22.2593378751778,
    21.8468283220514,
    21.8468283220514,
    22.2717923656741,
    22.5469671941111,
    22.5469671941111,
    21.988284265514,
    21.6897377428429,
    21.6897377428429,
    21.5216569283524,
    21.4182654243298,
    21.4182654243298,
    20.9750363937581,
    20.732526455656,
    20.732526455656,
    20.5863965820083,
    20.5020310969777,
    20.5020310969777,
    20.430989832602,
    20.4090891431832,
    20.4090891431832,
    20.7346748610549,
    20.9482870029131,
    20.9482870029131,
    20.2852839043996,
    19.9304997297944,
    19.9304997297944,
    20.0785956399749,
    20.1684158904813,
    20.1684158904813,
    19.852913200391,
    19.6729872725705,
    19.6729872725705,
    20.2361515369182,
    20.637269230834,
    20.637269230834,
    19.6165307948121,
    19.116803191682,
    19.116803191682,
    19.214387333607,
    19.282356559224,
    19.282356559224,
    19.6774778015793,
    19.9415279204367,
    19.9415279204367,
    20.4544463538906,
    20.789427749456,
    20.789427749456,
    20.995788986626,
    21.1273769126041,
    21.1273769126041,
    20.7945706204743,
    20.6282339100566,
    20.6282339100566,
    19.5952099930102,
    19.0996716989359,
    19.0996716989359,
    19.5551542917968,
    19.8575900365722,
    19.8575900365722,
    18.6900026189416,
    18.1340639695756,
    18.1340639695756,
    18.5907038673722,
    18.890315842322,
    18.890315842322,
    19.0730255268527,
    19.2115727601858,
    19.2115727601858,
    18.8731498710572,
    18.6908548366906,
    18.6908548366906,
    19.2756155044201,
    19.6931909285528,
    19.6931909285528,
    19.9636601139677,
    20.1418331642139,
    20.1418331642139,
    19.8111741552017,
    19.6462728593972,
    19.6462728593972,
    18.5682008743743,
    18.0443259811921,
    18.0443259811921,
    18.520770564358,
    18.8645041288024,
    18.8645041288024,
    19.4392542205268,
    19.8242244852808,
    19.8242244852808,
    18.6156020673338,
    18.0844836680265,
    18.0844836680265,
    19.1442268954198,
    19.9409615807175,
    19.9409615807175,
    19.7021899105901,
    19.5776543494925,
    19.5776543494925,
    18.5075321005836,
    18.0140303562502,
    18.0140303562502,
    16.6104619411567,
    15.9630744774946,
    15.9630744774946,
    16.038460940584,
    16.0792711247406,
    16.0792711247406,
    16.1122379010732,
    16.1204662754535,
    16.1204662754535,
    15.6791296751756,
    15.4252332139065,
    15.4252332139065,
    15.2767912596107,
    15.1605841680827,
    15.1605841680827,
    16.2799848293155,
    17.2727911514934,
    17.2727911514934,
    17.2938645944133,
    17.312060182084,
    17.312060182084,
    18.3406891367734,
    19.1286808344711,
    19.1286808344711,
    19.6617238146799,
    19.9894219696213,
    19.9894219696213,
    18.5873365969238,
    18.0294946483078,
    18.0294946483078,
    17.7371313092108,
    17.5639899492499,
    17.5639899492499,
    17.8927914848832,
    18.1021759566923,
    18.1021759566923,
    18.2241018251517,
    18.3124229313095,
    18.3124229313095,
    17.3165531390006,
    16.8475890997951,
    16.8475890997951,
    16.5844903700147,
    16.4234426569683,
    16.4234426569683,
    17.3814368451442,
    18.1059082311007,
    18.1059082311007,
    17.7656314785508,
    17.5911138530896,
    17.5911138530896,
    15.5332328685484,
    14.7537487417657,
    14.7537487417657,
    15.7749260372916,
    16.5976246990011,
    16.5976246990011,
    16.8537521331004,
    17.037936002361,
    17.037936002361,
    16.676502880339,
    16.4699384980009,
    16.4699384980009,
    15.8208728629185,
    15.4898072798246,
    15.4898072798246,
    15.2888688517272,
    15.165201344708,
    15.165201344708,
    13.8266600973319,
    13.2103950456856,
    13.2103950456856,
    13.965311106684,
    14.6095853707978,
    14.6095853707978,
    15.9014220848448,
    17.0347196007414,
    17.0347196007414,
    16.6752217666444,
    16.48533229238,
    16.48533229238,
    16.3726483971395,
    16.310132460894,
    16.310132460894,
    15.7249197698202,
    15.4317667434323,
    15.4317667434323,
    16.3931561727413,
    17.1196221830167,
    17.1196221830167,
    16.0808638403354,
    15.6118269299206,
    15.6118269299206,
    16.2111380832682,
    16.6371550971699,
    16.6371550971699,
    16.9367511090697,
    17.1128302640758,
    17.1128302640758,
    16.704934656126,
    16.4958906260536,
    16.4958906260536,
    16.377001203243,
    16.3034922961733,
    16.3034922961733,
    15.0137124847613,
    14.4567974254568,
    14.4567974254568,
    14.6256851001717,
    14.7449633780727,
    14.7449633780727,
    15.8477595391738,
    16.7582572276071,
    16.7582572276071,
    16.9986854282343,
    17.1442623536168,
    17.1442623536168,
    16.0776947962762,
    15.612044401309,
    15.612044401309,
    16.2456474120261,
    16.6459013325291,
    16.6459013325291,
    15.8634177522247,
    15.4903525684604,
    15.4903525684604,
    15.2846789993883,
    15.179781117076,
    15.179781117076,
    15.5494161379884,
    15.7962935184509,
    15.7962935184509,
    15.4556369339079,
    15.2583034634194,
    15.2583034634194,
    14.5591290436434,
    14.2012310957678,
    14.2012310957678,
    13.9773328896923,
    13.8445801742883,
    13.8445801742883,
    14.5514124935591,
    15.096379737198,
    15.096379737198,
    15.4900704400596,
    15.7644928779429,
    15.7644928779429,
    14.7609788682087,
    14.3001172857221,
    14.3001172857221,
    15.2347939027133,
    15.9723776825508,
    15.9723776825508,
    15.5321596368273,
    15.2925438088519,
    15.2925438088519,
    16.0072153105113,
    16.5252204217438,
    16.5252204217438,
    12.5295310892563,
    11.7468332280962,
    11.7468332280962,
    12.8654730511111,
    13.9715025337783,
    13.9715025337783,
    14.9962148694631,
    15.8046637221012,
    15.8046637221012,
    15.4278049345878,
    15.2433451139515,
    15.2433451139515,
    13.7012475674847,
    13.0833814551197,
    13.0833814551197,
    12.7431069709336,
    12.5349102648154,
    12.5349102648154,
    12.4010964387727,
    12.2732559683596,
};

static const std::vector<float> ABK = {
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0.00182106757478976,
    0.00200317433226873,
    0.0133185972845723,
    0.0212997054413141,
    0.0220978162569883,
    0.0258215453458907,
    0.0364278988180919,
    0.037488534165312,
    0.0393143616869862,
    0.0405367845451582,
    0.0406590268309754,
    0.049922662774745,
    0.0649601022287534,
    0.0664638461741543,
    0.0705938040820007,
    0.0734287618061249,
    0.0737122575785373,
    0.0846752125735777,
    0.101514057202138,
    0.103197941664994,
    0.107179488927421,
    0.109923620913122,
    0.110198034111692,
    0.11115272711863,
    0.121290061249702,
    0.122303794662809,
    0.132251034539771,
    0.139335519544559,
    0.140043968045038,
    0.143107649666768,
    0.155256644046013,
    0.156471543483937,
    0.167939386714928,
    0.17607535116423,
    0.17688894760916,
    0.181735058216804,
    0.19571318200191,
    0.19711099438042,
    0.198580085956776,
    0.199563082572098,
    0.19966138223363,
    0.209384057574251,
    0.227375266371117,
    0.229174387250804,
    0.233961054217015,
    0.237169816672558,
    0.237490692918112,
    0.24939489833602,
    0.269588988742082,
    0.271608397782688,
    0.275322343836569,
    0.277852007060662,
    0.278104973383071,
    0.279178777611516,
    0.292016666369571,
    0.293300455245376,
    0.302995299457759,
    0.309812555398405,
    0.31049428099247,
    0.31460312347542,
    0.330098576879134,
    0.331648122219505,
    0.340690588055288,
    0.346774102899321,
    0.347382454383725,
    0.350100308492125,
    0.364942746065361,
    0.366426989822684,
    0.36717914131936,
    0.36732227562228,
    0.367336589052572,
    0.372559225025049,
    0.389820627518313,
    0.391546767767639,
    0.392255206200461,
    0.390828414879102,
    0.390685735746967,
    0.388272727596153,
    0.400496649904731,
    0.401719042135589,
    0.401467478152524,
    0.401191050160998,
    0.401163407361845,
    0.400938800690647,
    0.415021312058678,
    0.416429563195481,
    0.411399592406346,
    0.407667777794824,
    0.407294596333672,
    0.404541104868689,
    0.416984675529051,
    0.418229032595088,
    0.414405341818664,
    0.411563928952298,
    0.411279787665661,
    0.407841532023908,
    0.419970013939972,
    0.421182862131579,
    0.420398144263134,
    0.419745808716681,
    0.419680575162035,
    0.413524811844348,
    0.423864739027578,
    0.424898731745901,
    0.424052181208177,
    0.423358315555602,
    0.423288928990344,
    0.418904134919196,
    0.430725407016272,
    0.431907534225979,
    0.430756831763717,
    0.429847908377781,
    0.429757016039187,
    0.427655251961491,
    0.441404998111243,
    0.442779972726218,
    0.437560704402967,
    0.433722333942908,
    0.433338496896902,
    0.431177424310024,
    0.445088180670092,
    0.446479256306099,
    0.442633016008688,
    0.439766813900123,
    0.439480193689266,
    0.437649008867037,
    0.452006557263542,
    0.453442312103192,
    0.451730557280174,
    0.450405480066254,
    0.450272972344862,
    0.444830210006131,
    0.456802370260114,
    0.457999586285513,
    0.456704619750084,
    0.455683836055489,
    0.455581757686029,
    0.449665463398036,
    0.461520248536198,
    0.462705727050014,
    0.459710354949752,
    0.457466292203411,
    0.457241885928777,
    0.4561636157058,
    0.471742946613228,
    0.473300879703971,
    0.467276738877968,
    0.462856768253952,
    0.46241477119155,
    0.460164907880757,
    0.47512182215931,
    0.476617513587166,
    0.470258963719697,
    0.465618495787852,
    0.465154448994667,
    0.464524915823153,
    0.480872834519279,
    0.482507626388892,
    0.482360979459064,
    0.48213358542522,
    0.482110846021836,
    0.475265752302382,
    0.48739371304059,
    0.488606509114411,
    0.488050856598958,
    0.487560233675144,
    0.487511171382763,
    0.479927483459759,
    0.49166359693525,
    0.492837208282799,
    0.489277163942159,
    0.486600835374732,
    0.48633320251799,
    0.486793929324922,
    0.504626563985513,
    0.506409827451572,
    0.499732193615866,
    0.494809059719197,
    0.49431674632953,
    0.493019240249288,
    0.509865182754015,
    0.511549777004487,
    0.502213492665153,
    0.495441056134906,
    0.494763812481881,
    0.49315863393316,
    0.50996428600372,
    0.511644851210776,
    0.50933270539181,
    0.50755245341436,
    0.507374428216615,
    0.500055847235827,
    0.512976394380756,
    0.51426740312371,
    0.512454608774448,
    0.511062462296291,
    0.510921040390769,
    0.500578659118058,
    0.511435562786411,
    0.512562460244628,
    0.510004479502396,
    0.508077493792184,
    0.507873149290538,
    0.506754565537338,
    0.524436294187539,
    0.52634847102655,
    0.516266418552578,
    0.508895643312224,
    0.508082703271025,
    0.506366849397222,
    0.52372314867069,
    0.525675188134111,
    0.515243831220645,
    0.507582009563353,
    0.506703395452785,
    0.504207601523574,
    0.521083543554247,
    0.52305672007789,
    0.522348316564454,
    0.521669740028972,
    0.521588987884157,
    0.513387837009813,
    0.507411205941198,
    0.506687172428336,
    0.523155975703595,
    0.523839933316418,
    0.52392425051153,
    0.514190664362623,
    0.507054099524331,
    0.50615881658533,
    0.521820580133457,
    0.521941568781215,
    0.521957013067328,
    0.52105490517198,
    0.520367527497878,
    0.52027834690927,
    0.530517279646973,
    0.526497877743364,
    0.525968075338538,
    0.522561556568274,
    0.52006998313928,
    0.519736251769233,
    0.529605508792636,
    0.525329857959456,
    0.524747941245609,
    0.520868604836391,
    0.518016101090039,
    0.51762158281379,
    0.537373598539601,
    0.540473165354973,
    0.540908282790482,
    0.53096649996859,
    0.52351786315262,
    0.522456650238875,
    0.519287528004254,
    0.536285490865871,
    0.538743499197594,
    0.530806419987919,
    0.524624451308096,
    0.523717490594673,
    0.520139308888389,
    0.536919284752485,
    0.539417290762369,
    0.538418988892546,
    0.537433725039597,
    0.537285057579766,
    0.529158112323887,
    0.54258229201041,
    0.54463558862203,
    0.540780250681472,
    0.537641070726196,
    0.537154185982231,
    0.527820223937341,
    0.540395446273837,
    0.542372468560922,
    0.539168088793884,
    0.536524915270123,
    0.536103750645282,
    0.535766644635999,
    0.535531149332051,
    0.535493139673111,
    0.545431982574967,
    0.54105450324081,
    0.540339130874531,
    0.536514418784738,
    0.533645905687004,
    0.533171043396692,
    0.544778559349279,
    0.541702872866474,
    0.541187254235653,
    0.538423116425711,
    0.536327393634717,
    0.535971621180093,
    0.554165493826481,
    0.556133698292634,
    0.556471833518854,
    0.547665156351567,
    0.540796640898689,
    0.539602775646286,
    0.536104273993714,
    0.553662045551962,
    0.556749830626668,
    0.546603423655567,
    0.538372840185383,
    0.536908176746689,
    0.533063946263667,
    0.550444512294381,
    0.553574763773919,
    0.553539192348896,
    0.553161707784029,
    0.553092968211126,
    0.542804428334353,
    0.534756482921036,
    0.533274764129906,
    0.550350621650171,
    0.551680509406593,
    0.551928162028108,
    0.543545709440186,
    0.53689621129472,
    0.535644170122959,
    0.552336351211589,
    0.553331216149413,
    0.553520651715002,
    0.552158804629828,
    0.551055977320799,
    0.550843829569024,
    0.563560375839202,
    0.561177063268479,
    0.56071373763484,
    0.557212116657864,
    0.554484741150538,
    0.553949040960385,
    0.544220517116434,
    0.557255272687831,
    0.559842245870015,
    0.557613916071951,
    0.555508086659482,
    0.55508573227269,
    0.551802584612475,
    0.570205799977736,
    0.57393381577949,
    0.565755419789642,
    0.558749167749387,
    0.557316047846691,
    0.554988398831734,
    0.553338079134593,
    0.552997105970941,
    0.562857357280488,
    0.558219018989356,
    0.557251423034137,
    0.552945293283315,
    0.549576122206206,
    0.548866365121176,
    0.569223667306706,
    0.573100862624732,
    0.573925229104047,
    0.562749627367083,
    0.553609102867911,
    0.551648261819677,
    0.550595631443833,
    0.571327564922485,
    0.575817898175363,
    0.566211676902734,
    0.557811112201688,
    0.555974565510408,
    0.553926641551652,
    0.573969636357456,
    0.578393058759041,
    0.576871713370084,
    0.575023603239125,
    0.574612075397833,
    0.563589073801262,
    0.55460295331444,
    0.552584511270694,
    0.570133741853754,
    0.571947538257324,
    0.572358499652211,
    0.563290135532818,
    0.555747046044012,
    0.554022980763273,
    0.572417292700861,
    0.574867329908573,
    0.575432323345308,
    0.575329772392822,
    0.575170699399506,
    0.575133714903812,
    0.565170968119847,
    0.578776653826719,
    0.581966015158756,
    0.578101481690721,
    0.574437437176333,
    0.573571240151619,
    0.565508373302813,
    0.580904382213013,
    0.584574754935348,
    0.580616676781386,
    0.576775388597488,
    0.575852017214897,
    0.575704925232161,
    0.575704084215648,
    0.575703880453904,
    0.58923808918182,
    0.587323943034693,
    0.586856665890756,
    0.579195634458704,
    0.572822477806142,
    0.571254194498324,
    0.562242421666564,
    0.577084736755332,
    0.580765527709531,
    0.577004848778596,
    0.573282013090872,
    0.572351342116476,
    0.572802113598527,
    0.595892338132177,
    0.601708212294643,
    0.59237099386956,
    0.583611675663253,
    0.581388635069576,
    0.577892315797052,
    0.575256489168282,
    0.574582389572031,
    0.586836551880627,
    0.583899762104784,
    0.583143068523972,
    0.580231051029665,
    0.577846972363636,
    0.577227848383511,
    0.575003192702372,
    0.595991214417907,
    0.601481076667961,
    0.59284397973286,
    0.584607377218461,
    0.58243760934622,
    0.57975877556718,
    0.600773227644855,
    0.606349774842542,
    0.597619973843529,
    0.589253702026739,
    0.587017978452987,
    0.581150411068451,
    0.576443854067872,
    0.575176783144239,
    0.598547189464131,
    0.605239988650097,
    0.607054223437673,
    0.598173035228854,
    0.590218956467596,
    0.588048262376084,
    0.58144642410484,
    0.5992787019544,
    0.604179611354844,
    0.597928261646881,
    0.591697204221855,
    0.589972943553751,
    0.584602936424072,
    0.603627625090915,
    0.608929302034453,
    0.606926806207117,
    0.604313277509205,
    0.603580099456351,
    0.593900845434494,
    0.585575068240074,
    0.583223947167425,
    0.601027392279976,
    0.603024381893109,
    0.603592123586617,
    0.596835373759457,
    0.590797613929967,
    0.58906982545257,
    0.581165618068189,
    0.598117616101104,
    0.603001931188906,
    0.605015236199592,
    0.605948924994299,
    0.606219652475709,
    0.597455462951877,
    0.589706043373473,
    0.587445455873407,
    0.605728606728464,
    0.608153336593716,
    0.608865290681641,
    0.597651011018375,
    0.587597604192053,
    0.584626728141084,
    0.579692217713734,
    0.599763493641942,
    0.60573190883135,
    0.606464591284684,
    0.606067676845627,
    0.605948925678796,
    0.595718614346885,
    0.58664236421713,
    0.583910563107966,
    0.60352257762609,
    0.607257924916231,
    0.608389115027686,
    0.597463718194355,
    0.587516922118856,
    0.584486476776107,
    0.60267125167661,
    0.605126256799294,
    0.605879053177232,
    0.606444659090143,
    0.606820985858817,
    0.606937055512135,
    0.599286838647073,
    0.616925470647901,
    0.622397018934612,
    0.618967299441671,
    0.614888479090215,
    0.613615716833964,
    0.604656079368189,
    0.596803393930382,
    0.594338374228081,
    0.61098475287423,
    0.611933970198005,
    0.612233741235014,
    0.611496787228948,
    0.610774112216778,
    0.610544578903426,
    0.600965218996164,
    0.61717779863177,
    0.622354982634093,
    0.616851079200853,
    0.610878241688071,
    0.608959963760996,
    0.600744939795783,
    0.59363054880664,
    0.591332848779549,
    0.612959210385472,
    0.618442706278457,
    0.620224066368152,
    0.62266648002345,
    0.624567796664727,
    0.625188935314704,
    0.614164563090444,
    0.629236449583528,
    0.634186796148261,
    0.628677618922223,
    0.622660764937099,
    0.620673361912309,
    0.609136488199879,
    0.598934073405872,
    0.595545762622136,
    0.61584894425197,
    0.620297841988072,
    0.621783750893634,
    0.620803730140885,
    0.619627202274736,
    0.619232197717893,
    0.608831390432022,
    0.624872537982866,
    0.630286043628221,
    0.627178740569358,
    0.623236464146701,
    0.621898788717188,
    0.608599441738026,
    0.596572167778819,
    0.592469720608437,
    0.615335502356797,
    0.622358550122747,
    0.624767436786133,
    0.625009202143621,
    0.624748412828344,
    0.624658501452705,
    0.610413442077399,
    0.623006474043452,
    0.627369888289994,
    0.629107601969947,
    0.6298499711313,
    0.63010853626134,
    0.622677686483584,
    0.615685238941431,
    0.613237473859784,
    0.628653101128762,
    0.628225999581905,
    0.62807567488114,
    0.629097784949114,
    0.630096640017693,
    0.63044992284339,
    0.620130148563122,
    0.636680205044014,
    0.642562398829218,
    0.634679903494516,
    0.62603094469574,
    0.622941320192968,
    0.614702937342921,
    0.607575271283407,
    0.605016796869425,
    0.630080139703603,
    0.638820774927743,
    0.641974092955404,
    0.640728200437072,
    0.638880793558291,
    0.638211022757605,
    0.62655421153778,
    0.642385936774124,
    0.648152358084282,
    0.642710287009824,
    0.636313220315245,
    0.633971711781783,
    0.625381539439391,
    0.617704182309519,
    0.61488054655073,
    0.637959111561454,
    0.644838743436824,
    0.647381308402232,
    0.645080277523618,
    0.642351989814044,
    0.641339141829301,
    0.629787709249553,
    0.618976773546404,
    0.614944950591739,
    0.639248375899919,
    0.647610594008855,
    0.650743899163097,
    0.639056165059867,
    0.627184939912245,
    0.622716374365643,
    0.617358911450987,
    0.640459123331365,
    0.649196431913335,
    0.652485608193809,
    0.653738599260678,
    0.654214669803195,
    0.643193472905632,
    0.632473293464982,
    0.62838200242675,
    0.648170615838488,
    0.652094622802405,
    0.653598839680689,
    0.642943806055896,
    0.632319528105888,
    0.628229394715391,
    0.623558913493576,
    0.647713589351628,
    0.657055100547725,
    0.658617332464102,
    0.658043718520704,
    0.657820915928307,
    0.648701404792739,
    0.63987363824602,
    0.636429760729541,
    0.632403060908188,
    0.657284576833744,
    0.667033896634368,
    0.660601200086795,
    0.652101759438077,
    0.648757021126517,
    0.640961860317041,
    0.634114247289539,
    0.631407392656638,
    0.654730392600258,
    0.661759421115696,
    0.664549923735082,
    0.655417005979681,
    0.645813732054241,
    0.641985182097356,
    0.636863834579599,
    0.661178741834155,
    0.670913198786802,
    0.662472772723957,
    0.651924392636839,
    0.64768403004923,
    0.641669462768642,
    0.636733465254071,
    0.634740472466102,
    0.660054784131225,
    0.668828172281377,
    0.672385293449536,
    0.665635187039161,
    0.658135876855513,
    0.655083322778106,
    0.649472949040484,
    0.644641836560319,
    0.642667155068471,
    0.656911357140826,
    0.654694821809771,
    0.653785133972821,
    0.647056414353288,
    0.640609599905527,
    0.637952360925641,
    0.64000902989676,
    0.671947668895537,
    0.68516483520306,
    0.680740316577139,
    0.673186799851864,
    0.670049012151144,
    0.662226499530545,
    0.655189450333332,
    0.652254138861948,
    0.639748519870221,
    0.657183260155847,
    0.664484492960315,
    0.66005408826254,
    0.653856377601785,
    0.651250005647503,
    0.65150914538992,
    0.65244580946462,
    0.652841282940725,
    0.672884828600022,
    0.675690800256512,
    0.67687988934878,
    0.671383276727095,
    0.665582093621864,
    0.663113912739193,
    0.652261533403978,
    0.671767036396209,
    0.680097999803243,
    0.675977005200085,
    0.669744206175238,
    0.667071148335102,
    0.666343496888255,
    0.666328359535942,
    0.666321843996047,
    0.652835847349531,
    0.669177710318661,
    0.67623710949655,
    0.683015703869414,
    0.68813533401954,
    0.690355509870972,
    0.675093574023595,
    0.659094556121885,
    0.652130842750028,
    0.670537687482295,
    0.673370671822055,
    0.674608749800341,
    0.675232739451061,
    0.675582494586612,
    0.675735894628962,
    0.667779021049576,
    0.659632194204228,
    0.656046375629054,
    0.679520396362981,
    0.686612073253655,
    0.689745540836256,
    0.681045563438828,
    0.671343899104084,
    0.667042116961794,
    0.657214513013787,
    0.679095705003145,
    0.688832941610032,
    0.691428559051306,
    0.691582418200859,
    0.691651136025786,
    0.685072076572266,
    0.678263078848364,
    0.675211480673983,
    0.669804728892246,
    0.696238577614869,
    0.708127890070669,
    0.700879973408646,
    0.690352189545788,
    0.68560096427716,
    0.674579850511809,
    0.664486289656903,
    0.659913686601172,
    0.657507276885163,
    0.687590617422581,
    0.701268674599707,
    0.697702523994184,
    0.690426726979594,
    0.687107921150136,
    0.683315585731389,
    0.680250150115519,
    0.678846837891657,
    0.694800566144691,
    0.693337425406837,
    0.692665410130485,
    0.690566235778772,
    0.688547663231471,
    0.687617056195868,
    0.678411294436764,
    0.669083173527715,
    0.664768580927122,
    0.686415881073512,
    0.691673955931877,
    0.694113599537814,
    0.694078952342796,
    0.693415301848053,
    0.693106285461968,
    0.67552418413407,
    0.657305837354911,
    0.648794067228696,
    0.674342699676684,
    0.68489212972931,
    0.689838098428002,
    0.687635585714954,
    0.684011648333213,
    0.682307006855231,
    0.671651255098544,
    0.660930035474989,
    0.655870781578555,
    0.68420579147356,
    0.696661165192036,
    0.70255816750917,
    0.693899511003737,
    0.683198001559571,
    0.678114915496193,
    0.671727027199562,
    0.699184186465618,
    0.712269681494379,
    0.717068656920827,
    0.718542004180378,
    0.719246435638561,
    0.703751349526332,
    0.687217776644844,
    0.679287515010138,
    0.668230300933965,
    0.691690222859206,
    0.702979489617691,
    0.698455027053889,
    0.690540624052718,
    0.686720637880973,
    0.679568103590553,
    0.673091593751199,
    0.669955581890278,
    0.668371478529191,
    0.70092640115186,
    0.716742253158043,
    0.711784375506646,
    0.702080420537054,
    0.697351799934935,
    0.693818642387099,
    0.691419145692766,
    0.690246203104098,
    0.671529666067376,
    0.685355867948657,
    0.692134876764442,
    0.694291681390714,
    0.694732333347286,
    0.694949068873164,
    0.697725478475391,
    0.700699616530745,
    0.702166930906491,
    0.690948276967043,
    0.712495126188819,
    0.72315798346848,
    0.724296640574651,
    0.722469814376809,
    0.721562888966968,
    0.708638301644244,
    0.695014168120282,
    0.688229952871293,
    0.678673212577172,
    0.704524476604416,
    0.71743744842581,
    0.721063105241274,
    0.721294049477851,
    0.721409748787957,
    0.709265751461253,
    0.696174963092707,
    0.68959735594252,
    0.682074610015323,
    0.710431871745541,
    0.72472430213323,
    0.717097949718001,
    0.704734849904347,
    0.698485464013568,
    0.690234955494922,
    0.683174366933821,
    0.679594558994354,
    0.677933762556398,
    0.712092989461233,
    0.72946383463948,
    0.724734312528245,
    0.7145441491596,
    0.709347644182338,
    0.700050942652003,
    0.691521744490919,
    0.687159588867172,
    0.670478620273209,
    0.688526067081226,
    0.697782866565209,
    0.696127586402337,
    0.691591028346244,
    0.689257170668855,
    0.691204675017219,
    0.694088632227087,
    0.695576503080837,
    0.687036542041853,
    0.712790596225772,
    0.72611273962547,
    0.73322973887784,
    0.737037682083697,
    0.739013495406789,
    0.7281243215146,
    0.715675628017986,
    0.70919955208793,
    0.696239470853971,
    0.719815566171213,
    0.732117211640316,
    0.744308949889379,
    0.754060172200074,
    0.75916248300555,
    0.743854884460532,
    0.725618807171508,
    0.716052201991592,
    0.704956919704897,
    0.732004097383676,
    0.746233836640778,
    0.738719766639775,
    0.726150406836484,
    0.719519579989072,
    0.710898375266827,
    0.703423587304984,
    0.699468737811787,
    0.697635022200852,
    0.733596511565687,
    0.752674288362046,
    0.754028925879352,
    0.74973182995056,
    0.747446148589988,
    0.735229958813423,
    0.722454125327444,
    0.715639207549061,
    0.706766331135148,
    0.736089694109413,
    0.751772987615584,
    0.749279879611995,
    0.741739982337534,
    0.737696113878131,
    0.73334003059294,
    0.729776921937532,
    0.727860739783947,
    0.714941578321381,
    0.701160773324866,
    0.693730218578157,
    0.716273846132237,
    0.722287151296075,
    0.725538514403813,
    0.720517108207326,
    0.713970945017685,
    0.710422813613058,
    0.700763667012007,
    0.691115114827211,
    0.685870559570149,
    0.72394294778956,
    0.746638220073774,
    0.759006138615076,
    0.749204528557872,
    0.734437156720654,
    0.726370024351348,
    0.710330271630357,
    0.694901996083555,
    0.686451101815816,
    0.708042048279472,
    0.713148188935712,
    0.715952136294464,
    0.711216927289453,
    0.705038453706276,
    0.701636570136743,
    0.699790901934735,
    0.698854813089791,
    0.698338101728585,
    0.688584483271912,
    0.716034841027981,
    0.73122513428185,
    0.737979632126772,
    0.740824324426594,
    0.742402522201141,
    0.726807171957108,
    0.70880872605505,
    0.698799508764529,
    0.689991877157393,
    0.722019636128528,
    0.739878064269954,
    0.75262090817976,
    0.761404793294628,
    0.766315234846325,
    0.751440000608042,
    0.733145119863038,
    0.722893629535869,
    0.71755023262958,
    0.714882919085974,
    0.713384591664429,
    0.735670418499596,
    0.738934912964752,
    0.740773218091771,
    0.740400241301514,
    0.739416198540027,
    0.738860588939508,
    0.737933698100614,
    0.737083809999727,
    0.736602760158183,
    0.759462244876716,
    0.762847834984717,
    0.764768312141669,
    0.757793779337801,
    0.749238919896178,
    0.74437366770296,
    0.735384801426632,
    0.726758449090314,
    0.721841420083855,
    0.710317409159535,
    0.738752735875953,
    0.755003251182677,
    0.763015256862099,
    0.766902424705568,
    0.769129335565188,
    0.757933807531812,
    0.744429267639245,
    0.73667594328866,
    0.720717001302454,
    0.745458092901575,
    0.759697366980934,
    0.755404513834871,
    0.745825029063715,
    0.740298939655229,
    0.735319053135037,
    0.731470392436565,
    0.729244783205508,
    0.729677148023761,
    0.730956382592323,
    0.731697950639047,
    0.75830436738516,
    0.765188450044467,
    0.769187843150596,
    0.768918972319173,
    0.76733260708927,
    0.766408749583213,
    0.751898335799728,
    0.735495375298479,
    0.725921340529204,
    0.757010017970043,
    0.772452660193707,
    0.781488367691051,
    0.780637488648448,
    0.776676895107743,
    0.774354444402217,
    0.75762812979285,
    0.739101412007644,
    0.728214682690643,
    0.718475650615938,
    0.75287308277565,
    0.773131234146991,
    0.777536423857005,
    0.775813649908318,
    0.774796635702725,
    0.764452930362044,
    0.752859702944,
    0.746000234950606,
    0.743740692358773,
    0.743489828452513,
    0.743341050321665,
    0.770058687063988,
    0.776936116402134,
    0.781023744428489,
    0.773565139252954,
    0.763517006932016,
    0.75753147556997,
    0.738889684810013,
    0.71920947270998,
    0.707461430695243,
    0.697931758982977,
    0.73351979265003,
    0.754812669729891,
    0.768600833672954,
    0.777515431603277,
    0.782861263155151,
    0.775072086573138,
    0.76413956579487,
    0.757569851958186,
    0.749869944137651,
    0.74313390552267,
    0.739076884443226,
    0.762513531763398,
    0.766672600770498,
    0.769182734868011,
    0.769579160898391,
    0.769226265738504,
    0.769012787171918,
    0.76567337448018,
    0.76186136704403,
    0.759550166333474,
    0.786780971884048,
    0.794463726707827,
    0.799130908234362,
    0.796765880193151,
    0.792386162578196,
    0.789719684468213,
    0.776715541890479,
    0.762355612964802,
    0.753595596734924,
    0.744376422680697,
    0.781062547424162,
    0.80349469435096,
    0.817933966358266,
    0.827248827060199,
    0.832955852814106,
    0.816993769718324,
    0.79619955716818,
    0.783433319960061,
    0.766361994234337,
    0.750672979922768,
    0.741020484104874,
    0.769804741584189,
    0.781685192293725,
    0.789009756505973,
    0.78502336278545,
    0.777758921495521,
    0.773270690681648,
    0.767557297333517,
    0.762412129071801,
    0.759226714431399,
    0.746275806672435,
    0.77753790795883,
    0.796927861921231,
    0.800141207741997,
    0.797114751190274,
    0.795233463372575,
    0.781609831862604,
    0.766116365812057,
    0.756467043953738,
    0.753462556507306,
    0.753418187512887,
    0.753390493620178,
    0.800591170341025,
    0.830615050994951,
    0.849397219805214,
    0.843633340613758,
    0.830124696370358,
    0.821658931090799,
    0.815651641747907,
    0.811545384823193,
    0.808966577088684,
    0.788688879238277,
    0.812077910480918,
    0.826794461023179,
    0.82974276259662,
    0.828092399266202,
    0.827051944904644,
    0.821235137120249,
    0.81465432884906,
    0.810496646164465,
    0.790337942672645,
    0.767703965612096,
    0.753378890395182,
    0.746647652260096,
    0.791123849482784,
    0.819330038196533,
    0.816519629873328,
    0.803010933654738,
    0.794426656212533,
    0.787400063801152,
    0.782129211702218,
    0.778772785994236,
    0.767623387413825,
    0.755515564275378,
    0.747791245733545,
    0.776699711087257,
    0.787301624191734,
    0.794077792293774,
    0.799175173387649,
    0.803000235523227,
    0.805449645806875,
    0.790841367966673,
    0.772320502009786,
    0.760437277813671,
    0.748091663097827,
    0.785875268322636,
    0.810165734942493,
    0.826575907765046,
    0.837587720053263,
    0.844680959437703,
    0.838332977079956,
    0.828106759576064,
    0.821508197621081,
    0.810468151137603,
    0.799545471034181,
    0.792484068127121,
    0.768995659352977,
    0.7919080541182,
    0.806747747449129,
    0.809970165701444,
    0.80844333253601,
    0.807452402271615,
    0.804536933557233,
    0.801462967520159,
    0.799464309335581,
    0.795587775027071,
    0.791714934989494,
    0.789192921273365,
    0.832758198546919,
    0.85839939379834,
    0.875132723672041,
    0.86459266551023,
    0.845600349165421,
    0.833185751937779,
    0.817961970142475,
    0.804056748497457,
    0.794949851930832,
    0.783321557320585,
    0.772564144300657,
    0.7655056939565,
    0.806845216029903,
    0.831535608841708,
    0.847762157449209,
    0.844407678419894,
    0.834377211013698,
    0.827772856435525,
    0.813603956634587,
    0.798766000340551,
    0.788978002007729,
    0.773286068316812,
    0.808835526613392,
    0.832328350251706,
    0.844698727003407,
    0.851103493677354,
    0.855344620068341,
    0.845116061049816,
    0.831001064814527,
    0.821639326444775,
    0.817001776756208,
    0.814931055998333,
    0.813555100805798,
    0.79180575674209,
    0.817252704392809,
    0.834190646526188,
    0.835775907286786,
    0.831396469195388,
    0.828475768073927,
    0.823162336518706,
    0.817843235648594,
    0.814289499745758,
    0.795243476314673,
    0.773109793192149,
    0.758296798989534,
    0.804776499888262,
    0.838238690870357,
    0.860675961955704,
    0.85836319148287,
    0.847032978601367,
    0.839423782003725,
    0.822321415074694,
    0.804085728537411,
    0.791815756585637,
    0.791828166866505,
    0.79667458553313,
    0.7999413370247,
    0.836062744604998,
    0.849321752969393,
    0.858272823326936,
    0.851434272766734,
    0.839534409771819,
    0.83148528705287,
    0.80919125580327,
    0.784656468994164,
    0.76803788148207,
    0.754616676890139,
    0.798409477264933,
    0.828124394544945,
    0.853853976948137,
    0.874635814054889,
    0.88876395375073,
    0.877739710111536,
    0.858643563940702,
    0.845638809533199,
    0.839389916066332,
    0.836662573986706,
    0.834802100291487,
    0.814951087466486,
    0.845803346814524,
    0.86688236109719,
    0.875135027559437,
    0.87727207506763,
    0.878734773551542,
    0.877560650238929,
    0.875570665259913,
    0.874206262787204,
    0.859388804667958,
    0.841462897298826,
    0.82915509075113,
    0.805771672662759,
    0.836854729810831,
    0.858235847373612,
    0.862031003978578,
    0.85856258017788,
    0.856173545838892,
    0.850121400259071,
    0.84348174454897,
    0.838899333881448,
    0.83782499743107,
    0.838365445211862,
    0.838739043800205,
    0.823216653513309,
    0.860282928815783,
    0.885940483450477,
    0.905250122507695,
    0.919593041589821,
    0.929538888309117,
    0.912425668170447,
    0.887150096875133,
    0.869596674897788,
    0.857064754224473,
    0.848209921239593,
    0.842048455188654,
    0.833730637089743,
    0.883536902121587,
    0.918249741667038,
    0.916145095592514,
    0.899944578934479,
    0.888638209787242,
    0.875317335608401,
    0.863030683915161,
    0.854441451780851,
    0.833375800478044,
    0.810183822779832,
    0.793946632768047,
    0.772973641133947,
    0.810740198667716,
    0.837231315300053,
    0.856476832840558,
    0.870472951817566,
    0.880304581367083,
    0.880955372368027,
    0.877923342879338,
    0.875790215037893,
    0.864221892553137,
    0.850523880576305,
    0.840871501908028,
    0.809300508875422,
    0.831841367774585,
    0.84774911920085,
    0.846648763349401,
    0.839032507106327,
    0.833648504677616,
    0.851982128841886,
    0.877854341228951,
    0.896174356848572,
    0.886387577370302,
    0.866880338713671,
    0.853049148952681,
    0.828603897575149,
    0.863088310255658,
    0.88758060176367,
    0.892740550862392,
    0.88955862009521,
    0.887295688707659,
    0.884935761810423,
    0.882874945716605,
    0.88140670460022,
    0.876615361334084,
    0.871162132939269,
    0.867271078737771,
    0.840769886511623,
    0.869618113308018,
    0.890230322248419,
    0.912918955312069,
    0.933781598491512,
    0.948713825269184,
    0.934939196596968,
    0.911418964154866,
    0.894563943154041,
    0.882042139538502,
    0.872875748155183,
    0.866294850606509,
    0.849537288759253,
    0.830830483551248,
    0.817381715244158,
    0.862454507036788,
    0.890694502055508,
    0.91102581465301,
    0.911894836753927,
    0.904724219887842,
    0.899553783160103,
    0.870599323347978,
    0.835625713163846,
    0.810371250332753,
    0.799979525532485,
    0.797171558415303,
    0.795140874085872,
    0.847338138067059,
    0.879677971845037,
    0.903102107184521,
    0.900942943873987,
    0.888713850745726,
    0.879845710370218,
    0.871406349267363,
    0.864309825613055,
    0.859155757266866,
    0.834456562946898,
    0.804764107855804,
    0.78316813512411,
    0.768460091128286,
    0.822511037129361,
    0.86188313096954,
    0.890819875877571,
    0.912136780495313,
    0.927687860640343,
    0.91831377867051,
    0.899971608501762,
    0.886575616613297,
    0.891194370862386,
    0.902911100944866,
    0.911483100936859,
    0.89363722190082,
    0.921922248342889,
    0.942640288679577,
    0.957860768107011,
    0.966245707868633,
    0.972397775218325,
    0.97024108015112,
    0.964948954991741,
    0.961061034677201,
    0.93934414554156,
    0.912874164023702,
    0.893404231438731,
    0.881838136904133,
    0.875123996178292,
    0.870178544546597,
    0.904089580262416,
    0.926298576881729,
    0.942681274527077,
    0.956418956377395,
    0.967674428311289,
    0.975989769166244,
    0.969428749724446,
    0.957563978993921,
    0.948786213579528,
    0.925769731052877,
    0.899545494414443,
    0.880118695459814,
    0.855628193072424,
    0.892660821364595,
    0.920137414588727,
    0.936153530356731,
    0.941716848887922,
    0.945849990290954,
    0.935678613839685,
    0.920739330924232,
    0.909624316114723,
    0.910275054499055,
    0.916000818918097,
    0.920266443841169,
    0.895443443541653,
    0.921833646174841,
    0.941519413651098,
    0.956247428562919,
    0.967245070404051,
    0.975461283669578,
    0.95413181012238,
    0.921879852527006,
    0.897753050432075,
    0.879950771765656,
    0.866819393522014,
    0.856982260451588,
    0.849542733270673,
    0.844024011830332,
    0.839884175986813,
    0.879556668301777,
    0.909341954138014,
    0.931712439414022,
    0.948562856319641,
    0.961232749888042,
    0.970760840514262,
    0.967449084625743,
    0.954166339346216,
    0.944163566392017,
    0.930265130236373,
    0.916365502324788,
    0.905884216888644,
    0.900675266171604,
    0.924840167393836,
    0.943090118669659,
    0.956908704014758,
    0.967350921680585,
    0.9752449407257,
    0.981230313649936,
    0.984512050108411,
    0.986996475610373,
    0.977202779480543,
    0.963233331382556,
    0.952644934591009,
    0.940664178870865,
    0.929388360127705,
    0.920828437369685,
    0.939730249739595,
    0.954093852243975,
    0.965012503459739,
    0.973334183459249,
    0.979664158881,
    0.984481063346549,
    0.977892680090922,
    0.963081474930453,
    0.95179610494238,
    0.942708005402784,
    0.935643283474417,
    0.930254484885081,
    0.911064185454221,
    0.931911521087053,
    0.947836458405294,
    0.960036776924014,
    0.96936609821674,
    0.976503012880595,
    0.974994151132487,
    0.965769834019064,
    0.95870688148963,
    0.938532463227204,
    0.914916001115136,
    0.89680709194153,
    0.87357444195465,
    0.850708046667385,
    0.833155367818326,
    0.820916889761267,
    0.86202682182514,
    0.893627657170412,
    0.917990761184647,
    0.936740367837143,
    0.951173651809734,
    0.962313845400497,
    0.970068164831677,
    0.976043532117864,
    0.978019813008826,
    0.97821555466134,
    0.978366571460497,
    0.957390689818107,
    0.929563394816609,
    0.908070469179745,
    0.928773555277245,
    0.944779789877287,
    0.957162113282927,
    0.966767882007207,
    0.974204895584354,
    0.979965554501871,
    0.984439721586316,
    0.986140825709964,
    0.987459766554347,
    0.989264549390034,
    0.991265552837567,
    0.992819123743169,
    0.957577587468912,
    0.966948309350889,
    0.974230782242213,
    0.979908665160337,
    0.984326304305645,
    0.987764863648834,
    0.990449057806734,
    0.992540197324316,
    0.994169976440355,
    0.995443689842252,
    0.996436966430384,
    0.997211968570645,
    0.992025236964216,
    0.977512395455748,
    0.966176271209663,
    0.946375828421978,
    0.957965003622453,
    0.967026266164343,
    0.974134240115088,
    0.979698705696117,
    0.984056139287909,
    0.987478301107238,
    0.990161132951943,
    0.992264355460354,
    0.985181592432637,
    0.962070121456862,
    0.943929053821737,
    0.930434603977023,
    0.920314687882356,
    0.912361037993661,
    0.930935523489789,
    0.945541306672136,
    0.957029378208114,
    0.966094038906428,
    0.973231651197851,
    0.97885346499483,
    0.98329460117133,
    0.986796375486573,
    0.989558010390135,
    0.991742029099537,
    0.99239241759978,
    0.992905827458267,
    0.991611369107943,
    0.989786676611113,
    0.988344379464336,
    0.99076089262333,
    0.992672209471732,
    0.994184478733804,
    0.995384654150918,
    0.996335098130955,
    0.997088065389963,
    0.997686332819782,
    0.998160803647648,
    0.998537075411832,
    0.995706322360776,
    0.983999955927578,
    0.974704314395615,
    0.973087480767257,
    0.975301630671354,
    0.977061828871634,
    0.9817144677178,
    0.98541540098008,
    0.988359907837288,
    0.990709943730962,
    0.992581614216556,
    0.994072546547338,
    0.995263834281591,
    0.996213774391026,
    0.996971507230805,
    0.997577595896206,
    0.998061420054138,
    0.998447685051841,
    0.998756986162258,
    0.99900416606014,
    0.999201703253316,
    0.999360056260128,
    0.999486729762073,
    0.999588081020428,
    0.999669419278201,
    0.999734552818763,
    0.999786729481972,
    0.999828650228463,
    0.99986226254601,
    0.999889220468231,
    0.999910902196146,
    0.999928301143633,
    0.999942268712632,
    0.999953515276114,
    0.999962553158157,
    0.999969816129588,
    0.997464934108169,
    0.997955503295715,
    0.998350173367926,
    0.998668656246695,
    0.998925126340664,
    0.999131698047664,
    0.999298570326027,
    0.999433107521289,
    0.999541583995017,
    0.999629303189728,
    0.999700080719421,
    0.999757196203245,
    0.999803434832182,
    0.99984079236274,
    0.999870975973442,
    0.978140990602752,
    0.982275555994867,
    0.985619741588231,
    0.988332958036406,
    0.990529147916152,
    0.992307493793242,
    0.993751918917419,
    0.994922771170116,
    0.995872060478408,
    0.996643861195772,
    0.997269911975188,
    0.997777882780355,
    0.998191338560161,
    0.998527154811055,
    0.998799926941702,
    0.984177910256994,
    0.987100769477391,
    0.989477663635971,
    0.991416576177648,
    0.992994874287796,
    0.994279769333866,
    0.995328986199808,
    0.99618398458108,
    0.996880743165658,
    0.997450282000867,
    0.997914802871003,
    0.998293724981536,
    0.998603789350106,
    0.9988569423311,
    0.999063668318522,
    0.979100746255804,
    0.982871330124831,
    0.985953601390458,
    0.988481223858243,
    0.99054941877919,
    0.992241918306599,
    0.99363130900045,
    0.994769424912806,
    0.995701808934638,
    0.996467989441622,
    0.997096099289062,
    0.997611210736114,
    0.998034948603524,
    0.99838275217043,
    0.998668340254818,
    0.998903496641323,
    0.999096685154724,
    0.999255407362889,
    0.999386240358897,
    0.999493855435591,
    0.999582381055238,
    0.999655423380417,
    0.99971556861518,
    0.999765091180644,
    0.999805991334444,
    0.999839692841899,
    0.999867469399688,
    0.999890433089656,
    0.999909377946278,
    0.999925009521249,
    0.999937944775336,
    0.999948626116262,
    0.999957446354656,
    0.999964752270992,
    0.999970790258504,
    0.999975781091562,
    0.999979919181208,
    0.999983343168842,
    0.99998617672875,
    0.999988528260494,
    0.999990475496755,
    0.999992088070174,
    0.999993427622212,
    0.999994537786634,
    0.999995458140678,
    0.999996223419937,
    0.999996858172731,
    0.999997384700959,
    0.999997822990099,
    0.999998186986988,
    0.999998489300075,
    0.999998741203594,
    0.99999895063258,
    0.999999124816347,
    0.999999270087472,
    0.999999390942684,
    0.999999491533667,
    0.999999575511196,
    0.999999645468673,
    0.99999970374386,
    0.999999752440212,
    0.999999793027107,
    0.999999826866185,
    0.999999855172736,
    0.99999987879688,
    0.999999898517633,
    0.999999915029656,
    0.999999928824157,
    0.999999940353573,
    0.999999950015396,
    0.999999958093783,
    0.999999964848287,
    0.99999997051409,
    0.999999975256133,
    0.999999979225938,
    0.999999982558845,
    0.999999985350531,
    0.999999987689126,
    0.999999989654394,
    0.999999991301738,
    0.999999992683352,
    0.999999993845513,
    0.999999994820863,
    0.999999995639679,
    0.999999996329041,
    0.999999996908028,
    0.999999997394312,
    0.999999997804118,
    0.999999998148699,
    0.999999998438465,
    0.999999998682876,
    0.999999998888514,
    0.999999999061531,
    0.999999999207615,
    0.999999999330675,
    0.999999999434338,
    0.999999999521946,
    0.999999999595834,
    0.999999999658143,
    0.999999999710846,
    0.988552543301307,
    0.978891522496538,
    0.982129242743144,
    0.984864247236653,
    0.9871743981354,
    0.989131953609365,
    0.990786949177347,
    0.992185908054255,
    0.99337244153843,
    0.994376409837371,
    0.995225991973924,
    0.995947223753164,
    0.996558007962065,
    0.997075423043873,
    0.997515058059972,
    0.997887679388156,
    0.99820359503615,
    0.998472262791902,
    0.998700191353929,
    0.998893620830504,
    0.999058265329751,
    0.999198060342405,
    0.999316743140814,
    0.999417861517131,
    0.999503796242378,
    0.999576850353199,
    0.999639148997086,
    0.999692161237258,
    0.999737255449506,
    0.999775743969994,
    0.99980850936561,
    0.999836413235989,
    0.999860250975486,
    0.999880561167072,
    0.999897873213445,
    0.999912675967469,
    0.999925298870131,
    0.999936065611542,
    0.999945280532775,
    0.999953146118644,
    0.999959863027563,
    0.999965617009523,
    0.999970534480088,
    0.999974736866484,
    0.999978339906543,
    0.999981421200614,
    0.99998405693986,
    0.999986318751747,
    0.999988254962067,
    0.999989912758013,
    0.999991336558343,
    0.999992556104034,
    0.999993601092378,
    0.999994499383262,
    0.999995269594244,
    0.999995930253139,
    0.999996498642957,
    0.999996986399421,
    0.999997405039356,
    0.999997765523145,
    0.999998075150752,
    0.999998341087714,
    0.999998570282855,
    0.999998767321151,
    0.999998936715328,
    0.999999082831433,
    0.999999208515018,
    0.999999316649795,
    0.999999410010913,
    0.999999490415887,
    0.999999559652669,
    0.999999619482306,
    0.999999671065631,
    0.999999715521001,
    0.999999753968243,
    0.999999787129326,
    0.999999815735326,
    0.999999840497192,
    0.999999861879489,
    0.999999880344229,
    0.999999896340497,
    0.999999910160442,
    0.999999922099046,
    0.999999932451153,
    0.999999941405341,
    0.999999949148529,
    0.999999955868467,
    0.999999961686305,
    0.999999966723564,
    0.999999971098554,
    0.999999974889024,
    0.999999978172301,
    0.999999981026286,
    0.999999983500951,
    0.999999985646832,
    0.999999987513618,
    0.999999989133071,
    0.999999990538397,
    0.999999991761985,
    0.999999992824482,
    0.9999999937473,
    0.999999994551437,
    0.999999995250556,
    0.999999995858165,
    0.99999999638804,
    0.999999996848892,
    0.99999999724967,
    0.999999997599474,
    0.999999997904052,
    0.999999998169195,
    0.999999998400797,
    0.99999999860256,
    0.999999998778311,
    0.999999998931959,
    0.999999999065933,
    0.999999999182741,
    0.999999999284941,
    0.999999999374141,
    0.999999999452004,
    0.999999999520179,
    0.999999999579715,
    0.999999999631703,
    0.999999999677259,
    0.999999999717078,
    0.999999999751882,
    0.999999999782404,
    0.9999999998091,
    0.999999999832445,
    0.999999999852935,
    0.999999999870871,
    0.999999999886572,
    0.999999999900364,
    0.999999999912448,
    0.999999999923036,
    0.999999999932344,
    0.999999999940502,
    0.999999999947655,
    0.999999999953947,
    0.999999999959469,
    0.999999999964312,
    0.999999999968576,
    0.99999999997232,
    0.999999999975609,
    0.999999999978506,
    0.999999999981053,
    0.99999999998329,
    0.999999999985264,
    0.999999999987001,
    0.999999999988529,
    0.999999999989876,
    0.999999999991063,
    0.999999999992106,
    0.999999999993028,
    0.99999999999384,
    0.999999999994555,
    0.999999999995188,
    0.999999999995745,
    0.999999999996236,
    0.99999999999667,
    0.999999999997053,
    0.999999999997391,
    0.999999999997691,
    0.999999999997955,
    0.999999999998188,
    0.999999999998395,
    0.999999999998577,
    0.999999999998739,
    0.999999999998882,
    0.999999999999008,
    0.99999999999912,
    0.999999999999219,
    0.999999999999307,
    0.999999999999384,
    0.999999999999453,
    0.999999999999514,
    0.999999999999568,
    0.999999999999616,
    0.999999999999659,
    0.999999999999697,
    0.99999999999973,
    0.99999999999976,
    0.999999999999786,
    0.99999999999981,
    0.999999999999831,
    0.999999999999849,
    0.999999999999866,
    0.99999999999988,
    0.999999999999894,
    0.999999999999905,
    0.999999999999915,
    0.999999999999924,
    0.999999999999932,
    0.99999999999994,
    0.999999999999946,
    0.999999999999952,
    0.999999999999957,
    0.999999999999962,
    0.999999999999966,
    0.999999999999969,
    0.999999999999973,
    0.999999999999976,
    0.999999999999978,
    0.99999999999998,
    0.999999999999983,
    0.999999999999984,
    0.999999999999986,
    0.999999999999988,
    0.999999999999989,
    0.99999999999999,
    0.999999999999991,
    0.999999999999992,
    0.999999999999993,
    0.999999999999994,
    0.999999999999994,
    0.999999999999995,
    0.999999999999995,
    0.999999999999996,
    0.999999999999996,
    0.999999999999997,
    0.999999999999997,
    0.999999999999997,
    0.999999999999998,
    0.999999999999998,
    0.999999999999998,
    0.999999999999998,
    0.999999999999998,
    0.999999999999998,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    0.999999999999999,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
};

}  // namespace Boardcore