/* Copyright (c) 2023 Skyward Experimental Rocketry
 * Author: Matteo Pignataro
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#pragma once

#include <algorithms/AirBrakes/TrajectorySet.h>

namespace Boardcore
{

//['Heights ', 'Vz_closed_m28 ', 'Vz_closed_m28_2 ', 'Vz_closed_m28_4 ',
//'Vz_closed_m28_6 ', 'Vz_closed_m28_8 ', 'Vz_closed_m29 ', 'Vz_closed_m29_2 ',
//'Vz_closed_m29_4 ', 'Vz_closed_m29_6 ', 'Vz_closed_m29_8 ', 'Vz_closed_m30 ',
//'Vz_open_m28 ', 'Vz_open_m28_2 ', 'Vz_open_m28_4 ', 'Vz_open_m28_6 ',
//'Vz_open_m28_8 ', 'Vz_open_m29 ', 'Vz_open_m29_2 ', 'Vz_open_m29_4 ',
//'Vz_open_m29_6 ', 'Vz_open_m29_8 ', 'Vz_open_m30 ']
Boardcore::TrajectoryPoint t0_closed[] = {
    Boardcore::TrajectoryPoint(0, 284.315896277823),
    Boardcore::TrajectoryPoint(10, 283.657136638085),
    Boardcore::TrajectoryPoint(20, 282.998894420936),
    Boardcore::TrajectoryPoint(30, 282.341059367907),
    Boardcore::TrajectoryPoint(40, 281.683846961779),
    Boardcore::TrajectoryPoint(50, 281.027042895289),
    Boardcore::TrajectoryPoint(60, 280.370603929448),
    Boardcore::TrajectoryPoint(70, 279.714612785827),
    Boardcore::TrajectoryPoint(80, 279.059095851672),
    Boardcore::TrajectoryPoint(90, 278.403903618511),
    Boardcore::TrajectoryPoint(100, 277.749031812961),
    Boardcore::TrajectoryPoint(110, 277.094629517671),
    Boardcore::TrajectoryPoint(120, 276.440542182417),
    Boardcore::TrajectoryPoint(130, 275.786736231823),
    Boardcore::TrajectoryPoint(140, 275.13324296661),
    Boardcore::TrajectoryPoint(150, 274.480125618842),
    Boardcore::TrajectoryPoint(160, 273.827252100818),
    Boardcore::TrajectoryPoint(170, 273.174617286284),
    Boardcore::TrajectoryPoint(180, 272.522280322407),
    Boardcore::TrajectoryPoint(190, 271.870212071205),
    Boardcore::TrajectoryPoint(200, 271.218346244894),
    Boardcore::TrajectoryPoint(210, 270.566677219977),
    Boardcore::TrajectoryPoint(220, 269.915266957568),
    Boardcore::TrajectoryPoint(230, 269.264049974269),
    Boardcore::TrajectoryPoint(240, 268.612994744106),
    Boardcore::TrajectoryPoint(250, 267.962095260541),
    Boardcore::TrajectoryPoint(260, 267.311401041706),
    Boardcore::TrajectoryPoint(270, 266.660845782434),
    Boardcore::TrajectoryPoint(280, 266.01041237918),
    Boardcore::TrajectoryPoint(290, 265.360094526619),
    Boardcore::TrajectoryPoint(300, 264.709922207644),
    Boardcore::TrajectoryPoint(310, 264.059846713863),
    Boardcore::TrajectoryPoint(320, 263.409853946844),
    Boardcore::TrajectoryPoint(330, 262.759937363144),
    Boardcore::TrajectoryPoint(340, 262.110107200449),
    Boardcore::TrajectoryPoint(350, 261.460336367228),
    Boardcore::TrajectoryPoint(360, 260.810609856933),
    Boardcore::TrajectoryPoint(370, 260.160920930105),
    Boardcore::TrajectoryPoint(380, 259.511265734895),
    Boardcore::TrajectoryPoint(390, 258.861630567632),
    Boardcore::TrajectoryPoint(400, 258.212001976562),
    Boardcore::TrajectoryPoint(410, 257.562373053717),
    Boardcore::TrajectoryPoint(420, 256.912736577593),
    Boardcore::TrajectoryPoint(430, 256.263073452362),
    Boardcore::TrajectoryPoint(440, 255.613379727048),
    Boardcore::TrajectoryPoint(450, 254.963648341273),
    Boardcore::TrajectoryPoint(460, 254.313872088462),
    Boardcore::TrajectoryPoint(470, 253.664033799485),
    Boardcore::TrajectoryPoint(480, 253.014116432877),
    Boardcore::TrajectoryPoint(490, 252.364124555678),
    Boardcore::TrajectoryPoint(500, 251.714050829791),
    Boardcore::TrajectoryPoint(510, 251.063887792338),
    Boardcore::TrajectoryPoint(520, 250.413605917498),
    Boardcore::TrajectoryPoint(530, 249.763199241924),
    Boardcore::TrajectoryPoint(540, 249.1126740975),
    Boardcore::TrajectoryPoint(550, 248.462022895477),
    Boardcore::TrajectoryPoint(560, 247.811237936783),
    Boardcore::TrajectoryPoint(570, 247.160286595277),
    Boardcore::TrajectoryPoint(580, 246.509159003947),
    Boardcore::TrajectoryPoint(590, 245.857868838726),
    Boardcore::TrajectoryPoint(600, 245.20640826949),
    Boardcore::TrajectoryPoint(610, 244.55476936501),
    Boardcore::TrajectoryPoint(620, 243.902935762905),
    Boardcore::TrajectoryPoint(630, 243.250857982253),
    Boardcore::TrajectoryPoint(640, 242.598573240974),
    Boardcore::TrajectoryPoint(650, 241.94607346404),
    Boardcore::TrajectoryPoint(660, 241.293350480597),
    Boardcore::TrajectoryPoint(670, 240.640396026529),
    Boardcore::TrajectoryPoint(680, 239.987176476231),
    Boardcore::TrajectoryPoint(690, 239.333668632239),
    Boardcore::TrajectoryPoint(700, 238.679900669253),
    Boardcore::TrajectoryPoint(710, 238.025864161211),
    Boardcore::TrajectoryPoint(720, 237.371550590239),
    Boardcore::TrajectoryPoint(730, 236.716951348107),
    Boardcore::TrajectoryPoint(740, 236.062046510818),
    Boardcore::TrajectoryPoint(750, 235.406781086565),
    Boardcore::TrajectoryPoint(760, 234.75120112924),
    Boardcore::TrajectoryPoint(770, 234.095297844018),
    Boardcore::TrajectoryPoint(780, 233.43906234454),
    Boardcore::TrajectoryPoint(790, 232.782485653564),
    Boardcore::TrajectoryPoint(800, 232.125558703452),
    Boardcore::TrajectoryPoint(810, 231.468253785197),
    Boardcore::TrajectoryPoint(820, 230.81052840441),
    Boardcore::TrajectoryPoint(830, 230.152423378115),
    Boardcore::TrajectoryPoint(840, 229.493929420176),
    Boardcore::TrajectoryPoint(850, 228.835037150675),
    Boardcore::TrajectoryPoint(860, 228.175737095877),
    Boardcore::TrajectoryPoint(870, 227.516019688064),
    Boardcore::TrajectoryPoint(880, 226.855875265275),
    Boardcore::TrajectoryPoint(890, 226.195268307401),
    Boardcore::TrajectoryPoint(900, 225.534172176346),
    Boardcore::TrajectoryPoint(910, 224.872618722766),
    Boardcore::TrajectoryPoint(920, 224.210598026187),
    Boardcore::TrajectoryPoint(930, 223.548100066883),
    Boardcore::TrajectoryPoint(940, 222.885114725275),
    Boardcore::TrajectoryPoint(950, 222.221631781266),
    Boardcore::TrajectoryPoint(960, 221.557640913501),
    Boardcore::TrajectoryPoint(970, 220.893131698556),
    Boardcore::TrajectoryPoint(980, 220.228093610079),
    Boardcore::TrajectoryPoint(990, 219.562468926014),
    Boardcore::TrajectoryPoint(1000, 218.896280825373),
    Boardcore::TrajectoryPoint(1010, 218.229531926887),
    Boardcore::TrajectoryPoint(1020, 217.562211392583),
    Boardcore::TrajectoryPoint(1030, 216.89430827531),
    Boardcore::TrajectoryPoint(1040, 216.225811517681),
    Boardcore::TrajectoryPoint(1050, 215.556709950981),
    Boardcore::TrajectoryPoint(1060, 214.886992294019),
    Boardcore::TrajectoryPoint(1070, 214.216647151951),
    Boardcore::TrajectoryPoint(1080, 213.545663015054),
    Boardcore::TrajectoryPoint(1090, 212.874028257472),
    Boardcore::TrajectoryPoint(1100, 212.20173113592),
    Boardcore::TrajectoryPoint(1110, 211.528759788356),
    Boardcore::TrajectoryPoint(1120, 210.855102232622),
    Boardcore::TrajectoryPoint(1130, 210.180716649766),
    Boardcore::TrajectoryPoint(1140, 209.505612637972),
    Boardcore::TrajectoryPoint(1150, 208.829787409154),
    Boardcore::TrajectoryPoint(1160, 208.153228590566),
    Boardcore::TrajectoryPoint(1170, 207.475923682021),
    Boardcore::TrajectoryPoint(1180, 206.797860054413),
    Boardcore::TrajectoryPoint(1190, 206.119024948217),
    Boardcore::TrajectoryPoint(1200, 205.439405471952),
    Boardcore::TrajectoryPoint(1210, 204.75898860062),
    Boardcore::TrajectoryPoint(1220, 204.077761174117),
    Boardcore::TrajectoryPoint(1230, 203.395709895613),
    Boardcore::TrajectoryPoint(1240, 202.712821329909),
    Boardcore::TrajectoryPoint(1250, 202.029081901757),
    Boardcore::TrajectoryPoint(1260, 201.344477894162),
    Boardcore::TrajectoryPoint(1270, 200.658995446647),
    Boardcore::TrajectoryPoint(1280, 199.9726205535),
    Boardcore::TrajectoryPoint(1290, 199.285339061979),
    Boardcore::TrajectoryPoint(1300, 198.597136670501),
    Boardcore::TrajectoryPoint(1310, 197.907998926793),
    Boardcore::TrajectoryPoint(1320, 197.217911226018),
    Boardcore::TrajectoryPoint(1330, 196.526858808867),
    Boardcore::TrajectoryPoint(1340, 195.834826759624),
    Boardcore::TrajectoryPoint(1350, 195.141800004197),
    Boardcore::TrajectoryPoint(1360, 194.447763308121),
    Boardcore::TrajectoryPoint(1370, 193.75270127452),
    Boardcore::TrajectoryPoint(1380, 193.056598342045),
    Boardcore::TrajectoryPoint(1390, 192.359438782773),
    Boardcore::TrajectoryPoint(1400, 191.661206700073),
    Boardcore::TrajectoryPoint(1410, 190.961886026432),
    Boardcore::TrajectoryPoint(1420, 190.261460521253),
    Boardcore::TrajectoryPoint(1430, 189.559913768606),
    Boardcore::TrajectoryPoint(1440, 188.857172202004),
    Boardcore::TrajectoryPoint(1450, 188.153269026742),
    Boardcore::TrajectoryPoint(1460, 187.448189188899),
    Boardcore::TrajectoryPoint(1470, 186.741915423956),
    Boardcore::TrajectoryPoint(1480, 186.034430278952),
    Boardcore::TrajectoryPoint(1490, 185.325716109955),
    Boardcore::TrajectoryPoint(1500, 184.615755079489),
    Boardcore::TrajectoryPoint(1510, 183.904529153906),
    Boardcore::TrajectoryPoint(1520, 183.192020100724),
    Boardcore::TrajectoryPoint(1530, 182.478209485905),
    Boardcore::TrajectoryPoint(1540, 181.763078671085),
    Boardcore::TrajectoryPoint(1550, 181.04660881076),
    Boardcore::TrajectoryPoint(1560, 180.328715273349),
    Boardcore::TrajectoryPoint(1570, 179.609382590013),
    Boardcore::TrajectoryPoint(1580, 178.888646313953),
    Boardcore::TrajectoryPoint(1590, 178.166486599113),
    Boardcore::TrajectoryPoint(1600, 177.442883375549),
    Boardcore::TrajectoryPoint(1610, 176.717816346217),
    Boardcore::TrajectoryPoint(1620, 175.991264983712),
    Boardcore::TrajectoryPoint(1630, 175.263208526937),
    Boardcore::TrajectoryPoint(1640, 174.533534920069),
    Boardcore::TrajectoryPoint(1650, 173.802225377022),
    Boardcore::TrajectoryPoint(1660, 173.069339016979),
    Boardcore::TrajectoryPoint(1670, 172.33485394989),
    Boardcore::TrajectoryPoint(1680, 171.598748032066),
    Boardcore::TrajectoryPoint(1690, 170.86099886238),
    Boardcore::TrajectoryPoint(1700, 170.121534278003),
    Boardcore::TrajectoryPoint(1710, 169.380205537019),
    Boardcore::TrajectoryPoint(1720, 168.637155688193),
    Boardcore::TrajectoryPoint(1730, 167.892361085906),
    Boardcore::TrajectoryPoint(1740, 167.145797804217),
    Boardcore::TrajectoryPoint(1750, 166.397441632499),
    Boardcore::TrajectoryPoint(1760, 165.647023401534),
    Boardcore::TrajectoryPoint(1770, 164.894730628019),
    Boardcore::TrajectoryPoint(1780, 164.140560338804),
    Boardcore::TrajectoryPoint(1790, 163.384486945569),
    Boardcore::TrajectoryPoint(1800, 162.626401932071),
    Boardcore::TrajectoryPoint(1810, 161.866129739072),
    Boardcore::TrajectoryPoint(1820, 161.103864671853),
    Boardcore::TrajectoryPoint(1830, 160.339579659454),
    Boardcore::TrajectoryPoint(1840, 159.573209402208),
    Boardcore::TrajectoryPoint(1850, 158.804445900023),
    Boardcore::TrajectoryPoint(1860, 158.033567142151),
    Boardcore::TrajectoryPoint(1870, 157.260544458731),
    Boardcore::TrajectoryPoint(1880, 156.48522130054),
    Boardcore::TrajectoryPoint(1890, 155.707421583945),
    Boardcore::TrajectoryPoint(1900, 154.92737665108),
    Boardcore::TrajectoryPoint(1910, 154.145056104276),
    Boardcore::TrajectoryPoint(1920, 153.360059310648),
    Boardcore::TrajectoryPoint(1930, 152.572642814368),
    Boardcore::TrajectoryPoint(1940, 151.78284294399),
    Boardcore::TrajectoryPoint(1950, 150.990334704067),
    Boardcore::TrajectoryPoint(1960, 150.195178826866),
    Boardcore::TrajectoryPoint(1970, 149.397526378543),
    Boardcore::TrajectoryPoint(1980, 148.597036169432),
    Boardcore::TrajectoryPoint(1990, 147.793753368498),
    Boardcore::TrajectoryPoint(2000, 146.987854999535),
    Boardcore::TrajectoryPoint(2010, 146.178881719645),
    Boardcore::TrajectoryPoint(2020, 145.367063392798),
    Boardcore::TrajectoryPoint(2030, 144.552465240357),
    Boardcore::TrajectoryPoint(2040, 143.734514138909),
    Boardcore::TrajectoryPoint(2050, 142.913729167298),
    Boardcore::TrajectoryPoint(2060, 142.089731765152),
    Boardcore::TrajectoryPoint(2070, 141.262495684009),
    Boardcore::TrajectoryPoint(2080, 140.432218795309),
    Boardcore::TrajectoryPoint(2090, 139.598296951772),
    Boardcore::TrajectoryPoint(2100, 138.761302276592),
    Boardcore::TrajectoryPoint(2110, 137.92060240051),
    Boardcore::TrajectoryPoint(2120, 137.07657122703),
    Boardcore::TrajectoryPoint(2130, 136.228856508492),
    Boardcore::TrajectoryPoint(2140, 135.377529491336),
    Boardcore::TrajectoryPoint(2150, 134.522477421878),
    Boardcore::TrajectoryPoint(2160, 133.663583952264),
    Boardcore::TrajectoryPoint(2170, 132.800855471771),
    Boardcore::TrajectoryPoint(2180, 131.934113049842),
    Boardcore::TrajectoryPoint(2190, 131.063351580555),
    Boardcore::TrajectoryPoint(2200, 130.188465142531),
    Boardcore::TrajectoryPoint(2210, 129.309295548518),
    Boardcore::TrajectoryPoint(2220, 128.425956745029),
    Boardcore::TrajectoryPoint(2230, 127.537984210903),
    Boardcore::TrajectoryPoint(2240, 126.645848053237),
    Boardcore::TrajectoryPoint(2250, 125.748679454573),
    Boardcore::TrajectoryPoint(2260, 124.847091653476),
    Boardcore::TrajectoryPoint(2270, 123.940606082379),
    Boardcore::TrajectoryPoint(2280, 123.029115169853),
    Boardcore::TrajectoryPoint(2290, 122.112848784536),
    Boardcore::TrajectoryPoint(2300, 121.19107952654),
    Boardcore::TrajectoryPoint(2310, 120.264164319095),
    Boardcore::TrajectoryPoint(2320, 119.332057777018),
    Boardcore::TrajectoryPoint(2330, 118.394020065317),
    Boardcore::TrajectoryPoint(2340, 117.450451112657),
    Boardcore::TrajectoryPoint(2350, 116.501233778488),
    Boardcore::TrajectoryPoint(2360, 115.545862098958),
    Boardcore::TrajectoryPoint(2370, 114.584293331735),
    Boardcore::TrajectoryPoint(2380, 113.616573177526),
    Boardcore::TrajectoryPoint(2390, 112.642516077586),
    Boardcore::TrajectoryPoint(2400, 111.661667904102),
    Boardcore::TrajectoryPoint(2410, 110.673917413237),
    Boardcore::TrajectoryPoint(2420, 109.679255284603),
    Boardcore::TrajectoryPoint(2430, 108.677467766923),
    Boardcore::TrajectoryPoint(2440, 107.668332803286),
    Boardcore::TrajectoryPoint(2450, 106.651619640786),
    Boardcore::TrajectoryPoint(2460, 105.62691413527),
    Boardcore::TrajectoryPoint(2470, 104.594091963817),
    Boardcore::TrajectoryPoint(2480, 103.552981558539),
    Boardcore::TrajectoryPoint(2490, 102.503315637951),
    Boardcore::TrajectoryPoint(2500, 101.444816053612),
    Boardcore::TrajectoryPoint(2510, 100.377193247753),
    Boardcore::TrajectoryPoint(2520, 99.3001456775904),
    Boardcore::TrajectoryPoint(2530, 98.2133592039481),
    Boardcore::TrajectoryPoint(2540, 97.1165064416012),
    Boardcore::TrajectoryPoint(2550, 96.0092460685571),
    Boardcore::TrajectoryPoint(2560, 94.8912220912357),
    Boardcore::TrajectoryPoint(2570, 93.7620630622572),
    Boardcore::TrajectoryPoint(2580, 92.6210183309726),
    Boardcore::TrajectoryPoint(2590, 91.4679536822406),
    Boardcore::TrajectoryPoint(2600, 90.3024547905362),
    Boardcore::TrajectoryPoint(2610, 89.124074035841),
    Boardcore::TrajectoryPoint(2620, 87.9323360839682),
    Boardcore::TrajectoryPoint(2630, 86.72596547001),
    Boardcore::TrajectoryPoint(2640, 85.5051334642366),
    Boardcore::TrajectoryPoint(2650, 84.2692955417786),
    Boardcore::TrajectoryPoint(2660, 83.0168371674722),
    Boardcore::TrajectoryPoint(2670, 81.7479889880197),
    Boardcore::TrajectoryPoint(2680, 80.4614332545315),
    Boardcore::TrajectoryPoint(2690, 79.1564925657379),
    Boardcore::TrajectoryPoint(2700, 77.8321165223271),
    Boardcore::TrajectoryPoint(2710, 76.4876077992114),
    Boardcore::TrajectoryPoint(2720, 75.1211679875941),
    Boardcore::TrajectoryPoint(2730, 73.7324173402673),
    Boardcore::TrajectoryPoint(2740, 72.3197984880435),
    Boardcore::TrajectoryPoint(2750, 70.88126013618),
    Boardcore::TrajectoryPoint(2760, 69.41585773448),
    Boardcore::TrajectoryPoint(2770, 67.9217571989799),
    Boardcore::TrajectoryPoint(2780, 66.3969582212811),
    Boardcore::TrajectoryPoint(2790, 64.8392752153856),
    Boardcore::TrajectoryPoint(2800, 63.2463155742377),
    Boardcore::TrajectoryPoint(2810, 61.6154547820958),
    Boardcore::TrajectoryPoint(2820, 59.9431421870297),
    Boardcore::TrajectoryPoint(2830, 58.2259348721686),
    Boardcore::TrajectoryPoint(2840, 56.4605777295364),
    Boardcore::TrajectoryPoint(2850, 54.6408155569451),
    Boardcore::TrajectoryPoint(2860, 52.7623725075133),
    Boardcore::TrajectoryPoint(2870, 50.8184261490708),
    Boardcore::TrajectoryPoint(2880, 48.8008478122156),
    Boardcore::TrajectoryPoint(2890, 46.7001272449699),
    Boardcore::TrajectoryPoint(2900, 44.5050675300325),
    Boardcore::TrajectoryPoint(2910, 42.1999742592349),
    Boardcore::TrajectoryPoint(2920, 39.7666846082259),
    Boardcore::TrajectoryPoint(2930, 37.1794318447989),
    Boardcore::TrajectoryPoint(2940, 34.4044658096754),
    Boardcore::TrajectoryPoint(2950, 31.3904700778418),
    Boardcore::TrajectoryPoint(2960, 28.062039285106),
    Boardcore::TrajectoryPoint(2970, 24.2887250381831),
    Boardcore::TrajectoryPoint(2980, 19.820548908405),
    Boardcore::TrajectoryPoint(2990, 14.0063840180364),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t1_closed[] = {
    Boardcore::TrajectoryPoint(0, 283.979995680513),
    Boardcore::TrajectoryPoint(10, 283.323354974336),
    Boardcore::TrajectoryPoint(20, 282.667394812745),
    Boardcore::TrajectoryPoint(30, 282.01193885835),
    Boardcore::TrajectoryPoint(40, 281.357007842347),
    Boardcore::TrajectoryPoint(50, 280.702436612565),
    Boardcore::TrajectoryPoint(60, 280.048221476578),
    Boardcore::TrajectoryPoint(70, 279.394558468066),
    Boardcore::TrajectoryPoint(80, 278.741227671035),
    Boardcore::TrajectoryPoint(90, 278.088212833675),
    Boardcore::TrajectoryPoint(100, 277.435584272394),
    Boardcore::TrajectoryPoint(110, 276.783352845363),
    Boardcore::TrajectoryPoint(120, 276.131398797318),
    Boardcore::TrajectoryPoint(130, 275.479717385509),
    Boardcore::TrajectoryPoint(140, 274.828419134835),
    Boardcore::TrajectoryPoint(150, 274.177393113707),
    Boardcore::TrajectoryPoint(160, 273.526602452906),
    Boardcore::TrajectoryPoint(170, 272.876053847586),
    Boardcore::TrajectoryPoint(180, 272.225829292522),
    Boardcore::TrajectoryPoint(190, 271.575804185151),
    Boardcore::TrajectoryPoint(200, 270.92597311169),
    Boardcore::TrajectoryPoint(210, 270.276358945417),
    Boardcore::TrajectoryPoint(220, 269.626979776803),
    Boardcore::TrajectoryPoint(230, 268.977759915061),
    Boardcore::TrajectoryPoint(240, 268.328693537443),
    Boardcore::TrajectoryPoint(250, 267.679802511388),
    Boardcore::TrajectoryPoint(260, 267.031080511676),
    Boardcore::TrajectoryPoint(270, 266.382478391066),
    Boardcore::TrajectoryPoint(280, 265.733990006687),
    Boardcore::TrajectoryPoint(290, 265.085627439136),
    Boardcore::TrajectoryPoint(300, 264.437381837581),
    Boardcore::TrajectoryPoint(310, 263.789217405893),
    Boardcore::TrajectoryPoint(320, 263.141127745642),
    Boardcore::TrajectoryPoint(330, 262.493113450925),
    Boardcore::TrajectoryPoint(340, 261.8451702244),
    Boardcore::TrajectoryPoint(350, 261.19727014499),
    Boardcore::TrajectoryPoint(360, 260.549406604143),
    Boardcore::TrajectoryPoint(370, 259.901573040789),
    Boardcore::TrajectoryPoint(380, 259.253764197954),
    Boardcore::TrajectoryPoint(390, 258.605961106473),
    Boardcore::TrajectoryPoint(400, 257.958156978025),
    Boardcore::TrajectoryPoint(410, 257.310344856011),
    Boardcore::TrajectoryPoint(420, 256.662510493155),
    Boardcore::TrajectoryPoint(430, 256.014642261374),
    Boardcore::TrajectoryPoint(440, 255.366735983466),
    Boardcore::TrajectoryPoint(450, 254.718784560337),
    Boardcore::TrajectoryPoint(460, 254.070780438844),
    Boardcore::TrajectoryPoint(470, 253.422689455392),
    Boardcore::TrajectoryPoint(480, 252.774523881038),
    Boardcore::TrajectoryPoint(490, 252.126276479109),
    Boardcore::TrajectoryPoint(500, 251.47793988572),
    Boardcore::TrajectoryPoint(510, 250.82949904854),
    Boardcore::TrajectoryPoint(520, 250.180920743245),
    Boardcore::TrajectoryPoint(530, 249.532224282122),
    Boardcore::TrajectoryPoint(540, 248.883402171605),
    Boardcore::TrajectoryPoint(550, 248.234446806129),
    Boardcore::TrajectoryPoint(560, 247.585343356597),
    Boardcore::TrajectoryPoint(570, 246.936047680122),
    Boardcore::TrajectoryPoint(580, 246.286590124102),
    Boardcore::TrajectoryPoint(590, 245.636962949933),
    Boardcore::TrajectoryPoint(600, 244.987158316839),
    Boardcore::TrajectoryPoint(610, 244.33716828571),
    Boardcore::TrajectoryPoint(620, 243.686938822603),
    Boardcore::TrajectoryPoint(630, 243.036492170714),
    Boardcore::TrajectoryPoint(640, 242.385831645506),
    Boardcore::TrajectoryPoint(650, 241.734949165502),
    Boardcore::TrajectoryPoint(660, 241.083836555517),
    Boardcore::TrajectoryPoint(670, 240.432480971744),
    Boardcore::TrajectoryPoint(680, 239.780818287837),
    Boardcore::TrajectoryPoint(690, 239.128897029159),
    Boardcore::TrajectoryPoint(700, 238.476708859552),
    Boardcore::TrajectoryPoint(710, 237.824245350991),
    Boardcore::TrajectoryPoint(720, 237.171497985134),
    Boardcore::TrajectoryPoint(730, 236.518458154641),
    Boardcore::TrajectoryPoint(740, 235.865057221914),
    Boardcore::TrajectoryPoint(750, 235.211335109012),
    Boardcore::TrajectoryPoint(760, 234.557291788741),
    Boardcore::TrajectoryPoint(770, 233.902918467079),
    Boardcore::TrajectoryPoint(780, 233.248206259538),
    Boardcore::TrajectoryPoint(790, 232.593146191725),
    Boardcore::TrajectoryPoint(800, 231.93772771501),
    Boardcore::TrajectoryPoint(810, 231.281873972547),
    Boardcore::TrajectoryPoint(820, 230.625643214324),
    Boardcore::TrajectoryPoint(830, 229.969026250578),
    Boardcore::TrajectoryPoint(840, 229.312013798482),
    Boardcore::TrajectoryPoint(850, 228.654596482155),
    Boardcore::TrajectoryPoint(860, 227.996764832562),
    Boardcore::TrajectoryPoint(870, 227.338509287296),
    Boardcore::TrajectoryPoint(880, 226.679805553698),
    Boardcore::TrajectoryPoint(890, 226.020604107579),
    Boardcore::TrajectoryPoint(900, 225.360948711131),
    Boardcore::TrajectoryPoint(910, 224.700829547428),
    Boardcore::TrajectoryPoint(920, 224.040236701323),
    Boardcore::TrajectoryPoint(930, 223.379160158895),
    Boardcore::TrajectoryPoint(940, 222.717589806812),
    Boardcore::TrajectoryPoint(950, 222.055515431638),
    Boardcore::TrajectoryPoint(960, 221.392926719054),
    Boardcore::TrajectoryPoint(970, 220.729813253032),
    Boardcore::TrajectoryPoint(980, 220.066117005631),
    Boardcore::TrajectoryPoint(990, 219.401860842909),
    Boardcore::TrajectoryPoint(1000, 218.737048286915),
    Boardcore::TrajectoryPoint(1010, 218.071668614773),
    Boardcore::TrajectoryPoint(1020, 217.40571099576),
    Boardcore::TrajectoryPoint(1030, 216.739164490278),
    Boardcore::TrajectoryPoint(1040, 216.072018048785),
    Boardcore::TrajectoryPoint(1050, 215.404260510682),
    Boardcore::TrajectoryPoint(1060, 214.735880603155),
    Boardcore::TrajectoryPoint(1070, 214.066866939982),
    Boardcore::TrajectoryPoint(1080, 213.397208020297),
    Boardcore::TrajectoryPoint(1090, 212.726892227324),
    Boardcore::TrajectoryPoint(1100, 212.055907827071),
    Boardcore::TrajectoryPoint(1110, 211.384229328895),
    Boardcore::TrajectoryPoint(1120, 210.711830844694),
    Boardcore::TrajectoryPoint(1130, 210.038729339944),
    Boardcore::TrajectoryPoint(1140, 209.364912701492),
    Boardcore::TrajectoryPoint(1150, 208.690368691815),
    Boardcore::TrajectoryPoint(1160, 208.015084947599),
    Boardcore::TrajectoryPoint(1170, 207.339048978283),
    Boardcore::TrajectoryPoint(1180, 206.662248164586),
    Boardcore::TrajectoryPoint(1190, 205.984669756988),
    Boardcore::TrajectoryPoint(1200, 205.306300874199),
    Boardcore::TrajectoryPoint(1210, 204.627128501587),
    Boardcore::TrajectoryPoint(1220, 203.947139489585),
    Boardcore::TrajectoryPoint(1230, 203.266320552066),
    Boardcore::TrajectoryPoint(1240, 202.584658264696),
    Boardcore::TrajectoryPoint(1250, 201.90213906325),
    Boardcore::TrajectoryPoint(1260, 201.218749241912),
    Boardcore::TrajectoryPoint(1270, 200.534474951533),
    Boardcore::TrajectoryPoint(1280, 199.849302197877),
    Boardcore::TrajectoryPoint(1290, 199.163216839821),
    Boardcore::TrajectoryPoint(1300, 198.476204587542),
    Boardcore::TrajectoryPoint(1310, 197.788251000662),
    Boardcore::TrajectoryPoint(1320, 197.099341486375),
    Boardcore::TrajectoryPoint(1330, 196.409461297533),
    Boardcore::TrajectoryPoint(1340, 195.718595530709),
    Boardcore::TrajectoryPoint(1350, 195.026729124225),
    Boardcore::TrajectoryPoint(1360, 194.333846856149),
    Boardcore::TrajectoryPoint(1370, 193.639933342259),
    Boardcore::TrajectoryPoint(1380, 192.944973033975),
    Boardcore::TrajectoryPoint(1390, 192.248950216256),
    Boardcore::TrajectoryPoint(1400, 191.551849005461),
    Boardcore::TrajectoryPoint(1410, 190.853653347175),
    Boardcore::TrajectoryPoint(1420, 190.154347014001),
    Boardcore::TrajectoryPoint(1430, 189.45391360331),
    Boardcore::TrajectoryPoint(1440, 188.752336534954),
    Boardcore::TrajectoryPoint(1450, 188.049542252564),
    Boardcore::TrajectoryPoint(1460, 187.345557916114),
    Boardcore::TrajectoryPoint(1470, 186.640373857661),
    Boardcore::TrajectoryPoint(1480, 185.933972638421),
    Boardcore::TrajectoryPoint(1490, 185.226336628708),
    Boardcore::TrajectoryPoint(1500, 184.517448005359),
    Boardcore::TrajectoryPoint(1510, 183.807288749109),
    Boardcore::TrajectoryPoint(1520, 183.09584064192),
    Boardcore::TrajectoryPoint(1530, 182.383085264257),
    Boardcore::TrajectoryPoint(1540, 181.669003992319),
    Boardcore::TrajectoryPoint(1550, 180.953577995214),
    Boardcore::TrajectoryPoint(1560, 180.236785461927),
    Boardcore::TrajectoryPoint(1570, 179.518484663873),
    Boardcore::TrajectoryPoint(1580, 178.798774623333),
    Boardcore::TrajectoryPoint(1590, 178.077635509369),
    Boardcore::TrajectoryPoint(1600, 177.355047267178),
    Boardcore::TrajectoryPoint(1610, 176.630989614891),
    Boardcore::TrajectoryPoint(1620, 175.905442040298),
    Boardcore::TrajectoryPoint(1630, 175.178383797516),
    Boardcore::TrajectoryPoint(1640, 174.449763950264),
    Boardcore::TrajectoryPoint(1650, 173.71944071251),
    Boardcore::TrajectoryPoint(1660, 172.987535118261),
    Boardcore::TrajectoryPoint(1670, 172.254025292992),
    Boardcore::TrajectoryPoint(1680, 171.518889108541),
    Boardcore::TrajectoryPoint(1690, 170.782104179302),
    Boardcore::TrajectoryPoint(1700, 170.043647858342),
    Boardcore::TrajectoryPoint(1710, 169.303281807751),
    Boardcore::TrajectoryPoint(1720, 168.561178898615),
    Boardcore::TrajectoryPoint(1730, 167.817325795918),
    Boardcore::TrajectoryPoint(1740, 167.071698589387),
    Boardcore::TrajectoryPoint(1750, 166.324273084035),
    Boardcore::TrajectoryPoint(1760, 165.574837788051),
    Boardcore::TrajectoryPoint(1770, 164.823463919881),
    Boardcore::TrajectoryPoint(1780, 164.070207166241),
    Boardcore::TrajectoryPoint(1790, 163.315041954496),
    Boardcore::TrajectoryPoint(1800, 162.557916699708),
    Boardcore::TrajectoryPoint(1810, 161.798540977602),
    Boardcore::TrajectoryPoint(1820, 161.037167067354),
    Boardcore::TrajectoryPoint(1830, 160.273767913655),
    Boardcore::TrajectoryPoint(1840, 159.508316125945),
    Boardcore::TrajectoryPoint(1850, 158.740444712451),
    Boardcore::TrajectoryPoint(1860, 157.970434904033),
    Boardcore::TrajectoryPoint(1870, 157.198275928269),
    Boardcore::TrajectoryPoint(1880, 156.42386552803),
    Boardcore::TrajectoryPoint(1890, 155.646917932632),
    Boardcore::TrajectoryPoint(1900, 154.867719920544),
    Boardcore::TrajectoryPoint(1910, 154.086241109456),
    Boardcore::TrajectoryPoint(1920, 153.302133333267),
    Boardcore::TrajectoryPoint(1930, 152.515547057091),
    Boardcore::TrajectoryPoint(1940, 151.726572263282),
    Boardcore::TrajectoryPoint(1950, 150.934935525983),
    Boardcore::TrajectoryPoint(1960, 150.140593258269),
    Boardcore::TrajectoryPoint(1970, 149.343749317507),
    Boardcore::TrajectoryPoint(1980, 148.544112980687),
    Boardcore::TrajectoryPoint(1990, 147.741627271745),
    Boardcore::TrajectoryPoint(2000, 146.936520934375),
    Boardcore::TrajectoryPoint(2010, 146.128383797904),
    Boardcore::TrajectoryPoint(2020, 145.31734614102),
    Boardcore::TrajectoryPoint(2030, 144.503562704621),
    Boardcore::TrajectoryPoint(2040, 143.686390869216),
    Boardcore::TrajectoryPoint(2050, 142.866370242708),
    Boardcore::TrajectoryPoint(2060, 142.04317958661),
    Boardcore::TrajectoryPoint(2070, 141.216696575636),
    Boardcore::TrajectoryPoint(2080, 140.387214766293),
    Boardcore::TrajectoryPoint(2090, 139.554034750198),
    Boardcore::TrajectoryPoint(2100, 138.717776977277),
    Boardcore::TrajectoryPoint(2110, 137.877854155022),
    Boardcore::TrajectoryPoint(2120, 137.034548700806),
    Boardcore::TrajectoryPoint(2130, 136.187599234431),
    Boardcore::TrajectoryPoint(2140, 135.336986787808),
    Boardcore::TrajectoryPoint(2150, 134.482688107372),
    Boardcore::TrajectoryPoint(2160, 133.624498094645),
    Boardcore::TrajectoryPoint(2170, 132.762511083891),
    Boardcore::TrajectoryPoint(2180, 131.896461040971),
    Boardcore::TrajectoryPoint(2190, 131.026429070939),
    Boardcore::TrajectoryPoint(2200, 130.152223970377),
    Boardcore::TrajectoryPoint(2210, 129.27377185851),
    Boardcore::TrajectoryPoint(2220, 128.391103387724),
    Boardcore::TrajectoryPoint(2230, 127.50383627625),
    Boardcore::TrajectoryPoint(2240, 126.612382062968),
    Boardcore::TrajectoryPoint(2250, 125.715884209715),
    Boardcore::TrajectoryPoint(2260, 124.814983797781),
    Boardcore::TrajectoryPoint(2270, 123.909140464379),
    Boardcore::TrajectoryPoint(2280, 122.998324763342),
    Boardcore::TrajectoryPoint(2290, 122.082727565252),
    Boardcore::TrajectoryPoint(2300, 121.161583483872),
    Boardcore::TrajectoryPoint(2310, 120.235325217371),
    Boardcore::TrajectoryPoint(2320, 119.303869512019),
    Boardcore::TrajectoryPoint(2330, 118.36643998519),
    Boardcore::TrajectoryPoint(2340, 117.423509564287),
    Boardcore::TrajectoryPoint(2350, 116.474924585601),
    Boardcore::TrajectoryPoint(2360, 115.520144171044),
    Boardcore::TrajectoryPoint(2370, 114.559195404559),
    Boardcore::TrajectoryPoint(2380, 113.592089009915),
    Boardcore::TrajectoryPoint(2390, 112.618639396301),
    Boardcore::TrajectoryPoint(2400, 111.638359518615),
    Boardcore::TrajectoryPoint(2410, 110.65120409129),
    Boardcore::TrajectoryPoint(2420, 109.657130697347),
    Boardcore::TrajectoryPoint(2430, 108.655925557365),
    Boardcore::TrajectoryPoint(2440, 107.647366587419),
    Boardcore::TrajectoryPoint(2450, 106.631223008668),
    Boardcore::TrajectoryPoint(2460, 105.607050775231),
    Boardcore::TrajectoryPoint(2470, 104.574785672384),
    Boardcore::TrajectoryPoint(2480, 103.534225883056),
    Boardcore::TrajectoryPoint(2490, 102.485104103102),
    Boardcore::TrajectoryPoint(2500, 101.427142162367),
    Boardcore::TrajectoryPoint(2510, 100.360050482288),
    Boardcore::TrajectoryPoint(2520, 99.2835275001773),
    Boardcore::TrajectoryPoint(2530, 98.1972590578194),
    Boardcore::TrajectoryPoint(2540, 97.1009177517936),
    Boardcore::TrajectoryPoint(2550, 95.9941622427304),
    Boardcore::TrajectoryPoint(2560, 94.8766365204704),
    Boardcore::TrajectoryPoint(2570, 93.7479691218307),
    Boardcore::TrajectoryPoint(2580, 92.6074329562977),
    Boardcore::TrajectoryPoint(2590, 91.454845961716),
    Boardcore::TrajectoryPoint(2600, 90.2898180349653),
    Boardcore::TrajectoryPoint(2610, 89.1119015436454),
    Boardcore::TrajectoryPoint(2620, 87.9206282824434),
    Boardcore::TrajectoryPoint(2630, 86.7147222070277),
    Boardcore::TrajectoryPoint(2640, 85.4943334905549),
    Boardcore::TrajectoryPoint(2650, 84.2589320939856),
    Boardcore::TrajectoryPoint(2660, 83.0069227056652),
    Boardcore::TrajectoryPoint(2670, 81.7384966272497),
    Boardcore::TrajectoryPoint(2680, 80.4523744579834),
    Boardcore::TrajectoryPoint(2690, 79.1478413316971),
    Boardcore::TrajectoryPoint(2700, 77.823883184504),
    Boardcore::TrajectoryPoint(2710, 76.4797673820869),
    Boardcore::TrajectoryPoint(2720, 75.1137295697727),
    Boardcore::TrajectoryPoint(2730, 73.7253727326438),
    Boardcore::TrajectoryPoint(2740, 72.3131241444873),
    Boardcore::TrajectoryPoint(2750, 70.8749633536065),
    Boardcore::TrajectoryPoint(2760, 69.409930094528),
    Boardcore::TrajectoryPoint(2770, 67.9161901964296),
    Boardcore::TrajectoryPoint(2780, 66.3917432670327),
    Boardcore::TrajectoryPoint(2790, 64.834403639181),
    Boardcore::TrajectoryPoint(2800, 63.2417786271057),
    Boardcore::TrajectoryPoint(2810, 61.6112436384967),
    Boardcore::TrajectoryPoint(2820, 59.9392586764256),
    Boardcore::TrajectoryPoint(2830, 58.2223585409897),
    Boardcore::TrajectoryPoint(2840, 56.4573091608129),
    Boardcore::TrajectoryPoint(2850, 54.637835090152),
    Boardcore::TrajectoryPoint(2860, 52.7596792683806),
    Boardcore::TrajectoryPoint(2870, 50.8160093694044),
    Boardcore::TrajectoryPoint(2880, 48.7986964994659),
    Boardcore::TrajectoryPoint(2890, 46.698230183666),
    Boardcore::TrajectoryPoint(2900, 44.5034132810185),
    Boardcore::TrajectoryPoint(2910, 42.198556643488),
    Boardcore::TrajectoryPoint(2920, 39.7654903158481),
    Boardcore::TrajectoryPoint(2930, 37.1784470751827),
    Boardcore::TrajectoryPoint(2940, 34.4036800563088),
    Boardcore::TrajectoryPoint(2950, 31.3898669960311),
    Boardcore::TrajectoryPoint(2960, 28.0616015816888),
    Boardcore::TrajectoryPoint(2970, 24.2884379061087),
    Boardcore::TrajectoryPoint(2980, 19.8203902608101),
    Boardcore::TrajectoryPoint(2990, 14.0063271188388),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t2_closed[] = {
    Boardcore::TrajectoryPoint(0, 283.649384988986),
    Boardcore::TrajectoryPoint(10, 282.994911393542),
    Boardcore::TrajectoryPoint(20, 282.341195240687),
    Boardcore::TrajectoryPoint(30, 281.688104072036),
    Boardcore::TrajectoryPoint(40, 281.035377580461),
    Boardcore::TrajectoryPoint(50, 280.383002174478),
    Boardcore::TrajectoryPoint(60, 279.731080239009),
    Boardcore::TrajectoryPoint(70, 279.079588074558),
    Boardcore::TrajectoryPoint(80, 278.428407377806),
    Boardcore::TrajectoryPoint(90, 277.7775338719),
    Boardcore::TrajectoryPoint(100, 277.127128812364),
    Boardcore::TrajectoryPoint(110, 276.477004039529),
    Boardcore::TrajectoryPoint(120, 275.827148149359),
    Boardcore::TrajectoryPoint(130, 275.177607765335),
    Boardcore::TrajectoryPoint(140, 274.528406812309),
    Boardcore::TrajectoryPoint(150, 273.879437869674),
    Boardcore::TrajectoryPoint(160, 273.230695836887),
    Boardcore::TrajectoryPoint(170, 272.582250035291),
    Boardcore::TrajectoryPoint(180, 271.934043411965),
    Boardcore::TrajectoryPoint(190, 271.286028057158),
    Boardcore::TrajectoryPoint(200, 270.638198388327),
    Boardcore::TrajectoryPoint(210, 269.990622697733),
    Boardcore::TrajectoryPoint(220, 269.343216172314),
    Boardcore::TrajectoryPoint(230, 268.695960877714),
    Boardcore::TrajectoryPoint(240, 268.048850858818),
    Boardcore::TrajectoryPoint(250, 267.401939123318),
    Boardcore::TrajectoryPoint(260, 266.755146461372),
    Boardcore::TrajectoryPoint(270, 266.108465735888),
    Boardcore::TrajectoryPoint(280, 265.461890700038),
    Boardcore::TrajectoryPoint(290, 264.815452745957),
    Boardcore::TrajectoryPoint(300, 264.16909503595),
    Boardcore::TrajectoryPoint(310, 263.522810704384),
    Boardcore::TrajectoryPoint(320, 262.876593271018),
    Boardcore::TrajectoryPoint(330, 262.230452872799),
    Boardcore::TrajectoryPoint(340, 261.584357820466),
    Boardcore::TrajectoryPoint(350, 260.938298283693),
    Boardcore::TrajectoryPoint(360, 260.292267589333),
    Boardcore::TrajectoryPoint(370, 259.64626069192),
    Boardcore::TrajectoryPoint(380, 259.000261903186),
    Boardcore::TrajectoryPoint(390, 258.354261396179),
    Boardcore::TrajectoryPoint(400, 257.70825233135),
    Boardcore::TrajectoryPoint(410, 257.062225493345),
    Boardcore::TrajectoryPoint(420, 256.416161760232),
    Boardcore::TrajectoryPoint(430, 255.770059620288),
    Boardcore::TrajectoryPoint(440, 255.123912083074),
    Boardcore::TrajectoryPoint(450, 254.477712015146),
    Boardcore::TrajectoryPoint(460, 253.831435710488),
    Boardcore::TrajectoryPoint(470, 253.185075664443),
    Boardcore::TrajectoryPoint(480, 252.538633838014),
    Boardcore::TrajectoryPoint(490, 251.892102967045),
    Boardcore::TrajectoryPoint(500, 251.245475665088),
    Boardcore::TrajectoryPoint(510, 250.598712075945),
    Boardcore::TrajectoryPoint(520, 249.951823735002),
    Boardcore::TrajectoryPoint(530, 249.304810178663),
    Boardcore::TrajectoryPoint(540, 248.657663895226),
    Boardcore::TrajectoryPoint(550, 248.010377264704),
    Boardcore::TrajectoryPoint(560, 247.362904026437),
    Boardcore::TrajectoryPoint(570, 246.71525871468),
    Boardcore::TrajectoryPoint(580, 246.067444594943),
    Boardcore::TrajectoryPoint(590, 245.41945391694),
    Boardcore::TrajectoryPoint(600, 244.771278831043),
    Boardcore::TrajectoryPoint(610, 244.12288631351),
    Boardcore::TrajectoryPoint(620, 243.474257567312),
    Boardcore::TrajectoryPoint(630, 242.825416131917),
    Boardcore::TrajectoryPoint(640, 242.176354014983),
    Boardcore::TrajectoryPoint(650, 241.527063129943),
    Boardcore::TrajectoryPoint(660, 240.877535298497),
    Boardcore::TrajectoryPoint(670, 240.227714584265),
    Boardcore::TrajectoryPoint(680, 239.577620025678),
    Boardcore::TrajectoryPoint(690, 238.927260208185),
    Boardcore::TrajectoryPoint(700, 238.276626793066),
    Boardcore::TrajectoryPoint(710, 237.625711351264),
    Boardcore::TrajectoryPoint(720, 236.974505364796),
    Boardcore::TrajectoryPoint(730, 236.322961192802),
    Boardcore::TrajectoryPoint(740, 235.671077067635),
    Boardcore::TrajectoryPoint(750, 235.018873868388),
    Boardcore::TrajectoryPoint(760, 234.366342892575),
    Boardcore::TrajectoryPoint(770, 233.713475347614),
    Boardcore::TrajectoryPoint(780, 233.060262351456),
    Boardcore::TrajectoryPoint(790, 232.406694933059),
    Boardcore::TrajectoryPoint(800, 231.752709811034),
    Boardcore::TrajectoryPoint(810, 231.098333581309),
    Boardcore::TrajectoryPoint(820, 230.443573877744),
    Boardcore::TrajectoryPoint(830, 229.78842151354),
    Boardcore::TrajectoryPoint(840, 229.132867209573),
    Boardcore::TrajectoryPoint(850, 228.476901594347),
    Boardcore::TrajectoryPoint(860, 227.820515203826),
    Boardcore::TrajectoryPoint(870, 227.163696391398),
    Boardcore::TrajectoryPoint(880, 226.506369951137),
    Boardcore::TrajectoryPoint(890, 225.848592929799),
    Boardcore::TrajectoryPoint(900, 225.19035561273),
    Boardcore::TrajectoryPoint(910, 224.531648188054),
    Boardcore::TrajectoryPoint(920, 223.872460746159),
    Boardcore::TrajectoryPoint(930, 223.212783279102),
    Boardcore::TrajectoryPoint(940, 222.552605679952),
    Boardcore::TrajectoryPoint(950, 221.891917742054),
    Boardcore::TrajectoryPoint(960, 221.230709158229),
    Boardcore::TrajectoryPoint(970, 220.568923384834),
    Boardcore::TrajectoryPoint(980, 219.906579436235),
    Boardcore::TrajectoryPoint(990, 219.243683481912),
    Boardcore::TrajectoryPoint(1000, 218.580224912536),
    Boardcore::TrajectoryPoint(1010, 217.916193012232),
    Boardcore::TrajectoryPoint(1020, 217.251576957582),
    Boardcore::TrajectoryPoint(1030, 216.586365816581),
    Boardcore::TrajectoryPoint(1040, 215.920548547557),
    Boardcore::TrajectoryPoint(1050, 215.254113998038),
    Boardcore::TrajectoryPoint(1060, 214.587050903581),
    Boardcore::TrajectoryPoint(1070, 213.919347886569),
    Boardcore::TrajectoryPoint(1080, 213.250993454964),
    Boardcore::TrajectoryPoint(1090, 212.581976001028),
    Boardcore::TrajectoryPoint(1100, 211.912249415848),
    Boardcore::TrajectoryPoint(1110, 211.241827466849),
    Boardcore::TrajectoryPoint(1120, 210.570708408297),
    Boardcore::TrajectoryPoint(1130, 209.898880258772),
    Boardcore::TrajectoryPoint(1140, 209.226330914081),
    Boardcore::TrajectoryPoint(1150, 208.553048145865),
    Boardcore::TrajectoryPoint(1160, 207.879019600168),
    Boardcore::TrajectoryPoint(1170, 207.204232795983),
    Boardcore::TrajectoryPoint(1180, 206.528675123763),
    Boardcore::TrajectoryPoint(1190, 205.852333843902),
    Boardcore::TrajectoryPoint(1200, 205.175196085197),
    Boardcore::TrajectoryPoint(1210, 204.497248843272),
    Boardcore::TrajectoryPoint(1220, 203.818478978978),
    Boardcore::TrajectoryPoint(1230, 203.138873216769),
    Boardcore::TrajectoryPoint(1240, 202.458418143045),
    Boardcore::TrajectoryPoint(1250, 201.777100204468),
    Boardcore::TrajectoryPoint(1260, 201.094905706256),
    Boardcore::TrajectoryPoint(1270, 200.411820810441),
    Boardcore::TrajectoryPoint(1280, 199.727831534105),
    Boardcore::TrajectoryPoint(1290, 199.042923747586),
    Boardcore::TrajectoryPoint(1300, 198.357083172653),
    Boardcore::TrajectoryPoint(1310, 197.670295380654),
    Boardcore::TrajectoryPoint(1320, 196.982545790637),
    Boardcore::TrajectoryPoint(1330, 196.293819667433),
    Boardcore::TrajectoryPoint(1340, 195.604102119718),
    Boardcore::TrajectoryPoint(1350, 194.913378098036),
    Boardcore::TrajectoryPoint(1360, 194.221632392795),
    Boardcore::TrajectoryPoint(1370, 193.528849632226),
    Boardcore::TrajectoryPoint(1380, 192.835014280315),
    Boardcore::TrajectoryPoint(1390, 192.140110634692),
    Boardcore::TrajectoryPoint(1400, 191.444122824496),
    Boardcore::TrajectoryPoint(1410, 190.747034808193),
    Boardcore::TrajectoryPoint(1420, 190.048830371365),
    Boardcore::TrajectoryPoint(1430, 189.34949312446),
    Boardcore::TrajectoryPoint(1440, 188.649006500501),
    Boardcore::TrajectoryPoint(1450, 187.947353752759),
    Boardcore::TrajectoryPoint(1460, 187.244455010831),
    Boardcore::TrajectoryPoint(1470, 186.54034386575),
    Boardcore::TrajectoryPoint(1480, 185.835009875976),
    Boardcore::TrajectoryPoint(1490, 185.128435425812),
    Boardcore::TrajectoryPoint(1500, 184.420602706153),
    Boardcore::TrajectoryPoint(1510, 183.711493711851),
    Boardcore::TrajectoryPoint(1520, 183.001090239049),
    Boardcore::TrajectoryPoint(1530, 182.289373882447),
    Boardcore::TrajectoryPoint(1540, 181.576326032534),
    Boardcore::TrajectoryPoint(1550, 180.861927872762),
    Boardcore::TrajectoryPoint(1560, 180.146160376665),
    Boardcore::TrajectoryPoint(1570, 179.428935204474),
    Boardcore::TrajectoryPoint(1580, 178.710235660226),
    Boardcore::TrajectoryPoint(1590, 177.990101502136),
    Boardcore::TrajectoryPoint(1600, 177.268512690257),
    Boardcore::TrajectoryPoint(1610, 176.545448957596),
    Boardcore::TrajectoryPoint(1620, 175.820889806844),
    Boardcore::TrajectoryPoint(1630, 175.094814507041),
    Boardcore::TrajectoryPoint(1640, 174.367202090168),
    Boardcore::TrajectoryPoint(1650, 173.637880722371),
    Boardcore::TrajectoryPoint(1660, 172.90694090731),
    Boardcore::TrajectoryPoint(1670, 172.174391429404),
    Boardcore::TrajectoryPoint(1680, 171.440210175707),
    Boardcore::TrajectoryPoint(1690, 170.704374775824),
    Boardcore::TrajectoryPoint(1700, 169.966862598026),
    Boardcore::TrajectoryPoint(1710, 169.227493682487),
    Boardcore::TrajectoryPoint(1720, 168.486323284153),
    Boardcore::TrajectoryPoint(1730, 167.743397342681),
    Boardcore::TrajectoryPoint(1740, 166.998691963146),
    Boardcore::TrajectoryPoint(1750, 166.252182965885),
    Boardcore::TrajectoryPoint(1760, 165.503715991602),
    Boardcore::TrajectoryPoint(1770, 164.753247060654),
    Boardcore::TrajectoryPoint(1780, 164.000889963593),
    Boardcore::TrajectoryPoint(1790, 163.246619143151),
    Boardcore::TrajectoryPoint(1800, 162.490408730958),
    Boardcore::TrajectoryPoint(1810, 161.731946531821),
    Boardcore::TrajectoryPoint(1820, 160.971450265771),
    Boardcore::TrajectoryPoint(1830, 160.208923545679),
    Boardcore::TrajectoryPoint(1840, 159.444338996252),
    Boardcore::TrajectoryPoint(1850, 158.677383759027),
    Boardcore::TrajectoryPoint(1860, 157.908229750237),
    Boardcore::TrajectoryPoint(1870, 157.136921418826),
    Boardcore::TrajectoryPoint(1880, 156.363410230798),
    Boardcore::TrajectoryPoint(1890, 155.587301880504),
    Boardcore::TrajectoryPoint(1900, 154.808937998775),
    Boardcore::TrajectoryPoint(1910, 154.028288218331),
    Boardcore::TrajectoryPoint(1920, 153.245056279002),
    Boardcore::TrajectoryPoint(1930, 152.459287703693),
    Boardcore::TrajectoryPoint(1940, 151.671125551698),
    Boardcore::TrajectoryPoint(1950, 150.880347403847),
    Boardcore::TrajectoryPoint(1960, 150.086806495745),
    Boardcore::TrajectoryPoint(1970, 149.290758896269),
    Boardcore::TrajectoryPoint(1980, 148.491963788708),
    Boardcore::TrajectoryPoint(1990, 147.690263189313),
    Boardcore::TrajectoryPoint(2000, 146.885936983811),
    Boardcore::TrajectoryPoint(2010, 146.078623620156),
    Boardcore::TrajectoryPoint(2020, 145.26835491621),
    Boardcore::TrajectoryPoint(2030, 144.455335495493),
    Boardcore::TrajectoryPoint(2040, 143.638969894996),
    Boardcore::TrajectoryPoint(2050, 142.819702159908),
    Boardcore::TrajectoryPoint(2060, 141.997306329474),
    Boardcore::TrajectoryPoint(2070, 141.171565115824),
    Boardcore::TrajectoryPoint(2080, 140.342843315789),
    Boardcore::TrajectoryPoint(2090, 139.510417361726),
    Boardcore::TrajectoryPoint(2100, 138.674885478144),
    Boardcore::TrajectoryPoint(2110, 137.835728245749),
    Boardcore::TrajectoryPoint(2120, 136.993137676678),
    Boardcore::TrajectoryPoint(2130, 136.146942178877),
    Boardcore::TrajectoryPoint(2140, 135.29703364669),
    Boardcore::TrajectoryPoint(2150, 134.443477253272),
    Boardcore::TrajectoryPoint(2160, 133.585980218551),
    Boardcore::TrajectoryPoint(2170, 132.724723758189),
    Boardcore::TrajectoryPoint(2180, 131.859355791786),
    Boardcore::TrajectoryPoint(2190, 130.990042585261),
    Boardcore::TrajectoryPoint(2200, 130.116508695212),
    Boardcore::TrajectoryPoint(2210, 129.238763514169),
    Boardcore::TrajectoryPoint(2220, 128.356755423816),
    Boardcore::TrajectoryPoint(2230, 127.470183368818),
    Boardcore::TrajectoryPoint(2240, 126.579378742157),
    Boardcore::TrajectoryPoint(2250, 125.6835640332),
    Boardcore::TrajectoryPoint(2260, 124.78334091899),
    Boardcore::TrajectoryPoint(2270, 123.878130315052),
    Boardcore::TrajectoryPoint(2280, 122.96797992116),
    Boardcore::TrajectoryPoint(2290, 122.053042096542),
    Boardcore::TrajectoryPoint(2300, 121.132513952084),
    Boardcore::TrajectoryPoint(2310, 120.20690300092),
    Boardcore::TrajectoryPoint(2320, 119.276060500771),
    Boardcore::TrajectoryPoint(2330, 118.339258283789),
    Boardcore::TrajectoryPoint(2340, 117.396957049993),
    Boardcore::TrajectoryPoint(2350, 116.448995175353),
    Boardcore::TrajectoryPoint(2360, 115.494797317737),
    Boardcore::TrajectoryPoint(2370, 114.534459490111),
    Boardcore::TrajectoryPoint(2380, 113.567957887416),
    Boardcore::TrajectoryPoint(2390, 112.595106887315),
    Boardcore::TrajectoryPoint(2400, 111.615386955552),
    Boardcore::TrajectoryPoint(2410, 110.628817909275),
    Boardcore::TrajectoryPoint(2420, 109.635324663162),
    Boardcore::TrajectoryPoint(2430, 108.634693410106),
    Boardcore::TrajectoryPoint(2440, 107.626702039588),
    Boardcore::TrajectoryPoint(2450, 106.611119747233),
    Boardcore::TrajectoryPoint(2460, 105.587472979094),
    Boardcore::TrajectoryPoint(2470, 104.555756838639),
    Boardcore::TrajectoryPoint(2480, 103.515739656493),
    Boardcore::TrajectoryPoint(2490, 102.467154106181),
    Boardcore::TrajectoryPoint(2500, 101.40972199614),
    Boardcore::TrajectoryPoint(2510, 100.343153727295),
    Boardcore::TrajectoryPoint(2520, 99.267147717322),
    Boardcore::TrajectoryPoint(2530, 98.1813897892136),
    Boardcore::TrajectoryPoint(2540, 97.0855525215816),
    Boardcore::TrajectoryPoint(2550, 95.979294557891),
    Boardcore::TrajectoryPoint(2560, 94.862259871597),
    Boardcore::TrajectoryPoint(2570, 93.7340769838915),
    Boardcore::TrajectoryPoint(2580, 92.5940420479439),
    Boardcore::TrajectoryPoint(2590, 91.4419257970673),
    Boardcore::TrajectoryPoint(2600, 90.2773620253158),
    Boardcore::TrajectoryPoint(2610, 89.0999030880133),
    Boardcore::TrajectoryPoint(2620, 87.9090807682223),
    Boardcore::TrajectoryPoint(2630, 86.703639582049),
    Boardcore::TrajectoryPoint(2640, 85.4836877589105),
    Boardcore::TrajectoryPoint(2650, 84.2487165934542),
    Boardcore::TrajectoryPoint(2660, 82.997149736438),
    Boardcore::TrajectoryPoint(2670, 81.7291396790053),
    Boardcore::TrajectoryPoint(2680, 80.4434448464753),
    Boardcore::TrajectoryPoint(2690, 79.1393134187272),
    Boardcore::TrajectoryPoint(2700, 77.8157671709963),
    Boardcore::TrajectoryPoint(2710, 76.4720386425474),
    Boardcore::TrajectoryPoint(2720, 75.1063970666899),
    Boardcore::TrajectoryPoint(2730, 73.718428396807),
    Boardcore::TrajectoryPoint(2740, 72.3065447610623),
    Boardcore::TrajectoryPoint(2750, 70.8687561269087),
    Boardcore::TrajectoryPoint(2760, 69.404086729303),
    Boardcore::TrajectoryPoint(2770, 67.9107023117805),
    Boardcore::TrajectoryPoint(2780, 66.386602399338),
    Boardcore::TrajectoryPoint(2790, 64.8296012447605),
    Boardcore::TrajectoryPoint(2800, 63.2373060846146),
    Boardcore::TrajectoryPoint(2810, 61.6070922510253),
    Boardcore::TrajectoryPoint(2820, 59.935430254184),
    Boardcore::TrajectoryPoint(2830, 58.2188329202676),
    Boardcore::TrajectoryPoint(2840, 56.4540869221981),
    Boardcore::TrajectoryPoint(2850, 54.6348968522637),
    Boardcore::TrajectoryPoint(2860, 52.7570241744769),
    Boardcore::TrajectoryPoint(2870, 50.8136268064579),
    Boardcore::TrajectoryPoint(2880, 48.7965756332132),
    Boardcore::TrajectoryPoint(2890, 46.6963599599857),
    Boardcore::TrajectoryPoint(2900, 44.5017824251479),
    Boardcore::TrajectoryPoint(2910, 42.1971590671598),
    Boardcore::TrajectoryPoint(2920, 39.7643128994952),
    Boardcore::TrajectoryPoint(2930, 37.1774762153787),
    Boardcore::TrajectoryPoint(2940, 34.4029053974381),
    Boardcore::TrajectoryPoint(2950, 31.3892724260696),
    Boardcore::TrajectoryPoint(2960, 28.0611700533797),
    Boardcore::TrajectoryPoint(2970, 24.2881548232795),
    Boardcore::TrajectoryPoint(2980, 19.8202338495918),
    Boardcore::TrajectoryPoint(2990, 14.0062710213803),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t3_closed[] = {
    Boardcore::TrajectoryPoint(0, 283.323943384102),
    Boardcore::TrajectoryPoint(10, 282.671680179665),
    Boardcore::TrajectoryPoint(20, 282.02029630144),
    Boardcore::TrajectoryPoint(30, 281.369392109533),
    Boardcore::TrajectoryPoint(40, 280.718833956169),
    Boardcore::TrajectoryPoint(50, 280.068627373899),
    Boardcore::TrajectoryPoint(60, 279.418951581266),
    Boardcore::TrajectoryPoint(70, 278.769582733232),
    Boardcore::TrajectoryPoint(80, 278.120516856145),
    Boardcore::TrajectoryPoint(90, 277.471838277135),
    Boardcore::TrajectoryPoint(100, 276.823520672995),
    Boardcore::TrajectoryPoint(110, 276.17546817989),
    Boardcore::TrajectoryPoint(120, 275.527676074667),
    Boardcore::TrajectoryPoint(130, 274.880263306644),
    Boardcore::TrajectoryPoint(140, 274.233094147641),
    Boardcore::TrajectoryPoint(150, 273.586148774706),
    Boardcore::TrajectoryPoint(160, 272.93944577566),
    Boardcore::TrajectoryPoint(170, 272.293035889894),
    Boardcore::TrajectoryPoint(180, 271.646814504047),
    Boardcore::TrajectoryPoint(190, 271.00077624342),
    Boardcore::TrajectoryPoint(200, 270.354952028172),
    Boardcore::TrajectoryPoint(210, 269.709337278581),
    Boardcore::TrajectoryPoint(220, 269.063871510877),
    Boardcore::TrajectoryPoint(230, 268.418548952147),
    Boardcore::TrajectoryPoint(240, 267.77339667026),
    Boardcore::TrajectoryPoint(250, 267.128392099267),
    Boardcore::TrajectoryPoint(260, 266.483497675319),
    Boardcore::TrajectoryPoint(270, 265.838707312672),
    Boardcore::TrajectoryPoint(280, 265.194036204775),
    Boardcore::TrajectoryPoint(290, 264.549464045037),
    Boardcore::TrajectoryPoint(300, 263.904963885677),
    Boardcore::TrajectoryPoint(310, 263.260529390275),
    Boardcore::TrajectoryPoint(320, 262.616162745962),
    Boardcore::TrajectoryPoint(330, 261.971851746245),
    Boardcore::TrajectoryPoint(340, 261.327575257385),
    Boardcore::TrajectoryPoint(350, 260.683326736079),
    Boardcore::TrajectoryPoint(360, 260.03910010902),
    Boardcore::TrajectoryPoint(370, 259.394884843666),
    Boardcore::TrajectoryPoint(380, 258.75066719933),
    Boardcore::TrajectoryPoint(390, 258.106440455141),
    Boardcore::TrajectoryPoint(400, 257.462197725739),
    Boardcore::TrajectoryPoint(410, 256.817920276759),
    Boardcore::TrajectoryPoint(420, 256.173601708375),
    Boardcore::TrajectoryPoint(430, 255.529237513881),
    Boardcore::TrajectoryPoint(440, 254.884820666396),
    Boardcore::TrajectoryPoint(450, 254.24033879215),
    Boardcore::TrajectoryPoint(460, 253.595763893491),
    Boardcore::TrajectoryPoint(470, 252.951107285029),
    Boardcore::TrajectoryPoint(480, 252.306361803146),
    Boardcore::TrajectoryPoint(490, 251.661520159485),
    Boardcore::TrajectoryPoint(500, 251.016558726333),
    Boardcore::TrajectoryPoint(510, 250.37145832443),
    Boardcore::TrajectoryPoint(520, 249.72623316452),
    Boardcore::TrajectoryPoint(530, 249.080875829188),
    Boardcore::TrajectoryPoint(540, 248.435378791033),
    Boardcore::TrajectoryPoint(550, 247.789715371436),
    Boardcore::TrajectoryPoint(560, 247.143862310474),
    Boardcore::TrajectoryPoint(570, 246.497841273864),
    Boardcore::TrajectoryPoint(580, 245.851644601902),
    Boardcore::TrajectoryPoint(590, 245.205264534451),
    Boardcore::TrajectoryPoint(600, 244.558689580089),
    Boardcore::TrajectoryPoint(610, 243.91185891786),
    Boardcore::TrajectoryPoint(620, 243.264816770429),
    Boardcore::TrajectoryPoint(630, 242.617555234402),
    Boardcore::TrajectoryPoint(640, 241.970066311567),
    Boardcore::TrajectoryPoint(650, 241.322341911507),
    Boardcore::TrajectoryPoint(660, 240.674348754966),
    Boardcore::TrajectoryPoint(670, 240.026061243951),
    Boardcore::TrajectoryPoint(680, 239.377510142296),
    Boardcore::TrajectoryPoint(690, 238.728687200086),
    Boardcore::TrajectoryPoint(700, 238.07958407699),
    Boardcore::TrajectoryPoint(710, 237.43019234376),
    Boardcore::TrajectoryPoint(720, 236.78048628606),
    Boardcore::TrajectoryPoint(730, 236.130420634632),
    Boardcore::TrajectoryPoint(740, 235.480038053749),
    Boardcore::TrajectoryPoint(750, 234.829329931707),
    Boardcore::TrajectoryPoint(760, 234.178287567016),
    Boardcore::TrajectoryPoint(770, 233.526902169115),
    Boardcore::TrajectoryPoint(780, 232.875164858906),
    Boardcore::TrajectoryPoint(790, 232.223031546334),
    Boardcore::TrajectoryPoint(800, 231.570490439167),
    Boardcore::TrajectoryPoint(810, 230.917568594229),
    Boardcore::TrajectoryPoint(820, 230.264256919729),
    Boardcore::TrajectoryPoint(830, 229.610546232237),
    Boardcore::TrajectoryPoint(840, 228.956427256688),
    Boardcore::TrajectoryPoint(850, 228.301890626275),
    Boardcore::TrajectoryPoint(860, 227.646926882237),
    Boardcore::TrajectoryPoint(870, 226.991467941891),
    Boardcore::TrajectoryPoint(880, 226.335549938778),
    Boardcore::TrajectoryPoint(890, 225.679175106331),
    Boardcore::TrajectoryPoint(900, 225.022333734667),
    Boardcore::TrajectoryPoint(910, 224.365016017172),
    Boardcore::TrajectoryPoint(920, 223.707212049949),
    Boardcore::TrajectoryPoint(930, 223.048911831195),
    Boardcore::TrajectoryPoint(940, 222.390105260505),
    Boardcore::TrajectoryPoint(950, 221.730782138111),
    Boardcore::TrajectoryPoint(960, 221.070889164222),
    Boardcore::TrajectoryPoint(970, 220.410438023804),
    Boardcore::TrajectoryPoint(980, 219.749439247556),
    Boardcore::TrajectoryPoint(990, 219.087882338179),
    Boardcore::TrajectoryPoint(1000, 218.425756693098),
    Boardcore::TrajectoryPoint(1010, 217.763051603499),
    Boardcore::TrajectoryPoint(1020, 217.099756253312),
    Boardcore::TrajectoryPoint(1030, 216.435859718159),
    Boardcore::TrajectoryPoint(1040, 215.77135096425),
    Boardcore::TrajectoryPoint(1050, 215.106218847238),
    Boardcore::TrajectoryPoint(1060, 214.440452111041),
    Boardcore::TrajectoryPoint(1070, 213.774039386622),
    Boardcore::TrajectoryPoint(1080, 213.106962728441),
    Boardcore::TrajectoryPoint(1090, 212.439177109996),
    Boardcore::TrajectoryPoint(1100, 211.770711985715),
    Boardcore::TrajectoryPoint(1110, 211.101555623924),
    Boardcore::TrajectoryPoint(1120, 210.431696173096),
    Boardcore::TrajectoryPoint(1130, 209.761121660513),
    Boardcore::TrajectoryPoint(1140, 209.089819990887),
    Boardcore::TrajectoryPoint(1150, 208.417778944958),
    Boardcore::TrajectoryPoint(1160, 207.74498617806),
    Boardcore::TrajectoryPoint(1170, 207.071429218655),
    Boardcore::TrajectoryPoint(1180, 206.397095466839),
    Boardcore::TrajectoryPoint(1190, 205.721972192827),
    Boardcore::TrajectoryPoint(1200, 205.046046535396),
    Boardcore::TrajectoryPoint(1210, 204.369305500314),
    Boardcore::TrajectoryPoint(1220, 203.691735958735),
    Boardcore::TrajectoryPoint(1230, 203.013324645566),
    Boardcore::TrajectoryPoint(1240, 202.334058157812),
    Boardcore::TrajectoryPoint(1250, 201.653922952883),
    Boardcore::TrajectoryPoint(1260, 200.972905346891),
    Boardcore::TrajectoryPoint(1270, 200.290991512897),
    Boardcore::TrajectoryPoint(1280, 199.60816747915),
    Boardcore::TrajectoryPoint(1290, 198.924419127287),
    Boardcore::TrajectoryPoint(1300, 198.239732190506),
    Boardcore::TrajectoryPoint(1310, 197.554092251712),
    Boardcore::TrajectoryPoint(1320, 196.86748474163),
    Boardcore::TrajectoryPoint(1330, 196.179894936894),
    Boardcore::TrajectoryPoint(1340, 195.491307958098),
    Boardcore::TrajectoryPoint(1350, 194.801708767821),
    Boardcore::TrajectoryPoint(1360, 194.111082168617),
    Boardcore::TrajectoryPoint(1370, 193.419412800974),
    Boardcore::TrajectoryPoint(1380, 192.726685141242),
    Boardcore::TrajectoryPoint(1390, 192.03288349952),
    Boardcore::TrajectoryPoint(1400, 191.337992017515),
    Boardcore::TrajectoryPoint(1410, 190.641994666362),
    Boardcore::TrajectoryPoint(1420, 189.944875244407),
    Boardcore::TrajectoryPoint(1430, 189.246617374956),
    Boardcore::TrajectoryPoint(1440, 188.547204503977),
    Boardcore::TrajectoryPoint(1450, 187.846619897775),
    Boardcore::TrajectoryPoint(1460, 187.144846640615),
    Boardcore::TrajectoryPoint(1470, 186.441792027207),
    Boardcore::TrajectoryPoint(1480, 185.737508951095),
    Boardcore::TrajectoryPoint(1490, 185.031979838904),
    Boardcore::TrajectoryPoint(1500, 184.32518689533),
    Boardcore::TrajectoryPoint(1510, 183.617112129088),
    Boardcore::TrajectoryPoint(1520, 182.90773735024),
    Boardcore::TrajectoryPoint(1530, 182.197044167463),
    Boardcore::TrajectoryPoint(1540, 181.485013985274),
    Boardcore::TrajectoryPoint(1550, 180.771628001198),
    Boardcore::TrajectoryPoint(1560, 180.056867202892),
    Boardcore::TrajectoryPoint(1570, 179.340704488564),
    Boardcore::TrajectoryPoint(1580, 178.623000058899),
    Boardcore::TrajectoryPoint(1590, 177.903855566915),
    Boardcore::TrajectoryPoint(1600, 177.183250987234),
    Boardcore::TrajectoryPoint(1610, 176.461166067457),
    Boardcore::TrajectoryPoint(1620, 175.737580324889),
    Boardcore::TrajectoryPoint(1630, 175.0124730432),
    Boardcore::TrajectoryPoint(1640, 174.285823269019),
    Boardcore::TrajectoryPoint(1650, 173.557518480213),
    Boardcore::TrajectoryPoint(1660, 172.827529797163),
    Boardcore::TrajectoryPoint(1670, 172.09592610935),
    Boardcore::TrajectoryPoint(1680, 171.362685318746),
    Boardcore::TrajectoryPoint(1690, 170.627785069865),
    Boardcore::TrajectoryPoint(1700, 169.89120274588),
    Boardcore::TrajectoryPoint(1710, 169.152816240324),
    Boardcore::TrajectoryPoint(1720, 168.412564249947),
    Boardcore::TrajectoryPoint(1730, 167.670551455176),
    Boardcore::TrajectoryPoint(1740, 166.926753976129),
    Boardcore::TrajectoryPoint(1750, 166.181147648157),
    Boardcore::TrajectoryPoint(1760, 165.433634703387),
    Boardcore::TrajectoryPoint(1770, 164.684057056531),
    Boardcore::TrajectoryPoint(1780, 163.932586049889),
    Boardcore::TrajectoryPoint(1790, 163.17919614124),
    Boardcore::TrajectoryPoint(1800, 162.423861477222),
    Boardcore::TrajectoryPoint(1810, 161.666324651161),
    Boardcore::TrajectoryPoint(1820, 160.906692820614),
    Boardcore::TrajectoryPoint(1830, 160.145025410993),
    Boardcore::TrajectoryPoint(1840, 159.381295061956),
    Boardcore::TrajectoryPoint(1850, 158.615242498417),
    Boardcore::TrajectoryPoint(1860, 157.846931434831),
    Boardcore::TrajectoryPoint(1870, 157.076460977784),
    Boardcore::TrajectoryPoint(1880, 156.303802140905),
    Boardcore::TrajectoryPoint(1890, 155.528554061517),
    Boardcore::TrajectoryPoint(1900, 154.751011806545),
    Boardcore::TrajectoryPoint(1910, 153.971178636431),
    Boardcore::TrajectoryPoint(1920, 153.188809642908),
    Boardcore::TrajectoryPoint(1930, 152.403846529596),
    Boardcore::TrajectoryPoint(1940, 151.616484862988),
    Boardcore::TrajectoryPoint(1950, 150.826552675005),
    Boardcore::TrajectoryPoint(1960, 150.033801150595),
    Boardcore::TrajectoryPoint(1970, 149.23853799808),
    Boardcore::TrajectoryPoint(1980, 148.440571754314),
    Boardcore::TrajectoryPoint(1990, 147.639644549623),
    Boardcore::TrajectoryPoint(2000, 146.83608684188),
    Boardcore::TrajectoryPoint(2010, 146.029585151894),
    Boardcore::TrajectoryPoint(2020, 145.220073945163),
    Boardcore::TrajectoryPoint(2030, 144.40780716428),
    Boardcore::TrajectoryPoint(2040, 143.592235967666),
    Boardcore::TrajectoryPoint(2050, 142.773709925375),
    Boardcore::TrajectoryPoint(2060, 141.952097261599),
    Boardcore::TrajectoryPoint(2070, 141.12708682322),
    Boardcore::TrajectoryPoint(2080, 140.299091005668),
    Boardcore::TrajectoryPoint(2090, 139.467430808977),
    Boardcore::TrajectoryPoint(2100, 138.632614046461),
    Boardcore::TrajectoryPoint(2110, 137.794211191054),
    Boardcore::TrajectoryPoint(2120, 136.952324913448),
    Boardcore::TrajectoryPoint(2130, 136.106872347686),
    Boardcore::TrajectoryPoint(2140, 135.257657310089),
    Boardcore::TrajectoryPoint(2150, 134.404832344662),
    Boardcore::TrajectoryPoint(2160, 133.548018041153),
    Boardcore::TrajectoryPoint(2170, 132.687481450697),
    Boardcore::TrajectoryPoint(2180, 131.822785486267),
    Boardcore::TrajectoryPoint(2190, 130.954180542223),
    Boardcore::TrajectoryPoint(2200, 130.081307959571),
    Boardcore::TrajectoryPoint(2210, 129.204259388587),
    Boardcore::TrajectoryPoint(2220, 128.32290194614),
    Boardcore::TrajectoryPoint(2230, 127.437014807812),
    Boardcore::TrajectoryPoint(2240, 126.546850204985),
    Boardcore::TrajectoryPoint(2250, 125.651708682081),
    Boardcore::TrajectoryPoint(2260, 124.752152994364),
    Boardcore::TrajectoryPoint(2270, 123.847565821045),
    Boardcore::TrajectoryPoint(2280, 122.938071045918),
    Boardcore::TrajectoryPoint(2290, 122.023771659874),
    Boardcore::TrajectoryPoint(2300, 121.103861750894),
    Boardcore::TrajectoryPoint(2310, 120.178888699153),
    Boardcore::TrajectoryPoint(2320, 119.248642609619),
    Boardcore::TrajectoryPoint(2330, 118.312466395129),
    Boardcore::TrajectoryPoint(2340, 117.370785207151),
    Boardcore::TrajectoryPoint(2350, 116.423437386406),
    Boardcore::TrajectoryPoint(2360, 115.469813568524),
    Boardcore::TrajectoryPoint(2370, 114.510077814865),
    Boardcore::TrajectoryPoint(2380, 113.544172231386),
    Boardcore::TrajectoryPoint(2390, 112.57191116475),
    Boardcore::TrajectoryPoint(2400, 111.592743011598),
    Boardcore::TrajectoryPoint(2410, 110.606751852327),
    Boardcore::TrajectoryPoint(2420, 109.613830353502),
    Boardcore::TrajectoryPoint(2430, 108.613764680765),
    Boardcore::TrajectoryPoint(2440, 107.606332697418),
    Boardcore::TrajectoryPoint(2450, 106.591299437196),
    Boardcore::TrajectoryPoint(2460, 105.568174634419),
    Boardcore::TrajectoryPoint(2470, 104.536999525656),
    Boardcore::TrajectoryPoint(2480, 103.497517115262),
    Boardcore::TrajectoryPoint(2490, 102.449460054748),
    Boardcore::TrajectoryPoint(2500, 101.392550131443),
    Boardcore::TrajectoryPoint(2510, 100.326497726043),
    Boardcore::TrajectoryPoint(2520, 99.2510012368434),
    Boardcore::TrajectoryPoint(2530, 98.1657464682888),
    Boardcore::TrajectoryPoint(2540, 97.0704059812477),
    Boardcore::TrajectoryPoint(2550, 95.9646384022268),
    Boardcore::TrajectoryPoint(2560, 94.8480876884868),
    Boardcore::TrajectoryPoint(2570, 93.720382345769),
    Boardcore::TrajectoryPoint(2580, 92.5808414607405),
    Boardcore::TrajectoryPoint(2590, 91.4291891919468),
    Boardcore::TrajectoryPoint(2600, 90.2650829118226),
    Boardcore::TrajectoryPoint(2610, 89.0880749635212),
    Boardcore::TrajectoryPoint(2620, 87.8976971185721),
    Boardcore::TrajectoryPoint(2630, 86.6927141772445),
    Boardcore::TrajectoryPoint(2640, 85.4731929888633),
    Boardcore::TrajectoryPoint(2650, 84.2386458948859),
    Boardcore::TrajectoryPoint(2660, 82.987515252634),
    Boardcore::TrajectoryPoint(2670, 81.719915266524),
    Boardcore::TrajectoryPoint(2680, 80.434641676415),
    Boardcore::TrajectoryPoint(2690, 79.130906208859),
    Boardcore::TrajectoryPoint(2700, 77.8077659919567),
    Boardcore::TrajectoryPoint(2710, 76.4644192115783),
    Boardcore::TrajectoryPoint(2720, 75.099168232338),
    Boardcore::TrajectoryPoint(2730, 73.7115822071469),
    Boardcore::TrajectoryPoint(2740, 72.3000583256251),
    Boardcore::TrajectoryPoint(2750, 70.8626365591284),
    Boardcore::TrajectoryPoint(2760, 69.3983258543543),
    Boardcore::TrajectoryPoint(2770, 67.905291870387),
    Boardcore::TrajectoryPoint(2780, 66.3815340506302),
    Boardcore::TrajectoryPoint(2790, 64.8248665688873),
    Boardcore::TrajectoryPoint(2800, 63.2328965850884),
    Boardcore::TrajectoryPoint(2810, 61.6029993567771),
    Boardcore::TrajectoryPoint(2820, 59.9316557564357),
    Boardcore::TrajectoryPoint(2830, 58.2153569390541),
    Boardcore::TrajectoryPoint(2840, 56.4509100355925),
    Boardcore::TrajectoryPoint(2850, 54.6319999521291),
    Boardcore::TrajectoryPoint(2860, 52.7544064211204),
    Boardcore::TrajectoryPoint(2870, 50.811277738691),
    Boardcore::TrajectoryPoint(2880, 48.7944845716657),
    Boardcore::TrajectoryPoint(2890, 46.6945160084301),
    Boardcore::TrajectoryPoint(2900, 44.5001744696969),
    Boardcore::TrajectoryPoint(2910, 42.1957811083194),
    Boardcore::TrajectoryPoint(2920, 39.7631520039774),
    Boardcore::TrajectoryPoint(2930, 37.1765189727421),
    Boardcore::TrajectoryPoint(2940, 34.4021415997367),
    Boardcore::TrajectoryPoint(2950, 31.3886861890166),
    Boardcore::TrajectoryPoint(2960, 28.060744570416),
    Boardcore::TrajectoryPoint(2970, 24.287875704638),
    Boardcore::TrajectoryPoint(2980, 19.8200796277919),
    Boardcore::TrajectoryPoint(2990, 14.006215708834),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t4_closed[] = {
    Boardcore::TrajectoryPoint(0, 283.003553469561),
    Boardcore::TrajectoryPoint(10, 282.353555591389),
    Boardcore::TrajectoryPoint(20, 281.70444652695),
    Boardcore::TrajectoryPoint(30, 281.055683689494),
    Boardcore::TrajectoryPoint(40, 280.407258429892),
    Boardcore::TrajectoryPoint(50, 279.759285956937),
    Boardcore::TrajectoryPoint(60, 279.111707190549),
    Boardcore::TrajectoryPoint(70, 278.464427144128),
    Boardcore::TrajectoryPoint(80, 277.817450410364),
    Boardcore::TrajectoryPoint(90, 277.170918378452),
    Boardcore::TrajectoryPoint(100, 276.524647661508),
    Boardcore::TrajectoryPoint(110, 275.87863380368),
    Boardcore::TrajectoryPoint(120, 275.232933636971),
    Boardcore::TrajectoryPoint(130, 274.587542817388),
    Boardcore::TrajectoryPoint(140, 273.942372646977),
    Boardcore::TrajectoryPoint(150, 273.297418060898),
    Boardcore::TrajectoryPoint(160, 272.652754467729),
    Boardcore::TrajectoryPoint(170, 272.008305773643),
    Boardcore::TrajectoryPoint(180, 271.36403764009),
    Boardcore::TrajectoryPoint(190, 270.719944533063),
    Boardcore::TrajectoryPoint(200, 270.076097835558),
    Boardcore::TrajectoryPoint(210, 269.432400494937),
    Boardcore::TrajectoryPoint(220, 268.788844299988),
    Boardcore::TrajectoryPoint(230, 268.145429010288),
    Boardcore::TrajectoryPoint(240, 267.502191608432),
    Boardcore::TrajectoryPoint(250, 266.859062570212),
    Boardcore::TrajectoryPoint(260, 266.216035974174),
    Boardcore::TrajectoryPoint(270, 265.573109740895),
    Boardcore::TrajectoryPoint(280, 264.930302392008),
    Boardcore::TrajectoryPoint(290, 264.287565676426),
    Boardcore::TrajectoryPoint(300, 263.644893404195),
    Boardcore::TrajectoryPoint(310, 263.002279161585),
    Boardcore::TrajectoryPoint(320, 262.359731493167),
    Boardcore::TrajectoryPoint(330, 261.717217511716),
    Boardcore::TrajectoryPoint(340, 261.074730639827),
    Boardcore::TrajectoryPoint(350, 260.432264273169),
    Boardcore::TrajectoryPoint(360, 259.789811070763),
    Boardcore::TrajectoryPoint(370, 259.147355934579),
    Boardcore::TrajectoryPoint(380, 258.504891175559),
    Boardcore::TrajectoryPoint(390, 257.862410024444),
    Boardcore::TrajectoryPoint(400, 257.219900488715),
    Boardcore::TrajectoryPoint(410, 256.577345319221),
    Boardcore::TrajectoryPoint(420, 255.934744315076),
    Boardcore::TrajectoryPoint(430, 255.292090557166),
    Boardcore::TrajectoryPoint(440, 254.649376986224),
    Boardcore::TrajectoryPoint(450, 254.006573130353),
    Boardcore::TrajectoryPoint(460, 253.363681763672),
    Boardcore::TrajectoryPoint(470, 252.720701716302),
    Boardcore::TrajectoryPoint(480, 252.077625798741),
    Boardcore::TrajectoryPoint(490, 251.434446701433),
    Boardcore::TrajectoryPoint(500, 250.791114444396),
    Boardcore::TrajectoryPoint(510, 250.147657893368),
    Boardcore::TrajectoryPoint(520, 249.504069740104),
    Boardcore::TrajectoryPoint(530, 248.860342550179),
    Boardcore::TrajectoryPoint(540, 248.216468782729),
    Boardcore::TrajectoryPoint(550, 247.572389089514),
    Boardcore::TrajectoryPoint(560, 246.928141524884),
    Boardcore::TrajectoryPoint(570, 246.28371926802),
    Boardcore::TrajectoryPoint(580, 245.63911464834),
    Boardcore::TrajectoryPoint(590, 244.99431989753),
    Boardcore::TrajectoryPoint(600, 244.349286140961),
    Boardcore::TrajectoryPoint(610, 243.704023830753),
    Boardcore::TrajectoryPoint(620, 243.05854344275),
    Boardcore::TrajectoryPoint(630, 242.412837066885),
    Boardcore::TrajectoryPoint(640, 241.76689670034),
    Boardcore::TrajectoryPoint(650, 241.120712419571),
    Boardcore::TrajectoryPoint(660, 240.474212646564),
    Boardcore::TrajectoryPoint(670, 239.827450965802),
    Boardcore::TrajectoryPoint(680, 239.180419215729),
    Boardcore::TrajectoryPoint(690, 238.533109144221),
    Boardcore::TrajectoryPoint(700, 237.885512410192),
    Boardcore::TrajectoryPoint(710, 237.23762058497),
    Boardcore::TrajectoryPoint(720, 236.589359764525),
    Boardcore::TrajectoryPoint(730, 235.940778632156),
    Boardcore::TrajectoryPoint(740, 235.291874203266),
    Boardcore::TrajectoryPoint(750, 234.642637866695),
    Boardcore::TrajectoryPoint(760, 233.993060922544),
    Boardcore::TrajectoryPoint(770, 233.343134582795),
    Boardcore::TrajectoryPoint(780, 232.692835079068),
    Boardcore::TrajectoryPoint(790, 232.04211001394),
    Boardcore::TrajectoryPoint(800, 231.391006950357),
    Boardcore::TrajectoryPoint(810, 230.739516890557),
    Boardcore::TrajectoryPoint(820, 230.087630745773),
    Boardcore::TrajectoryPoint(830, 229.435339336306),
    Boardcore::TrajectoryPoint(840, 228.782633391468),
    Boardcore::TrajectoryPoint(850, 228.129503549421),
    Boardcore::TrajectoryPoint(860, 227.475896523684),
    Boardcore::TrajectoryPoint(870, 226.821818499148),
    Boardcore::TrajectoryPoint(880, 226.167287105672),
    Boardcore::TrajectoryPoint(890, 225.512292734126),
    Boardcore::TrajectoryPoint(900, 224.856825679618),
    Boardcore::TrajectoryPoint(910, 224.200876140985),
    Boardcore::TrajectoryPoint(920, 223.544434220207),
    Boardcore::TrajectoryPoint(930, 222.887489921754),
    Boardcore::TrajectoryPoint(940, 222.230033151859),
    Boardcore::TrajectoryPoint(950, 221.572015583163),
    Boardcore::TrajectoryPoint(960, 220.913438155265),
    Boardcore::TrajectoryPoint(970, 220.254317443184),
    Boardcore::TrajectoryPoint(980, 219.594643060165),
    Boardcore::TrajectoryPoint(990, 218.934404515419),
    Boardcore::TrajectoryPoint(1000, 218.273591213188),
    Boardcore::TrajectoryPoint(1010, 217.61219245177),
    Boardcore::TrajectoryPoint(1020, 216.950197422478),
    Boardcore::TrajectoryPoint(1030, 216.287595208578),
    Boardcore::TrajectoryPoint(1040, 215.624374784165),
    Boardcore::TrajectoryPoint(1050, 214.960525013013),
    Boardcore::TrajectoryPoint(1060, 214.296034647379),
    Boardcore::TrajectoryPoint(1070, 213.630871517951),
    Boardcore::TrajectoryPoint(1080, 212.965017611917),
    Boardcore::TrajectoryPoint(1090, 212.298489906365),
    Boardcore::TrajectoryPoint(1100, 211.631276796187),
    Boardcore::TrajectoryPoint(1110, 210.963366557954),
    Boardcore::TrajectoryPoint(1120, 210.294747348592),
    Boardcore::TrajectoryPoint(1130, 209.625407204036),
    Boardcore::TrajectoryPoint(1140, 208.955334037845),
    Boardcore::TrajectoryPoint(1150, 208.28451563979),
    Boardcore::TrajectoryPoint(1160, 207.612939674417),
    Boardcore::TrajectoryPoint(1170, 206.940593679572),
    Boardcore::TrajectoryPoint(1180, 206.267465064908),
    Boardcore::TrajectoryPoint(1190, 205.593541110354),
    Boardcore::TrajectoryPoint(1200, 204.918808964566),
    Boardcore::TrajectoryPoint(1210, 204.243255643344),
    Boardcore::TrajectoryPoint(1220, 203.566868028022),
    Boardcore::TrajectoryPoint(1230, 202.889632863839),
    Boardcore::TrajectoryPoint(1240, 202.21153675827),
    Boardcore::TrajectoryPoint(1250, 201.53256617934),
    Boardcore::TrajectoryPoint(1260, 200.852707453908),
    Boardcore::TrajectoryPoint(1270, 200.171946765919),
    Boardcore::TrajectoryPoint(1280, 199.490270154636),
    Boardcore::TrajectoryPoint(1290, 198.807663512838),
    Boardcore::TrajectoryPoint(1300, 198.124112584987),
    Boardcore::TrajectoryPoint(1310, 197.439602965376),
    Boardcore::TrajectoryPoint(1320, 196.75412009624),
    Boardcore::TrajectoryPoint(1330, 196.067649265834),
    Boardcore::TrajectoryPoint(1340, 195.380175606492),
    Boardcore::TrajectoryPoint(1350, 194.691684092639),
    Boardcore::TrajectoryPoint(1360, 194.002159538789),
    Boardcore::TrajectoryPoint(1370, 193.311586597493),
    Boardcore::TrajectoryPoint(1380, 192.619949757266),
    Boardcore::TrajectoryPoint(1390, 191.927233340475),
    Boardcore::TrajectoryPoint(1400, 191.233421501191),
    Boardcore::TrajectoryPoint(1410, 190.538498223009),
    Boardcore::TrajectoryPoint(1420, 189.842447316826),
    Boardcore::TrajectoryPoint(1430, 189.145252418589),
    Boardcore::TrajectoryPoint(1440, 188.446896986995),
    Boardcore::TrajectoryPoint(1450, 187.747364301159),
    Boardcore::TrajectoryPoint(1460, 187.046637458241),
    Boardcore::TrajectoryPoint(1470, 186.344685896473),
    Boardcore::TrajectoryPoint(1480, 185.641437787314),
    Boardcore::TrajectoryPoint(1490, 184.936938158347),
    Boardcore::TrajectoryPoint(1500, 184.23116922782),
    Boardcore::TrajectoryPoint(1510, 183.524113018062),
    Boardcore::TrajectoryPoint(1520, 182.815751352803),
    Boardcore::TrajectoryPoint(1530, 182.106065854438),
    Boardcore::TrajectoryPoint(1540, 181.395037941254),
    Boardcore::TrajectoryPoint(1550, 180.682648824593),
    Boardcore::TrajectoryPoint(1560, 179.968879505972),
    Boardcore::TrajectoryPoint(1570, 179.253710774138),
    Boardcore::TrajectoryPoint(1580, 178.537039308169),
    Boardcore::TrajectoryPoint(1590, 177.818869537136),
    Boardcore::TrajectoryPoint(1600, 177.099234333944),
    Boardcore::TrajectoryPoint(1610, 176.37811346051),
    Boardcore::TrajectoryPoint(1620, 175.655486448471),
    Boardcore::TrajectoryPoint(1630, 174.931332595849),
    Boardcore::TrajectoryPoint(1640, 174.205630963636),
    Boardcore::TrajectoryPoint(1650, 173.478327841722),
    Boardcore::TrajectoryPoint(1660, 172.749275972803),
    Boardcore::TrajectoryPoint(1670, 172.018603844947),
    Boardcore::TrajectoryPoint(1680, 171.286289374746),
    Boardcore::TrajectoryPoint(1690, 170.552310221331),
    Boardcore::TrajectoryPoint(1700, 169.816643782481),
    Boardcore::TrajectoryPoint(1710, 169.079225282976),
    Boardcore::TrajectoryPoint(1720, 168.339877914036),
    Boardcore::TrajectoryPoint(1730, 167.598764565644),
    Boardcore::TrajectoryPoint(1740, 166.855861372656),
    Boardcore::TrajectoryPoint(1750, 166.111144185136),
    Boardcore::TrajectoryPoint(1760, 165.36457128952),
    Boardcore::TrajectoryPoint(1770, 164.615871579257),
    Boardcore::TrajectoryPoint(1780, 163.865273400406),
    Boardcore::TrajectoryPoint(1790, 163.112751225491),
    Boardcore::TrajectoryPoint(1800, 162.35827921585),
    Boardcore::TrajectoryPoint(1810, 161.601654213921),
    Boardcore::TrajectoryPoint(1820, 160.842873905234),
    Boardcore::TrajectoryPoint(1830, 160.082052975945),
    Boardcore::TrajectoryPoint(1840, 159.319164080352),
    Boardcore::TrajectoryPoint(1850, 158.554000982508),
    Boardcore::TrajectoryPoint(1860, 157.786520296349),
    Boardcore::TrajectoryPoint(1870, 157.016875228295),
    Boardcore::TrajectoryPoint(1880, 156.245036806494),
    Boardcore::TrajectoryPoint(1890, 155.47065566823),
    Boardcore::TrajectoryPoint(1900, 154.69392281474),
    Boardcore::TrajectoryPoint(1910, 153.914894110974),
    Boardcore::TrajectoryPoint(1920, 153.133375453359),
    Boardcore::TrajectoryPoint(1930, 152.349205835247),
    Boardcore::TrajectoryPoint(1940, 151.562632767703),
    Boardcore::TrajectoryPoint(1950, 150.773534185399),
    Boardcore::TrajectoryPoint(1960, 149.981560334631),
    Boardcore::TrajectoryPoint(1970, 149.187069998669),
    Boardcore::TrajectoryPoint(1980, 148.38992052277),
    Boardcore::TrajectoryPoint(1990, 147.589755257652),
    Boardcore::TrajectoryPoint(2000, 146.786954671346),
    Boardcore::TrajectoryPoint(2010, 145.981252819485),
    Boardcore::TrajectoryPoint(2020, 145.172487907851),
    Boardcore::TrajectoryPoint(2030, 144.360962642657),
    Boardcore::TrajectoryPoint(2040, 143.546174276512),
    Boardcore::TrajectoryPoint(2050, 142.728378975948),
    Boardcore::TrajectoryPoint(2060, 141.907538073647),
    Boardcore::TrajectoryPoint(2070, 141.083247631909),
    Boardcore::TrajectoryPoint(2080, 140.255967094805),
    Boardcore::TrajectoryPoint(2090, 139.425061515319),
    Boardcore::TrajectoryPoint(2100, 138.590949343057),
    Boardcore::TrajectoryPoint(2110, 137.753289895611),
    Boardcore::TrajectoryPoint(2120, 136.912097549172),
    Boardcore::TrajectoryPoint(2130, 136.067377118832),
    Boardcore::TrajectoryPoint(2140, 135.218845385306),
    Boardcore::TrajectoryPoint(2150, 134.366741224796),
    Boardcore::TrajectoryPoint(2160, 133.510599631),
    Boardcore::TrajectoryPoint(2170, 132.650772461928),
    Boardcore::TrajectoryPoint(2180, 131.78673864621),
    Boardcore::TrajectoryPoint(2190, 130.918831691563),
    Boardcore::TrajectoryPoint(2200, 130.046610730485),
    Boardcore::TrajectoryPoint(2210, 129.170248672696),
    Boardcore::TrajectoryPoint(2220, 128.289532358958),
    Boardcore::TrajectoryPoint(2230, 127.404320217336),
    Boardcore::TrajectoryPoint(2240, 126.514786284946),
    Boardcore::TrajectoryPoint(2250, 125.620308205614),
    Boardcore::TrajectoryPoint(2260, 124.721410287016),
    Boardcore::TrajectoryPoint(2270, 123.817437448758),
    Boardcore::TrajectoryPoint(2280, 122.908588813764),
    Boardcore::TrajectoryPoint(2290, 121.994893386848),
    Boardcore::TrajectoryPoint(2300, 121.07561796148),
    Boardcore::TrajectoryPoint(2310, 120.151273596905),
    Boardcore::TrajectoryPoint(2320, 119.221615241238),
    Boardcore::TrajectoryPoint(2330, 118.286055996953),
    Boardcore::TrajectoryPoint(2340, 117.344985911017),
    Boardcore::TrajectoryPoint(2350, 116.398243289513),
    Boardcore::TrajectoryPoint(2360, 115.44518517945),
    Boardcore::TrajectoryPoint(2370, 114.48604282619),
    Boardcore::TrajectoryPoint(2380, 113.520724678477),
    Boardcore::TrajectoryPoint(2390, 112.549045052488),
    Boardcore::TrajectoryPoint(2400, 111.570420687917),
    Boardcore::TrajectoryPoint(2410, 110.584999104654),
    Boardcore::TrajectoryPoint(2420, 109.592641133541),
    Boardcore::TrajectoryPoint(2430, 108.593132913399),
    Boardcore::TrajectoryPoint(2440, 107.586252281755),
    Boardcore::TrajectoryPoint(2450, 106.57173518905),
    Boardcore::TrajectoryPoint(2460, 105.549149801927),
    Boardcore::TrajectoryPoint(2470, 104.518507964645),
    Boardcore::TrajectoryPoint(2480, 103.479552658945),
    Boardcore::TrajectoryPoint(2490, 102.432016514637),
    Boardcore::TrajectoryPoint(2500, 101.375621298234),
    Boardcore::TrajectoryPoint(2510, 100.310077370475),
    Boardcore::TrajectoryPoint(2520, 99.235083110531),
    Boardcore::TrajectoryPoint(2530, 98.1503243045352),
    Boardcore::TrajectoryPoint(2540, 97.0554734958335),
    Boardcore::TrajectoryPoint(2550, 95.9501892941772),
    Boardcore::TrajectoryPoint(2560, 94.8341156408201),
    Boardcore::TrajectoryPoint(2570, 93.7068810262245),
    Boardcore::TrajectoryPoint(2580, 92.5678271664744),
    Boardcore::TrajectoryPoint(2590, 91.4166322627236),
    Boardcore::TrajectoryPoint(2600, 90.2529769532625),
    Boardcore::TrajectoryPoint(2610, 89.0764135691778),
    Boardcore::TrajectoryPoint(2620, 87.8864738705577),
    Boardcore::TrajectoryPoint(2630, 86.6819426710483),
    Boardcore::TrajectoryPoint(2640, 85.4628459923314),
    Boardcore::TrajectoryPoint(2650, 84.2287169415001),
    Boardcore::TrajectoryPoint(2660, 82.9780163317025),
    Boardcore::TrajectoryPoint(2670, 81.7108205939478),
    Boardcore::TrajectoryPoint(2680, 80.4259622813465),
    Boardcore::TrajectoryPoint(2690, 79.1226171576967),
    Boardcore::TrajectoryPoint(2700, 77.7998772274888),
    Boardcore::TrajectoryPoint(2710, 76.4569067866936),
    Boardcore::TrajectoryPoint(2720, 75.0920408837629),
    Boardcore::TrajectoryPoint(2730, 73.704832097707),
    Boardcore::TrajectoryPoint(2740, 72.2936628824778),
    Boardcore::TrajectoryPoint(2750, 70.8566028065025),
    Boardcore::TrajectoryPoint(2760, 69.3926457352541),
    Boardcore::TrajectoryPoint(2770, 67.8999572445317),
    Boardcore::TrajectoryPoint(2780, 66.3765366972542),
    Boardcore::TrajectoryPoint(2790, 64.8201981892989),
    Boardcore::TrajectoryPoint(2800, 63.2285488049668),
    Boardcore::TrajectoryPoint(2810, 61.5989637281851),
    Boardcore::TrajectoryPoint(2820, 59.9279340518673),
    Boardcore::TrajectoryPoint(2830, 58.211929556346),
    Boardcore::TrajectoryPoint(2840, 56.4477775502365),
    Boardcore::TrajectoryPoint(2850, 54.6291435234969),
    Boardcore::TrajectoryPoint(2860, 52.7518252261055),
    Boardcore::TrajectoryPoint(2870, 50.80896146471),
    Boardcore::TrajectoryPoint(2880, 48.792422690945),
    Boardcore::TrajectoryPoint(2890, 46.6926977792784),
    Boardcore::TrajectoryPoint(2900, 44.4985889356846),
    Boardcore::TrajectoryPoint(2910, 42.1944223568009),
    Boardcore::TrajectoryPoint(2920, 39.7620072840045),
    Boardcore::TrajectoryPoint(2930, 37.1755750627816),
    Boardcore::TrajectoryPoint(2940, 34.4013884363771),
    Boardcore::TrajectoryPoint(2950, 31.3881081109143),
    Boardcore::TrajectoryPoint(2960, 28.060325006648),
    Boardcore::TrajectoryPoint(2970, 24.2876004674963),
    Boardcore::TrajectoryPoint(2980, 19.8199275497618),
    Boardcore::TrajectoryPoint(2990, 14.0061611648416),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t5_closed[] = {
    Boardcore::TrajectoryPoint(0, 282.688101171867),
    Boardcore::TrajectoryPoint(10, 282.040538892303),
    Boardcore::TrajectoryPoint(20, 281.393519239995),
    Boardcore::TrajectoryPoint(30, 280.746863091953),
    Boardcore::TrajectoryPoint(40, 280.100559939923),
    Boardcore::TrajectoryPoint(50, 279.454750002642),
    Boardcore::TrajectoryPoint(60, 278.80923449633),
    Boardcore::TrajectoryPoint(70, 278.164009455869),
    Boardcore::TrajectoryPoint(80, 277.519167764027),
    Boardcore::TrajectoryPoint(90, 276.874657695747),
    Boardcore::TrajectoryPoint(100, 276.230400933259),
    Boardcore::TrajectoryPoint(110, 275.586392784388),
    Boardcore::TrajectoryPoint(120, 274.942756292332),
    Boardcore::TrajectoryPoint(130, 274.299340341524),
    Boardcore::TrajectoryPoint(140, 273.656137056015),
    Boardcore::TrajectoryPoint(150, 273.013172843303),
    Boardcore::TrajectoryPoint(160, 272.370476026174),
    Boardcore::TrajectoryPoint(170, 271.727957195796),
    Boardcore::TrajectoryPoint(180, 271.085611024241),
    Boardcore::TrajectoryPoint(190, 270.443473250701),
    Boardcore::TrajectoryPoint(200, 269.801523683647),
    Boardcore::TrajectoryPoint(210, 269.159713197733),
    Boardcore::TrajectoryPoint(220, 268.518036075731),
    Boardcore::TrajectoryPoint(230, 267.876522055724),
    Boardcore::TrajectoryPoint(240, 267.235137919067),
    Boardcore::TrajectoryPoint(250, 266.593854610478),
    Boardcore::TrajectoryPoint(260, 265.952666105791),
    Boardcore::TrajectoryPoint(270, 265.311588757029),
    Boardcore::TrajectoryPoint(280, 264.670595175058),
    Boardcore::TrajectoryPoint(290, 264.029664825648),
    Boardcore::TrajectoryPoint(300, 263.388791437768),
    Boardcore::TrajectoryPoint(310, 262.747977312252),
    Boardcore::TrajectoryPoint(320, 262.107205703708),
    Boardcore::TrajectoryPoint(330, 261.466460360126),
    Boardcore::TrajectoryPoint(340, 260.825734806018),
    Boardcore::TrajectoryPoint(350, 260.185022367125),
    Boardcore::TrajectoryPoint(360, 259.544309779312),
    Boardcore::TrajectoryPoint(370, 258.903587061557),
    Boardcore::TrajectoryPoint(380, 258.26284756237),
    Boardcore::TrajectoryPoint(390, 257.622084469145),
    Boardcore::TrajectoryPoint(400, 256.981274115117),
    Boardcore::TrajectoryPoint(410, 256.340416530421),
    Boardcore::TrajectoryPoint(420, 255.699506109886),
    Boardcore::TrajectoryPoint(430, 255.05853589994),
    Boardcore::TrajectoryPoint(440, 254.417488489276),
    Boardcore::TrajectoryPoint(450, 253.776342760342),
    Boardcore::TrajectoryPoint(460, 253.135108562497),
    Boardcore::TrajectoryPoint(470, 252.493778805932),
    Boardcore::TrajectoryPoint(480, 251.852346278323),
    Boardcore::TrajectoryPoint(490, 251.210778993961),
    Boardcore::TrajectoryPoint(500, 250.569071625459),
    Boardcore::TrajectoryPoint(510, 249.927233247142),
    Boardcore::TrajectoryPoint(520, 249.285256518008),
    Boardcore::TrajectoryPoint(530, 248.643133988898),
    Boardcore::TrajectoryPoint(540, 248.000827689006),
    Boardcore::TrajectoryPoint(550, 247.358334336551),
    Boardcore::TrajectoryPoint(560, 246.715667253157),
    Boardcore::TrajectoryPoint(570, 246.072818857924),
    Boardcore::TrajectoryPoint(580, 245.429781471101),
    Boardcore::TrajectoryPoint(590, 244.786529569617),
    Boardcore::TrajectoryPoint(600, 244.143027988374),
    Boardcore::TrajectoryPoint(610, 243.499309656202),
    Boardcore::TrajectoryPoint(620, 242.855366751016),
    Boardcore::TrajectoryPoint(630, 242.211191357364),
    Boardcore::TrajectoryPoint(640, 241.566775468973),
    Boardcore::TrajectoryPoint(650, 240.9220665584),
    Boardcore::TrajectoryPoint(660, 240.277075336531),
    Boardcore::TrajectoryPoint(670, 239.63181582922),
    Boardcore::TrajectoryPoint(680, 238.986279872086),
    Boardcore::TrajectoryPoint(690, 238.340459211675),
    Boardcore::TrajectoryPoint(700, 237.694345506931),
    Boardcore::TrajectoryPoint(710, 237.047888723573),
    Boardcore::TrajectoryPoint(720, 236.401090194513),
    Boardcore::TrajectoryPoint(730, 235.753970621492),
    Boardcore::TrajectoryPoint(740, 235.106521482951),
    Boardcore::TrajectoryPoint(750, 234.458734168877),
    Boardcore::TrajectoryPoint(760, 233.810599981501),
    Boardcore::TrajectoryPoint(770, 233.162110135821),
    Boardcore::TrajectoryPoint(780, 232.513188786418),
    Boardcore::TrajectoryPoint(790, 231.863885743308),
    Boardcore::TrajectoryPoint(800, 231.21419853852),
    Boardcore::TrajectoryPoint(810, 230.564118176969),
    Boardcore::TrajectoryPoint(820, 229.913635573288),
    Boardcore::TrajectoryPoint(830, 229.262741551834),
    Boardcore::TrajectoryPoint(840, 228.61142684658),
    Boardcore::TrajectoryPoint(850, 227.959654340088),
    Boardcore::TrajectoryPoint(860, 227.307397564079),
    Boardcore::TrajectoryPoint(870, 226.654690872682),
    Boardcore::TrajectoryPoint(880, 226.001524756313),
    Boardcore::TrajectoryPoint(890, 225.34788961056),
    Boardcore::TrajectoryPoint(900, 224.693775735714),
    Boardcore::TrajectoryPoint(910, 224.039173336232),
    Boardcore::TrajectoryPoint(920, 223.384072520111),
    Boardcore::TrajectoryPoint(930, 222.728463298212),
    Boardcore::TrajectoryPoint(940, 222.072304012881),
    Boardcore::TrajectoryPoint(950, 221.415581504805),
    Boardcore::TrajectoryPoint(960, 220.758320045382),
    Boardcore::TrajectoryPoint(970, 220.100509356947),
    Boardcore::TrajectoryPoint(980, 219.442139059013),
    Boardcore::TrajectoryPoint(990, 218.783198667372),
    Boardcore::TrajectoryPoint(1000, 218.12367759314),
    Boardcore::TrajectoryPoint(1010, 217.463565141761),
    Boardcore::TrajectoryPoint(1020, 216.802850511958),
    Boardcore::TrajectoryPoint(1030, 216.141522794647),
    Boardcore::TrajectoryPoint(1040, 215.479570971809),
    Boardcore::TrajectoryPoint(1050, 214.816983915319),
    Boardcore::TrajectoryPoint(1060, 214.153717425552),
    Boardcore::TrajectoryPoint(1070, 213.489776161098),
    Boardcore::TrajectoryPoint(1080, 212.825166765856),
    Boardcore::TrajectoryPoint(1090, 212.159877759547),
    Boardcore::TrajectoryPoint(1100, 211.493897545066),
    Boardcore::TrajectoryPoint(1110, 210.827214407194),
    Boardcore::TrajectoryPoint(1120, 210.159816511265),
    Boardcore::TrajectoryPoint(1130, 209.491691901813),
    Boardcore::TrajectoryPoint(1140, 208.822828501178),
    Boardcore::TrajectoryPoint(1150, 208.153214108095),
    Boardcore::TrajectoryPoint(1160, 207.48283639624),
    Boardcore::TrajectoryPoint(1170, 206.811682912758),
    Boardcore::TrajectoryPoint(1180, 206.139741076762),
    Boardcore::TrajectoryPoint(1190, 205.466998177798),
    Boardcore::TrajectoryPoint(1200, 204.793441374292),
    Boardcore::TrajectoryPoint(1210, 204.11905769196),
    Boardcore::TrajectoryPoint(1220, 203.443834022202),
    Boardcore::TrajectoryPoint(1230, 202.767757120458),
    Boardcore::TrajectoryPoint(1240, 202.090813604546),
    Boardcore::TrajectoryPoint(1250, 201.412989952966),
    Boardcore::TrajectoryPoint(1260, 200.734272503186),
    Boardcore::TrajectoryPoint(1270, 200.054647449886),
    Boardcore::TrajectoryPoint(1280, 199.374100843191),
    Boardcore::TrajectoryPoint(1290, 198.692618586864),
    Boardcore::TrajectoryPoint(1300, 198.010186436472),
    Boardcore::TrajectoryPoint(1310, 197.326789997532),
    Boardcore::TrajectoryPoint(1320, 196.642414723614),
    Boardcore::TrajectoryPoint(1330, 195.957045914424),
    Boardcore::TrajectoryPoint(1340, 195.270668713852),
    Boardcore::TrajectoryPoint(1350, 194.583268107994),
    Boardcore::TrajectoryPoint(1360, 193.894828923131),
    Boardcore::TrajectoryPoint(1370, 193.205335823688),
    Boardcore::TrajectoryPoint(1380, 192.514773310153),
    Boardcore::TrajectoryPoint(1390, 191.823125716961),
    Boardcore::TrajectoryPoint(1400, 191.130377210347),
    Boardcore::TrajectoryPoint(1410, 190.436511786159),
    Boardcore::TrajectoryPoint(1420, 189.74151326764),
    Boardcore::TrajectoryPoint(1430, 189.045365303164),
    Boardcore::TrajectoryPoint(1440, 188.348051363942),
    Boardcore::TrajectoryPoint(1450, 187.649554741685),
    Boardcore::TrajectoryPoint(1460, 186.949858546221),
    Boardcore::TrajectoryPoint(1470, 186.24894570308),
    Boardcore::TrajectoryPoint(1480, 185.54676523742),
    Boardcore::TrajectoryPoint(1490, 184.843279592843),
    Boardcore::TrajectoryPoint(1500, 184.138519266054),
    Boardcore::TrajectoryPoint(1510, 183.432466292747),
    Boardcore::TrajectoryPoint(1520, 182.725102510072),
    Boardcore::TrajectoryPoint(1530, 182.016409553897),
    Boardcore::TrajectoryPoint(1540, 181.306368856026),
    Boardcore::TrajectoryPoint(1550, 180.594961641364),
    Boardcore::TrajectoryPoint(1560, 179.882168925032),
    Boardcore::TrajectoryPoint(1570, 179.16797150942),
    Boardcore::TrajectoryPoint(1580, 178.452325720617),
    Boardcore::TrajectoryPoint(1590, 177.735116059764),
    Boardcore::TrajectoryPoint(1600, 177.016435709598),
    Boardcore::TrajectoryPoint(1610, 176.296264446075),
    Boardcore::TrajectoryPoint(1620, 175.574581814897),
    Boardcore::TrajectoryPoint(1630, 174.851367128159),
    Boardcore::TrajectoryPoint(1640, 174.126599460943),
    Boardcore::TrajectoryPoint(1650, 173.400257647838),
    Boardcore::TrajectoryPoint(1660, 172.67215436341),
    Boardcore::TrajectoryPoint(1670, 171.942399882815),
    Boardcore::TrajectoryPoint(1680, 171.210997905676),
    Boardcore::TrajectoryPoint(1690, 170.477926105456),
    Boardcore::TrajectoryPoint(1700, 169.743161894254),
    Boardcore::TrajectoryPoint(1710, 169.006682418833),
    Boardcore::TrajectoryPoint(1720, 168.268241081767),
    Boardcore::TrajectoryPoint(1730, 167.528013784343),
    Boardcore::TrajectoryPoint(1740, 166.785991565845),
    Boardcore::TrajectoryPoint(1750, 166.042150290753),
    Boardcore::TrajectoryPoint(1760, 165.296465534266),
    Boardcore::TrajectoryPoint(1770, 164.548668942258),
    Boardcore::TrajectoryPoint(1780, 163.798930623147),
    Boardcore::TrajectoryPoint(1790, 163.047263296463),
    Boardcore::TrajectoryPoint(1800, 162.293641137946),
    Boardcore::TrajectoryPoint(1810, 161.537914704737),
    Boardcore::TrajectoryPoint(1820, 160.779973290626),
    Boardcore::TrajectoryPoint(1830, 160.019986295891),
    Boardcore::TrajectoryPoint(1840, 159.257926389177),
    Boardcore::TrajectoryPoint(1850, 158.493639835173),
    Boardcore::TrajectoryPoint(1860, 157.726977236874),
    Boardcore::TrajectoryPoint(1870, 156.958145348691),
    Boardcore::TrajectoryPoint(1880, 156.187115212991),
    Boardcore::TrajectoryPoint(1890, 155.413588431841),
    Boardcore::TrajectoryPoint(1900, 154.637653024706),
    Boardcore::TrajectoryPoint(1910, 153.859416911524),
    Boardcore::TrajectoryPoint(1920, 153.078736252996),
    Boardcore::TrajectoryPoint(1930, 152.295348427377),
    Boardcore::TrajectoryPoint(1940, 151.509552334751),
    Boardcore::TrajectoryPoint(1950, 150.721275271418),
    Boardcore::TrajectoryPoint(1960, 149.930067642314),
    Boardcore::TrajectoryPoint(1970, 149.136338748685),
    Boardcore::TrajectoryPoint(1980, 148.339994206518),
    Boardcore::TrajectoryPoint(1990, 147.540579677946),
    Boardcore::TrajectoryPoint(2000, 146.738525086994),
    Boardcore::TrajectoryPoint(2010, 145.933611493748),
    Boardcore::TrajectoryPoint(2020, 145.125581921281),
    Boardcore::TrajectoryPoint(2030, 144.31478729198),
    Boardcore::TrajectoryPoint(2040, 143.500770433099),
    Boardcore::TrajectoryPoint(2050, 142.683695163517),
    Boardcore::TrajectoryPoint(2060, 141.863614864037),
    Boardcore::TrajectoryPoint(2070, 141.040033876628),
    Boardcore::TrajectoryPoint(2080, 140.213458152458),
    Boardcore::TrajectoryPoint(2090, 139.383296290621),
    Boardcore::TrajectoryPoint(2100, 138.549878408347),
    Boardcore::TrajectoryPoint(2110, 137.712951636674),
    Boardcore::TrajectoryPoint(2120, 136.872443087695),
    Boardcore::TrajectoryPoint(2130, 136.028444229188),
    Boardcore::TrajectoryPoint(2140, 135.180585831873),
    Boardcore::TrajectoryPoint(2150, 134.329192082392),
    Boardcore::TrajectoryPoint(2160, 133.473713395554),
    Boardcore::TrajectoryPoint(2170, 132.614585424656),
    Boardcore::TrajectoryPoint(2180, 131.751204119242),
    Boardcore::TrajectoryPoint(2190, 130.88398510232),
    Boardcore::TrajectoryPoint(2200, 130.012406287983),
    Boardcore::TrajectoryPoint(2210, 129.136720864012),
    Boardcore::TrajectoryPoint(2220, 128.256636366933),
    Boardcore::TrajectoryPoint(2230, 127.372089515595),
    Boardcore::TrajectoryPoint(2240, 126.483177103573),
    Boardcore::TrajectoryPoint(2250, 125.589352934917),
    Boardcore::TrajectoryPoint(2260, 124.691103335799),
    Boardcore::TrajectoryPoint(2270, 123.787735934459),
    Boardcore::TrajectoryPoint(2280, 122.879524164706),
    Boardcore::TrajectoryPoint(2290, 121.966423958798),
    Boardcore::TrajectoryPoint(2300, 121.047773917246),
    Boardcore::TrajectoryPoint(2310, 120.124049225411),
    Boardcore::TrajectoryPoint(2320, 119.194970114686),
    Boardcore::TrajectoryPoint(2330, 118.26001900213),
    Boardcore::TrajectoryPoint(2340, 117.31955126633),
    Boardcore::TrajectoryPoint(2350, 116.373405179326),
    Boardcore::TrajectoryPoint(2360, 115.420904625126),
    Boardcore::TrajectoryPoint(2370, 114.462347184565),
    Boardcore::TrajectoryPoint(2380, 113.497608073052),
    Boardcore::TrajectoryPoint(2390, 112.526501576778),
    Boardcore::TrajectoryPoint(2400, 111.548413182951),
    Boardcore::TrajectoryPoint(2410, 110.563553042523),
    Boardcore::TrajectoryPoint(2420, 109.571750555361),
    Boardcore::TrajectoryPoint(2430, 108.572791833878),
    Boardcore::TrajectoryPoint(2440, 107.566454690223),
    Boardcore::TrajectoryPoint(2450, 106.552446366232),
    Boardcore::TrajectoryPoint(2460, 105.530392709418),
    Boardcore::TrajectoryPoint(2470, 104.500276549046),
    Boardcore::TrajectoryPoint(2480, 103.461840844568),
    Boardcore::TrajectoryPoint(2490, 102.414818204401),
    Boardcore::TrajectoryPoint(2500, 101.358930374525),
    Boardcore::TrajectoryPoint(2510, 100.293887695989),
    Boardcore::TrajectoryPoint(2520, 99.2193885290931),
    Boardcore::TrajectoryPoint(2530, 98.1351186418885),
    Boardcore::TrajectoryPoint(2540, 97.0407505604146),
    Boardcore::TrajectoryPoint(2550, 95.9359428778676),
    Boardcore::TrajectoryPoint(2560, 94.8203395196782),
    Boardcore::TrajectoryPoint(2570, 93.6935689611989),
    Boardcore::TrajectoryPoint(2580, 92.5549952497968),
    Boardcore::TrajectoryPoint(2590, 91.4042512345392),
    Boardcore::TrajectoryPoint(2600, 90.2410405131566),
    Boardcore::TrajectoryPoint(2610, 89.0649154047724),
    Boardcore::TrajectoryPoint(2620, 87.8754076581241),
    Boardcore::TrajectoryPoint(2630, 86.6713218347942),
    Boardcore::TrajectoryPoint(2640, 85.4526436703645),
    Boardcore::TrajectoryPoint(2650, 84.2189267619438),
    Boardcore::TrajectoryPoint(2660, 82.968650132745),
    Boardcore::TrajectoryPoint(2670, 81.7018529435004),
    Boardcore::TrajectoryPoint(2680, 80.4174040692585),
    Boardcore::TrajectoryPoint(2690, 79.114443791853),
    Boardcore::TrajectoryPoint(2700, 77.7920985252084),
    Boardcore::TrajectoryPoint(2710, 76.4494991296178),
    Boardcore::TrajectoryPoint(2720, 75.0850128988675),
    Boardcore::TrajectoryPoint(2730, 73.698176060107),
    Boardcore::TrajectoryPoint(2740, 72.2873565304023),
    Boardcore::TrajectoryPoint(2750, 70.8506530766122),
    Boardcore::TrajectoryPoint(2760, 69.3870446858572),
    Boardcore::TrajectoryPoint(2770, 67.8946968517928),
    Boardcore::TrajectoryPoint(2780, 66.3716088579391),
    Boardcore::TrajectoryPoint(2790, 64.8155947232817),
    Boardcore::TrajectoryPoint(2800, 63.2242614574802),
    Boardcore::TrajectoryPoint(2810, 61.5949841717916),
    Boardcore::TrajectoryPoint(2820, 59.92426404059),
    Boardcore::TrajectoryPoint(2830, 58.2085497600445),
    Boardcore::TrajectoryPoint(2840, 56.4446885417596),
    Boardcore::TrajectoryPoint(2850, 54.6263267241488),
    Boardcore::TrajectoryPoint(2860, 52.7492798289198),
    Boardcore::TrajectoryPoint(2870, 50.8066773025657),
    Boardcore::TrajectoryPoint(2880, 48.7903893844612),
    Boardcore::TrajectoryPoint(2890, 46.6909047380368),
    Boardcore::TrajectoryPoint(2900, 44.4970253573919),
    Boardcore::TrajectoryPoint(2910, 42.1930824137896),
    Boardcore::TrajectoryPoint(2920, 39.760878403838),
    Boardcore::TrajectoryPoint(2930, 37.1746442088724),
    Boardcore::TrajectoryPoint(2940, 34.4006456868008),
    Boardcore::TrajectoryPoint(2950, 31.3875380226098),
    Boardcore::TrajectoryPoint(2960, 28.059911239408),
    Boardcore::TrajectoryPoint(2970, 24.2873290314453),
    Boardcore::TrajectoryPoint(2980, 19.8197775711084),
    Boardcore::TrajectoryPoint(2990, 14.0061073734936),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t6_closed[] = {
    Boardcore::TrajectoryPoint(0, 282.377587985693),
    Boardcore::TrajectoryPoint(10, 281.732309430491),
    Boardcore::TrajectoryPoint(20, 281.087401454484),
    Boardcore::TrajectoryPoint(30, 280.442818037048),
    Boardcore::TrajectoryPoint(40, 279.798681345873),
    Boardcore::TrajectoryPoint(50, 279.154909586924),
    Boardcore::TrajectoryPoint(60, 278.511424267346),
    Boardcore::TrajectoryPoint(70, 277.868240327989),
    Boardcore::TrajectoryPoint(80, 277.225470264565),
    Boardcore::TrajectoryPoint(90, 276.582949922817),
    Boardcore::TrajectoryPoint(100, 275.940674875469),
    Boardcore::TrajectoryPoint(110, 275.298707833507),
    Boardcore::TrajectoryPoint(120, 274.657025584097),
    Boardcore::TrajectoryPoint(130, 274.015553061824),
    Boardcore::TrajectoryPoint(140, 273.374285246271),
    Boardcore::TrajectoryPoint(150, 272.73330022754),
    Boardcore::TrajectoryPoint(160, 272.092510324037),
    Boardcore::TrajectoryPoint(170, 271.451890702015),
    Boardcore::TrajectoryPoint(180, 270.811439705348),
    Boardcore::TrajectoryPoint(190, 270.171217695099),
    Boardcore::TrajectoryPoint(200, 269.531132695562),
    Boardcore::TrajectoryPoint(210, 268.891179174104),
    Boardcore::TrajectoryPoint(220, 268.251361241108),
    Boardcore::TrajectoryPoint(230, 267.611701944043),
    Boardcore::TrajectoryPoint(240, 266.972141861716),
    Boardcore::TrajectoryPoint(250, 266.332675133003),
    Boardcore::TrajectoryPoint(260, 265.693302513256),
    Boardcore::TrajectoryPoint(270, 265.054032163641),
    Boardcore::TrajectoryPoint(280, 264.414823841794),
    Boardcore::TrajectoryPoint(290, 263.775671422061),
    Boardcore::TrajectoryPoint(300, 263.136570108066),
    Boardcore::TrajectoryPoint(310, 262.49752113469),
    Boardcore::TrajectoryPoint(320, 261.858497591597),
    Boardcore::TrajectoryPoint(330, 261.219493134335),
    Boardcore::TrajectoryPoint(340, 260.580501229514),
    Boardcore::TrajectoryPoint(350, 259.941511516579),
    Boardcore::TrajectoryPoint(360, 259.302511278654),
    Boardcore::TrajectoryPoint(370, 258.663493884437),
    Boardcore::TrajectoryPoint(380, 258.024452636539),
    Boardcore::TrajectoryPoint(390, 257.385372326085),
    Boardcore::TrajectoryPoint(400, 256.746238762442),
    Boardcore::TrajectoryPoint(410, 256.107052296794),
    Boardcore::TrajectoryPoint(420, 255.467806082498),
    Boardcore::TrajectoryPoint(430, 254.828493135299),
    Boardcore::TrajectoryPoint(440, 254.18907628311),
    Boardcore::TrajectoryPoint(450, 253.549568710581),
    Boardcore::TrajectoryPoint(460, 252.909965908216),
    Boardcore::TrajectoryPoint(470, 252.270260761716),
    Boardcore::TrajectoryPoint(480, 251.63043935749),
    Boardcore::TrajectoryPoint(490, 250.990462097692),
    Boardcore::TrajectoryPoint(500, 250.350354437471),
    Boardcore::TrajectoryPoint(510, 249.710109129774),
    Boardcore::TrajectoryPoint(520, 249.069718817562),
    Boardcore::TrajectoryPoint(530, 248.42916718729),
    Boardcore::TrajectoryPoint(540, 247.788409130061),
    Boardcore::TrajectoryPoint(550, 247.147478319368),
    Boardcore::TrajectoryPoint(560, 246.506367264172),
    Boardcore::TrajectoryPoint(570, 245.865068373384),
    Boardcore::TrajectoryPoint(580, 245.223573959641),
    Boardcore::TrajectoryPoint(590, 244.581820308481),
    Boardcore::TrajectoryPoint(600, 243.939845272358),
    Boardcore::TrajectoryPoint(610, 243.297647092256),
    Boardcore::TrajectoryPoint(620, 242.655217939908),
    Boardcore::TrajectoryPoint(630, 242.012549895657),
    Boardcore::TrajectoryPoint(640, 241.369615652146),
    Boardcore::TrajectoryPoint(650, 240.726376252019),
    Boardcore::TrajectoryPoint(660, 240.082870361437),
    Boardcore::TrajectoryPoint(670, 239.439089903337),
    Boardcore::TrajectoryPoint(680, 238.795026711413),
    Boardcore::TrajectoryPoint(690, 238.150672531683),
    Boardcore::TrajectoryPoint(700, 237.506002077061),
    Boardcore::TrajectoryPoint(710, 236.860967622884),
    Boardcore::TrajectoryPoint(720, 236.215614383943),
    Boardcore::TrajectoryPoint(730, 235.569933927595),
    Boardcore::TrajectoryPoint(740, 234.923917732977),
    Boardcore::TrajectoryPoint(750, 234.277557191779),
    Boardcore::TrajectoryPoint(760, 233.630843608847),
    Boardcore::TrajectoryPoint(770, 232.98372348142),
    Boardcore::TrajectoryPoint(780, 232.33620200666),
    Boardcore::TrajectoryPoint(790, 231.68829920493),
    Boardcore::TrajectoryPoint(800, 231.040006173866),
    Boardcore::TrajectoryPoint(810, 230.391313921443),
    Boardcore::TrajectoryPoint(820, 229.742213366026),
    Boardcore::TrajectoryPoint(830, 229.092695336323),
    Boardcore::TrajectoryPoint(840, 228.442740225547),
    Boardcore::TrajectoryPoint(850, 227.792286270239),
    Boardcore::TrajectoryPoint(860, 227.141385845442),
    Boardcore::TrajectoryPoint(870, 226.490029539945),
    Boardcore::TrajectoryPoint(880, 225.838207848608),
    Boardcore::TrajectoryPoint(890, 225.185911171937),
    Boardcore::TrajectoryPoint(900, 224.53312981558),
    Boardcore::TrajectoryPoint(910, 223.879853989759),
    Boardcore::TrajectoryPoint(920, 223.226073808613),
    Boardcore::TrajectoryPoint(930, 222.571755949863),
    Boardcore::TrajectoryPoint(940, 221.916869864789),
    Boardcore::TrajectoryPoint(950, 221.26144914186),
    Boardcore::TrajectoryPoint(960, 220.605483611077),
    Boardcore::TrajectoryPoint(970, 219.948963000807),
    Boardcore::TrajectoryPoint(980, 219.291876936906),
    Boardcore::TrajectoryPoint(990, 218.634214941807),
    Boardcore::TrajectoryPoint(1000, 217.975966433543),
    Boardcore::TrajectoryPoint(1010, 217.317120724732),
    Boardcore::TrajectoryPoint(1020, 216.65766702152),
    Boardcore::TrajectoryPoint(1030, 215.997594422475),
    Boardcore::TrajectoryPoint(1040, 215.33689191745),
    Boardcore::TrajectoryPoint(1050, 214.675505434962),
    Boardcore::TrajectoryPoint(1060, 214.013458032301),
    Boardcore::TrajectoryPoint(1070, 213.350748129821),
    Boardcore::TrajectoryPoint(1080, 212.687364370357),
    Boardcore::TrajectoryPoint(1090, 212.023295281395),
    Boardcore::TrajectoryPoint(1100, 211.358529273804),
    Boardcore::TrajectoryPoint(1110, 210.693054640532),
    Boardcore::TrajectoryPoint(1120, 210.026859555272),
    Boardcore::TrajectoryPoint(1130, 209.359932071098),
    Boardcore::TrajectoryPoint(1140, 208.692260119067),
    Boardcore::TrajectoryPoint(1150, 208.023831506799),
    Boardcore::TrajectoryPoint(1160, 207.354633917021),
    Boardcore::TrajectoryPoint(1170, 206.684654906089),
    Boardcore::TrajectoryPoint(1180, 206.013881902479),
    Boardcore::TrajectoryPoint(1190, 205.342302205252),
    Boardcore::TrajectoryPoint(1200, 204.669902982496),
    Boardcore::TrajectoryPoint(1210, 203.996671269731),
    Boardcore::TrajectoryPoint(1220, 203.322593968298),
    Boardcore::TrajectoryPoint(1230, 202.647657843716),
    Boardcore::TrajectoryPoint(1240, 201.971849524014),
    Boardcore::TrajectoryPoint(1250, 201.295155498032),
    Boardcore::TrajectoryPoint(1260, 200.617562113704),
    Boardcore::TrajectoryPoint(1270, 199.939055576302),
    Boardcore::TrajectoryPoint(1280, 199.25962194666),
    Boardcore::TrajectoryPoint(1290, 198.579247139372),
    Boardcore::TrajectoryPoint(1300, 197.89791692095),
    Boardcore::TrajectoryPoint(1310, 197.215616907969),
    Boardcore::TrajectoryPoint(1320, 196.532332565168),
    Boardcore::TrajectoryPoint(1330, 195.84804920353),
    Boardcore::TrajectoryPoint(1340, 195.162751978331),
    Boardcore::TrajectoryPoint(1350, 194.47642588715),
    Boardcore::TrajectoryPoint(1360, 193.789055767856),
    Boardcore::TrajectoryPoint(1370, 193.100626296561),
    Boardcore::TrajectoryPoint(1380, 192.411121985533),
    Boardcore::TrajectoryPoint(1390, 191.720527181081),
    Boardcore::TrajectoryPoint(1400, 191.028826061407),
    Boardcore::TrajectoryPoint(1410, 190.336002634411),
    Boardcore::TrajectoryPoint(1420, 189.642040735477),
    Boardcore::TrajectoryPoint(1430, 188.9469240252),
    Boardcore::TrajectoryPoint(1440, 188.250635987094),
    Boardcore::TrajectoryPoint(1450, 187.55315992525),
    Boardcore::TrajectoryPoint(1460, 186.854478961952),
    Boardcore::TrajectoryPoint(1470, 186.154576035257),
    Boardcore::TrajectoryPoint(1480, 185.453433896533),
    Boardcore::TrajectoryPoint(1490, 184.750974236521),
    Boardcore::TrajectoryPoint(1500, 184.047207447442),
    Boardcore::TrajectoryPoint(1510, 183.34214273172),
    Boardcore::TrajectoryPoint(1520, 182.635761939682),
    Boardcore::TrajectoryPoint(1530, 181.928046720425),
    Boardcore::TrajectoryPoint(1540, 181.218978519023),
    Boardcore::TrajectoryPoint(1550, 180.508538573699),
    Boardcore::TrajectoryPoint(1560, 179.796707912927),
    Boardcore::TrajectoryPoint(1570, 179.083467352492),
    Boardcore::TrajectoryPoint(1580, 178.368797492488),
    Boardcore::TrajectoryPoint(1590, 177.652568566211),
    Boardcore::TrajectoryPoint(1600, 176.934828868062),
    Boardcore::TrajectoryPoint(1610, 176.215593098412),
    Boardcore::TrajectoryPoint(1620, 175.494840816753),
    Boardcore::TrajectoryPoint(1630, 174.772551348991),
    Boardcore::TrajectoryPoint(1640, 174.04870378403),
    Boardcore::TrajectoryPoint(1650, 173.323276970286),
    Boardcore::TrajectoryPoint(1660, 172.59614061578),
    Boardcore::TrajectoryPoint(1670, 171.867290177862),
    Boardcore::TrajectoryPoint(1680, 171.13678717253),
    Boardcore::TrajectoryPoint(1690, 170.404609287296),
    Boardcore::TrajectoryPoint(1700, 169.670733948302),
    Boardcore::TrajectoryPoint(1710, 168.935138316339),
    Boardcore::TrajectoryPoint(1720, 168.197631221289),
    Boardcore::TrajectoryPoint(1730, 167.458276875386),
    Boardcore::TrajectoryPoint(1740, 166.71712261378),
    Boardcore::TrajectoryPoint(1750, 165.974144315084),
    Boardcore::TrajectoryPoint(1760, 165.229317568602),
    Boardcore::TrajectoryPoint(1770, 164.482428077796),
    Boardcore::TrajectoryPoint(1780, 163.733536936318),
    Boardcore::TrajectoryPoint(1790, 162.98271185635),
    Boardcore::TrajectoryPoint(1800, 162.229927027745),
    Boardcore::TrajectoryPoint(1810, 161.475086193017),
    Boardcore::TrajectoryPoint(1820, 160.717971324171),
    Boardcore::TrajectoryPoint(1830, 159.958805994262),
    Boardcore::TrajectoryPoint(1840, 159.197562885988),
    Boardcore::TrajectoryPoint(1850, 158.434140231948),
    Boardcore::TrajectoryPoint(1860, 157.668283702024),
    Boardcore::TrajectoryPoint(1870, 156.90025305277),
    Boardcore::TrajectoryPoint(1880, 156.130019340481),
    Boardcore::TrajectoryPoint(1890, 155.357334603062),
    Boardcore::TrajectoryPoint(1900, 154.582184949424),
    Boardcore::TrajectoryPoint(1910, 153.804729811455),
    Boardcore::TrajectoryPoint(1920, 153.024875080484),
    Boardcore::TrajectoryPoint(1930, 152.242257601043),
    Boardcore::TrajectoryPoint(1940, 151.457227113734),
    Boardcore::TrajectoryPoint(1950, 150.669751436109),
    Boardcore::TrajectoryPoint(1960, 149.879307133657),
    Boardcore::TrajectoryPoint(1970, 149.086328556871),
    Boardcore::TrajectoryPoint(1980, 148.290777368625),
    Boardcore::TrajectoryPoint(1990, 147.492102618348),
    Boardcore::TrajectoryPoint(2000, 146.69078313964),
    Boardcore::TrajectoryPoint(2010, 145.886646474227),
    Boardcore::TrajectoryPoint(2020, 145.079341524037),
    Boardcore::TrajectoryPoint(2030, 144.269266888089),
    Boardcore::TrajectoryPoint(2040, 143.456010456344),
    Boardcore::TrajectoryPoint(2050, 142.639644740355),
    Boardcore::TrajectoryPoint(2060, 141.820314124543),
    Boardcore::TrajectoryPoint(2070, 140.997432278622),
    Boardcore::TrajectoryPoint(2080, 140.171551127594),
    Boardcore::TrajectoryPoint(2090, 139.342122317608),
    Boardcore::TrajectoryPoint(2100, 138.509388648927),
    Boardcore::TrajectoryPoint(2110, 137.67318405093),
    Boardcore::TrajectoryPoint(2120, 136.833349385745),
    Boardcore::TrajectoryPoint(2130, 135.990061761876),
    Boardcore::TrajectoryPoint(2140, 135.142866949135),
    Boardcore::TrajectoryPoint(2150, 134.292173439453),
    Boardcore::TrajectoryPoint(2160, 133.437348069251),
    Boardcore::TrajectoryPoint(2170, 132.578909292209),
    Boardcore::TrajectoryPoint(2180, 131.716171067356),
    Boardcore::TrajectoryPoint(2190, 130.849630151594),
    Boardcore::TrajectoryPoint(2200, 129.978684214076),
    Boardcore::TrajectoryPoint(2210, 129.103665755846),
    Boardcore::TrajectoryPoint(2220, 128.22420396456),
    Boardcore::TrajectoryPoint(2230, 127.340312904556),
    Boardcore::TrajectoryPoint(2240, 126.452013060314),
    Boardcore::TrajectoryPoint(2250, 125.558833473067),
    Boardcore::TrajectoryPoint(2260, 124.661222945621),
    Boardcore::TrajectoryPoint(2270, 123.758452274799),
    Boardcore::TrajectoryPoint(2280, 122.850868293351),
    Boardcore::TrajectoryPoint(2290, 121.93835475843),
    Boardcore::TrajectoryPoint(2300, 121.020321194971),
    Boardcore::TrajectoryPoint(2310, 120.09720735367),
    Boardcore::TrajectoryPoint(2320, 119.168699181402),
    Boardcore::TrajectoryPoint(2330, 118.234347550413),
    Boardcore::TrajectoryPoint(2340, 117.294473599272),
    Boardcore::TrajectoryPoint(2350, 116.348915566553),
    Boardcore::TrajectoryPoint(2360, 115.396964591081),
    Boardcore::TrajectoryPoint(2370, 114.438983756115),
    Boardcore::TrajectoryPoint(2380, 113.474815459909),
    Boardcore::TrajectoryPoint(2390, 112.504273959156),
    Boardcore::TrajectoryPoint(2400, 111.526713885517),
    Boardcore::TrajectoryPoint(2410, 110.542407227548),
    Boardcore::TrajectoryPoint(2420, 109.551152351413),
    Boardcore::TrajectoryPoint(2430, 108.552735343528),
    Boardcore::TrajectoryPoint(2440, 107.546933991046),
    Boardcore::TrajectoryPoint(2450, 106.533427194834),
    Boardcore::TrajectoryPoint(2460, 105.511897745933),
    Boardcore::TrajectoryPoint(2470, 104.482299828864),
    Boardcore::TrajectoryPoint(2480, 103.444376381108),
    Boardcore::TrajectoryPoint(2490, 102.397859989983),
    Boardcore::TrajectoryPoint(2500, 101.342472381222),
    Boardcore::TrajectoryPoint(2510, 100.277923876444),
    Boardcore::TrajectoryPoint(2520, 99.203912817319),
    Boardcore::TrajectoryPoint(2530, 98.1201249540483),
    Boardcore::TrajectoryPoint(2540, 97.0262327955751),
    Boardcore::TrajectoryPoint(2550, 95.9218949187366),
    Boardcore::TrajectoryPoint(2560, 94.8067552333213),
    Boardcore::TrajectoryPoint(2570, 93.6804421997382),
    Boardcore::TrajectoryPoint(2580, 92.5423419042986),
    Boardcore::TrajectoryPoint(2590, 91.3920424375281),
    Boardcore::TrajectoryPoint(2600, 90.2292700561331),
    Boardcore::TrajectoryPoint(2610, 89.053577067376),
    Boardcore::TrajectoryPoint(2620, 87.864495208734),
    Boardcore::TrajectoryPoint(2630, 86.6608485294924),
    Boardcore::TrajectoryPoint(2640, 85.4425830100526),
    Boardcore::TrajectoryPoint(2650, 84.2092724673295),
    Boardcore::TrajectoryPoint(2660, 82.9594138936855),
    Boardcore::TrajectoryPoint(2670, 81.6930096727817),
    Boardcore::TrajectoryPoint(2680, 80.4089645200063),
    Boardcore::TrajectoryPoint(2690, 79.1063837064905),
    Boardcore::TrajectoryPoint(2700, 77.7844275979076),
    Boardcore::TrajectoryPoint(2710, 76.4421940640638),
    Boardcore::TrajectoryPoint(2720, 75.0780822143066),
    Boardcore::TrajectoryPoint(2730, 73.6916121415514),
    Boardcore::TrajectoryPoint(2740, 72.2811374207778),
    Boardcore::TrajectoryPoint(2750, 70.8447856266089),
    Boardcore::TrajectoryPoint(2760, 69.381521066633),
    Boardcore::TrajectoryPoint(2770, 67.8895091534803),
    Boardcore::TrajectoryPoint(2780, 66.3667490923357),
    Boardcore::TrajectoryPoint(2790, 64.8110548263072),
    Boardcore::TrajectoryPoint(2800, 63.2200332913812),
    Boardcore::TrajectoryPoint(2810, 61.5910595270727),
    Boardcore::TrajectoryPoint(2820, 59.9206446530573),
    Boardcore::TrajectoryPoint(2830, 58.2052165659607),
    Boardcore::TrajectoryPoint(2840, 56.4416421112737),
    Boardcore::TrajectoryPoint(2850, 54.6235487350757),
    Boardcore::TrajectoryPoint(2860, 52.7467694900015),
    Boardcore::TrajectoryPoint(2870, 50.804424589089),
    Boardcore::TrajectoryPoint(2880, 48.7883840623235),
    Boardcore::TrajectoryPoint(2890, 46.689136364921),
    Boardcore::TrajectoryPoint(2900, 44.4954832819116),
    Boardcore::TrajectoryPoint(2910, 42.191760891439),
    Boardcore::TrajectoryPoint(2920, 39.7597650369709),
    Boardcore::TrajectoryPoint(2930, 37.1737261419933),
    Boardcore::TrajectoryPoint(2940, 34.3999131365101),
    Boardcore::TrajectoryPoint(2950, 31.3869757595977),
    Boardcore::TrajectoryPoint(2960, 28.059503149398),
    Boardcore::TrajectoryPoint(2970, 24.2870613182854),
    Boardcore::TrajectoryPoint(2980, 19.8196296486587),
    Boardcore::TrajectoryPoint(2990, 14.0060543193188),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t7_closed[] = {
    Boardcore::TrajectoryPoint(0, 282.072241236148),
    Boardcore::TrajectoryPoint(10, 281.428843762445),
    Boardcore::TrajectoryPoint(20, 280.785983514998),
    Boardcore::TrajectoryPoint(30, 280.143472282807),
    Boardcore::TrajectoryPoint(40, 279.50142396704),
    Boardcore::TrajectoryPoint(50, 278.859658019611),
    Boardcore::TrajectoryPoint(60, 278.218170497137),
    Boardcore::TrajectoryPoint(70, 277.577058195089),
    Boardcore::TrajectoryPoint(80, 276.936254067678),
    Boardcore::TrajectoryPoint(90, 276.295691884726),
    Boardcore::TrajectoryPoint(100, 275.655371515757),
    Boardcore::TrajectoryPoint(110, 275.015402905057),
    Boardcore::TrajectoryPoint(120, 274.37564105859),
    Boardcore::TrajectoryPoint(130, 273.736081190695),
    Boardcore::TrajectoryPoint(140, 273.096754117379),
    Boardcore::TrajectoryPoint(150, 272.457673202883),
    Boardcore::TrajectoryPoint(160, 271.818760177855),
    Boardcore::TrajectoryPoint(170, 271.180009767853),
    Boardcore::TrajectoryPoint(180, 270.541459881593),
    Boardcore::TrajectoryPoint(190, 269.903080568752),
    Boardcore::TrajectoryPoint(200, 269.264830841622),
    Boardcore::TrajectoryPoint(210, 268.626705043751),
    Boardcore::TrajectoryPoint(220, 267.988733562545),
    Boardcore::TrajectoryPoint(230, 267.350877054233),
    Boardcore::TrajectoryPoint(240, 266.713112449189),
    Boardcore::TrajectoryPoint(250, 266.075433788687),
    Boardcore::TrajectoryPoint(260, 265.437857081135),
    Boardcore::TrajectoryPoint(270, 264.800351287738),
    Boardcore::TrajectoryPoint(280, 264.162900342017),
    Boardcore::TrajectoryPoint(290, 263.525498041248),
    Boardcore::TrajectoryPoint(300, 262.888145725147),
    Boardcore::TrajectoryPoint(310, 262.250824639182),
    Boardcore::TrajectoryPoint(320, 261.613521944157),
    Boardcore::TrajectoryPoint(330, 260.976231234593),
    Boardcore::TrajectoryPoint(340, 260.338944511493),
    Boardcore::TrajectoryPoint(350, 259.7016475657),
    Boardcore::TrajectoryPoint(360, 259.064333100185),
    Boardcore::TrajectoryPoint(370, 258.426994534468),
    Boardcore::TrajectoryPoint(380, 257.789624727757),
    Boardcore::TrajectoryPoint(390, 257.152196150674),
    Boardcore::TrajectoryPoint(400, 256.514714618547),
    Boardcore::TrajectoryPoint(410, 255.877173392985),
    Boardcore::TrajectoryPoint(420, 255.239565594608),
    Boardcore::TrajectoryPoint(430, 254.601868841398),
    Boardcore::TrajectoryPoint(440, 253.964069022295),
    Boardcore::TrajectoryPoint(450, 253.326174317198),
    Boardcore::TrajectoryPoint(460, 252.688177710701),
    Boardcore::TrajectoryPoint(470, 252.050072066866),
    Boardcore::TrajectoryPoint(480, 251.411817504991),
    Boardcore::TrajectoryPoint(490, 250.773421847992),
    Boardcore::TrajectoryPoint(500, 250.134889262179),
    Boardcore::TrajectoryPoint(510, 249.496212483119),
    Boardcore::TrajectoryPoint(520, 248.85738413986),
    Boardcore::TrajectoryPoint(530, 248.218355742292),
    Boardcore::TrajectoryPoint(540, 247.579142636247),
    Boardcore::TrajectoryPoint(550, 246.939750367481),
    Boardcore::TrajectoryPoint(560, 246.300171433716),
    Boardcore::TrajectoryPoint(570, 245.660398235265),
    Boardcore::TrajectoryPoint(580, 245.020392230565),
    Boardcore::TrajectoryPoint(590, 244.380142055155),
    Boardcore::TrajectoryPoint(600, 243.739670177296),
    Boardcore::TrajectoryPoint(610, 243.098968855778),
    Boardcore::TrajectoryPoint(620, 242.458030257353),
    Boardcore::TrajectoryPoint(630, 241.816846459236),
    Boardcore::TrajectoryPoint(640, 241.175347035918),
    Boardcore::TrajectoryPoint(650, 240.533576451602),
    Boardcore::TrajectoryPoint(660, 239.891533191328),
    Boardcore::TrajectoryPoint(670, 239.249209175501),
    Boardcore::TrajectoryPoint(680, 238.606596236712),
    Boardcore::TrajectoryPoint(690, 237.963686121181),
    Boardcore::TrajectoryPoint(700, 237.320406078604),
    Boardcore::TrajectoryPoint(710, 236.676800959884),
    Boardcore::TrajectoryPoint(720, 236.032870976607),
    Boardcore::TrajectoryPoint(730, 235.388607696368),
    Boardcore::TrajectoryPoint(740, 234.74400259957),
    Boardcore::TrajectoryPoint(750, 234.099047080104),
    Boardcore::TrajectoryPoint(760, 233.453711057533),
    Boardcore::TrajectoryPoint(770, 232.807953000407),
    Boardcore::TrajectoryPoint(780, 232.161816450171),
    Boardcore::TrajectoryPoint(790, 231.515292596277),
    Boardcore::TrajectoryPoint(800, 230.868372539077),
    Boardcore::TrajectoryPoint(810, 230.221047289949),
    Boardcore::TrajectoryPoint(820, 229.573307771295),
    Boardcore::TrajectoryPoint(830, 228.925144816437),
    Boardcore::TrajectoryPoint(840, 228.276483929584),
    Boardcore::TrajectoryPoint(850, 227.627371630214),
    Boardcore::TrajectoryPoint(860, 226.977806984846),
    Boardcore::TrajectoryPoint(870, 226.327780586437),
    Boardcore::TrajectoryPoint(880, 225.677282934493),
    Boardcore::TrajectoryPoint(890, 225.026304434618),
    Boardcore::TrajectoryPoint(900, 224.374835397973),
    Boardcore::TrajectoryPoint(910, 223.722866040671),
    Boardcore::TrajectoryPoint(920, 223.07037300956),
    Boardcore::TrajectoryPoint(930, 222.417305139694),
    Boardcore::TrajectoryPoint(940, 221.763706925611),
    Boardcore::TrajectoryPoint(950, 221.109568303591),
    Boardcore::TrajectoryPoint(960, 220.454879109434),
    Boardcore::TrajectoryPoint(970, 219.799629077614),
    Boardcore::TrajectoryPoint(980, 219.143807840401),
    Boardcore::TrajectoryPoint(990, 218.487404926911),
    Boardcore::TrajectoryPoint(1000, 217.830409762127),
    Boardcore::TrajectoryPoint(1010, 217.172811665862),
    Boardcore::TrajectoryPoint(1020, 216.514599851687),
    Boardcore::TrajectoryPoint(1030, 215.855763425818),
    Boardcore::TrajectoryPoint(1040, 215.196240568248),
    Boardcore::TrajectoryPoint(1050, 214.536068532117),
    Boardcore::TrajectoryPoint(1060, 213.875239589224),
    Boardcore::TrajectoryPoint(1070, 213.213742503833),
    Boardcore::TrajectoryPoint(1080, 212.551565926313),
    Boardcore::TrajectoryPoint(1090, 211.888698391891),
    Boardcore::TrajectoryPoint(1100, 211.225128319371),
    Boardcore::TrajectoryPoint(1110, 210.560844009826),
    Boardcore::TrajectoryPoint(1120, 209.895833645253),
    Boardcore::TrajectoryPoint(1130, 209.230085287203),
    Boardcore::TrajectoryPoint(1140, 208.563586875383),
    Boardcore::TrajectoryPoint(1150, 207.896326226218),
    Boardcore::TrajectoryPoint(1160, 207.228291031404),
    Boardcore::TrajectoryPoint(1170, 206.559468856415),
    Boardcore::TrajectoryPoint(1180, 205.889847138995),
    Boardcore::TrajectoryPoint(1190, 205.219413187618),
    Boardcore::TrajectoryPoint(1200, 204.548154179922),
    Boardcore::TrajectoryPoint(1210, 203.876057161116),
    Boardcore::TrajectoryPoint(1220, 203.203109042366),
    Boardcore::TrajectoryPoint(1230, 202.529296599142),
    Boardcore::TrajectoryPoint(1240, 201.854606469552),
    Boardcore::TrajectoryPoint(1250, 201.179025152645),
    Boardcore::TrajectoryPoint(1260, 200.502539006677),
    Boardcore::TrajectoryPoint(1270, 199.825134247367),
    Boardcore::TrajectoryPoint(1280, 199.146796946113),
    Boardcore::TrajectoryPoint(1290, 198.467513028181),
    Boardcore::TrajectoryPoint(1300, 197.787268270875),
    Boardcore::TrajectoryPoint(1310, 197.106048301664),
    Boardcore::TrajectoryPoint(1320, 196.423838596292),
    Boardcore::TrajectoryPoint(1330, 195.74062447685),
    Boardcore::TrajectoryPoint(1340, 195.056391109821),
    Boardcore::TrajectoryPoint(1350, 194.371123504096),
    Boardcore::TrajectoryPoint(1360, 193.68480650895),
    Boardcore::TrajectoryPoint(1370, 192.997424811995),
    Boardcore::TrajectoryPoint(1380, 192.308962937093),
    Boardcore::TrajectoryPoint(1390, 191.619405242239),
    Boardcore::TrajectoryPoint(1400, 190.928735917403),
    Boardcore::TrajectoryPoint(1410, 190.236938982345),
    Boardcore::TrajectoryPoint(1420, 189.543998284383),
    Boardcore::TrajectoryPoint(1430, 188.849897496135),
    Boardcore::TrajectoryPoint(1440, 188.154620113211),
    Boardcore::TrajectoryPoint(1450, 187.45814945187),
    Boardcore::TrajectoryPoint(1460, 186.760468646642),
    Boardcore::TrajectoryPoint(1470, 186.061560647898),
    Boardcore::TrajectoryPoint(1480, 185.361408219383),
    Boardcore::TrajectoryPoint(1490, 184.659993037416),
    Boardcore::TrajectoryPoint(1500, 183.957205053242),
    Boardcore::TrajectoryPoint(1510, 183.253113947407),
    Boardcore::TrajectoryPoint(1520, 182.547701583181),
    Boardcore::TrajectoryPoint(1530, 181.840949622648),
    Boardcore::TrajectoryPoint(1540, 181.132839523919),
    Boardcore::TrajectoryPoint(1550, 180.423352538287),
    Boardcore::TrajectoryPoint(1560, 179.71246970734),
    Boardcore::TrajectoryPoint(1570, 179.000171860009),
    Boardcore::TrajectoryPoint(1580, 178.286439609568),
    Boardcore::TrajectoryPoint(1590, 177.571201244468),
    Boardcore::TrajectoryPoint(1600, 176.854388310359),
    Boardcore::TrajectoryPoint(1610, 176.136074229563),
    Boardcore::TrajectoryPoint(1620, 175.416238575109),
    Boardcore::TrajectoryPoint(1630, 174.694860686453),
    Boardcore::TrajectoryPoint(1640, 173.971919666054),
    Boardcore::TrajectoryPoint(1650, 173.247394375898),
    Boardcore::TrajectoryPoint(1660, 172.521211068891),
    Boardcore::TrajectoryPoint(1670, 171.793251368182),
    Boardcore::TrajectoryPoint(1680, 171.063634110549),
    Boardcore::TrajectoryPoint(1690, 170.332336997286),
    Boardcore::TrajectoryPoint(1700, 169.599337468304),
    Boardcore::TrajectoryPoint(1710, 168.86461269815),
    Boardcore::TrajectoryPoint(1720, 168.128026440086),
    Boardcore::TrajectoryPoint(1730, 167.389532233597),
    Boardcore::TrajectoryPoint(1740, 166.649233196697),
    Boardcore::TrajectoryPoint(1750, 165.907105221857),
    Boardcore::TrajectoryPoint(1760, 165.163123912203),
    Boardcore::TrajectoryPoint(1770, 164.417128515084),
    Boardcore::TrajectoryPoint(1780, 163.66907214676),
    Boardcore::TrajectoryPoint(1790, 162.919076987722),
    Boardcore::TrajectoryPoint(1800, 162.167117241657),
    Boardcore::TrajectoryPoint(1810, 161.413149312277),
    Boardcore::TrajectoryPoint(1820, 160.65684890929),
    Boardcore::TrajectoryPoint(1830, 159.898493242508),
    Boardcore::TrajectoryPoint(1840, 159.138055008403),
    Boardcore::TrajectoryPoint(1850, 158.375483880564),
    Boardcore::TrajectoryPoint(1860, 157.610421661776),
    Boardcore::TrajectoryPoint(1870, 156.843180570911),
    Boardcore::TrajectoryPoint(1880, 156.073731677912),
    Boardcore::TrajectoryPoint(1890, 155.301876933807),
    Boardcore::TrajectoryPoint(1900, 154.527501595479),
    Boardcore::TrajectoryPoint(1910, 153.750816070208),
    Boardcore::TrajectoryPoint(1920, 152.971775453036),
    Boardcore::TrajectoryPoint(1930, 152.189917122436),
    Boardcore::TrajectoryPoint(1940, 151.405641118022),
    Boardcore::TrajectoryPoint(1950, 150.618915270668),
    Boardcore::TrajectoryPoint(1960, 149.829263317837),
    Boardcore::TrajectoryPoint(1970, 149.037024173956),
    Boardcore::TrajectoryPoint(1980, 148.242220685484),
    Boardcore::TrajectoryPoint(1990, 147.444309314419),
    Boardcore::TrajectoryPoint(2000, 146.643714300804),
    Boardcore::TrajectoryPoint(2010, 145.840343474125),
    Boardcore::TrajectoryPoint(2020, 145.033752661472),
    Boardcore::TrajectoryPoint(2030, 144.224387606756),
    Boardcore::TrajectoryPoint(2040, 143.411880758213),
    Boardcore::TrajectoryPoint(2050, 142.596214345065),
    Boardcore::TrajectoryPoint(2060, 141.777622726485),
    Boardcore::TrajectoryPoint(2070, 140.955429932081),
    Boardcore::TrajectoryPoint(2080, 140.130233335582),
    Boardcore::TrajectoryPoint(2090, 139.301527138786),
    Boardcore::TrajectoryPoint(2100, 138.469467824746),
    Boardcore::TrajectoryPoint(2110, 137.63397512191),
    Boardcore::TrajectoryPoint(2120, 136.794804640574),
    Boardcore::TrajectoryPoint(2130, 135.952218134131),
    Boardcore::TrajectoryPoint(2140, 135.105677364355),
    Boardcore::TrajectoryPoint(2150, 134.255674139599),
    Boardcore::TrajectoryPoint(2160, 133.401492702061),
    Boardcore::TrajectoryPoint(2170, 132.543733327262),
    Boardcore::TrajectoryPoint(2180, 131.681628955914),
    Boardcore::TrajectoryPoint(2190, 130.815756513773),
    Boardcore::TrajectoryPoint(2200, 129.945434382206),
    Boardcore::TrajectoryPoint(2210, 129.071073426964),
    Boardcore::TrajectoryPoint(2220, 128.192225426046),
    Boardcore::TrajectoryPoint(2230, 127.308980860037),
    Boardcore::TrajectoryPoint(2240, 126.421284822836),
    Boardcore::TrajectoryPoint(2250, 125.528740685608),
    Boardcore::TrajectoryPoint(2260, 124.631760178159),
    Boardcore::TrajectoryPoint(2270, 123.729577717736),
    Boardcore::TrajectoryPoint(2280, 122.822612640028),
    Boardcore::TrajectoryPoint(2290, 121.910677408815),
    Boardcore::TrajectoryPoint(2300, 120.993251606328),
    Boardcore::TrajectoryPoint(2310, 120.070739980154),
    Boardcore::TrajectoryPoint(2320, 119.142794617113),
    Boardcore::TrajectoryPoint(2330, 118.209034000539),
    Boardcore::TrajectoryPoint(2340, 117.269745449757),
    Boardcore::TrajectoryPoint(2350, 116.3247562134),
    Boardcore::TrajectoryPoint(2360, 115.37335796642),
    Boardcore::TrajectoryPoint(2370, 114.415945605464),
    Boardcore::TrajectoryPoint(2380, 113.452340077321),
    Boardcore::TrajectoryPoint(2390, 112.482329342192),
    Boardcore::TrajectoryPoint(2400, 111.505316368198),
    Boardcore::TrajectoryPoint(2410, 110.521555400252),
    Boardcore::TrajectoryPoint(2420, 109.53084042826),
    Boardcore::TrajectoryPoint(2430, 108.532957513041),
    Boardcore::TrajectoryPoint(2440, 107.527684417128),
    Boardcore::TrajectoryPoint(2450, 106.514672061172),
    Boardcore::TrajectoryPoint(2460, 105.493659456168),
    Boardcore::TrajectoryPoint(2470, 104.464572505244),
    Boardcore::TrajectoryPoint(2480, 103.427154124222),
    Boardcore::TrajectoryPoint(2490, 102.381136879615),
    Boardcore::TrajectoryPoint(2500, 101.326242477178),
    Boardcore::TrajectoryPoint(2510, 100.262181219358),
    Boardcore::TrajectoryPoint(2520, 99.188651429437),
    Boardcore::TrajectoryPoint(2530, 98.1053388399875),
    Boardcore::TrajectoryPoint(2540, 97.011915943065),
    Boardcore::TrajectoryPoint(2550, 95.90804129934),
    Boardcore::TrajectoryPoint(2560, 94.7933588031366),
    Boardcore::TrajectoryPoint(2570, 93.667496900084),
    Boardcore::TrajectoryPoint(2580, 92.5298634287462),
    Boardcore::TrajectoryPoint(2590, 91.3800023031899),
    Boardcore::TrajectoryPoint(2600, 90.2176621444341),
    Boardcore::TrajectoryPoint(2610, 89.0423952479819),
    Boardcore::TrajectoryPoint(2620, 87.8537333401396),
    Boardcore::TrajectoryPoint(2630, 86.6505197027341),
    Boardcore::TrajectoryPoint(2640, 85.4326610815574),
    Boardcore::TrajectoryPoint(2650, 84.1997512483907),
    Boardcore::TrajectoryPoint(2660, 82.9503049285517),
    Boardcore::TrajectoryPoint(2670, 81.6842882121695),
    Boardcore::TrajectoryPoint(2680, 80.4006411828351),
    Boardcore::TrajectoryPoint(2690, 79.0984345629604),
    Boardcore::TrajectoryPoint(2700, 77.7768622213095),
    Boardcore::TrajectoryPoint(2710, 76.4349894735997),
    Boardcore::TrajectoryPoint(2720, 75.0712468234658),
    Boardcore::TrajectoryPoint(2730, 73.6851384429187),
    Boardcore::TrajectoryPoint(2740, 72.2750037557723),
    Boardcore::TrajectoryPoint(2750, 70.838998761511),
    Boardcore::TrajectoryPoint(2760, 69.3760732830648),
    Boardcore::TrajectoryPoint(2770, 67.8843926531344),
    Boardcore::TrajectoryPoint(2780, 66.3619559996121),
    Boardcore::TrajectoryPoint(2790, 64.8065771907215),
    Boardcore::TrajectoryPoint(2800, 63.2158630897261),
    Boardcore::TrajectoryPoint(2810, 61.5871886653091),
    Boardcore::TrajectoryPoint(2820, 59.9170748490247),
    Boardcore::TrajectoryPoint(2830, 58.2019290168584),
    Boardcore::TrajectoryPoint(2840, 56.4386373844991),
    Boardcore::TrajectoryPoint(2850, 54.6208087596807),
    Boardcore::TrajectoryPoint(2860, 52.7442934900191),
    Boardcore::TrajectoryPoint(2870, 50.8022026792441),
    Boardcore::TrajectoryPoint(2880, 48.7864061507648),
    Boardcore::TrajectoryPoint(2890, 46.6873921543481),
    Boardcore::TrajectoryPoint(2900, 44.4939622687062),
    Boardcore::TrajectoryPoint(2910, 42.1904574124914),
    Boardcore::TrajectoryPoint(2920, 39.7586668658056),
    Boardcore::TrajectoryPoint(2930, 37.1728206004607),
    Boardcore::TrajectoryPoint(2940, 34.3991905768554),
    Boardcore::TrajectoryPoint(2950, 31.3864211618553),
    Boardcore::TrajectoryPoint(2960, 28.0591006205685),
    Boardcore::TrajectoryPoint(2970, 24.2867972519451),
    Boardcore::TrajectoryPoint(2980, 19.8194837404145),
    Boardcore::TrajectoryPoint(2990, 14.0060019872665),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t8_closed[] = {
    Boardcore::TrajectoryPoint(0, 281.771482344826),
    Boardcore::TrajectoryPoint(10, 281.13000405443),
    Boardcore::TrajectoryPoint(20, 280.489158984282),
    Boardcore::TrajectoryPoint(30, 279.848750029463),
    Boardcore::TrajectoryPoint(40, 279.20868357843),
    Boardcore::TrajectoryPoint(50, 278.568891734737),
    Boardcore::TrajectoryPoint(60, 277.929395125752),
    Boardcore::TrajectoryPoint(70, 277.290287465707),
    Boardcore::TrajectoryPoint(80, 276.65141836336),
    Boardcore::TrajectoryPoint(90, 276.01278343011),
    Boardcore::TrajectoryPoint(100, 275.374447607376),
    Boardcore::TrajectoryPoint(110, 274.736376790422),
    Boardcore::TrajectoryPoint(120, 274.098505199061),
    Boardcore::TrajectoryPoint(130, 273.460827864932),
    Boardcore::TrajectoryPoint(140, 272.823422744764),
    Boardcore::TrajectoryPoint(150, 272.186196788848),
    Boardcore::TrajectoryPoint(160, 271.549131245321),
    Boardcore::TrajectoryPoint(170, 270.912228300694),
    Boardcore::TrajectoryPoint(180, 270.275535289173),
    Boardcore::TrajectoryPoint(190, 269.638969959909),
    Boardcore::TrajectoryPoint(200, 269.002526839688),
    Boardcore::TrajectoryPoint(210, 268.366212359948),
    Boardcore::TrajectoryPoint(220, 267.730040173731),
    Boardcore::TrajectoryPoint(230, 267.093958436273),
    Boardcore::TrajectoryPoint(240, 266.457961350731),
    Boardcore::TrajectoryPoint(250, 265.822050997709),
    Boardcore::TrajectoryPoint(260, 265.186228621258),
    Boardcore::TrajectoryPoint(270, 264.550460039313),
    Boardcore::TrajectoryPoint(280, 263.914739193518),
    Boardcore::TrajectoryPoint(290, 263.279061990578),
    Boardcore::TrajectoryPoint(300, 262.643424394383),
    Boardcore::TrajectoryPoint(310, 262.007804499629),
    Boardcore::TrajectoryPoint(320, 261.372196030975),
    Boardcore::TrajectoryPoint(330, 260.736592527782),
    Boardcore::TrajectoryPoint(340, 260.100980212596),
    Boardcore::TrajectoryPoint(350, 259.465349861851),
    Boardcore::TrajectoryPoint(360, 258.82969517455),
    Boardcore::TrajectoryPoint(370, 258.194009526492),
    Boardcore::TrajectoryPoint(380, 257.558274350792),
    Boardcore::TrajectoryPoint(390, 256.922479083705),
    Boardcore::TrajectoryPoint(400, 256.28662419016),
    Boardcore::TrajectoryPoint(410, 255.65070289692),
    Boardcore::TrajectoryPoint(420, 255.014707426468),
    Boardcore::TrajectoryPoint(430, 254.378596833104),
    Boardcore::TrajectoryPoint(440, 253.742391710102),
    Boardcore::TrajectoryPoint(450, 253.106085141893),
    Boardcore::TrajectoryPoint(460, 252.469670089778),
    Boardcore::TrajectoryPoint(470, 251.833126482457),
    Boardcore::TrajectoryPoint(480, 251.196424447798),
    Boardcore::TrajectoryPoint(490, 250.559586216157),
    Boardcore::TrajectoryPoint(500, 249.922604616255),
    Boardcore::TrajectoryPoint(510, 249.285472368451),
    Boardcore::TrajectoryPoint(520, 248.648164409519),
    Boardcore::TrajectoryPoint(530, 248.010650764962),
    Boardcore::TrajectoryPoint(540, 247.372959052008),
    Boardcore::TrajectoryPoint(550, 246.735081857406),
    Boardcore::TrajectoryPoint(560, 246.097011669272),
    Boardcore::TrajectoryPoint(570, 245.458735553656),
    Boardcore::TrajectoryPoint(580, 244.820192120395),
    Boardcore::TrajectoryPoint(590, 244.181428437042),
    Boardcore::TrajectoryPoint(600, 243.542436849363),
    Boardcore::TrajectoryPoint(610, 242.903209610373),
    Boardcore::TrajectoryPoint(620, 242.263738882953),
    Boardcore::TrajectoryPoint(630, 241.623981324956),
    Boardcore::TrajectoryPoint(640, 240.983928044527),
    Boardcore::TrajectoryPoint(650, 240.343603987541),
    Boardcore::TrajectoryPoint(660, 239.703001160721),
    Boardcore::TrajectoryPoint(670, 239.062111482778),
    Boardcore::TrajectoryPoint(680, 238.42092678595),
    Boardcore::TrajectoryPoint(690, 237.779400990896),
    Boardcore::TrajectoryPoint(700, 237.137526079163),
    Boardcore::TrajectoryPoint(710, 236.495328659281),
    Boardcore::TrajectoryPoint(720, 235.852800386641),
    Boardcore::TrajectoryPoint(730, 235.209932829655),
    Boardcore::TrajectoryPoint(740, 234.566717470503),
    Boardcore::TrajectoryPoint(750, 233.923145705732),
    Boardcore::TrajectoryPoint(760, 233.279136201375),
    Boardcore::TrajectoryPoint(770, 232.634748044385),
    Boardcore::TrajectoryPoint(780, 231.989975506711),
    Boardcore::TrajectoryPoint(790, 231.344809780167),
    Boardcore::TrajectoryPoint(800, 230.699241968176),
    Boardcore::TrajectoryPoint(810, 230.053263085831),
    Boardcore::TrajectoryPoint(820, 229.406864059841),
    Boardcore::TrajectoryPoint(830, 228.759990021499),
    Boardcore::TrajectoryPoint(840, 228.112647993824),
    Boardcore::TrajectoryPoint(850, 227.464857144561),
    Boardcore::TrajectoryPoint(860, 226.816608163622),
    Boardcore::TrajectoryPoint(870, 226.167891648342),
    Boardcore::TrajectoryPoint(880, 225.518698103064),
    Boardcore::TrajectoryPoint(890, 224.869017938647),
    Boardcore::TrajectoryPoint(900, 224.218841471899),
    Boardcore::TrajectoryPoint(910, 223.568156920375),
    Boardcore::TrajectoryPoint(920, 222.916889340309),
    Boardcore::TrajectoryPoint(930, 222.265095689332),
    Boardcore::TrajectoryPoint(940, 221.612766008645),
    Boardcore::TrajectoryPoint(950, 220.959890240091),
    Boardcore::TrajectoryPoint(960, 220.306458225347),
    Boardcore::TrajectoryPoint(970, 219.65245970507),
    Boardcore::TrajectoryPoint(980, 218.99788431799),
    Boardcore::TrajectoryPoint(990, 218.342721599949),
    Boardcore::TrajectoryPoint(1000, 217.686960982897),
    Boardcore::TrajectoryPoint(1010, 217.030591793855),
    Boardcore::TrajectoryPoint(1020, 216.373602421929),
    Boardcore::TrajectoryPoint(1030, 215.715927882356),
    Boardcore::TrajectoryPoint(1040, 215.057612995698),
    Boardcore::TrajectoryPoint(1050, 214.398646757285),
    Boardcore::TrajectoryPoint(1060, 213.739018051165),
    Boardcore::TrajectoryPoint(1070, 213.078715648913),
    Boardcore::TrajectoryPoint(1080, 212.417728208411),
    Boardcore::TrajectoryPoint(1090, 211.756044272594),
    Boardcore::TrajectoryPoint(1100, 211.093652268162),
    Boardcore::TrajectoryPoint(1110, 210.430540504261),
    Boardcore::TrajectoryPoint(1120, 209.766697171135),
    Boardcore::TrajectoryPoint(1130, 209.10211033875),
    Boardcore::TrajectoryPoint(1140, 208.436767955384),
    Boardcore::TrajectoryPoint(1150, 207.770657846196),
    Boardcore::TrajectoryPoint(1160, 207.103767711759),
    Boardcore::TrajectoryPoint(1170, 206.436085126575),
    Boardcore::TrajectoryPoint(1180, 205.767597537559),
    Boardcore::TrajectoryPoint(1190, 205.09829226249),
    Boardcore::TrajectoryPoint(1200, 204.42815648845),
    Boardcore::TrajectoryPoint(1210, 203.757177270222),
    Boardcore::TrajectoryPoint(1220, 203.085341528674),
    Boardcore::TrajectoryPoint(1230, 202.412636049105),
    Boardcore::TrajectoryPoint(1240, 201.739047479573),
    Boardcore::TrajectoryPoint(1250, 201.064562329195),
    Boardcore::TrajectoryPoint(1260, 200.389166966418),
    Boardcore::TrajectoryPoint(1270, 199.712847617261),
    Boardcore::TrajectoryPoint(1280, 199.035590363536),
    Boardcore::TrajectoryPoint(1290, 198.357381141036),
    Boardcore::TrajectoryPoint(1300, 197.678205737694),
    Boardcore::TrajectoryPoint(1310, 196.998049791718),
    Boardcore::TrajectoryPoint(1320, 196.31689878969),
    Boardcore::TrajectoryPoint(1330, 195.634738064643),
    Boardcore::TrajectoryPoint(1340, 194.951552794099),
    Boardcore::TrajectoryPoint(1350, 194.267327998083),
    Boardcore::TrajectoryPoint(1360, 193.5820485371),
    Boardcore::TrajectoryPoint(1370, 192.895699110082),
    Boardcore::TrajectoryPoint(1380, 192.208264252301),
    Boardcore::TrajectoryPoint(1390, 191.519728333246),
    Boardcore::TrajectoryPoint(1400, 190.83007555447),
    Boardcore::TrajectoryPoint(1410, 190.139289947394),
    Boardcore::TrajectoryPoint(1420, 189.44735537108),
    Boardcore::TrajectoryPoint(1430, 188.754255509964),
    Boardcore::TrajectoryPoint(1440, 188.059973871551),
    Boardcore::TrajectoryPoint(1450, 187.364493784067),
    Boardcore::TrajectoryPoint(1460, 186.667798394076),
    Boardcore::TrajectoryPoint(1470, 185.969870664053),
    Boardcore::TrajectoryPoint(1480, 185.270693369911),
    Boardcore::TrajectoryPoint(1490, 184.570249098489),
    Boardcore::TrajectoryPoint(1500, 183.868484178741),
    Boardcore::TrajectoryPoint(1510, 183.165352356628),
    Boardcore::TrajectoryPoint(1520, 182.460894176936),
    Boardcore::TrajectoryPoint(1530, 181.755091314506),
    Boardcore::TrajectoryPoint(1540, 181.047925240246),
    Boardcore::TrajectoryPoint(1550, 180.33937721829),
    Boardcore::TrajectoryPoint(1560, 179.629428303096),
    Boardcore::TrajectoryPoint(1570, 178.918059336506),
    Boardcore::TrajectoryPoint(1580, 178.205250944732),
    Boardcore::TrajectoryPoint(1590, 177.490983535294),
    Boardcore::TrajectoryPoint(1600, 176.775089258323),
    Boardcore::TrajectoryPoint(1610, 176.057683363359),
    Boardcore::TrajectoryPoint(1620, 175.338750913856),
    Boardcore::TrajectoryPoint(1630, 174.618271262561),
    Boardcore::TrajectoryPoint(1640, 173.896223525239),
    Boardcore::TrajectoryPoint(1650, 173.172586577185),
    Boardcore::TrajectoryPoint(1660, 172.447339049672),
    Boardcore::TrajectoryPoint(1670, 171.720260751006),
    Boardcore::TrajectoryPoint(1680, 170.991516305509),
    Boardcore::TrajectoryPoint(1690, 170.261087107845),
    Boardcore::TrajectoryPoint(1700, 169.52895061143),
    Boardcore::TrajectoryPoint(1710, 168.795084004303),
    Boardcore::TrajectoryPoint(1720, 168.059405462504),
    Boardcore::TrajectoryPoint(1730, 167.321758862347),
    Boardcore::TrajectoryPoint(1740, 166.582302595126),
    Boardcore::TrajectoryPoint(1750, 165.841012566895),
    Boardcore::TrajectoryPoint(1760, 165.097864394335),
    Boardcore::TrajectoryPoint(1770, 164.352750359328),
    Boardcore::TrajectoryPoint(1780, 163.605516629287),
    Boardcore::TrajectoryPoint(1790, 162.856339333164),
    Boardcore::TrajectoryPoint(1800, 162.105192688207),
    Boardcore::TrajectoryPoint(1810, 161.352050595274),
    Boardcore::TrajectoryPoint(1820, 160.596587485939),
    Boardcore::TrajectoryPoint(1830, 159.839029740891),
    Boardcore::TrajectoryPoint(1840, 159.079384715182),
    Boardcore::TrajectoryPoint(1850, 158.317624777593),
    Boardcore::TrajectoryPoint(1860, 157.553373592098),
    Boardcore::TrajectoryPoint(1870, 156.786910631991),
    Boardcore::TrajectoryPoint(1880, 156.018235205287),
    Boardcore::TrajectoryPoint(1890, 155.24719865965),
    Boardcore::TrajectoryPoint(1900, 154.473586445791),
    Boardcore::TrajectoryPoint(1910, 153.697659416291),
    Boardcore::TrajectoryPoint(1920, 152.91938689556),
    Boardcore::TrajectoryPoint(1930, 152.138311212409),
    Boardcore::TrajectoryPoint(1940, 151.354778808553),
    Boardcore::TrajectoryPoint(1950, 150.568791982041),
    Boardcore::TrajectoryPoint(1960, 149.779921137515),
    Boardcore::TrajectoryPoint(1970, 148.98841077722),
    Boardcore::TrajectoryPoint(1980, 148.194331528394),
    Boardcore::TrajectoryPoint(1990, 147.397185414501),
    Boardcore::TrajectoryPoint(2000, 146.597304448029),
    Boardcore::TrajectoryPoint(2010, 145.794688605869),
    Boardcore::TrajectoryPoint(2020, 144.988801671518),
    Boardcore::TrajectoryPoint(2030, 144.180136009744),
    Boardcore::TrajectoryPoint(2040, 143.368368130016),
    Boardcore::TrajectoryPoint(2050, 142.553390989117),
    Boardcore::TrajectoryPoint(2060, 141.735503605907),
    Boardcore::TrajectoryPoint(2070, 140.914014291154),
    Boardcore::TrajectoryPoint(2080, 140.089492445434),
    Boardcore::TrajectoryPoint(2090, 139.261498643923),
    Boardcore::TrajectoryPoint(2100, 138.430104036809),
    Boardcore::TrajectoryPoint(2110, 137.595313167915),
    Boardcore::TrajectoryPoint(2120, 136.756797378119),
    Boardcore::TrajectoryPoint(2130, 135.914902085693),
    Boardcore::TrajectoryPoint(2140, 135.069006021318),
    Boardcore::TrajectoryPoint(2150, 134.219683336897),
    Boardcore::TrajectoryPoint(2160, 133.366136648524),
    Boardcore::TrajectoryPoint(2170, 132.509047091087),
    Boardcore::TrajectoryPoint(2180, 131.647567543119),
    Boardcore::TrajectoryPoint(2190, 130.782354150215),
    Boardcore::TrajectoryPoint(2200, 129.912646947134),
    Boardcore::TrajectoryPoint(2210, 129.038934231694),
    Boardcore::TrajectoryPoint(2220, 128.160691295613),
    Boardcore::TrajectoryPoint(2230, 127.278084122215),
    Boardcore::TrajectoryPoint(2240, 126.390983317723),
    Boardcore::TrajectoryPoint(2250, 125.499065691461),
    Boardcore::TrajectoryPoint(2260, 124.602706342967),
    Boardcore::TrajectoryPoint(2270, 123.701103753835),
    Boardcore::TrajectoryPoint(2280, 122.794748882283),
    Boardcore::TrajectoryPoint(2290, 121.883383765078),
    Boardcore::TrajectoryPoint(2300, 120.966557189759),
    Boardcore::TrajectoryPoint(2310, 120.044639324875),
    Boardcore::TrajectoryPoint(2320, 119.117248814086),
    Boardcore::TrajectoryPoint(2330, 118.184070922664),
    Boardcore::TrajectoryPoint(2340, 117.245359564051),
    Boardcore::TrajectoryPoint(2350, 116.300909976994),
    Boardcore::TrajectoryPoint(2360, 115.350077836798),
    Boardcore::TrajectoryPoint(2370, 114.39322598888),
    Boardcore::TrajectoryPoint(2380, 113.430175350353),
    Boardcore::TrajectoryPoint(2390, 112.460683618196),
    Boardcore::TrajectoryPoint(2400, 111.484214381006),
    Boardcore::TrajectoryPoint(2410, 110.500991473897),
    Boardcore::TrajectoryPoint(2420, 109.510808860573),
    Boardcore::TrajectoryPoint(2430, 108.513452576643),
    Boardcore::TrajectoryPoint(2440, 107.508700360384),
    Boardcore::TrajectoryPoint(2450, 106.496175506273),
    Boardcore::TrajectoryPoint(2460, 105.475672535116),
    Boardcore::TrajectoryPoint(2470, 104.447089425274),
    Boardcore::TrajectoryPoint(2480, 103.410169071211),
    Boardcore::TrajectoryPoint(2490, 102.364644018921),
    Boardcore::TrajectoryPoint(2500, 101.310235954449),
    Boardcore::TrajectoryPoint(2510, 100.246655161323),
    Boardcore::TrajectoryPoint(2520, 99.1735999446704),
    Boardcore::TrajectoryPoint(2530, 98.0907560196534),
    Boardcore::TrajectoryPoint(2540, 96.9977958616439),
    Boardcore::TrajectoryPoint(2550, 95.894378015335),
    Boardcore::TrajectoryPoint(2560, 94.7801463597611),
    Boardcore::TrajectoryPoint(2570, 93.6547293259324),
    Boardcore::TrajectoryPoint(2580, 92.5175562234792),
    Boardcore::TrajectoryPoint(2590, 91.3681273609194),
    Boardcore::TrajectoryPoint(2600, 90.2062134345759),
    Boardcore::TrajectoryPoint(2610, 89.0313667282928),
    Boardcore::TrajectoryPoint(2620, 87.8431189572952),
    Boardcore::TrajectoryPoint(2630, 86.6403323857333),
    Boardcore::TrajectoryPoint(2640, 85.4228750352748),
    Boardcore::TrajectoryPoint(2650, 84.1903603727642),
    Boardcore::TrajectoryPoint(2660, 82.9413206248785),
    Boardcore::TrajectoryPoint(2670, 81.6756860623371),
    Boardcore::TrajectoryPoint(2680, 80.3924316740138),
    Boardcore::TrajectoryPoint(2690, 79.0905940865458),
    Boardcore::TrajectoryPoint(2700, 77.769400231924),
    Boardcore::TrajectoryPoint(2710, 76.42788329961),
    Boardcore::TrajectoryPoint(2720, 75.064504774529),
    Boardcore::TrajectoryPoint(2730, 73.6787531169329),
    Boardcore::TrajectoryPoint(2740, 72.2689537866143),
    Boardcore::TrajectoryPoint(2750, 70.8332908325746),
    Boardcore::TrajectoryPoint(2760, 69.3706997841184),
    Boardcore::TrajectoryPoint(2770, 67.8793458950896),
    Boardcore::TrajectoryPoint(2780, 66.3572282171097),
    Boardcore::TrajectoryPoint(2790, 64.8021605444925),
    Boardcore::TrajectoryPoint(2800, 63.2117496687097),
    Boardcore::TrajectoryPoint(2810, 61.5833704885063),
    Boardcore::TrajectoryPoint(2820, 59.9135536165548),
    Boardcore::TrajectoryPoint(2830, 58.1986861815402),
    Boardcore::TrajectoryPoint(2840, 56.4356735109307),
    Boardcore::TrajectoryPoint(2850, 54.6181060230206),
    Boardcore::TrajectoryPoint(2860, 52.7418511291891),
    Boardcore::TrajectoryPoint(2870, 50.800010945519),
    Boardcore::TrajectoryPoint(2880, 48.7844550915996),
    Boardcore::TrajectoryPoint(2890, 46.6856716144605),
    Boardcore::TrajectoryPoint(2900, 44.4924618891928),
    Boardcore::TrajectoryPoint(2910, 42.1891716099233),
    Boardcore::TrajectoryPoint(2920, 39.7575835813583),
    Boardcore::TrajectoryPoint(2930, 37.1719273296862),
    Boardcore::TrajectoryPoint(2940, 34.3984778048424),
    Boardcore::TrajectoryPoint(2950, 31.385874073696),
    Boardcore::TrajectoryPoint(2960, 28.0587035400146),
    Boardcore::TrajectoryPoint(2970, 24.286536758414),
    Boardcore::TrajectoryPoint(2980, 19.819339805515),
    Boardcore::TrajectoryPoint(2990, 14.0059503626941),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t9_closed[] = {
    Boardcore::TrajectoryPoint(0, 281.47521101612),
    Boardcore::TrajectoryPoint(10, 280.835686314498),
    Boardcore::TrajectoryPoint(20, 280.196860974699),
    Boardcore::TrajectoryPoint(30, 279.558474608994),
    Boardcore::TrajectoryPoint(40, 278.92035898225),
    Boardcore::TrajectoryPoint(50, 278.282510184423),
    Boardcore::TrajectoryPoint(60, 277.64502498524),
    Boardcore::TrajectoryPoint(70, 277.007829624695),
    Boardcore::TrajectoryPoint(80, 276.370865272555),
    Boardcore::TrajectoryPoint(90, 275.734135735882),
    Boardcore::TrajectoryPoint(100, 275.097736734976),
    Boardcore::TrajectoryPoint(110, 274.461534176356),
    Boardcore::TrajectoryPoint(120, 273.825523324589),
    Boardcore::TrajectoryPoint(130, 273.189736567435),
    Boardcore::TrajectoryPoint(140, 272.554178569102),
    Boardcore::TrajectoryPoint(150, 271.918778760552),
    Boardcore::TrajectoryPoint(160, 271.283531926715),
    Boardcore::TrajectoryPoint(170, 270.648475997908),
    Boardcore::TrajectoryPoint(180, 270.01357607152),
    Boardcore::TrajectoryPoint(190, 269.378796622392),
    Boardcore::TrajectoryPoint(200, 268.744132059298),
    Boardcore::TrajectoryPoint(210, 268.109611839466),
    Boardcore::TrajectoryPoint(220, 267.475194101503),
    Boardcore::TrajectoryPoint(230, 266.84085971797),
    Boardcore::TrajectoryPoint(240, 266.20660279894),
    Boardcore::TrajectoryPoint(250, 265.572437898527),
    Boardcore::TrajectoryPoint(260, 264.938332945851),
    Boardcore::TrajectoryPoint(270, 264.304274820915),
    Boardcore::TrajectoryPoint(280, 263.670257391823),
    Boardcore::TrajectoryPoint(290, 263.036280312455),
    Boardcore::TrajectoryPoint(300, 262.402324620561),
    Boardcore::TrajectoryPoint(310, 261.768379799769),
    Boardcore::TrajectoryPoint(320, 261.134439516488),
    Boardcore::TrajectoryPoint(330, 260.500494038894),
    Boardcore::TrajectoryPoint(340, 259.866529343324),
    Boardcore::TrajectoryPoint(350, 259.232540082065),
    Boardcore::TrajectoryPoint(360, 258.598519747029),
    Boardcore::TrajectoryPoint(370, 257.964459514576),
    Boardcore::TrajectoryPoint(380, 257.330332189033),
    Boardcore::TrajectoryPoint(390, 256.696145313094),
    Boardcore::TrajectoryPoint(400, 256.061892221021),
    Boardcore::TrajectoryPoint(410, 255.427566108346),
    Boardcore::TrajectoryPoint(420, 254.793139933809),
    Boardcore::TrajectoryPoint(430, 254.158606211703),
    Boardcore::TrajectoryPoint(440, 253.523971511687),
    Boardcore::TrajectoryPoint(450, 252.8892288932),
    Boardcore::TrajectoryPoint(460, 252.254371296934),
    Boardcore::TrajectoryPoint(470, 251.61935162136),
    Boardcore::TrajectoryPoint(480, 250.984189700364),
    Boardcore::TrajectoryPoint(490, 250.34888524774),
    Boardcore::TrajectoryPoint(500, 249.713431075671),
    Boardcore::TrajectoryPoint(510, 249.077819891306),
    Boardcore::TrajectoryPoint(520, 248.441993642934),
    Boardcore::TrajectoryPoint(530, 247.805984570652),
    Boardcore::TrajectoryPoint(540, 247.16979121101),
    Boardcore::TrajectoryPoint(550, 246.533406140108),
    Boardcore::TrajectoryPoint(560, 245.896821837948),
    Boardcore::TrajectoryPoint(570, 245.25998792187),
    Boardcore::TrajectoryPoint(580, 244.622914633017),
    Boardcore::TrajectoryPoint(590, 243.985614988326),
    Boardcore::TrajectoryPoint(600, 243.348081326973),
    Boardcore::TrajectoryPoint(610, 242.710305897331),
    Boardcore::TrajectoryPoint(620, 242.07227305645),
    Boardcore::TrajectoryPoint(630, 241.433919378391),
    Boardcore::TrajectoryPoint(640, 240.795296829625),
    Boardcore::TrajectoryPoint(650, 240.156397502848),
    Boardcore::TrajectoryPoint(660, 239.517213402482),
    Boardcore::TrajectoryPoint(670, 238.877736446316),
    Boardcore::TrajectoryPoint(680, 238.23794804595),
    Boardcore::TrajectoryPoint(690, 237.597785721558),
    Boardcore::TrajectoryPoint(700, 236.957303247812),
    Boardcore::TrajectoryPoint(710, 236.316492367293),
    Boardcore::TrajectoryPoint(720, 235.675344735752),
    Boardcore::TrajectoryPoint(730, 235.033851922942),
    Boardcore::TrajectoryPoint(740, 234.392005413292),
    Boardcore::TrajectoryPoint(750, 233.749749294065),
    Boardcore::TrajectoryPoint(760, 233.107091958542),
    Boardcore::TrajectoryPoint(770, 232.46405316169),
    Boardcore::TrajectoryPoint(780, 231.820624185904),
    Boardcore::TrajectoryPoint(790, 231.176796225727),
    Boardcore::TrajectoryPoint(800, 230.53256038797),
    Boardcore::TrajectoryPoint(810, 229.887907691725),
    Boardcore::TrajectoryPoint(820, 229.242804185279),
    Boardcore::TrajectoryPoint(830, 228.597214856366),
    Boardcore::TrajectoryPoint(840, 227.951180219284),
    Boardcore::TrajectoryPoint(850, 227.304691059799),
    Boardcore::TrajectoryPoint(860, 226.65773807193),
    Boardcore::TrajectoryPoint(870, 226.010311857583),
    Boardcore::TrajectoryPoint(880, 225.362402926104),
    Boardcore::TrajectoryPoint(890, 224.714001693747),
    Boardcore::TrajectoryPoint(900, 224.065098483082),
    Boardcore::TrajectoryPoint(910, 223.415624578203),
    Boardcore::TrajectoryPoint(920, 222.7656178201),
    Boardcore::TrajectoryPoint(930, 222.115079388397),
    Boardcore::TrajectoryPoint(940, 221.463999329625),
    Boardcore::TrajectoryPoint(950, 220.812367591276),
    Boardcore::TrajectoryPoint(960, 220.160174020983),
    Boardcore::TrajectoryPoint(970, 219.50740836564),
    Boardcore::TrajectoryPoint(980, 218.854060270478),
    Boardcore::TrajectoryPoint(990, 218.20011927809),
    Boardcore::TrajectoryPoint(1000, 217.545574827415),
    Boardcore::TrajectoryPoint(1010, 216.89041320096),
    Boardcore::TrajectoryPoint(1020, 216.234572465808),
    Boardcore::TrajectoryPoint(1030, 215.578096783635),
    Boardcore::TrajectoryPoint(1040, 214.920975266562),
    Boardcore::TrajectoryPoint(1050, 214.263196916795),
    Boardcore::TrajectoryPoint(1060, 213.60475062547),
    Boardcore::TrajectoryPoint(1070, 212.945625171455),
    Boardcore::TrajectoryPoint(1080, 212.285809220118),
    Boardcore::TrajectoryPoint(1090, 211.625291322066),
    Boardcore::TrajectoryPoint(1100, 210.964059911847),
    Boardcore::TrajectoryPoint(1110, 210.30210330663),
    Boardcore::TrajectoryPoint(1120, 209.639409704846),
    Boardcore::TrajectoryPoint(1130, 208.975967184804),
    Boardcore::TrajectoryPoint(1140, 208.311763703284),
    Boardcore::TrajectoryPoint(1150, 207.646787094091),
    Boardcore::TrajectoryPoint(1160, 206.981025066593),
    Boardcore::TrajectoryPoint(1170, 206.314465204226),
    Boardcore::TrajectoryPoint(1180, 205.647094962973),
    Boardcore::TrajectoryPoint(1190, 204.978901669818),
    Boardcore::TrajectoryPoint(1200, 204.309872521174),
    Boardcore::TrajectoryPoint(1210, 203.639994581285),
    Boardcore::TrajectoryPoint(1220, 202.969254780599),
    Boardcore::TrajectoryPoint(1230, 202.297634715273),
    Boardcore::TrajectoryPoint(1240, 201.625122508407),
    Boardcore::TrajectoryPoint(1250, 200.951711320722),
    Boardcore::TrajectoryPoint(1260, 200.277387631586),
    Boardcore::TrajectoryPoint(1270, 199.602137778614),
    Boardcore::TrajectoryPoint(1280, 198.92594795592),
    Boardcore::TrajectoryPoint(1290, 198.248804212344),
    Boardcore::TrajectoryPoint(1300, 197.570692449648),
    Boardcore::TrajectoryPoint(1310, 196.89158796383),
    Boardcore::TrajectoryPoint(1320, 196.211480080246),
    Boardcore::TrajectoryPoint(1330, 195.530357248992),
    Boardcore::TrajectoryPoint(1340, 194.848204658463),
    Boardcore::TrajectoryPoint(1350, 194.165007339647),
    Boardcore::TrajectoryPoint(1360, 193.480750164102),
    Boardcore::TrajectoryPoint(1370, 192.795417841903),
    Boardcore::TrajectoryPoint(1380, 192.108994919551),
    Boardcore::TrajectoryPoint(1390, 191.421465777846),
    Boardcore::TrajectoryPoint(1400, 190.732814629736),
    Boardcore::TrajectoryPoint(1410, 190.043025518113),
    Boardcore::TrajectoryPoint(1420, 189.352082313591),
    Boardcore::TrajectoryPoint(1430, 188.659968712228),
    Boardcore::TrajectoryPoint(1440, 187.966668233226),
    Boardcore::TrajectoryPoint(1450, 187.272164216576),
    Boardcore::TrajectoryPoint(1460, 186.576439820675),
    Boardcore::TrajectoryPoint(1470, 185.879478019896),
    Boardcore::TrajectoryPoint(1480, 185.18126160211),
    Boardcore::TrajectoryPoint(1490, 184.481773166175),
    Boardcore::TrajectoryPoint(1500, 183.780995119373),
    Boardcore::TrajectoryPoint(1510, 183.078831152376),
    Boardcore::TrajectoryPoint(1520, 182.375313224256),
    Boardcore::TrajectoryPoint(1530, 181.670445607704),
    Boardcore::TrajectoryPoint(1540, 180.964209786196),
    Boardcore::TrajectoryPoint(1550, 180.256587036472),
    Boardcore::TrajectoryPoint(1560, 179.547558425635),
    Boardcore::TrajectoryPoint(1570, 178.837104808199),
    Boardcore::TrajectoryPoint(1580, 178.125206823078),
    Boardcore::TrajectoryPoint(1590, 177.411844890527),
    Boardcore::TrajectoryPoint(1600, 176.696907629367),
    Boardcore::TrajectoryPoint(1610, 175.980396710502),
    Boardcore::TrajectoryPoint(1620, 175.262354335104),
    Boardcore::TrajectoryPoint(1630, 174.542759868968),
    Boardcore::TrajectoryPoint(1640, 173.821592440913),
    Boardcore::TrajectoryPoint(1650, 173.098830939295),
    Boardcore::TrajectoryPoint(1660, 172.374454008449),
    Boardcore::TrajectoryPoint(1670, 171.648296259664),
    Boardcore::TrajectoryPoint(1680, 170.920411970978),
    Boardcore::TrajectoryPoint(1690, 170.190838110942),
    Boardcore::TrajectoryPoint(1700, 169.459552146218),
    Boardcore::TrajectoryPoint(1710, 168.726531278078),
    Boardcore::TrajectoryPoint(1720, 167.991747608207),
    Boardcore::TrajectoryPoint(1730, 167.254936352316),
    Boardcore::TrajectoryPoint(1740, 166.516310668945),
    Boardcore::TrajectoryPoint(1750, 165.77584647747),
    Boardcore::TrajectoryPoint(1760, 165.033519407865),
    Boardcore::TrajectoryPoint(1770, 164.28927427164),
    Boardcore::TrajectoryPoint(1780, 163.542851306886),
    Boardcore::TrajectoryPoint(1790, 162.794480075756),
    Boardcore::TrajectoryPoint(1800, 162.044134808791),
    Boardcore::TrajectoryPoint(1810, 161.291789420101),
    Boardcore::TrajectoryPoint(1820, 160.537169011928),
    Boardcore::TrajectoryPoint(1830, 159.780397700069),
    Boardcore::TrajectoryPoint(1840, 159.021534468085),
    Boardcore::TrajectoryPoint(1850, 158.260551697929),
    Boardcore::TrajectoryPoint(1860, 157.497122457347),
    Boardcore::TrajectoryPoint(1870, 156.731426446039),
    Boardcore::TrajectoryPoint(1880, 155.96351337659),
    Boardcore::TrajectoryPoint(1890, 155.193283483006),
    Boardcore::TrajectoryPoint(1900, 154.420423443057),
    Boardcore::TrajectoryPoint(1910, 153.645244030978),
    Boardcore::TrajectoryPoint(1920, 152.867714584109),
    Boardcore::TrajectoryPoint(1930, 152.087424530683),
    Boardcore::TrajectoryPoint(1940, 151.304625078287),
    Boardcore::TrajectoryPoint(1950, 150.519366694747),
    Boardcore::TrajectoryPoint(1960, 149.731265953781),
    Boardcore::TrajectoryPoint(1970, 148.940473955692),
    Boardcore::TrajectoryPoint(1980, 148.147108595644),
    Boardcore::TrajectoryPoint(1990, 147.350716965407),
    Boardcore::TrajectoryPoint(2000, 146.551539850812),
    Boardcore::TrajectoryPoint(2010, 145.749668367277),
    Boardcore::TrajectoryPoint(2020, 144.94447527109),
    Boardcore::TrajectoryPoint(2030, 144.136499031437),
    Boardcore::TrajectoryPoint(2040, 143.325459729275),
    Boardcore::TrajectoryPoint(2050, 142.511162043943),
    Boardcore::TrajectoryPoint(2060, 141.693949734819),
    Boardcore::TrajectoryPoint(2070, 140.873173157493),
    Boardcore::TrajectoryPoint(2080, 140.049316467575),
    Boardcore::TrajectoryPoint(2090, 139.222025058033),
    Boardcore::TrajectoryPoint(2100, 138.39128571539),
    Boardcore::TrajectoryPoint(2110, 137.557186830447),
    Boardcore::TrajectoryPoint(2120, 136.719316441639),
    Boardcore::TrajectoryPoint(2130, 135.878102667658),
    Boardcore::TrajectoryPoint(2140, 135.032842169397),
    Boardcore::TrajectoryPoint(2150, 134.184190485131),
    Boardcore::TrajectoryPoint(2160, 133.331269557242),
    Boardcore::TrajectoryPoint(2170, 132.474840433249),
    Boardcore::TrajectoryPoint(2180, 131.613976869906),
    Boardcore::TrajectoryPoint(2190, 130.749413299353),
    Boardcore::TrajectoryPoint(2200, 129.880312335239),
    Boardcore::TrajectoryPoint(2210, 129.00723879042),
    Boardcore::TrajectoryPoint(2220, 128.12959237819),
    Boardcore::TrajectoryPoint(2230, 127.247613686517),
    Boardcore::TrajectoryPoint(2240, 126.361099721568),
    Boardcore::TrajectoryPoint(2250, 125.469799854195),
    Boardcore::TrajectoryPoint(2260, 124.574052988945),
    Boardcore::TrajectoryPoint(2270, 123.673022107916),
    Boardcore::TrajectoryPoint(2280, 122.767268926716),
    Boardcore::TrajectoryPoint(2290, 121.856465906411),
    Boardcore::TrajectoryPoint(2300, 120.940230202682),
    Boardcore::TrajectoryPoint(2310, 120.018897821772),
    Boardcore::TrajectoryPoint(2320, 119.092054373682),
    Boardcore::TrajectoryPoint(2330, 118.159451091098),
    Boardcore::TrajectoryPoint(2340, 117.221308887685),
    Boardcore::TrajectoryPoint(2350, 116.277391386465),
    Boardcore::TrajectoryPoint(2360, 115.327117477677),
    Boardcore::TrajectoryPoint(2370, 114.370818347705),
    Boardcore::TrajectoryPoint(2380, 113.408314884458),
    Boardcore::TrajectoryPoint(2390, 112.439334897656),
    Boardcore::TrajectoryPoint(2400, 111.463401845297),
    Boardcore::TrajectoryPoint(2410, 110.480709528569),
    Boardcore::TrajectoryPoint(2420, 109.491051885374),
    Boardcore::TrajectoryPoint(2430, 108.494214926488),
    Boardcore::TrajectoryPoint(2440, 107.489976366295),
    Boardcore::TrajectoryPoint(2450, 106.477932220573),
    Boardcore::TrajectoryPoint(2460, 105.457931822924),
    Boardcore::TrajectoryPoint(2470, 104.429845576987),
    Boardcore::TrajectoryPoint(2480, 103.393416356169),
    Boardcore::TrajectoryPoint(2490, 102.348376686222),
    Boardcore::TrajectoryPoint(2500, 101.294448233746),
    Boardcore::TrajectoryPoint(2510, 100.231341263594),
    Boardcore::TrajectoryPoint(2520, 99.1587540629666),
    Boardcore::TrajectoryPoint(2530, 98.0763723298344),
    Boardcore::TrajectoryPoint(2540, 96.9838685230846),
    Boardcore::TrajectoryPoint(2550, 95.8809011716182),
    Boardcore::TrajectoryPoint(2560, 94.7671141393518),
    Boardcore::TrajectoryPoint(2570, 93.642135842835),
    Boardcore::TrajectoryPoint(2580, 92.5054167869442),
    Boardcore::TrajectoryPoint(2590, 91.3564142346671),
    Boardcore::TrajectoryPoint(2600, 90.1949206741338),
    Boardcore::TrajectoryPoint(2610, 89.0204883776297),
    Boardcore::TrajectoryPoint(2620, 87.8326490493863),
    Boardcore::TrajectoryPoint(2630, 86.6302836904765),
    Boardcore::TrajectoryPoint(2640, 85.4132220991015),
    Boardcore::TrajectoryPoint(2650, 84.1810971823701),
    Boardcore::TrajectoryPoint(2660, 82.9324584412046),
    Boardcore::TrajectoryPoint(2670, 81.6672007918598),
    Boardcore::TrajectoryPoint(2680, 80.3843336745535),
    Boardcore::TrajectoryPoint(2690, 79.0828600642874),
    Boardcore::TrajectoryPoint(2700, 77.7620395249805),
    Boardcore::TrajectoryPoint(2710, 76.4208735393291),
    Boardcore::TrajectoryPoint(2720, 75.0578541686162),
    Boardcore::TrajectoryPoint(2730, 73.6724543664024),
    Boardcore::TrajectoryPoint(2740, 72.2629858119263),
    Boardcore::TrajectoryPoint(2750, 70.8276602357244),
    Boardcore::TrajectoryPoint(2760, 69.3653990607663),
    Boardcore::TrajectoryPoint(2770, 67.8743674630907),
    Boardcore::TrajectoryPoint(2780, 66.3525644190495),
    Boardcore::TrajectoryPoint(2790, 64.7978036500023),
    Boardcore::TrajectoryPoint(2800, 63.2076918765425),
    Boardcore::TrajectoryPoint(2810, 61.5796039283536),
    Boardcore::TrajectoryPoint(2820, 59.9100799710594),
    Boardcore::TrajectoryPoint(2830, 58.195487153966),
    Boardcore::TrajectoryPoint(2840, 56.4327496630326),
    Boardcore::TrajectoryPoint(2850, 54.6154397710727),
    Boardcore::TrajectoryPoint(2860, 52.7394417266114),
    Boardcore::TrajectoryPoint(2870, 50.797848777328),
    Boardcore::TrajectoryPoint(2880, 48.7825303416937),
    Boardcore::TrajectoryPoint(2890, 46.6839742666583),
    Boardcore::TrajectoryPoint(2900, 44.4909817263366),
    Boardcore::TrajectoryPoint(2910, 42.1879031265964),
    Boardcore::TrajectoryPoint(2920, 39.7565148829631),
    Boardcore::TrajectoryPoint(2930, 37.1710460819314),
    Boardcore::TrajectoryPoint(2940, 34.3977746229365),
    Boardcore::TrajectoryPoint(2950, 31.3853343436182),
    Boardcore::TrajectoryPoint(2960, 28.0583117978639),
    Boardcore::TrajectoryPoint(2970, 24.2862797656681),
    Boardcore::TrajectoryPoint(2980, 19.8191978041954),
    Boardcore::TrajectoryPoint(2990, 14.0058994313509),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t10_closed[] = {
    Boardcore::TrajectoryPoint(0, 281.183329704889),
    Boardcore::TrajectoryPoint(10, 280.545789563713),
    Boardcore::TrajectoryPoint(20, 279.90900554376),
    Boardcore::TrajectoryPoint(30, 279.272547122274),
    Boardcore::TrajectoryPoint(40, 278.636351906137),
    Boardcore::TrajectoryPoint(50, 278.000442234236),
    Boardcore::TrajectoryPoint(60, 277.364901713799),
    Boardcore::TrajectoryPoint(70, 276.729588998516),
    Boardcore::TrajectoryPoint(80, 276.09449974736),
    Boardcore::TrajectoryPoint(90, 275.459698074329),
    Boardcore::TrajectoryPoint(100, 274.825145724073),
    Boardcore::TrajectoryPoint(110, 274.190782500035),
    Boardcore::TrajectoryPoint(120, 273.55660349262),
    Boardcore::TrajectoryPoint(130, 272.922684222254),
    Boardcore::TrajectoryPoint(140, 272.288931420691),
    Boardcore::TrajectoryPoint(150, 271.655329553943),
    Boardcore::TrajectoryPoint(160, 271.021882478934),
    Boardcore::TrajectoryPoint(170, 270.388629354032),
    Boardcore::TrajectoryPoint(180, 269.755494958588),
    Boardcore::TrajectoryPoint(190, 269.122473883368),
    Boardcore::TrajectoryPoint(200, 268.489573279466),
    Boardcore::TrajectoryPoint(210, 267.856801053048),
    Boardcore::TrajectoryPoint(220, 267.224110874719),
    Boardcore::TrajectoryPoint(230, 266.591497015366),
    Boardcore::TrajectoryPoint(240, 265.958961750792),
    Boardcore::TrajectoryPoint(250, 265.326502060813),
    Boardcore::TrajectoryPoint(260, 264.694088286946),
    Boardcore::TrajectoryPoint(270, 264.06171444074),
    Boardcore::TrajectoryPoint(280, 263.429376390502),
    Boardcore::TrajectoryPoint(290, 262.797066660874),
    Boardcore::TrajectoryPoint(300, 262.164767248454),
    Boardcore::TrajectoryPoint(310, 261.53247194896),
    Boardcore::TrajectoryPoint(320, 260.90017437325),
    Boardcore::TrajectoryPoint(330, 260.267857219943),
    Boardcore::TrajectoryPoint(340, 259.635515276077),
    Boardcore::TrajectoryPoint(350, 259.003142151507),
    Boardcore::TrajectoryPoint(360, 258.370731296327),
    Boardcore::TrajectoryPoint(370, 257.738260900598),
    Boardcore::TrajectoryPoint(380, 257.105724062591),
    Boardcore::TrajectoryPoint(390, 256.473121199862),
    Boardcore::TrajectoryPoint(400, 255.840445613353),
    Boardcore::TrajectoryPoint(410, 255.207686552895),
    Boardcore::TrajectoryPoint(420, 254.57480637699),
    Boardcore::TrajectoryPoint(430, 253.941825699226),
    Boardcore::TrajectoryPoint(440, 253.30873767816),
    Boardcore::TrajectoryPoint(450, 252.675535350982),
    Boardcore::TrajectoryPoint(460, 252.042193152386),
    Boardcore::TrajectoryPoint(470, 251.408689815336),
    Boardcore::TrajectoryPoint(480, 250.775044792878),
    Boardcore::TrajectoryPoint(490, 250.1412509896),
    Boardcore::TrajectoryPoint(500, 249.507301203191),
    Boardcore::TrajectoryPoint(510, 248.87316256915),
    Boardcore::TrajectoryPoint(520, 248.238818530643),
    Boardcore::TrajectoryPoint(530, 247.604291408195),
    Boardcore::TrajectoryPoint(540, 246.969573866135),
    Boardcore::TrajectoryPoint(550, 246.334658471443),
    Boardcore::TrajectoryPoint(560, 245.699522238057),
    Boardcore::TrajectoryPoint(570, 245.064121844332),
    Boardcore::TrajectoryPoint(580, 244.428496650832),
    Boardcore::TrajectoryPoint(590, 243.792639082849),
    Boardcore::TrajectoryPoint(600, 243.156541474127),
    Boardcore::TrajectoryPoint(610, 242.520196069433),
    Boardcore::TrajectoryPoint(620, 241.883544973019),
    Boardcore::TrajectoryPoint(630, 241.246606529934),
    Boardcore::TrajectoryPoint(640, 240.60939330544),
    Boardcore::TrajectoryPoint(650, 239.97189738931),
    Boardcore::TrajectoryPoint(660, 239.334110784457),
    Boardcore::TrajectoryPoint(670, 238.69602540845),
    Boardcore::TrajectoryPoint(680, 238.057576106563),
    Boardcore::TrajectoryPoint(690, 237.41879124734),
    Boardcore::TrajectoryPoint(700, 236.779680428006),
    Boardcore::TrajectoryPoint(710, 236.140235391028),
    Boardcore::TrajectoryPoint(720, 235.500447793058),
    Boardcore::TrajectoryPoint(730, 234.860309205677),
    Boardcore::TrajectoryPoint(740, 234.219790161872),
    Boardcore::TrajectoryPoint(750, 233.578846355892),
    Boardcore::TrajectoryPoint(760, 232.937524003429),
    Boardcore::TrajectoryPoint(770, 232.295814476607),
    Boardcore::TrajectoryPoint(780, 231.653709060202),
    Boardcore::TrajectoryPoint(790, 231.011198951816),
    Boardcore::TrajectoryPoint(800, 230.368275261942),
    Boardcore::TrajectoryPoint(810, 229.724926212941),
    Boardcore::TrajectoryPoint(820, 229.081072284226),
    Boardcore::TrajectoryPoint(830, 228.436776549103),
    Boardcore::TrajectoryPoint(840, 227.792029888117),
    Boardcore::TrajectoryPoint(850, 227.146823090863),
    Boardcore::TrajectoryPoint(860, 226.501146855667),
    Boardcore::TrajectoryPoint(870, 225.85499178918),
    Boardcore::TrajectoryPoint(880, 225.208348405894),
    Boardcore::TrajectoryPoint(890, 224.561207127583),
    Boardcore::TrajectoryPoint(900, 223.913513060432),
    Boardcore::TrajectoryPoint(910, 223.265275794283),
    Boardcore::TrajectoryPoint(920, 222.616511188124),
    Boardcore::TrajectoryPoint(930, 221.967209391848),
    Boardcore::TrajectoryPoint(940, 221.317360457409),
    Boardcore::TrajectoryPoint(950, 220.666954338028),
    Boardcore::TrajectoryPoint(960, 220.015980887354),
    Boardcore::TrajectoryPoint(970, 219.364429858565),
    Boardcore::TrajectoryPoint(980, 218.712290903426),
    Boardcore::TrajectoryPoint(990, 218.059553571301),
    Boardcore::TrajectoryPoint(1000, 217.406204008468),
    Boardcore::TrajectoryPoint(1010, 216.752179435558),
    Boardcore::TrajectoryPoint(1020, 216.097525279013),
    Boardcore::TrajectoryPoint(1030, 215.442230766175),
    Boardcore::TrajectoryPoint(1040, 214.78628501582),
    Boardcore::TrajectoryPoint(1050, 214.129677037031),
    Boardcore::TrajectoryPoint(1060, 213.472395728017),
    Boardcore::TrajectoryPoint(1070, 212.814429874915),
    Boardcore::TrajectoryPoint(1080, 212.155768150546),
    Boardcore::TrajectoryPoint(1090, 211.496399113148),
    Boardcore::TrajectoryPoint(1100, 210.836311205072),
    Boardcore::TrajectoryPoint(1110, 210.17549275145),
    Boardcore::TrajectoryPoint(1120, 209.513931958835),
    Boardcore::TrajectoryPoint(1130, 208.851616913814),
    Boardcore::TrajectoryPoint(1140, 208.188535581588),
    Boardcore::TrajectoryPoint(1150, 207.524675804528),
    Boardcore::TrajectoryPoint(1160, 206.860025300706),
    Boardcore::TrajectoryPoint(1170, 206.194571662398),
    Boardcore::TrajectoryPoint(1180, 205.528302354555),
    Boardcore::TrajectoryPoint(1190, 204.86120208359),
    Boardcore::TrajectoryPoint(1200, 204.193243603261),
    Boardcore::TrajectoryPoint(1210, 203.524433605641),
    Boardcore::TrajectoryPoint(1220, 202.854759129054),
    Boardcore::TrajectoryPoint(1230, 202.184207076907),
    Boardcore::TrajectoryPoint(1240, 201.512764216052),
    Boardcore::TrajectoryPoint(1250, 200.840417175123),
    Boardcore::TrajectoryPoint(1260, 200.16715244284),
    Boardcore::TrajectoryPoint(1270, 199.492956366292),
    Boardcore::TrajectoryPoint(1280, 198.817815149183),
    Boardcore::TrajectoryPoint(1290, 198.141714850063),
    Boardcore::TrajectoryPoint(1300, 197.464641380516),
    Boardcore::TrajectoryPoint(1310, 196.786580503325),
    Boardcore::TrajectoryPoint(1320, 196.107517830609),
    Boardcore::TrajectoryPoint(1330, 195.427438821927),
    Boardcore::TrajectoryPoint(1340, 194.74631523882),
    Boardcore::TrajectoryPoint(1350, 194.064130398055),
    Boardcore::TrajectoryPoint(1360, 193.380880590667),
    Boardcore::TrajectoryPoint(1370, 192.696550537698),
    Boardcore::TrajectoryPoint(1380, 192.0111247967),
    Boardcore::TrajectoryPoint(1390, 191.324587759604),
    Boardcore::TrajectoryPoint(1400, 190.636923650568),
    Boardcore::TrajectoryPoint(1410, 189.948116523772),
    Boardcore::TrajectoryPoint(1420, 189.258150261188),
    Boardcore::TrajectoryPoint(1430, 188.567008570309),
    Boardcore::TrajectoryPoint(1440, 187.874674981836),
    Boardcore::TrajectoryPoint(1450, 187.181132847332),
    Boardcore::TrajectoryPoint(1460, 186.486365336826),
    Boardcore::TrajectoryPoint(1470, 185.790355436387),
    Boardcore::TrajectoryPoint(1480, 185.093085945642),
    Boardcore::TrajectoryPoint(1490, 184.394539475263),
    Boardcore::TrajectoryPoint(1500, 183.694698444398),
    Boardcore::TrajectoryPoint(1510, 182.993524276774),
    Boardcore::TrajectoryPoint(1520, 182.290932968681),
    Boardcore::TrajectoryPoint(1530, 181.586987045335),
    Boardcore::TrajectoryPoint(1540, 180.881668002559),
    Boardcore::TrajectoryPoint(1550, 180.174957129472),
    Boardcore::TrajectoryPoint(1560, 179.466835505595),
    Boardcore::TrajectoryPoint(1570, 178.757283997885),
    Boardcore::TrajectoryPoint(1580, 178.046283257734),
    Boardcore::TrajectoryPoint(1590, 177.333813717894),
    Boardcore::TrajectoryPoint(1600, 176.619820012292),
    Boardcore::TrajectoryPoint(1610, 175.904191144688),
    Boardcore::TrajectoryPoint(1620, 175.187025995626),
    Boardcore::TrajectoryPoint(1630, 174.468303943705),
    Boardcore::TrajectoryPoint(1640, 173.748004130557),
    Boardcore::TrajectoryPoint(1650, 173.026105457355),
    Boardcore::TrajectoryPoint(1660, 172.302586581255),
    Boardcore::TrajectoryPoint(1670, 171.577336441504),
    Boardcore::TrajectoryPoint(1680, 170.85029992654),
    Boardcore::TrajectoryPoint(1690, 170.12156909661),
    Boardcore::TrajectoryPoint(1700, 169.391121431373),
    Boardcore::TrajectoryPoint(1710, 168.65893414508),
    Boardcore::TrajectoryPoint(1720, 167.924984182514),
    Boardcore::TrajectoryPoint(1730, 167.189044861129),
    Boardcore::TrajectoryPoint(1740, 166.451237837302),
    Boardcore::TrajectoryPoint(1750, 165.711587632504),
    Boardcore::TrajectoryPoint(1760, 164.970069889743),
    Boardcore::TrajectoryPoint(1770, 164.226659958028),
    Boardcore::TrajectoryPoint(1780, 163.48105763174),
    Boardcore::TrajectoryPoint(1790, 162.73348092037),
    Boardcore::TrajectoryPoint(1800, 161.983925559252),
    Boardcore::TrajectoryPoint(1810, 161.232365475486),
    Boardcore::TrajectoryPoint(1820, 160.47857594501),
    Boardcore::TrajectoryPoint(1830, 159.72257982346),
    Boardcore::TrajectoryPoint(1840, 158.964487214493),
    Boardcore::TrajectoryPoint(1850, 158.204270512978),
    Boardcore::TrajectoryPoint(1860, 157.441651693391),
    Boardcore::TrajectoryPoint(1870, 156.67671168763),
    Boardcore::TrajectoryPoint(1880, 155.909550103422),
    Boardcore::TrajectoryPoint(1890, 155.140115557016),
    Boardcore::TrajectoryPoint(1900, 154.367996973887),
    Boardcore::TrajectoryPoint(1910, 153.593554532696),
    Boardcore::TrajectoryPoint(1920, 152.816757583451),
    Boardcore::TrajectoryPoint(1930, 152.037242160718),
    Boardcore::TrajectoryPoint(1940, 151.255165237319),
    Boardcore::TrajectoryPoint(1950, 150.47062494389),
    Boardcore::TrajectoryPoint(1960, 149.683283531746),
    Boardcore::TrajectoryPoint(1970, 148.893199695978),
    Boardcore::TrajectoryPoint(1980, 148.10053809372),
    Boardcore::TrajectoryPoint(1990, 147.304890398706),
    Boardcore::TrajectoryPoint(2000, 146.506407157113),
    Boardcore::TrajectoryPoint(2010, 145.705225845146),
    Boardcore::TrajectoryPoint(2020, 144.900760543044),
    Boardcore::TrajectoryPoint(2030, 144.093463966026),
    Boardcore::TrajectoryPoint(2040, 143.283143067133),
    Boardcore::TrajectoryPoint(2050, 142.469515228566),
    Boardcore::TrajectoryPoint(2060, 141.652968451763),
    Boardcore::TrajectoryPoint(2070, 140.832894668316),
    Boardcore::TrajectoryPoint(2080, 140.009693742117),
    Boardcore::TrajectoryPoint(2090, 139.183094929872),
    Boardcore::TrajectoryPoint(2100, 138.353001608728),
    Boardcore::TrajectoryPoint(2110, 137.519585063121),
    Boardcore::TrajectoryPoint(2120, 136.682350980838),
    Boardcore::TrajectoryPoint(2130, 135.841809231805),
    Boardcore::TrajectoryPoint(2140, 134.99717535308),
    Boardcore::TrajectoryPoint(2150, 134.149161084008),
    Boardcore::TrajectoryPoint(2160, 133.296881360802),
    Boardcore::TrajectoryPoint(2170, 132.441080408393),
    Boardcore::TrajectoryPoint(2180, 131.58084725027),
    Boardcore::TrajectoryPoint(2190, 130.716924467205),
    Boardcore::TrajectoryPoint(2200, 129.848421235227),
    Boardcore::TrajectoryPoint(2210, 128.975977980481),
    Boardcore::TrajectoryPoint(2220, 128.0989197305),
    Boardcore::TrajectoryPoint(2230, 127.217560794897),
    Boardcore::TrajectoryPoint(2240, 126.331625452424),
    Boardcore::TrajectoryPoint(2250, 125.440934773674),
    Boardcore::TrajectoryPoint(2260, 124.545785374864),
    Boardcore::TrajectoryPoint(2270, 123.645324731059),
    Boardcore::TrajectoryPoint(2280, 122.740164901165),
    Boardcore::TrajectoryPoint(2290, 121.829916128431),
    Boardcore::TrajectoryPoint(2300, 120.914263114017),
    Boardcore::TrajectoryPoint(2310, 119.993508111415),
    Boardcore::TrajectoryPoint(2320, 119.067204099234),
    Boardcore::TrajectoryPoint(2330, 118.135167477349),
    Boardcore::TrajectoryPoint(2340, 117.19758655866),
    Boardcore::TrajectoryPoint(2350, 116.254193737603),
    Boardcore::TrajectoryPoint(2360, 115.304470347859),
    Boardcore::TrajectoryPoint(2370, 114.348716302046),
    Boardcore::TrajectoryPoint(2380, 113.386752459337),
    Boardcore::TrajectoryPoint(2390, 112.418277111355),
    Boardcore::TrajectoryPoint(2400, 111.442872847948),
    Boardcore::TrajectoryPoint(2410, 110.460703805506),
    Boardcore::TrajectoryPoint(2420, 109.471563896517),
    Boardcore::TrajectoryPoint(2430, 108.475239107297),
    Boardcore::TrajectoryPoint(2440, 107.471507128687),
    Boardcore::TrajectoryPoint(2450, 106.459937038852),
    Boardcore::TrajectoryPoint(2460, 105.440432299965),
    Boardcore::TrajectoryPoint(2470, 104.412836084585),
    Boardcore::TrajectoryPoint(2480, 103.376891245348),
    Boardcore::TrajectoryPoint(2490, 102.33233028804),
    Boardcore::TrajectoryPoint(2500, 101.27887486007),
    Boardcore::TrajectoryPoint(2510, 100.216235207859),
    Boardcore::TrajectoryPoint(2520, 99.1441096009085),
    Boardcore::TrajectoryPoint(2530, 98.0621837202052),
    Boardcore::TrajectoryPoint(2540, 96.9701300083487),
    Boardcore::TrajectoryPoint(2550, 95.8676069786303),
    Boardcore::TrajectoryPoint(2560, 94.754258480018),
    Boardcore::TrajectoryPoint(2570, 93.6297129147561),
    Boardcore::TrajectoryPoint(2580, 92.4934417123795),
    Boardcore::TrajectoryPoint(2590, 91.3448596397446),
    Boardcore::TrajectoryPoint(2600, 90.1837806986672),
    Boardcore::TrajectoryPoint(2610, 89.0097571499722),
    Boardcore::TrajectoryPoint(2620, 87.822320686986),
    Boardcore::TrajectoryPoint(2630, 86.6203708069981),
    Boardcore::TrajectoryPoint(2640, 85.4036995758212),
    Boardcore::TrajectoryPoint(2650, 84.1719590909084),
    Boardcore::TrajectoryPoint(2660, 82.9237159046795),
    Boardcore::TrajectoryPoint(2670, 81.6588300349283),
    Boardcore::TrajectoryPoint(2680, 80.3763449280279),
    Boardcore::TrajectoryPoint(2690, 79.0752303429038),
    Boardcore::TrajectoryPoint(2700, 77.7547780524514),
    Boardcore::TrajectoryPoint(2710, 76.4139582439634),
    Boardcore::TrajectoryPoint(2720, 75.0512931580034),
    Boardcore::TrajectoryPoint(2730, 73.6662404425365),
    Boardcore::TrajectoryPoint(2740, 72.2570981761325),
    Boardcore::TrajectoryPoint(2750, 70.8221054100527),
    Boardcore::TrajectoryPoint(2760, 69.3601696445769),
    Boardcore::TrajectoryPoint(2770, 67.8694559789692),
    Boardcore::TrajectoryPoint(2780, 66.3479633152937),
    Boardcore::TrajectoryPoint(2790, 64.7935053028924),
    Boardcore::TrajectoryPoint(2800, 63.2036885923768),
    Boardcore::TrajectoryPoint(2810, 61.5758879452287),
    Boardcore::TrajectoryPoint(2820, 59.906652954382),
    Boardcore::TrajectoryPoint(2830, 58.1923310524091),
    Boardcore::TrajectoryPoint(2840, 56.4298650354686),
    Boardcore::TrajectoryPoint(2850, 54.6128092700336),
    Boardcore::TrajectoryPoint(2860, 52.7370646196389),
    Boardcore::TrajectoryPoint(2870, 50.7957155804483),
    Boardcore::TrajectoryPoint(2880, 48.7806313724622),
    Boardcore::TrajectoryPoint(2890, 46.6822996451575),
    Boardcore::TrajectoryPoint(2900, 44.4895213742656),
    Boardcore::TrajectoryPoint(2910, 42.1866516149294),
    Boardcore::TrajectoryPoint(2920, 39.7554604779978),
    Boardcore::TrajectoryPoint(2930, 37.1701766160842),
    Boardcore::TrajectoryPoint(2940, 34.397080838885),
    Boardcore::TrajectoryPoint(2950, 31.3848018241707),
    Boardcore::TrajectoryPoint(2960, 28.0579252871813),
    Boardcore::TrajectoryPoint(2970, 24.2860262036087),
    Boardcore::TrajectoryPoint(2980, 19.8190576977534),
    Boardcore::TrajectoryPoint(2990, 14.0058491793658),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t0_open[] = {
    Boardcore::TrajectoryPoint(0, 478.303866669533),
    Boardcore::TrajectoryPoint(10, 476.110678663647),
    Boardcore::TrajectoryPoint(20, 473.908331442012),
    Boardcore::TrajectoryPoint(30, 471.700135899607),
    Boardcore::TrajectoryPoint(40, 469.486883702846),
    Boardcore::TrajectoryPoint(50, 467.258221998725),
    Boardcore::TrajectoryPoint(60, 465.029560294604),
    Boardcore::TrajectoryPoint(70, 462.781849245843),
    Boardcore::TrajectoryPoint(80, 460.532252082601),
    Boardcore::TrajectoryPoint(90, 458.269829602645),
    Boardcore::TrajectoryPoint(100, 455.99881272007),
    Boardcore::TrajectoryPoint(110, 453.720922112148),
    Boardcore::TrajectoryPoint(120, 451.427985634701),
    Boardcore::TrajectoryPoint(130, 449.133830016509),
    Boardcore::TrajectoryPoint(140, 446.818457765002),
    Boardcore::TrajectoryPoint(150, 444.503085513494),
    Boardcore::TrajectoryPoint(160, 442.168856447214),
    Boardcore::TrajectoryPoint(170, 439.830515212296),
    Boardcore::TrajectoryPoint(180, 437.477746091847),
    Boardcore::TrajectoryPoint(190, 435.115884866727),
    Boardcore::TrajectoryPoint(200, 432.743624633102),
    Boardcore::TrajectoryPoint(210, 430.357673802733),
    Boardcore::TrajectoryPoint(220, 427.964919732943),
    Boardcore::TrajectoryPoint(230, 425.55429021666),
    Boardcore::TrajectoryPoint(240, 423.139984719873),
    Boardcore::TrajectoryPoint(250, 420.70406706425),
    Boardcore::TrajectoryPoint(260, 418.267094240592),
    Boardcore::TrajectoryPoint(270, 415.805257658995),
    Boardcore::TrajectoryPoint(280, 413.343421077398),
    Boardcore::TrajectoryPoint(290, 410.85603095568),
    Boardcore::TrajectoryPoint(300, 408.367622310716),
    Boardcore::TrajectoryPoint(310, 405.854466492588),
    Boardcore::TrajectoryPoint(320, 403.338809217329),
    Boardcore::TrajectoryPoint(330, 400.798548963256),
    Boardcore::TrajectoryPoint(340, 398.254941916754),
    Boardcore::TrajectoryPoint(350, 395.686162385816),
    Boardcore::TrajectoryPoint(360, 393.113878638048),
    Boardcore::TrajectoryPoint(370, 390.515083834741),
    Boardcore::TrajectoryPoint(380, 387.913369375698),
    Boardcore::TrajectoryPoint(390, 385.282976696264),
    Boardcore::TrajectoryPoint(400, 382.650336586874),
    Boardcore::TrajectoryPoint(410, 379.987383404768),
    Boardcore::TrajectoryPoint(420, 377.320540187925),
    Boardcore::TrajectoryPoint(430, 374.625717613012),
    Boardcore::TrajectoryPoint(440, 371.922824680813),
    Boardcore::TrajectoryPoint(450, 369.195255744106),
    Boardcore::TrajectoryPoint(460, 366.454355028236),
    Boardcore::TrajectoryPoint(470, 363.693127867576),
    Boardcore::TrajectoryPoint(480, 361.291803523556),
    Boardcore::TrajectoryPoint(490, 359.16093249649),
    Boardcore::TrajectoryPoint(500, 357.053008768381),
    Boardcore::TrajectoryPoint(510, 354.952016492618),
    Boardcore::TrajectoryPoint(520, 352.880395038909),
    Boardcore::TrajectoryPoint(530, 350.81574292853),
    Boardcore::TrajectoryPoint(540, 348.774301632137),
    Boardcore::TrajectoryPoint(550, 346.746744508508),
    Boardcore::TrajectoryPoint(560, 344.734768278242),
    Boardcore::TrajectoryPoint(570, 342.744399753905),
    Boardcore::TrajectoryPoint(580, 340.762396123081),
    Boardcore::TrajectoryPoint(590, 338.808313673365),
    Boardcore::TrajectoryPoint(600, 336.863656006179),
    Boardcore::TrajectoryPoint(610, 334.937872655311),
    Boardcore::TrajectoryPoint(620, 333.030258537312),
    Boardcore::TrajectoryPoint(630, 331.132273793809),
    Boardcore::TrajectoryPoint(640, 329.261278684848),
    Boardcore::TrajectoryPoint(650, 327.399686574159),
    Boardcore::TrajectoryPoint(660, 325.555646708839),
    Boardcore::TrajectoryPoint(670, 323.730121856546),
    Boardcore::TrajectoryPoint(680, 321.914513572521),
    Boardcore::TrajectoryPoint(690, 320.12203983239),
    Boardcore::TrajectoryPoint(700, 318.341709542118),
    Boardcore::TrajectoryPoint(710, 316.574084688208),
    Boardcore::TrajectoryPoint(720, 314.828244869813),
    Boardcore::TrajectoryPoint(730, 313.092485871752),
    Boardcore::TrajectoryPoint(740, 311.372650481183),
    Boardcore::TrajectoryPoint(750, 309.670316315418),
    Boardcore::TrajectoryPoint(760, 307.978206928587),
    Boardcore::TrajectoryPoint(770, 306.303608435432),
    Boardcore::TrajectoryPoint(780, 304.643734464818),
    Boardcore::TrajectoryPoint(790, 302.994108784257),
    Boardcore::TrajectoryPoint(800, 301.362225309216),
    Boardcore::TrajectoryPoint(810, 299.743558103667),
    Boardcore::TrajectoryPoint(820, 298.135059338424),
    Boardcore::TrajectoryPoint(830, 296.543433436692),
    Boardcore::TrajectoryPoint(840, 294.96456019002),
    Boardcore::TrajectoryPoint(850, 293.395689763048),
    Boardcore::TrajectoryPoint(860, 291.841951216982),
    Boardcore::TrajectoryPoint(870, 290.301343794575),
    Boardcore::TrajectoryPoint(880, 288.77050453326),
    Boardcore::TrajectoryPoint(890, 287.252384837521),
    Boardcore::TrajectoryPoint(900, 285.748438086842),
    Boardcore::TrajectoryPoint(910, 284.253970949318),
    Boardcore::TrajectoryPoint(920, 282.7693115961),
    Boardcore::TrajectoryPoint(930, 281.300375629765),
    Boardcore::TrajectoryPoint(940, 279.840590090234),
    Boardcore::TrajectoryPoint(950, 278.390020058004),
    Boardcore::TrajectoryPoint(960, 276.951752997188),
    Boardcore::TrajectoryPoint(970, 275.524951589158),
    Boardcore::TrajectoryPoint(980, 274.106982082686),
    Boardcore::TrajectoryPoint(990, 272.697866798964),
    Boardcore::TrajectoryPoint(1000, 271.301774705652),
    Boardcore::TrajectoryPoint(1010, 269.914705288336),
    Boardcore::TrajectoryPoint(1020, 268.536072782173),
    Boardcore::TrajectoryPoint(1030, 267.165938045128),
    Boardcore::TrajectoryPoint(1040, 265.808102754033),
    Boardcore::TrajectoryPoint(1050, 264.458282353554),
    Boardcore::TrajectoryPoint(1060, 263.116453859755),
    Boardcore::TrajectoryPoint(1070, 261.782583011044),
    Boardcore::TrajectoryPoint(1080, 260.459647535878),
    Boardcore::TrajectoryPoint(1090, 259.144578153032),
    Boardcore::TrajectoryPoint(1100, 257.837026296697),
    Boardcore::TrajectoryPoint(1110, 256.536940386158),
    Boardcore::TrajectoryPoint(1120, 255.245656081881),
    Boardcore::TrajectoryPoint(1130, 253.962872292273),
    Boardcore::TrajectoryPoint(1140, 252.687117881477),
    Boardcore::TrajectoryPoint(1150, 251.418329225886),
    Boardcore::TrajectoryPoint(1160, 250.156436471),
    Boardcore::TrajectoryPoint(1170, 248.902914158213),
    Boardcore::TrajectoryPoint(1180, 247.65655521938),
    Boardcore::TrajectoryPoint(1190, 246.416663608132),
    Boardcore::TrajectoryPoint(1200, 245.183162917738),
    Boardcore::TrajectoryPoint(1210, 243.955972457538),
    Boardcore::TrajectoryPoint(1220, 242.735701791703),
    Boardcore::TrajectoryPoint(1230, 241.522410063674),
    Boardcore::TrajectoryPoint(1240, 240.315016011527),
    Boardcore::TrajectoryPoint(1250, 239.113436186479),
    Boardcore::TrajectoryPoint(1260, 237.917584271341),
    Boardcore::TrajectoryPoint(1270, 236.727371431674),
    Boardcore::TrajectoryPoint(1280, 235.543136785115),
    Boardcore::TrajectoryPoint(1290, 234.365015551893),
    Boardcore::TrajectoryPoint(1300, 233.192143708131),
    Boardcore::TrajectoryPoint(1310, 232.024432864238),
    Boardcore::TrajectoryPoint(1320, 230.861793035768),
    Boardcore::TrajectoryPoint(1330, 229.704132881822),
    Boardcore::TrajectoryPoint(1340, 228.551359923759),
    Boardcore::TrajectoryPoint(1350, 227.403420432847),
    Boardcore::TrajectoryPoint(1360, 226.260838391399),
    Boardcore::TrajectoryPoint(1370, 225.122783960178),
    Boardcore::TrajectoryPoint(1380, 223.989167311015),
    Boardcore::TrajectoryPoint(1390, 222.859898002946),
    Boardcore::TrajectoryPoint(1400, 221.734885128033),
    Boardcore::TrajectoryPoint(1410, 220.614037444278),
    Boardcore::TrajectoryPoint(1420, 219.497263496593),
    Boardcore::TrajectoryPoint(1430, 218.384471726666),
    Boardcore::TrajectoryPoint(1440, 217.275570572567),
    Boardcore::TrajectoryPoint(1450, 216.170468558837),
    Boardcore::TrajectoryPoint(1460, 215.069315969275),
    Boardcore::TrajectoryPoint(1470, 213.971800607032),
    Boardcore::TrajectoryPoint(1480, 212.877772008125),
    Boardcore::TrajectoryPoint(1490, 211.787142828208),
    Boardcore::TrajectoryPoint(1500, 210.69982596659),
    Boardcore::TrajectoryPoint(1510, 209.615734623055),
    Boardcore::TrajectoryPoint(1520, 208.534782348539),
    Boardcore::TrajectoryPoint(1530, 207.45688309016),
    Boardcore::TrajectoryPoint(1540, 206.38195123101),
    Boardcore::TrajectoryPoint(1550, 205.309901625107),
    Boardcore::TrajectoryPoint(1560, 204.240649627898),
    Boardcore::TrajectoryPoint(1570, 203.174111122621),
    Boardcore::TrajectoryPoint(1580, 202.110202542883),
    Boardcore::TrajectoryPoint(1590, 201.048840891714),
    Boardcore::TrajectoryPoint(1600, 199.989943757391),
    Boardcore::TrajectoryPoint(1610, 198.933429326281),
    Boardcore::TrajectoryPoint(1620, 197.879216392926),
    Boardcore::TrajectoryPoint(1630, 196.8272243676),
    Boardcore::TrajectoryPoint(1640, 195.777373281532),
    Boardcore::TrajectoryPoint(1650, 194.729583789978),
    Boardcore::TrajectoryPoint(1660, 193.683777173313),
    Boardcore::TrajectoryPoint(1670, 192.639875336311),
    Boardcore::TrajectoryPoint(1680, 191.597800805742),
    Boardcore::TrajectoryPoint(1690, 190.557476726436),
    Boardcore::TrajectoryPoint(1700, 189.51882685593),
    Boardcore::TrajectoryPoint(1710, 188.481775557818),
    Boardcore::TrajectoryPoint(1720, 187.446247793903),
    Boardcore::TrajectoryPoint(1730, 186.412169115258),
    Boardcore::TrajectoryPoint(1740, 185.379465652277),
    Boardcore::TrajectoryPoint(1750, 184.348133336927),
    Boardcore::TrajectoryPoint(1760, 183.318043204865),
    Boardcore::TrajectoryPoint(1770, 182.28910429263),
    Boardcore::TrajectoryPoint(1780, 181.261244268202),
    Boardcore::TrajectoryPoint(1790, 180.234391343629),
    Boardcore::TrajectoryPoint(1800, 179.208474258722),
    Boardcore::TrajectoryPoint(1810, 178.183422264299),
    Boardcore::TrajectoryPoint(1820, 177.159165105026),
    Boardcore::TrajectoryPoint(1830, 176.135633001879),
    Boardcore::TrajectoryPoint(1840, 175.112794607803),
    Boardcore::TrajectoryPoint(1850, 174.090559554552),
    Boardcore::TrajectoryPoint(1860, 173.068830674786),
    Boardcore::TrajectoryPoint(1870, 172.047539477572),
    Boardcore::TrajectoryPoint(1880, 171.026617867327),
    Boardcore::TrajectoryPoint(1890, 170.005998123584),
    Boardcore::TrajectoryPoint(1900, 168.985619869414),
    Boardcore::TrajectoryPoint(1910, 167.965413559216),
    Boardcore::TrajectoryPoint(1920, 166.945292280046),
    Boardcore::TrajectoryPoint(1930, 165.925189255102),
    Boardcore::TrajectoryPoint(1940, 164.905037983669),
    Boardcore::TrajectoryPoint(1950, 163.884763451674),
    Boardcore::TrajectoryPoint(1960, 162.864276947005),
    Boardcore::TrajectoryPoint(1970, 161.843525844286),
    Boardcore::TrajectoryPoint(1980, 160.822444213963),
    Boardcore::TrajectoryPoint(1990, 159.800962871495),
    Boardcore::TrajectoryPoint(2000, 158.778933719157),
    Boardcore::TrajectoryPoint(2010, 157.756356882669),
    Boardcore::TrajectoryPoint(2020, 156.733166659827),
    Boardcore::TrajectoryPoint(2030, 155.709257917077),
    Boardcore::TrajectoryPoint(2040, 154.684494008821),
    Boardcore::TrajectoryPoint(2050, 153.658897808863),
    Boardcore::TrajectoryPoint(2060, 152.632403459007),
    Boardcore::TrajectoryPoint(2070, 151.604762689688),
    Boardcore::TrajectoryPoint(2080, 150.576052755115),
    Boardcore::TrajectoryPoint(2090, 149.546222874254),
    Boardcore::TrajectoryPoint(2100, 148.514992946422),
    Boardcore::TrajectoryPoint(2110, 147.482445853488),
    Boardcore::TrajectoryPoint(2120, 146.448553622285),
    Boardcore::TrajectoryPoint(2130, 145.412934980101),
    Boardcore::TrajectoryPoint(2140, 144.375809594596),
    Boardcore::TrajectoryPoint(2150, 143.336979599798),
    Boardcore::TrajectoryPoint(2160, 142.296254361155),
    Boardcore::TrajectoryPoint(2170, 141.253789379336),
    Boardcore::TrajectoryPoint(2180, 140.209135465344),
    Boardcore::TrajectoryPoint(2190, 139.162525361947),
    Boardcore::TrajectoryPoint(2200, 138.113667536734),
    Boardcore::TrajectoryPoint(2210, 137.062521233607),
    Boardcore::TrajectoryPoint(2220, 136.009031316137),
    Boardcore::TrajectoryPoint(2230, 134.952945980071),
    Boardcore::TrajectoryPoint(2240, 133.89437235337),
    Boardcore::TrajectoryPoint(2250, 132.832932547981),
    Boardcore::TrajectoryPoint(2260, 131.768799390937),
    Boardcore::TrajectoryPoint(2270, 130.701576132574),
    Boardcore::TrajectoryPoint(2280, 129.63138244207),
    Boardcore::TrajectoryPoint(2290, 128.557932159568),
    Boardcore::TrajectoryPoint(2300, 127.48115056716),
    Boardcore::TrajectoryPoint(2310, 126.401013963894),
    Boardcore::TrajectoryPoint(2320, 125.317089348417),
    Boardcore::TrajectoryPoint(2330, 124.229669358445),
    Boardcore::TrajectoryPoint(2340, 123.138138058597),
    Boardcore::TrajectoryPoint(2350, 122.042671335029),
    Boardcore::TrajectoryPoint(2360, 120.943186515677),
    Boardcore::TrajectoryPoint(2370, 119.839037364039),
    Boardcore::TrajectoryPoint(2380, 118.730556983724),
    Boardcore::TrajectoryPoint(2390, 117.617560141882),
    Boardcore::TrajectoryPoint(2400, 116.49936286669),
    Boardcore::TrajectoryPoint(2410, 115.376251231255),
    Boardcore::TrajectoryPoint(2420, 114.248027157746),
    Boardcore::TrajectoryPoint(2430, 113.114366740849),
    Boardcore::TrajectoryPoint(2440, 111.974844822659),
    Boardcore::TrajectoryPoint(2450, 110.829549497303),
    Boardcore::TrajectoryPoint(2460, 109.678237908682),
    Boardcore::TrajectoryPoint(2470, 108.520656841963),
    Boardcore::TrajectoryPoint(2480, 107.356542287236),
    Boardcore::TrajectoryPoint(2490, 106.185391209069),
    Boardcore::TrajectoryPoint(2500, 105.007151523694),
    Boardcore::TrajectoryPoint(2510, 103.821553388785),
    Boardcore::TrajectoryPoint(2520, 102.628288237219),
    Boardcore::TrajectoryPoint(2530, 101.427034151376),
    Boardcore::TrajectoryPoint(2540, 100.217455211151),
    Boardcore::TrajectoryPoint(2550, 98.9992007959139),
    Boardcore::TrajectoryPoint(2560, 97.7719048374565),
    Boardcore::TrajectoryPoint(2570, 96.5351850206672),
    Boardcore::TrajectoryPoint(2580, 95.2886419283365),
    Boardcore::TrajectoryPoint(2590, 94.0318581261491),
    Boardcore::TrajectoryPoint(2600, 92.7643584194594),
    Boardcore::TrajectoryPoint(2610, 91.4853435624654),
    Boardcore::TrajectoryPoint(2620, 90.1946277005053),
    Boardcore::TrajectoryPoint(2630, 88.8917041592579),
    Boardcore::TrajectoryPoint(2640, 87.5760421816459),
    Boardcore::TrajectoryPoint(2650, 86.2465834472043),
    Boardcore::TrajectoryPoint(2660, 84.9028376920497),
    Boardcore::TrajectoryPoint(2670, 83.54447299671),
    Boardcore::TrajectoryPoint(2680, 82.1699560464087),
    Boardcore::TrajectoryPoint(2690, 80.7790641125538),
    Boardcore::TrajectoryPoint(2700, 79.3705565504743),
    Boardcore::TrajectoryPoint(2710, 77.9436123171423),
    Boardcore::TrajectoryPoint(2720, 76.4968535422118),
    Boardcore::TrajectoryPoint(2730, 75.0297333004365),
    Boardcore::TrajectoryPoint(2740, 73.5399569793735),
    Boardcore::TrajectoryPoint(2750, 72.0268082929918),
    Boardcore::TrajectoryPoint(2760, 70.4887235893419),
    Boardcore::TrajectoryPoint(2770, 68.9238584318644),
    Boardcore::TrajectoryPoint(2780, 67.3301968806733),
    Boardcore::TrajectoryPoint(2790, 65.7055319531776),
    Boardcore::TrajectoryPoint(2800, 64.0474432888295),
    Boardcore::TrajectoryPoint(2810, 62.3532715443473),
    Boardcore::TrajectoryPoint(2820, 60.6200889510762),
    Boardcore::TrajectoryPoint(2830, 58.8446653497418),
    Boardcore::TrajectoryPoint(2840, 57.0217694874734),
    Boardcore::TrajectoryPoint(2850, 55.1483053423785),
    Boardcore::TrajectoryPoint(2860, 53.2170760525875),
    Boardcore::TrajectoryPoint(2870, 51.2227922436814),
    Boardcore::TrajectoryPoint(2880, 49.1573600267221),
    Boardcore::TrajectoryPoint(2890, 47.0112995156676),
    Boardcore::TrajectoryPoint(2900, 44.7734399924792),
    Boardcore::TrajectoryPoint(2910, 42.4273077049903),
    Boardcore::TrajectoryPoint(2920, 39.9558031649007),
    Boardcore::TrajectoryPoint(2930, 37.3332282127749),
    Boardcore::TrajectoryPoint(2940, 34.5253443024025),
    Boardcore::TrajectoryPoint(2950, 31.481686800338),
    Boardcore::TrajectoryPoint(2960, 28.1269660101857),
    Boardcore::TrajectoryPoint(2970, 24.3303741768815),
    Boardcore::TrajectoryPoint(2980, 19.8429353728919),
    Boardcore::TrajectoryPoint(2990, 14.0141201654314),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t1_open[] = {
    Boardcore::TrajectoryPoint(0, 475.966219691446),
    Boardcore::TrajectoryPoint(10, 473.768973368115),
    Boardcore::TrajectoryPoint(20, 471.570350514458),
    Boardcore::TrajectoryPoint(30, 469.362071173956),
    Boardcore::TrajectoryPoint(40, 467.14317971734),
    Boardcore::TrajectoryPoint(50, 464.92144172689),
    Boardcore::TrajectoryPoint(60, 462.681818875355),
    Boardcore::TrajectoryPoint(70, 460.442196023821),
    Boardcore::TrajectoryPoint(80, 458.18509467961),
    Boardcore::TrajectoryPoint(90, 455.924262958044),
    Boardcore::TrajectoryPoint(100, 453.651781801924),
    Boardcore::TrajectoryPoint(110, 451.369248414793),
    Boardcore::TrajectoryPoint(120, 449.080600075706),
    Boardcore::TrajectoryPoint(130, 446.775856234994),
    Boardcore::TrajectoryPoint(140, 444.470211489279),
    Boardcore::TrajectoryPoint(150, 442.142731705319),
    Boardcore::TrajectoryPoint(160, 439.815251921358),
    Boardcore::TrajectoryPoint(170, 437.468458309715),
    Boardcore::TrajectoryPoint(180, 435.117699642432),
    Boardcore::TrajectoryPoint(190, 432.751554260064),
    Boardcore::TrajectoryPoint(200, 430.376955527941),
    Boardcore::TrajectoryPoint(210, 427.990468788308),
    Boardcore::TrajectoryPoint(220, 425.59144973218),
    Boardcore::TrajectoryPoint(230, 423.183578180768),
    Boardcore::TrajectoryPoint(240, 420.759538579304),
    Boardcore::TrajectoryPoint(250, 418.329181533547),
    Boardcore::TrajectoryPoint(260, 415.879500267037),
    Boardcore::TrajectoryPoint(270, 413.425496205935),
    Boardcore::TrajectoryPoint(280, 410.949530264708),
    Boardcore::TrajectoryPoint(290, 408.470652946506),
    Boardcore::TrajectoryPoint(300, 405.967736380001),
    Boardcore::TrajectoryPoint(310, 403.462690664162),
    Boardcore::TrajectoryPoint(320, 400.932133466331),
    Boardcore::TrajectoryPoint(330, 398.399550813621),
    Boardcore::TrajectoryPoint(340, 395.840637739989),
    Boardcore::TrajectoryPoint(350, 393.279071361859),
    Boardcore::TrajectoryPoint(360, 390.691060673137),
    Boardcore::TrajectoryPoint(370, 388.098980298618),
    Boardcore::TrajectoryPoint(380, 385.481102425325),
    Boardcore::TrajectoryPoint(390, 382.856888650321),
    Boardcore::TrajectoryPoint(400, 380.208344772388),
    Boardcore::TrajectoryPoint(410, 377.550282952588),
    Boardcore::TrajectoryPoint(420, 374.870243487354),
    Boardcore::TrajectoryPoint(430, 372.176517131801),
    Boardcore::TrajectoryPoint(440, 369.464120123215),
    Boardcore::TrajectoryPoint(450, 366.732803740959),
    Boardcore::TrajectoryPoint(460, 363.987153142149),
    Boardcore::TrajectoryPoint(470, 361.700770122063),
    Boardcore::TrajectoryPoint(480, 359.575733248278),
    Boardcore::TrajectoryPoint(490, 357.478250726056),
    Boardcore::TrajectoryPoint(500, 355.387032066308),
    Boardcore::TrajectoryPoint(510, 353.321036709588),
    Boardcore::TrajectoryPoint(520, 351.266098937542),
    Boardcore::TrajectoryPoint(530, 349.229500266728),
    Boardcore::TrajectoryPoint(540, 347.211136291415),
    Boardcore::TrajectoryPoint(550, 345.203717506021),
    Boardcore::TrajectoryPoint(560, 343.222038291101),
    Boardcore::TrajectoryPoint(570, 341.248483162524),
    Boardcore::TrajectoryPoint(580, 339.298451196377),
    Boardcore::TrajectoryPoint(590, 337.36176008228),
    Boardcore::TrajectoryPoint(600, 335.439803463574),
    Boardcore::TrajectoryPoint(610, 333.539697757378),
    Boardcore::TrajectoryPoint(620, 331.648707094235),
    Boardcore::TrajectoryPoint(630, 329.78141405885),
    Boardcore::TrajectoryPoint(640, 327.926659658223),
    Boardcore::TrajectoryPoint(650, 326.085881311589),
    Boardcore::TrajectoryPoint(660, 324.266794807615),
    Boardcore::TrajectoryPoint(670, 322.457393440417),
    Boardcore::TrajectoryPoint(680, 320.667881932437),
    Boardcore::TrajectoryPoint(690, 318.893396146401),
    Boardcore::TrajectoryPoint(700, 317.128966636544),
    Boardcore::TrajectoryPoint(710, 315.388271138988),
    Boardcore::TrajectoryPoint(720, 313.657811607977),
    Boardcore::TrajectoryPoint(730, 311.940585341852),
    Boardcore::TrajectoryPoint(740, 310.243249439483),
    Boardcore::TrajectoryPoint(750, 308.555945935772),
    Boardcore::TrajectoryPoint(760, 306.88377439671),
    Boardcore::TrajectoryPoint(770, 305.228440140527),
    Boardcore::TrajectoryPoint(780, 303.583178290333),
    Boardcore::TrajectoryPoint(790, 301.953574747364),
    Boardcore::TrajectoryPoint(800, 300.339038166366),
    Boardcore::TrajectoryPoint(810, 298.734511046452),
    Boardcore::TrajectoryPoint(820, 297.145047745973),
    Boardcore::TrajectoryPoint(830, 295.56994340413),
    Boardcore::TrajectoryPoint(840, 294.004699539828),
    Boardcore::TrajectoryPoint(850, 292.453031259124),
    Boardcore::TrajectoryPoint(860, 290.915875439383),
    Boardcore::TrajectoryPoint(870, 289.388361367439),
    Boardcore::TrajectoryPoint(880, 287.87224058667),
    Boardcore::TrajectoryPoint(890, 286.371469138107),
    Boardcore::TrajectoryPoint(900, 284.880065843982),
    Boardcore::TrajectoryPoint(910, 283.398131268658),
    Boardcore::TrajectoryPoint(920, 281.931352077371),
    Boardcore::TrajectoryPoint(930, 280.474405324377),
    Boardcore::TrajectoryPoint(940, 279.026581408843),
    Boardcore::TrajectoryPoint(950, 277.590205643384),
    Boardcore::TrajectoryPoint(960, 276.166050612954),
    Boardcore::TrajectoryPoint(970, 274.750647152693),
    Boardcore::TrajectoryPoint(980, 273.344022137587),
    Boardcore::TrajectoryPoint(990, 271.949792813833),
    Boardcore::TrajectoryPoint(1000, 270.565137382985),
    Boardcore::TrajectoryPoint(1010, 269.188853859534),
    Boardcore::TrajectoryPoint(1020, 267.820936126869),
    Boardcore::TrajectoryPoint(1030, 266.465025394389),
    Boardcore::TrajectoryPoint(1040, 265.117436439403),
    Boardcore::TrajectoryPoint(1050, 263.77778773937),
    Boardcore::TrajectoryPoint(1060, 262.446048615782),
    Boardcore::TrajectoryPoint(1070, 261.124971993736),
    Boardcore::TrajectoryPoint(1080, 259.811994113638),
    Boardcore::TrajectoryPoint(1090, 258.506493601316),
    Boardcore::TrajectoryPoint(1100, 257.208421987914),
    Boardcore::TrajectoryPoint(1110, 255.919012914308),
    Boardcore::TrajectoryPoint(1120, 254.638216785869),
    Boardcore::TrajectoryPoint(1130, 253.364419690565),
    Boardcore::TrajectoryPoint(1140, 252.097560685605),
    Boardcore::TrajectoryPoint(1150, 250.837572487614),
    Boardcore::TrajectoryPoint(1160, 249.585959760672),
    Boardcore::TrajectoryPoint(1170, 248.341493053432),
    Boardcore::TrajectoryPoint(1180, 247.103473959194),
    Boardcore::TrajectoryPoint(1190, 245.871828269665),
    Boardcore::TrajectoryPoint(1200, 244.646477396008),
    Boardcore::TrajectoryPoint(1210, 243.428160684699),
    Boardcore::TrajectoryPoint(1220, 242.216707374231),
    Boardcore::TrajectoryPoint(1230, 241.011140618851),
    Boardcore::TrajectoryPoint(1240, 239.811378760128),
    Boardcore::TrajectoryPoint(1250, 238.617337189275),
    Boardcore::TrajectoryPoint(1260, 237.428928701175),
    Boardcore::TrajectoryPoint(1270, 236.246712525604),
    Boardcore::TrajectoryPoint(1280, 235.070404939962),
    Boardcore::TrajectoryPoint(1290, 233.899343993823),
    Boardcore::TrajectoryPoint(1300, 232.733442683275),
    Boardcore::TrajectoryPoint(1310, 231.572612344399),
    Boardcore::TrajectoryPoint(1320, 230.416762894425),
    Boardcore::TrajectoryPoint(1330, 229.265803053143),
    Boardcore::TrajectoryPoint(1340, 228.119967139196),
    Boardcore::TrajectoryPoint(1350, 226.979216440296),
    Boardcore::TrajectoryPoint(1360, 225.842998086423),
    Boardcore::TrajectoryPoint(1370, 224.711223270838),
    Boardcore::TrajectoryPoint(1380, 223.583802525892),
    Boardcore::TrajectoryPoint(1390, 222.460645871144),
    Boardcore::TrajectoryPoint(1400, 221.341662948517),
    Boardcore::TrajectoryPoint(1410, 220.226763145418),
    Boardcore::TrajectoryPoint(1420, 219.115855706711),
    Boardcore::TrajectoryPoint(1430, 218.008849836337),
    Boardcore::TrajectoryPoint(1440, 216.905922876876),
    Boardcore::TrajectoryPoint(1450, 215.806755312119),
    Boardcore::TrajectoryPoint(1460, 214.711174424786),
    Boardcore::TrajectoryPoint(1470, 213.619093350561),
    Boardcore::TrajectoryPoint(1480, 212.530425376033),
    Boardcore::TrajectoryPoint(1490, 211.44508400375),
    Boardcore::TrajectoryPoint(1500, 210.362983010581),
    Boardcore::TrajectoryPoint(1510, 209.284036499904),
    Boardcore::TrajectoryPoint(1520, 208.208158948058),
    Boardcore::TrajectoryPoint(1530, 207.135265245514),
    Boardcore::TrajectoryPoint(1540, 206.065270733152),
    Boardcore::TrajectoryPoint(1550, 204.998091234021),
    Boardcore::TrajectoryPoint(1560, 203.933643080927),
    Boardcore::TrajectoryPoint(1570, 202.871843140165),
    Boardcore::TrajectoryPoint(1580, 201.812608831697),
    Boardcore::TrajectoryPoint(1590, 200.755858146046),
    Boardcore::TrajectoryPoint(1600, 199.701509658165),
    Boardcore::TrajectoryPoint(1610, 198.649482538509),
    Boardcore::TrajectoryPoint(1620, 197.599696561539),
    Boardcore::TrajectoryPoint(1630, 196.552072111852),
    Boardcore::TrajectoryPoint(1640, 195.506530188125),
    Boardcore::TrajectoryPoint(1650, 194.462992405051),
    Boardcore::TrajectoryPoint(1660, 193.421380993412),
    Boardcore::TrajectoryPoint(1670, 192.381618798464),
    Boardcore::TrajectoryPoint(1680, 191.343629276738),
    Boardcore::TrajectoryPoint(1690, 190.307336491406),
    Boardcore::TrajectoryPoint(1700, 189.272665106321),
    Boardcore::TrajectoryPoint(1710, 188.23954037884),
    Boardcore::TrajectoryPoint(1720, 187.207888151518),
    Boardcore::TrajectoryPoint(1730, 186.177634842788),
    Boardcore::TrajectoryPoint(1740, 185.148707436686),
    Boardcore::TrajectoryPoint(1750, 184.121033471716),
    Boardcore::TrajectoryPoint(1760, 183.094585010563),
    Boardcore::TrajectoryPoint(1770, 182.069283011376),
    Boardcore::TrajectoryPoint(1780, 181.045013483671),
    Boardcore::TrajectoryPoint(1790, 180.021705443748),
    Boardcore::TrajectoryPoint(1800, 178.999288419679),
    Boardcore::TrajectoryPoint(1810, 177.977692434619),
    Boardcore::TrajectoryPoint(1820, 176.95684798973),
    Boardcore::TrajectoryPoint(1830, 175.936686046751),
    Boardcore::TrajectoryPoint(1840, 174.917138010252),
    Boardcore::TrajectoryPoint(1850, 173.898184924115),
    Boardcore::TrajectoryPoint(1860, 172.879702869844),
    Boardcore::TrajectoryPoint(1870, 171.861618573509),
    Boardcore::TrajectoryPoint(1880, 170.8438646148),
    Boardcore::TrajectoryPoint(1890, 169.826373933084),
    Boardcore::TrajectoryPoint(1900, 168.809079807271),
    Boardcore::TrajectoryPoint(1910, 167.791923038055),
    Boardcore::TrajectoryPoint(1920, 166.774817153091),
    Boardcore::TrajectoryPoint(1930, 165.757693328416),
    Boardcore::TrajectoryPoint(1940, 164.740485655975),
    Boardcore::TrajectoryPoint(1950, 163.723128467793),
    Boardcore::TrajectoryPoint(1960, 162.705515703818),
    Boardcore::TrajectoryPoint(1970, 161.687602035978),
    Boardcore::TrajectoryPoint(1980, 160.669324424041),
    Boardcore::TrajectoryPoint(1990, 159.650617632626),
    Boardcore::TrajectoryPoint(2000, 158.631346324286),
    Boardcore::TrajectoryPoint(2010, 157.611472893085),
    Boardcore::TrajectoryPoint(2020, 156.590954675719),
    Boardcore::TrajectoryPoint(2030, 155.569722004218),
    Boardcore::TrajectoryPoint(2040, 154.54756474443),
    Boardcore::TrajectoryPoint(2050, 153.524545196868),
    Boardcore::TrajectoryPoint(2060, 152.500597947565),
    Boardcore::TrajectoryPoint(2070, 151.475514613892),
    Boardcore::TrajectoryPoint(2080, 150.449289614955),
    Boardcore::TrajectoryPoint(2090, 149.421916401541),
    Boardcore::TrajectoryPoint(2100, 148.393160260744),
    Boardcore::TrajectoryPoint(2110, 147.363009861555),
    Boardcore::TrajectoryPoint(2120, 146.331487254866),
    Boardcore::TrajectoryPoint(2130, 145.298259638056),
    Boardcore::TrajectoryPoint(2140, 144.2634460019),
    Boardcore::TrajectoryPoint(2150, 143.22695603144),
    Boardcore::TrajectoryPoint(2160, 142.188485948456),
    Boardcore::TrajectoryPoint(2170, 141.148250884009),
    Boardcore::TrajectoryPoint(2180, 140.10585572565),
    Boardcore::TrajectoryPoint(2190, 139.06142088331),
    Boardcore::TrajectoryPoint(2200, 138.014771163557),
    Boardcore::TrajectoryPoint(2210, 136.965746656728),
    Boardcore::TrajectoryPoint(2220, 135.914414284298),
    Boardcore::TrajectoryPoint(2230, 134.860398436028),
    Boardcore::TrajectoryPoint(2240, 133.80393197379),
    Boardcore::TrajectoryPoint(2250, 132.744510466136),
    Boardcore::TrajectoryPoint(2260, 131.682434344422),
    Boardcore::TrajectoryPoint(2270, 130.61717927286),
    Boardcore::TrajectoryPoint(2280, 129.548992796296),
    Boardcore::TrajectoryPoint(2290, 128.477461628783),
    Boardcore::TrajectoryPoint(2300, 127.402637780356),
    Boardcore::TrajectoryPoint(2310, 126.324372219364),
    Boardcore::TrajectoryPoint(2320, 125.242356262705),
    Boardcore::TrajectoryPoint(2330, 124.156822296769),
    Boardcore::TrajectoryPoint(2340, 123.067088885405),
    Boardcore::TrajectoryPoint(2350, 121.973459491655),
    Boardcore::TrajectoryPoint(2360, 120.875726815272),
    Boardcore::TrajectoryPoint(2370, 119.773366755007),
    Boardcore::TrajectoryPoint(2380, 118.666652661406),
    Boardcore::TrajectoryPoint(2390, 117.555347902624),
    Boardcore::TrajectoryPoint(2400, 116.438859408875),
    Boardcore::TrajectoryPoint(2410, 115.317443478506),
    Boardcore::TrajectoryPoint(2420, 114.190892150313),
    Boardcore::TrajectoryPoint(2430, 113.058821845377),
    Boardcore::TrajectoryPoint(2440, 111.920925638802),
    Boardcore::TrajectoryPoint(2450, 110.777233109001),
    Boardcore::TrajectoryPoint(2460, 109.62750134947),
    Boardcore::TrajectoryPoint(2470, 108.471477107675),
    Boardcore::TrajectoryPoint(2480, 107.308866285265),
    Boardcore::TrajectoryPoint(2490, 106.13919994612),
    Boardcore::TrajectoryPoint(2500, 104.962448114283),
    Boardcore::TrajectoryPoint(2510, 103.778314957261),
    Boardcore::TrajectoryPoint(2520, 102.586491909511),
    Boardcore::TrajectoryPoint(2530, 101.386657063104),
    Boardcore::TrajectoryPoint(2540, 100.178474515104),
    Boardcore::TrajectoryPoint(2550, 98.9615936689565),
    Boardcore::TrajectoryPoint(2560, 97.7356484869244),
    Boardcore::TrajectoryPoint(2570, 96.5002566902979),
    Boardcore::TrajectoryPoint(2580, 95.2550189037861),
    Boardcore::TrajectoryPoint(2590, 93.9995177401334),
    Boardcore::TrajectoryPoint(2600, 92.7333168206215),
    Boardcore::TrajectoryPoint(2610, 91.4555452808791),
    Boardcore::TrajectoryPoint(2620, 90.1660426711074),
    Boardcore::TrajectoryPoint(2630, 88.8643098587121),
    Boardcore::TrajectoryPoint(2640, 87.5498161596119),
    Boardcore::TrajectoryPoint(2650, 86.2215440958649),
    Boardcore::TrajectoryPoint(2660, 84.8789198143042),
    Boardcore::TrajectoryPoint(2670, 83.5216543116068),
    Boardcore::TrajectoryPoint(2680, 82.1482517002228),
    Boardcore::TrajectoryPoint(2690, 80.7584122536479),
    Boardcore::TrajectoryPoint(2700, 79.3509705337147),
    Boardcore::TrajectoryPoint(2710, 77.9250321680497),
    Boardcore::TrajectoryPoint(2720, 76.4792902879894),
    Boardcore::TrajectoryPoint(2730, 75.0131622621751),
    Boardcore::TrajectoryPoint(2740, 73.5243207536319),
    Boardcore::TrajectoryPoint(2750, 72.012114738935),
    Boardcore::TrajectoryPoint(2760, 70.4749475424458),
    Boardcore::TrajectoryPoint(2770, 68.9109745438756),
    Boardcore::TrajectoryPoint(2780, 67.318179644812),
    Boardcore::TrajectoryPoint(2790, 65.6943557275696),
    Boardcore::TrajectoryPoint(2800, 64.0370823182519),
    Boardcore::TrajectoryPoint(2810, 62.3436999803528),
    Boardcore::TrajectoryPoint(2820, 60.6112808705457),
    Boardcore::TrajectoryPoint(2830, 58.8365947719023),
    Boardcore::TrajectoryPoint(2840, 57.0144298976883),
    Boardcore::TrajectoryPoint(2850, 55.1416491527541),
    Boardcore::TrajectoryPoint(2860, 53.211093880032),
    Boardcore::TrajectoryPoint(2870, 51.2174546939379),
    Boardcore::TrajectoryPoint(2880, 49.152637257559),
    Boardcore::TrajectoryPoint(2890, 47.0071612852901),
    Boardcore::TrajectoryPoint(2900, 44.7698557013905),
    Boardcore::TrajectoryPoint(2910, 42.4242573825965),
    Boardcore::TrajectoryPoint(2920, 39.9532525180878),
    Boardcore::TrajectoryPoint(2930, 37.3311420054061),
    Boardcore::TrajectoryPoint(2940, 34.5236940327285),
    Boardcore::TrajectoryPoint(2950, 31.4804322670134),
    Boardcore::TrajectoryPoint(2960, 28.1260653004882),
    Boardcore::TrajectoryPoint(2970, 24.3297904406767),
    Boardcore::TrajectoryPoint(2980, 19.8426175242942),
    Boardcore::TrajectoryPoint(2990, 14.0140083271597),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t2_open[] = {
    Boardcore::TrajectoryPoint(0, 473.576902505924),
    Boardcore::TrajectoryPoint(10, 471.403156513521),
    Boardcore::TrajectoryPoint(20, 469.218515885813),
    Boardcore::TrajectoryPoint(30, 467.030818880971),
    Boardcore::TrajectoryPoint(40, 464.834299300421),
    Boardcore::TrajectoryPoint(50, 462.626509619678),
    Boardcore::TrajectoryPoint(60, 460.416195287316),
    Boardcore::TrajectoryPoint(70, 458.187856573562),
    Boardcore::TrajectoryPoint(80, 455.959517859808),
    Boardcore::TrajectoryPoint(90, 453.71368707362),
    Boardcore::TrajectoryPoint(100, 451.464328557231),
    Boardcore::TrajectoryPoint(110, 449.202776759906),
    Boardcore::TrajectoryPoint(120, 446.931912636239),
    Boardcore::TrajectoryPoint(130, 444.653846792708),
    Boardcore::TrajectoryPoint(140, 442.360975565775),
    Boardcore::TrajectoryPoint(150, 440.06556087913),
    Boardcore::TrajectoryPoint(160, 437.750164669209),
    Boardcore::TrajectoryPoint(170, 435.434768459289),
    Boardcore::TrajectoryPoint(180, 433.098065913499),
    Boardcore::TrajectoryPoint(190, 430.759609726283),
    Boardcore::TrajectoryPoint(200, 428.40320048115),
    Boardcore::TrajectoryPoint(210, 426.041131435832),
    Boardcore::TrajectoryPoint(220, 423.664021107702),
    Boardcore::TrajectoryPoint(230, 421.27776762121),
    Boardcore::TrajectoryPoint(240, 418.878908165881),
    Boardcore::TrajectoryPoint(250, 416.467879090217),
    Boardcore::TrajectoryPoint(260, 414.046165475788),
    Boardcore::TrajectoryPoint(270, 411.60974918521),
    Boardcore::TrajectoryPoint(280, 409.16401581857),
    Boardcore::TrajectoryPoint(290, 406.701579243071),
    Boardcore::TrajectoryPoint(300, 404.230596128855),
    Boardcore::TrajectoryPoint(310, 401.741483730096),
    Boardcore::TrajectoryPoint(320, 399.243952338846),
    Boardcore::TrajectoryPoint(330, 396.727485024392),
    Boardcore::TrajectoryPoint(340, 394.202033844353),
    Boardcore::TrajectoryPoint(350, 391.657507815678),
    Boardcore::TrajectoryPoint(360, 389.102687560054),
    Boardcore::TrajectoryPoint(370, 386.529373089425),
    Boardcore::TrajectoryPoint(380, 383.943651528057),
    Boardcore::TrajectoryPoint(390, 381.34079165894),
    Boardcore::TrajectoryPoint(400, 378.72254804015),
    Boardcore::TrajectoryPoint(410, 376.089357205342),
    Boardcore::TrajectoryPoint(420, 373.436876230083),
    Boardcore::TrajectoryPoint(430, 370.772538781228),
    Boardcore::TrajectoryPoint(440, 368.084004087701),
    Boardcore::TrajectoryPoint(450, 365.387672729278),
    Boardcore::TrajectoryPoint(460, 362.661159841617),
    Boardcore::TrajectoryPoint(470, 359.998807212132),
    Boardcore::TrajectoryPoint(480, 357.908599441223),
    Boardcore::TrajectoryPoint(490, 355.827524564623),
    Boardcore::TrajectoryPoint(500, 353.766504953142),
    Boardcore::TrajectoryPoint(510, 351.721185176283),
    Boardcore::TrajectoryPoint(520, 349.68925701354),
    Boardcore::TrajectoryPoint(530, 347.679998561459),
    Boardcore::TrajectoryPoint(540, 345.678310875964),
    Boardcore::TrajectoryPoint(550, 343.703897880091),
    Boardcore::TrajectoryPoint(560, 341.738716247092),
    Boardcore::TrajectoryPoint(570, 339.792570039108),
    Boardcore::TrajectoryPoint(580, 337.863776943574),
    Boardcore::TrajectoryPoint(590, 335.945484985267),
    Boardcore::TrajectoryPoint(600, 334.05282501477),
    Boardcore::TrajectoryPoint(610, 332.16903700624),
    Boardcore::TrajectoryPoint(620, 330.305020734741),
    Boardcore::TrajectoryPoint(630, 328.457048625364),
    Boardcore::TrajectoryPoint(640, 326.619378025119),
    Boardcore::TrajectoryPoint(650, 324.806678726085),
    Boardcore::TrajectoryPoint(660, 323.003434145043),
    Boardcore::TrajectoryPoint(670, 321.216736772472),
    Boardcore::TrajectoryPoint(680, 319.448048835359),
    Boardcore::TrajectoryPoint(690, 317.689197322152),
    Boardcore::TrajectoryPoint(700, 315.951074726848),
    Boardcore::TrajectoryPoint(710, 314.225871168629),
    Boardcore::TrajectoryPoint(720, 312.511114430814),
    Boardcore::TrajectoryPoint(730, 310.818735888578),
    Boardcore::TrajectoryPoint(740, 309.136196952216),
    Boardcore::TrajectoryPoint(750, 307.466318329876),
    Boardcore::TrajectoryPoint(760, 305.815484643834),
    Boardcore::TrajectoryPoint(770, 304.174546774521),
    Boardcore::TrajectoryPoint(780, 302.547094539143),
    Boardcore::TrajectoryPoint(790, 300.936650586179),
    Boardcore::TrajectoryPoint(800, 299.336056223153),
    Boardcore::TrajectoryPoint(810, 297.748632130778),
    Boardcore::TrajectoryPoint(820, 296.177259416318),
    Boardcore::TrajectoryPoint(830, 294.615603837136),
    Boardcore::TrajectoryPoint(840, 293.06588745375),
    Boardcore::TrajectoryPoint(850, 291.532146385233),
    Boardcore::TrajectoryPoint(860, 290.007919599839),
    Boardcore::TrajectoryPoint(870, 288.493684169188),
    Boardcore::TrajectoryPoint(880, 286.99605140318),
    Boardcore::TrajectoryPoint(890, 285.50767427043),
    Boardcore::TrajectoryPoint(900, 284.028658599303),
    Boardcore::TrajectoryPoint(910, 282.563696553704),
    Boardcore::TrajectoryPoint(920, 281.10955103029),
    Boardcore::TrajectoryPoint(930, 279.664434673047),
    Boardcore::TrajectoryPoint(940, 278.229847632718),
    Boardcore::TrajectoryPoint(950, 276.808301492567),
    Boardcore::TrajectoryPoint(960, 275.395425630145),
    Boardcore::TrajectoryPoint(970, 273.991251525886),
    Boardcore::TrajectoryPoint(980, 272.598788306198),
    Boardcore::TrajectoryPoint(990, 271.216508503537),
    Boardcore::TrajectoryPoint(1000, 269.842534745364),
    Boardcore::TrajectoryPoint(1010, 268.476865043878),
    Boardcore::TrajectoryPoint(1020, 267.122716562349),
    Boardcore::TrajectoryPoint(1030, 265.777319971955),
    Boardcore::TrajectoryPoint(1040, 264.439811230274),
    Boardcore::TrajectoryPoint(1050, 263.110163292387),
    Boardcore::TrajectoryPoint(1060, 261.790859207586),
    Boardcore::TrajectoryPoint(1070, 260.479933184578),
    Boardcore::TrajectoryPoint(1080, 259.176443715627),
    Boardcore::TrajectoryPoint(1090, 257.88034549024),
    Boardcore::TrajectoryPoint(1100, 256.592729838513),
    Boardcore::TrajectoryPoint(1110, 255.313881310073),
    Boardcore::TrajectoryPoint(1120, 254.042000904604),
    Boardcore::TrajectoryPoint(1130, 252.777030401923),
    Boardcore::TrajectoryPoint(1140, 251.518905129525),
    Boardcore::TrajectoryPoint(1150, 250.269125573729),
    Boardcore::TrajectoryPoint(1160, 249.026510268671),
    Boardcore::TrajectoryPoint(1170, 247.790322414437),
    Boardcore::TrajectoryPoint(1180, 246.56049003613),
    Boardcore::TrajectoryPoint(1190, 245.336936679765),
    Boardcore::TrajectoryPoint(1200, 244.120502273066),
    Boardcore::TrajectoryPoint(1210, 242.910846064343),
    Boardcore::TrajectoryPoint(1220, 241.707064937345),
    Boardcore::TrajectoryPoint(1230, 240.50907905266),
    Boardcore::TrajectoryPoint(1240, 239.316805536856),
    Boardcore::TrajectoryPoint(1250, 238.130158839442),
    Boardcore::TrajectoryPoint(1260, 236.949894670762),
    Boardcore::TrajectoryPoint(1270, 235.775358869192),
    Boardcore::TrajectoryPoint(1280, 234.606066703178),
    Boardcore::TrajectoryPoint(1290, 233.441932576201),
    Boardcore::TrajectoryPoint(1300, 232.282869165191),
    Boardcore::TrajectoryPoint(1310, 231.128787664483),
    Boardcore::TrajectoryPoint(1320, 229.97959801001),
    Boardcore::TrajectoryPoint(1330, 228.835804474488),
    Boardcore::TrajectoryPoint(1340, 227.696842818358),
    Boardcore::TrajectoryPoint(1350, 226.562418075524),
    Boardcore::TrajectoryPoint(1360, 225.432442475703),
    Boardcore::TrajectoryPoint(1370, 224.306827538533),
    Boardcore::TrajectoryPoint(1380, 223.185484224035),
    Boardcore::TrajectoryPoint(1390, 222.068323070057),
    Boardcore::TrajectoryPoint(1400, 220.955254317615),
    Boardcore::TrajectoryPoint(1410, 219.846188024996),
    Boardcore::TrajectoryPoint(1420, 218.74126377688),
    Boardcore::TrajectoryPoint(1430, 217.640290335741),
    Boardcore::TrajectoryPoint(1440, 216.543002122364),
    Boardcore::TrajectoryPoint(1450, 215.449312893558),
    Boardcore::TrajectoryPoint(1460, 214.359136453045),
    Boardcore::TrajectoryPoint(1470, 213.272386725456),
    Boardcore::TrajectoryPoint(1480, 212.188977823037),
    Boardcore::TrajectoryPoint(1490, 211.1088241056),
    Boardcore::TrajectoryPoint(1500, 210.031840234233),
    Boardcore::TrajectoryPoint(1510, 208.957941219214),
    Boardcore::TrajectoryPoint(1520, 207.887042462589),
    Boardcore::TrajectoryPoint(1530, 206.819059795787),
    Boardcore::TrajectoryPoint(1540, 205.75390951268),
    Boardcore::TrajectoryPoint(1550, 204.691508398394),
    Boardcore::TrajectoryPoint(1560, 203.631773754241),
    Boardcore::TrajectoryPoint(1570, 202.57462341902),
    Boardcore::TrajectoryPoint(1580, 201.519975787008),
    Boardcore::TrajectoryPoint(1590, 200.467749822869),
    Boardcore::TrajectoryPoint(1600, 199.417865073733),
    Boardcore::TrajectoryPoint(1610, 198.370241678652),
    Boardcore::TrajectoryPoint(1620, 197.324800375658),
    Boardcore::TrajectoryPoint(1630, 196.281462506591),
    Boardcore::TrajectoryPoint(1640, 195.240150019878),
    Boardcore::TrajectoryPoint(1650, 194.200785471431),
    Boardcore::TrajectoryPoint(1660, 193.163292023807),
    Boardcore::TrajectoryPoint(1670, 192.127593443768),
    Boardcore::TrajectoryPoint(1680, 191.093614098373),
    Boardcore::TrajectoryPoint(1690, 190.061278949713),
    Boardcore::TrajectoryPoint(1700, 189.030513548404),
    Boardcore::TrajectoryPoint(1710, 188.001244025936),
    Boardcore::TrajectoryPoint(1720, 186.973397085973),
    Boardcore::TrajectoryPoint(1730, 185.946899994685),
    Boardcore::TrajectoryPoint(1740, 184.921680570189),
    Boardcore::TrajectoryPoint(1750, 183.897667171188),
    Boardcore::TrajectoryPoint(1760, 182.874788684849),
    Boardcore::TrajectoryPoint(1770, 181.853006247745),
    Boardcore::TrajectoryPoint(1780, 180.832262879001),
    Boardcore::TrajectoryPoint(1790, 179.812436388566),
    Boardcore::TrajectoryPoint(1800, 178.793457073028),
    Boardcore::TrajectoryPoint(1810, 177.77525570845),
    Boardcore::TrajectoryPoint(1820, 176.757763533395),
    Boardcore::TrajectoryPoint(1830, 175.740912231608),
    Boardcore::TrajectoryPoint(1840, 174.724633914409),
    Boardcore::TrajectoryPoint(1850, 173.708874406281),
    Boardcore::TrajectoryPoint(1860, 172.693582129372),
    Boardcore::TrajectoryPoint(1870, 171.678648551304),
    Boardcore::TrajectoryPoint(1880, 170.66400690941),
    Boardcore::TrajectoryPoint(1890, 169.649590785659),
    Boardcore::TrajectoryPoint(1900, 168.635334086769),
    Boardcore::TrajectoryPoint(1910, 167.621172230839),
    Boardcore::TrajectoryPoint(1920, 166.60702952264),
    Boardcore::TrajectoryPoint(1930, 165.592833453365),
    Boardcore::TrajectoryPoint(1940, 164.578518691954),
    Boardcore::TrajectoryPoint(1950, 163.56402013351),
    Boardcore::TrajectoryPoint(1960, 162.54924460468),
    Boardcore::TrajectoryPoint(1970, 161.534119813178),
    Boardcore::TrajectoryPoint(1980, 160.518598363534),
    Boardcore::TrajectoryPoint(1990, 159.502615533925),
    Boardcore::TrajectoryPoint(2000, 158.486062048108),
    Boardcore::TrajectoryPoint(2010, 157.468846174725),
    Boardcore::TrajectoryPoint(2020, 156.45095476683),
    Boardcore::TrajectoryPoint(2030, 155.43232313989),
    Boardcore::TrajectoryPoint(2040, 154.412761453868),
    Boardcore::TrajectoryPoint(2050, 153.392275251589),
    Boardcore::TrajectoryPoint(2060, 152.370832400188),
    Boardcore::TrajectoryPoint(2070, 151.348266268721),
    Boardcore::TrajectoryPoint(2080, 150.324484704538),
    Boardcore::TrajectoryPoint(2090, 149.299527229795),
    Boardcore::TrajectoryPoint(2100, 148.273205985672),
    Boardcore::TrajectoryPoint(2110, 147.245412504739),
    Boardcore::TrajectoryPoint(2120, 146.216220288898),
    Boardcore::TrajectoryPoint(2130, 145.185346164204),
    Boardcore::TrajectoryPoint(2140, 144.152806149423),
    Boardcore::TrajectoryPoint(2150, 143.118619463994),
    Boardcore::TrajectoryPoint(2160, 142.08236748614),
    Boardcore::TrajectoryPoint(2170, 141.044325784426),
    Boardcore::TrajectoryPoint(2180, 140.004154010307),
    Boardcore::TrajectoryPoint(2190, 138.961858906594),
    Boardcore::TrajectoryPoint(2200, 137.917382738781),
    Boardcore::TrajectoryPoint(2210, 136.870445510846),
    Boardcore::TrajectoryPoint(2220, 135.821236956575),
    Boardcore::TrajectoryPoint(2230, 134.769257057052),
    Boardcore::TrajectoryPoint(2240, 133.714864863761),
    Boardcore::TrajectoryPoint(2250, 132.657429067147),
    Boardcore::TrajectoryPoint(2260, 131.597377918085),
    Boardcore::TrajectoryPoint(2270, 130.534059373755),
    Boardcore::TrajectoryPoint(2280, 129.467848880154),
    Boardcore::TrajectoryPoint(2290, 128.398206070817),
    Boardcore::TrajectoryPoint(2300, 127.325309563885),
    Boardcore::TrajectoryPoint(2310, 126.248885167628),
    Boardcore::TrajectoryPoint(2320, 125.168748290935),
    Boardcore::TrajectoryPoint(2330, 124.085067943743),
    Boardcore::TrajectoryPoint(2340, 122.997107043969),
    Boardcore::TrajectoryPoint(2350, 121.905286574646),
    Boardcore::TrajectoryPoint(2360, 120.809278309844),
    Boardcore::TrajectoryPoint(2370, 119.708679747891),
    Boardcore::TrajectoryPoint(2380, 118.603704711191),
    Boardcore::TrajectoryPoint(2390, 117.494055761647),
    Boardcore::TrajectoryPoint(2400, 116.379259410383),
    Boardcore::TrajectoryPoint(2410, 115.25951312629),
    Boardcore::TrajectoryPoint(2420, 114.134608855084),
    Boardcore::TrajectoryPoint(2430, 113.00410379968),
    Boardcore::TrajectoryPoint(2440, 111.867808407591),
    Boardcore::TrajectoryPoint(2450, 110.725694147217),
    Boardcore::TrajectoryPoint(2460, 109.577518063357),
    Boardcore::TrajectoryPoint(2470, 108.423026867086),
    Boardcore::TrajectoryPoint(2480, 107.261870886002),
    Boardcore::TrajectoryPoint(2490, 106.093692261303),
    Boardcore::TrajectoryPoint(2500, 104.918405647046),
    Boardcore::TrajectoryPoint(2510, 103.735715203871),
    Boardcore::TrajectoryPoint(2520, 102.545312367923),
    Boardcore::TrajectoryPoint(2530, 101.346875240843),
    Boardcore::TrajectoryPoint(2540, 100.140067936521),
    Boardcore::TrajectoryPoint(2550, 98.9245398819414),
    Boardcore::TrajectoryPoint(2560, 97.6999250691179),
    Boardcore::TrajectoryPoint(2570, 96.4658412548597),
    Boardcore::TrajectoryPoint(2580, 95.2218891047597),
    Boardcore::TrajectoryPoint(2590, 93.9676512774487),
    Boardcore::TrajectoryPoint(2600, 92.7026914447687),
    Boardcore::TrajectoryPoint(2610, 91.4261829161879),
    Boardcore::TrajectoryPoint(2620, 90.1378753682649),
    Boardcore::TrajectoryPoint(2630, 88.8373154575975),
    Boardcore::TrajectoryPoint(2640, 87.5239725712598),
    Boardcore::TrajectoryPoint(2650, 86.1968695944717),
    Boardcore::TrajectoryPoint(2660, 84.8553500649405),
    Boardcore::TrajectoryPoint(2670, 83.4991673900817),
    Boardcore::TrajectoryPoint(2680, 82.126862658999),
    Boardcore::TrajectoryPoint(2690, 80.7380600744877),
    Boardcore::TrajectoryPoint(2700, 79.331668488599),
    Boardcore::TrajectoryPoint(2710, 77.9067211012118),
    Boardcore::TrajectoryPoint(2720, 76.4619811651284),
    Boardcore::TrajectoryPoint(2730, 74.9968307817797),
    Boardcore::TrajectoryPoint(2740, 73.5089103104229),
    Boardcore::TrajectoryPoint(2750, 71.9976331587529),
    Boardcore::TrajectoryPoint(2760, 70.4613700452898),
    Boardcore::TrajectoryPoint(2770, 68.898276168656),
    Boardcore::TrajectoryPoint(2780, 67.3063352740002),
    Boardcore::TrajectoryPoint(2790, 65.6833401101246),
    Boardcore::TrajectoryPoint(2800, 64.0268700909025),
    Boardcore::TrajectoryPoint(2810, 62.3342656873004),
    Boardcore::TrajectoryPoint(2820, 60.6025989816356),
    Boardcore::TrajectoryPoint(2830, 58.8286396992956),
    Boardcore::TrajectoryPoint(2840, 57.0071952585478),
    Boardcore::TrajectoryPoint(2850, 55.1350880401615),
    Boardcore::TrajectoryPoint(2860, 53.2051970780797),
    Boardcore::TrajectoryPoint(2870, 51.2121932434966),
    Boardcore::TrajectoryPoint(2880, 49.1479817575547),
    Boardcore::TrajectoryPoint(2890, 47.0030819401451),
    Boardcore::TrajectoryPoint(2900, 44.7663223620547),
    Boardcore::TrajectoryPoint(2910, 42.4212503821809),
    Boardcore::TrajectoryPoint(2920, 39.9507380627055),
    Boardcore::TrajectoryPoint(2930, 37.3290853709413),
    Boardcore::TrajectoryPoint(2940, 34.5220671351363),
    Boardcore::TrajectoryPoint(2950, 31.4791954843358),
    Boardcore::TrajectoryPoint(2960, 28.1251773225894),
    Boardcore::TrajectoryPoint(2970, 24.3292149483238),
    Boardcore::TrajectoryPoint(2980, 19.842304160382),
    Boardcore::TrajectoryPoint(2990, 14.0138980654347),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t3_open[] = {
    Boardcore::TrajectoryPoint(0, 471.298349939231),
    Boardcore::TrajectoryPoint(10, 469.119867407005),
    Boardcore::TrajectoryPoint(20, 466.941384874778),
    Boardcore::TrajectoryPoint(30, 464.749419530194),
    Boardcore::TrajectoryPoint(40, 462.551166888978),
    Boardcore::TrajectoryPoint(50, 460.345517081592),
    Boardcore::TrajectoryPoint(60, 458.126913391846),
    Boardcore::TrajectoryPoint(70, 455.906843532282),
    Boardcore::TrajectoryPoint(80, 453.667424535482),
    Boardcore::TrajectoryPoint(90, 451.428005538681),
    Boardcore::TrajectoryPoint(100, 449.171491256958),
    Boardcore::TrajectoryPoint(110, 446.910777939907),
    Boardcore::TrajectoryPoint(120, 444.637850944092),
    Boardcore::TrajectoryPoint(130, 442.355348897901),
    Boardcore::TrajectoryPoint(140, 440.065184527305),
    Boardcore::TrajectoryPoint(150, 437.760383271321),
    Boardcore::TrajectoryPoint(160, 435.452113377835),
    Boardcore::TrajectoryPoint(170, 433.124485646202),
    Boardcore::TrajectoryPoint(180, 430.79685791457),
    Boardcore::TrajectoryPoint(190, 428.446196985498),
    Boardcore::TrajectoryPoint(200, 426.095197973836),
    Boardcore::TrajectoryPoint(210, 423.723991050601),
    Boardcore::TrajectoryPoint(220, 421.34905762009),
    Boardcore::TrajectoryPoint(230, 418.95627057658),
    Boardcore::TrajectoryPoint(240, 416.556820412546),
    Boardcore::TrajectoryPoint(250, 414.141363181215),
    Boardcore::TrajectoryPoint(260, 411.716793903024),
    Boardcore::TrajectoryPoint(270, 409.27751698598),
    Boardcore::TrajectoryPoint(280, 406.827205204855),
    Boardcore::TrajectoryPoint(290, 404.362895925138),
    Boardcore::TrajectoryPoint(300, 401.886196246167),
    Boardcore::TrajectoryPoint(310, 399.395574716742),
    Boardcore::TrajectoryPoint(320, 396.891818681079),
    Boardcore::TrajectoryPoint(330, 394.373533466854),
    Boardcore::TrajectoryPoint(340, 391.842028429754),
    Boardcore::TrajectoryPoint(350, 389.294651875436),
    Boardcore::TrajectoryPoint(360, 386.734679815384),
    Boardcore::TrajectoryPoint(370, 384.156703009248),
    Boardcore::TrajectoryPoint(380, 381.567519263058),
    Boardcore::TrajectoryPoint(390, 378.95734660359),
    Boardcore::TrajectoryPoint(400, 376.338178521861),
    Boardcore::TrajectoryPoint(410, 373.694121850819),
    Boardcore::TrajectoryPoint(420, 371.044167367662),
    Boardcore::TrajectoryPoint(430, 368.364439629247),
    Boardcore::TrajectoryPoint(440, 365.679632983659),
    Boardcore::TrajectoryPoint(450, 362.96557412114),
    Boardcore::TrajectoryPoint(460, 360.428951235645),
    Boardcore::TrajectoryPoint(470, 358.343878818962),
    Boardcore::TrajectoryPoint(480, 356.272843881266),
    Boardcore::TrajectoryPoint(490, 354.216633011564),
    Boardcore::TrajectoryPoint(500, 352.180837040307),
    Boardcore::TrajectoryPoint(510, 350.153414244097),
    Boardcore::TrajectoryPoint(520, 348.153175951537),
    Boardcore::TrajectoryPoint(530, 346.160279701819),
    Boardcore::TrajectoryPoint(540, 344.189832121394),
    Boardcore::TrajectoryPoint(550, 342.232951685253),
    Boardcore::TrajectoryPoint(560, 340.29053248031),
    Boardcore::TrajectoryPoint(570, 338.369571585879),
    Boardcore::TrajectoryPoint(580, 336.457106954624),
    Boardcore::TrajectoryPoint(590, 334.569513666981),
    Boardcore::TrajectoryPoint(600, 332.692871115362),
    Boardcore::TrajectoryPoint(610, 330.831980100764),
    Boardcore::TrajectoryPoint(620, 328.990737760049),
    Boardcore::TrajectoryPoint(630, 327.158748922048),
    Boardcore::TrajectoryPoint(640, 325.349665521647),
    Boardcore::TrajectoryPoint(650, 323.552530579037),
    Boardcore::TrajectoryPoint(660, 321.768503547913),
    Boardcore::TrajectoryPoint(670, 320.005569684015),
    Boardcore::TrajectoryPoint(680, 318.25225280443),
    Boardcore::TrajectoryPoint(690, 316.516564554168),
    Boardcore::TrajectoryPoint(700, 314.796576338823),
    Boardcore::TrajectoryPoint(710, 313.086459811897),
    Boardcore::TrajectoryPoint(720, 311.396693844325),
    Boardcore::TrajectoryPoint(730, 309.71888095619),
    Boardcore::TrajectoryPoint(740, 308.051164500195),
    Boardcore::TrajectoryPoint(750, 306.404794904757),
    Boardcore::TrajectoryPoint(760, 304.768143859692),
    Boardcore::TrajectoryPoint(770, 303.142717270556),
    Boardcore::TrajectoryPoint(780, 301.536330507408),
    Boardcore::TrajectoryPoint(790, 299.939632578811),
    Boardcore::TrajectoryPoint(800, 298.354126980701),
    Boardcore::TrajectoryPoint(810, 296.786451049129),
    Boardcore::TrajectoryPoint(820, 295.228347903573),
    Boardcore::TrajectoryPoint(830, 293.680467480357),
    Boardcore::TrajectoryPoint(840, 292.150106609091),
    Boardcore::TrajectoryPoint(850, 290.629131487969),
    Boardcore::TrajectoryPoint(860, 289.117689846687),
    Boardcore::TrajectoryPoint(870, 287.62214151145),
    Boardcore::TrajectoryPoint(880, 286.13675499289),
    Boardcore::TrajectoryPoint(890, 284.660621622282),
    Boardcore::TrajectoryPoint(900, 283.197371866482),
    Boardcore::TrajectoryPoint(910, 281.745992008375),
    Boardcore::TrajectoryPoint(920, 280.303546612489),
    Boardcore::TrajectoryPoint(930, 278.870647508428),
    Boardcore::TrajectoryPoint(940, 277.451674627804),
    Boardcore::TrajectoryPoint(950, 276.041289739244),
    Boardcore::TrajectoryPoint(960, 274.639528978177),
    Boardcore::TrajectoryPoint(970, 273.248736779458),
    Boardcore::TrajectoryPoint(980, 271.8687959427),
    Boardcore::TrajectoryPoint(990, 270.497094394928),
    Boardcore::TrajectoryPoint(1000, 269.133634328904),
    Boardcore::TrajectoryPoint(1010, 267.781158259423),
    Boardcore::TrajectoryPoint(1020, 266.437916497461),
    Boardcore::TrajectoryPoint(1030, 265.102509390847),
    Boardcore::TrajectoryPoint(1040, 263.774913578425),
    Boardcore::TrajectoryPoint(1050, 262.457296996896),
    Boardcore::TrajectoryPoint(1060, 261.14838459131),
    Boardcore::TrajectoryPoint(1070, 259.846867240454),
    Boardcore::TrajectoryPoint(1080, 258.552702838796),
    Boardcore::TrajectoryPoint(1090, 257.266799968447),
    Boardcore::TrajectoryPoint(1100, 255.989860259758),
    Boardcore::TrajectoryPoint(1110, 254.719857171346),
    Boardcore::TrajectoryPoint(1120, 253.456735247744),
    Boardcore::TrajectoryPoint(1130, 252.200432467482),
    Boardcore::TrajectoryPoint(1140, 250.952410712813),
    Boardcore::TrajectoryPoint(1150, 249.711607124789),
    Boardcore::TrajectoryPoint(1160, 248.477210352987),
    Boardcore::TrajectoryPoint(1170, 247.249150691373),
    Boardcore::TrajectoryPoint(1180, 246.027353854387),
    Boardcore::TrajectoryPoint(1190, 244.812731048246),
    Boardcore::TrajectoryPoint(1200, 243.60483165204),
    Boardcore::TrajectoryPoint(1210, 242.402795490135),
    Boardcore::TrajectoryPoint(1220, 241.206544571362),
    Boardcore::TrajectoryPoint(1230, 240.015997785163),
    Boardcore::TrajectoryPoint(1240, 238.831071261563),
    Boardcore::TrajectoryPoint(1250, 237.652693484112),
    Boardcore::TrajectoryPoint(1260, 236.479888511216),
    Boardcore::TrajectoryPoint(1270, 235.312323898127),
    Boardcore::TrajectoryPoint(1280, 234.149915477977),
    Boardcore::TrajectoryPoint(1290, 232.9925772894),
    Boardcore::TrajectoryPoint(1300, 231.840221823357),
    Boardcore::TrajectoryPoint(1310, 230.692789862205),
    Boardcore::TrajectoryPoint(1320, 229.550948653816),
    Boardcore::TrajectoryPoint(1330, 228.413734537409),
    Boardcore::TrajectoryPoint(1340, 227.281061721964),
    Boardcore::TrajectoryPoint(1350, 226.152843489165),
    Boardcore::TrajectoryPoint(1360, 225.028992360368),
    Boardcore::TrajectoryPoint(1370, 223.909420249478),
    Boardcore::TrajectoryPoint(1380, 222.794038602732),
    Boardcore::TrajectoryPoint(1390, 221.682758526296),
    Boardcore::TrajectoryPoint(1400, 220.57560908154),
    Boardcore::TrajectoryPoint(1410, 219.472679229846),
    Boardcore::TrajectoryPoint(1420, 218.373531577607),
    Boardcore::TrajectoryPoint(1430, 217.278080659474),
    Boardcore::TrajectoryPoint(1440, 216.186240940885),
    Boardcore::TrajectoryPoint(1450, 215.097926901754),
    Boardcore::TrajectoryPoint(1460, 214.013053112219),
    Boardcore::TrajectoryPoint(1470, 212.931534301035),
    Boardcore::TrajectoryPoint(1480, 211.853285417151),
    Boardcore::TrajectoryPoint(1490, 210.778221684965),
    Boardcore::TrajectoryPoint(1500, 209.706258653737),
    Boardcore::TrajectoryPoint(1510, 208.637312241591),
    Boardcore::TrajectoryPoint(1520, 207.571298774508),
    Boardcore::TrajectoryPoint(1530, 206.50813502069),
    Boardcore::TrajectoryPoint(1540, 205.447738220638),
    Boardcore::TrajectoryPoint(1550, 204.390026113283),
    Boardcore::TrajectoryPoint(1560, 203.334916958446),
    Boardcore::TrajectoryPoint(1570, 202.282329555938),
    Boardcore::TrajectoryPoint(1580, 201.232183261526),
    Boardcore::TrajectoryPoint(1590, 200.184398000028),
    Boardcore::TrajectoryPoint(1600, 199.138894275751),
    Boardcore::TrajectoryPoint(1610, 198.095593180476),
    Boardcore::TrajectoryPoint(1620, 197.054416399185),
    Boardcore::TrajectoryPoint(1630, 196.015286213704),
    Boardcore::TrajectoryPoint(1640, 194.978125504425),
    Boardcore::TrajectoryPoint(1650, 193.942857750257),
    Boardcore::TrajectoryPoint(1660, 192.909407026955),
    Boardcore::TrajectoryPoint(1670, 191.877698003938),
    Boardcore::TrajectoryPoint(1680, 190.847655939733),
    Boardcore::TrajectoryPoint(1690, 189.819206676149),
    Boardcore::TrajectoryPoint(1700, 188.792276631278),
    Boardcore::TrajectoryPoint(1710, 187.766792791427),
    Boardcore::TrajectoryPoint(1720, 186.742682702053),
    Boardcore::TrajectoryPoint(1730, 185.719874457804),
    Boardcore::TrajectoryPoint(1740, 184.69829669171),
    Boardcore::TrajectoryPoint(1750, 183.677878563622),
    Boardcore::TrajectoryPoint(1760, 182.658549747941),
    Boardcore::TrajectoryPoint(1770, 181.640240420699),
    Boardcore::TrajectoryPoint(1780, 180.622910170856),
    Boardcore::TrajectoryPoint(1790, 179.606503527452),
    Boardcore::TrajectoryPoint(1800, 178.590901172202),
    Boardcore::TrajectoryPoint(1810, 177.576034615204),
    Boardcore::TrajectoryPoint(1820, 176.561835813872),
    Boardcore::TrajectoryPoint(1830, 175.54823715575),
    Boardcore::TrajectoryPoint(1840, 174.535171441037),
    Boardcore::TrajectoryPoint(1850, 173.52257186485),
    Boardcore::TrajectoryPoint(1860, 172.510398038097),
    Boardcore::TrajectoryPoint(1870, 171.498560428225),
    Boardcore::TrajectoryPoint(1880, 170.486977175919),
    Boardcore::TrajectoryPoint(1890, 169.475582489074),
    Boardcore::TrajectoryPoint(1900, 168.464310885922),
    Boardcore::TrajectoryPoint(1910, 167.453097175265),
    Boardcore::TrajectoryPoint(1920, 166.441866895329),
    Boardcore::TrajectoryPoint(1930, 165.430548435468),
    Boardcore::TrajectoryPoint(1940, 164.41907717367),
    Boardcore::TrajectoryPoint(1950, 163.407388553359),
    Boardcore::TrajectoryPoint(1960, 162.395405976952),
    Boardcore::TrajectoryPoint(1970, 161.383022721616),
    Boardcore::TrajectoryPoint(1980, 160.370210775864),
    Boardcore::TrajectoryPoint(1990, 159.356905917927),
    Boardcore::TrajectoryPoint(2000, 158.343027776145),
    Boardcore::TrajectoryPoint(2010, 157.328424755415),
    Boardcore::TrajectoryPoint(2020, 156.31311608424),
    Boardcore::TrajectoryPoint(2030, 155.297037531927),
    Boardcore::TrajectoryPoint(2040, 154.280035323701),
    Boardcore::TrajectoryPoint(2050, 153.262040230623),
    Boardcore::TrajectoryPoint(2060, 152.243060127982),
    Boardcore::TrajectoryPoint(2070, 151.222971873088),
    Boardcore::TrajectoryPoint(2080, 150.201593263821),
    Boardcore::TrajectoryPoint(2090, 149.179011603537),
    Boardcore::TrajectoryPoint(2100, 148.155087247232),
    Boardcore::TrajectoryPoint(2110, 147.129611882424),
    Boardcore::TrajectoryPoint(2120, 146.102711781643),
    Boardcore::TrajectoryPoint(2130, 145.07415446885),
    Boardcore::TrajectoryPoint(2140, 144.04385087546),
    Boardcore::TrajectoryPoint(2150, 143.011896402002),
    Boardcore::TrajectoryPoint(2160, 141.977861549188),
    Boardcore::TrajectoryPoint(2170, 140.941977540445),
    Boardcore::TrajectoryPoint(2180, 139.903994586004),
    Boardcore::TrajectoryPoint(2190, 138.863804555568),
    Boardcore::TrajectoryPoint(2200, 137.821468175557),
    Boardcore::TrajectoryPoint(2210, 136.776584539177),
    Boardcore::TrajectoryPoint(2220, 135.729466847346),
    Boardcore::TrajectoryPoint(2230, 134.679490161356),
    Boardcore::TrajectoryPoint(2240, 133.627115595225),
    Boardcore::TrajectoryPoint(2250, 132.5716582),
    Boardcore::TrajectoryPoint(2260, 131.513597650322),
    Boardcore::TrajectoryPoint(2270, 130.452187771183),
    Boardcore::TrajectoryPoint(2280, 129.387922743414),
    Boardcore::TrajectoryPoint(2290, 128.320138265197),
    Boardcore::TrajectoryPoint(2300, 127.249139391604),
    Boardcore::TrajectoryPoint(2310, 126.17452698908),
    Boardcore::TrajectoryPoint(2320, 125.096240288281),
    Boardcore::TrajectoryPoint(2330, 124.014326512562),
    Boardcore::TrajectoryPoint(2340, 122.928168728732),
    Boardcore::TrajectoryPoint(2350, 121.838129425941),
    Boardcore::TrajectoryPoint(2360, 120.743818491823),
    Boardcore::TrajectoryPoint(2370, 119.64495446303),
    Boardcore::TrajectoryPoint(2380, 118.54169187317),
    Boardcore::TrajectoryPoint(2390, 117.433672864472),
    Boardcore::TrajectoryPoint(2400, 116.320542829891),
    Boardcore::TrajectoryPoint(2410, 115.202440725147),
    Boardcore::TrajectoryPoint(2420, 114.079158405918),
    Boardcore::TrajectoryPoint(2430, 112.950194314334),
    Boardcore::TrajectoryPoint(2440, 111.815475403649),
    Boardcore::TrajectoryPoint(2450, 110.67491544198),
    Boardcore::TrajectoryPoint(2460, 109.528271427049),
    Boardcore::TrajectoryPoint(2470, 108.375290034793),
    Boardcore::TrajectoryPoint(2480, 107.215566514153),
    Boardcore::TrajectoryPoint(2490, 106.048853115481),
    Boardcore::TrajectoryPoint(2500, 104.87500959317),
    Boardcore::TrajectoryPoint(2510, 103.693740101336),
    Boardcore::TrajectoryPoint(2520, 102.504736077911),
    Boardcore::TrajectoryPoint(2530, 101.307675633968),
    Boardcore::TrajectoryPoint(2540, 100.102222899884),
    Boardcore::TrajectoryPoint(2550, 98.8880273256509),
    Boardcore::TrajectoryPoint(2560, 97.6647229323288),
    Boardcore::TrajectoryPoint(2570, 96.4319275113827),
    Boardcore::TrajectoryPoint(2580, 95.1892417682807),
    Boardcore::TrajectoryPoint(2590, 93.936248406397),
    Boardcore::TrajectoryPoint(2600, 92.6725111468684),
    Boardcore::TrajectoryPoint(2610, 91.3972469801642),
    Boardcore::TrajectoryPoint(2620, 90.1101167089081),
    Boardcore::TrajectoryPoint(2630, 88.8107122693968),
    Boardcore::TrajectoryPoint(2640, 87.4985031180734),
    Boardcore::TrajectoryPoint(2650, 86.1725520314481),
    Boardcore::TrajectoryPoint(2660, 84.8321209029818),
    Boardcore::TrajectoryPoint(2670, 83.4770050533455),
    Boardcore::TrajectoryPoint(2680, 82.1057821051617),
    Boardcore::TrajectoryPoint(2690, 80.7180011024294),
    Boardcore::TrajectoryPoint(2700, 79.3126442865942),
    Boardcore::TrajectoryPoint(2710, 77.888673315895),
    Boardcore::TrajectoryPoint(2720, 76.4449206997305),
    Boardcore::TrajectoryPoint(2730, 74.9807337036722),
    Boardcore::TrajectoryPoint(2740, 73.4937207961689),
    Boardcore::TrajectoryPoint(2750, 71.9833589997412),
    Boardcore::TrajectoryPoint(2760, 70.4479868373564),
    Boardcore::TrajectoryPoint(2770, 68.8857593291269),
    Boardcore::TrajectoryPoint(2780, 67.294660065806),
    Boardcore::TrajectoryPoint(2790, 65.6724816642349),
    Boardcore::TrajectoryPoint(2800, 64.0168034271602),
    Boardcore::TrajectoryPoint(2810, 62.3249657337154),
    Boardcore::TrajectoryPoint(2820, 60.5940405921838),
    Boardcore::TrajectoryPoint(2830, 58.8207976702572),
    Boardcore::TrajectoryPoint(2840, 57.0000633352347),
    Boardcore::TrajectoryPoint(2850, 55.1286199821587),
    Boardcore::TrajectoryPoint(2860, 53.1993838323891),
    Boardcore::TrajectoryPoint(2870, 51.2070062765479),
    Boardcore::TrajectoryPoint(2880, 49.143392099741),
    Boardcore::TrajectoryPoint(2890, 46.9990602323191),
    Boardcore::TrajectoryPoint(2900, 44.7628388957542),
    Boardcore::TrajectoryPoint(2910, 42.4182857873722),
    Boardcore::TrajectoryPoint(2920, 39.9482590339176),
    Boardcore::TrajectoryPoint(2930, 37.3270576850087),
    Boardcore::TrajectoryPoint(2940, 34.5204631166138),
    Boardcore::TrajectoryPoint(2950, 31.4779760782228),
    Boardcore::TrajectoryPoint(2960, 28.1243018084368),
    Boardcore::TrajectoryPoint(2970, 24.3286475264132),
    Boardcore::TrajectoryPoint(2980, 19.8419951869066),
    Boardcore::TrajectoryPoint(2990, 14.0137893471542),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t4_open[] = {
    Boardcore::TrajectoryPoint(0, 469.040451230612),
    Boardcore::TrajectoryPoint(10, 466.864918440385),
    Boardcore::TrajectoryPoint(20, 464.676979756001),
    Boardcore::TrajectoryPoint(30, 462.488152287751),
    Boardcore::TrajectoryPoint(40, 460.286984275911),
    Boardcore::TrajectoryPoint(50, 458.078000758111),
    Boardcore::TrajectoryPoint(60, 455.862488193841),
    Boardcore::TrajectoryPoint(70, 453.632890747866),
    Boardcore::TrajectoryPoint(80, 451.402311934786),
    Boardcore::TrajectoryPoint(90, 449.151628200743),
    Boardcore::TrajectoryPoint(100, 446.900944466699),
    Boardcore::TrajectoryPoint(110, 444.632966419532),
    Boardcore::TrajectoryPoint(120, 442.360708930095),
    Boardcore::TrajectoryPoint(130, 440.07560322136),
    Boardcore::TrajectoryPoint(140, 437.781268741535),
    Boardcore::TrajectoryPoint(150, 435.478177904472),
    Boardcore::TrajectoryPoint(160, 433.161246735042),
    Boardcore::TrajectoryPoint(170, 430.839268011823),
    Boardcore::TrajectoryPoint(180, 428.499203254051),
    Boardcore::TrajectoryPoint(190, 426.157385875505),
    Boardcore::TrajectoryPoint(200, 423.793632654473),
    Boardcore::TrajectoryPoint(210, 421.42987943344),
    Boardcore::TrajectoryPoint(220, 419.0429595683),
    Boardcore::TrajectoryPoint(230, 416.654944212063),
    Boardcore::TrajectoryPoint(240, 414.245534908457),
    Boardcore::TrajectoryPoint(250, 411.832664079959),
    Boardcore::TrajectoryPoint(260, 409.399631593821),
    Boardcore::TrajectoryPoint(270, 406.961291372262),
    Boardcore::TrajectoryPoint(280, 404.503439971316),
    Boardcore::TrajectoryPoint(290, 402.03899487941),
    Boardcore::TrajectoryPoint(300, 399.555062909824),
    Boardcore::TrajectoryPoint(310, 397.063854883057),
    Boardcore::TrajectoryPoint(320, 394.552510538157),
    Boardcore::TrajectoryPoint(330, 392.033857831866),
    Boardcore::TrajectoryPoint(340, 389.493694596697),
    Boardcore::TrajectoryPoint(350, 386.946890626388),
    Boardcore::TrajectoryPoint(360, 384.376422369223),
    Boardcore::TrajectoryPoint(370, 381.800734479188),
    Boardcore::TrajectoryPoint(380, 379.198390158155),
    Boardcore::TrajectoryPoint(390, 376.592940869475),
    Boardcore::TrajectoryPoint(400, 373.957176262672),
    Boardcore::TrajectoryPoint(410, 371.317249841912),
    Boardcore::TrajectoryPoint(420, 368.650233415018),
    Boardcore::TrajectoryPoint(430, 365.973999760116),
    Boardcore::TrajectoryPoint(440, 363.274880625636),
    Boardcore::TrajectoryPoint(450, 360.864016496465),
    Boardcore::TrajectoryPoint(460, 358.783918217054),
    Boardcore::TrajectoryPoint(470, 356.722821085131),
    Boardcore::TrajectoryPoint(480, 354.671259096506),
    Boardcore::TrajectoryPoint(490, 352.644894616121),
    Boardcore::TrajectoryPoint(500, 350.625256042535),
    Boardcore::TrajectoryPoint(510, 348.63051735176),
    Boardcore::TrajectoryPoint(520, 346.646335497899),
    Boardcore::TrajectoryPoint(530, 344.67969846836),
    Boardcore::TrajectoryPoint(540, 342.731049413811),
    Boardcore::TrajectoryPoint(550, 340.792204275759),
    Boardcore::TrajectoryPoint(560, 338.879012278029),
    Boardcore::TrajectoryPoint(570, 336.974074036189),
    Boardcore::TrajectoryPoint(580, 335.089640015837),
    Boardcore::TrajectoryPoint(590, 333.220088508986),
    Boardcore::TrajectoryPoint(600, 331.362176185972),
    Boardcore::TrajectoryPoint(610, 329.527613833662),
    Boardcore::TrajectoryPoint(620, 327.702067203261),
    Boardcore::TrajectoryPoint(630, 325.895649327659),
    Boardcore::TrajectoryPoint(640, 324.104579732001),
    Boardcore::TrajectoryPoint(650, 322.323083435345),
    Boardcore::TrajectoryPoint(660, 320.565862636394),
    Boardcore::TrajectoryPoint(670, 318.818039911641),
    Boardcore::TrajectoryPoint(680, 317.084651200727),
    Boardcore::TrajectoryPoint(690, 315.369840471869),
    Boardcore::TrajectoryPoint(700, 313.664695674896),
    Boardcore::TrajectoryPoint(710, 311.977042874328),
    Boardcore::TrajectoryPoint(720, 310.303920238994),
    Boardcore::TrajectoryPoint(730, 308.640605972661),
    Boardcore::TrajectoryPoint(740, 306.996299007649),
    Boardcore::TrajectoryPoint(750, 305.363900264792),
    Boardcore::TrajectoryPoint(760, 303.741339827888),
    Boardcore::TrajectoryPoint(770, 302.138014031501),
    Boardcore::TrajectoryPoint(780, 300.545178734515),
    Boardcore::TrajectoryPoint(790, 298.962114658499),
    Boardcore::TrajectoryPoint(800, 297.397461913551),
    Boardcore::TrajectoryPoint(810, 295.842877739427),
    Boardcore::TrajectoryPoint(820, 294.29791668644),
    Boardcore::TrajectoryPoint(830, 292.76970673111),
    Boardcore::TrajectoryPoint(840, 291.251949903412),
    Boardcore::TrajectoryPoint(850, 289.743602392398),
    Boardcore::TrajectoryPoint(860, 288.249696609485),
    Boardcore::TrajectoryPoint(870, 286.767267269704),
    Boardcore::TrajectoryPoint(880, 285.293981680506),
    Boardcore::TrajectoryPoint(890, 283.832341230366),
    Boardcore::TrajectoryPoint(900, 282.383693447667),
    Boardcore::TrajectoryPoint(910, 280.94388436038),
    Boardcore::TrajectoryPoint(920, 279.512978793018),
    Boardcore::TrajectoryPoint(930, 278.09614071352),
    Boardcore::TrajectoryPoint(940, 276.688211985295),
    Boardcore::TrajectoryPoint(950, 275.288828776486),
    Boardcore::TrajectoryPoint(960, 273.899614041587),
    Boardcore::TrajectoryPoint(970, 272.521977193105),
    Boardcore::TrajectoryPoint(980, 271.152511952373),
    Boardcore::TrajectoryPoint(990, 269.791224743396),
    Boardcore::TrajectoryPoint(1000, 268.440332613367),
    Boardcore::TrajectoryPoint(1010, 267.099209679202),
    Boardcore::TrajectoryPoint(1020, 265.765867387348),
    Boardcore::TrajectoryPoint(1030, 264.440286110223),
    Boardcore::TrajectoryPoint(1040, 263.124273232124),
    Boardcore::TrajectoryPoint(1050, 261.81733760241),
    Boardcore::TrajectoryPoint(1060, 260.517754811796),
    Boardcore::TrajectoryPoint(1070, 259.225486006378),
    Boardcore::TrajectoryPoint(1080, 257.941216401014),
    Boardcore::TrajectoryPoint(1090, 256.666148005712),
    Boardcore::TrajectoryPoint(1100, 255.39798410724),
    Boardcore::TrajectoryPoint(1110, 254.136672057291),
    Boardcore::TrajectoryPoint(1120, 252.882152526004),
    Boardcore::TrajectoryPoint(1130, 251.635814207134),
    Boardcore::TrajectoryPoint(1140, 250.39678378848),
    Boardcore::TrajectoryPoint(1150, 249.16413905399),
    Boardcore::TrajectoryPoint(1160, 247.937812602464),
    Boardcore::TrajectoryPoint(1170, 246.717732350892),
    Boardcore::TrajectoryPoint(1180, 245.504851350715),
    Boardcore::TrajectoryPoint(1190, 244.29866949762),
    Boardcore::TrajectoryPoint(1200, 243.098338635641),
    Boardcore::TrajectoryPoint(1210, 241.90378265163),
    Boardcore::TrajectoryPoint(1220, 240.714922226007),
    Boardcore::TrajectoryPoint(1230, 239.53167519579),
    Boardcore::TrajectoryPoint(1240, 238.355119009725),
    Boardcore::TrajectoryPoint(1250, 237.184004811152),
    Boardcore::TrajectoryPoint(1260, 236.018127406833),
    Boardcore::TrajectoryPoint(1270, 234.857404082362),
    Boardcore::TrajectoryPoint(1280, 233.701750259481),
    Boardcore::TrajectoryPoint(1290, 232.551079745842),
    Boardcore::TrajectoryPoint(1300, 231.405553052456),
    Boardcore::TrajectoryPoint(1310, 230.265415598925),
    Boardcore::TrajectoryPoint(1320, 229.129908308422),
    Boardcore::TrajectoryPoint(1330, 227.998946511734),
    Boardcore::TrajectoryPoint(1340, 226.872444558499),
    Boardcore::TrajectoryPoint(1350, 225.750315986704),
    Boardcore::TrajectoryPoint(1360, 224.632473678031),
    Boardcore::TrajectoryPoint(1370, 223.518830000017),
    Boardcore::TrajectoryPoint(1380, 222.409296935974),
    Boardcore::TrajectoryPoint(1390, 221.304188912498),
    Boardcore::TrajectoryPoint(1400, 220.203032932572),
    Boardcore::TrajectoryPoint(1410, 219.105669794201),
    Boardcore::TrajectoryPoint(1420, 218.012014784962),
    Boardcore::TrajectoryPoint(1430, 216.921983088183),
    Boardcore::TrajectoryPoint(1440, 215.835489868495),
    Boardcore::TrajectoryPoint(1450, 214.752450349372),
    Boardcore::TrajectoryPoint(1460, 213.67277988325),
    Boardcore::TrajectoryPoint(1470, 212.596394014748),
    Boardcore::TrajectoryPoint(1480, 211.523208537515),
    Boardcore::TrajectoryPoint(1490, 210.45313954516),
    Boardcore::TrajectoryPoint(1500, 209.386103476713),
    Boardcore::TrajectoryPoint(1510, 208.322017157012),
    Boardcore::TrajectoryPoint(1520, 207.260797832404),
    Boardcore::TrajectoryPoint(1530, 206.202363202108),
    Boardcore::TrajectoryPoint(1540, 205.146640399083),
    Boardcore::TrajectoryPoint(1550, 204.093589316902),
    Boardcore::TrajectoryPoint(1560, 203.043061236609),
    Boardcore::TrajectoryPoint(1570, 201.994977671769),
    Boardcore::TrajectoryPoint(1580, 200.949260597988),
    Boardcore::TrajectoryPoint(1590, 199.905832469879),
    Boardcore::TrajectoryPoint(1600, 198.864616235202),
    Boardcore::TrajectoryPoint(1610, 197.825535346417),
    Boardcore::TrajectoryPoint(1620, 196.788513769818),
    Boardcore::TrajectoryPoint(1630, 195.753475992449),
    Boardcore::TrajectoryPoint(1640, 194.720352658097),
    Boardcore::TrajectoryPoint(1650, 193.689107228619),
    Boardcore::TrajectoryPoint(1660, 192.659625929184),
    Boardcore::TrajectoryPoint(1670, 191.63183431318),
    Boardcore::TrajectoryPoint(1680, 190.605658511759),
    Boardcore::TrajectoryPoint(1690, 189.581025227502),
    Boardcore::TrajectoryPoint(1700, 188.557861726983),
    Boardcore::TrajectoryPoint(1710, 187.536095832324),
    Boardcore::TrajectoryPoint(1720, 186.515655911822),
    Boardcore::TrajectoryPoint(1730, 185.496470869717),
    Boardcore::TrajectoryPoint(1740, 184.47847013518),
    Boardcore::TrajectoryPoint(1750, 183.461583650577),
    Boardcore::TrajectoryPoint(1760, 182.445741859072),
    Boardcore::TrajectoryPoint(1770, 181.430875691615),
    Boardcore::TrajectoryPoint(1780, 180.416916553379),
    Boardcore::TrajectoryPoint(1790, 179.403828677594),
    Boardcore::TrajectoryPoint(1800, 178.391544086313),
    Boardcore::TrajectoryPoint(1810, 177.379954048766),
    Boardcore::TrajectoryPoint(1820, 176.36899122321),
    Boardcore::TrajectoryPoint(1830, 175.358588683309),
    Boardcore::TrajectoryPoint(1840, 174.348679900803),
    Boardcore::TrajectoryPoint(1850, 173.339198727925),
    Boardcore::TrajectoryPoint(1860, 172.330082328663),
    Boardcore::TrajectoryPoint(1870, 171.321287322635),
    Boardcore::TrajectoryPoint(1880, 170.312709894256),
    Boardcore::TrajectoryPoint(1890, 169.304284861199),
    Boardcore::TrajectoryPoint(1900, 168.295947337441),
    Boardcore::TrajectoryPoint(1910, 167.287632713736),
    Boardcore::TrajectoryPoint(1920, 166.279268676342),
    Boardcore::TrajectoryPoint(1930, 165.270778936416),
    Boardcore::TrajectoryPoint(1940, 164.262102997798),
    Boardcore::TrajectoryPoint(1950, 163.253176837963),
    Boardcore::TrajectoryPoint(1960, 162.243936613246),
    Boardcore::TrajectoryPoint(1970, 161.234256015731),
    Boardcore::TrajectoryPoint(1980, 160.224108074244),
    Boardcore::TrajectoryPoint(1990, 159.213436337159),
    Boardcore::TrajectoryPoint(2000, 158.20217716352),
    Boardcore::TrajectoryPoint(2010, 157.190158231584),
    Boardcore::TrajectoryPoint(2020, 156.177389311268),
    Boardcore::TrajectoryPoint(2030, 155.16382144996),
    Boardcore::TrajectoryPoint(2040, 154.149339011273),
    Boardcore::TrajectoryPoint(2050, 153.133793827773),
    Boardcore::TrajectoryPoint(2060, 152.117235844324),
    Boardcore::TrajectoryPoint(2070, 151.09958702252),
    Boardcore::TrajectoryPoint(2080, 150.080571876524),
    Boardcore::TrajectoryPoint(2090, 149.060327078812),
    Boardcore::TrajectoryPoint(2100, 148.038762457692),
    Boardcore::TrajectoryPoint(2110, 147.015567349051),
    Boardcore::TrajectoryPoint(2120, 145.990922014799),
    Boardcore::TrajectoryPoint(2130, 144.964645662024),
    Boardcore::TrajectoryPoint(2140, 143.936542188428),
    Boardcore::TrajectoryPoint(2150, 142.906763380007),
    Boardcore::TrajectoryPoint(2160, 141.874931829613),
    Boardcore::TrajectoryPoint(2170, 140.841170700855),
    Boardcore::TrajectoryPoint(2180, 139.805342784672),
    Boardcore::TrajectoryPoint(2190, 138.767223992094),
    Boardcore::TrajectoryPoint(2200, 137.726994401832),
    Boardcore::TrajectoryPoint(2210, 136.68413147351),
    Boardcore::TrajectoryPoint(2220, 135.639024410992),
    Boardcore::TrajectoryPoint(2230, 134.591067007565),
    Boardcore::TrajectoryPoint(2240, 133.540641971705),
    Boardcore::TrajectoryPoint(2250, 132.4871686073),
    Boardcore::TrajectoryPoint(2260, 131.43100971331),
    Boardcore::TrajectoryPoint(2270, 130.371536649261),
    Boardcore::TrajectoryPoint(2280, 129.309187262782),
    Boardcore::TrajectoryPoint(2290, 128.243231795596),
    Boardcore::TrajectoryPoint(2300, 127.17410152082),
    Boardcore::TrajectoryPoint(2310, 126.101272625569),
    Boardcore::TrajectoryPoint(2320, 125.024807851248),
    Boardcore::TrajectoryPoint(2330, 123.944632972967),
    Boardcore::TrajectoryPoint(2340, 122.860250834709),
    Boardcore::TrajectoryPoint(2350, 121.771965568726),
    Boardcore::TrajectoryPoint(2360, 120.679325514782),
    Boardcore::TrajectoryPoint(2370, 119.582169663178),
    Boardcore::TrajectoryPoint(2380, 118.480593511352),
    Boardcore::TrajectoryPoint(2390, 117.374179174398),
    Boardcore::TrajectoryPoint(2400, 116.262690213067),
    Boardcore::TrajectoryPoint(2410, 115.146207394954),
    Boardcore::TrajectoryPoint(2420, 114.024522488602),
    Boardcore::TrajectoryPoint(2430, 112.897075634203),
    Boardcore::TrajectoryPoint(2440, 111.76390941909),
    Boardcore::TrajectoryPoint(2450, 110.624880324264),
    Boardcore::TrajectoryPoint(2460, 109.479745301923),
    Boardcore::TrajectoryPoint(2470, 108.328250994048),
    Boardcore::TrajectoryPoint(2480, 107.169938064136),
    Boardcore::TrajectoryPoint(2490, 106.004667906734),
    Boardcore::TrajectoryPoint(2500, 104.832245845902),
    Boardcore::TrajectoryPoint(2510, 103.652376029556),
    Boardcore::TrajectoryPoint(2520, 102.46474989749),
    Boardcore::TrajectoryPoint(2530, 101.269045570069),
    Boardcore::TrajectoryPoint(2540, 100.064927193817),
    Boardcore::TrajectoryPoint(2550, 98.8520442412079),
    Boardcore::TrajectoryPoint(2560, 97.6300307616593),
    Boardcore::TrajectoryPoint(2570, 96.3985045804486),
    Boardcore::TrajectoryPoint(2580, 95.1570664419355),
    Boardcore::TrajectoryPoint(2590, 93.9052990931249),
    Boardcore::TrajectoryPoint(2600, 92.6427663032173),
    Boardcore::TrajectoryPoint(2610, 91.3687282577249),
    Boardcore::TrajectoryPoint(2620, 90.0827578711939),
    Boardcore::TrajectoryPoint(2630, 88.7844918571683),
    Boardcore::TrajectoryPoint(2640, 87.4733997397265),
    Boardcore::TrajectoryPoint(2650, 86.1485837221675),
    Boardcore::TrajectoryPoint(2660, 84.8092250035486),
    Boardcore::TrajectoryPoint(2670, 83.4551603281131),
    Boardcore::TrajectoryPoint(2680, 82.0850034161678),
    Boardcore::TrajectoryPoint(2690, 80.6982290497963),
    Boardcore::TrajectoryPoint(2700, 79.2938919741733),
    Boardcore::TrajectoryPoint(2710, 77.8708831768305),
    Boardcore::TrajectoryPoint(2720, 76.4281035739183),
    Boardcore::TrajectoryPoint(2730, 74.9648636465197),
    Boardcore::TrajectoryPoint(2740, 73.4787474953656),
    Boardcore::TrajectoryPoint(2750, 71.9692878386011),
    Boardcore::TrajectoryPoint(2760, 70.4347937791234),
    Boardcore::TrajectoryPoint(2770, 68.8734201610548),
    Boardcore::TrajectoryPoint(2780, 67.283150422753),
    Boardcore::TrajectoryPoint(2790, 65.6617770506221),
    Boardcore::TrajectoryPoint(2800, 64.0068792373698),
    Boardcore::TrajectoryPoint(2810, 62.3157972709867),
    Boardcore::TrajectoryPoint(2820, 60.5856030860527),
    Boardcore::TrajectoryPoint(2830, 58.8130662925681),
    Boardcore::TrajectoryPoint(2840, 56.9930319559258),
    Boardcore::TrajectoryPoint(2850, 55.122243013252),
    Boardcore::TrajectoryPoint(2860, 53.1936523796623),
    Boardcore::TrajectoryPoint(2870, 51.2018922226999),
    Boardcore::TrajectoryPoint(2880, 49.138866897222),
    Boardcore::TrajectoryPoint(2890, 46.9950949489094),
    Boardcore::TrajectoryPoint(2900, 44.7594042540054),
    Boardcore::TrajectoryPoint(2910, 42.4153627074605),
    Boardcore::TrajectoryPoint(2920, 39.9458146882861),
    Boardcore::TrajectoryPoint(2930, 37.3250583406878),
    Boardcore::TrajectoryPoint(2940, 34.5188814979144),
    Boardcore::TrajectoryPoint(2950, 31.4767736850246),
    Boardcore::TrajectoryPoint(2960, 28.1234384974454),
    Boardcore::TrajectoryPoint(2970, 24.3280880063611),
    Boardcore::TrajectoryPoint(2980, 19.8416905122388),
    Boardcore::TrajectoryPoint(2990, 14.0136821401343),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t5_open[] = {
    Boardcore::TrajectoryPoint(0, 466.798381972774),
    Boardcore::TrajectoryPoint(10, 464.61789000206),
    Boardcore::TrajectoryPoint(20, 462.437398031347),
    Boardcore::TrajectoryPoint(30, 460.24040637368),
    Boardcore::TrajectoryPoint(40, 458.040930121593),
    Boardcore::TrajectoryPoint(50, 455.829796559331),
    Boardcore::TrajectoryPoint(60, 453.609904708223),
    Boardcore::TrajectoryPoint(70, 451.383787531673),
    Boardcore::TrajectoryPoint(80, 449.143014240449),
    Boardcore::TrajectoryPoint(90, 446.901163030565),
    Boardcore::TrajectoryPoint(100, 444.639027631797),
    Boardcore::TrajectoryPoint(110, 442.376892233028),
    Boardcore::TrajectoryPoint(120, 440.096659258559),
    Boardcore::TrajectoryPoint(130, 437.81266561361),
    Boardcore::TrajectoryPoint(140, 435.514565993175),
    Boardcore::TrajectoryPoint(150, 433.208201812032),
    Boardcore::TrajectoryPoint(160, 430.891344039854),
    Boardcore::TrajectoryPoint(170, 428.562080163309),
    Boardcore::TrajectoryPoint(180, 426.22552555696),
    Boardcore::TrajectoryPoint(190, 423.872815198613),
    Boardcore::TrajectoryPoint(200, 421.515575049245),
    Boardcore::TrajectoryPoint(210, 419.138852994605),
    Boardcore::TrajectoryPoint(220, 416.759885511508),
    Boardcore::TrajectoryPoint(230, 414.358567271224),
    Boardcore::TrajectoryPoint(240, 411.956774303495),
    Boardcore::TrajectoryPoint(250, 409.530255217554),
    Boardcore::TrajectoryPoint(260, 407.103736131613),
    Boardcore::TrajectoryPoint(270, 404.652133023433),
    Boardcore::TrajectoryPoint(280, 402.199787312848),
    Boardcore::TrajectoryPoint(290, 399.722331092397),
    Boardcore::TrajectoryPoint(300, 397.243510854666),
    Boardcore::TrajectoryPoint(310, 394.738888909177),
    Boardcore::TrajectoryPoint(320, 392.232923053452),
    Boardcore::TrajectoryPoint(330, 389.699749532372),
    Boardcore::TrajectoryPoint(340, 387.165122514702),
    Boardcore::TrajectoryPoint(350, 384.602753680028),
    Boardcore::TrajectoryPoint(360, 382.037311875557),
    Boardcore::TrajectoryPoint(370, 379.445633372635),
    Boardcore::TrajectoryPoint(380, 376.847769126042),
    Boardcore::TrajectoryPoint(390, 374.226005094491),
    Boardcore::TrajectoryPoint(400, 371.594017435669),
    Boardcore::TrajectoryPoint(410, 368.941362430346),
    Boardcore::TrajectoryPoint(420, 366.273450672386),
    Boardcore::TrajectoryPoint(430, 363.589068129847),
    Boardcore::TrajectoryPoint(440, 361.303830390443),
    Boardcore::TrajectoryPoint(450, 359.228552337551),
    Boardcore::TrajectoryPoint(460, 357.177292287072),
    Boardcore::TrajectoryPoint(470, 355.132083026117),
    Boardcore::TrajectoryPoint(480, 353.11320257713),
    Boardcore::TrajectoryPoint(490, 351.102696993273),
    Boardcore::TrajectoryPoint(500, 349.111875813195),
    Boardcore::TrajectoryPoint(510, 347.136333492296),
    Boardcore::TrajectoryPoint(520, 345.173358138179),
    Boardcore::TrajectoryPoint(530, 343.232872904577),
    Boardcore::TrajectoryPoint(540, 341.300185015984),
    Boardcore::TrajectoryPoint(550, 339.391970475384),
    Boardcore::TrajectoryPoint(560, 337.494501659399),
    Boardcore::TrajectoryPoint(570, 335.613083227484),
    Boardcore::TrajectoryPoint(580, 333.750570963343),
    Boardcore::TrajectoryPoint(590, 331.896788619506),
    Boardcore::TrajectoryPoint(600, 330.067566027072),
    Boardcore::TrajectoryPoint(610, 328.248416437743),
    Boardcore::TrajectoryPoint(620, 326.444526429652),
    Boardcore::TrajectoryPoint(630, 324.659480616198),
    Boardcore::TrajectoryPoint(640, 322.883707040729),
    Boardcore::TrajectoryPoint(650, 321.128833437008),
    Boardcore::TrajectoryPoint(660, 319.386467167187),
    Boardcore::TrajectoryPoint(670, 317.655246842287),
    Boardcore::TrajectoryPoint(680, 315.945578424248),
    Boardcore::TrajectoryPoint(690, 314.245370200585),
    Boardcore::TrajectoryPoint(700, 312.559703872486),
    Boardcore::TrajectoryPoint(710, 310.891238343834),
    Boardcore::TrajectoryPoint(720, 309.232390573966),
    Boardcore::TrajectoryPoint(730, 307.589926135223),
    Boardcore::TrajectoryPoint(740, 305.961747747879),
    Boardcore::TrajectoryPoint(750, 304.343233469979),
    Boardcore::TrajectoryPoint(760, 302.741638165038),
    Boardcore::TrajectoryPoint(770, 301.152634169554),
    Boardcore::TrajectoryPoint(780, 299.573243953994),
    Boardcore::TrajectoryPoint(790, 298.010236361126),
    Boardcore::TrajectoryPoint(800, 296.459140048492),
    Boardcore::TrajectoryPoint(810, 294.917525867413),
    Boardcore::TrajectoryPoint(820, 293.390897970915),
    Boardcore::TrajectoryPoint(830, 291.876328288049),
    Boardcore::TrajectoryPoint(840, 290.371042660961),
    Boardcore::TrajectoryPoint(850, 288.878674321467),
    Boardcore::TrajectoryPoint(860, 287.399170813865),
    Boardcore::TrajectoryPoint(870, 285.928700550212),
    Boardcore::TrajectoryPoint(880, 284.468568231473),
    Boardcore::TrajectoryPoint(890, 283.022620890566),
    Boardcore::TrajectoryPoint(900, 281.585415386357),
    Boardcore::TrajectoryPoint(910, 280.157021636155),
    Boardcore::TrajectoryPoint(920, 278.741670708396),
    Boardcore::TrajectoryPoint(930, 277.336165123906),
    Boardcore::TrajectoryPoint(940, 275.939125440257),
    Boardcore::TrajectoryPoint(950, 274.55139608446),
    Boardcore::TrajectoryPoint(960, 273.1760299204),
    Boardcore::TrajectoryPoint(970, 271.808766724362),
    Boardcore::TrajectoryPoint(980, 270.449617201102),
    Boardcore::TrajectoryPoint(990, 269.100221854963),
    Boardcore::TrajectoryPoint(1000, 267.761183274809),
    Boardcore::TrajectoryPoint(1010, 266.429870471829),
    Boardcore::TrajectoryPoint(1020, 265.106267601417),
    Boardcore::TrajectoryPoint(1030, 263.791775815524),
    Boardcore::TrajectoryPoint(1040, 262.486781510956),
    Boardcore::TrajectoryPoint(1050, 261.189097082814),
    Boardcore::TrajectoryPoint(1060, 259.898686975532),
    Boardcore::TrajectoryPoint(1070, 258.61597220071),
    Boardcore::TrajectoryPoint(1080, 257.342738879845),
    Boardcore::TrajectoryPoint(1090, 256.076377283261),
    Boardcore::TrajectoryPoint(1100, 254.816837612555),
    Boardcore::TrajectoryPoint(1110, 253.564063270462),
    Boardcore::TrajectoryPoint(1120, 252.319334988487),
    Boardcore::TrajectoryPoint(1130, 251.082040322835),
    Boardcore::TrajectoryPoint(1140, 249.851109686601),
    Boardcore::TrajectoryPoint(1150, 248.626478019901),
    Boardcore::TrajectoryPoint(1160, 247.408075476955),
    Boardcore::TrajectoryPoint(1170, 246.1968673627),
    Boardcore::TrajectoryPoint(1180, 244.992364796942),
    Boardcore::TrajectoryPoint(1190, 243.793700561432),
    Boardcore::TrajectoryPoint(1200, 242.600800451402),
    Boardcore::TrajectoryPoint(1210, 241.413586966936),
    Boardcore::TrajectoryPoint(1220, 240.231979679121),
    Boardcore::TrajectoryPoint(1230, 239.057181069093),
    Boardcore::TrajectoryPoint(1240, 237.887718485013),
    Boardcore::TrajectoryPoint(1250, 236.723488821637),
    Boardcore::TrajectoryPoint(1260, 235.564410840391),
    Boardcore::TrajectoryPoint(1270, 234.410401368092),
    Boardcore::TrajectoryPoint(1280, 233.261375549707),
    Boardcore::TrajectoryPoint(1290, 232.117694342822),
    Boardcore::TrajectoryPoint(1300, 230.979220939363),
    Boardcore::TrajectoryPoint(1310, 229.845380543172),
    Boardcore::TrajectoryPoint(1320, 228.716089624467),
    Boardcore::TrajectoryPoint(1330, 227.591263617325),
    Boardcore::TrajectoryPoint(1340, 226.470817091764),
    Boardcore::TrajectoryPoint(1350, 225.354663911605),
    Boardcore::TrajectoryPoint(1360, 224.242717379074),
    Boardcore::TrajectoryPoint(1370, 223.135079242259),
    Boardcore::TrajectoryPoint(1380, 222.031769599318),
    Boardcore::TrajectoryPoint(1390, 220.932347020742),
    Boardcore::TrajectoryPoint(1400, 219.836727793701),
    Boardcore::TrajectoryPoint(1410, 218.744827969134),
    Boardcore::TrajectoryPoint(1420, 217.656563457909),
    Boardcore::TrajectoryPoint(1430, 216.571850118284),
    Boardcore::TrajectoryPoint(1440, 215.490603835272),
    Boardcore::TrajectoryPoint(1450, 214.412740592515),
    Boardcore::TrajectoryPoint(1460, 213.338176537192),
    Boardcore::TrajectoryPoint(1470, 212.266828038484),
    Boardcore::TrajectoryPoint(1480, 211.198611740051),
    Boardcore::TrajectoryPoint(1490, 210.133444606975),
    Boardcore::TrajectoryPoint(1500, 209.071243967575),
    Boardcore::TrajectoryPoint(1510, 208.012048991695),
    Boardcore::TrajectoryPoint(1520, 206.955634447655),
    Boardcore::TrajectoryPoint(1530, 205.901918802903),
    Boardcore::TrajectoryPoint(1540, 204.850823154752),
    Boardcore::TrajectoryPoint(1550, 203.802269002033),
    Boardcore::TrajectoryPoint(1560, 202.756178269513),
    Boardcore::TrajectoryPoint(1570, 201.712473328983),
    Boardcore::TrajectoryPoint(1580, 200.671077017251),
    Boardcore::TrajectoryPoint(1590, 199.63191265128),
    Boardcore::TrajectoryPoint(1600, 198.594904040686),
    Boardcore::TrajectoryPoint(1610, 197.559975497782),
    Boardcore::TrajectoryPoint(1620, 196.527051845377),
    Boardcore::TrajectoryPoint(1630, 195.49605842247),
    Boardcore::TrajectoryPoint(1640, 194.466921088027),
    Boardcore::TrajectoryPoint(1650, 193.43956622297),
    Boardcore::TrajectoryPoint(1660, 192.413920730518),
    Boardcore::TrajectoryPoint(1670, 191.389912035007),
    Boardcore::TrajectoryPoint(1680, 190.367528458224),
    Boardcore::TrajectoryPoint(1690, 189.346643035484),
    Boardcore::TrajectoryPoint(1700, 188.32717902537),
    Boardcore::TrajectoryPoint(1710, 187.309065067163),
    Boardcore::TrajectoryPoint(1720, 186.292230333404),
    Boardcore::TrajectoryPoint(1730, 185.276604519431),
    Boardcore::TrajectoryPoint(1740, 184.262117832187),
    Boardcore::TrajectoryPoint(1750, 183.248700978336),
    Boardcore::TrajectoryPoint(1760, 182.236285151764),
    Boardcore::TrajectoryPoint(1770, 181.224802020503),
    Boardcore::TrajectoryPoint(1780, 180.214183713119),
    Boardcore::TrajectoryPoint(1790, 179.204362804625),
    Boardcore::TrajectoryPoint(1800, 178.195311511487),
    Boardcore::TrajectoryPoint(1810, 177.186941180749),
    Boardcore::TrajectoryPoint(1820, 176.179158382794),
    Boardcore::TrajectoryPoint(1830, 175.171896860245),
    Boardcore::TrajectoryPoint(1840, 174.165090739559),
    Boardcore::TrajectoryPoint(1850, 173.158674513597),
    Boardcore::TrajectoryPoint(1860, 172.152583023991),
    Boardcore::TrajectoryPoint(1870, 171.146764376437),
    Boardcore::TrajectoryPoint(1880, 170.141141523733),
    Boardcore::TrajectoryPoint(1890, 169.135635655972),
    Boardcore::TrajectoryPoint(1900, 168.130182467608),
    Boardcore::TrajectoryPoint(1910, 167.124717916444),
    Boardcore::TrajectoryPoint(1920, 166.119176099154),
    Boardcore::TrajectoryPoint(1930, 165.113467405479),
    Boardcore::TrajectoryPoint(1940, 164.107539808654),
    Boardcore::TrajectoryPoint(1950, 163.101329806411),
    Boardcore::TrajectoryPoint(1960, 162.094774062811),
    Boardcore::TrajectoryPoint(1970, 161.087766595461),
    Boardcore::TrajectoryPoint(1980, 160.080238279998),
    Boardcore::TrajectoryPoint(1990, 159.07215591558),
    Boardcore::TrajectoryPoint(2000, 158.06345632395),
    Boardcore::TrajectoryPoint(2010, 157.053997710268),
    Boardcore::TrajectoryPoint(2020, 156.04372660691),
    Boardcore::TrajectoryPoint(2030, 155.032628087665),
    Boardcore::TrajectoryPoint(2040, 154.020626590328),
    Boardcore::TrajectoryPoint(2050, 153.007491120021),
    Boardcore::TrajectoryPoint(2060, 151.993315613174),
    Boardcore::TrajectoryPoint(2070, 150.978036239807),
    Boardcore::TrajectoryPoint(2080, 149.961378420555),
    Boardcore::TrajectoryPoint(2090, 148.94343247487),
    Boardcore::TrajectoryPoint(2100, 147.924166272151),
    Boardcore::TrajectoryPoint(2110, 146.903239467872),
    Boardcore::TrajectoryPoint(2120, 145.880812449446),
    Boardcore::TrajectoryPoint(2130, 144.856782009275),
    Boardcore::TrajectoryPoint(2140, 143.830843223811),
    Boardcore::TrajectoryPoint(2150, 142.803205120316),
    Boardcore::TrajectoryPoint(2160, 141.773543095377),
    Boardcore::TrajectoryPoint(2170, 140.741870863382),
    Boardcore::TrajectoryPoint(2180, 139.708164964326),
    Boardcore::TrajectoryPoint(2190, 138.672084378022),
    Boardcore::TrajectoryPoint(2200, 137.633908331329),
    Boardcore::TrajectoryPoint(2210, 136.59305499796),
    Boardcore::TrajectoryPoint(2220, 135.549914670101),
    Boardcore::TrajectoryPoint(2230, 134.503957760262),
    Boardcore::TrajectoryPoint(2240, 133.455451457358),
    Boardcore::TrajectoryPoint(2250, 132.403931892565),
    Boardcore::TrajectoryPoint(2260, 131.349644722676),
    Boardcore::TrajectoryPoint(2270, 130.292079009303),
    Boardcore::TrajectoryPoint(2280, 129.231581902316),
    Boardcore::TrajectoryPoint(2290, 128.167461020475),
    Boardcore::TrajectoryPoint(2300, 127.100170963689),
    Boardcore::TrajectoryPoint(2310, 126.029097752636),
    Boardcore::TrajectoryPoint(2320, 124.954427290659),
    Boardcore::TrajectoryPoint(2330, 123.875964278144),
    Boardcore::TrajectoryPoint(2340, 122.793330931996),
    Boardcore::TrajectoryPoint(2350, 121.706773182646),
    Boardcore::TrajectoryPoint(2360, 120.615778169412),
    Boardcore::TrajectoryPoint(2370, 119.520304730168),
    Boardcore::TrajectoryPoint(2380, 118.420389591002),
    Boardcore::TrajectoryPoint(2390, 117.315555237678),
    Boardcore::TrajectoryPoint(2400, 116.205682671295),
    Boardcore::TrajectoryPoint(2410, 115.090794804297),
    Boardcore::TrajectoryPoint(2420, 113.97068332087),
    Boardcore::TrajectoryPoint(2430, 112.844730519116),
    Boardcore::TrajectoryPoint(2440, 111.713093744806),
    Boardcore::TrajectoryPoint(2450, 110.575572607891),
    Boardcore::TrajectoryPoint(2460, 109.431924016518),
    Boardcore::TrajectoryPoint(2470, 108.281894579839),
    Boardcore::TrajectoryPoint(2480, 107.124970866699),
    Boardcore::TrajectoryPoint(2490, 105.961122454613),
    Boardcore::TrajectoryPoint(2500, 104.790100705366),
    Boardcore::TrajectoryPoint(2510, 103.611609760965),
    Boardcore::TrajectoryPoint(2520, 102.425341063131),
    Boardcore::TrajectoryPoint(2530, 101.230972741373),
    Boardcore::TrajectoryPoint(2540, 100.028168958021),
    Boardcore::TrajectoryPoint(2550, 98.8165792075157),
    Boardcore::TrajectoryPoint(2560, 97.5958375669567),
    Boardcore::TrajectoryPoint(2570, 96.3655618946098),
    Boardcore::TrajectoryPoint(2580, 95.1253529727671),
    Boardcore::TrajectoryPoint(2590, 93.8747935909813),
    Boardcore::TrajectoryPoint(2600, 92.6134475653185),
    Boardcore::TrajectoryPoint(2610, 91.3406177971843),
    Boardcore::TrajectoryPoint(2620, 90.0557902851937),
    Boardcore::TrajectoryPoint(2630, 88.758646024658),
    Boardcore::TrajectoryPoint(2640, 87.4486546056083),
    Boardcore::TrajectoryPoint(2650, 86.1249572008821),
    Boardcore::TrajectoryPoint(2660, 84.78665525018),
    Boardcore::TrajectoryPoint(2670, 83.4336264393089),
    Boardcore::TrajectoryPoint(2680, 82.0645201575885),
    Boardcore::TrajectoryPoint(2690, 80.678737807325),
    Boardcore::TrajectoryPoint(2700, 79.2754057666193),
    Boardcore::TrajectoryPoint(2710, 77.8533452083614),
    Boardcore::TrajectoryPoint(2720, 76.4115246203212),
    Boardcore::TrajectoryPoint(2730, 74.9491892897096),
    Boardcore::TrajectoryPoint(2740, 73.4639858257113),
    Boardcore::TrajectoryPoint(2750, 71.9554153768772),
    Boardcore::TrajectoryPoint(2760, 70.4217868478018),
    Boardcore::TrajectoryPoint(2770, 68.8612549090798),
    Boardcore::TrajectoryPoint(2780, 67.2718028486315),
    Boardcore::TrajectoryPoint(2790, 65.6512230239194),
    Boardcore::TrajectoryPoint(2800, 63.9970945186851),
    Boardcore::TrajectoryPoint(2810, 62.3067575304634),
    Boardcore::TrajectoryPoint(2820, 60.5772839204674),
    Boardcore::TrajectoryPoint(2830, 58.8054432410263),
    Boardcore::TrajectoryPoint(2840, 56.9860990095912),
    Boardcore::TrajectoryPoint(2850, 55.1159552229091),
    Boardcore::TrajectoryPoint(2860, 53.1880010058665),
    Boardcore::TrajectoryPoint(2870, 51.1968495553967),
    Boardcore::TrajectoryPoint(2880, 49.1344048017797),
    Boardcore::TrajectoryPoint(2890, 46.9911849108067),
    Boardcore::TrajectoryPoint(2900, 44.7560174175093),
    Boardcore::TrajectoryPoint(2910, 42.412480276508),
    Boardcore::TrajectoryPoint(2920, 39.9434043030311),
    Boardcore::TrajectoryPoint(2930, 37.3230867479078),
    Boardcore::TrajectoryPoint(2940, 34.5173218130862),
    Boardcore::TrajectoryPoint(2950, 31.475587951172),
    Boardcore::TrajectoryPoint(2960, 28.1225871362484),
    Boardcore::TrajectoryPoint(2970, 24.3275362242516),
    Boardcore::TrajectoryPoint(2980, 19.8413900472862),
    Boardcore::TrajectoryPoint(2990, 14.0135764130844),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t6_open[] = {
    Boardcore::TrajectoryPoint(0, 464.57504489382),
    Boardcore::TrajectoryPoint(10, 462.395679122466),
    Boardcore::TrajectoryPoint(20, 460.205599127208),
    Boardcore::TrajectoryPoint(30, 458.01551913195),
    Boardcore::TrajectoryPoint(40, 455.808591590408),
    Boardcore::TrajectoryPoint(50, 453.598291340692),
    Boardcore::TrajectoryPoint(60, 451.376461632136),
    Boardcore::TrajectoryPoint(70, 449.145481674678),
    Boardcore::TrajectoryPoint(80, 446.908008032629),
    Boardcore::TrajectoryPoint(90, 444.655874361964),
    Boardcore::TrajectoryPoint(100, 442.40197659069),
    Boardcore::TrajectoryPoint(110, 440.128200019218),
    Boardcore::TrajectoryPoint(120, 437.854423447746),
    Boardcore::TrajectoryPoint(130, 435.561132749798),
    Boardcore::TrajectoryPoint(140, 433.265208243507),
    Boardcore::TrajectoryPoint(150, 430.953287049337),
    Boardcore::TrajectoryPoint(160, 428.63469302694),
    Boardcore::TrajectoryPoint(170, 426.30321450381),
    Boardcore::TrajectoryPoint(180, 423.961412096851),
    Boardcore::TrajectoryPoint(190, 421.609400263733),
    Boardcore::TrajectoryPoint(200, 419.243832535013),
    Boardcore::TrajectoryPoint(210, 416.870259276637),
    Boardcore::TrajectoryPoint(220, 414.480350394119),
    Boardcore::TrajectoryPoint(230, 412.084132258313),
    Boardcore::TrajectoryPoint(240, 409.66928662142),
    Boardcore::TrajectoryPoint(250, 407.249281381514),
    Boardcore::TrajectoryPoint(260, 404.808882696486),
    Boardcore::TrajectoryPoint(270, 402.363885658775),
    Boardcore::TrajectoryPoint(280, 399.897295959484),
    Boardcore::TrajectoryPoint(290, 397.42603599379),
    Boardcore::TrajectoryPoint(300, 394.932594604103),
    Boardcore::TrajectoryPoint(310, 392.433729873315),
    Boardcore::TrajectoryPoint(320, 389.912752306751),
    Boardcore::TrajectoryPoint(330, 387.3848656688),
    Boardcore::TrajectoryPoint(340, 384.835642460901),
    Boardcore::TrajectoryPoint(350, 382.277236513941),
    Boardcore::TrajectoryPoint(360, 379.699031982336),
    Boardcore::TrajectoryPoint(370, 377.10852372091),
    Boardcore::TrajectoryPoint(380, 374.500574647642),
    Boardcore::TrajectoryPoint(390, 371.876289694262),
    Boardcore::TrajectoryPoint(400, 369.237803924441),
    Boardcore::TrajectoryPoint(410, 366.577970297281),
    Boardcore::TrajectoryPoint(420, 363.908125247623),
    Boardcore::TrajectoryPoint(430, 361.748225730561),
    Boardcore::TrajectoryPoint(440, 359.678814625141),
    Boardcore::TrajectoryPoint(450, 357.636098539521),
    Boardcore::TrajectoryPoint(460, 355.600440435934),
    Boardcore::TrajectoryPoint(470, 353.58561009087),
    Boardcore::TrajectoryPoint(480, 351.584156327534),
    Boardcore::TrajectoryPoint(490, 349.597108462097),
    Boardcore::TrajectoryPoint(500, 347.630132733969),
    Boardcore::TrajectoryPoint(510, 345.670676032605),
    Boardcore::TrajectoryPoint(520, 343.73828908058),
    Boardcore::TrajectoryPoint(530, 341.813463721616),
    Boardcore::TrajectoryPoint(540, 339.908320742078),
    Boardcore::TrajectoryPoint(550, 338.01826680722),
    Boardcore::TrajectoryPoint(560, 336.139725260314),
    Boardcore::TrajectoryPoint(570, 334.284202867539),
    Boardcore::TrajectoryPoint(580, 332.437168986378),
    Boardcore::TrajectoryPoint(590, 330.610485860169),
    Boardcore::TrajectoryPoint(600, 328.797690788498),
    Boardcore::TrajectoryPoint(610, 326.996195200112),
    Boardcore::TrajectoryPoint(620, 325.217134198277),
    Boardcore::TrajectoryPoint(630, 323.447117048484),
    Boardcore::TrajectoryPoint(640, 321.694389567723),
    Boardcore::TrajectoryPoint(650, 319.957444724116),
    Boardcore::TrajectoryPoint(660, 318.229909464585),
    Boardcore::TrajectoryPoint(670, 316.523706495168),
    Boardcore::TrajectoryPoint(680, 314.828402364259),
    Boardcore::TrajectoryPoint(690, 313.144599003376),
    Boardcore::TrajectoryPoint(700, 311.480760008546),
    Boardcore::TrajectoryPoint(710, 309.826347785572),
    Boardcore::TrajectoryPoint(720, 308.185606515977),
    Boardcore::TrajectoryPoint(730, 306.561619052416),
    Boardcore::TrajectoryPoint(740, 304.947120792727),
    Boardcore::TrajectoryPoint(750, 303.347140770565),
    Boardcore::TrajectoryPoint(760, 301.761939171504),
    Boardcore::TrajectoryPoint(770, 300.186192987308),
    Boardcore::TrajectoryPoint(780, 298.624719438399),
    Boardcore::TrajectoryPoint(790, 297.077082192096),
    Boardcore::TrajectoryPoint(800, 295.538785036363),
    Boardcore::TrajectoryPoint(810, 294.013632105804),
    Boardcore::TrajectoryPoint(820, 292.502220612078),
    Boardcore::TrajectoryPoint(830, 290.999966798287),
    Boardcore::TrajectoryPoint(840, 289.509032711175),
    Boardcore::TrajectoryPoint(850, 288.032425755016),
    Boardcore::TrajectoryPoint(860, 286.564740403152),
    Boardcore::TrajectoryPoint(870, 285.106081064005),
    Boardcore::TrajectoryPoint(880, 283.662740198737),
    Boardcore::TrajectoryPoint(890, 282.228107462681),
    Boardcore::TrajectoryPoint(900, 280.802193629597),
    Boardcore::TrajectoryPoint(910, 279.38823580461),
    Boardcore::TrajectoryPoint(920, 277.985122131032),
    Boardcore::TrajectoryPoint(930, 276.590393696861),
    Boardcore::TrajectoryPoint(940, 275.204083994106),
    Boardcore::TrajectoryPoint(950, 273.830931936988),
    Boardcore::TrajectoryPoint(960, 272.465838154299),
    Boardcore::TrajectoryPoint(970, 271.108792742864),
    Boardcore::TrajectoryPoint(980, 269.760808295261),
    Boardcore::TrajectoryPoint(990, 268.423821114011),
    Boardcore::TrajectoryPoint(1000, 267.094503960445),
    Boardcore::TrajectoryPoint(1010, 265.772844821862),
    Boardcore::TrajectoryPoint(1020, 264.459792662219),
    Boardcore::TrajectoryPoint(1030, 263.156705616153),
    Boardcore::TrajectoryPoint(1040, 261.860884706045),
    Boardcore::TrajectoryPoint(1050, 260.572297721395),
    Boardcore::TrajectoryPoint(1060, 259.291060384365),
    Boardcore::TrajectoryPoint(1070, 258.01962716051),
    Boardcore::TrajectoryPoint(1080, 256.755032210805),
    Boardcore::TrajectoryPoint(1090, 255.4972286298),
    Boardcore::TrajectoryPoint(1100, 254.246162594205),
    Boardcore::TrajectoryPoint(1110, 253.002971880038),
    Boardcore::TrajectoryPoint(1120, 251.767376676696),
    Boardcore::TrajectoryPoint(1130, 250.538123299925),
    Boardcore::TrajectoryPoint(1140, 249.315149068141),
    Boardcore::TrajectoryPoint(1150, 248.098386408033),
    Boardcore::TrajectoryPoint(1160, 246.888783100757),
    Boardcore::TrajectoryPoint(1170, 245.685922574546),
    Boardcore::TrajectoryPoint(1180, 244.488887277919),
    Boardcore::TrajectoryPoint(1190, 243.29760494541),
    Boardcore::TrajectoryPoint(1200, 242.111999926051),
    Boardcore::TrajectoryPoint(1210, 240.932044674385),
    Boardcore::TrajectoryPoint(1220, 239.758889257745),
    Boardcore::TrajectoryPoint(1230, 238.591040016849),
    Boardcore::TrajectoryPoint(1240, 237.428419496724),
    Boardcore::TrajectoryPoint(1250, 236.270947958568),
    Boardcore::TrajectoryPoint(1260, 235.118543656811),
    Boardcore::TrajectoryPoint(1270, 233.97112309492),
    Boardcore::TrajectoryPoint(1280, 232.829228280713),
    Boardcore::TrajectoryPoint(1290, 231.692380013277),
    Boardcore::TrajectoryPoint(1300, 230.56016735551),
    Boardcore::TrajectoryPoint(1310, 229.432507935196),
    Boardcore::TrajectoryPoint(1320, 228.309318287839),
    Boardcore::TrajectoryPoint(1330, 227.190514031383),
    Boardcore::TrajectoryPoint(1340, 226.076010026642),
    Boardcore::TrajectoryPoint(1350, 224.965720524382),
    Boardcore::TrajectoryPoint(1360, 223.859997820778),
    Boardcore::TrajectoryPoint(1370, 222.758372230856),
    Boardcore::TrajectoryPoint(1380, 221.66064325945),
    Boardcore::TrajectoryPoint(1390, 220.566728006562),
    Boardcore::TrajectoryPoint(1400, 219.476543297336),
    Boardcore::TrajectoryPoint(1410, 218.390005780232),
    Boardcore::TrajectoryPoint(1420, 217.30703201643),
    Boardcore::TrajectoryPoint(1430, 216.227538561063),
    Boardcore::TrajectoryPoint(1440, 215.151442036874),
    Boardcore::TrajectoryPoint(1450, 214.078659200851),
    Boardcore::TrajectoryPoint(1460, 213.009107004331),
    Boardcore::TrajectoryPoint(1470, 211.942702647064),
    Boardcore::TrajectoryPoint(1480, 210.879495539076),
    Boardcore::TrajectoryPoint(1490, 209.81929057239),
    Boardcore::TrajectoryPoint(1500, 208.761959996512),
    Boardcore::TrajectoryPoint(1510, 207.707424681033),
    Boardcore::TrajectoryPoint(1520, 206.655605816985),
    Boardcore::TrajectoryPoint(1530, 205.606424950008),
    Boardcore::TrajectoryPoint(1540, 204.559804009577),
    Boardcore::TrajectoryPoint(1550, 203.515665334566),
    Boardcore::TrajectoryPoint(1560, 202.473931695431),
    Boardcore::TrajectoryPoint(1570, 201.43452631326),
    Boardcore::TrajectoryPoint(1580, 200.39737287591),
    Boardcore::TrajectoryPoint(1590, 199.362395551473),
    Boardcore::TrajectoryPoint(1600, 198.329518999249),
    Boardcore::TrajectoryPoint(1610, 197.298668378424),
    Boardcore::TrajectoryPoint(1620, 196.269769354622),
    Boardcore::TrajectoryPoint(1630, 195.242748104494),
    Boardcore::TrajectoryPoint(1640, 194.21753131849),
    Boardcore::TrajectoryPoint(1650, 193.194046201954),
    Boardcore::TrajectoryPoint(1660, 192.172220474673),
    Boardcore::TrajectoryPoint(1670, 191.151982368984),
    Boardcore::TrajectoryPoint(1680, 190.133260626569),
    Boardcore::TrajectoryPoint(1690, 189.115984494027),
    Boardcore::TrajectoryPoint(1700, 188.10014143303),
    Boardcore::TrajectoryPoint(1710, 187.085615076833),
    Boardcore::TrajectoryPoint(1720, 186.072322193714),
    Boardcore::TrajectoryPoint(1730, 185.060193252008),
    Boardcore::TrajectoryPoint(1740, 184.049159218464),
    Boardcore::TrajectoryPoint(1750, 183.039151546252),
    Boardcore::TrajectoryPoint(1760, 182.030102162374),
    Boardcore::TrajectoryPoint(1770, 181.021943454537),
    Boardcore::TrajectoryPoint(1780, 180.014608257521),
    Boardcore::TrajectoryPoint(1790, 179.008029839093),
    Boardcore::TrajectoryPoint(1800, 178.002141885494),
    Boardcore::TrajectoryPoint(1810, 176.996925377331),
    Boardcore::TrajectoryPoint(1820, 175.992268061996),
    Boardcore::TrajectoryPoint(1830, 174.988093834786),
    Boardcore::TrajectoryPoint(1840, 173.984337460544),
    Boardcore::TrajectoryPoint(1850, 172.980934056766),
    Boardcore::TrajectoryPoint(1860, 171.977819076129),
    Boardcore::TrajectoryPoint(1870, 170.974928680795),
    Boardcore::TrajectoryPoint(1880, 169.972210430464),
    Boardcore::TrajectoryPoint(1890, 168.969574492479),
    Boardcore::TrajectoryPoint(1900, 167.966957126991),
    Boardcore::TrajectoryPoint(1910, 166.964294844425),
    Boardcore::TrajectoryPoint(1920, 165.961524386307),
    Boardcore::TrajectoryPoint(1930, 164.958558013846),
    Boardcore::TrajectoryPoint(1940, 163.955332934092),
    Boardcore::TrajectoryPoint(1950, 162.951793923675),
    Boardcore::TrajectoryPoint(1960, 161.947878141381),
    Boardcore::TrajectoryPoint(1970, 160.943502945758),
    Boardcore::TrajectoryPoint(1980, 159.938550963533),
    Boardcore::TrajectoryPoint(1990, 158.933015290983),
    Boardcore::TrajectoryPoint(2000, 157.926833200686),
    Boardcore::TrajectoryPoint(2010, 156.919895753615),
    Boardcore::TrajectoryPoint(2020, 155.912081551711),
    Boardcore::TrajectoryPoint(2030, 154.903412027327),
    Boardcore::TrajectoryPoint(2040, 153.893824224006),
    Boardcore::TrajectoryPoint(2050, 152.883088516805),
    Boardcore::TrajectoryPoint(2060, 151.871256799619),
    Boardcore::TrajectoryPoint(2070, 150.858294897048),
    Boardcore::TrajectoryPoint(2080, 149.843972020582),
    Boardcore::TrajectoryPoint(2090, 148.828287827955),
    Boardcore::TrajectoryPoint(2100, 147.811258163349),
    Boardcore::TrajectoryPoint(2110, 146.7925899667),
    Boardcore::TrajectoryPoint(2120, 145.772345682949),
    Boardcore::TrajectoryPoint(2130, 144.750526889382),
    Boardcore::TrajectoryPoint(2140, 143.726718202982),
    Boardcore::TrajectoryPoint(2150, 142.70118667386),
    Boardcore::TrajectoryPoint(2160, 141.673661151085),
    Boardcore::TrajectoryPoint(2170, 140.64404463644),
    Boardcore::TrajectoryPoint(2180, 139.61242847161),
    Boardcore::TrajectoryPoint(2190, 138.578353838747),
    Boardcore::TrajectoryPoint(2200, 137.542161723912),
    Boardcore::TrajectoryPoint(2210, 136.503324714274),
    Boardcore::TrajectoryPoint(2220, 135.462120178032),
    Boardcore::TrajectoryPoint(2230, 134.418133457024),
    Boardcore::TrajectoryPoint(2240, 133.371515809618),
    Boardcore::TrajectoryPoint(2250, 132.321920488937),
    Boardcore::TrajectoryPoint(2260, 131.269475808892),
    Boardcore::TrajectoryPoint(2270, 130.213788640151),
    Boardcore::TrajectoryPoint(2280, 129.15508879324),
    Boardcore::TrajectoryPoint(2290, 128.092801045001),
    Boardcore::TrajectoryPoint(2300, 127.027323459846),
    Boardcore::TrajectoryPoint(2310, 125.957978752964),
    Boardcore::TrajectoryPoint(2320, 124.88507560579),
    Boardcore::TrajectoryPoint(2330, 123.808298050092),
    Boardcore::TrajectoryPoint(2340, 122.727387241368),
    Boardcore::TrajectoryPoint(2350, 121.642531080083),
    Boardcore::TrajectoryPoint(2360, 120.55315586054),
    Boardcore::TrajectoryPoint(2370, 119.45933964258),
    Boardcore::TrajectoryPoint(2380, 118.361060656959),
    Boardcore::TrajectoryPoint(2390, 117.257782162523),
    Boardcore::TrajectoryPoint(2400, 116.149501861304),
    Boardcore::TrajectoryPoint(2410, 115.036185150723),
    Boardcore::TrajectoryPoint(2420, 113.917600047795),
    Boardcore::TrajectoryPoint(2430, 112.793142225371),
    Boardcore::TrajectoryPoint(2440, 111.663012152568),
    Boardcore::TrajectoryPoint(2450, 110.526976572206),
    Boardcore::TrajectoryPoint(2460, 109.384792349785),
    Boardcore::TrajectoryPoint(2470, 108.236187671702),
    Boardcore::TrajectoryPoint(2480, 107.080650673299),
    Boardcore::TrajectoryPoint(2490, 105.918202985069),
    Boardcore::TrajectoryPoint(2500, 104.748560864017),
    Boardcore::TrajectoryPoint(2510, 103.57142844651),
    Boardcore::TrajectoryPoint(2520, 102.38649717625),
    Boardcore::TrajectoryPoint(2530, 101.193445191733),
    Boardcore::TrajectoryPoint(2540, 99.991936670758),
    Boardcore::TrajectoryPoint(2550, 98.7816211292266),
    Boardcore::TrajectoryPoint(2560, 97.5621326712553),
    Boardcore::TrajectoryPoint(2570, 96.3330891872948),
    Boardcore::TrajectoryPoint(2580, 95.0940914966348),
    Boardcore::TrajectoryPoint(2590, 93.8447224303209),
    Boardcore::TrajectoryPoint(2600, 92.5845458501197),
    Boardcore::TrajectoryPoint(2610, 91.3129069009138),
    Boardcore::TrajectoryPoint(2620, 90.0292056239672),
    Boardcore::TrajectoryPoint(2630, 88.733166807779),
    Boardcore::TrajectoryPoint(2640, 87.4242601066989),
    Boardcore::TrajectoryPoint(2650, 86.1016652129854),
    Boardcore::TrajectoryPoint(2660, 84.7644047274742),
    Boardcore::TrajectoryPoint(2670, 83.4123968030743),
    Boardcore::TrajectoryPoint(2680, 82.0443260764767),
    Boardcore::TrajectoryPoint(2690, 80.6595214378804),
    Boardcore::TrajectoryPoint(2700, 79.2571800420823),
    Boardcore::TrajectoryPoint(2710, 77.8360540888311),
    Boardcore::TrajectoryPoint(2720, 76.3951788167869),
    Boardcore::TrajectoryPoint(2730, 74.9337351145743),
    Boardcore::TrajectoryPoint(2740, 73.4494313334355),
    Boardcore::TrajectoryPoint(2750, 71.9417374365831),
    Boardcore::TrajectoryPoint(2760, 70.408962133249),
    Boardcore::TrajectoryPoint(2770, 68.8492599229072),
    Boardcore::TrajectoryPoint(2780, 67.2606139449578),
    Boardcore::TrajectoryPoint(2790, 65.6408164293912),
    Boardcore::TrajectoryPoint(2800, 63.9874463520398),
    Boardcore::TrajectoryPoint(2810, 62.2978438206664),
    Boardcore::TrajectoryPoint(2820, 60.5690806234602),
    Boardcore::TrajectoryPoint(2830, 58.7979262551143),
    Boardcore::TrajectoryPoint(2840, 56.9792624438792),
    Boardcore::TrajectoryPoint(2850, 55.1097547536487),
    Boardcore::TrajectoryPoint(2860, 53.1824280445218),
    Boardcore::TrajectoryPoint(2870, 51.1918767903957),
    Boardcore::TrajectoryPoint(2880, 49.1300045025326),
    Boardcore::TrajectoryPoint(2890, 46.9873289715247),
    Boardcore::TrajectoryPoint(2900, 44.7526773951407),
    Boardcore::TrajectoryPoint(2910, 42.4096376524901),
    Boardcore::TrajectoryPoint(2920, 39.9410271753139),
    Boardcore::TrajectoryPoint(2930, 37.3211423328618),
    Boardcore::TrajectoryPoint(2940, 34.5157836090082),
    Boardcore::TrajectoryPoint(2950, 31.4744185328222),
    Boardcore::TrajectoryPoint(2960, 28.1217474784409),
    Boardcore::TrajectoryPoint(2970, 24.3269920206659),
    Boardcore::TrajectoryPoint(2980, 19.8410937053959),
    Boardcore::TrajectoryPoint(2990, 14.0134721355646),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t7_open[] = {
    Boardcore::TrajectoryPoint(0, 462.397633914683),
    Boardcore::TrajectoryPoint(10, 460.235443345584),
    Boardcore::TrajectoryPoint(20, 458.07037540676),
    Boardcore::TrajectoryPoint(30, 455.890957654999),
    Boardcore::TrajectoryPoint(40, 453.711539903238),
    Boardcore::TrajectoryPoint(50, 451.514336157227),
    Boardcore::TrajectoryPoint(60, 449.314872751501),
    Boardcore::TrajectoryPoint(70, 447.102447050195),
    Boardcore::TrajectoryPoint(80, 444.88248484413),
    Boardcore::TrajectoryPoint(90, 442.654090226107),
    Boardcore::TrajectoryPoint(100, 440.413161786298),
    Boardcore::TrajectoryPoint(110, 438.168012938322),
    Boardcore::TrajectoryPoint(120, 435.905635928798),
    Boardcore::TrajectoryPoint(130, 433.642906965046),
    Boardcore::TrajectoryPoint(140, 431.358583498363),
    Boardcore::TrajectoryPoint(150, 429.07426003168),
    Boardcore::TrajectoryPoint(160, 426.770621538567),
    Boardcore::TrajectoryPoint(170, 424.463837491329),
    Boardcore::TrajectoryPoint(180, 422.140304646602),
    Boardcore::TrajectoryPoint(190, 419.81052893705),
    Boardcore::TrajectoryPoint(200, 417.466121489918),
    Boardcore::TrajectoryPoint(210, 415.112805315026),
    Boardcore::TrajectoryPoint(220, 412.74649108526),
    Boardcore::TrajectoryPoint(230, 410.369067114589),
    Boardcore::TrajectoryPoint(240, 407.979758821029),
    Boardcore::TrajectoryPoint(250, 405.577640344355),
    Boardcore::TrajectoryPoint(260, 403.164192202121),
    Boardcore::TrajectoryPoint(270, 400.736772227624),
    Boardcore::TrajectoryPoint(280, 398.297976294451),
    Boardcore::TrajectoryPoint(290, 395.84462659398),
    Boardcore::TrajectoryPoint(300, 393.379208844188),
    Boardcore::TrajectoryPoint(310, 390.899278941825),
    Boardcore::TrajectoryPoint(320, 388.405895044328),
    Boardcore::TrajectoryPoint(330, 385.898711144167),
    Boardcore::TrajectoryPoint(340, 383.375941918578),
    Boardcore::TrajectoryPoint(350, 380.840805767276),
    Boardcore::TrajectoryPoint(360, 378.287152289556),
    Boardcore::TrajectoryPoint(370, 375.723339968828),
    Boardcore::TrajectoryPoint(380, 373.137218295003),
    Boardcore::TrajectoryPoint(390, 370.543978938833),
    Boardcore::TrajectoryPoint(400, 367.923714412068),
    Boardcore::TrajectoryPoint(410, 365.298550667834),
    Boardcore::TrajectoryPoint(420, 362.644089945617),
    Boardcore::TrajectoryPoint(430, 360.13759133901),
    Boardcore::TrajectoryPoint(440, 358.099085747802),
    Boardcore::TrajectoryPoint(450, 356.072889850885),
    Boardcore::TrajectoryPoint(460, 354.061970737239),
    Boardcore::TrajectoryPoint(470, 352.069489138514),
    Boardcore::TrajectoryPoint(480, 350.086076424426),
    Boardcore::TrajectoryPoint(490, 348.127596012701),
    Boardcore::TrajectoryPoint(500, 346.176152646081),
    Boardcore::TrajectoryPoint(510, 344.247168241666),
    Boardcore::TrajectoryPoint(520, 342.330147222173),
    Boardcore::TrajectoryPoint(530, 340.427940681882),
    Boardcore::TrajectoryPoint(540, 338.545249299336),
    Boardcore::TrajectoryPoint(550, 336.670679152543),
    Boardcore::TrajectoryPoint(560, 334.820871155221),
    Boardcore::TrajectoryPoint(570, 332.980541718444),
    Boardcore::TrajectoryPoint(580, 331.156267128329),
    Boardcore::TrajectoryPoint(590, 329.349786541894),
    Boardcore::TrajectoryPoint(600, 327.552144764473),
    Boardcore::TrajectoryPoint(610, 325.777443337009),
    Boardcore::TrajectoryPoint(620, 324.013147463506),
    Boardcore::TrajectoryPoint(630, 322.262440190035),
    Boardcore::TrajectoryPoint(640, 320.530884304792),
    Boardcore::TrajectoryPoint(650, 318.808520904279),
    Boardcore::TrajectoryPoint(660, 317.104142370719),
    Boardcore::TrajectoryPoint(670, 315.413712439461),
    Boardcore::TrajectoryPoint(680, 313.732723863234),
    Boardcore::TrajectoryPoint(690, 312.072411112226),
    Boardcore::TrajectoryPoint(700, 310.422406043781),
    Boardcore::TrajectoryPoint(710, 308.78327137506),
    Boardcore::TrajectoryPoint(720, 307.163447856811),
    Boardcore::TrajectoryPoint(730, 305.552937960949),
    Boardcore::TrajectoryPoint(740, 303.954460520275),
    Boardcore::TrajectoryPoint(750, 302.373034789028),
    Boardcore::TrajectoryPoint(760, 300.800905195356),
    Boardcore::TrajectoryPoint(770, 299.240856843729),
    Boardcore::TrajectoryPoint(780, 297.696652145373),
    Boardcore::TrajectoryPoint(790, 296.161644441509),
    Boardcore::TrajectoryPoint(800, 294.637861430865),
    Boardcore::TrajectoryPoint(810, 293.129581333874),
    Boardcore::TrajectoryPoint(820, 291.630331411513),
    Boardcore::TrajectoryPoint(830, 290.14073024552),
    Boardcore::TrajectoryPoint(840, 288.666992602935),
    Boardcore::TrajectoryPoint(850, 287.202063770183),
    Boardcore::TrajectoryPoint(860, 285.746053584645),
    Boardcore::TrajectoryPoint(870, 284.304017520188),
    Boardcore::TrajectoryPoint(880, 282.871928631545),
    Boardcore::TrajectoryPoint(890, 281.448464679643),
    Boardcore::TrajectoryPoint(900, 280.035807398446),
    Boardcore::TrajectoryPoint(910, 278.635056173899),
    Boardcore::TrajectoryPoint(920, 277.242608452937),
    Boardcore::TrajectoryPoint(930, 275.858502482607),
    Boardcore::TrajectoryPoint(940, 274.486661176419),
    Boardcore::TrajectoryPoint(950, 273.123705797181),
    Boardcore::TrajectoryPoint(960, 271.768732511992),
    Boardcore::TrajectoryPoint(970, 270.422074303304),
    Boardcore::TrajectoryPoint(980, 269.087107076844),
    Boardcore::TrajectoryPoint(990, 267.759753212187),
    Boardcore::TrajectoryPoint(1000, 266.440004576942),
    Boardcore::TrajectoryPoint(1010, 265.128311681573),
    Boardcore::TrajectoryPoint(1020, 263.82709920524),
    Boardcore::TrajectoryPoint(1030, 262.533108315874),
    Boardcore::TrajectoryPoint(1040, 261.246310194749),
    Boardcore::TrajectoryPoint(1050, 259.966667118655),
    Boardcore::TrajectoryPoint(1060, 258.696807057942),
    Boardcore::TrajectoryPoint(1070, 257.433944327709),
    Boardcore::TrajectoryPoint(1080, 256.177841746167),
    Boardcore::TrajectoryPoint(1090, 254.928448305769),
    Boardcore::TrajectoryPoint(1100, 253.686723585107),
    Boardcore::TrajectoryPoint(1110, 252.452792674008),
    Boardcore::TrajectoryPoint(1120, 251.225180812935),
    Boardcore::TrajectoryPoint(1130, 250.003827736102),
    Boardcore::TrajectoryPoint(1140, 248.78866817845),
    Boardcore::TrajectoryPoint(1150, 247.58060240823),
    Boardcore::TrajectoryPoint(1160, 246.379347676669),
    Boardcore::TrajectoryPoint(1170, 245.183904611909),
    Boardcore::TrajectoryPoint(1180, 243.994202919291),
    Boardcore::TrajectoryPoint(1190, 242.810168826673),
    Boardcore::TrajectoryPoint(1200, 241.631826257504),
    Boardcore::TrajectoryPoint(1210, 240.460252941642),
    Boardcore::TrajectoryPoint(1220, 239.293979655657),
    Boardcore::TrajectoryPoint(1230, 238.13293054555),
    Boardcore::TrajectoryPoint(1240, 236.977027396809),
    Boardcore::TrajectoryPoint(1250, 235.826189914589),
    Boardcore::TrajectoryPoint(1260, 234.68033598262),
    Boardcore::TrajectoryPoint(1270, 233.540169128483),
    Boardcore::TrajectoryPoint(1280, 232.404907867877),
    Boardcore::TrajectoryPoint(1290, 231.274284562302),
    Boardcore::TrajectoryPoint(1300, 230.148218015763),
    Boardcore::TrajectoryPoint(1310, 229.026625882691),
    Boardcore::TrajectoryPoint(1320, 227.909424845357),
    Boardcore::TrajectoryPoint(1330, 226.796530776907),
    Boardcore::TrajectoryPoint(1340, 225.68796618519),
    Boardcore::TrajectoryPoint(1350, 224.583998032304),
    Boardcore::TrajectoryPoint(1360, 223.484017536951),
    Boardcore::TrajectoryPoint(1370, 222.38794304817),
    Boardcore::TrajectoryPoint(1380, 221.295692490901),
    Boardcore::TrajectoryPoint(1390, 220.207183475751),
    Boardcore::TrajectoryPoint(1400, 219.122333399233),
    Boardcore::TrajectoryPoint(1410, 218.04105953514),
    Boardcore::TrajectoryPoint(1420, 216.963279117685),
    Boardcore::TrajectoryPoint(1430, 215.888909416986),
    Boardcore::TrajectoryPoint(1440, 214.817867807446),
    Boardcore::TrajectoryPoint(1450, 213.750083832726),
    Boardcore::TrajectoryPoint(1460, 212.685665894992),
    Boardcore::TrajectoryPoint(1470, 211.624296878631),
    Boardcore::TrajectoryPoint(1480, 210.565897664973),
    Boardcore::TrajectoryPoint(1490, 209.510389353984),
    Boardcore::TrajectoryPoint(1500, 208.457693307672),
    Boardcore::TrajectoryPoint(1510, 207.407731188852),
    Boardcore::TrajectoryPoint(1520, 206.360424995579),
    Boardcore::TrajectoryPoint(1530, 205.315697091597),
    Boardcore::TrajectoryPoint(1540, 204.273470233066),
    Boardcore::TrajectoryPoint(1550, 203.233667591861),
    Boardcore::TrajectoryPoint(1560, 202.196212775688),
    Boardcore::TrajectoryPoint(1570, 201.161029845251),
    Boardcore::TrajectoryPoint(1580, 200.12804332869),
    Boardcore::TrajectoryPoint(1590, 199.097178233499),
    Boardcore::TrajectoryPoint(1600, 198.068360056101),
    Boardcore::TrajectoryPoint(1610, 197.041514789263),
    Boardcore::TrajectoryPoint(1620, 196.016568927516),
    Boardcore::TrajectoryPoint(1630, 194.993449470716),
    Boardcore::TrajectoryPoint(1640, 193.972083925906),
    Boardcore::TrajectoryPoint(1650, 192.952400307594),
    Boardcore::TrajectoryPoint(1660, 191.934327136566),
    Boardcore::TrajectoryPoint(1670, 190.917793437358),
    Boardcore::TrajectoryPoint(1680, 189.902728734478),
    Boardcore::TrajectoryPoint(1690, 188.889063047474),
    Boardcore::TrajectoryPoint(1700, 187.876726884945),
    Boardcore::TrajectoryPoint(1710, 186.865663009281),
    Boardcore::TrajectoryPoint(1720, 185.855850235006),
    Boardcore::TrajectoryPoint(1730, 184.84715737694),
    Boardcore::TrajectoryPoint(1740, 183.839516144088),
    Boardcore::TrajectoryPoint(1750, 182.832858718749),
    Boardcore::TrajectoryPoint(1760, 181.827117743862),
    Boardcore::TrajectoryPoint(1770, 180.822226309841),
    Boardcore::TrajectoryPoint(1780, 179.818117940942),
    Boardcore::TrajectoryPoint(1790, 178.814726581185),
    Boardcore::TrajectoryPoint(1800, 177.811986579881),
    Boardcore::TrajectoryPoint(1810, 176.809838119547),
    Boardcore::TrajectoryPoint(1820, 175.808253100213),
    Boardcore::TrajectoryPoint(1830, 174.80711378117),
    Boardcore::TrajectoryPoint(1840, 173.806355549807),
    Boardcore::TrajectoryPoint(1850, 172.805914132738),
    Boardcore::TrajectoryPoint(1860, 171.805725578494),
    Boardcore::TrajectoryPoint(1870, 170.805726240047),
    Boardcore::TrajectoryPoint(1880, 169.805856817865),
    Boardcore::TrajectoryPoint(1890, 168.806042787053),
    Boardcore::TrajectoryPoint(1900, 167.806213924106),
    Boardcore::TrajectoryPoint(1910, 166.806307278099),
    Boardcore::TrajectoryPoint(1920, 165.806260116703),
    Boardcore::TrajectoryPoint(1930, 164.80599659178),
    Boardcore::TrajectoryPoint(1940, 163.805429324137),
    Boardcore::TrajectoryPoint(1950, 162.804517240695),
    Boardcore::TrajectoryPoint(1960, 161.803197982393),
    Boardcore::TrajectoryPoint(1970, 160.801409312548),
    Boardcore::TrajectoryPoint(1980, 159.798997187855),
    Boardcore::TrajectoryPoint(1990, 158.795966559873),
    Boardcore::TrajectoryPoint(2000, 157.792260906707),
    Boardcore::TrajectoryPoint(2010, 156.787806325795),
    Boardcore::TrajectoryPoint(2020, 155.782409095975),
    Boardcore::TrajectoryPoint(2030, 154.776129189331),
    Boardcore::TrajectoryPoint(2040, 153.768904048119),
    Boardcore::TrajectoryPoint(2050, 152.760543711486),
    Boardcore::TrajectoryPoint(2060, 151.751018022556),
    Boardcore::TrajectoryPoint(2070, 150.740336342782),
    Boardcore::TrajectoryPoint(2080, 149.728313002663),
    Boardcore::TrajectoryPoint(2090, 148.714854347078),
    Boardcore::TrajectoryPoint(2100, 147.700025491233),
    Boardcore::TrajectoryPoint(2110, 146.68358169559),
    Boardcore::TrajectoryPoint(2120, 145.665485407726),
    Boardcore::TrajectoryPoint(2130, 144.645800514646),
    Boardcore::TrajectoryPoint(2140, 143.624132393797),
    Boardcore::TrajectoryPoint(2150, 142.600674112231),
    Boardcore::TrajectoryPoint(2160, 141.575252800392),
    Boardcore::TrajectoryPoint(2170, 140.547659602528),
    Boardcore::TrajectoryPoint(2180, 139.518092692902),
    Boardcore::TrajectoryPoint(2190, 138.486001428335),
    Boardcore::TrajectoryPoint(2200, 137.451762156966),
    Boardcore::TrajectoryPoint(2210, 136.414911108661),
    Boardcore::TrajectoryPoint(2220, 135.375612141149),
    Boardcore::TrajectoryPoint(2230, 134.33356597689),
    Boardcore::TrajectoryPoint(2240, 133.288807605255),
    Boardcore::TrajectoryPoint(2250, 132.241107629252),
    Boardcore::TrajectoryPoint(2260, 131.190476880746),
    Boardcore::TrajectoryPoint(2270, 130.136640089795),
    Boardcore::TrajectoryPoint(2280, 129.079709745034),
    Boardcore::TrajectoryPoint(2290, 128.019227694172),
    Boardcore::TrajectoryPoint(2300, 126.955535450231),
    Boardcore::TrajectoryPoint(2310, 125.887892690958),
    Boardcore::TrajectoryPoint(2320, 124.816730459637),
    Boardcore::TrajectoryPoint(2330, 123.74161255563),
    Boardcore::TrajectoryPoint(2340, 122.662398610935),
    Boardcore::TrajectoryPoint(2350, 121.57921868346),
    Boardcore::TrajectoryPoint(2360, 120.491438585126),
    Boardcore::TrajectoryPoint(2370, 119.399254954373),
    Boardcore::TrajectoryPoint(2380, 118.302587812889),
    Boardcore::TrajectoryPoint(2390, 117.200841599021),
    Boardcore::TrajectoryPoint(2400, 116.094129965689),
    Boardcore::TrajectoryPoint(2410, 114.982361141851),
    Boardcore::TrajectoryPoint(2420, 113.865247086013),
    Boardcore::TrajectoryPoint(2430, 112.74229448804),
    Boardcore::TrajectoryPoint(2440, 111.613648877891),
    Boardcore::TrajectoryPoint(2450, 110.479076945498),
    Boardcore::TrajectoryPoint(2460, 109.338335515056),
    Boardcore::TrajectoryPoint(2470, 108.191099724562),
    Boardcore::TrajectoryPoint(2480, 107.036963641165),
    Boardcore::TrajectoryPoint(2490, 105.875896116026),
    Boardcore::TrajectoryPoint(2500, 104.707613392722),
    Boardcore::TrajectoryPoint(2510, 103.531819602235),
    Boardcore::TrajectoryPoint(2520, 102.34820619028),
    Boardcore::TrajectoryPoint(2530, 101.156451304186),
    Boardcore::TrajectoryPoint(2540, 99.9562191368821),
    Boardcore::TrajectoryPoint(2550, 98.7471592252312),
    Boardcore::TrajectoryPoint(2560, 97.5289056997189),
    Boardcore::TrajectoryPoint(2570, 96.3010764821944),
    Boardcore::TrajectoryPoint(2580, 95.0632724280339),
    Boardcore::TrajectoryPoint(2590, 93.815076408749),
    Boardcore::TrajectoryPoint(2600, 92.5560523306727),
    Boardcore::TrajectoryPoint(2610, 91.2855871164063),
    Boardcore::TrajectoryPoint(2620, 90.002995795025),
    Boardcore::TrajectoryPoint(2630, 88.7080464664619),
    Boardcore::TrajectoryPoint(2640, 87.4002088477987),
    Boardcore::TrajectoryPoint(2650, 86.0787007076121),
    Boardcore::TrajectoryPoint(2660, 84.7424667140484),
    Boardcore::TrajectoryPoint(2670, 83.3914650200792),
    Boardcore::TrajectoryPoint(2680, 82.0244150950226),
    Boardcore::TrajectoryPoint(2690, 80.6405741704461),
    Boardcore::TrajectoryPoint(2700, 79.2392093358966),
    Boardcore::TrajectoryPoint(2710, 77.8190046452144),
    Boardcore::TrajectoryPoint(2720, 76.3790612813234),
    Boardcore::TrajectoryPoint(2730, 74.9184965157595),
    Boardcore::TrajectoryPoint(2740, 73.4350796888294),
    Boardcore::TrajectoryPoint(2750, 71.928249956016),
    Boardcore::TrajectoryPoint(2760, 70.3963158340585),
    Boardcore::TrajectoryPoint(2770, 68.8374316536634),
    Boardcore::TrajectoryPoint(2780, 67.2495804075891),
    Boardcore::TrajectoryPoint(2790, 65.6305541997953),
    Boardcore::TrajectoryPoint(2800, 63.9779318992499),
    Boardcore::TrajectoryPoint(2810, 62.2890535246224),
    Boardcore::TrajectoryPoint(2820, 60.5609907914265),
    Boardcore::TrajectoryPoint(2830, 58.790513136769),
    Boardcore::TrajectoryPoint(2840, 56.9725202630961),
    Boardcore::TrajectoryPoint(2850, 55.1036397992158),
    Boardcore::TrajectoryPoint(2860, 53.1769318750686),
    Boardcore::TrajectoryPoint(2870, 51.1869724843178),
    Boardcore::TrajectoryPoint(2880, 49.1256647246566),
    Boardcore::TrajectoryPoint(2890, 46.9835260160829),
    Boardcore::TrajectoryPoint(2900, 44.7493832229852),
    Boardcore::TrajectoryPoint(2910, 42.406834016481),
    Boardcore::TrajectoryPoint(2920, 39.93868262156),
    Boardcore::TrajectoryPoint(2930, 37.3192245374569),
    Boardcore::TrajectoryPoint(2940, 34.5142664449591),
    Boardcore::TrajectoryPoint(2950, 31.4732650955334),
    Boardcore::TrajectoryPoint(2960, 28.1209192843493),
    Boardcore::TrajectoryPoint(2970, 24.3264552405386),
    Boardcore::TrajectoryPoint(2980, 19.8408014022802),
    Boardcore::TrajectoryPoint(2990, 14.0133692779701),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t8_open[] = {
    Boardcore::TrajectoryPoint(0, 460.225158627655),
    Boardcore::TrajectoryPoint(10, 458.060827677211),
    Boardcore::TrajectoryPoint(20, 455.890588079475),
    Boardcore::TrajectoryPoint(30, 453.717152539828),
    Boardcore::TrajectoryPoint(40, 451.527056922347),
    Boardcore::TrajectoryPoint(50, 449.336961304867),
    Boardcore::TrajectoryPoint(60, 447.12853264931),
    Boardcore::TrajectoryPoint(70, 444.918134001297),
    Boardcore::TrajectoryPoint(80, 442.69382987869),
    Boardcore::TrajectoryPoint(90, 440.462667163239),
    Boardcore::TrajectoryPoint(100, 438.221711471348),
    Boardcore::TrajectoryPoint(110, 435.969309023959),
    Boardcore::TrajectoryPoint(120, 433.710885755415),
    Boardcore::TrajectoryPoint(130, 431.436752650058),
    Boardcore::TrajectoryPoint(140, 429.160003568699),
    Boardcore::TrajectoryPoint(150, 426.863632949304),
    Boardcore::TrajectoryPoint(160, 424.567262329909),
    Boardcore::TrajectoryPoint(170, 422.248523479768),
    Boardcore::TrajectoryPoint(180, 419.929391854839),
    Boardcore::TrajectoryPoint(190, 417.589933044757),
    Boardcore::TrajectoryPoint(200, 415.247499542649),
    Boardcore::TrajectoryPoint(210, 412.886302056624),
    Boardcore::TrajectoryPoint(220, 410.520007638815),
    Boardcore::TrajectoryPoint(230, 408.135998651014),
    Boardcore::TrajectoryPoint(240, 405.745265280491),
    Boardcore::TrajectoryPoint(250, 403.337314531361),
    Boardcore::TrajectoryPoint(260, 400.921544293022),
    Boardcore::TrajectoryPoint(270, 398.488460521606),
    Boardcore::TrajectoryPoint(280, 396.047034691304),
    Boardcore::TrajectoryPoint(290, 393.587561802997),
    Boardcore::TrajectoryPoint(300, 391.119839861583),
    Boardcore::TrajectoryPoint(310, 388.632652808532),
    Boardcore::TrajectoryPoint(320, 386.137971396961),
    Boardcore::TrajectoryPoint(330, 383.621671746041),
    Boardcore::TrajectoryPoint(340, 381.099343557243),
    Boardcore::TrajectoryPoint(350, 378.552454718058),
    Boardcore::TrajectoryPoint(360, 376.001767320946),
    Boardcore::TrajectoryPoint(370, 373.422729403494),
    Boardcore::TrajectoryPoint(380, 370.839758188705),
    Boardcore::TrajectoryPoint(390, 368.230108262556),
    Boardcore::TrajectoryPoint(400, 365.61239128173),
    Boardcore::TrajectoryPoint(410, 362.972081222503),
    Boardcore::TrajectoryPoint(420, 360.600532583615),
    Boardcore::TrajectoryPoint(430, 358.56610459273),
    Boardcore::TrajectoryPoint(440, 356.549282977082),
    Boardcore::TrajectoryPoint(450, 354.542142437385),
    Boardcore::TrajectoryPoint(460, 352.558554576556),
    Boardcore::TrajectoryPoint(470, 350.581415461934),
    Boardcore::TrajectoryPoint(480, 348.628589788952),
    Boardcore::TrajectoryPoint(490, 346.685350540421),
    Boardcore::TrajectoryPoint(500, 344.759383999265),
    Boardcore::TrajectoryPoint(510, 342.850111062785),
    Boardcore::TrajectoryPoint(520, 340.950710877523),
    Boardcore::TrajectoryPoint(530, 339.075331726986),
    Boardcore::TrajectoryPoint(540, 337.207833696383),
    Boardcore::TrajectoryPoint(550, 335.360465243744),
    Boardcore::TrajectoryPoint(560, 333.526798568999),
    Boardcore::TrajectoryPoint(570, 331.704805845707),
    Boardcore::TrajectoryPoint(580, 329.90460204722),
    Boardcore::TrajectoryPoint(590, 328.113002006336),
    Boardcore::TrajectoryPoint(600, 326.340312726937),
    Boardcore::TrajectoryPoint(610, 324.581705479725),
    Boardcore::TrajectoryPoint(620, 322.832896092653),
    Boardcore::TrajectoryPoint(630, 321.106699145628),
    Boardcore::TrajectoryPoint(640, 319.389478232561),
    Boardcore::TrajectoryPoint(650, 317.686805072571),
    Boardcore::TrajectoryPoint(660, 316.001221944481),
    Boardcore::TrajectoryPoint(670, 314.324876766447),
    Boardcore::TrajectoryPoint(680, 312.666118625682),
    Boardcore::TrajectoryPoint(690, 311.02049480437),
    Boardcore::TrajectoryPoint(700, 309.384254168177),
    Boardcore::TrajectoryPoint(710, 307.767168727173),
    Boardcore::TrajectoryPoint(720, 306.160621970143),
    Boardcore::TrajectoryPoint(730, 304.563536852513),
    Boardcore::TrajectoryPoint(740, 302.985862787341),
    Boardcore::TrajectoryPoint(750, 301.417324686885),
    Boardcore::TrajectoryPoint(760, 299.858594886426),
    Boardcore::TrajectoryPoint(770, 298.317798455729),
    Boardcore::TrajectoryPoint(780, 296.786054868447),
    Boardcore::TrajectoryPoint(790, 295.263554407357),
    Boardcore::TrajectoryPoint(800, 293.758365361645),
    Boardcore::TrajectoryPoint(810, 292.262093530493),
    Boardcore::TrajectoryPoint(820, 290.774873383291),
    Boardcore::TrajectoryPoint(830, 289.302832212465),
    Boardcore::TrajectoryPoint(840, 287.840633506221),
    Boardcore::TrajectoryPoint(850, 286.38724491854),
    Boardcore::TrajectoryPoint(860, 284.9464192575),
    Boardcore::TrajectoryPoint(870, 283.516847173471),
    Boardcore::TrajectoryPoint(880, 282.095804916018),
    Boardcore::TrajectoryPoint(890, 280.684357061787),
    Boardcore::TrajectoryPoint(900, 279.285940582769),
    Boardcore::TrajectoryPoint(910, 277.895744766523),
    Boardcore::TrajectoryPoint(920, 276.513812656106),
    Boardcore::TrajectoryPoint(930, 275.143195668429),
    Boardcore::TrajectoryPoint(940, 273.782349295054),
    Boardcore::TrajectoryPoint(950, 272.429417730194),
    Boardcore::TrajectoryPoint(960, 271.084410830051),
    Boardcore::TrajectoryPoint(970, 269.751025072264),
    Boardcore::TrajectoryPoint(980, 268.425603608007),
    Boardcore::TrajectoryPoint(990, 267.107733687241),
    Boardcore::TrajectoryPoint(1000, 265.797399807829),
    Boardcore::TrajectoryPoint(1010, 264.497951535638),
    Boardcore::TrajectoryPoint(1020, 263.205758511223),
    Boardcore::TrajectoryPoint(1030, 261.92071630529),
    Boardcore::TrajectoryPoint(1040, 260.642790504593),
    Boardcore::TrajectoryPoint(1050, 259.374272699812),
    Boardcore::TrajectoryPoint(1060, 258.11310898435),
    Boardcore::TrajectoryPoint(1070, 256.858673506351),
    Boardcore::TrajectoryPoint(1080, 255.610918116137),
    Boardcore::TrajectoryPoint(1090, 254.370588675944),
    Boardcore::TrajectoryPoint(1100, 253.138288003133),
    Boardcore::TrajectoryPoint(1110, 251.912283004352),
    Boardcore::TrajectoryPoint(1120, 250.692515867601),
    Boardcore::TrajectoryPoint(1130, 249.478923672416),
    Boardcore::TrajectoryPoint(1140, 248.272328947581),
    Boardcore::TrajectoryPoint(1150, 247.07264476411),
    Boardcore::TrajectoryPoint(1160, 245.878758200015),
    Boardcore::TrajectoryPoint(1170, 244.690600963531),
    Boardcore::TrajectoryPoint(1180, 243.508101191825),
    Boardcore::TrajectoryPoint(1190, 242.331308588339),
    Boardcore::TrajectoryPoint(1200, 241.161281253334),
    Boardcore::TrajectoryPoint(1210, 239.996547412052),
    Boardcore::TrajectoryPoint(1220, 238.837032838022),
    Boardcore::TrajectoryPoint(1230, 237.682660866122),
    Boardcore::TrajectoryPoint(1240, 236.533352675932),
    Boardcore::TrajectoryPoint(1250, 235.389027553791),
    Boardcore::TrajectoryPoint(1260, 234.250530863091),
    Boardcore::TrajectoryPoint(1270, 233.116819259572),
    Boardcore::TrajectoryPoint(1280, 231.987747684033),
    Boardcore::TrajectoryPoint(1290, 230.863236135885),
    Boardcore::TrajectoryPoint(1300, 229.74320340651),
    Boardcore::TrajectoryPoint(1310, 228.627567259413),
    Boardcore::TrajectoryPoint(1320, 227.51624459592),
    Boardcore::TrajectoryPoint(1330, 226.409469248984),
    Boardcore::TrajectoryPoint(1340, 225.30709957678),
    Boardcore::TrajectoryPoint(1350, 224.20872589254),
    Boardcore::TrajectoryPoint(1360, 223.114267425288),
    Boardcore::TrajectoryPoint(1370, 222.02364293744),
    Boardcore::TrajectoryPoint(1380, 220.936770836753),
    Boardcore::TrajectoryPoint(1390, 219.853569278661),
    Boardcore::TrajectoryPoint(1400, 218.773956259666),
    Boardcore::TrajectoryPoint(1410, 217.697849702414),
    Boardcore::TrajectoryPoint(1420, 216.625167533046),
    Boardcore::TrajectoryPoint(1430, 215.55585001901),
    Boardcore::TrajectoryPoint(1440, 214.490024358546),
    Boardcore::TrajectoryPoint(1450, 213.427341693082),
    Boardcore::TrajectoryPoint(1460, 212.367723303371),
    Boardcore::TrajectoryPoint(1470, 211.311090614979),
    Boardcore::TrajectoryPoint(1480, 210.25736524819),
    Boardcore::TrajectoryPoint(1490, 209.206469062826),
    Boardcore::TrajectoryPoint(1500, 208.158324198361),
    Boardcore::TrajectoryPoint(1510, 207.112853109651),
    Boardcore::TrajectoryPoint(1520, 206.069978598616),
    Boardcore::TrajectoryPoint(1530, 205.029623842161),
    Boardcore::TrajectoryPoint(1540, 203.991712416602),
    Boardcore::TrajectoryPoint(1550, 202.956168318874),
    Boardcore::TrajectoryPoint(1560, 201.922915984732),
    Boardcore::TrajectoryPoint(1570, 200.891880304192),
    Boardcore::TrajectoryPoint(1580, 199.862986634396),
    Boardcore::TrajectoryPoint(1590, 198.836160810104),
    Boardcore::TrajectoryPoint(1600, 197.811329151986),
    Boardcore::TrajectoryPoint(1610, 196.788418472877),
    Boardcore::TrajectoryPoint(1620, 195.767356082146),
    Boardcore::TrajectoryPoint(1630, 194.748069788334),
    Boardcore::TrajectoryPoint(1640, 193.730487900163),
    Boardcore::TrajectoryPoint(1650, 192.714539226076),
    Boardcore::TrajectoryPoint(1660, 191.700153072382),
    Boardcore::TrajectoryPoint(1670, 190.687259240141),
    Boardcore::TrajectoryPoint(1680, 189.675788020869),
    Boardcore::TrajectoryPoint(1690, 188.665670191153),
    Boardcore::TrajectoryPoint(1700, 187.656837006272),
    Boardcore::TrajectoryPoint(1710, 186.649220192878),
    Boardcore::TrajectoryPoint(1720, 185.642751940835),
    Boardcore::TrajectoryPoint(1730, 184.637419580132),
    Boardcore::TrajectoryPoint(1740, 183.633112787216),
    Boardcore::TrajectoryPoint(1750, 182.629748140797),
    Boardcore::TrajectoryPoint(1760, 181.627258982997),
    Boardcore::TrajectoryPoint(1770, 180.625579090403),
    Boardcore::TrajectoryPoint(1780, 179.624642660436),
    Boardcore::TrajectoryPoint(1790, 178.624384297304),
    Boardcore::TrajectoryPoint(1800, 177.624738997579),
    Boardcore::TrajectoryPoint(1810, 176.625642135409),
    Boardcore::TrajectoryPoint(1820, 175.627048332103),
    Boardcore::TrajectoryPoint(1830, 174.628892826532),
    Boardcore::TrajectoryPoint(1840, 173.631082404712),
    Boardcore::TrajectoryPoint(1850, 172.633553387318),
    Boardcore::TrajectoryPoint(1860, 171.636242404004),
    Boardcore::TrajectoryPoint(1870, 170.639086376094),
    Boardcore::TrajectoryPoint(1880, 169.642022660055),
    Boardcore::TrajectoryPoint(1890, 168.644983688203),
    Boardcore::TrajectoryPoint(1900, 167.647897161843),
    Boardcore::TrajectoryPoint(1910, 166.650700655175),
    Boardcore::TrajectoryPoint(1920, 165.653331948817),
    Boardcore::TrajectoryPoint(1930, 164.655729011007),
    Boardcore::TrajectoryPoint(1940, 163.657777492209),
    Boardcore::TrajectoryPoint(1950, 162.659449336997),
    Boardcore::TrajectoryPoint(1960, 161.66068421371),
    Boardcore::TrajectoryPoint(1970, 160.661420344365),
    Boardcore::TrajectoryPoint(1980, 159.661529454477),
    Boardcore::TrajectoryPoint(1990, 158.660963224684),
    Boardcore::TrajectoryPoint(2000, 157.659693928947),
    Boardcore::TrajectoryPoint(2010, 156.657659736065),
    Boardcore::TrajectoryPoint(2020, 155.654665510178),
    Boardcore::TrajectoryPoint(2030, 154.650736783788),
    Boardcore::TrajectoryPoint(2040, 153.645836393936),
    Boardcore::TrajectoryPoint(2050, 152.639815634879),
    Boardcore::TrajectoryPoint(2060, 151.632559109384),
    Boardcore::TrajectoryPoint(2070, 150.624121286739),
    Boardcore::TrajectoryPoint(2080, 149.614362850805),
    Boardcore::TrajectoryPoint(2090, 148.603094371682),
    Boardcore::TrajectoryPoint(2100, 147.59043143727),
    Boardcore::TrajectoryPoint(2110, 146.576178586317),
    Boardcore::TrajectoryPoint(2120, 145.560196371771),
    Boardcore::TrajectoryPoint(2130, 144.542602278495),
    Boardcore::TrajectoryPoint(2140, 143.523052072881),
    Boardcore::TrajectoryPoint(2150, 142.501634490951),
    Boardcore::TrajectoryPoint(2160, 141.478285810006),
    Boardcore::TrajectoryPoint(2170, 140.452684283189),
    Boardcore::TrajectoryPoint(2180, 139.425087271677),
    Boardcore::TrajectoryPoint(2190, 138.39499709614),
    Boardcore::TrajectoryPoint(2200, 137.36268030029),
    Boardcore::TrajectoryPoint(2210, 136.327785520017),
    Boardcore::TrajectoryPoint(2220, 135.29036259647),
    Boardcore::TrajectoryPoint(2230, 134.250228010162),
    Boardcore::TrajectoryPoint(2240, 133.207300211008),
    Boardcore::TrajectoryPoint(2250, 132.16146731737),
    Boardcore::TrajectoryPoint(2260, 131.112622597485),
    Boardcore::TrajectoryPoint(2270, 130.060608638202),
    Boardcore::TrajectoryPoint(2280, 129.005420672615),
    Boardcore::TrajectoryPoint(2290, 127.946717487085),
    Boardcore::TrajectoryPoint(2300, 126.884744596487),
    Boardcore::TrajectoryPoint(2310, 125.818817288415),
    Boardcore::TrajectoryPoint(2320, 124.749370155219),
    Boardcore::TrajectoryPoint(2330, 123.675886683407),
    Boardcore::TrajectoryPoint(2340, 122.598344493785),
    Boardcore::TrajectoryPoint(2350, 121.516816003502),
    Boardcore::TrajectoryPoint(2360, 120.4306069112),
    Boardcore::TrajectoryPoint(2370, 119.340031774419),
    Boardcore::TrajectoryPoint(2380, 118.244952701412),
    Boardcore::TrajectoryPoint(2390, 117.144715719891),
    Boardcore::TrajectoryPoint(2400, 116.039549674239),
    Boardcore::TrajectoryPoint(2410, 114.929305977268),
    Boardcore::TrajectoryPoint(2420, 113.813640951632),
    Boardcore::TrajectoryPoint(2430, 112.692171504006),
    Boardcore::TrajectoryPoint(2440, 111.564988603613),
    Boardcore::TrajectoryPoint(2450, 110.431858889115),
    Boardcore::TrajectoryPoint(2460, 109.292539144684),
    Boardcore::TrajectoryPoint(2470, 108.146651923078),
    Boardcore::TrajectoryPoint(2480, 106.993896318974),
    Boardcore::TrajectoryPoint(2490, 105.834188843554),
    Boardcore::TrajectoryPoint(2500, 104.667245727425),
    Boardcore::TrajectoryPoint(2510, 103.492771096417),
    Boardcore::TrajectoryPoint(2520, 102.310456398281),
    Boardcore::TrajectoryPoint(2530, 101.119979789019),
    Boardcore::TrajectoryPoint(2540, 99.9210054763542),
    Boardcore::TrajectoryPoint(2550, 98.7131830176197),
    Boardcore::TrajectoryPoint(2560, 97.4961465690349),
    Boardcore::TrajectoryPoint(2570, 96.2695140830807),
    Boardcore::TrajectoryPoint(2580, 95.0328864503311),
    Boardcore::TrajectoryPoint(2590, 93.7858465817633),
    Boardcore::TrajectoryPoint(2600, 92.527958427174),
    Boardcore::TrajectoryPoint(2610, 91.2586502277028),
    Boardcore::TrajectoryPoint(2620, 89.9771529321354),
    Boardcore::TrajectoryPoint(2630, 88.6832774768333),
    Boardcore::TrajectoryPoint(2640, 87.3764936400697),
    Boardcore::TrajectoryPoint(2650, 86.0560568305342),
    Boardcore::TrajectoryPoint(2660, 84.7208346757805),
    Boardcore::TrajectoryPoint(2670, 83.3708248691008),
    Boardcore::TrajectoryPoint(2680, 82.0047813044633),
    Boardcore::TrajectoryPoint(2690, 80.6218903943517),
    Boardcore::TrajectoryPoint(2700, 79.2214883351223),
    Boardcore::TrajectoryPoint(2710, 77.8021918479618),
    Boardcore::TrajectoryPoint(2720, 76.3631672672388),
    Boardcore::TrajectoryPoint(2730, 74.9034690154056),
    Boardcore::TrajectoryPoint(2740, 73.4209266819527),
    Boardcore::TrajectoryPoint(2750, 71.914948985735),
    Boardcore::TrajectoryPoint(2760, 70.3838442538021),
    Boardcore::TrajectoryPoint(2770, 68.825766650394),
    Boardcore::TrajectoryPoint(2780, 67.2386990234673),
    Boardcore::TrajectoryPoint(2790, 65.620433352368),
    Boardcore::TrajectoryPoint(2800, 63.9685484002282),
    Boardcore::TrajectoryPoint(2810, 62.2803840972997),
    Boardcore::TrajectoryPoint(2820, 60.5530120867743),
    Boardcore::TrajectoryPoint(2830, 58.7832017482358),
    Boardcore::TrajectoryPoint(2840, 56.9658705262602),
    Boardcore::TrajectoryPoint(2850, 55.0976086028241),
    Boardcore::TrajectoryPoint(2860, 53.1715109212917),
    Boardcore::TrajectoryPoint(2870, 51.1821352332448),
    Boardcore::TrajectoryPoint(2880, 49.1213842281489),
    Boardcore::TrajectoryPoint(2890, 46.9797749599281),
    Boardcore::TrajectoryPoint(2900, 44.7461339634083),
    Boardcore::TrajectoryPoint(2910, 42.4040685718622),
    Boardcore::TrajectoryPoint(2920, 39.9363699767986),
    Boardcore::TrajectoryPoint(2930, 37.3173328187741),
    Boardcore::TrajectoryPoint(2940, 34.5127698921887),
    Boardcore::TrajectoryPoint(2950, 31.47212731394),
    Boardcore::TrajectoryPoint(2960, 28.1201023207981),
    Boardcore::TrajectoryPoint(2970, 24.3259257330043),
    Boardcore::TrajectoryPoint(2980, 19.8405130559335),
    Boardcore::TrajectoryPoint(2990, 14.0132678114949),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t9_open[] = {
    Boardcore::TrajectoryPoint(0, 458.068111201296),
    Boardcore::TrajectoryPoint(10, 455.903232083041),
    Boardcore::TrajectoryPoint(20, 453.731294762838),
    Boardcore::TrajectoryPoint(30, 451.550458784949),
    Boardcore::TrajectoryPoint(40, 449.365979273495),
    Boardcore::TrajectoryPoint(50, 447.165033113314),
    Boardcore::TrajectoryPoint(60, 444.964086953132),
    Boardcore::TrajectoryPoint(70, 442.743713887406),
    Boardcore::TrajectoryPoint(80, 440.522202777176),
    Boardcore::TrajectoryPoint(90, 438.285279281955),
    Boardcore::TrajectoryPoint(100, 436.042734094565),
    Boardcore::TrajectoryPoint(110, 433.788453859129),
    Boardcore::TrajectoryPoint(120, 431.52439048872),
    Boardcore::TrajectoryPoint(130, 429.25190567503),
    Boardcore::TrajectoryPoint(140, 426.965824383976),
    Boardcore::TrajectoryPoint(150, 424.674243194965),
    Boardcore::TrajectoryPoint(160, 422.365627925012),
    Boardcore::TrajectoryPoint(170, 420.05401200263),
    Boardcore::TrajectoryPoint(180, 417.722329647801),
    Boardcore::TrajectoryPoint(190, 415.389691287021),
    Boardcore::TrajectoryPoint(200, 413.034390925723),
    Boardcore::TrajectoryPoint(210, 410.679090564424),
    Boardcore::TrajectoryPoint(220, 408.300202172946),
    Boardcore::TrajectoryPoint(230, 405.920714256477),
    Boardcore::TrajectoryPoint(240, 403.518078785598),
    Boardcore::TrajectoryPoint(250, 401.113814280072),
    Boardcore::TrajectoryPoint(260, 398.686256799372),
    Boardcore::TrajectoryPoint(270, 396.256606277798),
    Boardcore::TrajectoryPoint(280, 393.802888240271),
    Boardcore::TrajectoryPoint(290, 391.34722092127),
    Boardcore::TrajectoryPoint(300, 388.866036142908),
    Boardcore::TrajectoryPoint(310, 386.383353037444),
    Boardcore::TrajectoryPoint(320, 383.873669208376),
    Boardcore::TrajectoryPoint(330, 381.361387663329),
    Boardcore::TrajectoryPoint(340, 378.823656070934),
    Boardcore::TrajectoryPoint(350, 376.280265514635),
    Boardcore::TrajectoryPoint(360, 373.713759139729),
    Boardcore::TrajectoryPoint(370, 371.137663261419),
    Boardcore::TrajectoryPoint(380, 368.541627978403),
    Boardcore::TrajectoryPoint(390, 365.931138978654),
    Boardcore::TrajectoryPoint(400, 363.304792181678),
    Boardcore::TrajectoryPoint(410, 361.067487354075),
    Boardcore::TrajectoryPoint(420, 359.037010464157),
    Boardcore::TrajectoryPoint(430, 357.029475921839),
    Boardcore::TrajectoryPoint(440, 355.027749159478),
    Boardcore::TrajectoryPoint(450, 353.051215784041),
    Boardcore::TrajectoryPoint(460, 351.082686316867),
    Boardcore::TrajectoryPoint(470, 349.132984133428),
    Boardcore::TrajectoryPoint(480, 347.197887639702),
    Boardcore::TrajectoryPoint(490, 345.274813220192),
    Boardcore::TrajectoryPoint(500, 343.373233811463),
    Boardcore::TrajectoryPoint(510, 341.479094332052),
    Boardcore::TrajectoryPoint(520, 339.608399395929),
    Boardcore::TrajectoryPoint(530, 337.747929396049),
    Boardcore::TrajectoryPoint(540, 335.902876980803),
    Boardcore::TrajectoryPoint(550, 334.075833543992),
    Boardcore::TrajectoryPoint(560, 332.257109969043),
    Boardcore::TrajectoryPoint(570, 330.46203766277),
    Boardcore::TrajectoryPoint(580, 328.676446106067),
    Boardcore::TrajectoryPoint(590, 326.905648847954),
    Boardcore::TrajectoryPoint(600, 325.152699945757),
    Boardcore::TrajectoryPoint(610, 323.408592285795),
    Boardcore::TrajectoryPoint(620, 321.684803946917),
    Boardcore::TrajectoryPoint(630, 319.972698618042),
    Boardcore::TrajectoryPoint(640, 318.271614911226),
    Boardcore::TrajectoryPoint(650, 316.590853593187),
    Boardcore::TrajectoryPoint(660, 314.91912690508),
    Boardcore::TrajectoryPoint(670, 313.26181056575),
    Boardcore::TrajectoryPoint(680, 311.62054449508),
    Boardcore::TrajectoryPoint(690, 309.988473168718),
    Boardcore::TrajectoryPoint(700, 308.37271707331),
    Boardcore::TrajectoryPoint(710, 306.770110601175),
    Boardcore::TrajectoryPoint(720, 305.176754932505),
    Boardcore::TrajectoryPoint(730, 303.600365606379),
    Boardcore::TrajectoryPoint(740, 302.035396199753),
    Boardcore::TrajectoryPoint(750, 300.479642540068),
    Boardcore::TrajectoryPoint(760, 298.940470203543),
    Boardcore::TrajectoryPoint(770, 297.411967600311),
    Boardcore::TrajectoryPoint(780, 295.892568435013),
    Boardcore::TrajectoryPoint(790, 294.388528016907),
    Boardcore::TrajectoryPoint(800, 292.895210571004),
    Boardcore::TrajectoryPoint(810, 291.410820581999),
    Boardcore::TrajectoryPoint(820, 289.939905749922),
    Boardcore::TrajectoryPoint(830, 288.480412756586),
    Boardcore::TrajectoryPoint(840, 287.029620166954),
    Boardcore::TrajectoryPoint(850, 285.589912037241),
    Boardcore::TrajectoryPoint(860, 284.162831576814),
    Boardcore::TrajectoryPoint(870, 282.744184661596),
    Boardcore::TrajectoryPoint(880, 281.334042652709),
    Boardcore::TrajectoryPoint(890, 279.937748823576),
    Boardcore::TrajectoryPoint(900, 278.54977782),
    Boardcore::TrajectoryPoint(910, 277.169991381485),
    Boardcore::TrajectoryPoint(920, 275.800513514632),
    Boardcore::TrajectoryPoint(930, 274.441748353075),
    Boardcore::TrajectoryPoint(940, 273.09082967409),
    Boardcore::TrajectoryPoint(950, 271.747771689742),
    Boardcore::TrajectoryPoint(960, 270.415559017233),
    Boardcore::TrajectoryPoint(970, 269.092040530359),
    Boardcore::TrajectoryPoint(980, 267.7760189686),
    Boardcore::TrajectoryPoint(990, 266.467482678182),
    Boardcore::TrajectoryPoint(1000, 265.16925181739),
    Boardcore::TrajectoryPoint(1010, 263.878825838508),
    Boardcore::TrajectoryPoint(1020, 262.595507905128),
    Boardcore::TrajectoryPoint(1030, 261.319266959662),
    Boardcore::TrajectoryPoint(1040, 260.052018116911),
    Boardcore::TrajectoryPoint(1050, 258.792521429867),
    Boardcore::TrajectoryPoint(1060, 257.539720349371),
    Boardcore::TrajectoryPoint(1070, 256.293569626085),
    Boardcore::TrajectoryPoint(1080, 255.05456558252),
    Boardcore::TrajectoryPoint(1090, 253.823862206175),
    Boardcore::TrajectoryPoint(1100, 252.599430502507),
    Boardcore::TrajectoryPoint(1110, 251.381215151778),
    Boardcore::TrajectoryPoint(1120, 250.169155615001),
    Boardcore::TrajectoryPoint(1130, 248.963966192632),
    Boardcore::TrajectoryPoint(1140, 247.765818304985),
    Boardcore::TrajectoryPoint(1150, 246.573453481937),
    Boardcore::TrajectoryPoint(1160, 245.386805467285),
    Boardcore::TrajectoryPoint(1170, 244.205804338585),
    Boardcore::TrajectoryPoint(1180, 243.030499668849),
    Boardcore::TrajectoryPoint(1190, 241.861983087918),
    Boardcore::TrajectoryPoint(1200, 240.698753054717),
    Boardcore::TrajectoryPoint(1210, 239.540736997442),
    Boardcore::TrajectoryPoint(1220, 238.387859826056),
    Boardcore::TrajectoryPoint(1230, 237.240044218849),
    Boardcore::TrajectoryPoint(1240, 236.097244829438),
    Boardcore::TrajectoryPoint(1250, 234.960327175476),
    Boardcore::TrajectoryPoint(1260, 233.828128653802),
    Boardcore::TrajectoryPoint(1270, 232.700571945097),
    Boardcore::TrajectoryPoint(1280, 231.577578263902),
    Boardcore::TrajectoryPoint(1290, 230.4590675571),
    Boardcore::TrajectoryPoint(1300, 229.344958686859),
    Boardcore::TrajectoryPoint(1310, 228.235169599039),
    Boardcore::TrajectoryPoint(1320, 227.130130411036),
    Boardcore::TrajectoryPoint(1330, 226.029321808616),
    Boardcore::TrajectoryPoint(1340, 224.932517321381),
    Boardcore::TrajectoryPoint(1350, 223.839637072231),
    Boardcore::TrajectoryPoint(1360, 222.750600674041),
    Boardcore::TrajectoryPoint(1370, 221.665327343836),
    Boardcore::TrajectoryPoint(1380, 220.583736007259),
    Boardcore::TrajectoryPoint(1390, 219.505745394022),
    Boardcore::TrajectoryPoint(1400, 218.431274124958),
    Boardcore::TrajectoryPoint(1410, 217.360240791262),
    Boardcore::TrajectoryPoint(1420, 216.2928371119),
    Boardcore::TrajectoryPoint(1430, 215.228693610388),
    Boardcore::TrajectoryPoint(1440, 214.167707767909),
    Boardcore::TrajectoryPoint(1450, 213.109801442285),
    Boardcore::TrajectoryPoint(1460, 212.054896610155),
    Boardcore::TrajectoryPoint(1470, 211.002915418383),
    Boardcore::TrajectoryPoint(1480, 209.953780230314),
    Boardcore::TrajectoryPoint(1490, 208.907413667264),
    Boardcore::TrajectoryPoint(1500, 207.86373864557),
    Boardcore::TrajectoryPoint(1510, 206.822678409529),
    Boardcore::TrajectoryPoint(1520, 205.784156560529),
    Boardcore::TrajectoryPoint(1530, 204.748097082627),
    Boardcore::TrajectoryPoint(1540, 203.714424364858),
    Boardcore::TrajectoryPoint(1550, 202.683063220503),
    Boardcore::TrajectoryPoint(1560, 201.65393890353),
    Boardcore::TrajectoryPoint(1570, 200.626977122436),
    Boardcore::TrajectoryPoint(1580, 199.602104051662),
    Boardcore::TrajectoryPoint(1590, 198.579246340775),
    Boardcore::TrajectoryPoint(1600, 197.558331121577),
    Boardcore::TrajectoryPoint(1610, 196.539286013288),
    Boardcore::TrajectoryPoint(1620, 195.522039125965),
    Boardcore::TrajectoryPoint(1630, 194.506519062268),
    Boardcore::TrajectoryPoint(1640, 193.492654917717),
    Boardcore::TrajectoryPoint(1650, 192.48037627953),
    Boardcore::TrajectoryPoint(1660, 191.46961322418),
    Boardcore::TrajectoryPoint(1670, 190.460296313732),
    Boardcore::TrajectoryPoint(1680, 189.452356591084),
    Boardcore::TrajectoryPoint(1690, 188.445725574174),
    Boardcore::TrajectoryPoint(1700, 187.440335249241),
    Boardcore::TrajectoryPoint(1710, 186.436118063212),
    Boardcore::TrajectoryPoint(1720, 185.433006915275),
    Boardcore::TrajectoryPoint(1730, 184.430935147708),
    Boardcore::TrajectoryPoint(1740, 183.429875571248),
    Boardcore::TrajectoryPoint(1750, 182.429747656757),
    Boardcore::TrajectoryPoint(1760, 181.430455120864),
    Boardcore::TrajectoryPoint(1770, 180.431932410213),
    Boardcore::TrajectoryPoint(1780, 179.434114379513),
    Boardcore::TrajectoryPoint(1790, 178.436936277524),
    Boardcore::TrajectoryPoint(1800, 177.440333732687),
    Boardcore::TrajectoryPoint(1810, 176.444242738415),
    Boardcore::TrajectoryPoint(1820, 175.448599638084),
    Boardcore::TrajectoryPoint(1830, 174.453368980807),
    Boardcore::TrajectoryPoint(1840, 173.458457265384),
    Boardcore::TrajectoryPoint(1850, 172.463792269782),
    Boardcore::TrajectoryPoint(1860, 171.469311190482),
    Boardcore::TrajectoryPoint(1870, 170.474951503182),
    Boardcore::TrajectoryPoint(1880, 169.480650945513),
    Boardcore::TrajectoryPoint(1890, 168.486342014276),
    Boardcore::TrajectoryPoint(1900, 167.491952776563),
    Boardcore::TrajectoryPoint(1910, 166.497422011148),
    Boardcore::TrajectoryPoint(1920, 165.502687998813),
    Boardcore::TrajectoryPoint(1930, 164.507689196322),
    Boardcore::TrajectoryPoint(1940, 163.512327458837),
    Boardcore::TrajectoryPoint(1950, 162.516541265729),
    Boardcore::TrajectoryPoint(1960, 161.520288903962),
    Boardcore::TrajectoryPoint(1970, 160.523509042784),
    Boardcore::TrajectoryPoint(1980, 159.526101651628),
    Boardcore::TrajectoryPoint(1990, 158.527960143234),
    Boardcore::TrajectoryPoint(2000, 157.529088078972),
    Boardcore::TrajectoryPoint(2010, 156.529424034983),
    Boardcore::TrajectoryPoint(2020, 155.528808337488),
    Boardcore::TrajectoryPoint(2030, 154.527193264227),
    Boardcore::TrajectoryPoint(2040, 153.524580610744),
    Boardcore::TrajectoryPoint(2050, 152.520864410774),
    Boardcore::TrajectoryPoint(2060, 151.515841052631),
    Boardcore::TrajectoryPoint(2070, 150.509611576434),
    Boardcore::TrajectoryPoint(2080, 149.502084165381),
    Boardcore::TrajectoryPoint(2090, 148.492971331112),
    Boardcore::TrajectoryPoint(2100, 147.482440246833),
    Boardcore::TrajectoryPoint(2110, 146.470345613585),
    Boardcore::TrajectoryPoint(2120, 145.456444340857),
    Boardcore::TrajectoryPoint(2130, 144.440908352774),
    Boardcore::TrajectoryPoint(2140, 143.423444489511),
    Boardcore::TrajectoryPoint(2150, 142.404035814304),
    Boardcore::TrajectoryPoint(2160, 141.382728875232),
    Boardcore::TrajectoryPoint(2170, 140.359088105467),
    Boardcore::TrajectoryPoint(2180, 139.333430479434),
    Boardcore::TrajectoryPoint(2190, 138.305311654845),
    Boardcore::TrajectoryPoint(2200, 137.274887665066),
    Boardcore::TrajectoryPoint(2210, 136.241920109512),
    Boardcore::TrajectoryPoint(2220, 135.206344382082),
    Boardcore::TrajectoryPoint(2230, 134.168093029505),
    Boardcore::TrajectoryPoint(2240, 133.126967755492),
    Boardcore::TrajectoryPoint(2250, 132.082974300741),
    Boardcore::TrajectoryPoint(2260, 131.035888342153),
    Boardcore::TrajectoryPoint(2270, 129.985670271296),
    Boardcore::TrajectoryPoint(2280, 128.932198177736),
    Boardcore::TrajectoryPoint(2290, 127.8752476123),
    Boardcore::TrajectoryPoint(2300, 126.814948546317),
    Boardcore::TrajectoryPoint(2310, 125.750730901223),
    Boardcore::TrajectoryPoint(2320, 124.682973612899),
    Boardcore::TrajectoryPoint(2330, 123.611099921904),
    Boardcore::TrajectoryPoint(2340, 122.535204926579),
    Boardcore::TrajectoryPoint(2350, 121.455286672307),
    Boardcore::TrajectoryPoint(2360, 120.370641957683),
    Boardcore::TrajectoryPoint(2370, 119.2816517469),
    Boardcore::TrajectoryPoint(2380, 118.188132545839),
    Boardcore::TrajectoryPoint(2390, 117.089387202058),
    Boardcore::TrajectoryPoint(2400, 115.985744166066),
    Boardcore::TrajectoryPoint(2410, 114.877003331204),
    Boardcore::TrajectoryPoint(2420, 113.762765807972),
    Boardcore::TrajectoryPoint(2430, 112.64275791573),
    Boardcore::TrajectoryPoint(2440, 111.517016444177),
    Boardcore::TrajectoryPoint(2450, 110.385307982256),
    Boardcore::TrajectoryPoint(2460, 109.24738927533),
    Boardcore::TrajectoryPoint(2470, 108.102830751826),
    Boardcore::TrajectoryPoint(2480, 106.95143563314),
    Boardcore::TrajectoryPoint(2490, 105.793068528634),
    Boardcore::TrajectoryPoint(2500, 104.627445656374),
    Boardcore::TrajectoryPoint(2510, 103.454271137253),
    Boardcore::TrajectoryPoint(2520, 102.273236421075),
    Boardcore::TrajectoryPoint(2530, 101.084019672345),
    Boardcore::TrajectoryPoint(2540, 99.8862851132519),
    Boardcore::TrajectoryPoint(2550, 98.6796823211136),
    Boardcore::TrajectoryPoint(2560, 97.4638454772623),
    Boardcore::TrajectoryPoint(2570, 96.238392564061),
    Boardcore::TrajectoryPoint(2580, 95.0029245064155),
    Boardcore::TrajectoryPoint(2590, 93.7570242537949),
    Boardcore::TrajectoryPoint(2600, 92.5002557983856),
    Boardcore::TrajectoryPoint(2610, 91.2320882471852),
    Boardcore::TrajectoryPoint(2620, 89.9516693874817),
    Boardcore::TrajectoryPoint(2630, 88.6588525237292),
    Boardcore::TrajectoryPoint(2640, 87.3531074938962),
    Boardcore::TrajectoryPoint(2650, 86.033726917362),
    Boardcore::TrajectoryPoint(2660, 84.6995022593403),
    Boardcore::TrajectoryPoint(2670, 83.3504703008767),
    Boardcore::TrajectoryPoint(2680, 81.9854189592517),
    Boardcore::TrajectoryPoint(2690, 80.603464653749),
    Boardcore::TrajectoryPoint(2700, 79.204011873322),
    Boardcore::TrajectoryPoint(2710, 77.7856108060654),
    Boardcore::TrajectoryPoint(2720, 76.3474921584937),
    Boardcore::TrajectoryPoint(2730, 74.888648258773),
    Boardcore::TrajectoryPoint(2740, 73.4069682185269),
    Boardcore::TrajectoryPoint(2750, 71.9018306847158),
    Boardcore::TrajectoryPoint(2760, 70.371543797437),
    Boardcore::TrajectoryPoint(2770, 68.8142615567152),
    Boardcore::TrajectoryPoint(2780, 67.2279666675078),
    Boardcore::TrajectoryPoint(2790, 65.6104509859392),
    Boardcore::TrajectoryPoint(2800, 63.9592931703206),
    Boardcore::TrajectoryPoint(2810, 62.2718330631576),
    Boardcore::TrajectoryPoint(2820, 60.5451422356782),
    Boardcore::TrajectoryPoint(2830, 58.7759900100188),
    Boardcore::TrajectoryPoint(2840, 56.9593113452435),
    Boardcore::TrajectoryPoint(2850, 55.0916594554774),
    Boardcore::TrajectoryPoint(2860, 53.1661636498186),
    Boardcore::TrajectoryPoint(2870, 51.1773636713848),
    Boardcore::TrajectoryPoint(2880, 49.1171618066514),
    Boardcore::TrajectoryPoint(2890, 46.9760747479071),
    Boardcore::TrajectoryPoint(2900, 44.742928704169),
    Boardcore::TrajectoryPoint(2910, 42.4013405435719),
    Boardcore::TrajectoryPoint(2920, 39.9340885940374),
    Boardcore::TrajectoryPoint(2930, 37.3154666485606),
    Boardcore::TrajectoryPoint(2940, 34.5112935335193),
    Boardcore::TrajectoryPoint(2950, 31.4710048714515),
    Boardcore::TrajectoryPoint(2960, 28.1192963608952),
    Boardcore::TrajectoryPoint(2970, 24.3254033512597),
    Boardcore::TrajectoryPoint(2980, 19.8402285865554),
    Boardcore::TrajectoryPoint(2990, 14.013167708107),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::TrajectoryPoint t10_open[] = {
    Boardcore::TrajectoryPoint(0, 455.925284684661),
    Boardcore::TrajectoryPoint(10, 453.756079330941),
    Boardcore::TrajectoryPoint(20, 451.584396616468),
    Boardcore::TrajectoryPoint(30, 449.403412457969),
    Boardcore::TrajectoryPoint(40, 447.211809549394),
    Boardcore::TrajectoryPoint(50, 445.015581414527),
    Boardcore::TrajectoryPoint(60, 442.803609689168),
    Boardcore::TrajectoryPoint(70, 440.591393500811),
    Boardcore::TrajectoryPoint(80, 438.358590238346),
    Boardcore::TrajectoryPoint(90, 436.125786975882),
    Boardcore::TrajectoryPoint(100, 433.875491685517),
    Boardcore::TrajectoryPoint(110, 431.621379462713),
    Boardcore::TrajectoryPoint(120, 429.352998974085),
    Boardcore::TrajectoryPoint(130, 427.077085026814),
    Boardcore::TrajectoryPoint(140, 424.789738484838),
    Boardcore::TrajectoryPoint(150, 422.491514035252),
    Boardcore::TrajectoryPoint(160, 420.184274817898),
    Boardcore::TrajectoryPoint(170, 417.863214364445),
    Boardcore::TrajectoryPoint(180, 415.535107358373),
    Boardcore::TrajectoryPoint(190, 413.190667926159),
    Boardcore::TrajectoryPoint(200, 410.840666608603),
    Boardcore::TrajectoryPoint(210, 408.472286957417),
    Boardcore::TrajectoryPoint(220, 406.099310268341),
    Boardcore::TrajectoryPoint(230, 403.706410055435),
    Boardcore::TrajectoryPoint(240, 401.309319042472),
    Boardcore::TrajectoryPoint(250, 398.891297936958),
    Boardcore::TrajectoryPoint(260, 396.468892153972),
    Boardcore::TrajectoryPoint(270, 394.02512889944),
    Boardcore::TrajectoryPoint(280, 391.576142537684),
    Boardcore::TrajectoryPoint(290, 389.105993959368),
    Boardcore::TrajectoryPoint(300, 386.629091688174),
    Boardcore::TrajectoryPoint(310, 384.131891640668),
    Boardcore::TrajectoryPoint(320, 381.625664132305),
    Boardcore::TrajectoryPoint(330, 379.100722383519),
    Boardcore::TrajectoryPoint(340, 376.563681494306),
    Boardcore::TrajectoryPoint(350, 374.010282540957),
    Boardcore::TrajectoryPoint(360, 371.440856117901),
    Boardcore::TrajectoryPoint(370, 368.858257927442),
    Boardcore::TrajectoryPoint(380, 366.254784206505),
    Boardcore::TrajectoryPoint(390, 363.642216879926),
    Boardcore::TrajectoryPoint(400, 361.538309418135),
    Boardcore::TrajectoryPoint(410, 359.51328623236),
    Boardcore::TrajectoryPoint(420, 357.513329133999),
    Boardcore::TrajectoryPoint(430, 355.520617540524),
    Boardcore::TrajectoryPoint(440, 353.547339840363),
    Boardcore::TrajectoryPoint(450, 351.587352147065),
    Boardcore::TrajectoryPoint(460, 349.640652676126),
    Boardcore::TrajectoryPoint(470, 347.713638893918),
    Boardcore::TrajectoryPoint(480, 345.793555057437),
    Boardcore::TrajectoryPoint(490, 343.899397006836),
    Boardcore::TrajectoryPoint(500, 342.012665432891),
    Boardcore::TrajectoryPoint(510, 340.144340277405),
    Boardcore::TrajectoryPoint(520, 338.290856143262),
    Boardcore::TrajectoryPoint(530, 336.448000598387),
    Boardcore::TrajectoryPoint(540, 334.627542851565),
    Boardcore::TrajectoryPoint(550, 332.815167086074),
    Boardcore::TrajectoryPoint(560, 331.021995708384),
    Boardcore::TrajectoryPoint(570, 329.242381627966),
    Boardcore::TrajectoryPoint(580, 327.473359920727),
    Boardcore::TrajectoryPoint(590, 325.726041316768),
    Boardcore::TrajectoryPoint(600, 323.987338740838),
    Boardcore::TrajectoryPoint(610, 322.265114827698),
    Boardcore::TrajectoryPoint(620, 320.558100539767),
    Boardcore::TrajectoryPoint(630, 318.86005665399),
    Boardcore::TrajectoryPoint(640, 317.182531250155),
    Boardcore::TrajectoryPoint(650, 315.515400552083),
    Boardcore::TrajectoryPoint(660, 313.859415953449),
    Boardcore::TrajectoryPoint(670, 312.222486471735),
    Boardcore::TrajectoryPoint(680, 310.594562943265),
    Boardcore::TrajectoryPoint(690, 308.98002910794),
    Boardcore::TrajectoryPoint(700, 307.381342377999),
    Boardcore::TrajectoryPoint(710, 305.791733419197),
    Boardcore::TrajectoryPoint(720, 304.21648632164),
    Boardcore::TrajectoryPoint(730, 302.655065060734),
    Boardcore::TrajectoryPoint(740, 301.102702732898),
    Boardcore::TrajectoryPoint(750, 299.564616965076),
    Boardcore::TrajectoryPoint(760, 298.03933438),
    Boardcore::TrajectoryPoint(770, 296.523014437772),
    Boardcore::TrajectoryPoint(780, 295.020024999774),
    Boardcore::TrajectoryPoint(790, 293.529640299652),
    Boardcore::TrajectoryPoint(800, 292.048057647216),
    Boardcore::TrajectoryPoint(810, 290.578174660973),
    Boardcore::TrajectoryPoint(820, 289.121364924724),
    Boardcore::TrajectoryPoint(830, 287.673144670233),
    Boardcore::TrajectoryPoint(840, 286.234462680555),
    Boardcore::TrajectoryPoint(850, 284.809850508368),
    Boardcore::TrajectoryPoint(860, 283.393574403149),
    Boardcore::TrajectoryPoint(870, 281.985710936164),
    Boardcore::TrajectoryPoint(880, 280.590454471423),
    Boardcore::TrajectoryPoint(890, 279.204682893838),
    Boardcore::TrajectoryPoint(900, 277.827015613597),
    Boardcore::TrajectoryPoint(910, 276.458592864879),
    Boardcore::TrajectoryPoint(920, 275.101882716192),
    Boardcore::TrajectoryPoint(930, 273.752949652286),
    Boardcore::TrajectoryPoint(940, 272.411812285433),
    Boardcore::TrajectoryPoint(950, 271.080692816232),
    Boardcore::TrajectoryPoint(960, 269.759049343151),
    Boardcore::TrajectoryPoint(970, 268.444847212549),
    Boardcore::TrajectoryPoint(980, 267.138078665773),
    Boardcore::TrajectoryPoint(990, 265.840989195861),
    Boardcore::TrajectoryPoint(1000, 264.552300774824),
    Boardcore::TrajectoryPoint(1010, 263.270676772494),
    Boardcore::TrajectoryPoint(1020, 261.996089532656),
    Boardcore::TrajectoryPoint(1030, 260.730037228964),
    Boardcore::TrajectoryPoint(1040, 259.472176798488),
    Boardcore::TrajectoryPoint(1050, 258.220978595437),
    Boardcore::TrajectoryPoint(1060, 256.976400313594),
    Boardcore::TrajectoryPoint(1070, 255.738652581327),
    Boardcore::TrajectoryPoint(1080, 254.509514668294),
    Boardcore::TrajectoryPoint(1090, 253.286623775184),
    Boardcore::TrajectoryPoint(1100, 252.069927113472),
    Boardcore::TrajectoryPoint(1110, 250.859366563059),
    Boardcore::TrajectoryPoint(1120, 249.6555174207),
    Boardcore::TrajectoryPoint(1130, 248.458872567378),
    Boardcore::TrajectoryPoint(1140, 247.26799569363),
    Boardcore::TrajectoryPoint(1150, 246.082822612056),
    Boardcore::TrajectoryPoint(1160, 244.903285372289),
    Boardcore::TrajectoryPoint(1170, 243.72940726308),
    Boardcore::TrajectoryPoint(1180, 242.562367098793),
    Boardcore::TrajectoryPoint(1190, 241.400606106653),
    Boardcore::TrajectoryPoint(1200, 240.244053397253),
    Boardcore::TrajectoryPoint(1210, 239.092635481923),
    Boardcore::TrajectoryPoint(1220, 237.946276562556),
    Boardcore::TrajectoryPoint(1230, 236.805012029187),
    Boardcore::TrajectoryPoint(1240, 235.669571469639),
    Boardcore::TrajectoryPoint(1250, 234.538850224578),
    Boardcore::TrajectoryPoint(1260, 233.412772273789),
    Boardcore::TrajectoryPoint(1270, 232.291260067213),
    Boardcore::TrajectoryPoint(1280, 231.174234726322),
    Boardcore::TrajectoryPoint(1290, 230.061616229901),
    Boardcore::TrajectoryPoint(1300, 228.953342588456),
    Boardcore::TrajectoryPoint(1310, 227.84996800678),
    Boardcore::TrajectoryPoint(1320, 226.750683739627),
    Boardcore::TrajectoryPoint(1330, 225.655411499397),
    Boardcore::TrajectoryPoint(1340, 224.564072317215),
    Boardcore::TrajectoryPoint(1350, 223.476586669852),
    Boardcore::TrajectoryPoint(1360, 222.392874596151),
    Boardcore::TrajectoryPoint(1370, 221.312855803683),
    Boardcore::TrajectoryPoint(1380, 220.236449766287),
    Boardcore::TrajectoryPoint(1390, 219.163575813133),
    Boardcore::TrajectoryPoint(1400, 218.094364638547),
    Boardcore::TrajectoryPoint(1410, 217.028615759068),
    Boardcore::TrajectoryPoint(1420, 215.966116664575),
    Boardcore::TrajectoryPoint(1430, 214.906789764082),
    Boardcore::TrajectoryPoint(1440, 213.850557500272),
    Boardcore::TrajectoryPoint(1450, 212.797342408032),
    Boardcore::TrajectoryPoint(1460, 211.747067167393),
    Boardcore::TrajectoryPoint(1470, 210.699654651252),
    Boardcore::TrajectoryPoint(1480, 209.655027968261),
    Boardcore::TrajectoryPoint(1490, 208.613110501219),
    Boardcore::TrajectoryPoint(1500, 207.573825941296),
    Boardcore::TrajectoryPoint(1510, 206.537098318383),
    Boardcore::TrajectoryPoint(1520, 205.502852027855),
    Boardcore::TrajectoryPoint(1530, 204.471011853997),
    Boardcore::TrajectoryPoint(1540, 203.441502990343),
    Boardcore::TrajectoryPoint(1550, 202.414251057156),
    Boardcore::TrajectoryPoint(1560, 201.38918211624),
    Boardcore::TrajectoryPoint(1570, 200.36622268331),
    Boardcore::TrajectoryPoint(1580, 199.345299738067),
    Boardcore::TrajectoryPoint(1590, 198.326340732176),
    Boardcore::TrajectoryPoint(1600, 197.309273595274),
    Boardcore::TrajectoryPoint(1610, 196.294026739184),
    Boardcore::TrajectoryPoint(1620, 195.280529060448),
    Boardcore::TrajectoryPoint(1630, 194.268709941301),
    Boardcore::TrajectoryPoint(1640, 193.258499249229),
    Boardcore::TrajectoryPoint(1650, 192.249827335182),
    Boardcore::TrajectoryPoint(1660, 191.242625030575),
    Boardcore::TrajectoryPoint(1670, 190.236823643142),
    Boardcore::TrajectoryPoint(1680, 189.232354951746),
    Boardcore::TrajectoryPoint(1690, 188.229151200224),
    Boardcore::TrajectoryPoint(1700, 187.227145090323),
    Boardcore::TrajectoryPoint(1710, 186.226269773817),
    Boardcore::TrajectoryPoint(1720, 185.226458843854),
    Boardcore::TrajectoryPoint(1730, 184.227646325594),
    Boardcore::TrajectoryPoint(1740, 183.229766666192),
    Boardcore::TrajectoryPoint(1750, 182.232787232446),
    Boardcore::TrajectoryPoint(1760, 181.236637476528),
    Boardcore::TrajectoryPoint(1770, 180.241218918521),
    Boardcore::TrajectoryPoint(1780, 179.24646705496),
    Boardcore::TrajectoryPoint(1790, 178.252317763938),
    Boardcore::TrajectoryPoint(1800, 177.258707290797),
    Boardcore::TrajectoryPoint(1810, 176.265572233506),
    Boardcore::TrajectoryPoint(1820, 175.272849527733),
    Boardcore::TrajectoryPoint(1830, 174.280482069503),
    Boardcore::TrajectoryPoint(1840, 173.288421148983),
    Boardcore::TrajectoryPoint(1850, 172.296572968603),
    Boardcore::TrajectoryPoint(1860, 171.304875277813),
    Boardcore::TrajectoryPoint(1870, 170.313266093127),
    Boardcore::TrajectoryPoint(1880, 169.321683681018),
    Boardcore::TrajectoryPoint(1890, 168.330064193709),
    Boardcore::TrajectoryPoint(1900, 167.338328279721),
    Boardcore::TrajectoryPoint(1910, 166.346419922266),
    Boardcore::TrajectoryPoint(1920, 165.354277889913),
    Boardcore::TrajectoryPoint(1930, 164.361841115878),
    Boardcore::TrajectoryPoint(1940, 163.36903069772),
    Boardcore::TrajectoryPoint(1950, 162.375745500999),
    Boardcore::TrajectoryPoint(1960, 161.381965511128),
    Boardcore::TrajectoryPoint(1970, 160.387629833486),
    Boardcore::TrajectoryPoint(1980, 159.39266900463),
    Boardcore::TrajectoryPoint(1990, 158.396913480294),
    Boardcore::TrajectoryPoint(2000, 157.400400445722),
    Boardcore::TrajectoryPoint(2010, 156.403068874297),
    Boardcore::TrajectoryPoint(2020, 155.404796348287),
    Boardcore::TrajectoryPoint(2030, 154.405458283226),
    Boardcore::TrajectoryPoint(2040, 153.405097219225),
    Boardcore::TrajectoryPoint(2050, 152.403651313327),
    Boardcore::TrajectoryPoint(2060, 151.400825968402),
    Boardcore::TrajectoryPoint(2070, 150.396770156656),
    Boardcore::TrajectoryPoint(2080, 149.391421706329),
    Boardcore::TrajectoryPoint(2090, 148.384449705786),
    Boardcore::TrajectoryPoint(2100, 147.37601719136),
    Boardcore::TrajectoryPoint(2110, 146.366048757874),
    Boardcore::TrajectoryPoint(2120, 145.354196062337),
    Boardcore::TrajectoryPoint(2130, 144.340686239954),
    Boardcore::TrajectoryPoint(2140, 143.325277831038),
    Boardcore::TrajectoryPoint(2150, 142.307847001651),
    Boardcore::TrajectoryPoint(2160, 141.28853830064),
    Boardcore::TrajectoryPoint(2170, 140.26684136977),
    Boardcore::TrajectoryPoint(2180, 139.24309331544),
    Boardcore::TrajectoryPoint(2190, 138.216916749842),
    Boardcore::TrajectoryPoint(2200, 137.18835657407),
    Boardcore::TrajectoryPoint(2210, 136.157287831462),
    Boardcore::TrajectoryPoint(2220, 135.123531108801),
    Boardcore::TrajectoryPoint(2230, 134.087135262256),
    Boardcore::TrajectoryPoint(2240, 133.047785102265),
    Boardcore::TrajectoryPoint(2250, 132.005604044118),
    Boardcore::TrajectoryPoint(2260, 130.960250196032),
    Boardcore::TrajectoryPoint(2270, 129.911801656033),
    Boardcore::TrajectoryPoint(2280, 128.860019524771),
    Boardcore::TrajectoryPoint(2290, 127.804795904233),
    Boardcore::TrajectoryPoint(2300, 126.746145475618),
    Boardcore::TrajectoryPoint(2310, 125.683612497035),
    Boardcore::TrajectoryPoint(2320, 124.617520348647),
    Boardcore::TrajectoryPoint(2330, 123.547232338342),
    Boardcore::TrajectoryPoint(2340, 122.472960509036),
    Boardcore::TrajectoryPoint(2350, 121.394588530472),
    Boardcore::TrajectoryPoint(2360, 120.311525375063),
    Boardcore::TrajectoryPoint(2370, 119.224097032534),
    Boardcore::TrajectoryPoint(2380, 118.132063878606),
    Boardcore::TrajectoryPoint(2390, 117.034839208998),
    Boardcore::TrajectoryPoint(2400, 115.932697092471),
    Boardcore::TrajectoryPoint(2410, 114.825437335918),
    Boardcore::TrajectoryPoint(2420, 113.712606262047),
    Boardcore::TrajectoryPoint(2430, 112.594038795687),
    Boardcore::TrajectoryPoint(2440, 111.469717930564),
    Boardcore::TrajectoryPoint(2450, 110.339410207384),
    Boardcore::TrajectoryPoint(2460, 109.202872333869),
    Boardcore::TrajectoryPoint(2470, 108.059623072553),
    Boardcore::TrajectoryPoint(2480, 106.909568874665),
    Boardcore::TrajectoryPoint(2490, 105.752522884459),
    Boardcore::TrajectoryPoint(2500, 104.588201307872),
    Boardcore::TrajectoryPoint(2510, 103.416308261054),
    Boardcore::TrajectoryPoint(2520, 102.236535195866),
    Boardcore::TrajectoryPoint(2530, 101.048560285149),
    Boardcore::TrajectoryPoint(2540, 99.8520477652275),
    Boardcore::TrajectoryPoint(2550, 98.6466472329299),
    Boardcore::TrajectoryPoint(2560, 97.4319928940923),
    Boardcore::TrajectoryPoint(2570, 96.2077027602285),
    Boardcore::TrajectoryPoint(2580, 94.9733777897316),
    Boardcore::TrajectoryPoint(2590, 93.7286009696134),
    Boardcore::TrajectoryPoint(2600, 92.4729363334064),
    Boardcore::TrajectoryPoint(2610, 91.2058934077025),
    Boardcore::TrajectoryPoint(2620, 89.9265377241368),
    Boardcore::TrajectoryPoint(2630, 88.6347644935103),
    Boardcore::TrajectoryPoint(2640, 87.3300436120329),
    Boardcore::TrajectoryPoint(2650, 86.0117044870175),
    Boardcore::TrajectoryPoint(2660, 84.6784632859802),
    Boardcore::TrajectoryPoint(2670, 83.3303954322048),
    Boardcore::TrajectoryPoint(2680, 81.9663224714599),
    Boardcore::TrajectoryPoint(2690, 80.5852916423076),
    Boardcore::TrajectoryPoint(2700, 79.186774925544),
    Boardcore::TrajectoryPoint(2710, 77.7692567623198),
    Boardcore::TrajectoryPoint(2720, 76.3320314652333),
    Boardcore::TrajectoryPoint(2730, 74.8740300100356),
    Boardcore::TrajectoryPoint(2740, 73.3932003159864),
    Boardcore::TrajectoryPoint(2750, 71.8888913166507),
    Boardcore::TrajectoryPoint(2760, 70.3594109678489),
    Boardcore::TrajectoryPoint(2770, 68.8029131075916),
    Boardcore::TrajectoryPoint(2780, 67.2173802996045),
    Boardcore::TrajectoryPoint(2790, 65.6006042781576),
    Boardcore::TrajectoryPoint(2800, 63.9501635977427),
    Boardcore::TrajectoryPoint(2810, 62.2633980137858),
    Boardcore::TrajectoryPoint(2820, 60.5373790259145),
    Boardcore::TrajectoryPoint(2830, 58.7688758989049),
    Boardcore::TrajectoryPoint(2840, 56.9528408829811),
    Boardcore::TrajectoryPoint(2850, 55.0857906943522),
    Boardcore::TrajectoryPoint(2860, 53.1608885686685),
    Boardcore::TrajectoryPoint(2870, 51.1726564697814),
    Boardcore::TrajectoryPoint(2880, 49.1129962863124),
    Boardcore::TrajectoryPoint(2890, 46.9724243532722),
    Boardcore::TrajectoryPoint(2900, 44.7397665575609),
    Boardcore::TrajectoryPoint(2910, 42.3986491773757),
    Boardcore::TrajectoryPoint(2920, 39.9318378436545),
    Boardcore::TrajectoryPoint(2930, 37.3136255127328),
    Boardcore::TrajectoryPoint(2940, 34.5098369629541),
    Boardcore::TrajectoryPoint(2950, 31.4698974599527),
    Boardcore::TrajectoryPoint(2960, 28.1185011838155),
    Boardcore::TrajectoryPoint(2970, 24.324887952423),
    Boardcore::TrajectoryPoint(2980, 19.8399479164747),
    Boardcore::TrajectoryPoint(2990, 14.013068940521),
    Boardcore::TrajectoryPoint(3000, 0),
};
Boardcore::Trajectory t_closed[] = {
    Boardcore::Trajectory{0.0, t0_closed, 301},
    Boardcore::Trajectory{0.0, t1_closed, 301},
    Boardcore::Trajectory{0.0, t2_closed, 301},
    Boardcore::Trajectory{0.0, t3_closed, 301},
    Boardcore::Trajectory{0.0, t4_closed, 301},
    Boardcore::Trajectory{0.0, t5_closed, 301},
    Boardcore::Trajectory{0.0, t6_closed, 301},
    Boardcore::Trajectory{0.0, t7_closed, 301},
    Boardcore::Trajectory{0.0, t8_closed, 301},
    Boardcore::Trajectory{0.0, t9_closed, 301},
    Boardcore::Trajectory{0.0, t10_closed, 301},
};
Boardcore::Trajectory t_open[] = {
    Boardcore::Trajectory{0.0, t0_open, 301},
    Boardcore::Trajectory{0.0, t1_open, 301},
    Boardcore::Trajectory{0.0, t2_open, 301},
    Boardcore::Trajectory{0.0, t3_open, 301},
    Boardcore::Trajectory{0.0, t4_open, 301},
    Boardcore::Trajectory{0.0, t5_open, 301},
    Boardcore::Trajectory{0.0, t6_open, 301},
    Boardcore::Trajectory{0.0, t7_open, 301},
    Boardcore::Trajectory{0.0, t8_open, 301},
    Boardcore::Trajectory{0.0, t9_open, 301},
    Boardcore::Trajectory{0.0, t10_open, 301},
};
const Boardcore::TrajectorySet CLOSED_TRAJECTORY_SET(t_closed, 11);
const Boardcore::TrajectorySet OPEN_TRAJECTORY_SET(t_open, 11);

}  // namespace Boardcore