/* Copyright (c) 2019 Skyward Experimental Rocketry
 * Author: Luca Mozzarelli
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#pragma once

#include <vector>

namespace Boardcore
{

// ------------------------ TIME ------------------------
static const std::vector<float> TIME = {
    0,     0.05,  0.1,   0.15,  0.2,   0.25,  0.3,   0.35,  0.4,   0.45,  0.5,
    0.55,  0.6,   0.65,  0.7,   0.75,  0.8,   0.85,  0.9,   0.95,  1,     1.05,
    1.1,   1.15,  1.2,   1.25,  1.3,   1.35,  1.4,   1.45,  1.5,   1.55,  1.6,
    1.65,  1.7,   1.75,  1.8,   1.85,  1.9,   1.95,  2,     2.05,  2.1,   2.15,
    2.2,   2.25,  2.3,   2.35,  2.4,   2.45,  2.5,   2.55,  2.6,   2.65,  2.7,
    2.75,  2.8,   2.85,  2.9,   2.95,  3,     3.05,  3.1,   3.15,  3.2,   3.25,
    3.3,   3.35,  3.4,   3.45,  3.5,   3.55,  3.6,   3.65,  3.7,   3.75,  3.8,
    3.85,  3.9,   3.95,  4,     4.05,  4.1,   4.15,  4.2,   4.25,  4.3,   4.35,
    4.4,   4.45,  4.5,   4.55,  4.6,   4.65,  4.7,   4.75,  4.8,   4.85,  4.9,
    4.95,  5,     5.05,  5.1,   5.15,  5.2,   5.25,  5.3,   5.35,  5.4,   5.45,
    5.5,   5.55,  5.6,   5.65,  5.7,   5.75,  5.8,   5.85,  5.9,   5.95,  6,
    6.05,  6.1,   6.15,  6.2,   6.25,  6.3,   6.35,  6.4,   6.45,  6.5,   6.55,
    6.6,   6.65,  6.7,   6.75,  6.8,   6.85,  6.9,   6.95,  7,     7.05,  7.1,
    7.15,  7.2,   7.25,  7.3,   7.35,  7.4,   7.45,  7.5,   7.55,  7.6,   7.65,
    7.7,   7.75,  7.8,   7.85,  7.9,   7.95,  8,     8.05,  8.1,   8.15,  8.2,
    8.25,  8.3,   8.35,  8.4,   8.45,  8.5,   8.55,  8.6,   8.65,  8.7,   8.75,
    8.8,   8.85,  8.9,   8.95,  9,     9.05,  9.1,   9.15,  9.2,   9.25,  9.3,
    9.35,  9.4,   9.45,  9.5,   9.55,  9.6,   9.65,  9.7,   9.75,  9.8,   9.85,
    9.9,   9.95,  10,    10.05, 10.1,  10.15, 10.2,  10.25, 10.3,  10.35, 10.4,
    10.45, 10.5,  10.55, 10.6,  10.65, 10.7,  10.75, 10.8,  10.85, 10.9,  10.95,
    11,    11.05, 11.1,  11.15, 11.2,  11.25, 11.3,  11.35, 11.4,  11.45, 11.5,
    11.55, 11.6,  11.65, 11.7,  11.75, 11.8,  11.85, 11.9,  11.95, 12,    12.05,
    12.1,  12.15, 12.2,  12.25, 12.3,  12.35, 12.4,  12.45, 12.5,  12.55, 12.6,
    12.65, 12.7,  12.75, 12.8,  12.85, 12.9,  12.95, 13,    13.05, 13.1,  13.15,
    13.2,  13.25, 13.3,  13.35, 13.4,  13.45, 13.5,  13.55, 13.6,  13.65, 13.7,
    13.75, 13.8,  13.85, 13.9,  13.95, 14,    14.05, 14.1,  14.15, 14.2,  14.25,
    14.3,  14.35, 14.4,  14.45, 14.5,  14.55, 14.6,  14.65, 14.7,  14.75, 14.8,
    14.85, 14.9,  14.95, 15,    15.05, 15.1,  15.15, 15.2,  15.25, 15.3,  15.35,
    15.4,  15.45, 15.5,  15.55, 15.6,  15.65, 15.7,  15.75, 15.8,  15.85, 15.9,
    15.95, 16,    16.05, 16.1,  16.15, 16.2,  16.25, 16.3,  16.35, 16.4,  16.45,
    16.5,  16.55, 16.6,  16.65, 16.7,  16.75, 16.8,  16.85, 16.9,  16.95, 17,
    17.05, 17.1,  17.15, 17.2,  17.25, 17.3,  17.35, 17.4,  17.45, 17.5,  17.55,
    17.6,  17.65, 17.7,  17.75, 17.8,  17.85, 17.9,  17.95, 18,    18.05, 18.1,
    18.15, 18.2,  18.25, 18.3,  18.35, 18.4,  18.45, 18.5,  18.55, 18.6,  18.65,
    18.7,  18.75, 18.8,  18.85, 18.9,  18.95, 19,    19.05, 19.1,  19.15, 19.2,
    19.25, 19.3,  19.35, 19.4,  19.45, 19.5,  19.55, 19.6,  19.65, 19.7,  19.75,
    19.8,  19.85, 19.9,  19.95, 20,    20.05, 20.1,  20.15, 20.2,  20.25, 20.3,
    20.35, 20.4,  20.45, 20.5,  20.55, 20.6,  20.65, 20.7,  20.75, 20.8,  20.85,
    20.9,  20.95, 21,    21.05, 21.1,  21.15, 21.2,  21.25, 21.3,  21.35, 21.4,
    21.45, 21.5,  21.55, 21.6,  21.65, 21.7,  21.75, 21.8,  21.85, 21.9,  21.95,
    22,    22.05, 22.1,  22.15, 22.2,  22.25, 22.3,  22.35, 22.4,  22.45, 22.5,
    22.55, 22.6,  22.65, 22.7,  22.75, 22.8,  22.85, 22.9,  22.95, 23,    23.05,
    23.1,  23.15, 23.2,  23.25, 23.3,  23.35, 23.4,  23.45, 23.5,  23.55, 23.6,
    23.65, 23.7,  23.75, 23.8,  23.85, 23.9,  23.95, 24,    24.05, 24.1,  24.15,
    24.2,  24.25, 24.3,  24.35, 24.4,  24.45, 24.5,  24.55, 24.6,  24.65, 24.7,
    24.75, 24.8,  24.85, 24.9,  24.95, 25,    25.05, 25.1,  25.15, 25.2,  25.25,
    25.3,  25.35, 25.4,  25.45, 25.5,  25.55, 25.6,  25.65, 25.7,  25.75, 25.8,
    25.85, 25.9,  25.95, 26,    26.05, 26.1,  26.15, 26.2,  26.25, 26.3,  26.35,
    26.4,  26.45, 26.5,  26.55, 26.6,  26.65, 26.7,  26.75, 26.8,  26.85, 26.9,
    26.95, 27,    27.05, 27.1,  27.15, 27.2,  27.25, 27.3,  27.35, 27.4,  27.45,
    27.5,  27.55, 27.6,  27.65, 27.7,  27.75, 27.8,  27.85, 27.9,  27.95, 28,
    28.05, 28.1,  28.15, 28.2,  28.25, 28.3,  28.35, 28.4,  28.45, 28.5,  28.55,
    28.6,  28.65, 28.7,  28.75, 28.8,  28.85, 28.9,  28.95, 29,    29.05, 29.1,
    29.15, 29.2,  29.25, 29.3,  29.35, 29.4,  29.45, 29.5,  29.55, 29.6,  29.65,
    29.7,  29.75, 29.8,  29.85, 29.9,  29.95, 30,    30.05, 30.1,  30.15, 30.2,
    30.25, 30.3,  30.35, 30.4,  30.45, 30.5,  30.55, 30.6,  30.65, 30.7,  30.75,
    30.8,  30.85, 30.9,  30.95, 31,    31.05, 31.1,  31.15, 31.2,  31.25, 31.3,
    31.35, 31.4,  31.45, 31.5,  31.55, 31.6,  31.65, 31.7,  31.75, 31.8,  31.85,
    31.9,  31.95, 32,    32.05, 32.1,  32.15, 32.2,  32.25, 32.3,  32.35, 32.4,
    32.45, 32.5,  32.55, 32.6,  32.65, 32.7,  32.75, 32.8,  32.85, 32.9,  32.95,
    33,    33.05, 33.1,  33.15, 33.2,  33.25, 33.3,  33.35, 33.4,  33.45, 33.5,
    33.55, 33.6,  33.65, 33.7,  33.75, 33.8,  33.85, 33.9,  33.95, 34,    34.05,
    34.1,  34.15, 34.2,  34.25, 34.3,  34.35, 34.4,  34.45, 34.5,  34.55, 34.6,
    34.65, 34.7,  34.75, 34.8,  34.85, 34.9,  34.95, 35,    35.05, 35.1,  35.15,
    35.2,  35.25, 35.3,  35.35, 35.4,  35.45, 35.5,  35.55, 35.6,  35.65, 35.7,
    35.75, 35.8,  35.85, 35.9,  35.95, 36,    36.05, 36.1,  36.15, 36.2,  36.25,
    36.3,  36.35, 36.4,  36.45, 36.5,  36.55, 36.6,  36.65, 36.7,  36.75, 36.8,
    36.85, 36.9,  36.95, 37,    37.05, 37.1,  37.15, 37.2,  37.25, 37.3,  37.35,
    37.4,  37.45, 37.5,  37.55, 37.6,  37.65, 37.7,  37.75, 37.8,  37.85, 37.9,
    37.95, 38,    38.05, 38.1,  38.15, 38.2,  38.25, 38.3,  38.35, 38.4,  38.45,
    38.5,  38.55, 38.6,  38.65, 38.7,  38.75, 38.8,  38.85, 38.9,  38.95, 39,
    39.05, 39.1,  39.15, 39.2,  39.25, 39.3,  39.35, 39.4,  39.45, 39.5,  39.55,
    39.6,  39.65, 39.7,  39.75, 39.8,  39.85, 39.9,  39.95, 40,    40.05, 40.1,
    40.15, 40.2,  40.25, 40.3,  40.35, 40.4,  40.45, 40.5,  40.55, 40.6,  40.65,
    40.7,  40.75, 40.8,  40.85, 40.9,  40.95, 41,    41.05, 41.1,  41.15, 41.2,
    41.25, 41.3,  41.35, 41.4,  41.45, 41.5,  41.55, 41.6,  41.65, 41.7,  41.75,
    41.8,  41.85, 41.9,  41.95, 42,    42.05, 42.1,  42.15, 42.2,  42.25, 42.3,
    42.35, 42.4,  42.45, 42.5,  42.55, 42.6,  42.65, 42.7,  42.75, 42.8,  42.85,
    42.9,  42.95, 43,    43.05, 43.1,  43.15, 43.2,  43.25, 43.3,  43.35, 43.4,
    43.45, 43.5,  43.55, 43.6,  43.65, 43.7,  43.75, 43.8,  43.85, 43.9,  43.95,
    44,    44.05, 44.1,  44.15, 44.2,  44.25, 44.3,  44.35, 44.4,  44.45, 44.5,
    44.55, 44.6,  44.65, 44.7,  44.75, 44.8,  44.85, 44.9,  44.95, 45,    45.05,
    45.1,  45.15, 45.2,  45.25, 45.3,  45.35, 45.4,  45.45, 45.5,  45.55, 45.6,
    45.65, 45.7,  45.75, 45.8,  45.85, 45.9,  45.95, 46,    46.05, 46.1,  46.15,
    46.2,  46.25, 46.3,  46.35, 46.4,  46.45, 46.5,  46.55, 46.6,  46.65, 46.7,
    46.75, 46.8,  46.85, 46.9,  46.95, 47,    47.05, 47.1,  47.15, 47.2,  47.25,
    47.3,  47.35, 47.4,  47.45, 47.5,  47.55, 47.6,  47.65, 47.7,  47.75, 47.8,
    47.85, 47.9,  47.95, 48,    48.05, 48.1,  48.15, 48.2,  48.25, 48.3,  48.35,
    48.4,  48.45, 48.5,  48.55, 48.6,  48.65, 48.7,  48.75, 48.8,  48.85, 48.9,
    48.95, 49,    49.05, 49.1,  49.15, 49.2,  49.25, 49.3,  49.35, 49.4,  49.45,
    49.5,  49.55, 49.6,  49.65, 49.7,  49.75, 49.8,  49.85, 49.9,  49.95, 50,
    50.05, 50.1,  50.15, 50.2,  50.25, 50.3,  50.35, 50.4,  50.45, 50.5,  50.55,
    50.6,  50.65, 50.7,  50.75, 50.8,  50.85, 50.9,  50.95, 51,    51.05, 51.1,
    51.15, 51.2,  51.25, 51.3,  51.35, 51.4,  51.45, 51.5,  51.55, 51.6,  51.65,
    51.7,  51.75, 51.8,  51.85, 51.9,  51.95, 52,    52.05, 52.1,  52.15, 52.2,
    52.25, 52.3,  52.35, 52.4,  52.45, 52.5,  52.55, 52.6,  52.65, 52.7,  52.75,
    52.8,  52.85, 52.9,  52.95, 53,    53.05, 53.1,  53.15, 53.2,  53.25, 53.3,
    53.35, 53.4,  53.45, 53.5,  53.55, 53.6,  53.65, 53.7,  53.75, 53.8,  53.85,
    53.9,  53.95, 54,    54.05, 54.1,  54.15, 54.2,  54.25, 54.3,  54.35, 54.4,
    54.45, 54.5,  54.55, 54.6,  54.65, 54.7,  54.75, 54.8,  54.85, 54.9,  54.95,
    55,    55.05, 55.1,  55.15, 55.2,  55.25, 55.3,  55.35, 55.4,  55.45, 55.5,
    55.55, 55.6,  55.65, 55.7,  55.75, 55.8,  55.85, 55.9,  55.95, 56,    56.05,
    56.1,  56.15, 56.2,  56.25, 56.3,  56.35, 56.4,  56.45, 56.5,  56.55, 56.6,
    56.65, 56.7,  56.75, 56.8,  56.85, 56.9,  56.95, 57,    57.05, 57.1,  57.15,
    57.2,  57.25, 57.3,  57.35, 57.4,  57.45, 57.5,  57.55, 57.6,  57.65, 57.7,
    57.75, 57.8,  57.85, 57.9,  57.95, 58,    58.05, 58.1,  58.15, 58.2,  58.25,
    58.3,  58.35, 58.4,  58.45, 58.5,  58.55, 58.6,  58.65, 58.7,  58.75, 58.8,
    58.85, 58.9,  58.95, 59,    59.05, 59.1,  59.15, 59.2,  59.25, 59.3,  59.35,
    59.4,  59.45, 59.5,  59.55, 59.6,  59.65, 59.7,  59.75, 59.8,  59.85, 59.9,
    59.95, 60,    60.05, 60.1,  60.15, 60.2,  60.25, 60.3,  60.35, 60.4,  60.45,
    60.5,  60.55, 60.6,  60.65, 60.7,  60.75, 60.8,  60.85, 60.9,  60.95, 61,
    61.05, 61.1,  61.15, 61.2,  61.25, 61.3,  61.35, 61.4,  61.45, 61.5,  61.55,
    61.6,  61.65, 61.7,  61.75, 61.8,  61.85, 61.9,  61.95, 62,    62.05, 62.1,
    62.15, 62.2,  62.25, 62.3,  62.35, 62.4,  62.45, 62.5,  62.55, 62.6,  62.65,
    62.7,  62.75, 62.8,  62.85, 62.9,  62.95, 63,    63.05, 63.1,  63.15, 63.2,
    63.25, 63.3,  63.35, 63.4,  63.45, 63.5,  63.55, 63.6,  63.65, 63.7,  63.75,
    63.8,  63.85, 63.9,  63.95, 64,    64.05, 64.1,  64.15, 64.2,  64.25, 64.3,
    64.35, 64.4,  64.45, 64.5,  64.55, 64.6,  64.65, 64.7,  64.75, 64.8,  64.85,
    64.9,  64.95, 65,    65.05, 65.1,  65.15, 65.2,  65.25, 65.3,  65.35, 65.4,
    65.45, 65.5,  65.55, 65.6,  65.65, 65.7,  65.75, 65.8,  65.85, 65.9,  65.95,
    66,    66.05, 66.1,  66.15, 66.2,  66.25, 66.3,  66.35, 66.4,  66.45, 66.5,
    66.55, 66.6,  66.65, 66.7,  66.75, 66.8,  66.85, 66.9,  66.95, 67,    67.05,
    67.1,  67.15, 67.2,  67.25, 67.3,  67.35, 67.4,  67.45, 67.5,  67.55, 67.6,
    67.65, 67.7,  67.75, 67.8,  67.85, 67.9,  67.95, 68,    68.05, 68.1,  68.15,
    68.2,  68.25, 68.3,  68.35, 68.4,  68.45, 68.5,  68.55, 68.6,  68.65, 68.7,
    68.75, 68.8,  68.85, 68.9,  68.95, 69,    69.05, 69.1,  69.15, 69.2,  69.25,
    69.3,  69.35, 69.4,  69.45, 69.5,  69.55, 69.6,  69.65, 69.7,  69.75, 69.8,
    69.85, 69.9,  69.95, 70,    70.05, 70.1,  70.15, 70.2,  70.25, 70.3,  70.35,
    70.4,  70.45, 70.5,  70.55, 70.6,  70.65, 70.7,  70.75, 70.8,  70.85, 70.9,
    70.95, 71,    71.05, 71.1,  71.15, 71.2,  71.25, 71.3,  71.35, 71.4,  71.45,
    71.5,  71.55, 71.6,  71.65, 71.7,  71.75, 71.8,  71.85, 71.9,  71.95, 72,
    72.05, 72.1,  72.15, 72.2,  72.25, 72.3,  72.35, 72.4,  72.45, 72.5,  72.55,
    72.6,  72.65, 72.7,  72.75, 72.8,  72.85, 72.9,  72.95, 73,    73.05, 73.1,
    73.15, 73.2,  73.25, 73.3,  73.35, 73.4,  73.45, 73.5,  73.55, 73.6,  73.65,
    73.7,  73.75, 73.8,  73.85, 73.9,  73.95, 74,    74.05, 74.1,  74.15, 74.2,
    74.25, 74.3,  74.35, 74.4,  74.45, 74.5,  74.55, 74.6,  74.65, 74.7,  74.75,
    74.8,  74.85, 74.9,  74.95, 75,    75.05, 75.1,  75.15, 75.2,  75.25, 75.3,
    75.35, 75.4,  75.45, 75.5,  75.55, 75.6,  75.65, 75.7,  75.75, 75.8,  75.85,
    75.9,  75.95, 76,    76.05, 76.1,  76.15, 76.2,  76.25, 76.3,  76.35, 76.4,
    76.45, 76.5,  76.55, 76.6,  76.65, 76.7,  76.75, 76.8,  76.85, 76.9,  76.95,
    77,    77.05, 77.1,  77.15, 77.2,  77.25, 77.3,  77.35, 77.4,  77.45, 77.5,
    77.55, 77.6,  77.65, 77.7,  77.75, 77.8,  77.85, 77.9,  77.95, 78,    78.05,
    78.1,  78.15, 78.2,  78.25, 78.3,  78.35, 78.4,  78.45, 78.5,  78.55, 78.6,
    78.65, 78.7,  78.75, 78.8,  78.85, 78.9,  78.95, 79,    79.05, 79.1,  79.15,
    79.2,  79.25, 79.3,  79.35, 79.4,  79.45, 79.5,  79.55, 79.6,  79.65, 79.7,
    79.75, 79.8,  79.85, 79.9,  79.95, 80,    80.05, 80.1,  80.15, 80.2,  80.25,
    80.3,  80.35, 80.4,  80.45, 80.5,  80.55, 80.6,  80.65, 80.7,  80.75, 80.8,
    80.85, 80.9,  80.95, 81,    81.05, 81.1,  81.15, 81.2,  81.25, 81.3,  81.35,
    81.4,  81.45, 81.5,  81.55, 81.6,  81.65, 81.7,  81.75, 81.8,  81.85, 81.9,
    81.95, 82,    82.05, 82.1,  82.15, 82.2,  82.25, 82.3,  82.35, 82.4,  82.45,
    82.5,  82.55, 82.6,  82.65, 82.7,  82.75, 82.8,  82.85, 82.9,  82.95, 83,
    83.05, 83.1,  83.15, 83.2,  83.25, 83.3,  83.35, 83.4,  83.45, 83.5,  83.55,
    83.6,  83.65, 83.7,  83.75, 83.8,  83.85, 83.9,  83.95, 84,    84.05, 84.1,
    84.15, 84.2,  84.25, 84.3,  84.35, 84.4,  84.45, 84.5,  84.55, 84.6,  84.65,
    84.7,  84.75, 84.8,  84.85, 84.9,  84.95, 85,    85.05, 85.1,  85.15, 85.2,
    85.25, 85.3,  85.35, 85.4,  85.45, 85.5,  85.55, 85.6,  85.65, 85.7,  85.75,
    85.8,  85.85, 85.9,  85.95, 86,    86.05, 86.1,  86.15, 86.2,  86.25, 86.3,
    86.35, 86.4,  86.45, 86.5,  86.55, 86.6,  86.65, 86.7,  86.75, 86.8,  86.85,
    86.9,  86.95, 87,    87.05, 87.1,  87.15, 87.2,  87.25, 87.3,  87.35, 87.4,
    87.45, 87.5,  87.55, 87.6,  87.65, 87.7,  87.75, 87.8,  87.85, 87.9,  87.95,
    88,    88.05, 88.1,  88.15, 88.2,  88.25, 88.3,  88.35, 88.4,  88.45, 88.5,
    88.55, 88.6,  88.65, 88.7,  88.75, 88.8,  88.85, 88.9,  88.95, 89,    89.05,
    89.1,  89.15, 89.2,  89.25, 89.3,  89.35, 89.4,  89.45, 89.5,  89.55, 89.6,
    89.65, 89.7,  89.75, 89.8,  89.85, 89.9,  89.95, 90,    90.05, 90.1,  90.15,
    90.2,  90.25, 90.3,  90.35, 90.4,  90.45, 90.5,  90.55, 90.6,  90.65, 90.7,
    90.75, 90.8,  90.85, 90.9,  90.95, 91,    91.05, 91.1,  91.15, 91.2,  91.25,
    91.3,  91.35, 91.4,  91.45, 91.5,  91.55, 91.6,  91.65, 91.7,  91.75, 91.8,
    91.85, 91.9,  91.95, 92,    92.05, 92.1,  92.15, 92.2,  92.25, 92.3,  92.35,
    92.4,  92.45, 92.5,  92.55, 92.6,  92.65, 92.7,  92.75, 92.8,  92.85, 92.9,
    92.95, 93,    93.05, 93.1,  93.15, 93.2,  93.25, 93.3,  93.35, 93.4,  93.45,
    93.5,  93.55, 93.6,  93.65, 93.7,  93.75, 93.8,  93.85, 93.9,  93.95, 94,
    94.05, 94.1,  94.15, 94.2,  94.25, 94.3,  94.35, 94.4,  94.45, 94.5,  94.55,
    94.6,  94.65, 94.7,  94.75, 94.8,  94.85, 94.9,  94.95, 95,    95.05, 95.1,
    95.15, 95.2,  95.25, 95.3,  95.35, 95.4,  95.45, 95.5,  95.55, 95.6,  95.65,
    95.7,  95.75, 95.8,  95.85, 95.9,  95.95, 96,    96.05, 96.1,  96.15, 96.2,
    96.25, 96.3};

// ------------------------ INPUT ------------------------
static const std::vector<float> INPUT = {
    -5.15584, -2.56082, 2.63118, -5.15584, 2.63118, 5.22815, 2.63118, 5.22815,
    10.424,   7.82576,  5.22815, 5.22815,  10.424,  13.0229, 15.6225, 13.0229,
    18.2227,  20.8236,  23.4251, 28.6301,  31.2335, 31.2335, 31.2335, 36.4424,
    36.4424,  44.2606,  57.3041, 59.9147,  62.526,  62.526,  67.7506, 72.9778,
    78.2077,  78.2077,  86.0574, 101.775,  93.913,  104.396, 112.266, 120.141,
    133.281,  130.651,  146.436, 162.245,  162.245, 164.882, 170.159, 178.078,
    188.647,  196.581,  204.521, 207.168,  228.376, 241.653, 244.311, 249.628,
    260.27,   270.923,  284.255, 292.262,  313.645, 316.321, 327.032, 343.12,
    345.803,  359.232,  369.987, 388.837,  394.229, 410.421, 418.527, 442.882,
    445.592,  464.58,   480.883, 491.767,  494.489, 508.113, 527.217, 543.62,
    557.309,  571.017,  601.237, 601.237,  617.759, 637.068, 645.354, 661.947,
    684.113,  692.437,  714.669, 725.803,  750.899, 762.072, 778.855, 795.666,
    815.313,  834.999,  849.083, 866.01,   888.622, 899.948, 922.636, 948.22,
    948.22,   976.723,  993.863, 1016.76,  1036.84, 1056.96, 1085.77, 1094.43,
    1105.98,  1137.83,  1155.25, 1181.42,  1190.17, 1213.51, 1233.98, 1254.5,
    1283.87,  1307.44,  1328.1,  1354.73,  1372.52, 1384.4,  1411.18, 1438.03,
    1461.96,  1476.94,  1506.97, 1534.08,  1552.19, 1576.39, 1600.65, 1615.84,
    1646.29,  1667.67,  1692.15, 1716.69,  1741.29, 1778.3,  1796.86, 1815.46,
    1840.3,   1871.45,  1899.56, 1924.62,  1949.74, 1974.92, 1997.01, 2019.14,
    2054.03,  2076.29,  2104.99, 2133.78,  2159.43, 2172.28, 2201.26, 2233.56,
    2252.99,  2282.21,  2304.99, 2321.3,   2357.27, 2383.51, 2403.24, 2426.3,
    2462.66,  2475.91,  2502.47, 2532.44,  2552.47, 2585.94, 2602.72, 2633,
    2646.48,  2680.28,  2683.67, 2734.6,   2744.82, 2761.87, 2799.5,  2813.21,
    2840.71,  2861.38,  2892.47, 2913.25,  2947.99, 2961.91, 2986.34, 3003.82,
    3035.37,  3052.94,  3081.12, 3102.31,  3120.01, 3148.38, 3169.72, 3194.68,
    3219.69,  3248.37,  3255.55, 3273.52,  3309.58, 3331.28, 3345.77, 3363.91,
    3393.02,  3414.91,  3436.84, 3462.5,   3491.9,  3510.33, 3525.09, 3554.69,
    3569.53,  3599.26,  3614.17, 3640.3,   3651.52, 3696.55, 3707.84, 3734.23,
    3745.57,  3764.49,  3791.04, 3817.67,  3832.91, 3848.19, 3874.97, 3897.99,
    3921.07,  3951.93,  3944.2,  3982.88,  4006.17, 4037.3,  4049,    4056.81,
    4084.2,   4123.45,  4115.59, 4135.26,  4166.83, 4182.65, 4218.34, 4230.27,
    4246.2,   4278.14,  4298.15, 4306.17,  4326.25, 4350.4,  4370.57, 4382.69,
    4415.1,   4439.48,  4439.48, 4451.69,  4476.16, 4508.89, 4521.2,  4554.09,
    4554.09,  4587.09,  4607.78, 4632.67,  4640.98, 4645.14, 4686.82, 4707.73,
    4728.69,  4737.08,  4753.9,  4774.96,  4800.3,  4821.47, 4825.71, 4846.93,
    4881,     4893.8,   4915.19, 4945.21,  4958.1,  4966.71, 4983.94, 5005.54,
    5027.18,  5040.19,  5048.87, 5070.62,  5096.78, 5096.78, 5127.4,  5149.33,
    5166.91,  5184.53,  5206.6,  5206.6,   5237.58, 5264.22, 5268.67, 5290.94,
    5317.74,  5317.74,  5344.62, 5349.1,   5376.07, 5398.61, 5407.64, 5443.84,
    5452.92,  5480.2,   5475.64, 5502.99,  5502.99, 5544.16, 5544.16, 5580.92,
    5590.13,  5594.74,  5617.82, 5645.6,   5654.87, 5678.11, 5692.08, 5710.74,
    5738.8,   5743.49,  5766.95, 5771.65,  5809.34, 5814.06, 5828.24, 5832.97,
    5851.93,  5851.93,  5885.19, 5918.58,  5904.25, 5947.29, 5947.29, 5990.54,
    5971.29,  5995.36,  6019.49, 6029.16,  6053.38, 6082.52, 6077.66, 6106.89,
    6106.89,  6131.32,  6141.11, 6155.82,  6175.46, 6190.22, 6214.88, 6219.82,
    6249.52,  6264.4,   6259.44, 6284.29,  6309.21, 6314.2,  6319.2,  6349.23,
    6359.26,  6364.28,  6394.46, 6419.69,  6434.86, 6439.93, 6450.06, 6470.37,
    6485.63,  6500.91,  6521.33, 6536.68,  6557.18, 6577.73, 6572.59, 6577.73,
    6598.33,  6618.98,  6629.32, 6624.15,  6655.23, 6665.61, 6691.63, 6691.63,
    6717.72,  6728.17,  6743.88, 6759.62,  6770.13, 6796.45, 6812.29, 6807.01,
    6844.04,  6854.64,  6849.34, 6859.95,  6881.22, 6902.54, 6913.22, 6923.92,
    6956.07,  6939.98,  6966.82, 6993.74,  6993.74, 7009.93, 7009.93, 7058.68,
    7053.25,  7075,     7075,    7102.25,  7102.25, 7102.25, 7135.07, 7129.59,
    7151.52,  7179.02,  7168.01, 7212.13,  7217.66, 7217.66, 7228.73, 7250.92,
    7273.16,  7273.16,  7289.88, 7306.63,  7323.41, 7334.62, 7340.23, 7334.62,
    7351.45,  7379.59,  7385.23, 7407.81,  7390.87, 7447.49, 7430.46, 7464.54,
    7470.24,  7493.05,  7487.34, 7498.76,  7527.38, 7538.85, 7538.85, 7550.34,
    7590.68,  7579.13,  7596.45, 7613.81,  7631.2,  7631.2,  7648.62, 7654.44,
    7660.26,  7683.58,  7689.42, 7701.11,  7730.41, 7712.82, 7742.16, 7730.41,
    7765.7,   7783.4,   7783.4,  7789.31,  7807.06, 7812.98, 7818.91, 7848.61,
    7860.52,  7866.49,  7884.4,  7884.4,   7908.33, 7902.34, 7926.33, 7932.34,
    7938.35,  7968.47,  7968.47, 7986.6,   7980.55, 7974.51, 8035.12, 8035.12,
    8047.29,  8065.58,  8047.29, 8065.58,  8077.8,  8090.04, 8108.42, 8120.7,
    8126.85,  8133,     8145.31, 8151.47,  8169.99, 8169.99, 8182.36, 8200.95,
    8207.15,  8219.57,  8232.01, 8238.24,  8244.47, 8238.24, 8263.2,  8294.49,
    8281.96,  8300.77,  8313.33, 8332.2,   8338.51, 8338.51, 8363.76, 8376.41,
    8376.41,  8370.08,  8401.78, 8414.49,  8389.09, 8427.22, 8427.22, 8446.35,
    8446.35,  8478.34,  8497.59, 8484.75,  8504.01, 8523.32, 8510.45, 8516.88,
    8536.22,  8549.14,  8568.55, 8568.55,  8581.51, 8588,    8581.51, 8614.02,
    8614.02,  8646.65,  8633.58, 8640.11,  8633.58, 8666.29, 8679.41, 8685.97,
    8699.12,  8692.55,  8705.71, 8705.71,  8745.31, 8725.48, 8751.93, 8745.31,
    8765.18,  8778.46,  8805.07, 8778.46,  8811.74, 8805.07, 8805.07, 8825.08,
    8838.46,  8831.77,  8851.85, 8831.77,  8865.26, 8885.42, 8865.26, 8892.15,
    8912.38,  8898.89,  8932.65, 8932.65,  8980.16, 8932.65, 8946.2,  8959.76,
    8959.76,  9000.6,   9000.6,  8993.78,  9021.09, 8993.78, 9041.63, 9027.93,
    9041.63,  9048.49,  9069.1,  9062.23,  9096.66, 9096.66, 9082.87, 9089.76,
    9103.57,  9103.57,  9138.18, 9138.18,  9131.24, 9138.18, 9172.93, 9165.97,
    9186.88,  9186.88,  9172.93, 9200.84,  9207.84, 9214.83, 9207.84, 9214.83,
    9249.92,  9249.92,  9256.95, 9263.99,  9271.04, 9271.04, 9285.15, 9299.28,
    9299.28,  9278.09,  9313.44, 9320.53,  9313.44, 9320.53, 9334.72, 9356.06,
    9341.83,  9356.06,  9341.83, 9356.06,  9370.32, 9384.6,  9406.07, 9377.46,
    9420.42,  9406.07,  9413.24, 9449.18,  9427.6,  9441.98, 9456.39, 9456.39,
    9463.6,   9449.18,  9463.6,  9514.27,  9492.52, 9478.05, 9507.01, 9499.76,
    9536.08,  9507.01,  9514.27, 9499.76,  9536.08, 9543.37, 9557.96, 9543.37,
    9565.26,  9572.57,  9572.57, 9594.54,  9609.22, 9594.54, 9579.88, 9609.22,
    9623.92,  9623.92,  9631.29, 9616.57,  9660.8,  9631.29, 9631.29, 9638.65,
    9653.41,  9653.41,  9668.2,  9675.6,   9705.28, 9690.43, 9683.01, 9697.85,
    9705.28,  9720.16,  9727.61, 9727.61,  9727.61, 9742.53, 9750,    9750,
    9742.53,  9757.48,  9757.48, 9764.97,  9764.97, 9757.48, 9787.46, 9794.97,
    9787.46,  9794.97,  9779.96, 9810.02,  9810.02, 9810.02, 9840.19, 9825.09,
    9840.19,  9847.76,  9825.09, 9893.27,  9870.48, 9870.48, 9855.32, 9870.48,
    9862.9,   9878.07,  9878.07, 9900.88,  9878.07, 9931.4,  9916.13, 9893.27,
    9923.76,  9916.13,  9931.4,  9908.5,   9916.13, 9939.05, 9946.7,  9931.4,
    9977.39,  9962.03,  9954.36, 9946.7,   9977.39, 9992.78, 9992.78, 9992.78,
    10015.9,  9977.39,  9977.39, 10008.2,  10015.9, 10031.4, 10008.2, 10015.9,
    10015.9,  10023.6,  10023.6, 10046.9,  10031.4, 10062.4, 10054.6, 10046.9,
    10039.1,  10039.1,  10046.9, 10062.4,  10062.4, 10078,   10078,   10070.2,
    10062.4,  10101.3,  10109.1, 10109.1,  10101.3, 10093.5, 10109.1, 10109.1,
    10109.1,  10093.5,  10109.1, 10101.3,  10140.5, 10124.8, 10124.8, 10124.8,
    10140.5,  10179.8,  10148.3, 10140.5,  10132.6, 10140.5, 10164,   10164,
    10164,    10171.9,  10179.8, 10171.9,  10195.6, 10179.8, 10187.7, 10179.8,
    10171.9,  10171.9,  10203.5, 10187.7,  10211.4, 10243.1, 10211.4, 10219.3,
    10203.5,  10227.2,  10219.3, 10211.4,  10211.4, 10219.3, 10227.2, 10211.4,
    10259,    10259,    10227.2, 10235.2,  10227.2, 10243.1, 10243.1, 10267,
    10259,    10227.2,  10243.1, 10259,    10243.1, 10267,   10267,   10267,
    10267,    10274.9,  10259,   10274.9,  10259,   10267,   10290.9, 10274.9,
    10290.9,  10282.9,  10274.9, 10290.9,  10306.9, 10306.9, 10290.9, 10290.9,
    10331,    10306.9,  10314.9, 10282.9,  10314.9, 10323,   10290.9, 10306.9,
    10323,    10323,    10314.9, 10298.9,  10298.9, 10314.9, 10339,   10347.1,
    10314.9,  10298.9,  10323,   10331,    10323,   10331,   10323,   10331,
    10339,    10314.9,  10347.1, 10323,    10323,   10314.9, 10355.1, 10323,
    10314.9,  10331,    10331,   10339,    10347.1, 10347.1, 10355.1, 10323,
    10347.1,  10314.9,  10347.1, 10363.2,  10347.1, 10339,   10355.1, 10363.2,
    10355.1,  10371.2,  10339,   10347.1,  10331,   10355.1, 10331,   10331,
    10363.2,  10355.1,  10379.3, 10379.3,  10387.4, 10355.1, 10339,   10371.2,
    10371.2,  10347.1,  10379.3, 10371.2,  10371.2, 10363.2, 10371.2, 10347.1,
    10363.2,  10371.2,  10339,   10363.2,  10331,   10355.1, 10363.2, 10355.1,
    10347.1,  10339,    10347.1, 10379.3,  10355.1, 10363.2, 10379.3, 10331,
    10379.3,  10363.2,  10355.1, 10355.1,  10371.2, 10371.2, 10347.1, 10331,
    10347.1,  10347.1,  10331,   10363.2,  10339,   10363.2, 10339,   10363.2,
    10347.1,  10355.1,  10339,   10339,    10347.1, 10314.9, 10314.9, 10339,
    10331,    10290.9,  10331,   10347.1,  10355.1, 10323,   10347.1, 10355.1,
    10306.9,  10306.9,  10306.9, 10323,    10323,   10331,   10323,   10331,
    10298.9,  10298.9,  10323,   10314.9,  10323,   10306.9, 10314.9, 10306.9,
    10298.9,  10282.9,  10314.9, 10282.9,  10282.9, 10298.9, 10298.9, 10306.9,
    10306.9,  10306.9,  10282.9, 10290.9,  10290.9, 10267,   10290.9, 10290.9,
    10282.9,  10290.9,  10267,   10259,    10282.9, 10267,   10243.1, 10259,
    10243.1,  10243.1,  10259,   10259,    10251,   10251,   10259,   10243.1,
    10274.9,  10211.4,  10235.2, 10243.1,  10235.2, 10243.1, 10219.3, 10227.2,
    10211.4,  10203.5,  10219.3, 10219.3,  10219.3, 10195.6, 10203.5, 10203.5,
    10211.4,  10227.2,  10211.4, 10195.6,  10171.9, 10179.8, 10171.9, 10179.8,
    10164,    10179.8,  10187.7, 10171.9,  10156.2, 10164,   10140.5, 10148.3,
    10171.9,  10132.6,  10164,   10117,    10132.6, 10140.5, 10132.6, 10109.1,
    10156.2,  10124.8,  10132.6, 10117,    10117,   10101.3, 10078,   10101.3,
    10124.8,  10117,    10093.5, 10085.7,  10093.5, 10078,   10070.2, 10070.2,
    10070.2,  10039.1,  10039.1, 10054.6,  10031.4, 10078,   10078,   10031.4,
    10054.6,  10023.6,  10039.1, 10039.1,  10000.5, 10000.5, 10008.2, 10008.2,
    10000.5,  9985.08,  9985.08, 10000.5,  10008.2, 9985.08, 9977.39, 9969.71,
    9954.36,  9977.39,  9969.71, 9954.36,  9939.05, 9962.03, 9946.7,  9946.7,
    9939.05,  9923.76,  9900.88, 9916.13,  9931.4,  9923.76, 9939.05, 9916.13,
    9893.27,  9893.27,  9908.5,  9885.67,  9893.27, 9855.32, 9885.67, 9855.32,
    9855.32,  9862.9,   9870.48, 9840.19,  9840.19, 9840.19, 9832.64, 9825.09,
    9810.02,  9825.09,  9802.49, 9832.64,  9832.64, 9802.49, 9794.97, 9810.02,
    9779.96,  9779.96,  9757.48, 9764.97,  9764.97, 9742.53, 9757.48, 9735.07,
    9735.07,  9712.72,  9712.72, 9727.61,  9720.16, 9720.16, 9683.01, 9697.85,
    9712.72,  9668.2,   9697.85, 9668.2,   9675.6,  9675.6,  9653.41, 9675.6,
    9668.2,   9638.65,  9638.65, 9616.57,  9653.41, 9609.22, 9616.57, 9587.21,
    9594.54,  9587.21,  9587.21, 9572.57,  9565.26, 9579.88, 9565.26, 9543.37,
    9543.37,  9528.81,  9521.54, 9514.27,  9521.54, 9514.27, 9528.81, 9485.28,
    9499.76,  9499.76,  9478.05, 9492.52,  9470.82, 9470.82, 9463.6,  9449.18,
    9470.82,  9449.18,  9441.98, 9420.42,  9441.98, 9406.07, 9413.24, 9398.91,
    9398.91,  9391.75,  9406.07, 9363.19,  9384.6,  9370.32, 9341.83, 9327.62,
    9348.94,  9313.44,  9313.44, 9313.44,  9320.53, 9299.28, 9306.36, 9306.36,
    9278.09,  9263.99,  9271.04, 9263.99,  9249.92, 9235.87, 9242.89, 9228.85,
    9214.83,  9221.84,  9207.84, 9221.84,  9200.84, 9193.86, 9165.97, 9159.01,
    9186.88,  9165.97,  9138.18, 9159.01,  9138.18, 9145.12, 9131.24, 9103.57,
    9103.57,  9110.48,  9089.76, 9089.76,  9069.1,  9082.87, 9062.23, 9075.98,
    9062.23,  9048.49,  9021.09, 9007.42,  9007.42, 9007.42, 8993.78, 8980.16,
    8966.56,  8973.35,  8966.56, 8952.98,  8952.98, 8946.2,  8932.65, 8919.13,
    8905.63,  8925.89,  8905.63, 8898.89,  8865.26, 8885.42, 8871.97, 8871.97,
    8858.55,  8858.55,  8811.74, 8818.41,  8811.74, 8805.07, 8805.07, 8785.1,
    8778.46,  8771.82,  8751.93, 8751.93,  8751.93, 8732.09, 8712.29, 8732.09,
    8718.89,  8705.71,  8705.71, 8705.71,  8672.84, 8679.41, 8653.19, 8666.29,
    8640.11,  8646.65,  8627.06, 8620.53,  8620.53, 8594.5,  8594.5,  8581.51,
    8581.51,  8549.14,  8542.67, 8549.14,  8536.22, 8516.88, 8510.45, 8516.88,
    8523.32,  8478.34,  8471.93, 8478.34,  8446.35, 8459.13, 8452.74, 8446.35,
    8427.22,  8408.13,  8401.78, 8389.09,  8382.75, 8389.09, 8382.75, 8351.12,
    8344.81,  8325.91,  8319.62, 8325.91,  8300.77, 8307.05, 8307.05, 8281.96,
    8256.95,  8256.95,  8232.01, 8244.47,  8232.01, 8219.57, 8219.57, 8207.15,
    8182.36,  8169.99,  8169.99, 8169.99,  8139.15, 8157.64, 8151.47, 8108.42,
    8108.42,  8114.56,  8090.04, 8077.8,   8083.92, 8077.8,  8071.69, 8029.04,
    8029.04,  8016.89,  8035.12, 7998.7,   7998.7,  7980.55, 7974.51, 7944.37,
    7938.35,  7920.33,  7938.35, 7914.33,  7908.33, 7890.37, 7896.36, 7872.45,
    7854.57,  7836.72,  7848.61, 7836.72,  7818.91, 7818.91, 7801.14, 7807.06,
    7783.4,   7765.7,   7765.7,  7748.04,  7736.28, 7712.82, 7712.82, 7701.11,
    7683.58,  7701.11,  7677.74, 7660.26,  7631.2,  7642.81, 7631.2,  7596.45,
    7602.23,  7602.23,  7590.68, 7561.85,  7573.37, 7544.6,  7533.12, 7521.65,
    7515.92,  7510.2,   7504.48, 7470.24,  7464.54, 7464.54, 7447.49, 7436.13,
    7402.16,  7419.13,  7402.16, 7368.32,  7368.32, 7351.45, 7362.7,  7345.84,
    7334.62,  7329.01,  7306.63, 7295.46,  7278.73, 7273.16, 7273.16, 7267.59,
    7212.13,  7228.73,  7212.13, 7201.08,  7195.56, 7195.56, 7173.51, 7146.04,
    7146.04,  7140.55,  7129.59, 7107.71,  7085.89, 7085.89, 7058.68, 7058.68,
    7064.12,  7047.83,  7020.74, 7015.33,  7004.53, 6977.57, 6977.57, 6956.07,
    6950.7,   6956.07,  6923.92, 6913.22,  6897.21, 6891.88, 6865.27, 6854.64,
    6854.64,  6838.74,  6833.44, 6812.29,  6812.29, 6796.45, 6780.65, 6780.65,
    6759.62,  6728.17,  6733.41, 6722.94,  6696.84, 6686.42, 6681.21, 6676.01,
    6650.04,  6639.68,  6639.68, 6603.49,  6603.49, 6593.18, 6593.18, 6572.59,
    6562.32,  6531.56,  6536.68, 6516.22,  6490.72, 6475.45, 6470.37, 6475.45,
    6470.37,  6439.93,  6434.86, 6419.69,  6389.42, 6384.39, 6374.33, 6354.24,
    6359.26,  6349.23,  6309.21, 6314.2,   6289.27, 6279.31, 6274.34, 6259.44,
    6249.52,  6234.66,  6219.82, 6209.95,  6190.22, 6195.15, 6155.82, 6155.82,
    6136.21,  6116.65,  6111.77, 6106.89,  6087.39, 6053.38, 6063.08, 6043.68,
    6033.99,  6033.99,  6009.83, 6005,     5976.1,  5961.69, 5961.69, 5947.29,
    5928.14,  5909.03,  5899.48, 5885.19,  5875.67, 5875.67, 5837.71, 5832.97,
    5818.79,  5795.19,  5795.19, 5762.25,  5776.35, 5752.86, 5729.44, 5720.08,
    5696.74,  5692.08,  5682.76, 5673.46,  5650.23, 5645.6,  5627.07, 5599.35,
    5585.52,  5571.71,  5562.52, 5562.52,  5539.58, 5512.12, 5516.69, 5498.43,
    5493.87,  5475.64,  5462,    5439.31,  5425.72, 5412.16, 5389.59, 5371.57,
    5362.58,  5362.58,  5326.69, 5326.69,  5326.69, 5299.87, 5282.03, 5277.57,
    5259.78,  5242.02,  5228.72, 5219.86,  5188.94, 5184.53, 5175.72, 5149.33,
    5144.94,  5127.4,   5118.64, 5074.98,  5088.05, 5079.33, 5057.57, 5044.53,
    5035.85,  5005.54,  5005.54, 4975.32,  4975.32, 4949.5,  4932.33, 4928.04,
    4919.47,  4902.35,  4898.08, 4872.47,  4855.44, 4842.68, 4825.71, 4817.23,
    4800.3,   4783.4,   4770.75, 4749.69,  4728.69, 4716.11, 4711.92, 4699.36,
    4678.47,  4665.95,  4657.62, 4628.52,  4616.07, 4607.78, 4582.96, 4570.58,
    4562.33,  4541.74,  4529.41, 4504.8,   4496.61, 4492.51, 4476.16, 4455.76,
    4443.54,  4423.22,  4419.16, 4398.88,  4382.69, 4354.43, 4338.31, 4338.31,
    4322.23,  4302.16,  4302.16, 4278.14,  4266.15, 4242.22, 4246.2,  4214.37,
    4206.43,  4178.69,  4166.83, 4166.83,  4143.14, 4127.39, 4119.52, 4080.28,
    4084.2,   4064.63,  4049,    4033.4,   4021.72, 4002.28, 3986.76, 3971.26,
    3975.13,  3955.79,  3924.92, 3917.22,  3890.31, 3874.97, 3867.31, 3836.73,
    3829.1,   3817.67,  3794.84, 3794.84,  3779.65, 3760.7,  3745.57, 3726.68,
    3700.31,  3696.55,  3681.52, 3666.51,  3659.01, 3632.83, 3614.17, 3602.99,
    3584.38,  3573.24,  3562.11, 3547.28,  3521.4,  3506.64, 3499.27, 3480.87,
    3469.84,  3447.83,  3447.83, 3407.6,   3393.02, 3378.46, 3360.28, 3349.39,
    3338.52,  3320.42,  3305.97, 3291.53,  3277.12, 3269.93, 3241.19, 3223.27,
    3205.39,  3183.97,  3166.16, 3173.28,  3148.38, 3130.64, 3116.47, 3088.18,
    3088.18,  3077.6,   3056.46, 3035.37,  3024.84, 3003.82, 2986.34, 2975.86,
    2961.91,  2947.99,  2923.66, 2909.78,  2895.93, 2878.64, 2854.48, 2844.15,
    2833.83,  2799.5,   2789.22, 2789.22,  2761.87, 2748.23, 2731.19, 2727.79,
    2710.8,   2690.44,  2673.51, 2659.99,  2633,    2619.53, 2619.53, 2589.3,
    2589.3,   2552.47,  2539.11, 2539.11,  2515.78, 2499.15, 2479.23, 2462.66,
    2449.42,  2423,     2413.12, 2396.66,  2386.79, 2367.1,  2350.72, 2337.63,
    2321.3,   2301.73,  2288.71, 2275.71,  2259.48, 2227.09, 2217.4,  2191.59,
    2185.15,  2175.5,   2153.01, 2140.18,  2120.97, 2101.8,  2089.04, 2085.85,
    2060.39,  2047.68,  2041.33, 2009.65,  1993.85, 1984.38, 1959.17, 1952.88,
    1930.89,  1918.35,  1896.43, 1887.06,  1871.45, 1840.3,  1834.08, 1824.77,
    1803.06,  1784.49,  1759.78, 1753.61,  1735.13, 1719.76, 1719.76, 1695.21,
    1664.61,  1658.5,   1640.2,  1621.93,  1600.65, 1591.55, 1573.36, 1546.15,
    1546.15,  1528.05,  1506.97, 1485.94,  1473.94, 1458.96, 1447,    1426.09,
    1420.12,  1393.32,  1372.52, 1357.69,  1345.85, 1328.1,  1310.39, 1286.82,
    1277.99,  1254.5,   1242.77, 1225.2,   1213.51, 1198.91, 1181.42, 1169.78,
    1158.15,  1134.93,  1114.66, 1100.2,   1085.77, 1062.71, 1048.33, 1025.36,
    1022.49,  996.723,  993.863, 959.612,  951.067, 931.157, 922.636, 902.781,
    885.793,  874.484,  849.083, 843.447,  815.313, 809.696, 787.257, 764.867,
    759.278,  750.899,  717.451, 709.106,  681.339, 681.339, 656.413, 645.354,
    623.272,  612.249,  592.986, 581.996,  571.017, 540.884, 524.486, 508.113,
    494.489,  478.164,  461.865, 453.725,  429.344, 423.934, 394.229, 375.369,
    367.298,  348.488,  332.392, 310.97,   289.592, 284.255, 257.608, 246.969,
    231.03,   212.466,  193.936, 186.004,  164.882, 146.436, 133.281, 114.89,
    104.396,  80.8236,  59.9147, 49.476,   31.2335, 10.424,  -5.15584};

// ------------------------ STATE ------------------------
static const std::vector<float> STATE_1 = {
    -5.155840,    -5.127542,    -5.035614,    -5.036693,    -4.930338,
    -4.778159,    -4.657320,    -4.484589,    -4.206635,    -3.962533,
    -3.758284,    -3.543156,    -3.195865,    -2.766663,    -2.248406,
    -1.777812,    -1.135055,    -0.385216,    0.478669,     1.552121,
    2.756321,     3.998874,     5.276311,     6.799325,     8.355774,
    10.291032,    12.867224,    15.608159,    18.510568,    21.433261,
    24.646535,    28.150656,    31.943763,    35.710616,    39.915629,
    45.051273,    49.603286,    54.753909,    60.320700,    66.292296,
    73.025446,    79.374320,    86.664728,    94.879009,    102.801471,
    110.616927,   118.513838,   126.682261,   135.312536,   144.169075,
    153.232288,   162.049641,   172.144871,   182.809235,   193.121285,
    203.301774,   213.793909,   224.575486,   235.853922,   247.139040,
    259.578268,   271.485080,   283.570738,   296.288342,   308.419177,
    320.926339,   333.545998,   346.982239,   359.988798,   373.539044,
    386.873979,   401.451254,   415.256966,   429.782724,   444.742361,
    459.615110,   473.655917,   487.883132,   502.776189,   518.048245,
    533.424439,   548.891875,   565.942027,   581.729141,   597.814741,
    614.429573,   630.529410,   646.891320,   664.003948,   680.551423,
    697.829056,   714.772441,   732.671902,   750.190654,   767.854723,
    785.650588,   803.823860,   822.350189,   840.686795,   859.096578,
    878.091242,   896.591824,   915.663006,   935.534326,   953.795433,
    973.151603,   992.489844,   1012.334622,  1032.391591,  1052.645275,
    1073.880077,  1094.174791,  1113.836788,  1134.767716,  1155.560324,
    1177.022824,  1197.501748,  1218.389766,  1239.393057,  1260.503044,
    1282.525688,  1304.869471,  1327.240548,  1350.181997,  1372.838135,
    1394.668992,  1417.089344,  1440.068080,  1463.298563,  1485.931758,
    1509.384839,  1533.337681,  1556.923505,  1580.717877,  1604.708338,
    1628.037742,  1652.146811,  1676.148403,  1700.328415,  1724.676465,
    1749.182711,  1774.981512,  1800.289558,  1825.128810,  1850.094955,
    1875.759394,  1901.797471,  1927.900193,  1954.062721,  1980.280588,
    2006.257914,  2032.004473,  2058.708163,  2085.142742,  2111.912350,
    2139.001472,  2166.096038,  2192.003552,  2218.274599,  2245.192586,
    2271.525930,  2298.206786,  2324.615283,  2350.161303,  2376.707069,
    2403.294684,  2429.314279,  2455.099923,  2481.892440,  2507.494203,
    2533.197005,  2559.308525,  2584.883333,  2611.191806,  2636.646303,
    2662.539570,  2687.289680,  2712.837202,  2736.321148,  2762.253327,
    2786.732615,  2810.466403,  2835.400278,  2859.254681,  2883.363412,
    2907.080382,  2931.391775,  2955.311336,  2980.153177,  3003.939778,
    3027.700217,  3050.792497,  3074.556308,  3097.662169,  3121.128705,
    3144.290601,  3166.841671,  3189.804313,  3212.507448,  3235.301890,
    3258.189396,  3281.506977,  3303.241474,  3324.477720,  3346.921257,
    3369.181121,  3390.601152,  3411.566356,  3433.120517,  3454.567172,
    3475.918773,  3497.529123,  3519.734323,  3541.489362,  3562.480269,
    3584.125280,  3605.025613,  3626.603160,  3647.452383,  3668.654239,
    3688.811980,  3711.116811,  3732.332920,  3753.918946,  3774.463722,
    3794.727213,  3815.434862,  3836.574402,  3857.070867,  3876.964757,
    3897.356957,  3917.876682,  3938.526153,  3960.022651,  3978.748574,
    3999.152977,  4019.725941,  4041.188147,  4061.695034,  4080.938568,
    4100.802720,  4122.357745,  4141.152292,  4159.884887,  4179.665849,
    4198.984663,  4219.710180,  4239.569982,  4258.982599,  4279.458147,
    4299.838307,  4319.019281,  4338.184205,  4357.714459,  4377.225274,
    4395.974640,  4415.885801,  4436.156830,  4454.511894,  4472.185579,
    4490.353730,  4509.760005,  4528.450590,  4548.372809,  4566.417012,
    4585.742183,  4605.143607,  4625.008742,  4643.778890,  4661.129014,
    4680.613589,  4700.199246,  4719.887103,  4738.508651,  4756.902915,
    4775.477341,  4794.621713,  4813.921962,  4831.802881,  4849.914525,
    4869.438417,  4888.331656,  4907.424759,  4927.508639,  4946.945146,
    4965.372385,  4983.643565,  5002.173952,  5020.955736,  5039.177811,
    5056.470088,  5074.094896,  5092.446269,  5109.064289,  5126.879693,
    5145.027416,  5163.088994,  5181.074483,  5199.402086,  5216.010498,
    5233.862754,  5252.494101,  5269.808984,  5287.529232,  5306.055461,
    5322.863500,  5340.535900,  5356.953956,  5374.269670,  5392.028023,
    5408.955692,  5427.615703,  5445.405710,  5464.058616,  5480.579699,
    5498.038898,  5513.854781,  5531.930645,  5548.335197,  5566.563836,
    5583.969689,  5600.170505,  5616.942780,  5634.694315,  5651.660006,
    5669.176714,  5686.357900,  5703.656864,  5721.939692,  5738.989956,
    5756.612179,  5773.039069,  5791.391457,  5808.514321,  5825.349117,
    5841.036492,  5856.957039,  5871.344005,  5887.362610,  5904.942343,
    5919.580760,  5936.749766,  5952.330663,  5970.415750,  5985.083448,
    6000.528223,  6016.717656,  6032.274725,  6048.582555,  6066.059414,
    6081.494199,  6098.153761,  6113.266873,  6129.179817,  6144.496031,
    6159.704408,  6175.269490,  6190.722301,  6206.987809,  6222.197476,
    6238.702327,  6255.062542,  6269.447878,  6284.725682,  6300.857906,
    6315.954288,  6330.071281,  6345.581805,  6360.561673,  6374.575967,
    6390.008904,  6406.329525,  6422.559937,  6437.769295,  6452.480793,
    6467.665414,  6482.832021,  6497.984722,  6513.601822,  6529.190233,
    6545.229442,  6561.701009,  6576.201830,  6589.788455,  6603.943560,
    6618.644395,  6632.908797,  6645.324067,  6659.348835,  6672.983573,
    6687.700134,  6701.032573,  6715.472826,  6729.515639,  6743.670812,
    6757.936932,  6771.825099,  6786.821734,  6801.898920,  6815.095968,
    6830.433349,  6845.351223,  6858.398584,  6871.149143,  6884.608808,
    6898.747415,  6912.545054,  6926.022784,  6941.186636,  6953.479188,
    6967.030270,  6981.783689,  6995.182981,  7008.800269,  7021.125482,
    7036.745666,  7050.468845,  7064.913173,  7078.026311,  7092.404135,
    7105.456482,  7117.253851,  7130.905541,  7142.767517,  7155.475332,
    7169.503244,  7181.214934,  7195.841905,  7209.657049,  7222.190706,
    7234.537052,  7247.738332,  7261.756064,  7274.487428,  7287.550052,
    7300.930791,  7314.616820,  7328.076724,  7340.804054,  7351.798569,
    7363.232651,  7376.134236,  7388.343481,  7401.467809,  7411.798578,
    7426.300573,  7437.932274,  7451.580746,  7464.511826,  7478.349038,
    7490.402566,  7502.353906,  7515.803946,  7529.086037,  7541.146399,
    7553.114646,  7567.670536,  7579.870603,  7592.513513,  7605.580897,
    7619.053950,  7631.300209,  7643.998676,  7656.051740,  7667.494214,
    7679.981306,  7691.839960,  7703.646291,  7717.036296,  7727.582731,
    7739.784400,  7749.748950,  7761.954463,  7774.655731,  7786.187277,
    7797.158910,  7808.698857,  7819.682907,  7830.142785,  7842.310750,
    7854.450476,  7866.013699,  7878.137958,  7889.135223,  7901.283120,
    7911.750085,  7923.403549,  7934.516928,  7945.119738,  7957.474570,
    7968.699769,  7980.535190,  7990.709259,  7999.311348,  8012.602841,
    8024.723385,  8036.861616,  8049.583907,  8059.469932,  8070.058787,
    8080.753271,  8091.551316,  8103.017917,  8114.553871,  8125.588157,
    8136.147866,  8146.829947,  8157.059562,  8168.007299,  8177.920852,
    8188.002143,  8198.820704,  8209.191287,  8219.714975,  8230.386988,
    8240.625322,  8250.453986,  8258.741548,  8268.461507,  8280.128110,
    8289.579848,  8299.837741,  8310.282138,  8321.489134,  8332.255596,
    8342.020328,  8353.176676,  8364.485163,  8374.765752,  8383.486232,
    8394.254093,  8405.204031,  8412.795494,  8423.093165,  8432.424393,
    8442.613756,  8451.845043,  8463.134084,  8475.193418,  8485.008477,
    8495.671300,  8507.142895,  8516.398907,  8525.344306,  8535.193484,
    8545.305743,  8556.269583,  8566.242124,  8576.476522,  8586.360235,
    8594.709570,  8605.220372,  8614.768311,  8626.428060,  8635.854416,
    8644.980596,  8652.613505,  8662.469679,  8672.619307,  8682.439691,
    8692.559246,  8701.135514,  8710.078665,  8718.151751,  8729.071714,
    8737.183431,  8746.923210,  8755.142866,  8764.377956,  8773.966233,
    8785.125241,  8792.841041,  8802.844251,  8811.314558,  8818.951189,
    8827.654070,  8836.754967,  8844.374446,  8853.072331,  8859.072659,
    8867.483246,  8876.945456,  8883.668977,  8892.158740,  8901.707361,
    8909.135540,  8918.933869,  8927.851050,  8940.335953,  8947.395863,
    8954.972645,  8963.042505,  8970.324897,  8980.647309,  8990.066946,
    8997.998704,  9007.683875,  9013.970045,  9024.001179,  9031.879059,
    9040.255792,  9048.472678,  9057.813239,  9065.672779,  9075.956498,
    9085.347273,  9092.613399,  9099.783278,  9107.505188,  9114.472290,
    9123.932988,  9132.550560,  9139.726089,  9146.822401,  9156.422532,
    9164.531078,  9173.808764,  9182.257061,  9188.626807,  9196.907233,
    9205.062322,  9213.098360,  9219.726902,  9226.318568,  9235.481341,
    9243.829960,  9252.058435,  9260.174413,  9268.185238,  9275.443757,
    9283.297869,  9291.719337,  9299.369605,  9304.326062,  9311.971206,
    9319.547890,  9325.746621,  9331.955099,  9338.832989,  9347.009671,
    9353.121966,  9359.916344,  9364.721781,  9370.282098,  9376.563649,
    9383.532822,  9391.821402,  9396.720215,  9405.040129,  9411.292975,
    9417.581806,  9426.572403,  9432.793652,  9439.723018,  9447.327565,
    9454.237288,  9461.157264,  9466.083576,  9471.794905,  9481.611690,
    9488.608297,  9493.606232,  9500.736214,  9506.532920,  9515.104670,
    9520.247363,  9525.507691,  9528.864606,  9535.131079,  9541.467476,
    9548.547709,  9553.629608,  9560.199437,  9566.829800,  9572.840863,
    9580.301821,  9588.461773,  9594.562931,  9598.714997,  9605.099288,
    9612.244275,  9618.748344,  9625.328250,  9629.933633,  9638.131846,
    9642.902451,  9647.159894,  9651.615545,  9656.947361,  9661.743795,
    9667.405182,  9673.203078,  9681.195945,  9687.142441,  9691.837943,
    9697.412049,  9703.133717,  9709.686592,  9716.339181,  9722.395931,
    9727.888280,  9734.229127,  9740.684365,  9746.555948,  9751.182594,
    9756.708255,  9761.701973,  9766.886844,  9771.560159,  9775.056128,
    9780.910785,  9786.920179,  9791.684761,  9796.662388,  9799.756516,
    9805.244283,  9810.216835,  9814.702057,  9821.522512,  9826.361514,
    9832.121448,  9838.057098,  9841.357294,  9850.579862,  9856.984897,
    9862.829800,  9866.738951,  9871.624325,  9875.329211,  9880.025121,
    9884.256168,  9890.161732,  9893.427601,  9901.248564,  9907.029686,
    9910.173356,  9915.762525,  9920.138221,  9925.486672,  9928.220813,
    9931.308134,  9936.149717,  9941.240391,  9944.441074,  9951.531434,
    9956.623307,  9960.533262,  9963.325072,  9968.613032,  9974.850113,
    9980.560150,  9985.770116,  9992.648465,  9995.396314,  9997.798890,
    10002.732023, 10007.923438, 10014.082589, 10017.572305, 10021.396038,
    10024.824382, 10028.593131, 10031.972546, 10037.143644, 10040.418138,
    10046.205025, 10050.777987, 10054.209692, 10056.551658, 10058.585853,
    10061.053988, 10064.649570, 10067.879177, 10072.208969, 10076.136858,
    10078.961780, 10080.742881, 10085.864654, 10091.271656, 10096.225575,
    10100.026822, 10102.736010, 10106.580027, 10110.055267, 10113.181962,
    10114.534076, 10117.097919, 10118.644301, 10123.584080, 10126.653576,
    10129.405875, 10131.859039, 10135.485284, 10142.411319, 10145.902803,
    10148.334669, 10149.754421, 10151.681447, 10155.537281, 10159.044627,
    10162.222155, 10165.819922, 10169.816613, 10172.727507, 10177.538181,
    10180.489125, 10183.873915, 10186.206575, 10187.543283, 10188.670334,
    10192.529560, 10194.587061, 10198.598221, 10205.202843, 10208.388740,
    10212.003196, 10213.828025, 10217.618159, 10220.343491, 10222.060212,
    10223.554647, 10225.572558, 10228.088435, 10228.881430, 10233.918524,
    10238.567394, 10239.900305, 10241.779363, 10242.695275, 10244.915199,
    10246.899404, 10250.876186, 10253.785655, 10253.478185, 10254.544269,
    10256.914958, 10257.576811, 10260.309000, 10262.789995, 10265.033490,
    10267.052689, 10269.592354, 10270.420659, 10272.575269, 10273.041610,
    10274.124415, 10277.266974, 10278.665008, 10281.375693, 10283.107217,
    10283.911466, 10286.062477, 10289.491078, 10292.647745, 10294.063538,
    10295.312656, 10300.121028, 10302.353000, 10305.117077, 10304.679045,
    10307.138498, 10310.130750, 10309.902712, 10311.081287, 10313.604227,
    10315.909962, 10317.259378, 10316.971167, 10316.615635, 10317.681721,
    10320.847646, 10324.521118, 10324.940135, 10323.776497, 10324.831585,
    10326.499743, 10327.267152, 10328.664586, 10329.177573, 10330.336249,
    10332.108130, 10331.487272, 10333.817405, 10333.728320, 10333.580760,
    10332.629362, 10335.394395, 10334.982777, 10333.785442, 10334.088685,
    10334.324378, 10335.238896, 10336.807160, 10338.244858, 10340.300324,
    10339.225347, 10340.392666, 10338.469568, 10339.587353, 10342.096957,
    10342.941466, 10342.949180, 10344.407444, 10346.499768, 10347.691480,
    10350.271971, 10349.692431, 10349.853035, 10348.474217, 10349.363637,
    10347.937784, 10346.552636, 10348.192539, 10348.965919, 10351.911155,
    10354.671415, 10358.005254, 10358.137154, 10356.735321, 10358.357534,
    10359.862793, 10359.023597, 10361.180424, 10362.442563, 10363.606794,
    10363.936808, 10364.959228, 10363.663708, 10363.897863, 10364.832631,
    10362.706694, 10362.908092, 10360.090736, 10359.631867, 10359.927980,
    10359.439355, 10358.217278, 10356.292562, 10355.205520, 10357.147767,
    10356.734789, 10357.082817, 10358.894032, 10356.123883, 10357.964607,
    10358.208417, 10357.679754, 10357.170365, 10358.172223, 10359.114635,
    10357.767072, 10354.991447, 10353.848874, 10352.764443, 10350.244787,
    10350.842902, 10349.170700, 10349.832807, 10348.222939, 10348.945698,
    10348.145354, 10348.135101, 10346.641028, 10345.233653, 10344.660663,
    10341.145197, 10337.827240, 10336.933192, 10335.363838, 10330.181272,
    10329.009621, 10329.418135, 10330.573762, 10328.720627, 10329.224092,
    10330.469408, 10327.208957, 10324.145784, 10321.272533, 10320.073867,
    10318.971982, 10318.703916, 10317.743708, 10317.610414, 10314.545069,
    10311.676828, 10311.231096, 10310.098467, 10309.816295, 10308.097762,
    10307.251677, 10305.750456, 10303.628959, 10300.179545, 10299.921724,
    10296.759140, 10293.810074, 10292.548301, 10291.404214, 10291.113346,
    10290.889598, 10290.728850, 10288.403201, 10286.991585, 10285.705848,
    10282.325192, 10281.390016, 10280.558876, 10279.084918, 10278.484570,
    10275.756170, 10272.485118, 10271.657775, 10269.459213, 10265.220326,
    10262.738064, 10258.976023, 10255.476511, 10253.701581, 10252.089007,
    10249.889393, 10247.875380, 10246.779350, 10244.338800, 10245.044562,
    10239.900589, 10237.303447, 10235.648966, 10233.424399, 10232.124141,
    10228.762652, 10226.386092, 10222.748142, 10218.648341, 10216.309304,
    10214.176397, 10212.239414, 10208.292341, 10205.369826, 10202.687933,
    10200.967169, 10200.889689, 10199.440394, 10196.690039, 10191.974988,
    10188.328195, 10184.232020, 10181.176081, 10176.911477, 10174.431368,
    10172.911704, 10170.106064, 10166.091161, 10163.109269, 10158.207390,
    10154.388256, 10153.061522, 10148.268592, 10146.743082, 10141.050095,
    10137.209893, 10134.414508, 10131.146178, 10125.984807, 10125.573397,
    10122.389616, 10120.210357, 10116.814966, 10113.712998, 10109.435072,
    10103.339726, 10099.842922, 10098.829441, 10097.268575, 10093.732823,
    10089.780318, 10086.879568, 10082.817253, 10078.368515, 10074.277946,
    10070.528374, 10064.221306, 10058.374736, 10054.404155, 10048.627362,
    10047.608810, 10046.781771, 10041.816035, 10039.396097, 10034.367073,
    10031.175135, 10028.288954, 10022.115721, 10016.405811, 10011.851387,
    10007.680493, 10003.160764, 9997.596272,  9992.472429,  9989.197161,
    9986.959263,  9982.847977,  9978.391012,  9973.608350,  9967.807588,
    9964.600370,  9961.006335,  9956.334950,  9950.646992,  9947.545474,
    9943.345956,  9939.526552,  9935.358944,  9930.153833,  9923.263318,
    9918.311341,  9915.200572,  9911.712045,  9909.989877,  9906.399795,
    9901.044047,  9896.134097,  9893.059278,  9888.196974,  9884.460681,
    9877.571139,  9874.023834,  9868.020531,  9862.503038,  9858.150204,
    9854.902079,  9849.191516,  9843.954709,  9839.168372,  9834.110329,
    9828.795704,  9822.542244,  9818.193697,  9812.160922,  9809.421142,
    9807.008405,  9802.110163,  9796.952968,  9793.642654,  9787.902531,
    9782.645574,  9775.764713,  9770.123924,  9764.966256,  9758.188157,
    9753.340790,  9746.862653,  9740.916982,  9733.406697,  9726.487033,
    9721.509595,  9716.304045,  9711.573198,  9703.850145,  9698.110732,
    9694.256028,  9686.684215,  9682.463754,  9675.925467,  9670.624508,
    9665.811568,  9659.405166,  9655.601927,  9651.523950,  9645.132199,
    9639.286382,  9631.913182,  9628.554020,  9621.490705,  9615.693276,
    9607.695287,  9601.013686,  9594.223470,  9588.011244,  9580.991586,
    9573.887495,  9568.737434,  9562.730585,  9555.238498,  9548.368858,
    9540.741843,  9533.074586,  9525.371533,  9518.984220,  9512.498087,
    9507.940288,  9499.828949,  9493.726331,  9488.187118,  9481.170355,
    9476.106654,  9469.542583,  9463.567667,  9457.482671,  9450.626550,
    9446.381910,  9440.601420,  9434.702816,  9427.361752,  9422.650278,
    9415.105647,  9408.868462,  9401.879135,  9395.505714,  9389.053344,
    9384.517132,  9376.496037,  9371.130212,  9364.974311,  9356.752783,
    9347.898269,  9341.738856,  9332.869868,  9324.724203,  9317.266490,
    9311.119436,  9303.589037,  9297.373563,  9291.748843,  9284.064084,
    9275.740626,  9268.773550,  9261.786716,  9254.131374,  9245.845409,
    9238.915922,  9231.321689,  9223.100255,  9216.234687,  9208.708279,
    9203.150945,  9196.216451,  9189.275773,  9180.392081,  9171.607940,
    9166.147920,  9159.318435,  9150.553176,  9144.459966,  9137.039374,
    9130.934241,  9124.146542,  9115.433931,  9107.462236,  9100.834619,
    9092.920991,  9085.709163,  9077.248761,  9070.796590,  9063.059614,
    9057.292032,  9050.842398,  9043.746568,  9034.772482,  9025.291900,
    9016.600400,  9008.658856,  9000.165439,  8991.152124,  8981.649731,
    8973.575498,  8965.598015,  8957.083943,  8949.320848,  8941.642138,
    8933.416592,  8924.676356,  8915.451488,  8908.897412,  8901.120198,
    8893.436526,  8883.350185,  8875.972870,  8868.049730,  8860.855907,
    8853.109820,  8846.083956,  8835.402976,  8826.215267,  8817.209017,
    8808.376322,  8800.327545,  8791.172032,  8782.203930,  8773.414880,
    8763.568956,  8754.566212,  8746.364240,  8737.083543,  8726.785277,
    8719.194196,  8711.111821,  8702.565695,  8694.801841,  8687.779573,
    8678.413697,  8670.481817,  8660.871160,  8653.313957,  8644.063516,
    8636.240832,  8627.350406,  8618.658646,  8610.761001,  8601.204107,
    8592.487507,  8583.364573,  8575.061083,  8564.535211,  8554.304546,
    8545.554931,  8536.413381,  8526.306226,  8516.481673,  8508.118279,
    8501.141263,  8490.712616,  8480.587403,  8471.939624,  8461.134668,
    8452.435318,  8443.956317,  8435.686245,  8426.433514,  8416.253535,
    8406.376594,  8396.200853,  8386.331845,  8377.929929,  8369.743855,
    8359.418509,  8349.412724,  8338.544657,  8328.029694,  8319.017047,
    8308.516676,  8299.518923,  8291.364154,  8281.683052,  8270.563000,
    8260.398397,  8248.829984,  8239.398829,  8229.685450,  8219.707066,
    8210.631135,  8201.260040,  8190.463164,  8179.467057,  8169.430232,
    8160.303889,  8149.183067,  8140.744227,  8132.562493,  8121.206066,
    8110.830854,  8101.956106,  8091.662587,  8081.162781,  8072.169906,
    8063.471315,  8055.052033,  8043.510726,  8032.963562,  8022.234352,
    8014.149006,  8003.505065,  7993.811204,  7983.336592,  7973.244894,
    7961.283702,  7949.787480,  7937.622170,  7928.164697,  7917.378986,
    7907.004871,  7895.913512,  7886.362835,  7875.502203,  7863.959460,
    7851.774600,  7841.739193,  7831.538534,  7820.633018,  7810.710613,
    7800.073804,  7790.955602,  7780.535524,  7769.433865,  7759.327315,
    7748.528034,  7737.619515,  7725.524221,  7714.479699,  7703.347440,
    7691.593798,  7682.501479,  7672.141575,  7661.125839,  7648.416142,
    7637.871533,  7627.228518,  7614.348426,  7603.105585,  7592.880547,
    7582.550241,  7570.518944,  7560.615559,  7548.995944,  7537.352514,
    7525.688738,  7514.538856,  7503.877908,  7493.680779,  7481.280408,
    7469.437591,  7458.652986,  7447.292103,  7435.912910,  7422.422077,
    7411.652305,  7400.317709,  7386.885047,  7374.601634,  7361.846287,
    7351.251228,  7340.099542,  7328.943083,  7318.302309,  7306.596350,
    7294.920076,  7282.757590,  7271.169539,  7260.642994,  7250.606403,
    7236.410490,  7224.951513,  7213.011680,  7201.131171,  7189.820225,
    7179.561108,  7168.255268,  7155.454984,  7143.784955,  7132.678462,
    7121.599423,  7109.534484,  7096.541261,  7084.691663,  7071.405720,
    7059.281382,  7048.763432,  7037.754276,  7025.278351,  7013.421861,
    7001.653817,  6988.472662,  6976.451743,  6963.539337,  6951.277882,
    6940.629721,  6928.033708,  6915.579632,  6902.769120,  6890.611660,
    6877.102200,  6863.793616,  6851.662305,  6839.174460,  6827.331703,
    6814.632112,  6803.081016,  6791.150992,  6778.865655,  6767.708120,
    6755.670669,  6741.833697,  6729.692466,  6717.703735,  6704.411500,
    6691.337833,  6678.955475,  6667.230083,  6654.202862,  6641.388960,
    6629.738266,  6615.836743,  6603.156582,  6590.679870,  6579.351949,
    6567.204671,  6555.236964,  6541.540823,  6529.532332,  6516.753663,
    6502.778469,  6488.618676,  6475.230207,  6463.515837,  6452.446890,
    6439.638864,  6427.533442,  6415.158244,  6401.128240,  6387.869910,
    6374.878223,  6361.210714,  6349.230631,  6337.455620,  6323.095551,
    6310.457309,  6296.679477,  6283.209767,  6270.495729,  6257.578381,
    6244.930257,  6232.079884,  6219.040030,  6206.281668,  6192.876853,
    6181.145127,  6166.897716,  6153.911260,  6140.303749,  6126.113107,
    6112.731528,  6100.117894,  6086.877674,  6071.699445,  6058.736583,
    6045.178057,  6031.955403,  6019.949657,  6006.858271,  5994.529085,
    5980.691775,  5966.768332,  5954.099692,  5941.286352,  5927.895689,
    5913.961944,  5900.400276,  5886.752922,  5873.467143,  5861.406784,
    5846.989988,  5833.418746,  5819.775168,  5805.190854,  5791.903104,
    5776.792710,  5764.315211,  5750.850376,  5736.456327,  5722.485472,
    5707.621381,  5693.643134,  5680.073899,  5666.894788,  5652.794823,
    5639.546247,  5625.816993,  5610.780963,  5595.794869,  5580.859777,
    5566.402865,  5553.252125,  5539.213998,  5523.916378,  5510.394565,
    5496.441166,  5483.348627,  5469.805309,  5456.260046,  5441.874469,
    5427.536350,  5413.246920,  5398.169599,  5382.768471,  5367.898997,
    5354.368016,  5338.780422,  5324.570553,  5311.667605,  5297.517861,
    5283.018589,  5269.428608,  5255.465503,  5241.151683,  5226.919238,
    5213.175911,  5197.852212,  5183.488185,  5169.626985,  5154.613608,
    5140.547620,  5126.161650,  5112.286442,  5095.661602,  5081.689281,
    5068.212938,  5053.998098,  5039.891380,  5026.291384,  5011.167197,
    4997.407664,  4982.141561,  4968.248595,  4953.264928,  4938.049642,
    4923.809474,  4910.097489,  4896.093696,  4883.003897,  4868.802288,
    4854.341701,  4840.031634,  4825.474413,  4811.470041,  4797.206762,
    4782.700939,  4768.359365,  4753.394451,  4737.844918,  4722.522726,
    4708.194713,  4694.033898,  4679.259689,  4664.680056,  4650.673543,
    4635.285596,  4620.131846,  4605.586554,  4590.086737,  4574.835851,
    4560.204664,  4545.017909,  4530.070659,  4514.213209,  4499.015799,
    4484.824041,  4470.450470,  4455.529190,  4440.847095,  4425.641476,
    4411.446961,  4396.707877,  4381.831734,  4365.707606,  4349.526795,
    4334.787684,  4319.925733,  4304.577910,  4290.629967,  4275.782937,
    4261.198447,  4245.756494,  4232.088634,  4216.783678,  4202.140933,
    4186.291369,  4170.770291,  4156.660560,  4141.693268,  4126.648930,
    4112.262111,  4095.591585,  4080.757107,  4065.486975,  4050.169430,
    4034.810310,  4019.775641,  4004.329823,  3988.858102,  3973.364381,
    3959.645405,  3945.457355,  3929.755507,  3914.766257,  3898.672780,
    3882.605722,  3867.276615,  3850.523840,  3834.549728,  3818.962890,
    3802.687568,  3787.876318,  3773.045542,  3757.847700,  3742.656021,
    3727.121987,  3710.570773,  3695.151803,  3679.762470,  3664.403447,
    3649.769379,  3634.091300,  3618.120780,  3602.567010,  3586.720367,
    3571.288985,  3556.252579,  3541.247725,  3525.248721,  3509.338386,
    3494.197675,  3478.764582,  3463.737451,  3448.077628,  3433.857905,
    3417.274781,  3400.828987,  3384.516508,  3367.996085,  3351.955301,
    3336.371923,  3320.552581,  3304.848249,  3289.254287,  3273.768025,
    3259.053058,  3243.071866,  3226.893345,  3210.532267,  3193.671071,
    3176.671692,  3161.853008,  3146.134268,  3130.225877,  3114.468941,
    3097.547501,  3082.144841,  3067.201764,  3051.715350,  3035.718378,
    3020.216334,  3004.211506,  2988.058471,  2972.414180,  2956.930818,
    2941.602744,  2925.457043,  2909.505019,  2893.739793,  2877.833102,
    2861.155996,  2845.031040,  2829.431051,  2812.103938,  2795.369500,
    2780.150689,  2763.834130,  2747.747783,  2731.565060,  2716.555369,
    2701.397891,  2685.787440,  2670.065224,  2654.553022,  2637.991555,
    2621.688874,  2606.880313,  2590.686252,  2575.980179,  2559.271102,
    2542.838637,  2527.907114,  2512.236038,  2496.484490,  2480.351758,
    2464.168391,  2448.245992,  2431.349869,  2415.064270,  2398.748311,
    2383.014725,  2366.923274,  2350.799490,  2334.950202,  2319.060958,
    2302.833640,  2286.893100,  2271.226408,  2255.519863,  2238.277928,
    2221.685048,  2204.214567,  2187.708470,  2171.819917,  2155.327059,
    2139.156914,  2122.701793,  2105.980685,  2089.602124,  2074.435553,
    2058.353701,  2042.585571,  2027.704019,  2011.314797,  1994.967964,
    1979.248251,  1962.664350,  1947.014845,  1930.796127,  1914.913588,
    1898.480490,  1882.688727,  1866.926605,  1849.752335,  1833.550391,
    1817.984216,  1801.871345,  1785.531156,  1768.406784,  1752.257954,
    1735.893503,  1719.613095,  1704.836824,  1689.210509,  1672.217148,
    1656.197877,  1639.972580,  1623.554866,  1606.676135,  1590.489731,
    1574.117546,  1556.733661,  1540.913189,  1524.897574,  1508.420681,
    1491.511410,  1475.029715,  1458.677639,  1442.728512,  1426.331897,
    1410.895622,  1394.438988,  1377.571169,  1360.867396,  1344.596769,
    1328.189285,  1311.655967,  1294.460678,  1278.004605,  1260.891233,
    1244.245265,  1227.501740,  1211.211089,  1195.080227,  1178.832948,
    1163.017355,  1147.611545,  1131.519437,  1115.049799,  1098.760792,
    1082.645867,  1065.896165,  1049.349405,  1032.199373,  1016.340766,
    999.584494,   984.100206,   966.912351,   950.492153,   933.746829,
    917.749025,   901.409430,   885.011457,   869.084455,   852.297804,
    836.528037,   819.637145,   803.770326,   787.315248,   770.307081,
    754.332029,   739.077645,   722.182494,   706.058340,   688.865299,
    673.232645,   656.769047,   640.802673,   624.285944,   608.272339,
    591.971904,   576.166077,   560.829700,   544.162553,   527.506701,
    510.864215,   494.489458,   478.118311,   461.753039,   446.149410,
    429.762254,   414.390163,   397.728292,   380.848779,   364.763224,
    348.435114,   332.128514,   315.348766,   298.124937,   281.967372,
    264.845959,   248.294813,   231.793466,   215.096248,   198.216814,
    182.147185,   165.622855,   148.915523,   132.525304,   115.950594,
    99.932924,    83.231165,    66.127920,    49.614941,    32.938633,
    15.869887,    -1.085671};

std::vector<float> STATE_2 = {
    0.000000,    0.001285,    0.009334,    0.009158,    0.026591,
    0.056836,    0.084668,    0.129912,    0.211259,    0.288974,
    0.358540,    0.436830,    0.573581,    0.752734,    0.980517,
    1.193906,    1.500945,    1.872836,    2.315831,    2.886220,
    3.542453,    4.230408,    4.946722,    5.823866,    6.726683,
    7.882787,    9.473309,    11.175225,   12.984380,   14.797913,
    16.807823,   19.012562,   21.408426,   23.756143,   26.404149,
    29.725725,   32.547268,   35.786658,   39.295436,   43.059380,
    47.356121,   51.262313,   55.842655,   61.071811,   65.953163,
    70.638131,   75.280286,   80.033213,   85.049042,   90.126583,
    95.246009,   100.028791,  105.745552,  111.786405,  117.373155,
    122.696713,  128.131691,  133.655297,  139.438396,  145.060659,
    151.492136,  157.288353,  163.062717,  169.198069,  174.650590,
    180.251685,  185.772263,  191.812325,  197.296538,  203.066391,
    208.465905,  214.748338,  220.169261,  226.024203,  232.056904,
    237.815370,  242.665116,  247.500739,  252.733910,  258.107956,
    263.382198,  268.546996,  274.888990,  279.926739,  285.036569,
    290.415170,  295.154164,  299.939080,  305.190407,  309.759339,
    314.781375,  319.324753,  324.516625,  329.184239,  333.795022,
    338.338270,  343.027948,  347.839053,  352.298032,  356.640921,
    361.313762,  365.372981,  369.756378,  374.654859,  377.965244,
    382.072751,  385.992371,  390.183637,  394.384380,  398.580797,
    403.453550,  407.318315,  410.466616,  414.566954,  418.374227,
    422.597291,  425.790244,  429.187868,  432.530149,  435.811175,
    439.732531,  443.764686,  447.649629,  451.862635,  455.652262,
    458.559975,  461.836771,  465.446689,  469.115190,  472.103317,
    475.659305,  479.491076,  482.838750,  486.214502,  489.606948,
    492.271079,  495.477087,  498.440919,  501.417251,  504.397006,
    507.371796,  511.327693,  514.690648,  517.494541,  520.271175,
    523.518088,  526.941624,  530.268945,  533.498333,  536.628466,
    539.404824,  541.844959,  544.990022,  547.756923,  550.680395,
    553.743284,  556.669319,  558.425617,  560.389534,  562.802784,
    564.584093,  566.559944,  568.187206,  568.962187,  570.525630,
    572.025935,  572.935153,  573.559146,  574.984486,  575.281558,
    575.602258,  576.214410,  576.289766,  576.946977,  576.792258,
    576.970591,  576.099450,  575.893100,  573.848954,  573.936446,
    572.712201,  570.825024,  569.984227,  568.183262,  566.606900,
    564.689221,  563.297438,  561.562312,  560.636080,  558.780512,
    556.914605,  554.481776,  552.662214,  550.286121,  548.254241,
    545.980872,  543.207126,  540.835703,  538.274488,  535.834502,
    533.515518,  531.608709,  528.354703,  524.731539,  522.232692,
    519.622149,  516.333417,  512.719431,  509.697169,  506.647702,
    503.583755,  500.814482,  498.625847,  496.095794,  492.960809,
    490.470037,  487.392338,  484.979532,  481.994023,  479.390812,
    475.946995,  474.458933,  472.065399,  470.057730,  467.200129,
    464.175283,  461.618961,  459.509618,  456.902197,  453.845024,
    451.307230,  448.954264,  446.784084,  445.416273,  441.686120,
    439.521231,  437.570565,  436.455759,  434.552572,  431.613177,
    429.301919,  428.534166,  425.401678,  422.309987,  420.224121,
    417.806302,  416.690006,  414.867380,  412.720109,  411.569503,
    410.383844,  408.204443,  406.084960,  404.355836,  402.673097,
    400.390716,  399.196006,  398.364811,  395.909458,  392.944053,
    390.504145,  389.223637,  387.375179,  386.666043,  384.364323,
    383.256277,  382.264875,  381.723988,  380.267102,  377.634469,
    376.945942,  376.385301,  375.950110,  374.621110,  373.149966,
    371.894521,  371.188305,  370.657522,  368.928142,  367.464628,
    367.287654,  366.588876,  366.103107,  366.512419,  366.369873,
    365.374208,  364.288321,  363.475466,  362.921968,  361.916041,
    360.147143,  358.731890,  358.004167,  355.808186,  354.728686,
    353.985865,  353.207427,  352.402882,  351.936346,  350.007159,
    349.227915,  349.165900,  347.981123,  347.198412,  347.155959,
    345.640579,  344.934202,  343.174670,  342.259268,  341.771400,
    340.593252,  340.970231,  340.600811,  341.009832,  339.573936,
    339.008007,  337.046064,  337.116529,  335.750794,  336.023459,
    335.592274,  334.142211,  333.243172,  333.235979,  332.563617,
    332.404733,  331.975569,  331.676744,  332.257755,  331.769331,
    331.806691,  330.820024,  331.547966,  331.204497,  330.634523,
    329.096485,  327.814918,  325.247642,  324.178939,  324.510364,
    322.292429,  322.346036,  321.033768,  321.947432,  319.883075,
    318.561624,  317.936607,  316.793501,  316.347716,  316.945422,
    315.768553,  315.701402,  314.306915,  313.658041,  312.522067,
    311.336224,  310.505730,  309.614040,  309.466832,  308.420919,
    308.542607,  308.550829,  306.856951,  305.996339,  305.915238,
    304.950693,  303.173773,  302.667937,  301.728676,  299.988685,
    299.540941,  299.891615,  300.170316,  299.569198,  298.564894,
    298.011634,  297.471155,  296.946624,  296.853379,  296.751795,
    297.058700,  297.747551,  296.719174,  294.934858,  293.702743,
    292.989514,  291.928410,  289.300018,  288.150749,  286.705668,
    286.251936,  284.620991,  284.008776,  283.081298,  282.289634,
    281.629178,  280.671580,  280.716528,  280.845185,  279.350583,
    279.768565,  279.825766,  278.269391,  276.507928,  275.421325,
    274.966706,  274.241579,  273.270949,  273.804964,  271.843704,
    271.039909,  271.315991,  270.422247,  269.754528,  267.994375,
    269.157111,  268.655718,  268.807583,  267.811926,  267.954118,
    266.953784,  264.900683,  264.524559,  262.615619,  261.503609,
    261.581170,  259.657153,  260.329794,  260.293864,  259.158402,
    257.902097,  257.434228,  257.701665,  256.857661,  256.336179,
    256.117708,  256.183399,  256.063926,  255.323393,  253.107654,
    251.342483,  250.910717,  249.901428,  249.726504,  247.140839,
    248.259933,  246.869436,  247.280574,  247.071202,  247.668000,
    246.712042,  245.703825,  246.036526,  246.227554,  245.363995,
    244.454162,  245.828999,  245.133349,  244.851732,  244.957773,
    245.425246,  244.825581,  244.644956,  243.918592,  242.690354,
    242.411922,  241.605089,  240.783911,  241.371111,  239.482382,
    239.090797,  236.775201,  236.477089,  236.629013,  235.771609,
    234.460175,  233.687080,  232.461647,  230.822896,  230.722104,
    230.611371,  230.014112,  229.931338,  228.882552,  228.871995,
    227.411983,  227.031666,  226.203096,  224.963135,  225.289239,
    224.636952,  224.543155,  223.018950,  220.177866,  221.496847,
    221.777067,  222.077365,  222.889309,  221.226162,  220.226552,
    219.354954,  218.606478,  218.469309,  218.407168,  217.921572,
    217.046549,  216.310837,  215.211276,  214.774750,  213.461328,
    212.337947,  211.895198,  211.085693,  210.441166,  209.953371,
    209.112385,  207.947928,  205.484578,  204.340304,  204.929583,
    203.591026,  202.999130,  202.596619,  202.879535,  202.784559,
    201.832990,  202.126917,  202.557519,  202.095141,  200.299216,
    200.339524,  200.548593,  197.843888,  197.570963,  196.476402,
    196.167009,  195.044206,  195.750242,  197.119952,  196.515379,
    196.673689,  197.541783,  196.472244,  195.169497,  194.695355,
    194.472206,  195.005324,  194.673402,  194.587307,  194.208251,
    192.514389,  192.751843,  192.156178,  193.421141,  192.722303,
    191.789185,  189.590511,  189.389348,  189.458254,  189.248956,
    189.314579,  188.046312,  187.138192,  185.506042,  186.399632,
    184.839336,  184.743251,  183.337920,  182.860501,  182.712187,
    183.943168,  182.159597,  182.418813,  181.348545,  179.589883,
    178.812096,  178.409962,  176.740173,  176.060038,  173.062298,
    172.245946,  172.375720,  170.132674,  169.492759,  169.801189,
    168.270087,  168.849446,  168.659850,  171.587967,  169.737130,
    168.392156,  167.520069,  165.995957,  167.163851,  167.528530,
    166.600939,  167.231189,  164.900813,  165.894720,  165.002069,
    164.575496,  164.030732,  164.486568,  163.653357,  164.958291,
    165.463818,  164.118629,  162.732417,  161.870106,  160.382681,
    161.110070,  161.095987,  159.837983,  158.552015,  159.484663,
    159.106833,  159.764181,  159.693133,  157.825645,  157.674938,
    157.428203,  157.093205,  155.551941,  154.026314,  154.783597,
    154.823605,  154.767314,  154.623610,  154.400932,  153.538535,
    153.224266,  153.419910,  152.948866,  150.156227,  149.779848,
    149.362697,  147.767320,  146.229781,  145.322493,  145.577099,
    144.040612,  143.145562,  140.554026,  138.694240,  137.519223,
    136.982943,  137.618764,  135.303114,  136.031057,  134.955280,
    133.949069,  135.328388,  134.276864,  133.878233,  134.087580,
    133.698481,  133.338705,  131.265297,  129.937041,  132.222387,
    132.009638,  130.074898,  130.052541,  128.882230,  130.164340,
    128.443651,  126.878531,  123.708422,  123.158341,  122.694503,
    122.900586,  121.375699,  121.194003,  121.081049,  120.443924,
    121.094552,  122.347705,  121.790234,  119.562472,  119.341597,
    119.798343,  119.696998,  119.674387,  117.945844,  119.394246,
    117.836628,  115.881732,  114.158360,  113.250559,  111.911029,
    111.368161,  110.968857,  112.499052,  112.222780,  110.876276,
    110.337802,  109.951731,  110.308558,  110.753568,  110.679531,
    110.126504,  110.334725,  110.646823,  110.453067,  109.191013,
    108.751348,  107.869590,  107.185488,  106.083278,  103.994725,
    104.018997,  104.187373,  103.279297,  102.589048,  100.288593,
    100.136953,  99.551746,   98.567987,   99.649574,   98.991838,
    99.161262,   99.489186,   97.527419,   100.773261,  101.497846,
    101.725885,  100.273544,  99.714494,   98.151602,   97.498033,
    96.465561,   96.923701,   95.084455,   97.260293,   97.617129,
    95.680303,   95.926270,   95.119571,   95.187116,   92.988518,
    91.160512,   90.912427,   90.896389,   89.246807,   91.029331,
    91.038933,   90.029369,   88.081580,   88.361548,   89.468738,
    90.098717,   90.286407,   91.927768,   89.944594,   87.718216,
    87.755471,   88.024531,   89.136169,   87.906873,   87.006180,
    85.791973,   84.911994,   83.723681,   84.131067,   82.887731,
    83.868004,   83.776610,   82.703218,   80.717226,   78.521656,
    76.767138,   76.046074,   75.034531,   75.014534,   74.655406,
    73.356023,   71.191427,   71.995426,   73.037511,   73.669350,
    73.292528,   71.984747,   71.705406,   71.121694,   70.258789,
    67.883993,   66.631714,   64.536329,   65.453991,   64.733258,
    63.765083,   62.571454,   62.438092,   65.187417,   64.892041,
    63.692196,   61.651879,   60.113405,   60.300504,   60.190245,
    59.806091,   59.806868,   60.164297,   59.578439,   60.668319,
    60.123355,   59.978136,   58.930747,   57.052632,   55.048484,
    55.479497,   54.343220,   54.943610,   57.793374,   57.608656,
    57.809434,   56.457481,   56.856107,   56.327255,   54.942837,
    53.408040,   52.375315,   51.810215,   49.770410,   51.480589,
    52.819645,   51.250870,   50.204469,   48.355536,   47.695486,
    46.856252,   47.779620,   47.761140,   44.955213,   43.422713,
    43.072434,   41.255151,   41.293249,   41.122175,   40.758897,
    40.219607,   40.156153,   38.616265,   38.277823,   36.490133,
    35.293286,   35.927590,   35.039817,   35.325702,   34.763372,
    33.419002,   33.289273,   34.283741,   35.026838,   34.247310,
    33.351626,   35.582028,   35.525770,   35.941938,   33.572075,
    33.788856,   34.472018,   32.346749,   31.505877,   31.863520,
    32.032042,   31.373355,   29.315760,   27.259735,   26.500229,
    27.594765,   29.112447,   27.771487,   25.096597,   24.426485,
    24.315513,   23.433586,   23.130793,   22.076041,   21.618450,
    21.714931,   19.738228,   20.386025,   18.924030,   17.457329,
    15.338367,   16.513686,   14.908223,   12.670007,   11.802977,
    10.909895,   10.640387,   10.957052,   11.163153,   11.911747,
    9.930310,    9.958048,    7.308747,    7.379996,    8.670356,
    8.491305,    7.599304,    8.000732,    8.953308,    9.108629,
    10.476593,   9.071835,    8.354237,    6.325030,    6.327598,
    4.326536,    2.420340,    3.201645,    3.220027,    5.135722,
    6.851807,    9.031943,    8.381364,    6.420749,    7.145582,
    7.758086,    6.324170,    7.537882,    7.950441,    8.274170,
    7.870911,    8.085943,    6.286610,    5.868452,    6.076430,
    3.624814,    3.264593,    0.296082,    -0.540227,   -0.691181,
    -1.512489,   -2.942787,   -4.939818,   -6.149871,   -4.686906,
    -5.299130,   -5.225799,   -3.873667,   -6.530087,   -5.103266,
    -5.092136,   -5.744951,   -6.356821,   -5.631620,   -4.968467,
    -6.305358,   -8.842976,   -9.889515,   -10.850973,  -13.027582,
    -12.430323,  -13.812711,  -13.122139,  -14.415073,  -13.638860,
    -14.197384,  -14.046444,  -15.180748,  -16.202780,  -16.465117,
    -19.270198,  -21.824254,  -22.197239,  -23.137747,  -27.185686,
    -27.634474,  -26.686770,  -25.102029,  -26.162082,  -25.136583,
    -23.481689,  -25.775924,  -27.831902,  -29.661402,  -29.978876,
    -30.193660,  -29.667667,  -29.746300,  -29.094084,  -30.997521,
    -32.672266,  -32.188897,  -32.304599,  -31.668109,  -32.286611,
    -32.121692,  -32.521079,  -33.440488,  -35.482066,  -34.688276,
    -36.429989,  -37.932871,  -37.921254,  -37.797515,  -36.925218,
    -36.006851,  -35.047636,  -35.985962,  -36.097802,  -36.088998,
    -37.893408,  -37.518234,  -37.053480,  -37.150984,  -36.478563,
    -37.665280,  -39.286397,  -38.734450,  -39.380341,  -41.775951,
    -42.576187,  -44.460312,  -46.060080,  -46.111102,  -46.010155,
    -46.412730,  -46.634645,  -46.043772,  -46.627627,  -44.452797,
    -47.409623,  -48.070055,  -47.885671,  -48.192819,  -47.680164,
    -48.963949,  -49.351023,  -50.816570,  -52.638358,  -52.874795,
    -52.916894,  -52.778512,  -54.382197,  -55.046061,  -55.474913,
    -55.048225,  -53.194517,  -52.571282,  -53.086825,  -55.289779,
    -56.500860,  -58.063824,  -58.674521,  -60.311687,  -60.347262,
    -59.537590,  -59.857090,  -61.211089,  -61.624223,  -63.687135,
    -64.747821,  -63.605462,  -65.495586,  -64.488385,  -67.120035,
    -68.065583,  -68.069179,  -68.473903,  -70.504432,  -68.344629,
    -68.639200,  -68.043748,  -68.511333,  -68.703199,  -69.903731,
    -72.645304,  -73.049751,  -71.275319,  -70.011727,  -70.487934,
    -71.306131,  -71.181023,  -72.060434,  -73.245387,  -74.080713,
    -74.589898,  -77.300900,  -79.534505,  -80.071385,  -82.154881,
    -80.039101,  -77.799443,  -79.204517,  -78.352182,  -79.780475,
    -79.567054,  -79.084225,  -81.462501,  -83.369697,  -84.215270,
    -84.696587,  -85.459405,  -87.101673,  -88.309791,  -87.870297,
    -86.529692,  -86.841541,  -87.436735,  -88.290835,  -89.999246,
    -89.400475,  -89.143252,  -89.819695,  -91.353722,  -90.591319,
    -90.793106,  -90.650215,  -90.804606,  -91.848269,  -94.322192,
    -95.039612,  -94.128692,  -93.559477,  -91.459817,  -91.028150,
    -92.134469,  -92.817756,  -91.880580,  -92.513059,  -92.143226,
    -94.516512,  -93.917117,  -95.460044,  -96.534174,  -96.560756,
    -95.618065,  -96.831833,  -97.595585,  -97.940626,  -98.505223,
    -99.270730,  -100.825177, -100.676309, -101.986936, -100.393455,
    -98.547215,  -98.900438,  -99.462815,  -98.398339,  -99.465950,
    -100.079999, -102.083496, -102.951509, -103.370148, -105.179342,
    -105.256793, -106.741904, -107.718696, -110.022756, -111.746783,
    -111.729706, -111.901780, -111.647420, -113.991514, -114.543032,
    -113.432486, -115.571784, -114.734531, -115.923742, -115.998105,
    -115.636887, -116.660788, -115.386797, -114.374561, -115.390779,
    -115.898728, -117.713496, -115.984598, -117.510782, -117.890022,
    -120.164461, -121.228865, -122.351941, -122.935098, -124.196167,
    -125.489497, -125.041838, -125.340412, -126.913125, -127.895609,
    -129.501945, -131.092815, -132.664383, -133.041796, -133.484564,
    -132.228768, -134.083021, -134.133970, -133.683098, -134.517574,
    -133.622904, -134.044853, -133.934191, -133.912263, -134.551749,
    -132.895436, -132.606665, -132.419200, -133.482101, -132.223980,
    -133.452228, -133.505100, -134.202467, -134.338890, -134.532490,
    -133.047441, -134.621609, -133.840537, -133.758416, -135.466983,
    -137.675814, -137.478511, -139.633722, -141.097962, -141.918791,
    -141.570703, -142.425106, -142.106207, -141.272992, -142.243212,
    -143.736225, -144.004219, -144.274060, -145.109777, -146.464251,
    -146.596761, -147.294970, -148.512115, -148.511027, -149.075402,
    -147.904795, -147.951990, -147.995001, -149.717902, -151.302783,
    -149.949329, -149.811617, -151.351999, -150.522509, -150.859439,
    -150.036246, -149.819205, -151.273545, -152.039802, -151.610564,
    -152.302346, -152.359064, -153.492215, -152.843441, -153.320237,
    -152.065517, -151.427949, -151.361390, -152.922924, -154.879134,
    -156.093323, -156.617651, -157.600981, -159.003921, -160.788918,
    -161.279223, -161.664471, -162.497906, -162.648897, -162.714022,
    -163.244318, -164.200265, -165.544992, -164.525299, -164.585701,
    -164.554831, -166.605262, -166.240786, -166.351339, -165.816671,
    -165.767320, -165.085139, -167.590026, -168.726244, -169.667992,
    -170.426800, -170.476476, -171.478458, -172.283815, -172.904580,
    -174.419769, -175.154958, -175.166300, -176.105924, -177.897461,
    -177.281107, -177.097722, -177.312850, -176.833435, -175.712433,
    -176.648511, -176.306273, -177.423897, -176.720195, -177.498065,
    -177.007290, -177.449211, -177.699680, -177.245840, -178.238370,
    -178.468114, -179.037859, -178.873448, -180.637789, -182.093791,
    -182.217812, -182.671356, -183.944971, -184.932844, -184.617278,
    -183.095922, -184.605436, -185.805629, -185.683267, -187.431223,
    -187.296648, -186.965487, -186.452821, -186.799419, -187.935800,
    -188.772521, -189.840103, -190.606162, -190.069287, -189.349980,
    -190.500646, -191.336951, -192.894021, -194.096946, -193.955165,
    -195.101740, -194.904719, -193.971166, -194.379674, -196.020959,
    -196.782364, -198.736705, -198.775333, -199.049405, -199.538177,
    -199.221357, -199.160401, -200.332065, -201.639163, -202.070860,
    -201.691333, -203.046521, -202.027451, -200.801722, -202.358562,
    -203.015449, -202.343234, -202.913215, -203.640394, -203.031339,
    -202.173837, -201.087517, -202.735605, -203.471269, -204.339593,
    -202.880347, -203.674851, -203.616649, -204.231801, -204.491844,
    -206.363815, -207.777648, -209.730282, -209.271998, -209.971830,
    -210.288361, -211.212534, -210.766111, -211.461697, -212.725011,
    -214.506897, -214.367098, -214.365885, -214.969093, -214.694189,
    -215.039004, -214.046863, -214.203513, -214.941251, -214.787863,
    -215.233036, -215.754618, -217.287453, -217.860774, -218.488146,
    -219.632093, -218.425646, -218.343429, -218.825856, -220.761403,
    -220.758502, -220.833259, -222.843170, -223.371398, -222.993235,
    -222.707846, -223.900456, -223.205353, -224.011797, -224.811028,
    -225.600080, -225.914625, -225.788189, -225.253752, -226.640447,
    -227.500071, -227.410300, -227.815873, -228.219412, -230.440860,
    -230.233031, -230.513136, -232.602074, -233.631230, -235.036138,
    -234.518761, -234.489201, -234.455753, -233.966219, -234.406619,
    -234.802013, -235.602043, -235.874438, -235.208917, -234.126047,
    -236.678669, -236.780343, -237.289504, -237.726391, -237.649206,
    -236.651626, -236.581422, -237.804965, -238.007997, -237.708620,
    -237.385607, -237.920773, -239.242664, -239.530153, -241.051919,
    -241.518333, -240.568899, -240.062841, -240.837587, -241.047507,
    -241.168310, -242.507711, -242.797917, -243.848727, -244.300070,
    -243.330178, -244.070783, -244.662478, -245.542161, -245.824887,
    -247.268655, -248.494242, -248.657930, -249.119627, -249.001139,
    -249.622792, -249.222754, -249.154581, -249.389667, -248.631155,
    -248.649575, -250.225235, -250.280361, -250.194474, -251.237048,
    -252.056581, -252.247471, -251.855253, -252.597602, -253.128988,
    -252.628790, -254.090999, -254.447879, -254.611832, -253.765871,
    -253.646554, -253.367564, -254.591854, -254.311936, -254.702151,
    -256.116496, -257.649427, -258.466540, -257.800612, -256.583137,
    -256.901388, -256.594508, -256.523606, -257.887070, -258.539406,
    -258.937225, -259.906183, -259.377338, -258.676912, -260.235191,
    -260.251373, -261.251501, -261.952315, -261.972038, -262.161412,
    -262.105476, -262.220349, -262.490767, -262.503444, -263.071621,
    -262.164875, -263.461873, -263.624239, -264.316375, -265.492033,
    -265.928574, -265.680071, -265.976110, -267.943301, -267.928749,
    -268.425631, -268.611348, -267.727742, -267.803572, -267.208644,
    -267.933695, -268.709568, -268.369069, -268.156844, -268.446004,
    -269.194339, -269.594679, -270.053605, -270.180776, -269.233497,
    -270.352854, -270.703523, -271.102563, -272.303708, -272.341683,
    -273.957227, -273.237194, -273.387280, -274.335412, -274.885809,
    -276.192744, -276.690408, -276.813393, -276.587508, -277.161347,
    -276.974232, -277.203309, -278.556468, -279.825956, -281.012607,
    -281.746816, -281.319866, -281.667896, -283.095170, -282.935721,
    -283.148189, -282.599784, -282.450026, -282.298996, -282.875756,
    -283.390350, -283.843195, -284.963092, -286.329750, -287.192981,
    -286.863675, -288.323312, -288.541378, -287.610320, -287.779272,
    -288.240930, -287.893612, -287.872556, -288.150312, -288.343837,
    -288.100802, -289.231408, -289.493028, -289.304441, -290.115827,
    -290.076890, -290.310696, -290.088286, -292.255680, -292.056418,
    -291.424299, -291.443634, -291.362330, -290.836498, -291.643091,
    -291.237367, -292.145845, -291.832141, -292.468817, -293.285295,
    -293.227828, -292.706801, -292.446893, -291.393523, -291.328037,
    -291.484591, -291.501697, -291.728629, -291.464681, -291.427941,
    -291.598636, -291.617982, -292.174520, -293.221133, -294.039474,
    -293.968343, -293.748898, -294.063611, -294.196767, -293.823819,
    -294.656782, -295.260920, -295.316416, -296.195775, -296.832069,
    -296.908865, -297.461868, -297.787935, -298.892206, -299.389940,
    -298.995658, -298.764097, -299.009494, -299.035908, -299.511939,
    -299.092184, -299.151582, -299.324028, -300.572548, -301.834388,
    -301.806217, -301.880345, -302.369912, -301.625108, -301.675598,
    -301.491820, -302.053446, -301.054054, -301.498435, -301.351712,
    -302.253576, -302.843004, -302.186223, -302.287017, -302.448064,
    -302.029276, -303.602300, -303.535600, -303.844955, -304.183473,
    -304.545320, -304.611659, -305.029399, -305.454828, -305.884297,
    -304.755600, -304.058622, -304.691216, -304.684652, -305.634373,
    -306.533423, -306.764236, -308.222662, -308.963141, -309.343597,
    -310.308164, -309.970722, -309.653614, -309.658685, -309.653544,
    -309.941530, -311.102023, -311.244391, -311.352535, -311.426773,
    -310.864107, -311.218529, -311.813833, -312.027365, -312.485542,
    -312.566589, -312.297562, -312.003288, -312.576297, -313.053560,
    -312.845371, -312.892182, -312.580609, -312.822714, -311.802714,
    -312.859039, -313.765766, -314.529860, -315.451355, -315.928339,
    -315.991098, -316.252783, -316.403320, -316.449539, -316.396423,
    -315.669630, -316.057588, -316.603290, -317.289866, -318.389736,
    -319.577682, -318.835222, -318.888964, -319.101601, -319.172651,
    -320.249752, -319.974858, -319.302565, -319.114972, -319.371694,
    -319.187546, -319.441001, -319.812922, -319.729177, -319.503571,
    -319.144683, -319.501845, -319.678024, -319.683700, -319.808559,
    -320.596457, -320.880924, -320.698064, -322.017524, -322.784840,
    -322.211142, -322.602009, -322.778933, -323.031171, -322.253251,
    -321.619386, -321.391608, -321.263342, -320.952478, -321.558499,
    -321.921302, -320.972893, -321.249685, -320.223080, -320.960827,
    -321.437071, -320.593790, -320.411920, -320.302162, -320.524237,
    -320.782502, -320.805110, -321.671359, -321.982739, -322.310135,
    -322.120391, -322.243883, -322.389829, -322.290921, -322.226698,
    -322.455542, -322.426914, -322.158505, -321.929129, -323.038120,
    -323.552801, -324.815029, -325.204482, -325.044284, -325.410441,
    -325.483885, -325.800226, -326.336870, -326.559176, -325.719059,
    -325.692646, -325.391333, -324.324079, -324.591818, -324.813769,
    -324.482687, -324.908966, -324.510050, -324.613809, -324.420640,
    -324.708929, -324.430457, -324.131223, -325.065333, -325.128874,
    -324.636074, -324.628957, -324.817844, -325.681959, -325.674411,
    -325.852450, -325.950925, -324.737226, -324.291056, -325.043010,
    -324.927785, -324.992943, -325.222181, -325.844889, -325.848424,
    -326.011597, -327.048450, -326.698231, -326.524385, -326.753998,
    -327.351883, -327.561103, -327.650311, -327.384871, -327.513066,
    -326.801188, -326.992347, -327.534487, -327.918647, -327.914702,
    -328.027873, -328.245666, -329.031547, -329.153021, -329.840675,
    -330.102468, -330.440090, -330.373058, -330.166290, -330.063501,
    -329.585683, -328.761400, -328.552482, -328.675324, -328.636421,
    -328.445531, -328.809724, -328.986826, -329.682354, -329.236025,
    -329.579518, -328.806897, -329.533043, -329.572098, -329.891179,
    -329.550721, -329.514270, -329.527930, -329.130276, -329.488496,
    -328.952313, -329.402879, -328.950579, -329.019733, -329.566817,
    -329.200792, -328.216117, -328.681486, -328.464026, -329.180330,
    -328.521162, -328.599883, -328.243488, -328.373658, -328.062413,
    -328.007603, -327.523530, -326.642905, -326.940952, -327.221548,
    -327.483231, -327.505252, -327.523176, -327.535140, -326.884251,
    -326.930530, -326.093007, -326.397692, -326.884027, -326.667874,
    -326.667872, -326.649084, -327.042026, -327.811071, -327.633561,
    -328.297996, -328.449528, -328.553331, -328.824147, -329.245876,
    -328.952202, -329.060335, -329.324068, -329.304673, -329.445286,
    -329.097234, -329.351791, -329.948235, -330.015680, -330.222411,
    -330.764101, -331.192685};

std::vector<float> STATE_3 = {
    0.000000,   0.000032,   0.000424,   0.000410,   0.002037,   0.005487,
    0.009191,   0.016063,   0.029872,   0.044236,   0.058009,   0.074559,
    0.105636,   0.148544,   0.205625,   0.260549,   0.343157,   0.446283,
    0.572358,   0.739197,   0.934593,   1.141358,   1.358102,   1.628820,
    1.907891,   2.273302,   2.788394,   3.339380,   3.924160,   4.505112,
    5.151125,   5.860788,   6.631797,   7.374939,   8.218982,   9.301215,
    10.180513,  11.202454,  12.309030,  13.493297,  14.858346,  16.052451,
    17.480476,  19.128660,  20.615428,  22.000695,  23.344276,  24.705011,
    26.140170,  27.571834,  28.992407,  30.258228,  31.854672,  33.543743,
    35.028112,  36.384136,  37.756427,  39.135978,  40.587428,  41.949944,
    43.592997,  44.963635,  46.299577,  47.746489,  48.906990,  50.101360,
    51.242256,  52.557652,  53.637568,  54.804657,  55.809376,  57.128243,
    58.096495,  59.209961,  60.369123,  61.402609,  62.073634,  62.726477,
    63.516623,  64.344714,  65.119378,  65.838029,  66.986021,  67.621340,
    68.271650,  69.010635,  69.495060,  69.987519,  70.645872,  71.035329,
    71.587568,  71.949567,  72.548160,  72.938607,  73.300319,  73.629834,
    74.008035,  74.424616,  74.701267,  74.929158,  75.276427,  75.387144,
    75.617255,  76.036021,  75.851916,  75.969879,  76.015246,  76.161490,
    76.308528,  76.451177,  76.844346,  76.852787,  76.592891,  76.694205,
    76.683937,  76.829457,  76.586788,  76.425256,  76.246050,  76.047290,
    76.091804,  76.176931,  76.205396,  76.356037,  76.345499,  76.005308,
    75.809529,  75.742001,  75.697647,  75.399683,  75.319656,  75.344258,
    75.187372,  75.043922,  74.909398,  74.505051,  74.310891,  74.029809,
    73.758658,  73.493858,  73.232154,  73.342192,  73.228466,  72.907827,
    72.582991,  72.440070,  72.365862,  72.257066,  72.113686,  71.935875,
    71.629109,  71.202363,  71.047171,  70.753484,  70.523829,  70.350598,
    70.129433,  69.475029,  68.910490,  68.524513,  67.909463,  67.378652,
    66.727423,  65.769691,  65.124678,  64.468115,  63.602811,  62.647035,
    62.008760,  60.960543,  59.940757,  59.049014,  57.973226,  57.135114,
    56.009078,  55.028626,  53.674090,  52.593453,  50.845837,  49.927948,
    48.536740,  46.923660,  45.731997,  44.203590,  42.787740,  41.270737,
    39.978737,  38.582510,  37.514846,  36.119649,  34.746671,  33.187381,
    31.886553,  30.401950,  29.073810,  27.680205,  26.125556,  24.750407,
    23.330002,  21.981482,  20.703419,  19.603369,  18.020149,  16.328495,
    15.088867,  13.830650,  12.342372,  10.760302,  9.429064,   8.112542,
    6.815220,   5.652336,   4.728301,   3.693881,   2.452607,   1.475421,
    0.297044,   -0.610690,  -1.715594,  -2.656895,  -3.894911,  -4.378499,
    -5.191614,  -5.845247,  -6.804461,  -7.808276,  -8.618137,  -9.245726,
    -10.047819, -11.003085, -11.746289, -12.406489, -12.986000, -13.254660,
    -14.401608, -14.941840, -15.391872, -15.520951, -15.942402, -16.743426,
    -17.294606, -17.258345, -18.106966, -18.924467, -19.350594, -19.892875,
    -19.938363, -20.247105, -20.671465, -20.715225, -20.771273, -21.197847,
    -21.594041, -21.836868, -22.057811, -22.498838, -22.524925, -22.414602,
    -22.913634, -23.594051, -24.065258, -24.094141, -24.334848, -24.145047,
    -24.554282, -24.509537, -24.422013, -24.167673, -24.260591, -24.791399,
    -24.585357, -24.335349, -24.043108, -24.090536, -24.190228, -24.207403,
    -24.018894, -23.768312, -23.970585, -24.069666, -23.685841, -23.504302,
    -23.246509, -22.658854, -22.288532, -22.244126, -22.234284, -22.122537,
    -21.915903, -21.882300, -22.134610, -22.249970, -22.106098, -22.513915,
    -22.496642, -22.353803, -22.226952, -22.112235, -21.873277, -22.185689,
    -22.062283, -21.673003, -21.710816, -21.597584, -21.209677, -21.379769,
    -21.244183, -21.504921, -21.445153, -21.226643, -21.270322, -20.731703,
    -20.482241, -19.946375, -20.110364, -19.945996, -20.306688, -19.900695,
    -20.039304, -19.562704, -19.358192, -19.538476, -19.509353, -19.147303,
    -19.040737, -18.744167, -18.554203, -18.319055, -17.759322, -17.609928,
    -17.266730, -17.312845, -16.716984, -16.532876, -16.436904, -16.704698,
    -16.871587, -17.516099, -17.588226, -17.135479, -17.644434, -17.294516,
    -17.461858, -16.793767, -17.251686, -17.423262, -17.331225, -17.434628,
    -17.275361, -16.728898, -16.856187, -16.566159, -16.777860, -16.706809,
    -16.819220, -16.948176, -16.941851, -16.958527, -16.696519, -16.775447,
    -16.416319, -16.106331, -16.438576, -16.453040, -16.175765, -16.234004,
    -16.594912, -16.473798, -16.517011, -16.858820, -16.711051, -16.267506,
    -15.859165, -15.787433, -15.867800, -15.778012, -15.685124, -15.588009,
    -15.331447, -15.082800, -14.686062, -14.153926, -14.273833, -14.674153,
    -14.860514, -14.849372, -14.968514, -15.671457, -15.808195, -16.052985,
    -15.922521, -16.234670, -16.160068, -16.204741, -16.197796, -16.141921,
    -16.198195, -15.878553, -15.533587, -15.802027, -15.350310, -15.041938,
    -15.342668, -15.714460, -15.826963, -15.701056, -15.678649, -15.748457,
    -15.254355, -15.702505, -15.709486, -15.312557, -15.360461, -15.322956,
    -15.694627, -14.966444, -14.874115, -14.539249, -14.639718, -14.312852,
    -14.419301, -14.917404, -14.779151, -15.216622, -15.347932, -15.031992,
    -15.470373, -14.929636, -14.663952, -14.814364, -15.007148, -14.901522,
    -14.522931, -14.566999, -14.489649, -14.300445, -14.008526, -13.791301,
    -13.810358, -14.380657, -14.771821, -14.657096, -14.760458, -14.549908,
    -15.244701, -14.541248, -14.789315, -14.359090, -14.168924, -13.680878,
    -13.782550, -13.901861, -13.517556, -13.193409, -13.269645, -13.361759,
    -12.597884, -12.622471, -12.491786, -12.218594, -11.815366, -11.818693,
    -11.665272, -11.718779, -11.958943, -11.839473, -11.919811, -12.004012,
    -11.560027, -12.050125, -11.971259, -12.613279, -12.488934, -12.198639,
    -12.291172, -12.551742, -12.606150, -12.828675, -13.201584, -12.992460,
    -12.790962, -12.775149, -12.567260, -12.724462, -12.490517, -12.802916,
    -12.705763, -12.778033, -13.002777, -12.637747, -12.645375, -12.444034,
    -12.781304, -13.604666, -12.857135, -12.511985, -12.165781, -11.634738,
    -12.039091, -12.187779, -12.285822, -12.335995, -12.156655, -11.952614,
    -11.910723, -12.015227, -12.065687, -12.251251, -12.185428, -12.448719,
    -12.636029, -12.565340, -12.633107, -12.637920, -12.584039, -12.663227,
    -12.861885, -13.542502, -13.717175, -13.240385, -13.493351, -13.462401,
    -13.361217, -13.005635, -12.797999, -12.914536, -12.563188, -12.167304,
    -12.112718, -12.557782, -12.307934, -11.999656, -12.786638, -12.649634,
    -12.822411, -12.698374, -12.880800, -12.375990, -11.632461, -11.641042,
    -11.364212, -10.827159, -11.024653, -11.305653, -11.271575, -11.144284,
    -10.736595, -10.659978, -10.492875, -10.438437, -10.876641, -10.584508,
    -10.609350, -9.938017,  -10.013523, -10.175219, -10.807099, -10.680271,
    -10.454831, -10.337631, -10.119825, -10.404849, -10.549882, -10.962927,
    -10.423843, -10.812377, -10.646160, -10.972595, -10.945968, -10.796783,
    -10.134651, -10.612077, -10.316753, -10.524062, -10.984894, -11.070348,
    -11.013744, -11.432190, -11.472770, -12.379171, -12.452979, -12.171639,
    -12.782786, -12.783076, -12.428762, -12.768897, -12.313545, -12.154228,
    -10.832137, -11.321675, -11.612912, -11.721885, -12.072622, -11.410226,
    -11.060547, -11.200601, -10.755540, -11.425815, -10.840568, -10.971671,
    -10.926049, -10.925474, -10.550773, -10.665067, -9.977746,  -9.602183,
    -9.925647,  -10.258403, -10.389044, -10.750982, -10.278005, -10.091118,
    -10.372841, -10.659754, -10.111734, -10.063965, -9.630022,  -9.476548,
    -9.997656,  -9.867094,  -9.774880,  -9.717393,  -10.112018, -10.493418,
    -10.014080, -9.811901,  -9.649509,  -9.522838,  -9.428065,  -9.574262,
    -9.512774,  -9.261773,  -9.264748,  -10.135741, -10.086979, -10.054375,
    -10.462934, -10.842227, -10.978772, -10.678316, -11.053190, -11.181214,
    -11.941182, -12.413332, -12.620610, -12.585182, -12.112153, -12.751559,
    -12.240973, -12.414367, -12.558508, -11.807974, -11.980394, -11.905467,
    -11.604609, -11.533143, -11.452048, -12.013218, -12.285275, -11.201075,
    -11.071213, -11.587653, -11.379374, -11.604224, -10.907878, -11.347336,
    -11.720408, -12.686632, -12.655129, -12.591969, -12.279497, -12.620098,
    -12.452096, -12.261531, -12.270523, -11.797840, -11.108702, -11.109464,
    -11.734753, -11.597953, -11.210339, -11.038648, -10.840729, -11.284378,
    -10.531834, -10.917348, -11.444201, -11.874635, -11.992070, -12.268737,
    -12.242351, -12.162777, -11.363228, -11.254086, -11.547159, -11.532620,
    -11.461367, -11.113667, -10.739495, -10.566397, -10.575636, -10.300061,
    -9.990798,  -9.876461,  -10.163712, -10.138092, -10.278254, -10.341890,
    -10.560672, -11.144170, -10.926747, -10.659506, -10.799761, -10.855946,
    -11.513156, -11.354611, -11.361145, -11.516581, -10.896853, -10.939065,
    -10.671203, -10.349083, -10.889129, -9.471889,  -9.023875,  -8.769901,
    -9.148991,  -9.186981,  -9.599609,  -9.664516,  -9.869886,  -9.514058,
    -10.023904, -9.022928,  -8.720813,  -9.281976,  -9.016473,  -9.149539,
    -8.953227,  -9.607924,  -10.111812, -10.015528, -9.834278,  -10.267220,
    -9.408759,  -9.229266,  -9.434208,  -9.986132,  -9.694752,  -9.099510,
    -8.693832,  -8.461116,  -7.689204,  -8.286983,  -8.964524,  -8.782996,
    -8.518188,  -7.943279,  -8.254424,  -8.436883,  -8.733157,  -8.898921,
    -9.176875,  -8.852981,  -9.152367,  -8.614722,  -8.487838,  -8.730507,
    -9.309872,  -9.956769,  -10.426658, -10.501339, -10.683239, -10.490986,
    -10.429133, -10.720009, -11.328962, -10.816535, -10.224664, -9.797255,
    -9.754988,  -10.061607, -9.977949,  -10.009662, -10.145176, -10.843472,
    -11.108989, -11.684790, -11.123210, -11.184746, -11.337653, -11.572001,
    -11.405521, -10.164281, -10.084698, -10.344795, -10.914293, -11.285498,
    -11.004550, -10.840040, -10.781019, -10.579171, -10.247739, -10.275211,
    -9.675589,  -9.698467,  -9.571448,  -9.784135,  -10.303465, -10.860212,
    -10.496012, -10.724651, -10.299653, -9.041532,  -8.941564,  -8.699322,
    -9.042195,  -8.724094,  -8.758736,  -9.112637,  -9.516151,  -9.724389,
    -9.753883,  -10.334237, -9.501575,  -8.823247,  -9.244876,  -9.463299,
    -9.977716,  -10.037978, -10.164111, -9.628828,  -9.455721,  -10.328112,
    -10.708042, -10.638822, -11.119428, -10.897298, -10.757533, -10.692248,
    -10.693997, -10.517792, -10.896939, -10.819762, -11.285919, -11.522438,
    -11.069844, -11.194836, -10.878646, -10.885525, -11.184690, -11.024093,
    -10.446146, -9.972995,  -10.078020, -10.224512, -9.199383,  -9.048430,
    -8.723654,  -9.446681,  -9.189012,  -8.761775,  -9.392633,  -9.531445,
    -9.219521,  -8.984144,  -9.062471,  -9.662403,  -10.250532, -10.342880,
    -9.740253,  -8.990673,  -9.323988,  -10.149845, -10.210651, -10.061250,
    -10.202912, -10.125380, -10.330465, -10.308430, -10.079632, -10.630301,
    -10.189341, -10.545503, -10.896766, -11.485351, -10.831158, -11.228966,
    -11.855931, -11.958470, -12.068833, -11.943971, -11.602266, -11.308291,
    -10.816967, -11.355621, -11.132949, -11.915418, -11.666011, -10.965426,
    -10.827370, -10.958476, -10.603501, -10.049082, -9.803132,  -9.108357,
    -9.463327,  -9.554723,  -10.134838, -9.944400,  -10.506706, -11.023027,
    -10.524805, -10.321164, -9.411901,  -8.594273,  -7.618418,  -7.719246,
    -8.308029,  -7.881681,  -7.505305,  -7.901148,  -7.299609,  -7.008877,
    -6.756795,  -6.781256,  -6.574073,  -7.123960,  -7.147128,  -6.935742,
    -7.722764,  -7.713073,  -8.678836,  -8.829286,  -8.720661,  -8.864720,
    -9.233795,  -9.807878,  -10.076968, -9.341551,  -9.395824,  -9.192743,
    -8.515300,  -9.349370,  -8.641072,  -8.475359,  -8.561003,  -8.629736,
    -8.197236,  -7.796022,  -8.150151,  -8.946626,  -9.170677,  -9.358727,
    -9.997621,  -9.587386,  -9.925036,  -9.481268,  -9.787454,  -9.314236,
    -9.348939,  -9.117717,  -9.371386,  -9.578332,  -9.497351,  -10.368646,
    -11.129792, -11.061177, -11.206049, -12.510120, -12.444043, -11.857035,
    -11.042806, -11.232721, -10.639272, -9.821578,  -10.495801, -11.068331,
    -11.545475, -11.448332, -11.314609, -10.906400, -10.731900, -10.287389,
    -10.806778, -11.230947, -10.840240, -10.680837, -10.243160, -10.282924,
    -10.029013, -9.990850,  -10.147843, -10.721495, -10.224241, -10.684341,
    -11.046537, -10.835671, -10.586824, -10.062734, -9.531216,  -8.994361,
    -9.177058,  -9.047306,  -8.874869,  -9.383639,  -9.067924,  -8.724616,
    -8.597962,  -8.185791,  -8.476480,  -8.924163,  -8.550941,  -8.632582,
    -9.366940,  -9.491037,  -10.018094, -10.428973, -10.253074, -10.023641,
    -9.986771,  -9.883039,  -9.477334,  -9.518460,  -8.527311,  -9.473481,
    -9.543312,  -9.295951,  -9.237004,  -8.872624,  -9.186768,  -9.159748,
    -9.536486,  -10.039386, -9.940100,  -9.770005,  -9.535605,  -9.956969,
    -10.019044, -9.992085,  -9.645733,  -8.772275,  -8.375237,  -8.411424,
    -9.077880,  -9.361001,  -9.770403,  -9.816087,  -10.244726, -10.066496,
    -9.575550,  -9.515995,  -9.844364,  -9.814794,  -10.402649, -10.604768,
    -9.979363,  -10.499534, -9.926633,  -10.725056, -10.878096, -10.676068,
    -10.627804, -11.188351, -10.171600, -10.091579, -9.680264,  -9.674121,
    -9.564998,  -9.835069,  -10.676304, -10.627932, -9.765754,  -9.110704,
    -9.118433,  -9.253893,  -9.034106,  -9.194030,  -9.465211,  -9.600592,
    -9.611494,  -10.445478, -11.085366, -11.078865, -11.650784, -10.641848,
    -9.605456,  -9.951251,  -9.446507,  -9.803956,  -9.540864,  -9.181955,
    -9.899560,  -10.427606, -10.548826, -10.531579, -10.619912, -11.035431,
    -11.280847, -10.905612, -10.200456, -10.126356, -10.159588, -10.289007,
    -10.735444, -10.310850, -10.021903, -10.087468, -10.472469, -9.991607,
    -9.880258,  -9.642112,  -9.519575,  -9.731840,  -10.474928, -10.547345,
    -10.009551, -9.609580,  -8.644833,  -8.321807,  -8.579892,  -8.674975,
    -8.162369,  -8.246261,  -7.953806,  -8.692506,  -8.305873,  -8.727509,
    -8.965974,  -8.808289,  -8.291128,  -8.589963,  -8.714945,  -8.681029,
    -8.729841,  -8.852864,  -9.268582,  -9.039636,  -9.360694,  -8.589868,
    -7.738942,  -7.726332,  -7.792164,  -7.248464,  -7.512142,  -7.601299,
    -8.208320,  -8.379421,  -8.379297,  -8.899121,  -8.761707,  -9.153203,
    -9.347312,  -10.034075, -10.491117, -10.288594, -10.160583, -9.875516,
    -10.567373, -10.576029, -9.963057,  -10.576701, -10.065904, -10.322376,
    -10.157199, -9.832239,  -10.031269, -9.367367,  -8.813750,  -9.028948,
    -9.050075,  -9.559443,  -8.734266,  -9.141633,  -9.112527,  -9.792604,
    -10.007519, -10.240354, -10.266954, -10.546537, -10.832955, -10.463040,
    -10.379068, -10.773082, -10.939036, -11.335153, -11.718081, -12.086633,
    -12.001786, -11.942961, -11.250122, -11.733122, -11.532815, -11.148615,
    -11.252205, -10.707310, -10.664902, -10.424137, -10.221052, -10.269075,
    -9.457772,  -9.172978,  -8.931388,  -9.161842,  -8.520129,  -8.820097,
    -8.674969,  -8.773539,  -8.660523,  -8.570998,  -7.855480,  -8.297218,
    -7.850044,  -7.672576,  -8.167987,  -8.841191,  -8.602125,  -9.247164,
    -9.621780,  -9.748813,  -9.436398,  -9.579451,  -9.281116,  -8.796051,
    -8.994380,  -9.384481,  -9.309239,  -9.236094,  -9.375904,  -9.707071,
    -9.575138,  -9.657194,  -9.931752,  -9.745665,  -9.774491,  -9.154046,
    -9.000552,  -8.848363,  -9.327152,  -9.745382,  -9.057112,  -8.836292,
    -9.247060,  -8.764024,  -8.726157,  -8.255214,  -8.019723,  -8.413586,
    -8.542801,  -8.222591,  -8.327530,  -8.193050,  -8.463574,  -8.062758,
    -8.090300,  -7.469891,  -7.091842,  -6.934368,  -7.388603,  -7.981920,
    -8.286693,  -8.327821,  -8.539807,  -8.904727,  -9.405680,  -9.413166,
    -9.381230,  -9.517474,  -9.395996,  -9.244683,  -9.270133,  -9.454262,
    -9.780319,  -9.216194,  -9.066476,  -8.885430,  -9.485993,  -9.172365,
    -9.042219,  -8.673250,  -8.492645,  -8.078793,  -8.864364,  -9.123485,
    -9.305047,  -9.414812,  -9.257370,  -9.458951,  -9.583244,  -9.636191,
    -10.022584, -10.110102, -9.925328,  -10.091106, -10.572324, -10.144205,
    -9.885983,  -9.781597,  -9.419465,  -8.824206,  -9.009243,  -8.712842,
    -8.967844,  -8.537061,  -8.668311,  -8.322745,  -8.332386,  -8.270260,
    -7.945946,  -8.168511,  -8.101699,  -8.163268,  -7.949175,  -8.460270,
    -8.846517,  -8.727498,  -8.733918,  -9.046853,  -9.247094,  -8.956220,
    -8.219924,  -8.630674,  -8.918085,  -8.705603,  -9.196429,  -8.974177,
    -8.682573,  -8.328555,  -8.302445,  -8.572132,  -8.724732,  -8.960800,
    -9.079711,  -8.709216,  -8.277434,  -8.552930,  -8.705733,  -9.125182,
    -9.404369,  -9.175535,  -9.432711,  -9.182692,  -8.661949,  -8.652755,
    -9.104683,  -9.219164,  -9.777559,  -9.609205,  -9.532034,  -9.536584,
    -9.239829,  -9.044292,  -9.313303,  -9.627926,  -9.609342,  -9.287780,
    -9.620861,  -9.059950,  -8.432253,  -8.856728,  -8.936765,  -8.518337,
    -8.572204,  -8.683843,  -8.293759,  -7.818072,  -7.265719,  -7.746123,
    -7.876378,  -8.053802,  -7.357601,  -7.517120,  -7.354821,  -7.447331,
    -7.405332,  -7.966838,  -8.346542,  -8.920613,  -8.582478,  -8.683699,
    -8.639707,  -8.823743,  -8.491854,  -8.593182,  -8.904896,  -9.404683,
    -9.176584,  -9.004568,  -9.061769,  -8.789564,  -8.754168,  -8.219529,
    -8.124433,  -8.248391,  -8.036829,  -8.053031,  -8.097501,  -8.519259,
    -8.574358,  -8.648637,  -8.914682,  -8.296911,  -8.111053,  -8.139797,
    -8.711344,  -8.547395,  -8.415548,  -9.009746,  -9.038814,  -8.728428,
    -8.458534,  -8.746328,  -8.322902,  -8.468840,  -8.609352,  -8.743431,
    -8.697580,  -8.487697,  -8.129181,  -8.495704,  -8.658296,  -8.462857,
    -8.456287,  -8.449080,  -9.121746,  -8.873500,  -8.812339,  -9.428667,
    -9.637206,  -9.982345,  -9.602266,  -9.411692,  -9.223228,  -8.867751,
    -8.866634,  -8.848709,  -8.982418,  -8.916339,  -8.500795,  -7.936969,
    -8.743040,  -8.617600,  -8.646871,  -8.648569,  -8.458019,  -7.926883,
    -7.752435,  -8.064996,  -7.990132,  -7.728811,  -7.463537,  -7.524107,
    -7.877711,  -7.837928,  -8.260400,  -8.280365,  -7.770553,  -7.436056,
    -7.586722,  -7.523375,  -7.427890,  -7.789840,  -7.752716,  -8.000685,
    -8.019870,  -7.507279,  -7.643847,  -7.722183,  -7.906736,  -7.864629,
    -8.257438,  -8.561323,  -8.462468,  -8.476892,  -8.274107,  -8.351861,
    -8.046138,  -7.870220,  -7.810983,  -7.381335,  -7.250223,  -7.703835,
    -7.580419,  -7.406584,  -7.657945,  -7.821209,  -7.746362,  -7.454884,
    -7.593084,  -7.649818,  -7.319770,  -7.729661,  -7.718592,  -7.635592,
    -7.176524,  -6.997740,  -6.762595,  -7.093942,  -6.856651,  -6.874368,
    -7.274689,  -7.711866,  -7.873217,  -7.477023,  -6.882006,  -6.872341,
    -6.629112,  -6.478665,  -6.867359,  -6.982886,  -7.001086,  -7.232502,
    -6.899544,  -6.508655,  -6.969631,  -6.845380,  -7.091362,  -7.220828,
    -7.093205,  -7.031402,  -6.879030,  -6.793375,  -6.767481,  -6.645699,
    -6.733902,  -6.268964,  -6.636725,  -6.573358,  -6.709264,  -7.023423,
    -7.055344,  -6.830522,  -6.813513,  -7.421688,  -7.277494,  -7.327226,
    -7.259681,  -6.793566,  -6.694909,  -6.347293,  -6.499732,  -6.668324,
    -6.416339,  -6.217028,  -6.208917,  -6.372649,  -6.403201,  -6.455087,
    -6.381956,  -5.908442,  -6.216521,  -6.231419,  -6.264125,  -6.596136,
    -6.487017,  -6.969810,  -6.570276,  -6.503560,  -6.736490,  -6.816347,
    -7.177590,  -7.229484,  -7.140310,  -6.922356,  -7.007504,  -6.806530,
    -6.764932,  -7.144420,  -7.485528,  -7.789285,  -7.918190,  -7.610512,
    -7.598362,  -7.989981,  -7.780984,  -7.714958,  -7.365666,  -7.171964,
    -6.981408,  -7.066544,  -7.126843,  -7.162927,  -7.447755,  -7.819525,
    -7.996107,  -7.723483,  -8.124865,  -8.054503,  -7.555785,  -7.477698,
    -7.510517,  -7.240237,  -7.097003,  -7.068176,  -7.008394,  -6.786494,
    -7.082364,  -7.047777,  -6.845500,  -7.020906,  -6.875087,  -6.833976,
    -6.623048,  -7.309642,  -7.098477,  -6.729410,  -6.610829,  -6.456835,
    -6.139505,  -6.326318,  -6.056338,  -6.282803,  -6.048044,  -6.173033,
    -6.362916,  -6.222469,  -5.911318,  -5.703619,  -5.203118,  -5.081357,
    -5.044895,  -4.956974,  -4.949153,  -4.757932,  -4.655242,  -4.632034,
    -4.552669,  -4.675650,  -4.979578,  -5.192470,  -5.068796,  -4.891979,
    -4.918195,  -4.876035,  -4.645425,  -4.870031,  -5.004877,  -4.932059,
    -5.168654,  -5.309941,  -5.239384,  -5.348205,  -5.370137,  -5.682640,
    -5.762508,  -5.507348,  -5.317801,  -5.310138,  -5.220739,  -5.301127,
    -5.045068,  -4.972957,  -4.944464,  -5.318861,  -5.691240,  -5.574305,
    -5.497807,  -5.578078,  -5.195300,  -5.117050,  -4.952667,  -5.070072,
    -4.601599,  -4.681729,  -4.539339,  -4.791692,  -4.922503,  -4.584894,
    -4.536865,  -4.512263,  -4.271314,  -4.779632,  -4.665334,  -4.693784,
    -4.732607,  -4.779427,  -4.714878,  -4.782928,  -4.852582,  -4.922444,
    -4.408381,  -4.065355,  -4.225886,  -4.144426,  -4.422056,  -4.675549,
    -4.674440,  -5.132372,  -5.313294,  -5.356216,  -5.616742,  -5.385559,
    -5.166302,  -5.071611,  -4.974872,  -4.989545,  -5.330185,  -5.283767,
    -5.225420,  -5.155486,  -4.848714,  -4.890587,  -5.021746,  -5.007703,
    -5.085399,  -5.020629,  -4.826173,  -4.625911,  -4.753682,  -4.843264,
    -4.674872,  -4.604975,  -4.402381,  -4.410602,  -3.946752,  -4.267938,
    -4.527184,  -4.728249,  -4.984410,  -5.069574,  -4.998261,  -5.002663,
    -4.965422,  -4.889873,  -4.778593,  -4.417497,  -4.479972,  -4.600261,
    -4.770975,  -5.093034,  -5.442004,  -5.062648,  -4.988093,  -4.974345,
    -4.907913,  -5.218898,  -5.018541,  -4.673338,  -4.515823,  -4.527389,
    -4.373891,  -4.386888,  -4.443939,  -4.329543,  -4.164243,  -3.952197,
    -4.011856,  -4.002727,  -3.930016,  -3.903228,  -4.124860,  -4.154109,
    -4.008071,  -4.426500,  -4.630653,  -4.329568,  -4.394773,  -4.378765,
    -4.391216,  -4.018245,  -3.706111,  -3.551654,  -3.437294,  -3.256795,
    -3.422506,  -3.494177,  -3.074229,  -3.120251,  -2.678055,  -2.903840,
    -3.027625,  -2.655708,  -2.538054,  -2.449564,  -2.486804,  -2.536880,
    -2.497905,  -2.775107,  -2.839653,  -2.908982,  -2.783649,  -2.777782,
    -2.780421,  -2.691456,  -2.617124,  -2.653763,  -2.593445,  -2.444597,
    -2.313127,  -2.684547,  -2.826804,  -3.245918,  -3.330855,  -3.208682,
    -3.285605,  -3.251640,  -3.309132,  -3.447924,  -3.466586,  -3.087645,
    -3.020044,  -2.850917,  -2.398558,  -2.453826,  -2.490941,  -2.320576,
    -2.436582,  -2.241869,  -2.238753,  -2.124670,  -2.192742,  -2.047624,
    -1.897454,  -2.211256,  -2.193674,  -1.968397,  -1.928936,  -1.963501,
    -2.249895,  -2.205010,  -2.230357,  -2.225480,  -1.730056,  -1.530883,
    -1.783427,  -1.707000,  -1.699450,  -1.753393,  -1.953451,  -1.918252,
    -1.943401,  -2.294760,  -2.120907,  -2.016252,  -2.064412,  -2.249373,
    -2.285550,  -2.276176,  -2.134370,  -2.142401,  -1.836167,  -1.873315,
    -2.041006,  -2.146490,  -2.104885,  -2.107849,  -2.149877,  -2.403534,
    -2.404019,  -2.616197,  -2.665173,  -2.741587,  -2.665267,  -2.538125,
    -2.452240,  -2.227731,  -1.877873,  -1.764648,  -1.777588,  -1.729809,
    -1.626093,  -1.731869,  -1.765711,  -1.992767,  -1.788622,  -1.883619,
    -1.559511,  -1.801870,  -1.782786,  -1.868764,  -1.706525,  -1.660991,
    -1.635045,  -1.455790,  -1.562516,  -1.332818,  -1.476372,  -1.279650,
    -1.281584,  -1.462185,  -1.297987,  -0.905538,  -1.062616,  -0.961439,
    -1.211299,  -0.942182,  -0.954002,  -0.802906,  -0.836567,  -0.704549,
    -0.670882,  -0.477339,  -0.139138,  -0.247980,  -0.348262,  -0.439598,
    -0.439613,  -0.438096,  -0.434380,  -0.182883,  -0.196768,  0.120071,
    0.003900,   -0.178019,  -0.093869,  -0.092113,  -0.083366,  -0.228733,
    -0.512012,  -0.436067,  -0.676355,  -0.720370,  -0.745715,  -0.833035,
    -0.975151,  -0.847111,  -0.871706,  -0.954022,  -0.928934,  -0.964144,
    -0.815978,  -0.895905,  -1.102173,  -1.106786,  -1.163393,  -1.344187,
    -1.479310};

static const std::vector<float> PRED_STATE_3 = {
    0.000000,   0.000032,   0.000424,   0.000410,   0.002037,   0.005487,
    0.009191,   0.016063,   0.029872,   0.044236,   0.058009,   0.074559,
    0.105636,   0.148544,   0.205625,   0.260549,   0.343157,   0.446283,
    0.572358,   0.739197,   0.934593,   1.141358,   1.358102,   1.628820,
    1.907891,   2.273302,   2.788394,   3.339380,   3.924160,   4.505112,
    5.151125,   5.860788,   6.631797,   7.374939,   8.218982,   9.301215,
    10.180513,  11.202454,  12.309030,  13.493297,  14.858346,  16.052451,
    17.480476,  19.128660,  20.615428,  22.000695,  23.344276,  24.705011,
    26.140170,  27.571834,  28.992407,  30.258228,  31.854672,  33.543743,
    35.028112,  36.384136,  37.756427,  39.135978,  40.587428,  41.949944,
    43.592997,  44.963635,  46.299577,  47.746489,  48.906990,  50.101360,
    51.242256,  52.557652,  53.637568,  54.804657,  55.809376,  57.128243,
    58.096495,  59.209961,  60.369123,  61.402609,  62.073634,  62.726477,
    63.516623,  64.344714,  65.119378,  65.838029,  66.986021,  67.621340,
    68.271650,  69.010635,  69.495060,  69.987519,  70.645872,  71.035329,
    71.587568,  71.949567,  72.548160,  72.938607,  73.300319,  73.629834,
    74.008035,  74.424616,  74.701267,  74.929158,  75.276427,  75.387144,
    75.617255,  76.036021,  75.851916,  75.969879,  76.015246,  76.161490,
    76.308528,  76.451177,  76.844346,  76.852787,  76.592891,  76.694205,
    76.683937,  76.829457,  76.586788,  76.425256,  76.246050,  76.047290,
    76.091804,  76.176931,  76.205396,  76.356037,  76.345499,  76.005308,
    75.809529,  75.742001,  75.697647,  75.399683,  75.319656,  75.344258,
    75.187372,  75.043922,  74.909398,  74.505051,  74.310891,  74.029809,
    73.758658,  73.493858,  73.232154,  73.342192,  73.228466,  72.907827,
    72.582991,  72.440070,  72.365862,  72.257066,  72.113686,  71.935875,
    71.629109,  71.202363,  71.047171,  70.753484,  70.523829,  70.350598,
    70.129433,  69.475029,  68.910490,  68.524513,  67.909463,  67.378652,
    66.727423,  65.769691,  65.124678,  64.468115,  63.602811,  62.647035,
    62.008760,  60.960543,  59.940757,  59.049014,  57.973226,  57.135114,
    56.009078,  55.028626,  53.674090,  52.593453,  50.845837,  49.927948,
    48.536740,  46.923660,  45.731997,  44.203590,  42.787740,  41.270737,
    39.978737,  38.582510,  37.514846,  36.119649,  34.746671,  33.187381,
    31.886553,  30.401950,  29.073810,  27.680205,  26.125556,  24.750407,
    23.330002,  21.981482,  20.703419,  19.603369,  18.020149,  16.328495,
    15.088867,  13.830650,  12.342372,  10.760302,  9.429064,   8.112542,
    6.815220,   5.652336,   4.728301,   3.693881,   2.452607,   1.475421,
    0.297044,   -0.610690,  -1.715594,  -2.656895,  -3.894911,  -4.378499,
    -5.191614,  -5.845247,  -6.804461,  -7.808276,  -8.618137,  -9.245726,
    -10.047819, -11.003085, -11.746289, -12.406489, -12.986000, -13.254660,
    -14.401608, -14.941840, -15.391872, -15.520951, -15.942402, -16.743426,
    -17.294606, -17.258345, -18.106966, -18.924467, -19.350594, -19.892875,
    -19.938363, -20.247105, -20.671465, -20.715225, -20.771273, -21.197847,
    -21.594041, -21.836868, -22.057811, -22.498838, -22.524925, -22.414602,
    -22.913634, -23.594051, -24.065258, -24.094141, -24.334848, -24.145047,
    -24.554282, -24.509537, -24.422013, -24.167673, -24.260591, -24.791399,
    -24.585357, -24.335349, -24.043108, -24.090536, -24.190228, -24.207403,
    -24.018894, -23.768312, -23.970585, -24.069666, -23.685841, -23.504302,
    -23.246509, -22.658854, -22.288532, -22.244126, -22.234284, -22.122537,
    -21.915903, -21.882300, -22.134610, -22.249970, -22.106098, -22.513915,
    -22.496642, -22.353803, -22.226952, -22.112235, -21.873277, -22.185689,
    -22.062283, -21.673003, -21.710816, -21.597584, -21.209677, -21.379769,
    -21.244183, -21.504921, -21.445153, -21.226643, -21.270322, -20.731703,
    -20.482241, -19.946375, -20.110364, -19.945996, -20.306688, -19.900695,
    -20.039304, -19.562704, -19.358192, -19.538476, -19.509353, -19.147303,
    -19.040737, -18.744167, -18.554203, -18.319055, -17.759322, -17.609928,
    -17.266730, -17.312845, -16.716984, -16.532876, -16.436904, -16.704698,
    -16.871587, -17.516099, -17.588226, -17.135479, -17.644434, -17.294516,
    -17.461858, -16.793767, -17.251686, -17.423262, -17.331225, -17.434628,
    -17.275361, -16.728898, -16.856187, -16.566159, -16.777860, -16.706809,
    -16.819220, -16.948176, -16.941851, -16.958527, -16.696519, -16.775447,
    -16.416319, -16.106331, -16.438576, -16.453040, -16.175765, -16.234004,
    -16.594912, -16.473798, -16.517011, -16.858820, -16.711051, -16.267506,
    -15.859165, -15.787433, -15.867800, -15.778012, -15.685124, -15.588009,
    -15.331447, -15.082800, -14.686062, -14.153926, -14.273833, -14.674153,
    -14.860514, -14.849372, -14.968514, -15.671457, -15.808195, -16.052985,
    -15.922521, -16.234670, -16.160068, -16.204741, -16.197796, -16.141921,
    -16.198195, -15.878553, -15.533587, -15.802027, -15.350310, -15.041938,
    -15.342668, -15.714460, -15.826963, -15.701056, -15.678649, -15.748457,
    -15.254355, -15.702505, -15.709486, -15.312557, -15.360461, -15.322956,
    -15.694627, -14.966444, -14.874115, -14.539249, -14.639718, -14.312852,
    -14.419301, -14.917404, -14.779151, -15.216622, -15.347932, -15.031992,
    -15.470373, -14.929636, -14.663952, -14.814364, -15.007148, -14.901522,
    -14.522931, -14.566999, -14.489649, -14.300445, -14.008526, -13.791301,
    -13.810358, -14.380657, -14.771821, -14.657096, -14.760458, -14.549908,
    -15.244701, -14.541248, -14.789315, -14.359090, -14.168924, -13.680878,
    -13.782550, -13.901861, -13.517556, -13.193409, -13.269645, -13.361759,
    -12.597884, -12.622471, -12.491786, -12.218594, -11.815366, -11.818693,
    -11.665272, -11.718779, -11.958943, -11.839473, -11.919811, -12.004012,
    -11.560027, -12.050125, -11.971259, -12.613279, -12.488934, -12.198639,
    -12.291172, -12.551742, -12.606150, -12.828675, -13.201584, -12.992460,
    -12.790962, -12.775149, -12.567260, -12.724462, -12.490517, -12.802916,
    -12.705763, -12.778033, -13.002777, -12.637747, -12.645375, -12.444034,
    -12.781304, -13.604666, -12.857135, -12.511985, -12.165781, -11.634738,
    -12.039091, -12.187779, -12.285822, -12.335995, -12.156655, -11.952614,
    -11.910723, -12.015227, -12.065687, -12.251251, -12.185428, -12.448719,
    -12.636029, -12.565340, -12.633107, -12.637920, -12.584039, -12.663227,
    -12.861885, -13.542502, -13.717175, -13.240385, -13.493351, -13.462401,
    -13.361217, -13.005635, -12.797999, -12.914536, -12.563188, -12.167304,
    -12.112718, -12.557782, -12.307934, -11.999656, -12.786638, -12.649634,
    -12.822411, -12.698374, -12.880800, -12.375990, -11.632461, -11.641042,
    -11.364212, -10.827159, -11.024653, -11.305653, -11.271575, -11.144284,
    -10.736595, -10.659978, -10.492875, -10.438437, -10.876641, -10.584508,
    -10.609350, -9.938017,  -10.013523, -10.175219, -10.807099, -10.680271,
    -10.454831, -10.337631, -10.119825, -10.404849, -10.549882, -10.962927,
    -10.423843, -10.812377, -10.646160, -10.972595, -10.945968, -10.796783,
    -10.134651, -10.612077, -10.316753, -10.524062, -10.984894, -11.070348,
    -11.013744, -11.432190, -11.472770, -12.379171, -12.452979, -12.171639,
    -12.782786, -12.783076, -12.428762, -12.768897, -12.313545, -12.154228,
    -10.832137, -11.321675, -11.612912, -11.721885, -12.072622, -11.410226,
    -11.060547, -11.200601, -10.755540, -11.425815, -10.840568, -10.971671,
    -10.926049, -10.925474, -10.550773, -10.665067, -9.977746,  -9.602183,
    -9.925647,  -10.258403, -10.389044, -10.750982, -10.278005, -10.091118,
    -10.372841, -10.659754, -10.111734, -10.063965, -9.630022,  -9.476548,
    -9.997656,  -9.867094,  -9.774880,  -9.717393,  -10.112018, -10.493418,
    -10.014080, -9.811901,  -9.649509,  -9.522838,  -9.428065,  -9.574262,
    -9.512774,  -9.261773,  -9.264748,  -10.135741, -10.086979, -10.054375,
    -10.462934, -10.842227, -10.978772, -10.678316, -11.053190, -11.181214,
    -11.941182, -12.413332, -12.620610, -12.585182, -12.112153, -12.751559,
    -12.240973, -12.414367, -12.558508, -11.807974, -11.980394, -11.905467,
    -11.604609, -11.533143, -11.452048, -12.013218, -12.285275, -11.201075,
    -11.071213, -11.587653, -11.379374, -11.604224, -10.907878, -11.347336,
    -11.720408, -12.686632, -12.655129, -12.591969, -12.279497, -12.620098,
    -12.452096, -12.261531, -12.270523, -11.797840, -11.108702, -11.109464,
    -11.734753, -11.597953, -11.210339, -11.038648, -10.840729, -11.284378,
    -10.531834, -10.917348, -11.444201, -11.874635, -11.992070, -12.268737,
    -12.242351, -12.162777, -11.363228, -11.254086, -11.547159, -11.532620,
    -11.461367, -11.113667, -10.739495, -10.566397, -10.575636, -10.300061,
    -9.990798,  -9.876461,  -10.163712, -10.138092, -10.278254, -10.341890,
    -10.560672, -11.144170, -10.926747, -10.659506, -10.799761, -10.855946,
    -11.513156, -11.354611, -11.361145, -11.516581, -10.896853, -10.939065,
    -10.671203, -10.349083, -10.889129, -9.471889,  -9.023875,  -8.769901,
    -9.148991,  -9.186981,  -9.599609,  -9.664516,  -9.869886,  -9.514058,
    -10.023904, -9.022928,  -8.720813,  -9.281976,  -9.016473,  -9.149539,
    -8.953227,  -9.607924,  -10.111812, -10.015528, -9.834278,  -10.267220,
    -9.408759,  -9.229266,  -9.434208,  -9.986132,  -9.694752,  -9.099510,
    -8.693832,  -8.461116,  -7.689204,  -8.286983,  -8.964524,  -8.782996,
    -8.518188,  -7.943279,  -8.254424,  -8.436883,  -8.733157,  -8.898921,
    -9.176875,  -8.852981,  -9.152367,  -8.614722,  -8.487838,  -8.730507,
    -9.309872,  -9.956769,  -10.426658, -10.501339, -10.683239, -10.490986,
    -10.429133, -10.720009, -11.328962, -10.816535, -10.224664, -9.797255,
    -9.754988,  -10.061607, -9.977949,  -10.009662, -10.145176, -10.843472,
    -11.108989, -11.684790, -11.123210, -11.184746, -11.337653, -11.572001,
    -11.405521, -10.164281, -10.084698, -10.344795, -10.914293, -11.285498,
    -11.004550, -10.840040, -10.781019, -10.579171, -10.247739, -10.275211,
    -9.675589,  -9.698467,  -9.571448,  -9.784135,  -10.303465, -10.860212,
    -10.496012, -10.724651, -10.299653, -9.041532,  -8.941564,  -8.699322,
    -9.042195,  -8.724094,  -8.758736,  -9.112637,  -9.516151,  -9.724389,
    -9.753883,  -10.334237, -9.501575,  -8.823247,  -9.244876,  -9.463299,
    -9.977716,  -10.037978, -10.164111, -9.628828,  -9.455721,  -10.328112,
    -10.708042, -10.638822, -11.119428, -10.897298, -10.757533, -10.692248,
    -10.693997, -10.517792, -10.896939, -10.819762, -11.285919, -11.522438,
    -11.069844, -11.194836, -10.878646, -10.885525, -11.184690, -11.024093,
    -10.446146, -9.972995,  -10.078020, -10.224512, -9.199383,  -9.048430,
    -8.723654,  -9.446681,  -9.189012,  -8.761775,  -9.392633,  -9.531445,
    -9.219521,  -8.984144,  -9.062471,  -9.662403,  -10.250532, -10.342880,
    -9.740253,  -8.990673,  -9.323988,  -10.149845, -10.210651, -10.061250,
    -10.202912, -10.125380, -10.330465, -10.308430, -10.079632, -10.630301,
    -10.189341, -10.545503, -10.896766, -11.485351, -10.831158, -11.228966,
    -11.855931, -11.958470, -12.068833, -11.943971, -11.602266, -11.308291,
    -10.816967, -11.355621, -11.132949, -11.915418, -11.666011, -10.965426,
    -10.827370, -10.958476, -10.603501, -10.049082, -9.803132,  -9.108357,
    -9.463327,  -9.554723,  -10.134838, -9.944400,  -10.506706, -11.023027,
    -10.524805, -10.321164, -9.411901,  -8.594273,  -7.618418,  -7.719246,
    -8.308029,  -7.881681,  -7.505305,  -7.901148,  -7.299609,  -7.008877,
    -6.756795,  -6.781256,  -6.574073,  -7.123960,  -7.147128,  -6.935742,
    -7.722764,  -7.713073,  -8.678836,  -8.829286,  -8.720661,  -8.864720,
    -9.233795,  -9.807878,  -10.076968, -9.341551,  -9.395824,  -9.192743,
    -8.515300,  -9.349370,  -8.641072,  -8.475359,  -8.561003,  -8.629736,
    -8.197236,  -7.796022,  -8.150151,  -8.946626,  -9.170677,  -9.358727,
    -9.997621,  -9.587386,  -9.925036,  -9.481268,  -9.787454,  -9.314236,
    -9.348939,  -9.117717,  -9.371386,  -9.578332,  -9.497351,  -10.368646,
    -11.129792, -11.061177, -11.206049, -12.510120, -12.444043, -11.857035,
    -11.042806, -11.232721, -10.639272, -9.821578,  -10.495801, -11.068331,
    -11.545475, -11.448332, -11.314609, -10.906400, -10.731900, -10.287389,
    -10.806778, -11.230947, -10.840240, -10.680837, -10.243160, -10.282924,
    -10.029013, -9.990850,  -10.147843, -10.721495, -10.224241, -10.684341,
    -11.046537, -10.835671, -10.586824, -10.062734, -9.531216,  -8.994361,
    -9.177058,  -9.047306,  -8.874869,  -9.383639,  -9.067924,  -8.724616,
    -8.597962,  -8.185791,  -8.476480,  -8.924163,  -8.550941,  -8.632582,
    -9.366940,  -9.491037,  -10.018094, -10.428973, -10.253074, -10.023641,
    -9.986771,  -9.883039,  -9.477334,  -9.518460,  -8.527311,  -9.473481,
    -9.543312,  -9.295951,  -9.237004,  -8.872624,  -9.186768,  -9.159748,
    -9.536486,  -10.039386, -9.940100,  -9.770005,  -9.535605,  -9.956969,
    -10.019044, -9.992085,  -9.645733,  -8.772275,  -8.375237,  -8.411424,
    -9.077880,  -9.361001,  -9.770403,  -9.816087,  -10.244726, -10.066496,
    -9.575550,  -9.515995,  -9.844364,  -9.814794,  -10.402649, -10.604768,
    -9.979363,  -10.499534, -9.926633,  -10.725056, -10.878096, -10.676068,
    -10.627804, -11.188351, -10.171600, -10.091579, -9.680264,  -9.674121,
    -9.564998,  -9.835069,  -10.676304, -10.627932, -9.765754,  -9.110704,
    -9.118433,  -9.253893,  -9.034106,  -9.194030,  -9.465211,  -9.600592,
    -9.611494,  -10.445478, -11.085366, -11.078865, -11.650784, -10.641848,
    -9.605456,  -9.951251,  -9.446507,  -9.803956,  -9.540864,  -9.181955,
    -9.899560,  -10.427606, -10.548826, -10.531579, -10.619912, -11.035431,
    -11.280847, -10.905612, -10.200456, -10.126356, -10.159588, -10.289007,
    -10.735444, -10.310850, -10.021903, -10.087468, -10.472469, -9.991607,
    -9.880258,  -9.642112,  -9.519575,  -9.731840,  -10.474928, -10.547345,
    -10.009551, -9.609580,  -8.644833,  -8.321807,  -8.579892,  -8.674975,
    -8.162369,  -8.246261,  -7.953806,  -8.692506,  -8.305873,  -8.727509,
    -8.965974,  -8.808289,  -8.291128,  -8.589963,  -8.714945,  -8.681029,
    -8.729841,  -8.852864,  -9.268582,  -9.039636,  -9.360694,  -8.589868,
    -7.738942,  -7.726332,  -7.792164,  -7.248464,  -7.512142,  -7.601299,
    -8.208320,  -8.379421,  -8.379297,  -8.899121,  -8.761707,  -9.153203,
    -9.347312,  -10.034075, -10.491117, -10.288594, -10.160583, -9.875516,
    -10.567373, -10.576029, -9.963057,  -10.576701, -10.065904, -10.322376,
    -10.157199, -9.832239,  -10.031269, -9.367367,  -8.813750,  -9.028948,
    -9.050075,  -9.559443,  -8.734266,  -9.141633,  -9.112527,  -9.792604,
    -10.007519, -10.240354, -10.266954, -10.546537, -10.832955, -10.463040,
    -10.379068, -10.773082, -10.939036, -11.335153, -11.718081, -12.086633,
    -12.001786, -11.942961, -11.250122, -11.733122, -11.532815, -11.148615,
    -11.252205, -10.707310, -10.664902, -10.424137, -10.221052, -10.269075,
    -9.457772,  -9.172978,  -8.931388,  -9.161842,  -8.520129,  -8.820097,
    -8.674969,  -8.773539,  -8.660523,  -8.570998,  -7.855480,  -8.297218,
    -7.850044,  -7.672576,  -8.167987,  -8.841191,  -8.602125,  -9.247164,
    -9.621780,  -9.748813,  -9.436398,  -9.579451,  -9.281116,  -8.796051,
    -8.994380,  -9.384481,  -9.309239,  -9.236094,  -9.375904,  -9.707071,
    -9.575138,  -9.657194,  -9.931752,  -9.745665,  -9.774491,  -9.154046,
    -9.000552,  -8.848363,  -9.327152,  -9.745382,  -9.057112,  -8.836292,
    -9.247060,  -8.764024,  -8.726157,  -8.255214,  -8.019723,  -8.413586,
    -8.542801,  -8.222591,  -8.327530,  -8.193050,  -8.463574,  -8.062758,
    -8.090300,  -7.469891,  -7.091842,  -6.934368,  -7.388603,  -7.981920,
    -8.286693,  -8.327821,  -8.539807,  -8.904727,  -9.405680,  -9.413166,
    -9.381230,  -9.517474,  -9.395996,  -9.244683,  -9.270133,  -9.454262,
    -9.780319,  -9.216194,  -9.066476,  -8.885430,  -9.485993,  -9.172365,
    -9.042219,  -8.673250,  -8.492645,  -8.078793,  -8.864364,  -9.123485,
    -9.305047,  -9.414812,  -9.257370,  -9.458951,  -9.583244,  -9.636191,
    -10.022584, -10.110102, -9.925328,  -10.091106, -10.572324, -10.144205,
    -9.885983,  -9.781597,  -9.419465,  -8.824206,  -9.009243,  -8.712842,
    -8.967844,  -8.537061,  -8.668311,  -8.322745,  -8.332386,  -8.270260,
    -7.945946,  -8.168511,  -8.101699,  -8.163268,  -7.949175,  -8.460270,
    -8.846517,  -8.727498,  -8.733918,  -9.046853,  -9.247094,  -8.956220,
    -8.219924,  -8.630674,  -8.918085,  -8.705603,  -9.196429,  -8.974177,
    -8.682573,  -8.328555,  -8.302445,  -8.572132,  -8.724732,  -8.960800,
    -9.079711,  -8.709216,  -8.277434,  -8.552930,  -8.705733,  -9.125182,
    -9.404369,  -9.175535,  -9.432711,  -9.182692,  -8.661949,  -8.652755,
    -9.104683,  -9.219164,  -9.777559,  -9.609205,  -9.532034,  -9.536584,
    -9.239829,  -9.044292,  -9.313303,  -9.627926,  -9.609342,  -9.287780,
    -9.620861,  -9.059950,  -8.432253,  -8.856728,  -8.936765,  -8.518337,
    -8.572204,  -8.683843,  -8.293759,  -7.818072,  -7.265719,  -7.746123,
    -7.876378,  -8.053802,  -7.357601,  -7.517120,  -7.354821,  -7.447331,
    -7.405332,  -7.966838,  -8.346542,  -8.920613,  -8.582478,  -8.683699,
    -8.639707,  -8.823743,  -8.491854,  -8.593182,  -8.904896,  -9.404683,
    -9.176584,  -9.004568,  -9.061769,  -8.789564,  -8.754168,  -8.219529,
    -8.124433,  -8.248391,  -8.036829,  -8.053031,  -8.097501,  -8.519259,
    -8.574358,  -8.648637,  -8.914682,  -8.296911,  -8.111053,  -8.139797,
    -8.711344,  -8.547395,  -8.415548,  -9.009746,  -9.038814,  -8.728428,
    -8.458534,  -8.746328,  -8.322902,  -8.468840,  -8.609352,  -8.743431,
    -8.697580,  -8.487697,  -8.129181,  -8.495704,  -8.658296,  -8.462857,
    -8.456287,  -8.449080,  -9.121746,  -8.873500,  -8.812339,  -9.428667,
    -9.637206,  -9.982345,  -9.602266,  -9.411692,  -9.223228,  -8.867751,
    -8.866634,  -8.848709,  -8.982418,  -8.916339,  -8.500795,  -7.936969,
    -8.743040,  -8.617600,  -8.646871,  -8.648569,  -8.458019,  -7.926883,
    -7.752435,  -8.064996,  -7.990132,  -7.728811,  -7.463537,  -7.524107,
    -7.877711,  -7.837928,  -8.260400,  -8.280365,  -7.770553,  -7.436056,
    -7.586722,  -7.523375,  -7.427890,  -7.789840,  -7.752716,  -8.000685,
    -8.019870,  -7.507279,  -7.643847,  -7.722183,  -7.906736,  -7.864629,
    -8.257438,  -8.561323,  -8.462468,  -8.476892,  -8.274107,  -8.351861,
    -8.046138,  -7.870220,  -7.810983,  -7.381335,  -7.250223,  -7.703835,
    -7.580419,  -7.406584,  -7.657945,  -7.821209,  -7.746362,  -7.454884,
    -7.593084,  -7.649818,  -7.319770,  -7.729661,  -7.718592,  -7.635592,
    -7.176524,  -6.997740,  -6.762595,  -7.093942,  -6.856651,  -6.874368,
    -7.274689,  -7.711866,  -7.873217,  -7.477023,  -6.882006,  -6.872341,
    -6.629112,  -6.478665,  -6.867359,  -6.982886,  -7.001086,  -7.232502,
    -6.899544,  -6.508655,  -6.969631,  -6.845380,  -7.091362,  -7.220828,
    -7.093205,  -7.031402,  -6.879030,  -6.793375,  -6.767481,  -6.645699,
    -6.733902,  -6.268964,  -6.636725,  -6.573358,  -6.709264,  -7.023423,
    -7.055344,  -6.830522,  -6.813513,  -7.421688,  -7.277494,  -7.327226,
    -7.259681,  -6.793566,  -6.694909,  -6.347293,  -6.499732,  -6.668324,
    -6.416339,  -6.217028,  -6.208917,  -6.372649,  -6.403201,  -6.455087,
    -6.381956,  -5.908442,  -6.216521,  -6.231419,  -6.264125,  -6.596136,
    -6.487017,  -6.969810,  -6.570276,  -6.503560,  -6.736490,  -6.816347,
    -7.177590,  -7.229484,  -7.140310,  -6.922356,  -7.007504,  -6.806530,
    -6.764932,  -7.144420,  -7.485528,  -7.789285,  -7.918190,  -7.610512,
    -7.598362,  -7.989981,  -7.780984,  -7.714958,  -7.365666,  -7.171964,
    -6.981408,  -7.066544,  -7.126843,  -7.162927,  -7.447755,  -7.819525,
    -7.996107,  -7.723483,  -8.124865,  -8.054503,  -7.555785,  -7.477698,
    -7.510517,  -7.240237,  -7.097003,  -7.068176,  -7.008394,  -6.786494,
    -7.082364,  -7.047777,  -6.845500,  -7.020906,  -6.875087,  -6.833976,
    -6.623048,  -7.309642,  -7.098477,  -6.729410,  -6.610829,  -6.456835,
    -6.139505,  -6.326318,  -6.056338,  -6.282803,  -6.048044,  -6.173033,
    -6.362916,  -6.222469,  -5.911318,  -5.703619,  -5.203118,  -5.081357,
    -5.044895,  -4.956974,  -4.949153,  -4.757932,  -4.655242,  -4.632034,
    -4.552669,  -4.675650,  -4.979578,  -5.192470,  -5.068796,  -4.891979,
    -4.918195,  -4.876035,  -4.645425,  -4.870031,  -5.004877,  -4.932059,
    -5.168654,  -5.309941,  -5.239384,  -5.348205,  -5.370137,  -5.682640,
    -5.762508,  -5.507348,  -5.317801,  -5.310138,  -5.220739,  -5.301127,
    -5.045068,  -4.972957,  -4.944464,  -5.318861,  -5.691240,  -5.574305,
    -5.497807,  -5.578078,  -5.195300,  -5.117050,  -4.952667,  -5.070072,
    -4.601599,  -4.681729,  -4.539339,  -4.791692,  -4.922503,  -4.584894,
    -4.536865,  -4.512263,  -4.271314,  -4.779632,  -4.665334,  -4.693784,
    -4.732607,  -4.779427,  -4.714878,  -4.782928,  -4.852582,  -4.922444,
    -4.408381,  -4.065355,  -4.225886,  -4.144426,  -4.422056,  -4.675549,
    -4.674440,  -5.132372,  -5.313294,  -5.356216,  -5.616742,  -5.385559,
    -5.166302,  -5.071611,  -4.974872,  -4.989545,  -5.330185,  -5.283767,
    -5.225420,  -5.155486,  -4.848714,  -4.890587,  -5.021746,  -5.007703,
    -5.085399,  -5.020629,  -4.826173,  -4.625911,  -4.753682,  -4.843264,
    -4.674872,  -4.604975,  -4.402381,  -4.410602,  -3.946752,  -4.267938,
    -4.527184,  -4.728249,  -4.984410,  -5.069574,  -4.998261,  -5.002663,
    -4.965422,  -4.889873,  -4.778593,  -4.417497,  -4.479972,  -4.600261,
    -4.770975,  -5.093034,  -5.442004,  -5.062648,  -4.988093,  -4.974345,
    -4.907913,  -5.218898,  -5.018541,  -4.673338,  -4.515823,  -4.527389,
    -4.373891,  -4.386888,  -4.443939,  -4.329543,  -4.164243,  -3.952197,
    -4.011856,  -4.002727,  -3.930016,  -3.903228,  -4.124860,  -4.154109,
    -4.008071,  -4.426500,  -4.630653,  -4.329568,  -4.394773,  -4.378765,
    -4.391216,  -4.018245,  -3.706111,  -3.551654,  -3.437294,  -3.256795,
    -3.422506,  -3.494177,  -3.074229,  -3.120251,  -2.678055,  -2.903840,
    -3.027625,  -2.655708,  -2.538054,  -2.449564,  -2.486804,  -2.536880,
    -2.497905,  -2.775107,  -2.839653,  -2.908982,  -2.783649,  -2.777782,
    -2.780421,  -2.691456,  -2.617124,  -2.653763,  -2.593445,  -2.444597,
    -2.313127,  -2.684547,  -2.826804,  -3.245918,  -3.330855,  -3.208682,
    -3.285605,  -3.251640,  -3.309132,  -3.447924,  -3.466586,  -3.087645,
    -3.020044,  -2.850917,  -2.398558,  -2.453826,  -2.490941,  -2.320576,
    -2.436582,  -2.241869,  -2.238753,  -2.124670,  -2.192742,  -2.047624,
    -1.897454,  -2.211256,  -2.193674,  -1.968397,  -1.928936,  -1.963501,
    -2.249895,  -2.205010,  -2.230357,  -2.225480,  -1.730056,  -1.530883,
    -1.783427,  -1.707000,  -1.699450,  -1.753393,  -1.953451,  -1.918252,
    -1.943401,  -2.294760,  -2.120907,  -2.016252,  -2.064412,  -2.249373,
    -2.285550,  -2.276176,  -2.134370,  -2.142401,  -1.836167,  -1.873315,
    -2.041006,  -2.146490,  -2.104885,  -2.107849,  -2.149877,  -2.403534,
    -2.404019,  -2.616197,  -2.665173,  -2.741587,  -2.665267,  -2.538125,
    -2.452240,  -2.227731,  -1.877873,  -1.764648,  -1.777588,  -1.729809,
    -1.626093,  -1.731869,  -1.765711,  -1.992767,  -1.788622,  -1.883619,
    -1.559511,  -1.801870,  -1.782786,  -1.868764,  -1.706525,  -1.660991,
    -1.635045,  -1.455790,  -1.562516,  -1.332818,  -1.476372,  -1.279650,
    -1.281584,  -1.462185,  -1.297987,  -0.905538,  -1.062616,  -0.961439,
    -1.211299,  -0.942182,  -0.954002,  -0.802906,  -0.836567,  -0.704549,
    -0.670882,  -0.477339,  -0.139138,  -0.247980,  -0.348262,  -0.439598,
    -0.439613,  -0.438096,  -0.434380,  -0.182883,  -0.196768,  0.120071,
    0.003900,   -0.178019,  -0.093869,  -0.092113,  -0.083366,  -0.228733,
    -0.512012,  -0.436067,  -0.676355,  -0.720370,  -0.745715,  -0.833035,
    -0.975151,  -0.847111,  -0.871706,  -0.954022,  -0.928934,  -0.964144,
    -0.815978,  -0.895905,  -1.102173,  -1.106786,  -1.163393,  -1.344187,
    -1.479310};

static const std::vector<float> PRED_STATE_2 = {
    0.000000,    0.001293,    0.009440,    0.009261,    0.027101,
    0.058208,    0.086965,    0.133928,    0.218727,    0.300033,
    0.373043,    0.455470,    0.599990,    0.789870,    1.031923,
    1.259043,    1.586734,    1.984407,    2.458920,    3.071019,
    3.776102,    4.515748,    5.286247,    6.231071,    7.203655,
    8.451112,    10.170407,   12.010071,   13.965420,   15.924191,
    18.095604,   20.477759,   23.066375,   25.599878,   28.458895,
    32.051028,   35.092396,   38.587272,   42.372693,   46.432704,
    51.070707,   55.275425,   60.212774,   65.853976,   71.107020,
    76.138305,   81.116355,   86.209466,   91.584085,   97.019542,
    102.494111,  107.593348,  113.709220,  120.172341,  126.130183,
    131.792747,  137.570797,  143.439291,  149.585252,  155.548145,
    162.390386,  168.529262,  174.637611,  181.134691,  186.877337,
    192.777025,  198.582827,  204.951738,  210.705930,  216.767555,
    222.418249,  229.030399,  234.693385,  240.826693,  247.149185,
    253.166022,  258.183525,  263.182358,  268.613066,  274.194134,
    279.662043,  285.006503,  291.635495,  296.832074,  302.104482,
    307.667829,  312.527929,  317.435960,  322.851875,  327.518172,
    332.678267,  337.312144,  342.653665,  347.418890,  352.120102,
    356.745728,  361.529957,  366.445207,  370.973349,  375.373211,
    380.132869,  384.219767,  388.660691,  393.663865,  396.928223,
    401.065221,  404.996182,  409.224009,  413.461512,  417.693591,
    422.664636,  426.531512,  429.614839,  433.740506,  437.545211,
    441.804655,  444.936941,  448.294182,  451.591661,  454.822997,
    458.755482,  462.808919,  466.700978,  470.951645,  474.738637,
    477.561302,  480.789153,  484.382189,  488.039602,  490.953238,
    494.489219,  498.327140,  501.635593,  504.975483,  508.334298,
    510.897342,  514.054810,  516.948371,  519.856916,  522.770470,
    525.679835,  529.663241,  532.997765,  535.721498,  538.416923,
    541.628106,  545.033089,  548.333211,  551.526755,  554.612435,
    557.312102,  559.645549,  562.751814,  565.445294,  568.311352,
    571.330934,  574.201677,  575.794374,  577.617156,  579.933913,
    581.561458,  583.404607,  584.869061,  585.404610,  586.806799,
    588.142964,  588.835855,  589.220905,  590.486676,  590.521694,
    590.587447,  590.976663,  590.783072,  591.230755,  590.794527,
    590.727748,  589.517973,  589.041463,  586.560413,  586.418433,
    584.846386,  582.555939,  581.417227,  579.234159,  577.303835,
    575.006905,  573.292122,  571.207939,  570.014791,  567.810424,
    565.601272,  562.778622,  560.633852,  557.886608,  555.522693,
    552.900923,  549.738515,  547.023304,  544.106988,  541.329873,
    538.691373,  536.509552,  532.859741,  528.813662,  526.004908,
    523.079812,  519.419010,  515.409506,  512.054435,  508.675837,
    505.287560,  502.227566,  499.807922,  497.019264,  493.573961,
    490.838893,  487.466599,  484.826859,  481.565124,  478.726588,
    474.973267,  473.364308,  470.767495,  468.596418,  465.499013,
    462.223214,  459.464427,  457.198187,  454.390242,  451.094252,
    448.370658,  445.852642,  443.537584,  442.102607,  438.085718,
    435.785771,  433.722597,  432.575521,  430.566972,  427.427321,
    424.978268,  424.219580,  420.874936,  417.578870,  415.386472,
    412.833084,  411.705415,  409.805604,  407.552243,  406.390697,
    405.191025,  402.904982,  400.686450,  398.896619,  397.158645,
    394.766006,  393.564775,  392.761160,  390.181049,  387.045540,
    384.487830,  383.200102,  381.291467,  380.629782,  378.225753,
    377.128892,  376.159372,  375.682070,  374.201954,  371.436619,
    370.799603,  370.301464,  369.939333,  368.598476,  367.102409,
    365.842671,  365.183581,  364.715444,  362.935496,  361.447212,
    361.366194,  360.712800,  360.291480,  360.847705,  360.797740,
    359.813177,  358.729750,  357.944832,  357.442992,  356.445466,
    354.613491,  353.169397,  352.477642,  350.179707,  349.104526,
    348.397414,  347.650689,  346.874823,  346.468027,  344.460737,
    343.712344,  343.747649,  342.553419,  341.799016,  341.853540,
    340.295637,  339.623156,  337.798440,  336.897980,  336.464739,
    335.275672,  335.787305,  335.480251,  336.023238,  334.546345,
    334.021508,  331.969392,  332.141355,  330.740968,  331.132783,
    330.752726,  329.257592,  328.365833,  328.449153,  327.803433,
    327.718692,  327.337018,  327.096980,  327.817924,  327.366849,
    327.490008,  326.491813,  327.368720,  327.071277,  326.525297,
    324.920310,  323.597021,  320.868617,  319.781882,  320.226494,
    317.881321,  318.022407,  316.668304,  317.748990,  315.570154,
    314.205808,  313.603800,  312.434844,  312.028876,  312.763198,
    311.554506,  311.559862,  310.112450,  309.481339,  308.317262,
    307.099180,  306.270268,  305.374409,  305.292702,  304.227057,
    304.438527,  304.524246,  302.747307,  301.883079,  301.871297,
    300.892192,  299.025045,  298.549487,  297.599423,  295.773980,
    295.363178,  295.824738,  296.205525,  295.622340,  294.597944,
    294.067131,  293.549874,  293.049621,  293.020517,  292.981095,
    293.387185,  294.209070,  293.150716,  291.266319,  289.987614,
    289.277171,  288.186281,  285.382154,  284.198700,  282.692421,
    282.271306,  280.562324,  279.968759,  279.030113,  278.240185,
    277.593697,  276.622031,  276.746890,  276.961789,  275.400076,
    275.930988,  276.065281,  274.433724,  272.579313,  271.464584,
    271.041442,  270.321917,  269.333834,  269.991375,  267.918078,
    267.112538,  267.487852,  266.582131,  265.923789,  264.070719,
    265.415500,  264.937189,  265.172771,  264.151997,  264.375905,
    263.348958,  261.171332,  260.829772,  258.811464,  257.666626,
    257.823172,  255.789560,  256.597385,  256.627876,  255.454811,
    254.150310,  253.708848,  254.070932,  253.215912,  252.713767,
    252.542597,  252.681267,  252.616101,  251.870803,  249.512489,
    247.649528,  247.246443,  246.211313,  246.089027,  243.329663,
    244.624621,  243.172107,  243.690801,  243.528971,  244.247780,
    243.266404,  242.228360,  242.657137,  242.929202,  242.046584,
    241.113723,  242.679528,  241.977731,  241.728785,  241.903125,
    242.471405,  241.870908,  241.728638,  240.988897,  239.700619,
    239.452054,  238.625136,  237.782908,  238.481104,  236.469851,
    236.097982,  233.621881,  233.354855,  233.579353,  232.698816,
    231.322240,  230.535543,  229.254478,  227.522500,  227.473989,
    227.413631,  226.820325,  226.789523,  225.701437,  225.749366,
    224.211254,  223.855225,  223.008588,  221.712441,  222.129802,
    221.475608,  221.432146,  219.823624,  216.776700,  218.282564,
    218.649071,  219.035920,  219.980625,  218.216389,  217.179608,
    216.283498,  215.522480,  215.430146,  215.419015,  214.943891,
    214.042742,  213.294415,  212.148464,  211.728393,  210.349148,
    209.178940,  208.753863,  207.927416,  207.281686,  206.807361,
    205.946578,  204.732457,  202.098953,  200.911010,  201.619487,
    200.217689,  199.633530,  199.256314,  199.628127,  199.585059,
    198.604356,  198.986120,  199.515693,  199.066961,  197.159770,
    197.262540,  197.548679,  194.647229,  194.408554,  193.270800,
    192.992415,  191.824006,  192.656245,  194.211836,  193.605119,
    193.832636,  194.834993,  193.716081,  192.343084,  191.877462,
    191.686135,  192.321175,  192.008407,  191.964088,  191.598642,
    189.795229,  190.105716,  189.503841,  190.936637,  190.218922,
    189.245380,  186.888736,  186.719280,  186.844547,  186.664548,
    186.784623,  185.445100,  184.500722,  182.765310,  183.793671,
    182.136242,  182.081711,  180.594771,  180.124009,  180.012991,
    181.409506,  179.506578,  179.839625,  178.717529,  176.843659,
    176.044509,  175.656526,  173.882126,  173.191845,  169.967505,
    169.132701,  169.332810,  166.936978,  166.296990,  166.693998,
    165.077863,  165.771060,  165.621293,  168.879932,  166.906711,
    165.488928,  164.589598,  162.977801,  164.311294,  164.763393,
    163.800789,  164.542304,  162.044360,  163.184578,  162.259152,
    161.843984,  161.299363,  161.848874,  160.987091,  162.463854,
    163.063272,  161.637217,  160.167816,  159.272845,  157.694935,
    158.540569,  158.573208,  157.244773,  155.887076,  156.956730,
    156.590842,  157.356675,  157.323996,  155.326231,  155.208164,
    154.984483,  154.663856,  153.023937,  151.402959,  152.280077,
    152.370630,  152.354936,  152.242900,  152.043915,  151.144970,
    150.846072,  151.104467,  150.632679,  147.622292,  147.258104,
    146.849104,  145.151586,  143.519224,  142.577800,  142.907520,
    141.277315,  140.350259,  137.568730,  135.590907,  134.364071,
    133.836648,  134.590726,  132.115224,  132.970814,  131.851688,
    130.809442,  132.376394,  131.281766,  130.901867,  131.186427,
    130.815195,  130.475693,  128.261993,  126.865723,  129.422118,
    129.241835,  127.177985,  127.207698,  125.981175,  127.437371,
    125.606816,  123.948429,  120.536764,  119.994559,  119.546511,
    119.830712,  118.220675,  118.080979,  118.015666,  117.376293,
    118.145092,  119.570530,  119.012868,  116.628784,  116.442109,
    116.995759,  116.937336,  116.964205,  115.124749,  116.761287,
    115.107291,  113.020682,  111.189701,  110.252541,  108.843845,
    108.307573,  107.928163,  109.658245,  109.409259,  107.989486,
    107.454647,  107.086390,  107.530141,  108.068694,  108.037932,
    107.482595,  107.759710,  108.149123,  107.983952,  106.650085,
    106.216825,  105.300026,  104.600015,  103.443110,  101.208683,
    101.287311,  101.522497,  100.579357,  99.875062,   97.410304,
    97.298300,   96.711460,   95.688841,   96.925361,   96.257072,
    96.493461,   96.901915,   94.805137,   98.405288,   99.241877,
    99.533409,   97.986296,   97.417749,   95.751699,   95.081904,
    93.998089,   94.545187,   92.578479,   95.004561,   95.436926,
    93.359809,   93.672151,   92.832186,   92.948810,   90.586537,
    88.632559,   88.408545,   88.437819,   86.680002,   88.677141,
    88.731616,   87.670817,   85.585047,   85.937860,   87.193860,
    87.925259,   88.171128,   90.005467,   87.872849,   85.477085,
    85.559722,   85.894984,   87.150349,   85.843267,   84.896959,
    83.608684,   82.687263,   81.429462,   81.917822,   80.599640,
    81.714324,   81.654651,   80.520592,   78.389758,   76.032464,
    74.160473,   73.420739,   72.363722,   72.391787,   72.048122,
    70.676021,   68.359187,   69.291292,   70.481345,   71.220036,
    70.853781,   69.469346,   69.210919,   68.619279,   67.722495,
    65.173125,   63.854467,   61.615132,   62.673188,   61.937072,
    60.930669,   59.678454,   59.586712,   62.646347,   62.370867,
    61.105997,   58.923306,   57.292031,   57.549366,   57.480235,
    57.110837,   57.162075,   57.602362,   57.009636,   58.249422,
    57.698738,   57.585274,   56.484714,   54.476766,   52.333431,
    52.855494,   51.662058,   52.368697,   55.532991,   55.373265,
    55.634603,   54.196932,   54.675083,   54.137570,   52.664678,
    51.029002,   49.944218,   49.371744,   47.186851,   49.105195,
    50.613833,   48.939651,   47.838644,   45.861107,   45.185992,
    44.315224,   45.372413,   45.397210,   42.373185,   40.745703,
    40.412729,   38.475294,   38.568924,   38.432791,   38.085835,
    37.546107,   37.526705,   35.892031,   35.572882,   33.668653,
    32.412677,   33.160129,   32.241108,   32.606041,   32.041991,
    30.622829,   30.533250,   31.672205,   32.533589,   31.727805,
    30.795497,   33.282183,   33.263663,   33.761024,   31.210405,
    31.491603,   32.281574,   29.998591,   29.123016,   29.558640,
    29.786006,   29.107737,   26.900159,   24.697102,   23.914509,
    25.159702,   26.864779,   25.440490,   22.559135,   21.873822,
    21.800201,   20.882858,   20.599448,   19.493424,   19.041342,
    19.195023,   17.080653,   17.838690,   16.287655,   14.733138,
    12.467029,   13.805897,   12.100981,   9.706024,    8.813360,
    7.892686,    7.654395,    8.056485,    8.336081,    9.207505,
    7.091405,    7.174811,    4.329893,    4.463493,    5.928999,
    5.784463,    4.859685,    5.349857,    6.441038,    6.657846,
    8.199504,    6.706003,    5.965556,    3.791321,    3.841498,
    1.699860,    -0.335416,   0.570444,    0.639736,    2.782747,
    4.703239,    7.127338,    6.451553,    4.343742,    5.175162,
    5.881760,    4.348883,    5.712979,    6.198222,    6.584971,
    6.175597,    6.442425,    4.505620,    4.081670,    4.342494,
    1.694123,    1.336325,    -1.873627,   -2.747549,   -2.871346,
    -3.728669,   -5.251235,   -7.391788,   -8.669113,   -7.022293,
    -7.648086,   -7.523985,   -6.002492,   -8.867430,   -7.263534,
    -7.210976,   -7.885201,   -8.514255,   -7.680929,   -6.917473,
    -8.342896,   -11.079633,  -12.182184,  -13.190655,  -15.526987,
    -14.827169,  -16.293970,  -15.492456,  -16.861937,  -15.967418,
    -16.534619,  -16.325873,  -17.523595,  -18.597363,  -18.839455,
    -21.862359,  -24.606702,  -24.962533,  -25.939259,  -30.313217,
    -30.745485,  -29.651029,  -27.862730,  -28.970262,  -27.796401,
    -25.937083,  -28.399874,  -30.598985,  -32.547771,  -32.840959,
    -33.022312,  -32.394267,  -32.429275,  -31.665931,  -33.699215,
    -35.480003,  -34.898957,  -34.974808,  -34.228899,  -34.857342,
    -34.628945,  -35.018791,  -35.977448,  -38.162440,  -37.244336,
    -39.101074,  -40.694505,  -40.630172,  -40.444221,  -39.440901,
    -38.389655,  -37.296226,  -38.280227,  -38.359628,  -38.307715,
    -40.239317,  -39.785215,  -39.234634,  -39.300475,  -38.525010,
    -39.784400,  -41.517438,  -40.872185,  -41.538487,  -44.117686,
    -44.948946,  -46.964835,  -48.667323,  -48.674371,  -48.516065,
    -48.909423,  -49.105405,  -48.413105,  -49.007242,  -46.584625,
    -49.777994,  -50.455883,  -50.209658,  -50.502070,  -49.898320,
    -51.260641,  -51.640960,  -53.200691,  -55.148205,  -55.359820,
    -55.359396,  -55.162413,  -56.871440,  -57.550822,  -57.972934,
    -57.459658,  -55.387586,  -54.665092,  -55.189681,  -57.559249,
    -58.841110,  -60.506424,  -61.128543,  -62.872868,  -62.863887,
    -61.931477,  -62.236089,  -63.672180,  -64.077921,  -66.287798,
    -67.399013,  -66.100303,  -68.120469,  -66.970043,  -69.801299,
    -70.785107,  -70.738196,  -71.130854,  -73.301520,  -70.887528,
    -71.162094,  -70.463814,  -70.929863,  -71.094448,  -72.362498,
    -75.314380,  -75.706734,  -73.716757,  -72.289403,  -72.767542,
    -73.619605,  -73.439549,  -74.358942,  -75.611690,  -76.480862,
    -76.992772,  -79.912269,  -82.305847,  -82.841101,  -85.067577,
    -82.699563,  -80.200807,  -81.692330,  -80.713809,  -82.231464,
    -81.952270,  -81.379714,  -83.937392,  -85.976598,  -86.852477,
    -87.329481,  -88.114383,  -89.860531,  -91.130003,  -90.596700,
    -89.079806,  -89.373131,  -89.976633,  -90.863086,  -92.683107,
    -91.978187,  -91.648727,  -92.341562,  -93.971839,  -93.089220,
    -93.263171,  -93.060743,  -93.184500,  -94.281229,  -96.940924,
    -97.676448,  -96.631080,  -95.961872,  -93.621025,  -93.108601,
    -94.279442,  -94.986499,  -93.921173,  -94.574625,  -94.131678,
    -96.689638,  -95.993586,  -97.641921,  -98.775668,  -98.762829,
    -97.690848,  -98.979324,  -99.774322,  -100.110883, -100.687683,
    -101.483946, -103.142322, -102.936218, -104.327109, -102.540922,
    -100.481950, -100.832021, -101.410855, -100.210455, -101.343986,
    -101.980324, -104.135575, -105.046364, -105.464972, -107.404122,
    -107.447220, -109.030204, -110.055524, -112.531274, -114.369562,
    -114.301855, -114.441926, -114.116299, -116.633357, -117.187039,
    -115.923251, -118.215959, -117.251007, -118.504336, -118.537405,
    -118.094947, -119.168605, -117.728639, -116.577999, -117.648016,
    -118.161247, -120.103356, -118.168165, -119.796190, -120.168154,
    -122.612612, -123.730745, -124.912029, -125.501837, -126.832801,
    -128.197735, -127.657598, -127.935179, -129.606396, -130.630368,
    -132.335733, -134.022335, -135.686041, -136.042243, -136.470304,
    -135.041299, -137.016302, -137.017174, -136.470252, -137.330625,
    -136.299732, -136.711078, -136.540225, -136.467526, -137.119018,
    -135.259879, -134.899909, -134.652047, -135.772562, -134.354012,
    -135.657252, -135.673842, -136.395852, -136.504021, -136.675240,
    -135.011311, -136.695913, -135.803048, -135.676560, -137.508979,
    -139.886111, -139.629042, -141.945513, -143.503407, -144.355994,
    -143.929803, -144.819969, -144.426486, -143.472005, -144.491807,
    -146.082345, -146.331529, -146.583083, -147.453753, -148.891019,
    -148.990545, -149.709268, -150.995053, -150.947444, -151.519025,
    -150.193307, -150.202128, -150.207092, -152.049690, -153.739129,
    -152.213607, -152.020690, -153.663764, -152.713515, -153.040978,
    -152.100049, -151.824136, -153.376942, -154.175502, -153.666212,
    -154.384229, -154.407327, -155.608108, -154.859130, -155.342812,
    -153.932990, -153.200910, -153.094982, -154.770075, -156.874614,
    -158.164996, -158.699606, -159.735933, -161.230103, -163.140338,
    -163.632515, -164.009778, -164.877274, -164.997896, -165.025192,
    -165.561852, -166.563831, -167.990071, -166.829348, -166.852320,
    -166.776188, -168.976760, -168.533878, -168.611893, -167.984983,
    -167.890481, -167.104837, -169.806117, -171.007116, -171.994254,
    -172.780503, -172.790819, -173.843196, -174.679626, -175.313628,
    -176.925415, -177.682483, -177.647632, -178.628701, -180.540542,
    -179.817158, -179.569218, -179.758249, -179.188302, -177.918484,
    -178.900822, -178.484484, -179.665858, -178.854460, -179.665143,
    -179.087976, -179.532308, -179.767245, -179.232327, -180.280498,
    -180.493539, -181.078676, -180.860741, -182.752857, -184.305420,
    -184.399686, -184.854836, -186.206685, -187.244617, -186.856333,
    -185.150903, -186.763105, -188.035150, -187.859668, -189.730330,
    -189.540193, -189.136130, -188.534959, -188.875031, -190.078833,
    -190.953704, -192.080303, -192.876090, -192.246591, -191.419339,
    -192.638878, -193.513384, -195.175317, -196.448038, -196.249048,
    -197.459917, -197.200392, -196.136653, -196.542863, -198.297130,
    -199.087155, -201.181095, -201.177634, -201.432414, -201.922323,
    -201.531315, -201.421474, -202.660391, -204.046145, -204.473195,
    -204.013278, -205.451736, -204.292439, -202.909785, -204.572744,
    -205.249640, -204.472819, -205.056266, -205.811354, -205.104779,
    -204.128354, -202.903947, -204.672136, -205.440364, -206.353044,
    -204.719747, -205.554131, -205.455354, -206.093634, -206.343177,
    -208.355524, -209.864283, -211.960435, -211.417617, -212.142754,
    -212.448288, -213.418470, -212.889074, -213.609992, -214.951235,
    -216.858068, -216.661244, -216.617027, -217.234536, -216.891580,
    -217.227546, -216.101745, -216.234622, -217.003349, -216.797071,
    -217.246293, -217.778993, -219.417268, -220.004364, -220.650306,
    -221.860764, -220.499874, -220.371192, -220.860805, -222.939239,
    -222.895351, -222.937146, -225.095607, -225.631101, -225.175342,
    -224.822479, -226.087037, -225.286078, -226.129007, -226.963366,
    -227.785938, -228.089020, -227.910114, -227.286047, -228.764373,
    -229.664645, -229.526015, -229.929944, -230.331682, -232.721297,
    -232.451406, -232.716221, -234.959241, -236.040532, -237.531724,
    -236.919328, -236.842124, -236.761560, -236.183157, -236.623277,
    -237.014190, -237.847647, -238.103523, -237.334116, -236.110289,
    -238.864429, -238.934743, -239.451222, -239.888533, -239.763711,
    -238.633346, -238.519530, -239.821214, -240.005530, -239.640822,
    -239.251491, -239.801799, -241.212091, -241.489635, -243.117019,
    -243.588424, -242.511537, -241.921855, -242.734267, -242.928350,
    -243.025282, -244.455171, -244.736096, -245.848899, -246.305037,
    -245.206998, -245.981745, -246.593024, -247.518845, -247.791044,
    -249.333014, -250.634573, -250.773547, -251.238850, -251.069666,
    -251.710757, -251.234288, -251.122136, -251.342413, -250.476489,
    -250.462131, -252.151194, -252.175466, -252.046120, -253.151534,
    -254.011883, -254.184061, -253.718974, -254.495873, -255.041443,
    -254.458732, -256.023414, -256.377527, -256.520730, -255.560001,
    -255.395989, -255.058213, -256.365339, -256.026099, -256.420743,
    -257.935168, -259.577394, -260.434845, -259.669867, -258.303638,
    -258.619474, -258.251786, -258.143272, -259.603909, -260.285127,
    -260.687496, -261.714308, -261.102224, -260.304075, -261.977598,
    -261.962718, -263.024342, -263.757522, -263.745339, -263.919263,
    -263.825234, -263.918693, -264.182637, -264.164868, -264.755096,
    -263.732116, -265.121054, -265.267578, -265.993691, -267.247888,
    -267.692410, -267.387702, -267.679488, -269.798723, -269.748123,
    -270.257437, -270.426268, -269.426134, -269.477299, -268.795467,
    -269.558628, -270.376649, -269.973154, -269.711101, -269.998234,
    -270.787501, -271.195480, -271.667377, -271.776265, -270.710607,
    -271.906985, -272.261377, -272.668594, -273.952742, -273.963438,
    -275.699680, -274.879763, -275.013170, -276.019534, -276.589896,
    -277.987141, -278.497779, -278.598471, -278.318097, -278.913223,
    -278.675865, -278.894542, -280.342573, -281.697338, -282.959928,
    -283.726364, -283.222494, -283.567486, -285.092665, -284.880967,
    -285.076928, -284.441200, -284.243018, -284.044348, -284.642392,
    -285.172061, -285.633927, -286.825031, -288.284632, -289.192007,
    -288.794545, -290.354528, -290.555003, -289.499267, -289.648696,
    -290.118559, -289.703671, -289.646807, -289.917356, -290.095936,
    -289.797425, -291.001999, -291.254972, -291.015816, -291.871054,
    -291.795661, -292.019190, -291.744048, -294.083091, -293.831037,
    -293.106652, -293.096341, -292.976538, -292.371374, -293.224670,
    -292.751452, -293.716545, -293.344152, -294.012076, -294.876023,
    -294.783445, -294.184631, -293.872798, -292.694303, -292.598376,
    -292.745814, -292.740940, -292.965917, -292.654164, -292.591751,
    -292.756644, -292.756149, -293.343432, -294.466028, -295.337592,
    -295.235542, -294.971893, -295.293160, -295.415776, -294.985175,
    -295.874290, -296.512139, -296.549431, -297.487939, -298.159554,
    -298.218711, -298.798919, -299.130470, -300.312866, -300.830567,
    -300.372494, -300.093547, -300.337029, -300.341093, -300.837221,
    -300.353451, -300.394822, -300.560144, -301.902263, -303.257198,
    -303.199793, -303.254796, -303.764432, -302.923933, -302.954860,
    -302.729987, -303.320964, -302.204454, -302.668868, -302.486546,
    -303.451499, -304.073630, -303.332446, -303.421234, -303.576130,
    -303.097105, -304.797208, -304.701934, -305.018401, -305.366625,
    -305.740176, -305.790378, -306.225131, -306.667973, -307.114908,
    -305.857695, -305.074961, -305.747688, -305.720758, -306.739887,
    -307.702310, -307.932846, -309.505755, -310.291465, -310.682651,
    -311.712349, -311.317111, -310.945190, -310.926587, -310.897262,
    -311.188916, -312.434569, -312.565333, -312.658890, -312.715645,
    -312.076286, -312.441176, -313.069270, -313.279291, -313.756892,
    -313.821746, -313.504105, -313.159765, -313.764717, -314.264377,
    -314.014089, -314.043426, -313.681204, -313.925364, -312.789402,
    -313.926023, -314.897562, -315.711923, -316.697458, -317.195733,
    -317.240663, -317.503448, -317.644675, -317.672007, -317.591071,
    -316.774004, -317.177581, -317.753355, -318.482610, -319.662995,
    -320.938183, -320.100884, -320.135988, -320.345187, -320.399630,
    -321.554477, -321.229494, -320.470899, -320.243928, -320.503541,
    -320.281018, -320.537723, -320.923906, -320.811563, -320.544632,
    -320.132732, -320.504809, -320.678705, -320.666204, -320.784366,
    -321.627672, -321.919452, -321.700082, -323.124149, -323.942503,
    -323.293534, -323.700702, -323.873624, -324.128975, -323.257813,
    -322.545913, -322.279521, -322.122665, -321.766676, -322.414125,
    -322.794847, -321.741450, -322.029747, -320.892594, -321.686787,
    -322.193977, -321.257717, -321.046434, -320.914553, -321.145938,
    -321.416722, -321.429586, -322.365135, -322.692652, -323.037380,
    -322.816303, -322.938328, -323.084935, -322.963785, -322.880979,
    -323.118983, -323.075276, -322.769655, -322.507411, -323.709257,
    -324.259502, -325.626508, -326.037195, -325.846454, -326.231842,
    -326.296795, -326.627510, -327.198851, -327.425822, -326.490970,
    -326.447657, -326.104062, -324.923718, -325.205274, -325.436504,
    -325.062831, -325.518112, -325.070517, -325.173497, -324.951808,
    -325.257115, -324.942363, -324.605587, -325.618147, -325.677293,
    -325.128173, -325.111191, -325.308720, -326.244433, -326.225663,
    -326.410039, -326.507294, -325.169739, -324.673777, -325.488867,
    -325.354535, -325.417806, -325.660530, -326.333252, -326.327987,
    -326.497447, -327.622140, -327.228458, -327.028448, -327.270101,
    -327.914226, -328.132491, -328.219355, -327.918463, -328.048666,
    -327.260230, -327.460676, -328.044739, -328.455269, -328.440923,
    -328.554835, -328.783135, -329.632431, -329.754025, -330.494725,
    -330.768762, -331.125487, -331.039374, -330.800821, -330.676561,
    -330.142616, -329.230868, -328.993644, -329.119721, -329.068873,
    -328.852055, -329.242691, -329.428254, -330.180546, -329.683181,
    -330.050422, -329.196774, -329.983511, -330.017795, -330.358370,
    -329.977352, -329.929518, -329.936691, -329.494224, -329.879125,
    -329.285518, -329.771972, -329.270491, -329.340129, -329.932363,
    -329.525289, -328.442502, -328.947140, -328.704386, -329.483155,
    -328.756708, -328.838384, -328.444215, -328.582800, -328.238551,
    -328.175324, -327.642865, -326.677689, -327.002947, -327.308614,
    -327.593131, -327.615155, -327.632700, -327.643735, -326.929971,
    -326.979722, -326.062989, -326.396717, -326.928531, -326.691341,
    -326.690900, -326.669925, -327.099210, -327.939074, -327.742578,
    -328.467085, -328.629620, -328.739760, -329.032406, -329.489664,
    -329.163979, -329.278261, -329.562573, -329.536907, -329.686322,
    -329.301228, -329.575768, -330.223778, -330.292376, -330.513260,
    -331.100148, -331.562513};

static const std::vector<float> PRED_STATE_1 = {
    0.000000,     -5.127220,    -5.033268,    -5.034390,    -4.923627,
    -4.763779,    -4.635866,    -4.451609,    -4.152887,    -3.888907,
    -3.666836,    -3.431618,    -3.049169,    -2.573838,    -1.996851,
    -1.471193,    -0.749095,    0.096940,     1.075513,     2.296776,
    3.671140,     5.092144,     6.555432,     8.306192,     10.097067,
    12.332769,    15.322689,    18.506321,    21.879293,    25.273524,
    29.009463,    33.086946,    37.503113,    41.880119,    46.773510,
    52.773367,    58.058244,    64.050650,    70.529216,    77.478806,
    85.328800,    92.691538,    101.171656,   110.744732,   119.933994,
    128.963981,   138.063418,   147.462595,   157.391677,   167.562341,
    177.949803,   188.002409,   199.576718,   211.804079,   223.559202,
    235.112956,   247.006720,   259.212309,   271.981878,   284.715140,
    298.813583,   312.212282,   325.783279,   340.079937,   353.610168,
    367.554928,   381.590384,   396.577747,   410.989106,   426.018287,
    440.734498,   456.923596,   472.114797,   488.139086,   504.643122,
    520.987784,   536.261997,   551.718519,   567.944561,   584.586006,
    601.304969,   618.086062,   636.757588,   653.823993,   671.207373,
    689.189948,   706.489672,   724.063200,   742.509233,   760.211112,
    778.761512,   796.852053,   816.068189,   834.766046,   853.594113,
    872.536087,   891.893599,   911.635721,   931.095718,   950.598345,
    970.772071,   990.290918,   1010.465139,  1031.574166,  1050.657117,
    1071.043850,  1091.363413,  1112.260577,  1133.372328,  1154.679574,
    1177.144850,  1198.406019,  1218.846970,  1240.806149,  1262.550254,
    1285.073067,  1306.342646,  1328.075023,  1349.908283,  1371.832315,
    1394.836690,  1418.191172,  1441.534374,  1465.533782,  1489.136997,
    1511.684152,  1534.917585,  1558.796690,  1582.942912,  1606.313828,
    1630.653404,  1655.564958,  1679.982798,  1704.616625,  1729.450993,
    1753.433794,  1778.338298,  1803.072064,  1827.987686,  1853.072399,
    1878.314165,  1905.105379,  1931.250610,  1956.780815,  1982.430967,
    2008.902669,  2035.794310,  2062.725462,  2089.690857,  2116.685701,
    2143.347530,  2169.690787,  2197.175893,  2224.293019,  2251.786318,
    2279.635749,  2307.454912,  2333.781051,  2360.525435,  2388.034673,
    2414.794124,  2441.952355,  2468.747317,  2494.457153,  2521.373622,
    2548.315797,  2574.535655,  2600.447429,  2627.576335,  2653.219609,
    2678.970718,  2705.207409,  2730.767438,  2757.214022,  2782.594651,
    2808.501863,  2832.991858,  2858.454022,  2881.372319,  2907.297687,
    2931.427439,  2954.639023,  2979.325459,  3002.681859,  3026.352254,
    3049.542398,  3073.465470,  3096.907617,  3121.484536,  3144.763646,
    3168.014702,  3190.450047,  3213.718316,  3236.183760,  3259.100822,
    3281.650826,  3303.459876,  3325.786689,  3347.805132,  3369.947437,
    3392.215257,  3415.021760,  3435.893280,  3456.170870,  3477.950957,
    3499.518866,  3520.070205,  3540.082473,  3560.839468,  3581.482615,
    3602.027688,  3622.909379,  3644.538544,  3665.628745,  3685.797115,
    3706.788896,  3726.882980,  3747.828959,  3767.897277,  3788.418914,
    3807.677013,  3829.594717,  3850.187032,  3871.250714,  3891.051115,
    3910.527025,  3930.570286,  3951.162878,  3970.982422,  3990.082167,
    4009.816693,  4029.727545,  4049.816362,  4070.962511,  4088.720054,
    4108.566352,  4128.637586,  4149.817057,  4169.834977,  4188.318630,
    4207.587743,  4228.951964,  4246.936869,  4264.870994,  4284.117173,
    4302.814587,  4323.259608,  4342.654105,  4361.516643,  4381.703172,
    4401.785165,  4420.407959,  4439.030631,  4458.121016,  4477.204242,
    4495.369231,  4514.980899,  4535.047576,  4552.773208,  4569.684278,
    4587.227727,  4606.312972,  4624.533921,  4644.284787,  4661.740772,
    4680.790330,  4699.946637,  4719.684499,  4738.087522,  4754.762900,
    4774.081782,  4793.535091,  4813.123283,  4831.411099,  4849.434462,
    4867.694490,  4886.668199,  4905.843582,  4923.285836,  4941.028505,
    4960.520148,  4979.244366,  4998.224082,  5018.428655,  5037.841098,
    5056.020809,  5074.020824,  5092.351489,  5111.001356,  5128.973000,
    5145.815167,  5163.082557,  5181.256495,  5197.312776,  5214.858845,
    5232.825326,  5250.696259,  5268.484196,  5286.702633,  5302.818985,
    5320.480287,  5339.108294,  5356.125802,  5373.653911,  5392.181648,
    5408.605527,  5426.105570,  5442.075594,  5459.164326,  5476.807541,
    5493.439308,  5512.210395,  5529.915843,  5548.687750,  5564.844734,
    5582.167588,  5597.481713,  5615.587881,  5631.646667,  5649.958367,
    5667.262814,  5683.095480,  5699.643905,  5717.404956,  5734.205887,
    5751.692142,  5768.771974,  5786.003580,  5804.449152,  5821.381978,
    5839.024266,  5855.203048,  5873.756042,  5890.798793,  5907.494094,
    5922.788591,  5938.383532,  5952.108537,  5967.857713,  5985.534450,
    5999.602478,  6016.795821,  6032.043422,  6050.377802,  6064.515102,
    6079.624152,  6095.660207,  6110.928268,  6127.129629,  6144.772991,
    6159.909582,  6176.561419,  6191.319294,  6207.072239,  6222.100947,
    6237.008834,  6252.366490,  6267.595857,  6283.832751,  6298.778473,
    6315.324969,  6331.696927,  6345.648410,  6360.710610,  6376.831223,
    6391.684649,  6405.346133,  6420.733983,  6435.477686,  6449.046300,
    6464.371918,  6480.794069,  6497.106917,  6512.168237,  6526.626148,
    6541.675259,  6556.709650,  6571.734253,  6587.336060,  6602.906844,
    6619.035178,  6635.695587,  6649.935566,  6663.063602,  6676.904854,
    6691.427731,  6705.423133,  6717.159338,  6730.892516,  6744.158334,
    6758.765540,  6771.680487,  6785.970018,  6799.779565,  6813.737039,
    6827.839792,  6841.486800,  6856.504661,  6871.624792,  6884.439801,
    6899.895793,  6914.837604,  6927.486474,  6939.785048,  6952.969546,
    6966.998434,  6980.615491,  6993.848382,  7009.161179,  7020.949410,
    7034.299326,  7049.134170,  7062.308528,  7075.760058,  7087.633619,
    7103.567243,  7117.167958,  7131.660718,  7144.521801,  7158.945387,
    7171.744324,  7183.012853,  7196.574833,  7207.945903,  7220.371612,
    7234.428786,  7245.645773,  7260.457803,  7274.272266,  7286.517357,
    7298.543603,  7311.631216,  7325.727639,  7338.246624,  7351.181295,
    7364.513329,  7378.224904,  7391.661727,  7404.203329,  7414.626086,
    7425.606652,  7438.403881,  7450.357573,  7463.444751,  7473.107391,
    7487.911142,  7499.187466,  7512.952168,  7525.836848,  7539.838510,
    7551.649872,  7563.345429,  7576.890654,  7590.230632,  7602.072722,
    7613.810632,  7628.734101,  7640.759488,  7653.336078,  7666.438509,
    7680.041031,  7692.137270,  7704.795375,  7716.665176,  7727.793086,
    7740.214303,  7751.868738,  7763.467144,  7777.017823,  7787.076760,
    7799.182997,  7808.548585,  7820.683456,  7833.431777,  7844.746081,
    7855.381712,  7866.726685,  7877.397423,  7887.435960,  7899.585262,
    7911.703601,  7923.118004,  7935.228066,  7945.958221,  7958.110790,
    7968.202989,  7979.764411,  7990.668388,  8000.954185,  8013.401950,
    8024.463839,  8036.282102,  8046.064581,  8053.930668,  8067.575267,
    8079.776652,  8092.000777,  8104.942649,  8114.400250,  8124.734557,
    8135.208078,  8145.817436,  8157.255349,  8168.782144,  8179.696340,
    8190.034027,  8200.530603,  8210.479530,  8221.320192,  8230.897162,
    8240.691754,  8251.401837,  8261.567926,  8271.930331,  8282.482080,
    8292.507692,  8302.039034,  8309.689489,  8319.117921,  8330.946744,
    8340.055937,  8350.166824,  8360.513755,  8371.802592,  8382.551799,
    8392.074996,  8403.315805,  8414.744315,  8424.911015,  8433.168605,
    8443.954351,  8454.966190,  8461.856884,  8472.090605,  8481.142794,
    8491.258684,  8500.203569,  8511.684895,  8524.109891,  8533.773539,
    8544.484590,  8556.189992,  8565.172448,  8573.783379,  8583.515086,
    8593.575535,  8604.685395,  8614.577350,  8624.795447,  8634.586097,
    8642.498272,  8653.077567,  8662.475813,  8674.472782,  8683.722069,
    8692.609916,  8699.673410,  8709.483257,  8719.657158,  8729.428879,
    8739.571646,  8747.821940,  8756.533529,  8764.185670,  8775.345877,
    8783.055379,  8792.776331,  8800.634452,  8809.751020,  8819.306880,
    8830.794325,  8838.049313,  8848.126555,  8856.322818,  8863.505382,
    8872.011146,  8881.013278,  8888.202233,  8896.728817,  8901.951384,
    8910.155577,  8919.659022,  8925.802683,  8934.132458,  8943.769260,
    8950.804034,  8960.761432,  8969.636193,  8982.894441,  8989.476344,
    8996.707781,  9004.556214,  9011.446617,  9022.081702,  9031.603436,
    9039.298920,  9049.155562,  9054.838192,  9065.136091,  9072.786712,
    9081.058227,  9089.138940,  9098.605169,  9106.252835,  9116.884266,
    9126.413159,  9133.332880,  9140.145807,  9147.648057,  9154.231992,
    9163.889318,  9172.509210,  9179.361433,  9186.127287,  9195.977706,
    9203.993287,  9213.448871,  9221.884202,  9227.770792,  9236.017621,
    9244.113907,  9252.067993,  9258.298887,  9264.497227,  9273.864301,
    9282.229239,  9290.448717,  9298.532727,  9306.490844,  9313.529196,
    9321.306661,  9329.784885,  9337.317298,  9341.548376,  9349.100950,
    9356.574365,  9362.361484,  9368.173725,  9374.820525,  9383.070249,
    9388.786707,  9395.353321,  9399.487125,  9404.567741,  9410.549061,
    9417.385271,  9425.847588,  9430.147508,  9438.665363,  9444.643846,
    9450.676620,  9460.035501,  9465.988480,  9472.820530,  9480.486816,
    9487.301497,  9494.134064,  9498.524487,  9503.895250,  9514.317253,
    9521.264732,  9525.762842,  9532.893744,  9538.390846,  9547.304884,
    9552.003671,  9556.861061,  9559.395255,  9565.525192,  9571.747603,
    9578.889121,  9583.579154,  9590.108809,  9596.716890,  9602.568390,
    9610.206777,  9618.701553,  9624.663319,  9628.238904,  9634.572251,
    9641.843538,  9648.327636,  9654.908074,  9659.067457,  9667.651288,
    9672.020441,  9675.772696,  9679.784053,  9684.885248,  9689.338154,
    9694.864649,  9700.565205,  9708.965607,  9714.846446,  9719.196163,
    9724.636105,  9730.263482,  9736.916430,  9743.691964,  9749.735614,
    9755.089417,  9761.490932,  9768.033858,  9773.860575,  9778.162731,
    9783.579277,  9788.348175,  9793.360032,  9797.750957,  9800.706554,
    9806.574073,  9812.633912,  9817.167093,  9821.970402,  9824.468878,
    9829.923689,  9834.749736,  9838.984161,  9846.094379,  9850.767628,
    9856.578288,  9862.605986,  9865.398864,  9875.477180,  9882.077362,
    9887.987212,  9891.521431,  9896.265856,  9899.567123,  9904.097613,
    9908.064124,  9914.095343,  9916.885468,  9925.281671,  9931.161443,
    9933.803370,  9939.462328,  9943.632191,  9949.003663,  9951.167694,
    9953.782268,  9958.564838,  9963.657167,  9966.431925,  9973.994743,
    9979.094626,  9982.745785,  9985.033400,  9990.400458,  9996.932938,
    10002.813147, 10008.077308, 10015.390120, 10017.623495, 10019.448303,
    10024.396422, 10029.663378, 10036.118404, 10039.291073, 10042.883930,
    10045.999464, 10049.543039, 10052.616689, 10057.899756, 10060.854059,
    10066.902816, 10071.456895, 10074.612668, 10076.440031, 10077.905118,
    10079.919940, 10083.332922, 10086.303958, 10090.634759, 10094.474799,
    10096.965785, 10098.186707, 10103.525493, 10109.211513, 10114.336748,
    10118.045110, 10120.417772, 10124.194568, 10127.522888, 10130.429622,
    10131.166216, 10133.408692, 10134.413233, 10139.599978, 10142.487367,
    10144.992844, 10147.140278, 10150.738385, 10158.390539, 10161.810666,
    10163.934443, 10164.826319, 10166.357126, 10170.268514, 10173.753437,
    10176.836771, 10180.441040, 10184.537445, 10187.301017, 10192.402899,
    10195.216887, 10198.569342, 10200.633507, 10201.484458, 10202.093074,
    10206.071434, 10207.837721, 10212.012259, 10219.368639, 10222.511480,
    10226.183700, 10227.659826, 10231.559558, 10234.151594, 10235.511151,
    10236.609277, 10238.362499, 10240.736180, 10241.001088, 10246.491747,
    10251.496579, 10252.424120, 10254.034752, 10254.472355, 10256.525383,
    10258.295839, 10262.520190, 10265.430449, 10264.394235, 10265.065321,
    10267.350603, 10267.543116, 10270.291771, 10272.734366, 10274.889082,
    10276.773403, 10279.302712, 10279.734196, 10281.806607, 10281.811458,
    10282.587661, 10285.902939, 10287.075124, 10289.867161, 10291.457888,
    10291.916695, 10294.040292, 10297.735571, 10301.092798, 10302.310428,
    10303.331046, 10308.729054, 10310.951680, 10313.829947, 10312.776855,
    10315.298555, 10318.474949, 10317.695880, 10318.659899, 10321.281997,
    10323.637218, 10324.819514, 10323.998157, 10323.110240, 10323.983563,
    10327.441954, 10331.518271, 10331.591632, 10329.733463, 10330.619124,
    10332.264207, 10332.806707, 10334.130866, 10334.373756, 10335.418723,
    10337.221875, 10336.089632, 10338.595494, 10338.129781, 10337.604569,
    10336.105037, 10339.184343, 10338.358928, 10336.582446, 10336.665727,
    10336.674700, 10337.525744, 10339.183852, 10340.682262, 10342.940230,
    10341.353061, 10342.534274, 10339.924398, 10341.067790, 10343.921877,
    10344.725937, 10344.506554, 10346.076267, 10348.424061, 10349.662290,
    10352.606483, 10351.664661, 10351.643009, 10349.738761, 10350.634774,
    10348.691084, 10346.813252, 10348.664050, 10349.448390, 10352.900963,
    10356.115796, 10360.025165, 10359.991268, 10358.080882, 10359.897627,
    10361.567774, 10360.357729, 10362.836781, 10364.211146, 10365.464186,
    10365.692622, 10366.775274, 10365.012737, 10365.141628, 10366.134997,
    10363.371561, 10363.483207, 10359.893543, 10359.220895, 10359.482664,
    10358.784211, 10357.193025, 10354.751111, 10353.353147, 10355.684118,
    10355.116387, 10355.489094, 10357.659512, 10354.199193, 10356.418757,
    10356.670528, 10355.975985, 10355.311481, 10356.508154, 10357.628893,
    10355.936041, 10352.501121, 10351.089911, 10349.759239, 10346.675466,
    10347.435715, 10345.407365, 10346.255983, 10344.313313, 10345.244913,
    10344.303853, 10344.338561, 10342.552985, 10340.883635, 10340.247591,
    10336.003627, 10332.023371, 10331.038220, 10329.229213, 10322.993909,
    10321.712126, 10322.375910, 10323.953167, 10321.829084, 10322.607469,
    10324.292061, 10320.436983, 10316.841923, 10313.496386, 10312.221388,
    10311.069985, 10310.946174, 10309.971761, 10310.015412, 10306.457977,
    10303.157794, 10302.845115, 10301.688541, 10301.579170, 10299.704768,
    10298.907848, 10297.307972, 10294.951717, 10290.973982, 10290.930147,
    10287.317757, 10283.981652, 10282.729373, 10281.623998, 10281.567581,
    10281.590035, 10281.685867, 10279.119927, 10277.684406, 10276.406259,
    10272.558601, 10271.727085, 10271.022861, 10269.528486, 10269.109123,
    10266.074960, 10262.384639, 10261.706946, 10259.344359, 10254.483622,
    10251.797422, 10247.547879, 10243.635585, 10241.853397, 10240.273230,
    10237.974124, 10235.907874, 10234.972241, 10232.384442, 10233.664884,
    10227.752136, 10224.987705, 10223.387050, 10221.087538, 10219.926831,
    10216.234578, 10213.762095, 10209.745984, 10205.175021, 10202.779977,
    10200.641860, 10198.746799, 10194.385636, 10191.295215, 10188.506952,
    10186.903683, 10187.316926, 10186.035847, 10183.155476, 10177.868860,
    10173.910449, 10169.410739, 10166.200699, 10161.513408, 10159.029975,
    10157.728070, 10154.844416, 10150.480753, 10147.396501, 10141.960523,
    10137.869901, 10136.848302, 10131.566585, 10130.310779, 10123.934928,
    10119.853557, 10117.063586, 10113.695584, 10108.009063, 10108.169378,
    10104.914454, 10102.896911, 10099.384816, 10096.238292, 10091.651794,
    10084.844766, 10081.248362, 10080.705431, 10079.480934, 10075.825889,
    10071.664601, 10068.801997, 10064.514832, 10059.761380, 10055.457749,
    10051.580540, 10044.569660, 10038.144692, 10034.040095, 10027.724554,
    10027.266477, 10027.031740, 10021.703930, 10019.512848, 10014.115580,
    10010.985220, 10008.230962, 10001.440734, 9995.237524,  9990.467919,
    9986.177235,  9981.464041,  9975.475996,  9970.042455,  9966.888787,
    9965.008076,  9960.821143,  9956.214341,  9951.214110,  9944.972293,
    9941.928037,  9938.407338,  9933.564793,  9927.481297,  9924.585407,
    9920.338922,  9916.562682,  9912.360306,  9906.887646,  9899.355428,
    9894.221833,  9891.355601,  9888.021876,  9886.854772,  9883.382701,
    9877.742308,  9872.658565,  9869.834058,  9864.811013,  9861.176318,
    9853.670370,  9850.284996,  9843.882785,  9838.089308,  9833.734756,
    9830.738465,  9824.715121,  9819.283471,  9814.411933,  9809.211216,
    9803.701369,  9797.046307,  9792.742131,  9786.371666,  9784.054345,
    9782.129760,  9777.143605,  9771.843760,  9768.816555,  9762.801289,
    9757.388034,  9749.987329,  9744.124190,  9738.861866,  9731.615224,
    9726.752789,  9719.891139,  9713.695205,  9705.587443,  9698.222490,
    9693.255650,  9688.011082,  9683.352734,  9675.022036,  9669.144474,
    9665.586560,  9657.460748,  9653.465561,  9646.621958,  9641.307570,
    9636.595089,  9629.926492,  9626.462498,  9622.654880,  9616.002349,
    9610.028885,  9602.186076,  9599.284925,  9591.827333,  9585.936004,
    9577.348153,  9570.393735,  9563.315474,  9556.956627,  9549.612965,
    9542.176591,  9537.150005,  9531.071136,  9523.173558,  9516.053111,
    9508.012133,  9499.935192,  9491.827730,  9485.348715,  9478.753729,
    9474.531529,  9465.941533,  9459.832438,  9454.417949,  9447.189330,
    9442.366325,  9435.698092,  9429.758365,  9423.685197,  9416.667704,
    9412.862496,  9407.163098,  9401.318910,  9393.704920,  9389.328029,
    9381.466962,  9375.221094,  9368.054345,  9361.650350,  9355.152378,
    9351.009788,  9342.581347,  9337.424764,  9331.294939,  9322.630788,
    9313.203028,  9307.100412,  9297.672463,  9289.149032,  9281.482142,
    9275.431872,  9267.683402,  9261.556977,  9256.155718,  9248.222207,
    9239.513305,  9232.481581,  9225.429574,  9217.560933,  9208.926000,
    9201.967509,  9194.196160,  9185.661859,  9178.802378,  9171.133976,
    9165.888682,  9158.947186,  9152.000511,  9142.671132,  9133.477701,
    9128.377553,  9121.589397,  9112.426206,  9106.555463,  9099.051822,
    9093.167204,  9086.441124,  9077.352621,  9069.185323,  9062.675022,
    9054.585169,  9047.363364,  9038.611221,  9032.333769,  9024.476733,
    9019.042219,  9012.763791,  9005.689521,  8996.310857,  8986.322681,
    8977.318110,  8969.244198,  8960.498324,  8951.122871,  8941.158574,
    8932.961531,  8924.888734,  8916.162045,  8908.364999,  8900.674736,
    8892.315820,  8883.330844,  8873.759605,  8867.478081,  8859.690446,
    8852.020149,  8841.402432,  8834.126037,  8826.179326,  8819.130700,
    8811.402595,  8804.560209,  8793.228458,  8783.748597,  8774.501236,
    8765.475409,  8757.419133,  8748.006826,  8738.833500,  8729.887604,
    8719.650808,  8710.461532,  8702.262498,  8692.741715,  8681.980526,
    8674.556913,  8666.528453,  8657.931808,  8650.299124,  8643.575708,
    8633.970030,  8626.132972,  8616.234940,  8608.867125,  8599.418115,
    8591.728924,  8582.727716,  8573.975280,  8566.201230,  8556.389249,
    8547.617301,  8538.350006,  8530.094310,  8519.111380,  8508.504645,
    8499.727743,  8490.472607,  8480.037268,  8469.959490,  8461.684077,
    8455.110410,  8444.291549,  8433.857306,  8425.246757,  8413.989473,
    8405.330712,  8396.943615,  8388.812772,  8379.474208,  8369.001706,
    8358.910816,  8348.460802,  8338.396563,  8330.140445,  8322.147690,
    8311.526068,  8301.306432,  8290.035989,  8279.211571,  8270.241520,
    8259.446468,  8250.505784,  8242.600676,  8232.817735,  8221.273239,
    8210.914707,  8198.840259,  8189.404708,  8179.625222,  8169.524504,
    8160.537051,  8151.187305,  8140.089107,  8128.756394,  8118.612225,
    8109.590812,  8098.120785,  8089.954240,  8082.098554,  8070.339653,
    8059.797718,  8051.104100,  8040.666402,  8029.981313,  8021.152892,
    8012.683541,  8004.553100,  7992.584759,  7981.849608,  7970.897772,
    7963.198994,  7952.351443,  7942.677203,  7932.045912,  7921.890516,
    7909.443785,  7897.582238,  7884.910830,  7875.578496,  7864.614663,
    7854.162790,  7842.834637,  7833.405937,  7822.368241,  7810.499930,
    7797.853980,  7787.860650,  7777.665670,  7766.607564,  7756.762392,
    7746.040486,  7737.187026,  7726.730758,  7715.440791,  7705.379198,
    7694.468118,  7683.427814,  7670.936131,  7659.746557,  7648.455134,
    7636.407191,  7627.635789,  7617.302248,  7606.165007,  7592.953562,
    7582.414801,  7571.757218,  7558.356079,  7546.980273,  7536.859474,
    7526.608950,  7514.270507,  7504.554130,  7492.728343,  7480.880715,
    7469.015485,  7457.788401,  7447.165620,  7437.113304,  7424.354806,
    7412.292001,  7401.535947,  7390.073876,  7378.594023,  7364.526807,
    7353.816750,  7342.414039,  7328.439883,  7315.892664,  7302.775304,
    7292.321467,  7281.183127,  7270.040919,  7259.533637,  7247.717613,
    7235.943051,  7223.576378,  7211.922294,  7201.575115,  7191.826861,
    7176.967603,  7165.487127,  7153.419089,  7141.429305,  7130.143611,
    7120.150487,  7108.867649,  7095.751711,  7084.033264,  7073.009782,
    7062.019785,  7049.819163,  7036.484417,  7024.564189,  7010.884603,
    6998.643037,  6988.378378,  6977.506189,  6964.831869,  6952.924879,
    6941.129618,  6927.602302,  6915.509992,  6902.327134,  6889.952244,
    6879.562574,  6866.777142,  6854.172694,  6841.136494,  6828.909669,
    6815.026991,  6801.402514,  6789.233370,  6776.629650,  6764.822853,
    6751.965418,  6740.523886,  6728.616402,  6716.274145,  6705.319665,
    6693.281705,  6679.036644,  6666.885487,  6654.923661,  6641.362927,
    6628.079275,  6615.651533,  6604.033305,  6590.816178,  6577.867656,
    6566.352326,  6552.072441,  6539.303406,  6526.788300,  6515.686215,
    6503.574353,  6491.683742,  6477.671174,  6465.740077,  6452.863301,
    6438.522011,  6423.965323,  6410.367534,  6398.832027,  6388.086043,
    6375.198756,  6363.177655,  6350.824884,  6336.441868,  6323.016844,
    6309.925133,  6296.008152,  6284.170686,  6272.582997,  6257.818953,
    6245.180548,  6231.144997,  6217.496038,  6204.781056,  6191.818297,
    6179.188919,  6166.312504,  6153.205855,  6140.448129,  6126.898513,
    6115.408003,  6100.824850,  6087.799782,  6074.014991,  6059.520617,
    6046.028905,  6033.484422,  6020.170725,  6004.481692,  5991.526974,
    5977.842673,  5964.575701,  5952.805422,  5939.698162,  5927.528571,
    5913.505235,  5899.382555,  5886.806914,  5874.052858,  5860.590159,
    5846.464214,  5832.801506,  5819.037799,  5805.722513,  5793.913771,
    5779.207508,  5765.548133,  5751.803774,  5736.908798,  5723.614964,
    5708.085597,  5695.800592,  5682.300319,  5667.661959,  5653.551009,
    5638.348895,  5624.244610,  5610.647416,  5597.531588,  5583.285502,
    5570.089985,  5556.304761,  5540.918583,  5525.604458,  5510.363210,
    5495.718718,  5482.684330,  5468.559575,  5452.892899,  5439.417479,
    5425.413026,  5412.468504,  5398.968679,  5385.467128,  5370.934700,
    5356.466049,  5342.062280,  5326.696084,  5310.941673,  5295.850873,
    5282.410739,  5266.445692,  5252.183505,  5239.528907,  5225.339365,
    5210.723653,  5197.228948,  5183.275583,  5168.893224,  5154.614266,
    5140.938632,  5125.323036,  5110.894685,  5097.086953,  5081.865247,
    5067.813551,  5053.370415,  5039.557400,  5022.369256,  5008.453349,
    4995.146569,  4980.930601,  4966.849022,  4953.390400,  4938.058727,
    4924.409062,  4908.908762,  4895.101558,  4879.954816,  4864.529477,
    4850.308065,  4836.736060,  4822.803735,  4809.992918,  4795.811487,
    4781.312900,  4767.001304,  4752.387595,  4738.455185,  4724.204301,
    4709.656529,  4695.312599,  4680.204707,  4664.384023,  4648.850592,
    4634.544227,  4620.443799,  4605.590093,  4590.978489,  4577.072418,
    4561.469212,  4546.160214,  4531.603323,  4515.876273,  4500.461898,
    4485.813717,  4470.485310,  4455.455859,  4439.312575,  4423.988235,
    4409.903022,  4395.593264,  4380.610874,  4365.924970,  4350.597831,
    4336.516257,  4321.764577,  4306.846213,  4290.398255,  4273.890346,
    4259.161933,  4244.283840,  4228.811117,  4215.061337,  4200.204130,
    4185.670721,  4170.084693,  4156.681320,  4141.262765,  4126.661150,
    4110.578235,  4094.905712,  4080.970727,  4065.979737,  4050.895905,
    4036.621314,  4019.541646,  4004.727415,  3989.379056,  3973.975668,
    3958.524623,  3943.475386,  3927.923006,  3912.342752,  3896.739480,
    3883.318743,  3869.315657,  3853.450644,  3838.465581,  3822.125997,
    3805.826255,  3790.439480,  3773.307788,  3757.142902,  3741.459609,
    3724.935004,  3710.215338,  3695.470691,  3680.274541,  3665.087171,
    3649.480681,  3632.628699,  3617.175587,  3601.761041,  3586.385644,
    3571.901830,  3556.133837,  3540.010392,  3524.403678,  3508.440063,
    3492.990443,  3478.027371,  3463.102344,  3446.956094,  3430.923644,
    3415.840242,  3400.397631,  3385.454724,  3369.734118,  3355.783890,
    3338.926648,  3322.246071,  3305.736285,  3288.977484,  3272.814792,
    3257.217953,  3241.333052,  3225.592250,  3209.989094,  3194.519588,
    3179.997604,  3163.917469,  3147.598765,  3131.060708,  3113.914479,
    3096.607209,  3081.985994,  3066.256149,  3050.295029,  3034.522406,
    3017.321972,  3001.994297,  2987.230081,  2971.795487,  2955.733973,
    2940.282764,  2924.214166,  2907.966367,  2892.346588,  2876.924792,
    2861.693067,  2845.456211,  2829.460428,  2813.696055,  2797.758986,
    2780.877980,  2764.680993,  2749.131283,  2731.461229,  2714.528582,
    2699.462605,  2683.046291,  2666.916214,  2650.670041,  2635.866486,
    2620.877229,  2605.328549,  2589.641974,  2574.213128,  2557.494977,
    2541.099355,  2526.541020,  2510.276323,  2495.840719,  2478.940150,
    2462.384756,  2447.675676,  2432.053744,  2416.332401,  2400.142986,
    2383.893488,  2367.966655,  2350.845307,  2334.479846,  2318.079872,
    2302.397638,  2286.275498,  2270.115144,  2254.293364,  2238.422498,
    2222.136825,  2206.205326,  2190.610388,  2174.965295,  2157.434505,
    2140.708510,  2122.909375,  2106.303260,  2090.458575,  2073.871773,
    2057.684329,  2041.148326,  2024.288720,  2007.853999,  1992.909299,
    1976.836163,  1961.148647,  1946.548045,  1930.090160,  1913.686680,
    1898.055062,  1881.360965,  1865.817274,  1849.572714,  1833.742032,
    1817.234735,  1801.517125,  1785.834503,  1768.416900,  1752.199620,
    1736.763685,  1720.653827,  1704.265336,  1686.915985,  1670.770444,
    1654.360692,  1638.055818,  1623.598453,  1608.089905,  1590.900664,
    1574.912587,  1558.671236,  1542.194527,  1525.153868,  1508.967679,
    1492.553916,  1474.899837,  1459.172353,  1443.203470,  1426.667668,
    1409.603146,  1393.068016,  1376.693931,  1360.815595,  1344.386680,
    1329.137944,  1312.632360,  1295.623766,  1278.820657,  1262.552316,
    1246.116446,  1229.527367,  1212.127681,  1195.641224,  1178.349308,
    1161.636361,  1144.806043,  1128.534535,  1112.459338,  1096.240440,
    1080.551317,  1065.362511,  1049.326171,  1032.825418,  1016.547630,
    1000.483668,  983.639613,   967.047520,   949.716511,   933.975865,
    917.130751,   901.849748,   884.472781,   868.043417,   851.215635,
    835.308016,   818.978957,   802.578379,   786.756392,   769.876851,
    754.248309,   737.240288,   721.492692,   705.020266,   687.869684,
    671.991269,   656.995317,   639.978916,   623.912288,   606.532364,
    591.072911,   574.589264,   558.716710,   542.166387,   526.234719,
    509.949038,   494.270278,   479.164626,   462.419566,   445.690431,
    428.979670,   412.599407,   396.223827,   379.855680,   364.422632,
    348.023473,   332.870664,   316.128990,   299.122210,   283.093322,
    266.765268,   250.463638,   233.581112,   216.156169,   200.045355,
    182.750324,   166.159919,   149.631829,   132.864179,   115.874871,
    99.882662,    83.330530,    66.554693,    50.170106,    33.559143,
    17.633116,    0.865221,     -16.393582,   -32.923566,   -49.653326,
    -66.863144,   -83.930071};

static const std::vector<float> PRED_OUT = PRED_STATE_3;

}  // namespace Boardcore
