/* Copyright (c) 2021 Skyward Experimental Rocketry
 * Author: Luca Conterio
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 * This data was obtained from the accelerometer LIS3DSH on March 2021
 * on the 6 different orientation
 */

#pragma once

#include <sensors/SensorData.h>
#include <sensors/calibration/Calibration.h>

namespace Boardcore
{

namespace accData
{
constexpr unsigned nOrientations = 6;
constexpr unsigned nSamples      = 60;

AxisOrthoOrientation orientations[nOrientations]{
    {Direction::POSITIVE_X, Direction::POSITIVE_Y},
    {Direction::POSITIVE_Y, Direction::POSITIVE_Z},
    {Direction::POSITIVE_Z, Direction::POSITIVE_X},
    {Direction::POSITIVE_Y, Direction::POSITIVE_X},
    {Direction::POSITIVE_Z, Direction::POSITIVE_Y},
    {Direction::POSITIVE_X, Direction::POSITIVE_Z},
};

AccelerometerData samples[nOrientations][nSamples] = {

    /* --------------------------  1  ------------------------ */

    {
        {0, -0.009180, 0.013140, 0.998820},
        {0, -0.009720, 0.007560, 0.991440},
        {0, -0.011700, 0.011340, 0.990720},
        {0, -0.020520, 0.027000, 0.990000},
        {0, -0.009540, 0.010080, 0.990360},
        {0, -0.008460, 0.005760, 0.995220},
        {0, -0.016920, 0.019440, 0.995580},
        {0, -0.015480, 0.007560, 0.992520},
        {0, -0.009180, 0.003060, 0.994320},
        {0, -0.010620, 0.007920, 0.994860},
        {0, -0.011520, 0.011880, 0.998280},
        {0, -0.011520, 0.001620, 0.998640},
        {0, 0.003780, 0.030600, 0.992340},
        {0, -0.008640, 0.003420, 0.992160},
        {0, -0.012240, 0.014220, 0.995220},
        {0, -0.008100, 0.007020, 0.997380},
        {0, -0.006480, 0.009540, 0.993960},
        {0, -0.017460, 0.005760, 0.992520},
        {0, -0.000360, -0.005220, 1.000260},
        {0, -0.019260, 0.010080, 0.996480},
        {0, -0.011520, 0.008820, 0.995040},
        {0, -0.014040, 0.013680, 0.991980},
        {0, -0.009180, 0.000000, 1.002420},
        {0, -0.004320, 0.000900, 0.997560},
        {0, -0.018180, 0.010260, 0.999000},
        {0, -0.003420, 0.002700, 0.997740},
        {0, -0.015660, 0.015660, 0.996300},
        {0, -0.007920, 0.003060, 0.996300},
        {0, -0.017820, 0.013860, 0.993060},
        {0, -0.023040, 0.018900, 0.995040},
        {0, -0.004320, 0.001620, 0.998100},
        {0, -0.008280, 0.006120, 0.995580},
        {0, -0.012240, 0.008100, 0.996300},
        {0, -0.004860, 0.008820, 0.996480},
        {0, -0.005400, 0.005760, 0.999360},
        {0, -0.008460, 0.007740, 0.997200},
        {0, -0.011160, 0.010080, 0.996840},
        {0, -0.006840, 0.005220, 0.994860},
        {0, -0.012600, 0.008100, 0.994500},
        {0, -0.002520, -0.006840, 0.994680},
        {0, -0.016200, 0.010440, 0.997020},
        {0, -0.009720, 0.008640, 0.992880},
        {0, -0.017280, 0.012960, 1.000080},
        {0, -0.010080, 0.005220, 0.995940},
        {0, -0.012240, 0.010800, 0.999540},
        {0, -0.012780, 0.012600, 0.996840},
        {0, -0.012960, 0.012420, 1.001340},
        {0, -0.011700, 0.015480, 0.998280},
        {0, -0.009180, 0.007740, 0.995760},
        {0, -0.008820, 0.020520, 0.995040},
        {0, -0.014760, 0.012780, 0.996840},
        {0, -0.009900, 0.009540, 0.991620},
        {0, -0.014220, 0.011520, 0.995400},
        {0, -0.003060, 0.011700, 0.992160},
        {0, -0.015480, 0.006660, 0.995940},
        {0, -0.017820, 0.005220, 0.998280},
        {0, -0.014040, 0.009540, 0.995580},
        {0, -0.012060, 0.006840, 0.999900},
        {0, -0.007740, 0.004680, 0.994860},
        {0, -0.012420, 0.011700, 0.991260},
    },

    /* --------------------------  2  ------------------------ */

    {
        {0, 0.003780, 1.038960, 0.043020},  {0, 0.011160, 1.036800, 0.026820},
        {0, 0.005220, 1.038960, 0.028980},  {0, 0.005040, 1.036260, 0.007020},
        {0, 0.012600, 1.040940, 0.021780},  {0, 0.005400, 1.042920, 0.002700},
        {0, 0.020520, 1.039140, 0.010440},  {0, 0.007920, 1.041300, -0.001440},
        {0, 0.006120, 1.036260, 0.012600},  {0, 0.002520, 1.041120, 0.027900},
        {0, 0.009540, 1.041840, 0.021420},  {0, 0.005580, 1.037520, 0.011520},
        {0, -0.041940, 1.025100, 0.018720}, {0, 0.005040, 1.040580, 0.022140},
        {0, 0.010980, 1.036440, 0.014400},  {0, 0.007200, 1.040040, 0.018720},
        {0, 0.006840, 1.040940, 0.020340},  {0, 0.007380, 1.038960, 0.026640},
        {0, 0.009000, 1.043820, 0.028980},  {0, 0.006660, 1.039500, 0.027180},
        {0, 0.009540, 1.040400, 0.020520},  {0, 0.008460, 1.039680, 0.022680},
        {0, 0.012420, 1.044540, 0.032040},  {0, 0.010800, 1.038600, 0.022680},
        {0, 0.003960, 1.036980, 0.019440},  {0, 0.007560, 1.039860, 0.017460},
        {0, 0.007020, 1.042740, 0.011340},  {0, 0.004680, 1.039140, 0.009000},
        {0, 0.007380, 1.041120, 0.018900},  {0, 0.005580, 1.042380, 0.026820},
        {0, 0.012240, 1.039140, 0.019800},  {0, 0.010260, 1.038780, 0.004140},
        {0, 0.007740, 1.041120, 0.016740},  {0, 0.002880, 1.038960, 0.016740},
        {0, 0.003960, 1.040760, 0.026820},  {0, 0.009000, 1.040580, 0.021600},
        {0, 0.007920, 1.035720, 0.020880},  {0, 0.004680, 1.041840, 0.021600},
        {0, 0.004140, 1.036440, 0.010980},  {0, 0.010260, 1.038420, 0.015480},
        {0, 0.014040, 1.036980, 0.018540},  {0, 0.009900, 1.036620, 0.018000},
        {0, 0.009000, 1.035900, 0.018540},  {0, 0.009180, 1.038780, 0.023760},
        {0, 0.011340, 1.041840, 0.019620},  {0, 0.004320, 1.036440, 0.009360},
        {0, 0.008280, 1.036980, 0.014940},  {0, 0.007020, 1.036620, 0.011340},
        {0, 0.005940, 1.035000, 0.024300},  {0, 0.005220, 1.041840, 0.023220},
        {0, 0.009720, 1.037340, 0.032220},  {0, 0.007380, 1.036260, 0.036900},
        {0, 0.008640, 1.035720, 0.020160},  {0, 0.009000, 1.042200, 0.014760},
        {0, 0.011880, 1.038960, 0.015840},  {0, 0.004140, 1.033560, 0.016200},
        {0, 0.011880, 1.040760, 0.007200},  {0, 0.004860, 1.039140, 0.021780},
        {0, 0.006660, 1.038960, 0.008820},  {0, 0.009360, 1.039680, 0.017100},
    },

    /* --------------------------  3  ------------------------ */

    {
        {0, 1.026180, 0.020340, -0.035100}, {0, 1.026900, 0.021240, -0.037080},
        {0, 1.024920, 0.022140, -0.032580}, {0, 1.024200, 0.013320, -0.039420},
        {0, 1.022400, 0.018720, -0.033120}, {0, 1.025640, 0.016740, -0.046080},
        {0, 1.027260, 0.018720, -0.044100}, {0, 1.025100, 0.024300, -0.040680},
        {0, 1.026000, 0.024480, -0.041940}, {0, 1.025100, 0.021240, -0.049860},
        {0, 1.023840, 0.018540, -0.044280}, {0, 1.024200, 0.020520, -0.036900},
        {0, 1.025460, 0.019080, -0.045540}, {0, 1.024920, 0.025200, -0.043020},
        {0, 1.022040, 0.018000, -0.045540}, {0, 1.025820, 0.018540, -0.045540},
        {0, 1.024200, 0.014040, -0.043380}, {0, 1.027440, 0.021780, -0.044820},
        {0, 1.026900, 0.021600, -0.047880}, {0, 1.024020, 0.021420, -0.043740},
        {0, 1.020600, 0.021240, -0.043920}, {0, 1.023120, 0.017280, -0.055080},
        {0, 1.023480, 0.019440, -0.058680}, {0, 1.026900, 0.021420, -0.041580},
        {0, 1.026720, 0.019260, -0.045000}, {0, 1.021500, 0.021240, -0.040500},
        {0, 1.025280, 0.024300, -0.040680}, {0, 1.029600, 0.016200, -0.047340},
        {0, 1.024560, 0.020160, -0.024660}, {0, 1.030860, 0.021600, -0.041580},
        {0, 1.028700, 0.023040, -0.039960}, {0, 1.024560, 0.019080, -0.037980},
        {0, 1.027800, 0.021240, -0.051480}, {0, 1.029060, 0.022320, -0.061380},
        {0, 1.024560, 0.021780, -0.053100}, {0, 1.027080, 0.018000, -0.055800},
        {0, 1.023300, 0.018900, -0.056700}, {0, 1.024380, 0.017280, -0.059220},
        {0, 1.025640, 0.018540, -0.062820}, {0, 1.029240, 0.022680, -0.046080},
        {0, 1.023300, 0.019440, -0.061020}, {0, 1.024740, 0.018360, -0.068220},
        {0, 1.026000, 0.025920, -0.054540}, {0, 1.023120, 0.020160, -0.054900},
        {0, 1.028160, 0.019980, -0.063000}, {0, 1.026000, 0.017280, -0.054360},
        {0, 1.024920, 0.022680, -0.050220}, {0, 1.023120, 0.017820, -0.058860},
        {0, 1.028520, 0.026460, -0.047160}, {0, 1.021860, 0.019080, -0.053640},
        {0, 1.033380, 0.019080, -0.057780}, {0, 1.023120, 0.020880, -0.050400},
        {0, 1.022580, 0.020160, -0.058500}, {0, 1.024560, 0.019080, -0.049320},
        {0, 1.027980, 0.022500, -0.052380}, {0, 1.026180, 0.021060, -0.053100},
        {0, 1.028340, 0.019980, -0.053280}, {0, 1.025280, 0.018900, -0.054540},
        {0, 1.023660, 0.021420, -0.039420}, {0, 1.023300, 0.021600, -0.048600},
    },

    /* --------------------------  4  ------------------------ */

    {
        {0, 0.009180, 0.021420, -1.006920}, {0, 0.007920, 0.017280, -1.005300},
        {0, 0.004500, 0.019260, -1.013040}, {0, 0.012600, 0.022500, -1.006920},
        {0, 0.006480, 0.021060, -1.008180}, {0, 0.004500, 0.012780, -1.006740},
        {0, 0.005220, 0.015300, -1.013760}, {0, 0.011520, 0.021420, -1.012320},
        {0, 0.005940, 0.016560, -1.010700}, {0, -0.008280, 0.005220, -1.010700},
        {0, 0.002880, 0.013140, -1.011600}, {0, 0.010800, 0.019800, -1.010160},
        {0, 0.010080, 0.021960, -1.005480}, {0, -0.003960, 0.008820, -1.010520},
        {0, 0.009180, 0.021060, -1.009800}, {0, 0.011160, 0.023400, -1.010880},
        {0, 0.002700, 0.017100, -1.012860}, {0, 0.005760, 0.021600, -1.009620},
        {0, 0.011160, 0.016740, -1.011060}, {0, 0.005040, 0.018360, -1.012680},
        {0, 0.009540, 0.020880, -1.009440}, {0, 0.005220, 0.018900, -1.008900},
        {0, 0.004680, 0.015840, -1.010340}, {0, 0.010440, 0.023040, -1.014300},
        {0, 0.012420, 0.021600, -1.007820}, {0, 0.008820, 0.022140, -1.006200},
        {0, 0.008460, 0.021780, -1.008540}, {0, 0.009540, 0.019980, -1.008720},
        {0, 0.012600, 0.019980, -1.010880}, {0, 0.010260, 0.019620, -1.011960},
        {0, 0.009540, 0.018000, -1.007640}, {0, 0.010440, 0.021060, -1.010160},
        {0, 0.011160, 0.018360, -1.013760}, {0, 0.008460, 0.014940, -1.003320},
        {0, 0.009720, 0.017820, -1.007280}, {0, 0.013320, 0.022860, -1.005840},
        {0, 0.004680, 0.016020, -1.007820}, {0, 0.011700, 0.020340, -1.008360},
        {0, 0.009000, 0.022500, -1.013940}, {0, 0.010080, 0.021420, -1.010880},
        {0, 0.007020, 0.021240, -1.014300}, {0, 0.010800, 0.018180, -1.010160},
        {0, 0.010260, 0.018900, -1.010520}, {0, 0.007920, 0.022500, -1.008180},
        {0, 0.006300, 0.016920, -1.008720}, {0, 0.008460, 0.019620, -1.011780},
        {0, 0.007200, 0.018720, -1.008900}, {0, 0.008460, 0.020340, -1.009620},
        {0, 0.014580, 0.023580, -1.010520}, {0, 0.007200, 0.021060, -1.008000},
        {0, 0.005400, 0.019620, -1.005480}, {0, 0.012780, 0.020520, -1.010520},
        {0, 0.009000, 0.018000, -1.009080}, {0, 0.011700, 0.024480, -1.008540},
        {0, 0.008280, 0.015480, -1.007460}, {0, 0.006840, 0.021240, -1.010160},
        {0, 0.004500, 0.015660, -1.010700}, {0, 0.014040, 0.021960, -1.007280},
        {0, 0.010260, 0.018180, -1.005840}, {0, 0.007740, 0.017280, -1.006920},
    },

    /* --------------------------  5  ------------------------ */

    {
        {0, 1.026540, 0.028800, 0.023580}, {0, 1.027800, 0.022680, 0.016560},
        {0, 1.029240, 0.021600, 0.015660}, {0, 1.027260, 0.025020, 0.012060},
        {0, 1.031220, 0.025740, 0.014400}, {0, 1.027980, 0.025020, 0.022140},
        {0, 1.026360, 0.025020, 0.019980}, {0, 1.026540, 0.024660, 0.018720},
        {0, 1.028160, 0.024480, 0.010260}, {0, 1.028520, 0.025740, 0.016200},
        {0, 1.026180, 0.027720, 0.016380}, {0, 1.031940, 0.030780, 0.015120},
        {0, 1.023660, 0.022680, 0.011880}, {0, 1.024920, 0.023580, 0.016560},
        {0, 1.027080, 0.025560, 0.012240}, {0, 1.029240, 0.022140, 0.018900},
        {0, 1.028880, 0.026100, 0.017820}, {0, 1.027260, 0.026100, 0.030240},
        {0, 1.024020, 0.026460, 0.021600}, {0, 1.029420, 0.023040, 0.015120},
        {0, 1.026900, 0.019800, 0.018360}, {0, 1.026720, 0.026280, 0.017100},
        {0, 1.028880, 0.025020, 0.013140}, {0, 1.025640, 0.023220, 0.019440},
        {0, 1.028160, 0.026460, 0.021240}, {0, 1.026180, 0.028080, 0.020160},
        {0, 1.031400, 0.034560, 0.020520}, {0, 1.026180, 0.029160, 0.020340},
        {0, 1.027980, 0.024120, 0.015300}, {0, 1.026180, 0.026100, 0.023580},
        {0, 1.029240, 0.026820, 0.015840}, {0, 1.026720, 0.026820, 0.025200},
        {0, 1.023300, 0.025560, 0.022680}, {0, 1.028880, 0.029520, 0.019980},
        {0, 1.025820, 0.028800, 0.020160}, {0, 1.025640, 0.022680, 0.025740},
        {0, 1.026720, 0.028800, 0.026100}, {0, 1.025100, 0.026640, 0.018360},
        {0, 1.022400, 0.023580, 0.020340}, {0, 1.024020, 0.026100, 0.018720},
        {0, 1.029060, 0.024300, 0.024480}, {0, 1.028520, 0.022860, 0.015480},
        {0, 1.022940, 0.023220, 0.021780}, {0, 1.026360, 0.025740, 0.020160},
        {0, 1.026900, 0.024480, 0.023580}, {0, 1.024380, 0.026640, 0.027900},
        {0, 1.024200, 0.025020, 0.027720}, {0, 1.028700, 0.024300, 0.018000},
        {0, 1.025100, 0.028800, 0.030060}, {0, 1.024380, 0.027000, 0.018180},
        {0, 1.026180, 0.027180, 0.020340}, {0, 1.020960, 0.025380, 0.030780},
        {0, 1.028520, 0.026820, 0.019440}, {0, 1.022040, 0.026640, 0.027720},
        {0, 1.028700, 0.024660, 0.019080}, {0, 1.028520, 0.030780, 0.020160},
        {0, 1.025100, 0.028980, 0.021240}, {0, 1.027440, 0.027540, 0.019260},
        {0, 1.027440, 0.027540, 0.024660}, {0, 1.028700, 0.019980, 0.024660},
    },

    /* --------------------------  6  ------------------------ */

    {
        {0, 0.023400, 1.033740, -0.036720}, {0, 0.022860, 1.035180, -0.030780},
        {0, 0.019260, 1.042200, -0.045180}, {0, 0.022500, 1.039500, -0.037260},
        {0, 0.025920, 1.035360, -0.033480}, {0, 0.022140, 1.040400, -0.035460},
        {0, 0.024660, 1.038240, -0.036900}, {0, 0.024120, 1.036440, -0.036540},
        {0, 0.019260, 1.038240, -0.032040}, {0, 0.021960, 1.038600, -0.044640},
        {0, 0.021420, 1.038960, -0.037800}, {0, 0.020340, 1.039860, -0.042300},
        {0, 0.025020, 1.040580, -0.030780}, {0, 0.025920, 1.038780, -0.039240},
        {0, 0.016560, 1.038960, -0.036000}, {0, 0.027180, 1.037520, -0.037260},
        {0, 0.022320, 1.036440, -0.039960}, {0, 0.021600, 1.038420, -0.036540},
        {0, 0.022140, 1.038420, -0.032940}, {0, 0.018720, 1.038960, -0.033300},
        {0, 0.019620, 1.035180, -0.029340}, {0, 0.033480, 1.029780, -0.025380},
        {0, 0.017460, 1.035000, -0.037620}, {0, 0.018540, 1.035720, -0.024840},
        {0, 0.023400, 1.034280, -0.028800}, {0, 0.022320, 1.035360, -0.034560},
        {0, 0.021960, 1.041840, -0.038880}, {0, 0.023940, 1.033380, -0.034020},
        {0, 0.023220, 1.036800, -0.035820}, {0, 0.023400, 1.039140, -0.042300},
        {0, 0.022140, 1.037880, -0.036900}, {0, 0.022320, 1.037880, -0.025380},
        {0, 0.023760, 1.042920, -0.038520}, {0, 0.023220, 1.043640, -0.033660},
        {0, 0.021960, 1.035540, -0.036000}, {0, 0.023400, 1.036440, -0.040140},
        {0, 0.022140, 1.039500, -0.041040}, {0, 0.024120, 1.036620, -0.048600},
        {0, 0.020160, 1.036800, -0.039960}, {0, 0.023760, 1.041300, -0.055620},
        {0, 0.023040, 1.041660, -0.042480}, {0, 0.025920, 1.034640, -0.033480},
        {0, 0.024300, 1.035540, -0.043200}, {0, 0.024300, 1.036260, -0.042660},
        {0, 0.019980, 1.042380, -0.052920}, {0, 0.022320, 1.036800, -0.037800},
        {0, 0.024480, 1.036800, -0.040320}, {0, 0.023220, 1.035720, -0.052740},
        {0, 0.027720, 1.039860, -0.037080}, {0, 0.023400, 1.040220, -0.043740},
        {0, 0.020340, 1.034460, -0.045360}, {0, 0.018180, 1.037520, -0.036900},
        {0, 0.024480, 1.034100, -0.021960}, {0, 0.021060, 1.040580, -0.045900},
        {0, 0.025380, 1.040760, -0.032400}, {0, 0.024120, 1.039320, -0.032580},
        {0, 0.023400, 1.035720, -0.034740}, {0, 0.024480, 1.039860, -0.047700},
        {0, 0.028980, 1.032300, -0.032040}, {0, 0.025200, 1.038240, -0.027540},
    },
};
}  // namespace accData

}  // namespace Boardcore
