/* Copyright (c) 2021 Skyward Experimental Rocketry
 * Author: Luca Conterio
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

// This data is a stripped down version of LOG_6.dat file of the calibration
// repository.

#pragma once

#include <sensors/SensorData.h>

namespace Boardcore
{

namespace magnetoData
{
constexpr unsigned nSamples = 885;

MagnetometerData samples[nSamples]{
    {0, 0.038, 0.271, 0.015},   {0, 0.048, 0.252, 0.001},
    {0, 0.256, 0.388, -0.008},  {0, 0.438, 0.500, 0.110},
    {0, 0.113, 0.529, 0.068},   {0, -0.086, 0.551, 0.368},
    {0, 0.017, 0.601, 0.503},   {0, 0.201, 0.571, 0.593},
    {0, -0.065, 0.429, 0.609},  {0, -0.141, 0.443, 0.219},
    {0, 0.165, 0.487, 0.027},   {0, 0.481, 0.135, 0.666},
    {0, 0.357, 0.021, 0.701},   {0, 0.272, -0.041, 0.689},
    {0, 0.040, -0.021, 0.695},  {0, -0.121, 0.199, 0.120},
    {0, 0.003, 0.203, 0.020},   {0, -0.006, 0.226, 0.027},
    {0, -0.191, 0.234, 0.530},  {0, 0.560, 0.093, 0.568},
    {0, 0.636, 0.225, 0.213},   {0, 0.378, 0.597, 0.235},
    {0, 0.257, 0.643, 0.417},   {0, 0.220, 0.562, 0.601},
    {0, 0.380, 0.496, 0.608},   {0, 0.377, 0.451, 0.639},
    {0, 0.236, 0.425, 0.702},   {0, 0.038, 0.574, 0.189},
    {0, 0.169, 0.492, 0.050},   {0, 0.369, 0.419, 0.037},
    {0, 0.569, 0.316, 0.134},   {0, 0.543, -0.010, 0.509},
    {0, 0.361, -0.060, 0.656},  {0, 0.152, -0.045, 0.704},
    {0, -0.126, 0.058, 0.572},  {0, -0.100, 0.077, 0.614},
    {0, -0.156, 0.081, 0.519},  {0, -0.172, 0.164, 0.211},
    {0, -0.111, 0.182, 0.116},  {0, 0.049, 0.342, 0.018},
    {0, 0.363, 0.394, 0.020},   {0, 0.475, 0.356, 0.074},
    {0, 0.574, 0.319, 0.151},   {0, 0.182, 0.518, 0.051},
    {0, -0.055, 0.550, 0.214},  {0, -0.014, 0.588, 0.468},
    {0, 0.117, 0.650, 0.462},   {0, 0.019, 0.535, 0.094},
    {0, -0.095, 0.541, 0.197},  {0, -0.099, 0.557, 0.303},
    {0, -0.184, 0.444, 0.440},  {0, -0.208, 0.378, 0.402},
    {0, -0.117, 0.367, 0.143},  {0, 0.331, 0.400, 0.018},
    {0, 0.498, 0.440, 0.154},   {0, 0.410, 0.592, 0.347},
    {0, 0.261, 0.646, 0.285},   {0, 0.309, 0.629, 0.281},
    {0, 0.334, 0.632, 0.292},   {0, 0.311, 0.637, 0.307},
    {0, 0.260, 0.646, 0.267},   {0, 0.267, 0.621, 0.195},
    {0, 0.325, 0.574, 0.145},   {0, 0.645, 0.271, 0.285},
    {0, 0.651, 0.148, 0.433},   {0, 0.527, 0.043, 0.625},
    {0, 0.231, -0.049, 0.710},  {0, -0.075, 0.027, 0.651},
    {0, -0.163, 0.127, 0.594},  {0, -0.092, 0.103, 0.680},
    {0, 0.227, -0.063, 0.724},  {0, 0.632, 0.071, 0.362},
    {0, 0.606, 0.379, 0.419},   {0, 0.540, 0.467, 0.455},
    {0, 0.483, 0.503, 0.516},   {0, 0.405, 0.522, 0.573},
    {0, 0.403, 0.530, 0.558},   {0, 0.441, 0.501, 0.563},
    {0, 0.451, 0.451, 0.617},   {0, 0.597, 0.118, 0.494},
    {0, 0.599, 0.057, 0.438},   {0, 0.591, 0.046, 0.377},
    {0, 0.506, -0.030, 0.180},  {0, 0.426, 0.079, 0.038},
    {0, 0.332, 0.194, -0.029},  {0, 0.259, 0.412, -0.012},
    {0, 0.337, 0.304, -0.027},  {0, 0.457, -0.050, 0.136},
    {0, 0.454, -0.104, 0.544},  {0, 0.357, -0.003, 0.674},
    {0, 0.317, 0.125, 0.747},   {0, 0.228, 0.641, 0.476},
    {0, 0.235, 0.659, 0.338},   {0, 0.317, 0.619, 0.224},
    {0, 0.320, 0.547, 0.116},   {0, 0.313, 0.317, -0.034},
    {0, 0.315, 0.276, -0.045},  {0, 0.345, 0.182, -0.033},
    {0, 0.373, 0.064, 0.003},   {0, 0.417, -0.068, 0.096},
    {0, 0.417, -0.068, 0.096},  {0, 0.453, -0.122, 0.207},
    {0, 0.488, -0.119, 0.246},  {0, 0.570, 0.006, 0.196},
    {0, 0.612, 0.113, 0.172},   {0, 0.641, 0.179, 0.204},
    {0, 0.657, 0.235, 0.266},   {0, 0.631, 0.336, 0.280},
    {0, 0.625, 0.362, 0.284},   {0, 0.617, 0.385, 0.318},
    {0, 0.579, 0.439, 0.358},   {0, 0.506, 0.523, 0.396},
    {0, 0.497, 0.507, 0.448},   {0, 0.523, 0.469, 0.490},
    {0, 0.557, 0.333, 0.562},   {0, 0.604, 0.246, 0.501},
    {0, 0.621, 0.242, 0.465},   {0, 0.632, 0.191, 0.392},
    {0, 0.630, 0.146, 0.332},   {0, 0.590, 0.081, 0.237},
    {0, 0.526, 0.038, 0.144},   {0, 0.490, 0.015, 0.119},
    {0, 0.461, 0.003, 0.107},   {0, 0.342, 0.050, 0.030},
    {0, 0.331, 0.062, 0.014},   {0, 0.301, 0.086, -0.008},
    {0, 0.306, 0.083, 0.014},   {0, 0.564, -0.013, 0.331},
    {0, 0.559, -0.012, 0.444},  {0, 0.487, 0.049, 0.624},
    {0, 0.300, 0.198, 0.755},   {0, 0.224, 0.350, 0.752},
    {0, 0.197, 0.405, 0.730},   {0, 0.103, 0.583, 0.581},
    {0, 0.033, 0.630, 0.428},   {0, 0.068, 0.578, 0.161},
    {0, 0.220, 0.437, 0.016},   {0, 0.238, 0.381, -0.017},
    {0, 0.268, 0.278, -0.040},  {0, 0.301, 0.077, -0.008},
    {0, 0.345, 0.013, 0.040},   {0, 0.371, -0.031, 0.070},
    {0, 0.400, -0.083, 0.123},  {0, 0.514, -0.082, 0.208},
    {0, 0.532, -0.057, 0.201},  {0, 0.541, -0.040, 0.195},
    {0, 0.600, 0.035, 0.212},   {0, 0.621, 0.049, 0.236},
    {0, 0.637, 0.073, 0.270},   {0, 0.652, 0.114, 0.300},
    {0, 0.659, 0.141, 0.301},   {0, 0.649, 0.249, 0.336},
    {0, 0.626, 0.288, 0.441},   {0, 0.614, 0.246, 0.506},
    {0, 0.600, 0.221, 0.531},   {0, 0.541, 0.114, 0.604},
    {0, 0.541, 0.070, 0.587},   {0, 0.543, 0.032, 0.561},
    {0, 0.519, -0.056, 0.507},  {0, 0.461, -0.146, 0.293},
    {0, 0.435, -0.143, 0.197},  {0, 0.364, -0.119, 0.130},
    {0, 0.212, -0.056, 0.057},  {0, 0.150, -0.091, 0.101},
    {0, 0.109, -0.151, 0.195},  {0, 0.018, -0.166, 0.400},
    {0, 0.007, -0.155, 0.458},  {0, 0.122, -0.132, 0.635},
    {0, 0.263, -0.097, 0.676},  {0, 0.399, -0.050, 0.664},
    {0, 0.463, -0.005, 0.651},  {0, 0.502, 0.190, 0.668},
    {0, 0.482, 0.359, 0.632},   {0, 0.468, 0.423, 0.617},
    {0, 0.424, 0.482, 0.599},   {0, 0.326, 0.574, 0.552},
    {0, 0.223, 0.638, 0.478},   {0, 0.183, 0.653, 0.421},
    {0, 0.169, 0.627, 0.219},   {0, 0.323, 0.519, 0.095},
    {0, 0.408, 0.482, 0.107},   {0, 0.589, 0.396, 0.256},
    {0, 0.601, 0.403, 0.317},   {0, 0.585, 0.426, 0.421},
    {0, 0.543, 0.472, 0.239},   {0, 0.488, 0.473, 0.141},
    {0, 0.331, 0.446, 0.010},   {0, 0.052, 0.241, -0.021},
    {0, 0.008, 0.176, 0.010},   {0, -0.038, 0.117, 0.046},
    {0, -0.071, 0.033, 0.133},  {0, -0.088, -0.029, 0.193},
    {0, -0.040, -0.016, 0.120}, {0, 0.156, 0.058, -0.006},
    {0, 0.437, 0.191, 0.001},   {0, 0.578, 0.284, 0.142},
    {0, 0.621, 0.287, 0.223},   {0, 0.632, 0.269, 0.265},
    {0, 0.639, 0.241, 0.273},   {0, 0.626, 0.186, 0.235},
    {0, 0.611, 0.197, 0.201},   {0, 0.622, 0.206, 0.212},
    {0, 0.638, 0.228, 0.278},   {0, 0.629, 0.189, 0.426},
    {0, 0.605, 0.167, 0.487},   {0, 0.577, 0.128, 0.530},
    {0, 0.555, 0.094, 0.557},   {0, 0.458, -0.049, 0.568},
    {0, 0.469, -0.121, 0.429},  {0, 0.444, -0.142, 0.377},
    {0, 0.387, -0.171, 0.280},  {0, 0.365, -0.112, 0.135},
    {0, 0.307, -0.012, 0.030},  {0, 0.281, 0.112, -0.021},
    {0, 0.279, 0.141, -0.032},  {0, 0.301, 0.155, -0.026},
    {0, 0.505, 0.078, 0.097},   {0, 0.607, 0.026, 0.305},
    {0, 0.612, 0.015, 0.408},   {0, 0.322, 0.124, 0.755},
    {0, 0.269, 0.145, 0.768},   {0, 0.262, 0.175, 0.779},
    {0, 0.171, 0.239, 0.771},   {0, -0.073, 0.462, 0.609},
    {0, -0.116, 0.485, 0.540},  {0, -0.156, 0.489, 0.335},
    {0, -0.069, 0.460, 0.146},  {0, 0.091, 0.425, 0.030},
    {0, 0.149, 0.425, 0.019},   {0, 0.308, 0.431, 0.029},
    {0, 0.415, 0.430, 0.072},   {0, 0.537, 0.422, 0.193},
    {0, 0.575, 0.434, 0.332},   {0, 0.575, 0.434, 0.332},
    {0, 0.564, 0.449, 0.420},   {0, 0.538, 0.469, 0.452},
    {0, 0.527, 0.500, 0.397},   {0, 0.528, 0.502, 0.350},
    {0, 0.495, 0.510, 0.207},   {0, 0.263, 0.599, 0.169},
    {0, 0.251, 0.627, 0.226},   {0, 0.241, 0.625, 0.244},
    {0, 0.295, 0.610, 0.217},   {0, 0.222, 0.620, 0.182},
    {0, 0.168, 0.609, 0.158},   {0, 0.109, 0.589, 0.148},
    {0, 0.106, 0.594, 0.153},   {0, 0.148, 0.608, 0.153},
    {0, 0.129, 0.611, 0.141},   {0, 0.166, 0.597, 0.120},
    {0, 0.184, 0.588, 0.116},   {0, 0.345, 0.491, 0.059},
    {0, 0.376, 0.478, 0.067},   {0, 0.461, 0.481, 0.151},
    {0, 0.493, 0.490, 0.221},   {0, 0.470, 0.540, 0.401},
    {0, 0.454, 0.554, 0.421},   {0, 0.439, 0.553, 0.445},
    {0, 0.324, 0.603, 0.487},   {0, 0.242, 0.647, 0.359},
    {0, 0.242, 0.647, 0.359},   {0, 0.295, 0.622, 0.239},
    {0, 0.296, 0.621, 0.241},   {0, 0.281, 0.616, 0.199},
    {0, 0.292, 0.606, 0.208},   {0, 0.292, 0.606, 0.208},
    {0, 0.297, 0.563, 0.139},   {0, 0.342, 0.430, 0.021},
    {0, 0.418, 0.325, -0.002},  {0, 0.500, 0.240, 0.047},
    {0, 0.525, 0.205, 0.065},   {0, 0.652, 0.133, 0.310},
    {0, 0.655, 0.163, 0.364},   {0, 0.623, 0.223, 0.512},
    {0, 0.556, 0.285, 0.596},   {0, 0.455, 0.356, 0.674},
    {0, 0.384, 0.356, 0.716},   {0, 0.228, 0.384, 0.752},
    {0, 0.148, 0.387, 0.746},   {0, 0.003, 0.418, 0.696},
    {0, -0.159, 0.472, 0.490},  {0, -0.171, 0.488, 0.419},
    {0, -0.165, 0.482, 0.455},  {0, 0.007, 0.470, 0.679},
    {0, 0.096, 0.480, 0.709},   {0, 0.251, 0.473, 0.706},
    {0, 0.251, 0.473, 0.706},   {0, 0.540, 0.414, 0.529},
    {0, 0.563, 0.420, 0.485},   {0, 0.579, 0.440, 0.321},
    {0, 0.493, 0.461, 0.147},   {0, 0.441, 0.488, 0.122},
    {0, 0.436, 0.524, 0.173},   {0, 0.426, 0.548, 0.203},
    {0, 0.402, 0.573, 0.206},   {0, 0.380, 0.596, 0.253},
    {0, 0.348, 0.623, 0.317},   {0, 0.357, 0.620, 0.325},
    {0, 0.342, 0.629, 0.339},   {0, 0.406, 0.601, 0.366},
    {0, 0.441, 0.574, 0.367},   {0, 0.443, 0.570, 0.389},
    {0, 0.456, 0.556, 0.387},   {0, 0.471, 0.534, 0.450},
    {0, 0.487, 0.505, 0.482},   {0, 0.508, 0.476, 0.483},
    {0, 0.557, 0.405, 0.495},   {0, 0.610, 0.311, 0.448},
    {0, 0.632, 0.260, 0.428},   {0, 0.635, 0.150, 0.423},
    {0, 0.635, 0.150, 0.423},   {0, 0.601, 0.061, 0.482},
    {0, 0.568, 0.007, 0.484},   {0, 0.557, -0.014, 0.511},
    {0, 0.550, -0.031, 0.507},  {0, 0.555, -0.053, 0.480},
    {0, 0.552, -0.055, 0.464},  {0, 0.560, -0.033, 0.448},
    {0, 0.560, -0.033, 0.448},  {0, 0.541, -0.033, 0.213},
    {0, 0.541, -0.033, 0.213},  {0, 0.505, -0.007, 0.138},
    {0, 0.443, 0.054, 0.048},   {0, 0.408, 0.135, -0.002},
    {0, 0.370, 0.168, -0.026},  {0, 0.326, 0.221, -0.046},
    {0, 0.312, 0.249, -0.047},  {0, 0.305, 0.326, -0.037},
    {0, 0.279, 0.403, -0.015},  {0, 0.265, 0.444, 0.007},
    {0, 0.256, 0.485, 0.043},   {0, 0.259, 0.583, 0.140},
    {0, 0.253, 0.600, 0.160},   {0, 0.249, 0.617, 0.190},
    {0, 0.247, 0.630, 0.214},   {0, 0.255, 0.646, 0.274},
    {0, 0.278, 0.644, 0.274},   {0, 0.300, 0.634, 0.264},
    {0, 0.320, 0.621, 0.228},   {0, 0.358, 0.548, 0.143},
    {0, 0.441, 0.415, 0.077},   {0, 0.488, 0.345, 0.076},
    {0, 0.544, 0.262, 0.108},   {0, 0.623, 0.127, 0.255},
    {0, 0.600, 0.033, 0.440},   {0, 0.565, 0.025, 0.514},
    {0, 0.524, 0.021, 0.570},   {0, 0.354, 0.063, 0.722},
    {0, 0.273, 0.116, 0.748},   {0, 0.191, 0.182, 0.765},
    {0, 0.191, 0.182, 0.765},   {0, -0.029, 0.452, 0.639},
    {0, -0.029, 0.452, 0.639},  {0, -0.039, 0.513, 0.586},
    {0, -0.036, 0.596, 0.420},  {0, 0.073, 0.602, 0.191},
    {0, 0.073, 0.602, 0.191},   {0, 0.155, 0.539, 0.091},
    {0, 0.206, 0.492, 0.047},   {0, 0.306, 0.373, -0.009},
    {0, 0.381, 0.243, -0.017},  {0, 0.412, 0.183, 0.002},
    {0, 0.418, 0.137, 0.005},   {0, 0.431, 0.011, 0.055},
    {0, 0.438, -0.028, 0.079},  {0, 0.438, -0.052, 0.099},
    {0, 0.429, -0.069, 0.117},  {0, 0.430, -0.095, 0.123},
    {0, 0.423, -0.080, 0.109},  {0, 0.416, -0.044, 0.075},
    {0, 0.420, 0.041, 0.032},   {0, 0.429, 0.142, -0.004},
    {0, 0.430, 0.180, -0.007},  {0, 0.416, 0.257, -0.006},
    {0, 0.422, 0.279, 0.000},   {0, 0.424, 0.323, 0.015},
    {0, 0.416, 0.360, 0.028},   {0, 0.418, 0.459, 0.084},
    {0, 0.418, 0.459, 0.084},   {0, 0.425, 0.550, 0.199},
    {0, 0.421, 0.579, 0.260},   {0, 0.427, 0.583, 0.326},
    {0, 0.444, 0.574, 0.377},   {0, 0.502, 0.472, 0.523},
    {0, 0.525, 0.404, 0.574},   {0, 0.528, 0.345, 0.610},
    {0, 0.533, 0.253, 0.630},   {0, 0.530, 0.150, 0.623},
    {0, 0.544, 0.090, 0.602},   {0, 0.526, -0.006, 0.557},
    {0, 0.522, -0.042, 0.520},  {0, 0.510, -0.083, 0.414},
    {0, 0.472, -0.113, 0.282},  {0, 0.472, -0.113, 0.282},
    {0, 0.421, -0.104, 0.186},  {0, 0.398, -0.029, 0.072},
    {0, 0.413, 0.016, 0.046},   {0, 0.413, 0.016, 0.046},
    {0, 0.420, 0.108, 0.023},   {0, 0.379, 0.256, -0.008},
    {0, 0.362, 0.327, -0.001},  {0, 0.374, 0.383, 0.036},
    {0, 0.421, 0.456, 0.106},   {0, 0.450, 0.500, 0.191},
    {0, 0.452, 0.518, 0.220},   {0, 0.454, 0.539, 0.274},
    {0, 0.460, 0.547, 0.315},   {0, 0.459, 0.548, 0.387},
    {0, 0.434, 0.549, 0.455},   {0, 0.425, 0.540, 0.492},
    {0, 0.430, 0.516, 0.530},   {0, 0.354, 0.505, 0.617},
    {0, 0.354, 0.505, 0.617},   {0, 0.312, 0.535, 0.610},
    {0, 0.312, 0.535, 0.610},   {0, 0.267, 0.637, 0.411},
    {0, 0.265, 0.637, 0.300},   {0, 0.276, 0.613, 0.216},
    {0, 0.386, 0.456, 0.074},   {0, 0.446, 0.267, 0.030},
    {0, 0.460, 0.175, 0.030},   {0, 0.441, -0.006, 0.078},
    {0, 0.408, -0.086, 0.129},  {0, 0.336, -0.193, 0.268},
    {0, 0.238, -0.218, 0.374},  {0, 0.192, -0.220, 0.412},
    {0, 0.156, -0.200, 0.460},  {0, 0.099, -0.093, 0.645},
    {0, 0.073, -0.041, 0.690},  {0, 0.057, 0.027, 0.722},
    {0, 0.026, 0.096, 0.738},   {0, -0.071, 0.355, 0.665},
    {0, -0.073, 0.435, 0.617},  {0, -0.059, 0.511, 0.554},
    {0, -0.017, 0.564, 0.498},  {0, 0.164, 0.642, 0.313},
    {0, 0.225, 0.631, 0.261},   {0, 0.348, 0.582, 0.202},
    {0, 0.348, 0.582, 0.202},   {0, 0.460, 0.518, 0.205},
    {0, 0.553, 0.441, 0.235},   {0, 0.589, 0.405, 0.273},
    {0, 0.620, 0.365, 0.312},   {0, 0.621, 0.320, 0.466},
    {0, 0.617, 0.290, 0.516},   {0, 0.585, 0.256, 0.570},
    {0, 0.570, 0.231, 0.618},   {0, 0.555, 0.213, 0.609},
    {0, 0.597, 0.210, 0.537},   {0, 0.637, 0.217, 0.441},
    {0, 0.611, 0.296, 0.195},   {0, 0.483, 0.359, 0.061},
    {0, 0.483, 0.359, 0.061},   {0, 0.300, 0.412, -0.004},
    {0, 0.090, 0.419, 0.019},   {0, 0.010, 0.402, 0.038},
    {0, -0.093, 0.287, 0.071},  {0, -0.112, 0.221, 0.091},
    {0, -0.155, 0.079, 0.204},  {0, -0.161, 0.001, 0.341},
    {0, -0.149, -0.023, 0.409}, {0, -0.116, -0.044, 0.486},
    {0, -0.068, -0.043, 0.577}, {0, 0.057, 0.070, 0.742},
    {0, 0.078, 0.136, 0.764},   {0, 0.081, 0.210, 0.770},
    {0, 0.042, 0.366, 0.728},   {0, 0.024, 0.492, 0.650},
    {0, 0.014, 0.544, 0.597},   {0, 0.014, 0.610, 0.470},
    {0, 0.030, 0.629, 0.414},   {0, 0.059, 0.630, 0.260},
    {0, 0.162, 0.573, 0.131},   {0, 0.214, 0.549, 0.110},
    {0, 0.214, 0.549, 0.110},   {0, 0.376, 0.485, 0.098},
    {0, 0.436, 0.460, 0.117},   {0, 0.487, 0.433, 0.135},
    {0, 0.515, 0.408, 0.142},   {0, 0.581, 0.291, 0.161},
    {0, 0.599, 0.240, 0.160},   {0, 0.615, 0.192, 0.180},
    {0, 0.633, 0.098, 0.246},   {0, 0.619, 0.010, 0.389},
    {0, 0.619, 0.010, 0.389},   {0, 0.531, -0.096, 0.465},
    {0, 0.509, -0.119, 0.454},  {0, 0.467, -0.150, 0.458},
    {0, 0.442, -0.163, 0.461},  {0, 0.444, -0.170, 0.447},
    {0, 0.440, -0.175, 0.430},  {0, 0.388, -0.191, 0.488},
    {0, 0.364, -0.187, 0.505},  {0, 0.350, -0.199, 0.502},
    {0, 0.343, -0.200, 0.476},  {0, 0.331, -0.210, 0.425},
    {0, 0.333, -0.219, 0.411},  {0, 0.324, -0.225, 0.407},
    {0, 0.351, -0.216, 0.342},  {0, 0.403, -0.194, 0.304},
    {0, 0.419, -0.187, 0.289},  {0, 0.441, -0.160, 0.239},
    {0, 0.462, -0.151, 0.247},  {0, 0.510, -0.115, 0.245},
    {0, 0.515, -0.115, 0.242},  {0, 0.519, -0.113, 0.256},
    {0, 0.519, -0.113, 0.256},  {0, 0.537, -0.118, 0.371},
    {0, 0.524, -0.129, 0.423},  {0, 0.505, -0.136, 0.480},
    {0, 0.474, -0.130, 0.527},  {0, 0.380, -0.082, 0.666},
    {0, 0.336, -0.049, 0.704},  {0, 0.298, -0.023, 0.726},
    {0, 0.273, 0.010, 0.747},   {0, 0.275, 0.033, 0.754},
    {0, 0.275, 0.033, 0.754},   {0, 0.249, 0.063, 0.769},
    {0, 0.225, 0.091, 0.781},   {0, 0.301, 0.221, 0.779},
    {0, 0.333, 0.275, 0.768},   {0, 0.340, 0.337, 0.741},
    {0, 0.347, 0.377, 0.721},   {0, 0.347, 0.512, 0.631},
    {0, 0.355, 0.539, 0.588},   {0, 0.355, 0.570, 0.556},
    {0, 0.338, 0.596, 0.527},   {0, 0.300, 0.649, 0.404},
    {0, 0.273, 0.655, 0.356},   {0, 0.257, 0.660, 0.321},
    {0, 0.216, 0.654, 0.260},   {0, 0.209, 0.645, 0.222},
    {0, 0.185, 0.629, 0.182},   {0, 0.093, 0.570, 0.115},
    {0, 0.032, 0.532, 0.104},   {0, -0.079, 0.483, 0.140},
    {0, -0.139, 0.436, 0.191},  {0, -0.155, 0.423, 0.222},
    {0, -0.167, 0.416, 0.250},  {0, -0.211, 0.379, 0.380},
    {0, -0.211, 0.379, 0.380},  {0, -0.207, 0.380, 0.356},
    {0, -0.190, 0.386, 0.280},  {0, -0.004, 0.443, 0.072},
    {0, 0.141, 0.493, 0.062},   {0, 0.247, 0.536, 0.084},
    {0, 0.308, 0.564, 0.125},   {0, 0.354, 0.605, 0.206},
    {0, 0.356, 0.622, 0.279},   {0, 0.327, 0.632, 0.342},
    {0, 0.289, 0.647, 0.360},   {0, 0.282, 0.649, 0.357},
    {0, 0.290, 0.631, 0.198},   {0, 0.188, 0.581, 0.083},
    {0, 0.188, 0.581, 0.083},   {0, -0.084, 0.553, 0.235},
    {0, -0.093, 0.568, 0.323},  {0, -0.093, 0.568, 0.323},
    {0, -0.088, 0.575, 0.376},  {0, -0.072, 0.572, 0.434},
    {0, -0.093, 0.570, 0.378},  {0, -0.093, 0.570, 0.378},
    {0, -0.048, 0.558, 0.191},  {0, 0.059, 0.573, 0.146},
    {0, 0.190, 0.588, 0.146},   {0, 0.307, 0.634, 0.281},
    {0, 0.307, 0.634, 0.281},   {0, 0.253, 0.654, 0.372},
    {0, 0.208, 0.656, 0.395},   {0, 0.151, 0.659, 0.411},
    {0, 0.082, 0.649, 0.438},   {0, -0.058, 0.596, 0.446},
    {0, -0.110, 0.562, 0.425},  {0, -0.133, 0.543, 0.381},
    {0, -0.155, 0.520, 0.326},  {0, -0.153, 0.464, 0.219},
    {0, -0.143, 0.442, 0.179},  {0, -0.142, 0.417, 0.148},
    {0, -0.114, 0.373, 0.098},  {0, 0.009, 0.267, -0.004},
    {0, 0.062, 0.241, -0.029},  {0, 0.062, 0.233, -0.030},
    {0, 0.054, 0.233, -0.022},  {0, 0.056, 0.277, -0.016},
    {0, 0.075, 0.309, -0.024},  {0, 0.110, 0.348, -0.015},
    {0, 0.138, 0.377, -0.011},  {0, 0.186, 0.419, -0.002},
    {0, 0.200, 0.425, -0.003},  {0, 0.218, 0.421, -0.007},
    {0, 0.215, 0.410, -0.021},  {0, 0.231, 0.409, -0.011},
    {0, 0.253, 0.425, 0.001},   {0, 0.253, 0.425, 0.001},
    {0, 0.329, 0.437, 0.030},   {0, 0.376, 0.412, 0.036},
    {0, 0.408, 0.383, 0.033},   {0, 0.423, 0.316, 0.024},
    {0, 0.423, 0.316, 0.024},   {0, 0.355, 0.272, -0.025},
    {0, 0.295, 0.331, -0.014},  {0, 0.280, 0.365, -0.016},
    {0, 0.280, 0.365, -0.016},  {0, 0.205, 0.448, 0.020},
    {0, 0.205, 0.448, 0.020},   {0, 0.189, 0.452, 0.019},
    {0, 0.181, 0.432, 0.006},   {0, 0.212, 0.394, -0.016},
    {0, 0.218, 0.386, -0.017},  {0, 0.217, 0.346, -0.033},
    {0, 0.242, 0.299, -0.048},  {0, 0.234, 0.260, -0.055},
    {0, 0.221, 0.220, -0.047},  {0, 0.215, 0.193, -0.041},
    {0, 0.212, 0.164, -0.042},  {0, 0.249, 0.112, -0.028},
    {0, 0.355, 0.083, 0.012},   {0, 0.355, 0.083, 0.012},
    {0, 0.418, 0.056, 0.044},   {0, 0.513, 0.026, 0.123},
    {0, 0.541, 0.008, 0.180},   {0, 0.566, -0.013, 0.251},
    {0, 0.582, -0.023, 0.342},  {0, 0.513, -0.051, 0.528},
    {0, 0.460, -0.067, 0.573},  {0, 0.406, -0.071, 0.615},
    {0, 0.352, -0.072, 0.642},  {0, 0.201, -0.030, 0.693},
    {0, 0.142, 0.004, 0.717},   {0, 0.088, 0.045, 0.721},
    {0, 0.028, 0.091, 0.720},   {0, -0.036, 0.153, 0.717},
    {0, -0.052, 0.172, 0.711},  {0, -0.057, 0.180, 0.717},
    {0, -0.028, 0.177, 0.735},  {0, -0.088, 0.177, 0.675},
    {0, -0.129, 0.177, 0.641},  {0, -0.178, 0.200, 0.571},
    {0, -0.203, 0.237, 0.501},  {0, -0.225, 0.270, 0.407},
    {0, -0.225, 0.270, 0.407},  {0, -0.214, 0.296, 0.306},
    {0, -0.214, 0.296, 0.306},  {0, -0.181, 0.328, 0.216},
    {0, -0.123, 0.355, 0.156},  {0, -0.123, 0.355, 0.156},
    {0, -0.081, 0.394, 0.117},  {0, -0.047, 0.422, 0.100},
    {0, -0.006, 0.440, 0.083},  {0, -0.006, 0.440, 0.083},
    {0, -0.006, 0.440, 0.083},  {0, 0.031, 0.454, 0.066},
    {0, 0.063, 0.455, 0.049},   {0, 0.063, 0.455, 0.049},
    {0, 0.091, 0.467, 0.041},   {0, 0.108, 0.470, 0.045},
    {0, 0.108, 0.470, 0.045},   {0, 0.126, 0.472, 0.041},
    {0, 0.126, 0.472, 0.041},   {0, 0.154, 0.477, 0.043},
    {0, 0.154, 0.477, 0.043},   {0, 0.166, 0.476, 0.030},
    {0, 0.165, 0.458, 0.029},   {0, 0.165, 0.458, 0.029},
    {0, 0.141, 0.451, 0.029},   {0, 0.141, 0.451, 0.029},
    {0, 0.108, 0.458, 0.031},   {0, 0.089, 0.463, 0.038},
    {0, 0.089, 0.463, 0.038},   {0, 0.061, 0.477, 0.056},
    {0, 0.061, 0.477, 0.056},   {0, 0.035, 0.508, 0.094},
    {0, 0.025, 0.537, 0.126},   {0, 0.025, 0.537, 0.126},
    {0, 0.020, 0.570, 0.159},   {0, 0.030, 0.582, 0.184},
    {0, 0.030, 0.582, 0.184},   {0, 0.038, 0.592, 0.195},
    {0, 0.038, 0.592, 0.195},   {0, 0.051, 0.588, 0.182},
    {0, 0.051, 0.588, 0.182},   {0, 0.044, 0.586, 0.175},
    {0, 0.044, 0.586, 0.175},   {0, 0.039, 0.577, 0.170},
    {0, 0.039, 0.578, 0.158},   {0, 0.039, 0.578, 0.158},
    {0, 0.034, 0.561, 0.140},   {0, 0.046, 0.540, 0.106},
    {0, 0.046, 0.540, 0.106},   {0, 0.046, 0.540, 0.106},
    {0, 0.067, 0.528, 0.087},   {0, 0.076, 0.502, 0.059},
    {0, 0.076, 0.502, 0.059},   {0, 0.088, 0.482, 0.036},
    {0, 0.088, 0.482, 0.036},   {0, 0.117, 0.441, 0.016},
    {0, 0.189, 0.401, -0.009},  {0, 0.189, 0.401, -0.009},
    {0, 0.281, 0.357, -0.028},  {0, 0.397, 0.331, 0.010},
    {0, 0.397, 0.331, 0.010},   {0, 0.504, 0.293, 0.076},
    {0, 0.504, 0.293, 0.076},   {0, 0.592, 0.267, 0.173},
    {0, 0.637, 0.244, 0.291},   {0, 0.637, 0.244, 0.291},
    {0, 0.635, 0.237, 0.402},   {0, 0.612, 0.247, 0.485},
    {0, 0.612, 0.247, 0.485},   {0, 0.573, 0.266, 0.562},
    {0, 0.573, 0.266, 0.562},   {0, 0.497, 0.289, 0.645},
    {0, 0.382, 0.306, 0.729},   {0, 0.382, 0.306, 0.729},
    {0, 0.382, 0.306, 0.729},   {0, 0.135, 0.303, 0.770},
    {0, 0.135, 0.303, 0.770},   {0, 0.135, 0.303, 0.770},
    {0, 0.048, 0.300, 0.755},   {0, -0.020, 0.306, 0.728},
    {0, -0.053, 0.310, 0.715},  {0, -0.053, 0.310, 0.715},
    {0, -0.053, 0.310, 0.715},  {0, -0.089, 0.305, 0.682},
    {0, -0.134, 0.308, 0.631},  {0, -0.168, 0.318, 0.574},
    {0, -0.168, 0.318, 0.574},  {0, -0.194, 0.324, 0.528},
    {0, -0.207, 0.327, 0.473},  {0, -0.207, 0.327, 0.473},
    {0, -0.207, 0.327, 0.473},  {0, -0.206, 0.330, 0.434},
    {0, -0.205, 0.341, 0.403},  {0, -0.205, 0.341, 0.403},
    {0, -0.205, 0.358, 0.363},  {0, -0.202, 0.360, 0.338},
    {0, -0.202, 0.360, 0.338},  {0, -0.197, 0.363, 0.299},
    {0, -0.197, 0.363, 0.299},  {0, -0.190, 0.360, 0.253},
    {0, -0.190, 0.360, 0.253},  {0, -0.168, 0.347, 0.202},
    {0, -0.144, 0.338, 0.154},  {0, -0.103, 0.327, 0.109},
    {0, -0.103, 0.327, 0.109},  {0, -0.068, 0.308, 0.066},
    {0, -0.068, 0.308, 0.066},  {0, -0.032, 0.301, 0.040},
    {0, 0.006, 0.269, 0.017},   {0, 0.006, 0.269, 0.017},
    {0, 0.039, 0.234, 0.002},   {0, 0.074, 0.194, -0.017},
    {0, 0.074, 0.194, -0.017},  {0, 0.074, 0.194, -0.017},
    {0, 0.087, 0.148, -0.010},  {0, 0.094, 0.105, -0.005},
    {0, 0.110, 0.053, 0.008},   {0, 0.110, 0.053, 0.008},
    {0, 0.130, 0.014, 0.022},   {0, 0.160, -0.030, 0.039},
    {0, 0.160, -0.030, 0.039},  {0, 0.180, -0.067, 0.057},
    {0, 0.180, -0.067, 0.057},  {0, 0.197, -0.096, 0.083},
    {0, 0.206, -0.116, 0.107},  {0, 0.206, -0.116, 0.107},
    {0, 0.206, -0.116, 0.107},  {0, 0.259, -0.136, 0.131},
    {0, 0.259, -0.136, 0.131},  {0, 0.259, -0.136, 0.131},
    {0, 0.285, -0.143, 0.130},  {0, 0.323, -0.148, 0.148},
    {0, 0.339, -0.161, 0.163},  {0, 0.339, -0.161, 0.163},
    {0, 0.350, -0.177, 0.186},  {0, 0.350, -0.177, 0.186},
    {0, 0.347, -0.201, 0.225},  {0, 0.332, -0.216, 0.251},
    {0, 0.332, -0.216, 0.251},  {0, 0.320, -0.223, 0.284},
    {0, 0.310, -0.216, 0.310},  {0, 0.310, -0.216, 0.310},
    {0, 0.295, -0.220, 0.337},  {0, 0.295, -0.220, 0.337},
    {0, 0.291, -0.231, 0.348},  {0, 0.307, -0.235, 0.352},
    {0, 0.307, -0.235, 0.352},  {0, 0.308, -0.253, 0.363},
    {0, 0.291, -0.250, 0.363},  {0, 0.291, -0.250, 0.363},
    {0, 0.269, -0.251, 0.369},  {0, 0.269, -0.251, 0.369},
    {0, 0.228, -0.237, 0.362},  {0, 0.201, -0.238, 0.367},
    {0, 0.201, -0.238, 0.367},  {0, 0.183, -0.235, 0.343},
    {0, 0.161, -0.219, 0.313},  {0, 0.161, -0.219, 0.313},
    {0, 0.149, -0.208, 0.290},  {0, 0.151, -0.205, 0.273},
    {0, 0.151, -0.205, 0.273},  {0, 0.160, -0.213, 0.275},
    {0, 0.143, -0.220, 0.311},  {0, 0.143, -0.220, 0.311},
    {0, 0.143, -0.220, 0.311},  {0, 0.128, -0.222, 0.363},
    {0, 0.128, -0.222, 0.363},  {0, 0.116, -0.214, 0.430},
    {0, 0.116, -0.214, 0.430},  {0, 0.116, -0.214, 0.430},
    {0, 0.089, -0.188, 0.503},  {0, 0.089, -0.188, 0.503},
    {0, 0.057, -0.158, 0.560},  {0, 0.057, -0.158, 0.560},
    {0, 0.057, -0.158, 0.560},  {0, 0.023, -0.115, 0.611},
    {0, 0.023, -0.115, 0.611},  {0, 0.023, -0.115, 0.611},
    {0, 0.002, -0.066, 0.649},  {0, 0.002, -0.066, 0.649},
    {0, -0.009, -0.017, 0.672}, {0, -0.009, -0.017, 0.672},
    {0, -0.009, -0.017, 0.672}, {0, -0.016, 0.046, 0.708},
    {0, -0.016, 0.046, 0.708},  {0, -0.006, 0.120, 0.737},
    {0, -0.006, 0.120, 0.737},  {0, 0.019, 0.193, 0.760},
    {0, 0.019, 0.193, 0.760},   {0, 0.019, 0.193, 0.760},
    {0, 0.019, 0.193, 0.760},   {0, 0.046, 0.268, 0.766},
    {0, 0.046, 0.268, 0.766},   {0, 0.058, 0.334, 0.748},
    {0, 0.058, 0.334, 0.748},   {0, 0.034, 0.380, 0.726},
    {0, 0.034, 0.380, 0.726},   {0, 0.034, 0.380, 0.726},
    {0, 0.001, 0.411, 0.685},   {0, 0.001, 0.411, 0.685},
    {0, -0.047, 0.435, 0.657},  {0, -0.047, 0.435, 0.657},
    {0, -0.047, 0.435, 0.657},  {0, -0.073, 0.450, 0.612},
    {0, -0.073, 0.450, 0.612},  {0, -0.073, 0.450, 0.612},
    {0, -0.101, 0.459, 0.579},  {0, -0.101, 0.459, 0.579},
    {0, -0.129, 0.464, 0.529},  {0, -0.129, 0.464, 0.529},
    {0, -0.129, 0.464, 0.529},  {0, -0.155, 0.461, 0.475},
    {0, -0.155, 0.461, 0.475},  {0, -0.171, 0.459, 0.424},
    {0, -0.171, 0.459, 0.424},  {0, -0.171, 0.459, 0.424},
    {0, -0.187, 0.449, 0.347},  {0, -0.187, 0.449, 0.347},
    {0, -0.178, 0.438, 0.289},  {0, -0.178, 0.438, 0.289},
    {0, -0.151, 0.418, 0.218},  {0, -0.151, 0.418, 0.218},
    {0, -0.151, 0.418, 0.218},  {0, -0.112, 0.383, 0.131},
    {0, -0.112, 0.383, 0.131},  {0, -0.112, 0.383, 0.131},
    {0, -0.044, 0.351, 0.057},  {0, -0.044, 0.351, 0.057},
    {0, 0.034, 0.304, 0.012},   {0, 0.034, 0.304, 0.012},
    {0, 0.034, 0.304, 0.012},   {0, 0.119, 0.270, -0.016},
    {0, 0.119, 0.270, -0.016},  {0, 0.200, 0.235, -0.032},
    {0, 0.200, 0.235, -0.032},  {0, 0.264, 0.217, -0.025},
    {0, 0.264, 0.217, -0.025},  {0, 0.264, 0.217, -0.025},
    {0, 0.264, 0.217, -0.025},  {0, 0.308, 0.186, -0.018},
    {0, 0.308, 0.186, -0.018},  {0, 0.349, 0.171, -0.012},
    {0, 0.349, 0.171, -0.012},  {0, 0.361, 0.165, 0.001},
    {0, 0.361, 0.165, 0.001}};
}  // namespace magnetoData

}  // namespace Boardcore
